{
    'name': 'Real Estate Theme',
    'description': 'Real Estate Theme - Houses, Appartments, Real Estate Agencies',
    'category': 'Theme/Services',
    'summary': 'Real Estate, Agencies, Construction, Services, Accomodations, Lodging, Hosting, Houses, Appartments, Vacations, Holidays, Travels',
    'sequence': 320,
    'version': '2.0.0',
    'depends': ['theme_common'],
    'data': [
        'data/generate_primary_template.xml',
        'data/ir_asset.xml',
        'views/images.xml',

        'views/snippets/s_cta_box.xml',
        'views/snippets/s_banner.xml',
        'views/snippets/s_cover.xml',
        'views/snippets/s_picture.xml',
        'views/snippets/s_cards_grid.xml',
        'views/snippets/s_striped_top.xml',
        'views/snippets/s_card_offset.xml',
        'views/snippets/s_image_text.xml',
        'views/snippets/s_image_title.xml',
        'views/snippets/s_images_mosaic.xml',
        'views/snippets/s_text_image.xml',
        'views/snippets/s_sidegrid.xml',
        'views/snippets/s_three_columns.xml',
        'views/snippets/s_quotes_carousel.xml',
        'views/snippets/s_quotes_carousel_minimal.xml',
        'views/snippets/s_freegrid.xml',
        'views/snippets/s_company_team_grid.xml',
        'views/snippets/s_text_block.xml',
        'views/snippets/s_features_wall.xml',
        'views/snippets/s_masonry_block.xml',
        'views/snippets/s_numbers.xml',
        'views/snippets/s_references.xml',
        'views/snippets/s_title.xml',
        'views/snippets/s_image_gallery.xml',
        'views/snippets/s_striped_center_top.xml',
        'views/snippets/s_call_to_action.xml',
        'views/snippets/s_quadrant.xml',
        'views/snippets/s_unveil.xml',
        'views/snippets/s_key_benefits.xml',
        'views/snippets/s_carousel.xml',
        'views/snippets/s_carousel_intro.xml',
        'views/snippets/s_pricelist_boxed.xml',
        'views/snippets/s_key_images.xml',
        'views/snippets/s_intro_pill.xml',
        'views/snippets/s_big_number.xml',
        'views/snippets/s_wavy_grid.xml',
        'views/snippets/s_shape_image.xml',
        'views/snippets/s_images_constellation.xml',
        'views/snippets/s_empowerment.xml',
        'views/snippets/s_numbers_boxed.xml',
        'views/snippets/s_split_intro.xml',
        'views/snippets/s_numbers_framed.xml',
        'views/new_page_template.xml',
    ],
    'images': [
        'static/description/real_estate_description.png',
        'static/description/real_estate_screenshot.webp',
    ],
    'images_preview_theme': {
        'website.s_cover_default_image': '/theme_real_estate/static/src/img/snippets/s_cover.webp',
        'website.s_text_image_default_image': '/theme_real_estate/static/src/img/snippets/s_text_image.webp',
        'website.s_image_text_default_image': '/theme_real_estate/static/src/img/snippets/s_image_text.webp',
        'website.s_three_columns_default_image_1': '/theme_real_estate/static/src/img/snippets/library_image_11.webp',
        'website.s_three_columns_default_image_2': '/theme_real_estate/static/src/img/snippets/library_image_13.webp',
        'website.s_three_columns_default_image_3': '/theme_real_estate/static/src/img/snippets/library_image_07.webp',
        'website.s_quotes_carousel_demo_image_0': '/theme_real_estate/static/src/img/snippets/s_quotes_carousel_1.webp',
    },
    'configurator_snippets': {
        'homepage': ['s_cover', 's_text_image', 's_image_text', 's_three_columns', 's_title', 's_references', 's_numbers_showcase', 's_quotes_carousel', 's_call_to_action'],
    },
    'configurator_snippets_addons': {
        'website_sale': {
            'homepage': [
                ('website_sale.s_dynamic_snippet_category_list', 'after', 's_cover'),
            ],
        },
    },
    'theme_customizations': {
        'website_sale.s_dynamic_snippet_category_list': {
            'data_attributes': {
                'gap': '4',
                'rounded': '0',
                'size': 'small',
                'alignment': 'left',
            },
            'background': {
                'color': 'o_cc2',
            },
            'add_classes': [
                'pt96', 'pb96',
                {
                    's_dynamic_snippet_title': 'd-none',
                },
            ],
            'remove_classes': [
                'pt64', 'pb64',
            ],
        },
    },
    'new_page_templates': {
        'about': {
            'personal': ['s_text_cover', 's_image_text', 's_text_block_h2', 's_numbers', 's_features', 's_call_to_action'],
        },
    },
    'author': 'Odoo S.A.',
    'license': 'LGPL-3',
    'live_test_url': 'https://theme-real-estate.odoo.com',
    'assets': {
        'website.assets_editor': [
            'theme_real_estate/static/src/js/tour.js',
        ],
    }
}
