/** @odoo-module **/

import {
    afterNextRender,
    start,
    startServer,
} from '@mail/../tests/helpers/test_utils';

QUnit.module('im_livechat', {}, function () {
QUnit.module('components', {}, function () {
QUnit.module('thread_icon_tests.js');

QUnit.test('livechat: public website visitor is typing', async function (assert) {
    assert.expect(4);

    const pyEnv = await startServer();
    const mailChannelId1 = pyEnv['mail.channel'].create({
        anonymous_name: "Visitor 20",
        channel_member_ids: [
            [0, 0, { partner_id: pyEnv.currentPartnerId }],
            [0, 0, { partner_id: pyEnv.publicPartnerId }],
        ],
        channel_type: 'livechat',
        livechat_operator_id: pyEnv.currentPartnerId,
    });
    const { messaging, openDiscuss } = await start({
        discuss: {
            context: { active_id: mailChannelId1 },
        },
    });
    await openDiscuss();
    assert.containsOnce(
        document.body,
        '.o_ThreadViewTopbar .o_ThreadIconView',
        "should have thread icon"
    );
    assert.containsOnce(
        document.body,
        '.o_ThreadIconView .fa.fa-comments',
        "should have default livechat icon"
    );

    const mailChannel1 = pyEnv['mail.channel'].searchRead([['id', '=', mailChannelId1]])[0];
    // simulate receive typing notification from livechat visitor "is typing"
    await afterNextRender(() => messaging.rpc({
        route: '/im_livechat/notify_typing',
        params: {
            context: {
                mockedPartnerId: pyEnv.publicPartnerId,
            },
            is_typing: true,
            uuid: mailChannel1.uuid,
        },
    }));
    assert.containsOnce(
        document.body,
        '.o_ThreadIconView_typing',
        "should have thread icon with visitor currently typing"
    );
    assert.strictEqual(
        document.querySelector('.o_ThreadIconView_typing').title,
        "Visitor 20 is typing...",
        "title of icon should tell visitor is currently typing"
    );
});

});
});
