# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo.tests import tagged

from odoo.addons.base.tests.common import HttpCaseWithUserDemo, HttpCaseWithUserPortal


@tagged('post_install', '-at_install')
class TestUi(HttpCaseWithUserDemo, HttpCaseWithUserPortal):

    @classmethod
    def setUpClass(cls):
        super().setUpClass()
        # be sure some expected values are set otherwise homepage may fail
        cls.partner_portal.write({
            "city": "Bayonne",
            "country_id": cls.env.ref("base.us").id,
            "phone": "(683)-556-5104",
            "street": "858 Lynn Street",
            "zip": "07002",
            "state_id": cls.env.ref("base.state_us_5").id,
        })
        if 'enforce_cities' in cls.env['res.country']._fields:
            cls.env.company.country_id.enforce_cities = False

    def test_01_portal_load_tour(self):
        self.start_tour("/", 'portal_load_homepage', login="portal")

    def test_02_portal_load_tour_cant_edit_vat(self):
        willis = self.user_portal
        self.start_tour("/", 'portal_load_homepage', login="portal")
        self.assertEqual(willis.phone, "+1 555 666 7788")

    def test_03_skip_to_content(self):
        self.start_tour("/", "skip_to_content", login="portal")
