// @odoo-module ignore
// Transpiled AOT with https://github.com/rrahir/spreadsheet-tools
/**
 * This file is generated by o-spreadsheet build tools. Do not edit it.
 * @see https://github.com/odoo/o-spreadsheet
 * @version 19.1.0-alpha.6
 * @date 2025-10-16T17:41:59.850Z
 * @hash 8ab685e0c
 */
odoo.define('@spreadsheet/o_spreadsheet/o_spreadsheet', ['@odoo/owl'], function (require) {
'use strict';
let __exports = {};

const { useEnv, useSubEnv, onWillUnmount, useComponent, status, Component, useRef, onMounted, useEffect, App, blockDom, useState, onPatched, useExternalListener, onWillUpdateProps, onWillStart, onWillPatch, xml, useChildSubEnv, markRaw, toRaw } = require('@odoo/owl');

const CANVAS_SHIFT = 0.5;
// Colors
const HIGHLIGHT_COLOR = "#017E84";
const BACKGROUND_HEADER_COLOR = "#F8F9FA";
const BACKGROUND_HEADER_SELECTED_COLOR = "#E8EAED";
const BACKGROUND_HEADER_ACTIVE_COLOR = "#595959";
const TEXT_HEADER_COLOR = "#666666";
const SELECTION_BORDER_COLOR = "#3266ca";
const HEADER_BORDER_COLOR = "#C0C0C0";
const CELL_BORDER_COLOR = "#E2E3E3";
const BACKGROUND_CHART_COLOR = "#FFFFFF";
const DEFAULT_COLOR_SCALE_MIDPOINT_COLOR = 0xb6d7a8;
const LINK_COLOR = HIGHLIGHT_COLOR;
const FILTERS_COLOR = "#188038";
const FROZEN_PANE_HEADER_BORDER_COLOR = "#BCBCBC";
const FROZEN_PANE_BORDER_COLOR = "#DADFE8";
const COMPOSER_ASSISTANT_COLOR = "#9B359B";
const COLOR_TRANSPARENT = "#00000000";
const TABLE_HOVER_BACKGROUND_COLOR = "#017E8414";
const CHART_WATERFALL_POSITIVE_COLOR = "#4EA7F2";
const CHART_WATERFALL_NEGATIVE_COLOR = "#EA6175";
const CHART_WATERFALL_SUBTOTAL_COLOR = "#AAAAAA";
const GRAY_900 = "#111827";
const GRAY_300 = "#D8DADD";
const GRAY_200 = "#E7E9ED";
const TEXT_BODY = "#374151";
const TEXT_BODY_MUTED = TEXT_BODY + "C2";
const ACTION_COLOR = HIGHLIGHT_COLOR;
const CHART_PADDING = 20;
const CHART_PADDING_BOTTOM = 10;
const CHART_PADDING_TOP = 15;
const CHART_TITLE_FONT_SIZE = 16;
const CHART_AXIS_TITLE_FONT_SIZE = 12;
const MASTER_CHART_HEIGHT = 60;
const SCORECARD_CHART_TITLE_FONT_SIZE = 14;
const PIVOT_TOKEN_COLOR = "#F28C28";
// Color picker defaults as upper case HEX to match `toHex`helper
const COLOR_PICKER_DEFAULTS = [
    "#000000",
    "#434343",
    "#666666",
    "#999999",
    "#B7B7B7",
    "#CCCCCC",
    "#D9D9D9",
    "#EFEFEF",
    "#F3F3F3",
    "#FFFFFF",
    "#980000",
    "#FF0000",
    "#FF9900",
    "#FFFF00",
    "#00FF00",
    "#00FFFF",
    "#4A86E8",
    "#0000FF",
    "#9900FF",
    "#FF00FF",
    "#E6B8AF",
    "#F4CCCC",
    "#FCE5CD",
    "#FFF2CC",
    "#D9EAD3",
    "#D0E0E3",
    "#C9DAF8",
    "#CFE2F3",
    "#D9D2E9",
    "#EAD1DC",
    "#DD7E6B",
    "#EA9999",
    "#F9CB9C",
    "#FFE599",
    "#B6D7A8",
    "#A2C4C9",
    "#A4C2F4",
    "#9FC5E8",
    "#B4A7D6",
    "#D5A6BD",
    "#CC4125",
    "#E06666",
    "#F6B26B",
    "#FFD966",
    "#93C47D",
    "#76A5AF",
    "#6D9EEB",
    "#6FA8DC",
    "#8E7CC3",
    "#C27BA0",
    "#A61C00",
    "#CC0000",
    "#E69138",
    "#F1C232",
    "#6AA84F",
    "#45818E",
    "#3C78D8",
    "#3D85C6",
    "#674EA7",
    "#A64D79",
    "#85200C",
    "#990000",
    "#B45F06",
    "#BF9000",
    "#38761D",
    "#134F5C",
    "#1155CC",
    "#0B5394",
    "#351C75",
    "#741B47",
    "#5B0F00",
    "#660000",
    "#783F04",
    "#7F6000",
    "#274E13",
    "#0C343D",
    "#1C4587",
    "#073763",
    "#20124D",
    "#4C1130",
];
// Dimensions
const MIN_ROW_HEIGHT = 10;
const MIN_COL_WIDTH = 5;
const HEADER_HEIGHT = 26;
const HEADER_WIDTH = 48;
const DESKTOP_TOPBAR_TOOLBAR_HEIGHT = 34;
const DESKTOP_BOTTOMBAR_HEIGHT = 36;
const DEFAULT_CELL_WIDTH = 96;
const DEFAULT_CELL_HEIGHT = 23;
const SCROLLBAR_WIDTH = 15;
const AUTOFILL_EDGE_LENGTH = 8;
const ICON_EDGE_LENGTH = 18;
const MIN_CF_ICON_MARGIN = 4;
const MIN_CELL_TEXT_MARGIN = 4;
const PADDING_AUTORESIZE_VERTICAL = 3;
const PADDING_AUTORESIZE_HORIZONTAL = MIN_CELL_TEXT_MARGIN;
const GROUP_LAYER_WIDTH = 21;
const GRID_ICON_MARGIN = 2;
const GRID_ICON_EDGE_LENGTH = 17;
const FOOTER_HEIGHT = 2 * DEFAULT_CELL_HEIGHT;
const DATA_VALIDATION_CHIP_MARGIN = 5;
// 768px is a common breakpoint for small screens
// Typically inside Odoo, it is the threshold for switching to mobile view
const MOBILE_WIDTH_BREAKPOINT = 768;
// Menus
const MENU_WIDTH = 250;
const MENU_VERTICAL_PADDING = 6;
const DESKTOP_MENU_ITEM_HEIGHT = 26;
// Style
const DEFAULT_STYLE = {
    align: "left",
    verticalAlign: "bottom",
    wrapping: "overflow",
    bold: false,
    italic: false,
    strikethrough: false,
    underline: false,
    fontSize: 10,
    fillColor: "",
    textColor: "",
};
const DEFAULT_VERTICAL_ALIGN = DEFAULT_STYLE.verticalAlign;
const DEFAULT_WRAPPING_MODE = DEFAULT_STYLE.wrapping;
// Fonts
const DEFAULT_FONT_WEIGHT = "400";
const DEFAULT_FONT_SIZE = DEFAULT_STYLE.fontSize;
const HEADER_FONT_SIZE = 11;
const DEFAULT_FONT = "'Roboto', arial";
// Borders
const DEFAULT_BORDER_DESC = { style: "thin", color: "#000000" };
// Max Number of history steps kept in memory
const MAX_HISTORY_STEPS = 99;
// Id of the first revision
const DEFAULT_REVISION_ID = "START_REVISION";
// Figure
const DEFAULT_FIGURE_HEIGHT = 335;
const DEFAULT_FIGURE_WIDTH = 536;
const FIGURE_BORDER_WIDTH = 1;
const MIN_FIG_SIZE = 80;
// Chart
const MAX_CHAR_LABEL = 20;
const FIGURE_ID_SPLITTER = "??";
const DEFAULT_GAUGE_LOWER_COLOR = "#EA6175";
const DEFAULT_GAUGE_MIDDLE_COLOR = "#FFD86D";
const DEFAULT_GAUGE_UPPER_COLOR = "#43C5B1";
const DEFAULT_SCORECARD_BASELINE_MODE = "difference";
const DEFAULT_SCORECARD_BASELINE_COLOR_UP = "#43C5B1";
const DEFAULT_SCORECARD_BASELINE_COLOR_DOWN = "#EA6175";
const DEFAULT_SCORECARD_KEY_VALUE_FONT_SIZE = 32;
const DEFAULT_SCORECARD_BASELINE_FONT_SIZE = 16;
const LINE_FILL_TRANSPARENCY = 0.4;
const LINE_DATA_POINT_RADIUS = 3;
const DEFAULT_WINDOW_SIZE = 2;
// session
const DEBOUNCE_TIME = 200;
const MESSAGE_VERSION = 1;
// Sheets
const FORBIDDEN_SHEETNAME_CHARS = ["'", "*", "?", "/", "\\", "[", "]"];
const FORBIDDEN_SHEETNAME_CHARS_IN_EXCEL_REGEX = /'|\*|\?|\/|\\|\[|\]/;
// Cells
const FORMULA_REF_IDENTIFIER = "|";
let DEFAULT_SHEETVIEW_SIZE = 0;
function getDefaultSheetViewSize() {
    return DEFAULT_SHEETVIEW_SIZE;
}
function setDefaultSheetViewSize(size) {
    DEFAULT_SHEETVIEW_SIZE = size;
}
const MAXIMAL_FREEZABLE_RATIO = 0.85;
const NEWLINE = "\n";
const FONT_SIZES = [6, 7, 8, 9, 10, 11, 12, 14, 18, 24, 36];
// Pivot
const PIVOT_TABLE_CONFIG = {
    hasFilters: false,
    totalRow: false,
    firstColumn: true,
    lastColumn: false,
    numberOfHeaders: 1,
    bandedRows: true,
    bandedColumns: false,
    styleId: "TableStyleMedium5",
    automaticAutofill: false,
};
const PIVOT_INDENT = 15;
const PIVOT_COLLAPSE_ICON_SIZE = 12;
const PIVOT_MAX_NUMBER_OF_CELLS = 1e5;
const DEFAULT_CURRENCY = {
    symbol: "$",
    position: "before",
    decimalPlaces: 2,
    code: "",
    name: "Dollar",
};
const DEFAULT_CAROUSEL_TITLE_STYLE = {
    fontSize: CHART_TITLE_FONT_SIZE,
    color: TEXT_BODY,
};
const DEFAULT_TOKEN_COLOR = "#000000";
const functionColor = DEFAULT_TOKEN_COLOR;
const operatorColor = "#3da4ab";
const tokenColors = {
    OPERATOR: operatorColor,
    NUMBER: "#02c39a",
    STRING: "#00a82d",
    FUNCTION: functionColor,
    DEBUGGER: operatorColor,
    LEFT_PAREN: functionColor,
    RIGHT_PAREN: functionColor,
    ARG_SEPARATOR: functionColor,
    ORPHAN_RIGHT_PAREN: "#ff0000",
};
const DRAG_THRESHOLD = 5; // in pixels, to avoid unwanted drag when clicking

//------------------------------------------------------------------------------
// Miscellaneous
//------------------------------------------------------------------------------
const sanitizeSheetNameRegex = new RegExp(FORBIDDEN_SHEETNAME_CHARS_IN_EXCEL_REGEX, "g");
function isCloneable$1(obj) {
    return "clone" in obj && obj.clone instanceof Function;
}
/**
 * Escapes a string to use as a literal string in a RegExp.
 * @url https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Escaping
 */
function escapeRegExp$1(str) {
    return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
/**
 * Deep copy arrays, plain objects and primitive values.
 * Throws an error for other types such as class instances.
 * Sparse arrays remain sparse.
 */
function deepCopy$1(obj) {
    switch (typeof obj) {
        case "object": {
            if (obj === null) {
                return obj;
            }
            else if (isCloneable$1(obj)) {
                return obj.clone();
            }
            else if (!(isPlainObject$1(obj) || obj instanceof Array)) {
                throw new Error("Unsupported type: only objects and arrays are supported");
            }
            const result = Array.isArray(obj) ? new Array(obj.length) : {};
            if (Array.isArray(obj)) {
                for (let i = 0, len = obj.length; i < len; i++) {
                    if (i in obj) {
                        result[i] = deepCopy$1(obj[i]);
                    }
                }
            }
            else {
                for (const key in obj) {
                    result[key] = deepCopy$1(obj[key]);
                }
            }
            return result;
        }
        case "number":
        case "string":
        case "boolean":
        case "function":
        case "undefined":
            return obj;
        default:
            throw new Error(`Unsupported type: ${typeof obj}`);
    }
}
/**
 * Check if the object is a plain old javascript object.
 */
function isPlainObject$1(obj) {
    return (typeof obj === "object" &&
        obj !== null &&
        // obj.constructor can be undefined when there's no prototype (`Object.create(null, {})`)
        (obj?.constructor === Object || obj?.constructor === undefined));
}
/**
 * Sanitize the name of a sheet, by eventually removing quotes.
 */
function getUnquotedSheetName(sheetName) {
    return unquote(sheetName, "'");
}
/**
 * Remove quotes from a quoted string.
 */
function unquote(string, quoteChar = '"') {
    if (string.startsWith(quoteChar)) {
        string = string.slice(1);
    }
    if (string.endsWith(quoteChar)) {
        string = string.slice(0, -1);
    }
    return string;
}
/**
 * Add quotes around the sheet name or any symbol name if it contains at least one non alphanumeric character.
 */
function getCanonicalSymbolName(symbolName) {
    if (symbolName.match(/\w/g)?.length !== symbolName.length) {
        symbolName = `'${symbolName}'`;
    }
    return symbolName;
}
/** Replace the excel-excluded characters of a sheetName */
function sanitizeSheetName(sheetName, replacementChar = " ") {
    return sheetName.replace(sanitizeSheetNameRegex, replacementChar);
}
function clip(val, min, max) {
    return val < min ? min : val > max ? max : val;
}
/**
 * Create a range from start (included) to end (excluded).
 * range(10, 13) => [10, 11, 12]
 * range(2, 8, 2) => [2, 4, 6]
 */
function range$1(start, end, step = 1) {
    if (end <= start && step > 0) {
        return [];
    }
    if (step === 0) {
        throw new Error("range() step must not be zero");
    }
    const length = Math.ceil(Math.abs((end - start) / step));
    const array = Array(length);
    for (let i = 0; i < length; i++) {
        array[i] = start + i * step;
    }
    return array;
}
/**
 * Groups consecutive numbers.
 * The input array is assumed to be sorted
 * @param numbers
 */
function groupConsecutive$1(numbers) {
    return numbers.reduce((groups, currentRow, index, rows) => {
        if (Math.abs(currentRow - rows[index - 1]) === 1) {
            const lastGroup = groups[groups.length - 1];
            lastGroup.push(currentRow);
        }
        else {
            groups.push([currentRow]);
        }
        return groups;
    }, []);
}
/**
 * Create one generator from two generators by linking
 * each item of the first generator to the next item of
 * the second generator.
 *
 * Let's say generator G1 yields A, B, C and generator G2 yields X, Y, Z.
 * The resulting generator of `linkNext(G1, G2)` will yield A', B', C'
 * where `A' = A & {next: Y}`, `B' = B & {next: Z}` and `C' = C & {next: undefined}`
 * @param generator
 * @param nextGenerator
 */
function* linkNext(generator, nextGenerator) {
    nextGenerator.next();
    for (const item of generator) {
        const nextItem = nextGenerator.next();
        yield {
            ...item,
            next: nextItem.done ? undefined : nextItem.value,
        };
    }
}
function isBoolean(str) {
    const upperCased = str.toUpperCase();
    return upperCased === "TRUE" || upperCased === "FALSE";
}
const MARKDOWN_LINK_REGEX = /^\[(.+)\]\((.+)\)$/;
//link must start with http or https
//https://stackoverflow.com/a/3809435/4760614
const WEB_LINK_REGEX = /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,4}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)$/;
function isMarkdownLink(str) {
    return MARKDOWN_LINK_REGEX.test(str);
}
/**
 * Check if the string is a web link.
 * e.g. http://odoo.com
 */
function isWebLink(str) {
    return WEB_LINK_REGEX.test(str);
}
/**
 * Build a markdown link from a label and an url
 */
function markdownLink(label, url) {
    return `[${label}](${url})`;
}
function parseMarkdownLink(str) {
    const matches = str.match(MARKDOWN_LINK_REGEX) || [];
    const label = matches[1];
    const url = matches[2];
    if (!label || !url) {
        throw new Error(`Could not parse markdown link ${str}.`);
    }
    return {
        label,
        url,
    };
}
const O_SPREADSHEET_LINK_PREFIX = "o-spreadsheet://";
function isSheetUrl(url) {
    return url.startsWith(O_SPREADSHEET_LINK_PREFIX);
}
function buildSheetLink(sheetId) {
    return `${O_SPREADSHEET_LINK_PREFIX}${sheetId}`;
}
/**
 * Parse a sheet link and return the sheet id
 */
function parseSheetUrl(sheetLink) {
    if (sheetLink.startsWith(O_SPREADSHEET_LINK_PREFIX)) {
        return sheetLink.slice(O_SPREADSHEET_LINK_PREFIX.length);
    }
    throw new Error(`${sheetLink} is not a valid sheet link`);
}
/**
 * This helper function can be used as a type guard when filtering arrays.
 * const foo: number[] = [1, 2, undefined, 4].filter(isDefined)
 */
function isDefined$1(argument) {
    return argument !== undefined;
}
/**
 * Check if all the values of an object, and all the values of the objects inside of it, are undefined.
 */
function isObjectEmptyRecursive(argument) {
    if (argument === undefined)
        return true;
    return Object.values(argument).every((value) => typeof value === "object" ? isObjectEmptyRecursive(value) : !value);
}
/**
 * Returns a function, that, as long as it continues to be invoked, will not
 * be triggered. The function will be called after it stops being called for
 * N milliseconds. If `immediate` is passed, trigger the function on the
 * leading edge, instead of the trailing.
 *
 * Also decorate the argument function with two methods: stopDebounce and isDebouncePending.
 *
 * Inspired by https://davidwalsh.name/javascript-debounce-function
 */
function debounce(func, wait, immediate) {
    let timeout = undefined;
    const debounced = function () {
        const context = this;
        const args = Array.from(arguments);
        function later() {
            timeout = undefined;
            if (!immediate) {
                func.apply(context, args);
            }
        }
        const callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow) {
            func.apply(context, args);
        }
    };
    debounced.isDebouncePending = () => timeout !== undefined;
    debounced.stopDebounce = () => {
        clearTimeout(timeout);
    };
    return debounced;
}
/**
 * Creates a batched version of a callback so that all calls to it in the same
 * microtick will only call the original callback once.
 *
 * @param callback the callback to batch
 * @returns a batched version of the original callback
 *
 * Copied from odoo/owl repo.
 */
function batched(callback) {
    let scheduled = false;
    return async (...args) => {
        if (!scheduled) {
            scheduled = true;
            await Promise.resolve();
            scheduled = false;
            callback(...args);
        }
    };
}
/*
 * Concatenate an array of strings.
 */
function concat$1(chars) {
    // ~40% faster than chars.join("")
    let output = "";
    for (let i = 0, len = chars.length; i < len; i++) {
        output += chars[i];
    }
    return output;
}
/**
 * Lazy value computed by the provided function.
 */
function lazy(fn) {
    let isMemoized = false;
    let memo;
    const lazyValue = () => {
        if (!isMemoized) {
            memo = fn instanceof Function ? fn() : fn;
            isMemoized = true;
        }
        return memo;
    };
    lazyValue.map = (callback) => lazy(() => callback(lazyValue()));
    return lazyValue;
}
/**
 * Find the next defined value after the given index in an array of strings. If there is no defined value
 * after the index, return the closest defined value before the index. Return an empty string if no
 * defined value was found.
 *
 */
function findNextDefinedValue(arr, index) {
    let value = arr.slice(index).find((val) => val);
    if (!value) {
        value = arr
            .slice(0, index)
            .reverse()
            .find((val) => val);
    }
    return value || "";
}
/** Get index of first header added by an ADD_COLUMNS_ROWS command */
function getAddHeaderStartIndex(position, base) {
    return position === "after" ? base + 1 : base;
}
/**
 * Compares n objects.
 */
function deepEquals$1(...o) {
    if (o.length <= 1)
        return true;
    for (let index = 1; index < o.length; index++) {
        if (!_deepEquals$1(o[0], o[index]))
            return false;
    }
    return true;
}
function _deepEquals$1(o1, o2) {
    if (o1 === o2)
        return true;
    if ((o1 && !o2) || (o2 && !o1))
        return false;
    if (typeof o1 !== typeof o2)
        return false;
    if (typeof o1 !== "object")
        return false;
    // Objects can have different keys if the values are undefined
    for (const key in o2) {
        if (!(key in o1) && o2[key] !== undefined) {
            return false;
        }
    }
    for (const key in o1) {
        if (typeof o1[key] !== typeof o2[key])
            return false;
        if (typeof o1[key] === "object") {
            if (!_deepEquals$1(o1[key], o2[key]))
                return false;
        }
        else {
            if (o1[key] !== o2[key])
                return false;
        }
    }
    return true;
}
/**
 * Compares two arrays.
 * For performance reasons, this function is to be preferred
 * to 'deepEquals' in the case we know that the inputs are arrays.
 */
function deepEqualsArray(arr1, arr2) {
    if (arr1.length !== arr2.length) {
        return false;
    }
    for (let i = 0; i < arr1.length; i++) {
        if (!deepEquals$1(arr1[i], arr2[i])) {
            return false;
        }
    }
    return true;
}
/**
 * Check if the given array contains all the values of the other array.
 * It makes the assumption that both array do not contain duplicates.
 */
function includesAll(arr, values) {
    if (arr.length < values.length) {
        return false;
    }
    const set = new Set(arr);
    return values.every((value) => set.has(value));
}
/**
 * Return an object with all the keys in the object that have a falsy value removed.
 */
function removeFalsyAttributes$1(obj) {
    if (!obj)
        return obj;
    const cleanObject = { ...obj };
    Object.keys(cleanObject).forEach((key) => !cleanObject[key] && delete cleanObject[key]);
    return cleanObject;
}
/**
 * Equivalent to "\s" in regexp, minus the new lines characters
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions/Character_Classes
 */
const specialWhiteSpaceSpecialCharacters = [
    "\t",
    "\f",
    "\v",
    String.fromCharCode(parseInt("00a0", 16)),
    String.fromCharCode(parseInt("1680", 16)),
    String.fromCharCode(parseInt("2000", 16)),
    String.fromCharCode(parseInt("200a", 16)),
    String.fromCharCode(parseInt("2028", 16)),
    String.fromCharCode(parseInt("2029", 16)),
    String.fromCharCode(parseInt("202f", 16)),
    String.fromCharCode(parseInt("205f", 16)),
    String.fromCharCode(parseInt("3000", 16)),
    String.fromCharCode(parseInt("feff", 16)),
];
const specialWhiteSpaceRegexp = new RegExp(specialWhiteSpaceSpecialCharacters.join("|"), "g");
const newLineRegexp = /(\r\n|\r)/g;
const whiteSpaceCharacters = specialWhiteSpaceSpecialCharacters.concat([" "]);
/**
 * Replace all different newlines characters by \n.
 */
function replaceNewLines(text) {
    if (!text)
        return "";
    return text.replace(newLineRegexp, NEWLINE);
}
/**
 * Determine if the numbers are consecutive.
 */
function isConsecutive(iterable) {
    const array = Array.from(iterable).sort((a, b) => a - b); // sort numerically rather than lexicographically
    for (let i = 1; i < array.length; i++) {
        if (array[i] - array[i - 1] !== 1) {
            return false;
        }
    }
    return true;
}
/**
 * Creates a version of the function that's memoized on the value of its first argument, if any.
 */
function memoize$1(func) {
    const cache = new Map();
    const funcName = func.name ? func.name + " (memoized)" : "memoized";
    return {
        [funcName](...args) {
            if (!cache.has(args[0])) {
                cache.set(args[0], func(...args));
            }
            return cache.get(args[0]);
        },
    }[funcName];
}
/**
 * Removes the specified indexes from the array.
 * Sparse (empty) elements are transformed to undefined (unless their index is explicitly removed).
 */
function removeIndexesFromArray(array, indexes) {
    const toRemove = new Set(indexes);
    const newArray = [];
    for (let i = 0; i < array.length; i++) {
        if (!toRemove.has(i)) {
            newArray.push(array[i]);
        }
    }
    return newArray;
}
function insertItemsAtIndex(array, items, index) {
    return array.slice(0, index).concat(items).concat(array.slice(index));
}
function replaceItemAtIndex(array, newItem, index) {
    const newArray = [...array];
    newArray[index] = newItem;
    return newArray;
}
function trimContent$1(content) {
    const contentLines = content.split("\n");
    return contentLines.map((line) => line.replace(/\s+/g, " ").trim()).join("\n");
}
function isNumberBetween(value, min, max) {
    if (min > max) {
        return isNumberBetween(value, max, min);
    }
    return value >= min && value <= max;
}
/**
 * Get a Regex for the find & replace that matches the given search string and options.
 */
function getSearchRegex(searchStr, searchOptions) {
    let searchValue = escapeRegExp$1(searchStr);
    const flags = !searchOptions.matchCase ? "i" : "";
    if (searchOptions.exactMatch) {
        searchValue = `^${searchValue}$`;
    }
    return RegExp(searchValue, flags);
}
/**
 * Alternative to Math.max that works with large arrays.
 * Typically useful for arrays bigger than 100k elements.
 */
function largeMax(array) {
    let len = array.length;
    if (len < 100_000)
        return Math.max(...array);
    let max = -Infinity;
    while (len--) {
        max = array[len] > max ? array[len] : max;
    }
    return max;
}
/**
 * Alternative to Math.min that works with large arrays.
 * Typically useful for arrays bigger than 100k elements.
 */
function largeMin(array) {
    let len = array.length;
    if (len < 100_000)
        return Math.min(...array);
    let min = +Infinity;
    while (len--) {
        min = array[len] < min ? array[len] : min;
    }
    return min;
}
let TokenizingChars$1 = class TokenizingChars {
    text;
    currentIndex = 0;
    current;
    constructor(text) {
        this.text = text;
        this.current = text[0];
    }
    shift() {
        const current = this.current;
        const next = this.text[++this.currentIndex];
        this.current = next;
        return current;
    }
    advanceBy(length) {
        this.currentIndex += length;
        this.current = this.text[this.currentIndex];
    }
    isOver() {
        return this.currentIndex >= this.text.length;
    }
    remaining() {
        return this.text.substring(this.currentIndex);
    }
    currentStartsWith(str) {
        if (this.current !== str[0]) {
            return false;
        }
        for (let j = 1; j < str.length; j++) {
            if (this.text[this.currentIndex + j] !== str[j]) {
                return false;
            }
        }
        return true;
    }
};
/**
 * Remove duplicates from an array.
 *
 * @param array The array to remove duplicates from.
 * @param cb A callback to get an element value.
 */
function removeDuplicates$1(array, cb = (a) => a) {
    const set = new Set();
    return array.filter((item) => {
        const key = cb(item);
        if (set.has(key)) {
            return false;
        }
        set.add(key);
        return true;
    });
}
/**
 * Similar to transposing and array, but with POJOs instead of arrays. Useful, for example, when manipulating
 * a POJO grid[col][row] and you want to transpose it to grid[row][col].
 *
 * The resulting object is created such as result[key1][key2] = pojo[key2][key1]
 */
function transpose2dPOJO(pojo) {
    const result = {};
    for (const key in pojo) {
        for (const subKey in pojo[key]) {
            if (!result[subKey]) {
                result[subKey] = {};
            }
            result[subKey][key] = pojo[key][subKey];
        }
    }
    return result;
}
function getUniqueText(text, texts, options = {}) {
    const compute = options.compute ?? ((text, i) => `${text} (${i})`);
    const computeFirstOne = options.computeFirstOne ?? false;
    let i = options.start ?? 1;
    let newText = computeFirstOne ? compute(text, i) : text;
    while (texts.includes(newText)) {
        newText = compute(text, i++);
    }
    return newText;
}
function isFormula(content) {
    return content.startsWith("=") || content.startsWith("+");
}
// TODO: we should make make ChartStyle be the same as Style sometime ...
function chartStyleToCellStyle(style) {
    return {
        bold: style.bold,
        italic: style.italic,
        fontSize: style.fontSize,
        textColor: style.color,
        align: style.align,
    };
}

//------------------------------------------------------------------------------
// Coordinate
//------------------------------------------------------------------------------
/**
 * Convert a (col) number to the corresponding letter.
 *
 * Examples:
 *     0 => 'A'
 *     25 => 'Z'
 *     26 => 'AA'
 *     27 => 'AB'
 */
function numberToLetters(n) {
    if (n < 0) {
        throw new Error(`number must be positive. Got ${n}`);
    }
    if (n < 26) {
        return String.fromCharCode(65 + n);
    }
    else {
        return numberToLetters(Math.floor(n / 26) - 1) + numberToLetters(n % 26);
    }
}
function lettersToNumber(letters) {
    let result = 0;
    const l = letters.length;
    for (let i = 0; i < l; i++) {
        const colIndex = charToNumber(letters[i]);
        result = result * 26 + colIndex;
    }
    return result - 1;
}
function charToNumber(char) {
    const charCode = char.charCodeAt(0);
    return charCode >= 65 && charCode <= 90 ? charCode - 64 : charCode - 96;
}
function isCharALetter(char) {
    return (char >= "A" && char <= "Z") || (char >= "a" && char <= "z");
}
function isCharADigit(char) {
    return char >= "0" && char <= "9";
}
// we limit the max column to 3 letters and max row to 7 digits for performance reasons
const MAX_COL = lettersToNumber("ZZZ");
const MAX_ROW = 9999998;
function consumeSpaces(chars) {
    while (chars.current === " ") {
        chars.advanceBy(1);
    }
}
function consumeLetters(chars) {
    if (chars.current === "$")
        chars.advanceBy(1);
    if (!chars.current || !isCharALetter(chars.current)) {
        return -1;
    }
    let colCoordinate = 0;
    while (chars.current && isCharALetter(chars.current)) {
        colCoordinate = colCoordinate * 26 + charToNumber(chars.shift());
    }
    return colCoordinate;
}
function consumeDigits(chars) {
    if (chars.current === "$")
        chars.advanceBy(1);
    if (!chars.current || !isCharADigit(chars.current)) {
        return -1;
    }
    let num = 0;
    while (chars.current && isCharADigit(chars.current)) {
        num = num * 10 + Number(chars.shift());
    }
    return num;
}
/**
 * Convert a "XC" coordinate to cartesian coordinates.
 *
 * Examples:
 *   A1 => [0,0]
 *   B3 => [1,2]
 *
 * Note: it also accepts lowercase coordinates, but not fixed references
 */
function toCartesian(xc) {
    const chars = new TokenizingChars$1(xc);
    consumeSpaces(chars);
    const letterPart = consumeLetters(chars);
    if (letterPart === -1 || !chars.current) {
        throw new Error(`Invalid cell description: ${xc}`);
    }
    const num = consumeDigits(chars);
    consumeSpaces(chars);
    const col = letterPart - 1;
    const row = num - 1;
    if (!chars.isOver() || col > MAX_COL || row > MAX_ROW) {
        throw new Error(`Invalid cell description: ${xc}`);
    }
    return { col, row };
}
/**
 * Convert from cartesian coordinate to the "XC" coordinate system.
 *
 * Examples:
 *   - 0,0 => A1
 *   - 1,2 => B3
 *   - 0,0, {colFixed: false, rowFixed: true} => A$1
 *   - 1,2, {colFixed: true, rowFixed: false} => $B3
 */
function toXC(col, row, rangePart = { colFixed: false, rowFixed: false }) {
    return ((rangePart.colFixed ? "$" : "") +
        numberToLetters(col) +
        (rangePart.rowFixed ? "$" : "") +
        String(row + 1));
}

/**
 * ####################################################
 * # INTRODUCTION
 * ####################################################
 *
 * This file contain the function recomputeZones.
 * This function try to recompute in a performant way
 * an ensemble of zones possibly overlapping to avoid
 * overlapping and to reduce the number of zones.
 *
 * It also allows to remove some zones from the ensemble.
 *
 * In the following example, 2 zones are overlapping.
 * Applying recomputeZones will return zones without
 * overlapping:
 *
 * ["B3:D4", "D2:E3"]         ["B3:C4", "D2:D4", "E2:E3"]
 *
 *      A B C D E                    A B C D E
 *    1       ___                  1       ___
 *    2   ___|_  |                 2   ___| | |
 *    3  |   |_|_|      --->       3  |   | |_|
 *    4  |_____|                   4  |___|_|
 *    6                            6
 *    7                            7
 *
 *
 * In the following example, 2 zones are contiguous.
 * Applying recomputeZones will return only one zone:
 *
 *  ["B2:B3", "C2:D3"]               ["B2:D3"]
 *
 *       A B C D E                   A B C D E
 *     1   _ ___                   1   _____
 *     2  | |   |        --->      2  |     |
 *     3  |_|___|                  3  |_____|
 *     4                           4
 *
 *
 * In the following example, we want to remove a zone
 * from the ensemble. Applying recomputeZones will
 * return the ensemble without the zone to remove:
 *
 *    remove ["C3:D3"]           ["B2:B4", "C2:D2",
 *                                "C4:D4", "E2:E4"]
 *
 *       A B C D E F                 A B C D E F
 *     1   _______                 1   _______
 *     2  |       |       --->     2  | |___| |
 *     3  |  xxx  |                3  | |___| |
 *     4  |_______|                4  |_|___|_|
 *     5                           5
 *
 *
 * The exercise seems simple when we have only 2 zones.
 * But with n zones and in a performant way, we want to
 * avoid comparing each zone with all the others.
 *
 *
 * ####################################################
 * # Methodological approach
 * ####################################################
 *
 * The methodological approach to avoid comparing each
 * zone with all the others is to use a data structure
 * that allow to quickly find which zones are
 * overlapping with any other given zone.
 *
 * Here the idea is to profile the zones at the columns level.
 *
 * To do that, we propose to use a data structure
 * composed of 2 parts:
 * - profilesStartingPosition: a sorted number array
 * indicating on which columns a new profile begins.
 * - profiles: a map where the key is a column
 * position (from profilesStartingPosition) and the
 * value is a sorted number array representing a
 * profile.
 *
 *
 * See the following example:    here profileStartingPosition
 *                               corresponds to [A,C,E,G,K]
 *    A B C D E F G H I J K      so with number [0,2,4,6,10]
 *  1    '   '   '       '
 *  2    '   '   '_______'       here profile correspond
 *  3    '___'   |_______|       for A to []
 *  4    |   |                   for C to [3, 5]
 *  5    |___|                   for E to []
 *  6                            for G to [2, 3]
 *  7                            for K to []
 *
 *
 * Now we can easily find which zones are overlapping
 * with a given zone. Suppose we want to add a new zone
 * D5:H6 to the ensemble:
 *
 *                              With a binary search of left and right
 *    A B C D E F G H I J K     on profilesStartingPosition, we can
 *  1    '   '   '       '      find the indexes of the profiles on which
 *  2    '   '   '_______'      to apply a modification.
 *  3    '___'   |_______|
 *  4    |  _|_______           Here we will:
 *  5    |_|_|       |          - add a new profile in D   --> become [3, 6]
 *  6      |_________|          - modify the profile in E  --> become [4, 6]
 *  7                           - modify the profile in G  --> become [2, 3, 4, 6]
 *                              - add a new profile in I   --> become [8, 10]
 *
 *  See below the result:
 *
 *                              Note the particularity of the profile
 *    A B C D E F G H I J K     for G: it will correspond to [2, 3, 4, 6]
 *  1    ' ' '   '   '   '
 *  2    ' ' '   '___'___'      To know how to modify the profile (add a
 *  3    '_'_'   |___|___|      zone or remove it) we do a binary
 *  4    | | |___ ___           search of the top and bottom value on the
 *  5    |_| |   |   |          profile array. Depending on the result index
 *  6      |_|___|___|          parity (odd or even), because zone boundaries
 *  7                           go by pairs, we know if we are in a zone or
 *                              not and how operate.
 */
/**
 * Recompute the zone without the cells in toRemoveZones and avoid overlapping.
 * This compute is particularly useful because after this function:
 * - you will find coordinate of a cell only once among all the zones
 * - the number of zones will be reduced to the minimum
 */
function recomputeZones(zones, zonesToRemove = []) {
    if (zones.length <= 1 && zonesToRemove.length === 0) {
        return zones;
    }
    const profilesStartingPosition = [0];
    const profiles = new Map([[0, []]]);
    modifyProfiles(profilesStartingPosition, profiles, zones, false);
    modifyProfiles(profilesStartingPosition, profiles, zonesToRemove, true);
    return constructZonesFromProfiles(profilesStartingPosition, profiles);
}
function modifyProfiles(// export for testing only
profilesStartingPosition, profiles, zones, toRemove = false) {
    for (const zone of zones) {
        const leftValue = zone.left;
        const rightValue = zone.right === undefined ? undefined : zone.right + 1;
        const leftIndex = findIndexAndCreateProfile(profilesStartingPosition, profiles, leftValue, true, 0);
        const rightIndex = findIndexAndCreateProfile(profilesStartingPosition, profiles, rightValue, false, leftIndex);
        for (let i = leftIndex; i <= rightIndex; i++) {
            const profile = profiles.get(profilesStartingPosition[i]);
            modifyProfile(profile, zone, toRemove);
        }
        // maybe this part cost in performance, and maybe it's not necessary (depending on the use case). To be checked
        removeContiguousProfiles(profilesStartingPosition, profiles, leftIndex, rightIndex);
    }
}
function findIndexAndCreateProfile(profilesStartingPosition, profiles, value, searchLeft, startIndex) {
    if (value === undefined) {
        // this is only the case when the value correspond to a bottom value that could be undefined
        return profilesStartingPosition.length - 1;
    }
    const predecessorIndex = binaryPredecessorSearch(profilesStartingPosition, value, startIndex);
    if (value !== profilesStartingPosition[predecessorIndex]) {
        // mean that the value is not ending/starting at the same position as the previous/next profile
        // --> it's a new profile
        // --> we need to add it
        profilesStartingPosition.splice(predecessorIndex + 1, 0, value);
        // suppose the               we want to add the       for the left value
        // following profile         following zone:          'C', the predecessor index
        //   for B: [1, 3]                "C3:D4"             correspond to 'B'.
        //                                                    The next line code will
        //       A B C D                A B C D               copy the profile of 'B'
        //     1  '___'               1  '___'                to 'C'. In the rest of the
        //     2  |   |       --->    2  |  _|_               process the 'modifyProfile'
        //     3  |___|               3  |_|_| |              function will adapt the waiting
        //     4                      4    |___|              'C' profile [1, 3] to the
        //                                                    correct 'C' profile [1, 4]
        profiles.set(value, [...profiles.get(profilesStartingPosition[predecessorIndex])]);
        return searchLeft ? predecessorIndex + 1 : predecessorIndex;
    }
    return searchLeft ? predecessorIndex : predecessorIndex - 1;
}
/**
 *  Suppose the following        Suppose we want to add          We want to have the
 *  profile:                     the following zone:             following profile:
 *
 *       A B C D E F                  A B C D E F                     A B C D E F
 *     1    '___'                   1    '   '                      1    '___'
 *     2    |___|                   2    '___'                      2    |   |
 *     3    '   '                   3    |   |                      3    |   |
 *     4    '___'          -->      4    |   |            -->       4    |   |
 *     6    |   |                   6    |___|                      6    |   |
 *     7    |___|                   7                               7    |___|
 *     8                            8                               8
 *
 *  the profile for 'C'          the top zone correspond        Here [2, 3, 5, 8] with [3, 7]
 *  corresponds to:              to 3 and the bottom zone       would be merged into [2, 8]
 *   ____  ____                  correspond to 6
 *  [2, 3, 5, 8]                 would be the profile:          The difficulty of modify profile
 *                                ____                          is to know what must be deleted
 *  Note that the 'filled        [3, 7]                         and what must be added to the
 *  zone' are always between                                    existing profile.
 *  an even index and its
 *  next index
 *
 */
function modifyProfile(profile, zone, toRemove = false) {
    const topValue = zone.top;
    const bottomValue = zone.bottom === undefined ? undefined : zone.bottom + 1;
    const newPoints = [];
    // Case we want to add a zone to the profile:
    // - If the top predecessor index `topPredIndex` is even, it means the top of the zone is already positioned on a filled zone
    // so we don't need to add it to the profile. we can keep in reference the index of the predecessor.
    // - If it is odd, it means the top of the zone must be the beginning of a filled zone.
    // so we can keep the index of the top position
    // Case we want to remove a zone from the profile: it's the opposite of the previous case
    const topPredIndex = binaryPredecessorSearch(profile, topValue, 0, false);
    if ((topPredIndex % 2 !== 0 && !toRemove) || (topPredIndex % 2 === 0 && toRemove)) {
        newPoints.push(topValue);
    }
    if (bottomValue === undefined) {
        // The following two code lines will not impact the final result,
        // but they will impact the intermediate profile.
        // We keep them for performance reason
        profile.splice(topPredIndex + 1);
        profile.push(...newPoints);
        return;
    }
    // Case we want to add a zone to the profile:
    // - If the bottom successor index `bottomSuccIndex` is even, it means the bottom of the zone must be the ending of a filled zone
    // so we can keep the index of the bottom position.
    // - If it is odd, it means the bottom of the zone is already positioned on a filled zone
    // so we don't need to add it to the profile. we can keep in reference the index of the successor
    // Case we want to remove a zone from the profile: it's the opposite of the previous case
    const bottomSuccIndex = binarySuccessorSearch(profile, bottomValue, 0, false);
    if ((bottomSuccIndex % 2 === 0 && !toRemove) || (bottomSuccIndex % 2 !== 0 && toRemove)) {
        newPoints.push(bottomValue);
    }
    // add the top and bottom value to the profile and
    // remove all information between the top and bottom index
    profile.splice(topPredIndex + 1, bottomSuccIndex - topPredIndex - 1, ...newPoints);
}
function removeContiguousProfiles(profilesStartingPosition, profiles, leftIndex, rightIndex) {
    const start = leftIndex - 1 === -1 ? 0 : leftIndex - 1;
    const end = rightIndex === profilesStartingPosition.length - 1 ? rightIndex : rightIndex + 1;
    for (let i = end; i > start; i--) {
        if (deepEqualsArray(profiles.get(profilesStartingPosition[i]), profiles.get(profilesStartingPosition[i - 1]))) {
            profiles.delete(profilesStartingPosition[i]);
            profilesStartingPosition.splice(i, 1);
        }
    }
}
function constructZonesFromProfiles(profilesStartingPosition, profiles) {
    const mergedZone = [];
    let pendingZones = [];
    for (let colIndex = 0; colIndex < profilesStartingPosition.length; colIndex++) {
        const left = profilesStartingPosition[colIndex];
        const profile = profiles.get(left);
        if (!profile || profile.length === 0) {
            mergedZone.push(...pendingZones);
            pendingZones = [];
            continue;
        }
        let right = profilesStartingPosition[colIndex + 1];
        if (right !== undefined) {
            right--;
        }
        const nextPendingZones = [];
        for (let i = 0; i < profile.length; i += 2) {
            const top = profile[i];
            let bottom = profile[i + 1];
            if (bottom !== undefined) {
                bottom--;
            }
            const profileZone = {
                top,
                left,
                bottom,
                right,
                hasHeader: (bottom === undefined && top !== 0) || (right === undefined && left !== 0),
            };
            let findCorrespondingZone = false;
            for (let j = pendingZones.length - 1; j >= 0; j--) {
                const pendingZone = pendingZones[j];
                if (pendingZone.top === profileZone.top && pendingZone.bottom === profileZone.bottom) {
                    pendingZone.right = profileZone.right;
                    pendingZones.splice(j, 1);
                    nextPendingZones.push(pendingZone);
                    findCorrespondingZone = true;
                    break;
                }
            }
            if (!findCorrespondingZone) {
                nextPendingZones.push(profileZone);
            }
        }
        mergedZone.push(...pendingZones);
        pendingZones = nextPendingZones;
    }
    mergedZone.push(...pendingZones);
    return mergedZone;
}
function binaryPredecessorSearch(arr, val, start = 0, matchEqual = true) {
    let end = arr.length - 1;
    let result = -1;
    while (start <= end) {
        const mid = Math.floor((start + end) / 2);
        if (arr[mid] === val && matchEqual) {
            return mid;
        }
        else if (arr[mid] < val) {
            result = mid;
            start = mid + 1;
        }
        else {
            end = mid - 1;
        }
    }
    return result;
}
function binarySuccessorSearch(arr, val, start = 0, matchEqual = true) {
    let end = arr.length - 1;
    let result = arr.length;
    while (start <= end) {
        const mid = Math.floor((start + end) / 2);
        if (arr[mid] === val && matchEqual) {
            return mid;
        }
        else if (arr[mid] > val) {
            result = mid;
            end = mid - 1;
        }
        else {
            start = mid + 1;
        }
    }
    return result;
}

/**
 * Convert from a cartesian reference to a Zone
 * The range boundaries will be kept in the same order as the
 * ones in the text.
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "C3:A1" ==> Top 2, Bottom 0, Left 2, Right 0
 *    "A:A" ==> Top 0, Bottom undefined, Left 0, Right 0
 *    "A:B3" or "B3:A" ==> Top 2, Bottom undefined, Left 0, Right 1
 *
 * @param xc the string reference to convert
 *
 */
function toZoneWithoutBoundaryChanges(xc) {
    const chars = new TokenizingChars$1(xc);
    consumeSpaces(chars);
    const sheetSeparatorIndex = xc.indexOf("!");
    if (sheetSeparatorIndex !== -1) {
        chars.advanceBy(sheetSeparatorIndex + 1);
    }
    const leftLetters = consumeLetters(chars);
    const leftNumbers = consumeDigits(chars);
    let top, bottom, left, right;
    let fullCol = false;
    let fullRow = false;
    let hasHeader = false;
    if (leftNumbers === -1) {
        left = right = leftLetters - 1;
        top = bottom = 0;
        fullCol = true;
    }
    else if (leftLetters === -1) {
        top = bottom = leftNumbers - 1;
        left = right = 0;
        fullRow = true;
    }
    else {
        left = right = leftLetters - 1;
        top = bottom = leftNumbers - 1;
        hasHeader = true;
    }
    consumeSpaces(chars);
    if (chars.current === ":") {
        chars.advanceBy(1);
        consumeSpaces(chars);
        const rightLetters = consumeLetters(chars);
        const rightNumbers = consumeDigits(chars);
        if (rightNumbers === -1) {
            right = rightLetters - 1;
            fullCol = true;
        }
        else if (rightLetters === -1) {
            bottom = rightNumbers - 1;
            fullRow = true;
        }
        else {
            right = rightLetters - 1;
            bottom = rightNumbers - 1;
            top = fullCol ? bottom : top;
            left = fullRow ? right : left;
            hasHeader = true;
        }
    }
    const zone = {
        top,
        left,
        bottom: fullCol ? undefined : bottom,
        right: fullRow ? undefined : right,
    };
    hasHeader = hasHeader && (fullRow || fullCol);
    if (hasHeader) {
        zone.hasHeader = hasHeader;
    }
    return zone;
}
/**
 * Convert from a cartesian reference to a (possibly unbounded) Zone
 *
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "B:B" ==> Top 0, Bottom undefined, Left: 1, Right: 1
 *    "B2:B" ==> Top 1, Bottom undefined, Left: 1, Right: 1, hasHeader: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *
 * @param xc the string reference to convert
 *
 */
function toUnboundedZone(xc) {
    const zone = toZoneWithoutBoundaryChanges(xc);
    const orderedZone = reorderZone(zone);
    const bottom = orderedZone.bottom;
    const right = orderedZone.right;
    if ((bottom !== undefined && bottom > MAX_ROW) || (right !== undefined && right > MAX_COL)) {
        throw new Error(`Range string out of bounds: ${xc}`); // limit the size of the zone for performance
    }
    if (bottom === undefined && right === undefined) {
        throw new Error("Wrong zone xc. The zone cannot be at the same time a full column and a full row");
    }
    return orderedZone;
}
/**
 * Convert from a cartesian reference to a Zone.
 * Will return throw an error if given a unbounded zone (eg : A:A).
 *
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 2, Left: 1, Right: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 2, Left: 1, Right: 1
 *
 * @param xc the string reference to convert
 *
 */
function toZone(xc) {
    const zone = toUnboundedZone(xc);
    if (zone.bottom === undefined || zone.right === undefined) {
        throw new Error("This does not support unbounded ranges");
    }
    return zone;
}
function isXcValid(xc) {
    const zone = toUnboundedZone(xc);
    return isZoneValid(zone);
}
/**
 * Check that the given string is a correct xc representation (ie a valid zone). The try-catch
 * added over the ixXcValid call is necessary because the function can throw an error if the
 * string is not convertible to a zone by the toUnboundedZone function.
 */
function isXcRepresentation(xc) {
    try {
        return isXcValid(xc);
    }
    catch (e) {
        return false;
    }
}
/**
 * Check that the zone has valid coordinates and in
 * the correct order.
 */
function isZoneValid(zone) {
    // Typescript *should* prevent this kind of errors but
    // it's better to be on the safe side at runtime as well.
    const { bottom, top, left, right } = zone;
    if ((bottom !== undefined && isNaN(bottom)) ||
        isNaN(top) ||
        isNaN(left) ||
        (right !== undefined && isNaN(right))) {
        return false;
    }
    return isZoneOrdered(zone) && zone.top >= 0 && zone.left >= 0;
}
/**
 * Check that the zone properties are in the correct order.
 */
function isZoneOrdered(zone) {
    return ((zone.bottom === undefined || (zone.bottom >= zone.top && zone.bottom >= 0)) &&
        (zone.right === undefined || (zone.right >= zone.left && zone.right >= 0)));
}
/**
 * Convert from zone to a cartesian reference
 *
 */
function zoneToXc(zone) {
    const { top, bottom, left, right } = zone;
    const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
    const isOneCell = top === bottom && left === right;
    if (bottom === undefined && right !== undefined) {
        return top === 0 && !hasHeader
            ? `${numberToLetters(left)}:${numberToLetters(right)}`
            : `${toXC(left, top)}:${numberToLetters(right)}`;
    }
    else if (right === undefined && bottom !== undefined) {
        return left === 0 && !hasHeader
            ? `${top + 1}:${bottom + 1}`
            : `${toXC(left, top)}:${bottom + 1}`;
    }
    else if (bottom !== undefined && right !== undefined) {
        return isOneCell ? toXC(left, top) : `${toXC(left, top)}:${toXC(right, bottom)}`;
    }
    throw new Error("Bad zone format");
}
/**
 * Expand a zone after inserting columns or rows.
 *
 * Don't resize the zone if a col/row was added right before/after the row but only move the zone.
 */
function expandZoneOnInsertion(zone, start, base, position, quantity) {
    const dimension = start === "left" ? "columns" : "rows";
    const baseElement = position === "before" ? base - 1 : base;
    const end = start === "left" ? "right" : "bottom";
    const zoneEnd = zone[end];
    if (zone[start] <= baseElement && zoneEnd && zoneEnd > baseElement) {
        return createAdaptedZone(zone, dimension, "RESIZE", quantity);
    }
    if (baseElement < zone[start]) {
        return createAdaptedZone(zone, dimension, "MOVE", quantity);
    }
    return { ...zone };
}
/**
 * Update the selection after column/row addition
 */
function updateSelectionOnInsertion(selection, start, base, position, quantity) {
    const dimension = start === "left" ? "columns" : "rows";
    const baseElement = position === "before" ? base - 1 : base;
    const end = start === "left" ? "right" : "bottom";
    if (selection[start] <= baseElement && selection[end] > baseElement) {
        return createAdaptedZone(selection, dimension, "RESIZE", quantity);
    }
    if (baseElement < selection[start]) {
        return createAdaptedZone(selection, dimension, "MOVE", quantity);
    }
    return { ...selection };
}
/**
 * Update the selection after column/row deletion
 */
function updateSelectionOnDeletion(zone, start, elements) {
    const end = start === "left" ? "right" : "bottom";
    let newStart = zone[start];
    let newEnd = zone[end];
    for (const removedElement of elements.sort((a, b) => b - a)) {
        if (zone[start] > removedElement) {
            newStart--;
            newEnd--;
        }
        if (zone[start] < removedElement && zone[end] >= removedElement) {
            newEnd--;
        }
    }
    return { ...zone, [start]: newStart, [end]: newEnd };
}
/**
 * Reduce a zone after deletion of elements
 */
function reduceZoneOnDeletion(zone, start, elements) {
    const end = start === "left" ? "right" : "bottom";
    let newStart = zone[start];
    let newEnd = zone[end];
    const zoneEnd = zone[end];
    for (const removedElement of elements.sort((a, b) => b - a)) {
        if (zone[start] > removedElement) {
            newStart--;
            if (newEnd !== undefined)
                newEnd--;
        }
        if (zoneEnd !== undefined &&
            newEnd !== undefined &&
            zone[start] <= removedElement &&
            zoneEnd >= removedElement) {
            newEnd--;
        }
    }
    if (newEnd !== undefined && newStart > newEnd) {
        return undefined;
    }
    return { ...zone, [start]: newStart, [end]: newEnd };
}
/**
 * Compute the union of multiple zones.
 */
function union(...zones) {
    return {
        top: Math.min(...zones.map((zone) => zone.top)),
        left: Math.min(...zones.map((zone) => zone.left)),
        bottom: Math.max(...zones.map((zone) => zone.bottom)),
        right: Math.max(...zones.map((zone) => zone.right)),
    };
}
/**
 * Compute the union of multiple unbounded zones.
 */
function unionUnboundedZones(...zones) {
    return {
        top: Math.min(...zones.map((zone) => zone.top)),
        left: Math.min(...zones.map((zone) => zone.left)),
        bottom: zones.some((zone) => zone.bottom === undefined)
            ? undefined
            : Math.max(...zones.map((zone) => zone.bottom)),
        right: zones.some((zone) => zone.right === undefined)
            ? undefined
            : Math.max(...zones.map((zone) => zone.right)),
    };
}
/**
 * Compute the intersection of two zones. Returns nothing if the two zones don't overlap
 */
function intersection(z1, z2) {
    if (!overlap(z1, z2)) {
        return undefined;
    }
    return {
        top: Math.max(z1.top, z2.top),
        left: Math.max(z1.left, z2.left),
        bottom: z1.bottom !== undefined ? Math.min(z1.bottom, z2.bottom) : z1.bottom ?? z2.bottom,
        right: z1.right !== undefined ? Math.min(z1.right, z2.right) : z1.right ?? z2.right,
    };
}
/**
 * Two zones are equal if they represent the same area, so we clearly cannot use
 * reference equality.
 */
function isEqual(z1, z2) {
    return (z1.left === z2.left &&
        z1.right === z2.right &&
        z1.top === z2.top &&
        z1.bottom === z2.bottom &&
        z1.hasHeader === z2.hasHeader);
}
/**
 * Two zones are adjacent if they -partially- share an edge.
 * Returns the adjacent size of z1 as well as the indexes of the header by which they are adjacent.
 */
function adjacent(z1, z2) {
    if (intersection(z1, z2))
        return undefined;
    let adjacentEdge = undefined;
    if (z1.left === z2.right + 1) {
        adjacentEdge = {
            position: "left",
            start: Math.max(z1.top, z2.top),
            stop: z1.bottom !== undefined ? Math.min(z1.bottom, z2.bottom) : z2.bottom,
        };
    }
    if (z1.right !== undefined && z1.right + 1 === z2.left) {
        adjacentEdge = {
            position: "right",
            start: Math.max(z1.top, z2.top),
            stop: z1.bottom !== undefined ? Math.min(z1.bottom, z2.bottom) : z2.bottom,
        };
    }
    if (z1.top === z2.bottom + 1) {
        adjacentEdge = {
            position: "top",
            start: Math.max(z1.left, z2.left),
            stop: z1.right !== undefined ? Math.min(z1.right, z2.right) : z2.right,
        };
    }
    if (z1.bottom !== undefined && z1.bottom + 1 === z2.top) {
        adjacentEdge = {
            position: "bottom",
            start: Math.max(z1.left, z2.left),
            stop: z1.right !== undefined ? Math.min(z1.right, z2.right) : z2.right,
        };
    }
    return adjacentEdge && adjacentEdge.start <= adjacentEdge.stop ? adjacentEdge : undefined;
}
/**
 * Return true if two zones overlap, false otherwise.
 */
function overlap(z1, z2) {
    if ((z1.bottom !== undefined && z1.bottom < z2.top) ||
        (z2.bottom !== undefined && z2.bottom < z1.top)) {
        return false;
    }
    if ((z1.right !== undefined && z1.right < z2.left) ||
        (z2.right !== undefined && z2.right < z1.left)) {
        return false;
    }
    return true;
}
/**
 * Returns true if any two zones in the given list overlap.
 */
function hasOverlappingZones(zones) {
    for (let i = 0; i < zones.length - 1; i++) {
        for (let j = i + 1; j < zones.length; j++) {
            if (overlap(zones[i], zones[j])) {
                return true;
            }
        }
    }
    return false;
}
function isInside(col, row, zone) {
    const { left, right, top, bottom } = zone;
    return col >= left && col <= right && row >= top && row <= bottom;
}
/**
 * Check if a zone is inside another
 */
function isZoneInside(smallZone, biggerZone) {
    return isEqual(union(biggerZone, smallZone), biggerZone);
}
function zoneToDimension(zone) {
    return {
        numberOfRows: zone.bottom - zone.top + 1,
        numberOfCols: zone.right - zone.left + 1,
    };
}
function isOneDimensional(zone) {
    const { numberOfCols, numberOfRows } = zoneToDimension(zone);
    return numberOfCols === 1 || numberOfRows === 1;
}
function excludeTopLeft(zone) {
    const { top, left, bottom, right } = zone;
    if (getZoneArea(zone) === 1) {
        return [];
    }
    const leftColumnZone = {
        top: top + 1,
        bottom,
        left,
        right: left,
    };
    if (right === left) {
        return [leftColumnZone];
    }
    const rightPartZone = {
        top,
        bottom,
        left: left + 1,
        right,
    };
    if (top === bottom) {
        return [rightPartZone];
    }
    return [leftColumnZone, rightPartZone];
}
function aggregatePositionsToZones(positions) {
    const result = {};
    for (const position of positions) {
        result[position.sheetId] ??= [];
        result[position.sheetId].push(positionToZone(position));
    }
    for (const sheetId in result) {
        result[sheetId] = recomputeZones(result[sheetId]);
    }
    return result;
}
/**
 * Array of all positions in the zone.
 */
function positions(zone) {
    const positions = [];
    const { left, right, top, bottom } = reorderZone(zone);
    for (const col of range$1(left, right + 1)) {
        for (const row of range$1(top, bottom + 1)) {
            positions.push({ col, row });
        }
    }
    return positions;
}
/**
 * Array of all cell positions in the zone.
 */
function cellPositions(sheetId, zone) {
    const positions = [];
    const { left, right, top, bottom } = reorderZone(zone);
    for (const col of range$1(left, right + 1)) {
        for (const row of range$1(top, bottom + 1)) {
            positions.push({ sheetId, col, row });
        }
    }
    return positions;
}
function reorderZone(zone) {
    if (zone.right !== undefined && zone.left > zone.right) {
        zone = { ...zone, left: zone.right, right: zone.left };
    }
    if (zone.bottom !== undefined && zone.top > zone.bottom) {
        zone = { ...zone, top: zone.bottom, bottom: zone.top };
    }
    return zone;
}
/**
 * This function returns a zone with coordinates modified according to the change
 * applied to the zone. It may be possible to change the zone by resizing or moving
 * it according to different dimensions.
 *
 * @param zone the zone to modify
 * @param dimension the direction to change the zone among "columns", "rows" and
 * "both"
 * @param operation how to change the zone, modify its size "RESIZE" or modify
 * its location "MOVE"
 * @param by a number of how many units the change should be made. This parameter
 * takes the form of a two-number array when the dimension is "both"
 */
function createAdaptedZone(zone, dimension, operation, by) {
    const offsetX = dimension === "both" ? by[0] : dimension === "columns" ? by : 0;
    const offsetY = dimension === "both" ? by[1] : dimension === "rows" ? by : 0;
    // For full columns/rows, we have to make the distinction between the one that have a header and
    // whose start should be moved (eg. A2:A), and those who don't (eg. A:A)
    // The only time we don't want to move the start of the zone is if the zone is a full column (or a full row)
    // without header and that we are adding/removing a row (or a column)
    const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
    let shouldStartBeMoved;
    if (isFullCol(zone) && !hasHeader) {
        shouldStartBeMoved = dimension !== "rows";
    }
    else if (isFullRow(zone) && !hasHeader) {
        shouldStartBeMoved = dimension !== "columns";
    }
    else {
        shouldStartBeMoved = true;
    }
    const newZone = { ...zone };
    if (shouldStartBeMoved && operation === "MOVE") {
        newZone["left"] += offsetX;
        newZone["top"] += offsetY;
    }
    if (newZone["right"] !== undefined) {
        newZone["right"] += offsetX;
    }
    if (newZone["bottom"] !== undefined) {
        newZone["bottom"] += offsetY;
    }
    return newZone;
}
/**
 * Returns a Zone array with unique occurrence of each zone.
 * For each multiple occurrence, the occurrence with the largest index is kept.
 * This allows to always have the last selection made in the last position.
 * */
function uniqueZones(zones) {
    return zones
        .reverse()
        .filter((zone, index, self) => index ===
        self.findIndex((z) => z.top === zone.top &&
            z.bottom === zone.bottom &&
            z.left === zone.left &&
            z.right === zone.right))
        .reverse();
}
/**
 * This function will find all overlapping zones in an array and transform them
 * into an union of each one.
 * */
function mergeOverlappingZones(zones) {
    return zones.reduce((dissociatedZones, zone) => {
        const nextIndex = dissociatedZones.length;
        for (let i = 0; i < nextIndex; i++) {
            if (overlap(dissociatedZones[i], zone)) {
                dissociatedZones[i] = union(dissociatedZones[i], zone);
                return dissociatedZones;
            }
        }
        dissociatedZones[nextIndex] = zone;
        return dissociatedZones;
    }, []);
}
/**
 * This function will compare the modifications of selection to determine
 * a cell that is part of the new zone and not the previous one.
 */
function findCellInNewZone(oldZone, currentZone) {
    let col, row;
    const { left: oldLeft, right: oldRight, top: oldTop, bottom: oldBottom } = oldZone;
    const { left, right, top, bottom } = currentZone;
    if (left !== oldLeft) {
        col = left;
    }
    else if (right !== oldRight) {
        col = right;
    }
    else {
        // left and right don't change
        col = left;
    }
    if (top !== oldTop) {
        row = top;
    }
    else if (bottom !== oldBottom) {
        row = bottom;
    }
    else {
        // top and bottom don't change
        row = top;
    }
    return { col, row };
}
function positionToZone(position) {
    return { left: position.col, right: position.col, top: position.row, bottom: position.row };
}
/** Transform a zone into a zone with only its top-left position */
function zoneToTopLeft(zone) {
    return { ...zone, right: zone.left, bottom: zone.top };
}
function isFullRow(zone) {
    return zone.right === undefined;
}
function isFullCol(zone) {
    return zone.bottom === undefined;
}
/** Returns the area of a zone */
function getZoneArea(zone) {
    return (zone.bottom - zone.top + 1) * (zone.right - zone.left + 1);
}
/**
 * Checks if a single zone crosses any of the frozen panes based on the vertical and horizontal split.
 */
function doesZoneCrossFrozenPane(zone, xSplit, ySplit) {
    return ((zone.left < xSplit && xSplit <= zone.right) || (zone.top < ySplit && ySplit <= zone.bottom));
}
/**
 * Checks if any of the given zones crosses any of the frozen panes.
 */
function doesAnyZoneCrossFrozenPane(zones, xSplit, ySplit) {
    return zones.some((zone) => doesZoneCrossFrozenPane(zone, xSplit, ySplit));
}
function boundUnboundedZone(unboundedZone, sheetSize) {
    const { left, top, bottom, right } = unboundedZone;
    if (right !== undefined && bottom !== undefined) {
        return unboundedZone;
    }
    else if (bottom === undefined && right !== undefined) {
        return { right, top, left, bottom: sheetSize.numberOfRows - 1 };
    }
    else if (right === undefined && bottom !== undefined) {
        return { bottom, left, top, right: sheetSize.numberOfCols - 1 };
    }
    throw new Error("Bad zone format");
}
/**
 * Check if the zones are continuous, ie. if they can be merged into a single zone without
 * including cells outside the zones
 * */
function areZonesContinuous(zones) {
    if (zones.length < 2)
        return true;
    return recomputeZones(zones).length === 1;
}
/** Return all the columns in the given list of zones */
function getZonesCols(zones) {
    const set = new Set();
    for (const zone of recomputeZones(zones)) {
        for (const col of range$1(zone.left, zone.right + 1)) {
            set.add(col);
        }
    }
    return set;
}
/**
 * Returns one merged zone per column,
 * spanning the full vertical range across all input zones.
 */
function getZonesByColumns(zones) {
    const map = new Map();
    for (const zone of zones) {
        for (let col = zone.left; col <= zone.right; col++) {
            const existing = map.get(col);
            if (existing) {
                existing.top = Math.min(existing.top, zone.top);
                existing.bottom = Math.max(existing.bottom, zone.bottom);
            }
            else {
                map.set(col, { left: col, right: col, top: zone.top, bottom: zone.bottom });
            }
        }
    }
    return Array.from(map.values());
}
/** Return all the rows in the given list of zones */
function getZonesRows(zones) {
    const set = new Set();
    for (const zone of recomputeZones(zones)) {
        for (const row of range$1(zone.top, zone.bottom + 1)) {
            set.add(row);
        }
    }
    return set;
}
/**
 * Check if two zones are contiguous, ie. that they share a border
 */
function areZoneContiguous(zone1, zone2) {
    if (zone1.right + 1 === zone2.left || zone1.left === zone2.right + 1) {
        return ((zone1.top <= zone2.bottom && zone1.top >= zone2.top) ||
            (zone2.top <= zone1.bottom && zone2.top >= zone1.top));
    }
    if (zone1.bottom + 1 === zone2.top || zone1.top === zone2.bottom + 1) {
        return ((zone1.left <= zone2.right && zone1.left >= zone2.left) ||
            (zone2.left <= zone1.right && zone2.left >= zone1.left));
    }
    return false;
}
/**
 * Merge contiguous and overlapping zones that are in the array into bigger zones
 */
function mergeContiguousZones(zones) {
    const mergedZones = [...zones];
    let hasMerged = true;
    while (hasMerged) {
        hasMerged = false;
        for (let i = 0; i < mergedZones.length; i++) {
            const zone = mergedZones[i];
            const mergeableZoneIndex = mergedZones.findIndex((z, j) => i !== j && (areZoneContiguous(z, zone) || overlap(z, zone)));
            if (mergeableZoneIndex !== -1) {
                mergedZones[i] = union(mergedZones[mergeableZoneIndex], zone);
                mergedZones.splice(mergeableZoneIndex, 1);
                hasMerged = true;
                break;
            }
        }
    }
    return mergedZones;
}
function splitIfAdjacent(zone, zoneToRemove) {
    const adjacentEdge = adjacent(zone, zoneToRemove);
    if (!adjacentEdge)
        return [zone];
    const newZones = [];
    switch (adjacentEdge.position) {
        case "bottom":
        case "top":
            newZones.push({
                top: zone.top,
                bottom: zone.bottom,
                left: adjacentEdge.start,
                right: adjacentEdge.stop,
            });
            if (adjacentEdge.start > zone.left) {
                newZones.push({
                    top: zone.top,
                    bottom: zone.bottom,
                    left: zone.left,
                    right: adjacentEdge.start - 1,
                });
            }
            if (zone.right === undefined || adjacentEdge.stop < zone.right) {
                newZones.push({
                    top: zone.top,
                    bottom: zone.bottom,
                    left: adjacentEdge.stop + 1,
                    right: zone.right,
                });
            }
            return newZones;
        case "left":
        case "right":
            newZones.push({
                top: adjacentEdge.start,
                bottom: adjacentEdge.stop,
                left: zone.left,
                right: zone.right,
            });
            if (adjacentEdge.start > zone.top) {
                newZones.push({
                    top: zone.top,
                    bottom: adjacentEdge.start - 1,
                    left: zone.left,
                    right: zone.right,
                });
            }
            if (zone.bottom === undefined || adjacentEdge.stop < zone.bottom) {
                newZones.push({
                    top: adjacentEdge.stop + 1,
                    bottom: zone.bottom,
                    left: zone.left,
                    right: zone.right,
                });
            }
            return newZones;
    }
}

function transformZone(zone, executed) {
    if (executed.type === "REMOVE_COLUMNS_ROWS") {
        return reduceZoneOnDeletion(zone, executed.dimension === "COL" ? "left" : "top", executed.elements);
    }
    if (executed.type === "ADD_COLUMNS_ROWS") {
        return expandZoneOnInsertion(zone, executed.dimension === "COL" ? "left" : "top", executed.base, executed.position, executed.quantity);
    }
    return zone;
}
function transformRangeData(range, executed) {
    const deletedSheet = executed.type === "DELETE_SHEET" && executed.sheetId;
    if ("sheetId" in executed && range._sheetId !== executed.sheetId) {
        return range;
    }
    else {
        const newZone = transformZone(range._zone, executed);
        if (newZone && deletedSheet !== range._sheetId) {
            return { ...range, _zone: newZone };
        }
    }
    return undefined;
}

let Registry$1 = class Registry {
    content = {};
    add(key, value) {
        if (key in this.content) {
            throw new Error(`${key} is already present in this registry!`);
        }
        return this.replace(key, value);
    }
    replace(key, value) {
        this.content[key] = value;
        return this;
    }
    get(key) {
        const content = this.content[key];
        if (!content && !(key in this.content)) {
            throw new Error(`Cannot find ${key} in this registry!`);
        }
        return content;
    }
    contains(key) {
        return key in this.content;
    }
    getAll() {
        return Object.values(this.content);
    }
    getKeys() {
        return Object.keys(this.content);
    }
    remove(key) {
        delete this.content[key];
    }
};

//------------------------------------------------------------------------------
// Arg description DSL
//------------------------------------------------------------------------------
const ARG_REGEXP = /(.*?)\((.*?)\)(.*)/;
const ARG_TYPES = [
    "ANY",
    "BOOLEAN",
    "DATE",
    "NUMBER",
    "STRING",
    "RANGE",
    "RANGE<BOOLEAN>",
    "RANGE<DATE>",
    "RANGE<NUMBER>",
    "RANGE<STRING>",
    "META",
    "RANGE<META>",
];
function arg(definition, description = "", proposals) {
    return makeArg(definition, description, proposals);
}
function makeArg(str, description, proposals) {
    const parts = str.match(ARG_REGEXP);
    const name = parts[1].trim();
    if (!name) {
        throw new Error(`Function argument definition is missing a name: '${str}'.`);
    }
    const types = [];
    let isOptional = false;
    let isRepeating = false;
    let defaultValue;
    for (const param of parts[2].split(",")) {
        const key = param.trim().toUpperCase();
        const type = ARG_TYPES.find((t) => key === t);
        if (type) {
            types.push(type);
        }
        else if (key === "RANGE<ANY>") {
            types.push("RANGE");
        }
        else if (key === "OPTIONAL") {
            isOptional = true;
        }
        else if (key === "REPEATING") {
            isRepeating = true;
        }
        else if (key.startsWith("DEFAULT=")) {
            defaultValue = param.trim().slice(8);
        }
    }
    const result = {
        name,
        description,
        type: types,
    };
    const acceptErrors = types.includes("ANY") || types.includes("RANGE");
    if (acceptErrors) {
        result.acceptErrors = true;
    }
    if (isOptional) {
        result.optional = true;
    }
    if (isRepeating) {
        result.repeating = true;
    }
    if (defaultValue !== undefined) {
        result.default = true;
        result.defaultValue = defaultValue;
    }
    if (types.some((t) => t.startsWith("RANGE"))) {
        result.acceptMatrix = true;
    }
    if (types.every((t) => t.startsWith("RANGE"))) {
        result.acceptMatrixOnly = true;
    }
    if (proposals && proposals.length > 0) {
        result.proposalValues = proposals;
    }
    return result;
}
/**
 * This function adds on description more general information derived from the
 * arguments.
 *
 * This information is useful during compilation.
 */
function addMetaInfoFromArg(name, addDescr) {
    let countArg = 0;
    let minArg = 0;
    let repeatingArg = 0;
    let optionalArg = 0;
    for (const arg of addDescr.args) {
        countArg++;
        if (!arg.optional && !arg.repeating && !arg.default) {
            minArg++;
        }
        if (arg.repeating) {
            repeatingArg++;
        }
        if (arg.optional || arg.default) {
            optionalArg++;
        }
    }
    const descr = addDescr;
    descr.minArgRequired = minArg;
    descr.maxArgPossible = repeatingArg ? Infinity : countArg;
    descr.nbrArgRepeating = repeatingArg;
    descr.nbrArgOptional = optionalArg;
    descr.hidden = addDescr.hidden || false;
    descr.name = name;
    return descr;
}
const cacheArgTargeting = {};
/**
 * Returns a function that maps the position of a value in a function to its corresponding argument index.
 *
 * In most cases, the task is straightforward:
 *
 * In the formula "=SUM(11, 55, 66)" which is defined like this "SUM(value1, [value2, ...])":
 * - 11 corresponds to the value1 argument => position will be 0
 * - 55 and 66 correspond to the [value2, ...] argument => position will be 1
 *
 * In other cases, optional arguments could be defined after repeatable arguments,
 * or even optional and required arguments could be mixed in unconventional ways.
 *
 * The next function has been designed to handle all possible configurations.
 * The only restriction is if repeatable arguments are present in the function definition:
 * - they must be defined consecutively
 * - they must be in a quantity greater than the optional arguments.
 *
 * The markdown tables below illustrate how values are mapped to positions based on the number of values supplied.
 * Each table represents a different function configuration, with columns representing the number of values supplied as arguments
 * and rows representing the correspondence with the argument index.
 *
 * The tables are built based on the following conventions:
 * - `m`: Mandatory argument
 * - `o`: Optional argument
 * - `r`: Repeating argument
 *
 *
 * Configuration 1: (m, o) like the CEILING function
 *
 * |   | 1 | 2 |
 * |---|---|---|
 * | m | 0 | 0 |
 * | o |   | 1 |
 *
 *
 * Configuration 2: (m, m, m, r, r) like the SUMIFS function
 *
 * |   | 3 | 5 | 7    | 3 + 2n     |
 * |---|---|---|------|------------|
 * | m | 0 | 0 | 0    | 0          |
 * | m | 1 | 1 | 1    | 1          |
 * | m | 2 | 2 | 2    | 2          |
 * | r |   | 3 | 3, 5 | 3 + 2n     |
 * | r |   | 4 | 4, 6 | 3 + 2n + 1 |
 *
 *
 * Configuration 3: (m, m, m, r, r, o) like the SWITCH function
 *
 * |   | 3 | 4 | 5 | 6 | 7    | 8    | 3 + 2n     | 3 + 2n + 1     |
 * |---|---|---|---|---|------|------|------------|----------------|
 * | m | 0 | 0 | 0 | 0 | 0    | 0    | 0          | 0              |
 * | m | 1 | 1 | 1 | 1 | 1    | 1    | 1          | 1              |
 * | m | 2 | 2 | 2 | 2 | 2    | 2    | 2          | 2              |
 * | r |   |   | 3 | 3 | 3, 5 | 3, 5 | 3 + 2n     | 3 + 2n         |
 * | r |   |   | 4 | 4 | 4, 6 | 4, 6 | 3 + 2n + 1 | 3 + 2n + 1     |
 * | o |   | 3 |   | 5 |      | 7    |            | 3 + 2N + 2     |
 *
 *
 * Configuration 4: (m, o, m, o, r, r, r, m) a complex case to understand subtleties
 *
 * |   | 3 | 4 | 5 | 6 | 7 | 8 | 9    | 10   | 11   | ... |
 * |---|---|---|---|---|---|---|------|------|------|-----|
 * | m | 0 | 0 | 0 | 0 | 0 | 0 | 0    | 0    | 0    | ... |
 * | o |   | 1 | 1 |   | 1 | 1 |      | 1    | 1    | ... |
 * | m | 1 | 2 | 2 | 1 | 2 | 2 | 1    | 2    | 2    | ... |
 * | o |   |   | 3 |   |   | 3 |      |      | 3    | ... |
 * | r |   |   |   | 2 | 3 | 4 | 2, 5 | 3, 6 | 4, 7 | ... |
 * | r |   |   |   | 3 | 4 | 5 | 3, 6 | 4, 7 | 5, 8 | ... |
 * | r |   |   |   | 4 | 5 | 6 | 4, 7 | 5, 8 | 6, 9 | ... |
 * | m | 2 | 3 | 4 | 5 | 6 | 7 | 8    | 9    | 10   | ... |
 *
 */
function argTargeting(functionDescription, nbrArgSupplied) {
    const functionName = functionDescription.name;
    const result = cacheArgTargeting[functionName]?.[nbrArgSupplied];
    if (result) {
        return result;
    }
    if (!cacheArgTargeting[functionName]) {
        cacheArgTargeting[functionName] = {};
    }
    if (!cacheArgTargeting[functionName][nbrArgSupplied]) {
        cacheArgTargeting[functionName][nbrArgSupplied] = _argTargeting(functionDescription, nbrArgSupplied);
    }
    return cacheArgTargeting[functionName][nbrArgSupplied];
}
function _argTargeting(functionDescription, nbrArgSupplied) {
    const valueIndexToArgPosition = {};
    const groupsOfRepeatingValues = functionDescription.nbrArgRepeating
        ? Math.floor((nbrArgSupplied - functionDescription.minArgRequired) / functionDescription.nbrArgRepeating)
        : 0;
    const nbrValueRepeating = functionDescription.nbrArgRepeating * groupsOfRepeatingValues;
    const nbrValueOptional = nbrArgSupplied - functionDescription.minArgRequired - nbrValueRepeating;
    let countValueSupplied = 0;
    let countValueOptional = 0;
    for (let i = 0; i < functionDescription.args.length; i++) {
        const arg = functionDescription.args[i];
        if (arg.optional || arg.default) {
            if (countValueOptional < nbrValueOptional) {
                valueIndexToArgPosition[countValueSupplied] = i;
                countValueSupplied++;
            }
            countValueOptional++;
            continue;
        }
        if (arg.repeating) {
            // As we know all repeating arguments are consecutive,
            // --> we will treat all repeating arguments in one go
            // --> the index i will be incremented by the number of repeating values at the end of the loop
            for (let j = 0; j < groupsOfRepeatingValues; j++) {
                for (let k = 0; k < functionDescription.nbrArgRepeating; k++) {
                    valueIndexToArgPosition[countValueSupplied] = i + k;
                    countValueSupplied++;
                }
            }
            i += functionDescription.nbrArgRepeating - 1;
            continue;
        }
        // End case: it's a required argument
        valueIndexToArgPosition[countValueSupplied] = i;
        countValueSupplied++;
    }
    return (argPosition) => {
        return valueIndexToArgPosition[argPosition];
    };
}
//------------------------------------------------------------------------------
// Argument validation
//------------------------------------------------------------------------------
const META_TYPES = ["META", "RANGE<META>"];
function validateArguments(descr) {
    if (descr.nbrArgRepeating && descr.nbrArgOptional >= descr.nbrArgRepeating) {
        throw new Error(`Function ${descr.name} has more optional arguments than repeatable ones.`);
    }
    let foundRepeating = false;
    let consecutiveRepeating = false;
    for (const current of descr.args) {
        if (current.type.some((t) => META_TYPES.includes(t)) &&
            current.type.some((t) => !META_TYPES.includes(t))) {
            throw new Error(`Function ${descr.name} has a mix of META and non-META types in the same argument: ${current.type}.`);
        }
        if (current.repeating) {
            if (!consecutiveRepeating && foundRepeating) {
                throw new Error(`Function ${descr.name} has non-consecutive repeating arguments. All repeating arguments must be declared consecutively.`);
            }
            foundRepeating = true;
            consecutiveRepeating = true;
        }
        else {
            consecutiveRepeating = false;
        }
    }
}

const defaultTranslate = (s) => s;
const defaultLoaded = () => false;
let _translate = defaultTranslate;
let _loaded = defaultLoaded;
function sprintf$1(s, ...values) {
    if (values.length === 1 && typeof values[0] === "object" && !(values[0] instanceof String)) {
        const valuesDict = values[0];
        s = s.replace(/\%\(([^\)]+)\)s/g, (match, value) => valuesDict[value]);
    }
    else if (values.length > 0) {
        s = s.replace(/\%s/g, () => values.shift());
    }
    return s;
}
/***
 * Allow to inject a translation function from outside o-spreadsheet. This should be called before instantiating
 * a model.
 * @param tfn the function that will do the translation
 * @param loaded a function that returns true when the translation is loaded
 */
function setTranslationMethod(tfn, loaded = () => true) {
    _translate = tfn;
    _loaded = loaded;
}
/**
 * If no translation function has been set, this will mark the translation are loaded.
 *
 * By default, the translations should not be set as loaded, otherwise top-level translated constants will never be
 * translated. But if by the time the model is instantiated no custom translation function has been set, we can set
 * the default translation function as loaded so o-spreadsheet can be run in standalone with no translations.
 */
function setDefaultTranslationMethod() {
    if (_translate === defaultTranslate && _loaded === defaultLoaded) {
        _loaded = () => true;
    }
}
const _t$1 = function (s, ...values) {
    if (!_loaded()) {
        return new LazyTranslatedString$1(s, values);
    }
    return sprintf$1(_translate(s), ...values);
};
let LazyTranslatedString$1 = class LazyTranslatedString extends String {
    values;
    constructor(str, values) {
        super(str);
        this.values = values;
    }
    valueOf() {
        const str = super.valueOf();
        return _loaded() ? sprintf$1(_translate(str), ...this.values) : sprintf$1(str, ...this.values);
    }
    toString() {
        return this.valueOf();
    }
};

const CellErrorType$1 = {
    NotAvailable: "#N/A",
    InvalidReference: "#REF",
    BadExpression: "#BAD_EXPR",
    CircularDependency: "#CYCLE",
    UnknownFunction: "#NAME?",
    DivisionByZero: "#DIV/0!",
    SpilledBlocked: "#SPILL!",
    GenericError: "#ERROR",
    NullError: "#NULL!",
};
const errorTypes = new Set(Object.values(CellErrorType$1));
class EvaluationError {
    message;
    value;
    constructor(message = _t$1("Error"), value = CellErrorType$1.GenericError) {
        this.message = message;
        this.value = value;
        this.message = message.toString();
    }
}
class BadExpressionError extends EvaluationError {
    constructor(message = _t$1("Invalid expression")) {
        super(message, CellErrorType$1.BadExpression);
    }
}
class CircularDependencyError extends EvaluationError {
    constructor(message = _t$1("Circular reference")) {
        super(message, CellErrorType$1.CircularDependency);
    }
}
class InvalidReferenceError extends EvaluationError {
    constructor(message = _t$1("Invalid reference")) {
        super(message, CellErrorType$1.InvalidReference);
    }
}
class NotAvailableError extends EvaluationError {
    constructor(message = _t$1("Data not available")) {
        super(message, CellErrorType$1.NotAvailable);
    }
}
class UnknownFunctionError extends EvaluationError {
    constructor(message = _t$1("Unknown function")) {
        super(message, CellErrorType$1.UnknownFunction);
    }
}
class SplillBlockedError extends EvaluationError {
    constructor(message = _t$1("Spill range is not empty")) {
        super(message, CellErrorType$1.SpilledBlocked);
    }
}
class DivisionByZeroError extends EvaluationError {
    constructor(message = _t$1("Division by zero")) {
        super(message, CellErrorType$1.DivisionByZero);
    }
}

const borderStyles = ["thin", "medium", "thick", "dashed", "dotted"];
function isMatrix(x) {
    return Array.isArray(x) && Array.isArray(x[0]);
}
var DIRECTION$1;
(function (DIRECTION) {
    DIRECTION["UP"] = "up";
    DIRECTION["DOWN"] = "down";
    DIRECTION["LEFT"] = "left";
    DIRECTION["RIGHT"] = "right";
})(DIRECTION$1 || (DIRECTION$1 = {}));

// -----------------------------------------------------------------------------
// Date Type
// -----------------------------------------------------------------------------
/**
 * A DateTime object that can be used to manipulate spreadsheet dates.
 * Conceptually, a spreadsheet date is simply a number with a date format,
 * and it is timezone-agnostic.
 * This DateTime object consistently uses UTC time to represent a naive date and time.
 */
let DateTime$1 = class DateTime {
    jsDate;
    constructor(year, month, day, hours = 0, minutes = 0, seconds = 0) {
        this.jsDate = new Date(Date.UTC(year, month, day, hours, minutes, seconds, 0));
    }
    static fromTimestamp(timestamp) {
        const date = new Date(timestamp);
        return new DateTime(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds());
    }
    static now() {
        const now = new Date();
        return new DateTime(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), now.getSeconds());
    }
    toString() {
        return this.jsDate.toString();
    }
    toLocaleDateString() {
        return this.jsDate.toLocaleDateString();
    }
    getTime() {
        return this.jsDate.getTime();
    }
    getFullYear() {
        return this.jsDate.getUTCFullYear();
    }
    getMonth() {
        return this.jsDate.getUTCMonth();
    }
    getQuarter() {
        return Math.floor(this.getMonth() / 3) + 1;
    }
    getDate() {
        return this.jsDate.getUTCDate();
    }
    getDay() {
        return this.jsDate.getUTCDay();
    }
    getHours() {
        return this.jsDate.getUTCHours();
    }
    getMinutes() {
        return this.jsDate.getUTCMinutes();
    }
    getSeconds() {
        return this.jsDate.getUTCSeconds();
    }
    getIsoWeek() {
        const date = new Date(this.jsDate.getTime());
        const dayNumber = date.getUTCDay() || 7;
        date.setUTCDate(date.getUTCDate() + 4 - dayNumber);
        const yearStart = new Date(Date.UTC(date.getUTCFullYear(), 0, 1));
        return Math.ceil(((date.getTime() - yearStart.getTime()) / 86400000 + 1) / 7);
    }
    setFullYear(year) {
        return this.jsDate.setUTCFullYear(year);
    }
    setMonth(month) {
        return this.jsDate.setUTCMonth(month);
    }
    setDate(date) {
        return this.jsDate.setUTCDate(date);
    }
    setHours(hours) {
        return this.jsDate.setUTCHours(hours);
    }
    setMinutes(minutes) {
        return this.jsDate.setUTCMinutes(minutes);
    }
    setSeconds(seconds) {
        return this.jsDate.setUTCSeconds(seconds);
    }
};
// -----------------------------------------------------------------------------
// Parsing
// -----------------------------------------------------------------------------
const INITIAL_1900_DAY$1 = new DateTime$1(1899, 11, 30);
const MS_PER_DAY$1 = 24 * 60 * 60 * 1000;
const CURRENT_MILLENIAL = 2000; // note: don't forget to update this in 2999
const CURRENT_YEAR = DateTime$1.now().getFullYear();
const CURRENT_MONTH = DateTime$1.now().getMonth();
const INITIAL_JS_DAY$1 = DateTime$1.fromTimestamp(0);
const DATE_JS_1900_OFFSET$1 = INITIAL_JS_DAY$1.getTime() - INITIAL_1900_DAY$1.getTime();
const mdyDateRegexp = /^\d{1,2}(\/|-|\s)\d{1,2}((\/|-|\s)\d{1,4})?$/;
const ymdDateRegexp = /^\d{3,4}(\/|-|\s)\d{1,2}(\/|-|\s)\d{1,2}$/;
const whiteSpaceChars = whiteSpaceCharacters.join("");
const dateSeparatorsRegex = new RegExp(`\/|-|${whiteSpaceCharacters.join("|")}`);
const dateRegexp = new RegExp(`^(\\d{1,4})[\/${whiteSpaceChars}\-](\\d{1,4})([\/${whiteSpaceChars}\-](\\d{1,4}))?$`);
const timeRegexp = /((\d+(:\d+)?(:\d+)?\s*(AM|PM))|(\d+:\d+(:\d+)?))$/;
/** Convert a value number representing a date, or return undefined if it isn't possible */
function valueToDateNumber(value, locale) {
    switch (typeof value) {
        case "number":
            return value;
        case "string":
            if (isDateTime(value, locale)) {
                return parseDateTime(value, locale)?.value;
            }
            return !value || isNaN(Number(value)) ? undefined : Number(value);
        default:
            return undefined;
    }
}
function isDateTime(str, locale) {
    return parseDateTime(str, locale) !== null;
}
const CACHE = new Map();
function parseDateTime(str, locale) {
    if (!CACHE.has(locale)) {
        CACHE.set(locale, new Map());
    }
    if (!CACHE.get(locale).has(str)) {
        CACHE.get(locale).set(str, _parseDateTime(str, locale));
    }
    return CACHE.get(locale).get(str);
}
function _parseDateTime(str, locale) {
    str = str.trim();
    let time = null;
    const timeMatch = str.match(timeRegexp);
    if (timeMatch) {
        time = parseTime(timeMatch[0]);
        if (time === null) {
            return null;
        }
        str = str.replace(timeMatch[0], "").trim();
    }
    let date = null;
    const dateParts = getDateParts(str, locale);
    if (dateParts) {
        const separator = dateParts.dateString.match(dateSeparatorsRegex)[0];
        date = parseDate(dateParts, separator);
        if (date === null) {
            return null;
        }
        str = str.replace(dateParts.dateString, "").trim();
    }
    if (str !== "" || !(date || time)) {
        return null;
    }
    if (date && date.jsDate && time && time.jsDate) {
        return {
            value: date.value + time.value,
            format: date.format + " " + (time.format === "hhhh:mm:ss" ? "hh:mm:ss" : time.format),
            jsDate: new DateTime$1(date.jsDate.getFullYear() + time.jsDate.getFullYear() - 1899, date.jsDate.getMonth() + time.jsDate.getMonth() - 11, date.jsDate.getDate() + time.jsDate.getDate() - 30, date.jsDate.getHours() + time.jsDate.getHours(), date.jsDate.getMinutes() + time.jsDate.getMinutes(), date.jsDate.getSeconds() + time.jsDate.getSeconds()),
        };
    }
    return date || time;
}
/**
 * Returns the parts (day/month/year) of a date string corresponding to the given locale.
 *
 * - A string "xxxx-xx-xx" will be parsed as "y-m-d" no matter the locale.
 * - A string "xx-xx-xxxx" will be parsed as "m-d-y" for mdy locale, and "d-m-y" for ymd and dmy locales.
 * - A string "xx-xx-xx" will be "y-m-d" for ymd locale, "d-m-y" for dmy locale, "m-d-y" for mdy locale.
 * - A string "xxxx-xx" will be parsed as "y-m" no matter the locale.
 * - A string "xx-xx" will be parsed as "m-d" for mdy and ymd locales, and "d-m" for dmy locale.
 */
function getDateParts(dateString, locale) {
    const match = dateString.match(dateRegexp);
    if (!match) {
        return null;
    }
    const [, part1, part2, , part3] = match;
    if (part1.length > 2 && part3 && part3.length > 2) {
        return null;
    }
    if (part1.length > 2) {
        return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
    }
    const localeDateType = getLocaleDateFormatType(locale);
    if (!part3) {
        if (part2.length > 2) {
            // e.g. 11/2023
            return { month: part1, year: part2, day: undefined, dateString, type: localeDateType };
        }
        if (localeDateType === "dmy") {
            return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
        }
        return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
    }
    if (part3.length > 2) {
        if (localeDateType === "mdy") {
            return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
        }
        return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
    }
    if (localeDateType === "mdy") {
        return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
    }
    if (localeDateType === "ymd") {
        return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
    }
    if (localeDateType === "dmy") {
        return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
    }
    return null;
}
function getLocaleDateFormatType(locale) {
    switch (locale.dateFormat[0]) {
        case "d":
            return "dmy";
        case "m":
            return "mdy";
        case "y":
            return "ymd";
    }
    throw new Error("Invalid date format in locale");
}
function parseDate(parts, separator) {
    const { year: yearStr, month: monthStr, day: dayStr } = parts;
    const month = inferMonth(monthStr);
    const day = inferDay(dayStr);
    const year = inferYear(yearStr);
    if (year === null || month === null || day === null) {
        return null;
    }
    // month + 1: months are 0-indexed in JS
    const leadingZero = (monthStr?.length === 2 && month + 1 < 10) || (dayStr?.length === 2 && day < 10);
    const fullYear = yearStr?.length !== 2;
    const jsDate = new DateTime$1(year, month, day);
    if (jsDate.getMonth() !== month || jsDate.getDate() !== day) {
        // invalid date
        return null;
    }
    const delta = jsDate.getTime() - INITIAL_1900_DAY$1.getTime();
    const format = getFormatFromDateParts(parts, separator, leadingZero, fullYear);
    return {
        value: Math.round(delta / MS_PER_DAY$1),
        format: format,
        jsDate,
    };
}
function getFormatFromDateParts(parts, sep, leadingZero, fullYear) {
    const yearFmt = parts.year ? (fullYear ? "yyyy" : "yy") : undefined;
    const monthFmt = parts.month ? (leadingZero ? "mm" : "m") : undefined;
    const dayFmt = parts.day ? (leadingZero ? "dd" : "d") : undefined;
    switch (parts.type) {
        case "mdy":
            return [monthFmt, dayFmt, yearFmt].filter(isDefined$1).join(sep);
        case "ymd":
            return [yearFmt, monthFmt, dayFmt].filter(isDefined$1).join(sep);
        case "dmy":
            return [dayFmt, monthFmt, yearFmt].filter(isDefined$1).join(sep);
    }
}
function inferYear(yearStr) {
    if (!yearStr) {
        return CURRENT_YEAR;
    }
    const nbr = Number(yearStr);
    switch (yearStr.length) {
        case 1:
            return CURRENT_MILLENIAL + nbr;
        case 2:
            const offset = CURRENT_MILLENIAL + nbr > CURRENT_YEAR + 10 ? -100 : 0;
            const base = CURRENT_MILLENIAL + offset;
            return base + nbr;
        case 3:
        case 4:
            return nbr;
    }
    return null;
}
function inferMonth(monthStr) {
    if (!monthStr) {
        return CURRENT_MONTH;
    }
    const nbr = Number(monthStr);
    if (nbr >= 1 && nbr <= 12) {
        return nbr - 1;
    }
    return null;
}
function inferDay(dayStr) {
    if (!dayStr) {
        return 1;
    }
    const nbr = Number(dayStr);
    if (nbr >= 0 && nbr <= 31) {
        return nbr;
    }
    return null;
}
function parseTime(str) {
    str = str.trim();
    if (timeRegexp.test(str)) {
        const isAM = /AM/i.test(str);
        const isPM = /PM/i.test(str);
        const strTime = isAM || isPM ? str.substring(0, str.length - 2).trim() : str;
        const parts = strTime.split(/:/);
        const isMinutes = parts.length >= 2;
        const isSeconds = parts.length === 3;
        let hours = Number(parts[0]);
        let minutes = isMinutes ? Number(parts[1]) : 0;
        let seconds = isSeconds ? Number(parts[2]) : 0;
        let format = isSeconds ? "hh:mm:ss" : "hh:mm";
        if (isAM || isPM) {
            format += " a";
        }
        else if (!isMinutes) {
            return null;
        }
        if (hours >= 12 && isAM) {
            hours -= 12;
        }
        else if (hours < 12 && isPM) {
            hours += 12;
        }
        minutes += Math.floor(seconds / 60);
        seconds %= 60;
        hours += Math.floor(minutes / 60);
        minutes %= 60;
        if (hours >= 24) {
            format = "hhhh:mm:ss";
        }
        const jsDate = new DateTime$1(1899, 11, 30, hours, minutes, seconds);
        return {
            value: hours / 24 + minutes / 1440 + seconds / 86400,
            format: format,
            jsDate: jsDate,
        };
    }
    return null;
}
// -----------------------------------------------------------------------------
// Conversion
// -----------------------------------------------------------------------------
function numberToJsDate$1(value) {
    const truncValue = Math.trunc(value);
    const date = DateTime$1.fromTimestamp(truncValue * MS_PER_DAY$1 - DATE_JS_1900_OFFSET$1);
    let time = value - truncValue;
    time = time < 0 ? 1 + time : time;
    const hours = Math.round(time * 24);
    const minutes = Math.round((time - hours / 24) * 24 * 60);
    const seconds = Math.round((time - hours / 24 - minutes / 24 / 60) * 24 * 60 * 60);
    date.setHours(hours);
    date.setMinutes(minutes);
    date.setSeconds(seconds);
    return date;
}
function jsDateToRoundNumber(date) {
    return Math.round(jsDateToNumber(date));
}
function jsDateToNumber(date) {
    const delta = date.getTime() - INITIAL_1900_DAY$1.getTime();
    return delta / MS_PER_DAY$1;
}
/** Return the number of days in the current month of the given date */
function getDaysInMonth(date) {
    return new DateTime$1(date.getFullYear(), date.getMonth() + 1, 0).getDate();
}
function isLastDayOfMonth(date) {
    return getDaysInMonth(date) === date.getDate();
}
/**
 * Add a certain number of months to a date. This will adapt the month number, and possibly adapt
 * the day of the month to keep it in the month.
 *
 * For example "31/12/2020" minus one month will be "30/11/2020", and not "31/11/2020"
 *
 * @param keepEndOfMonth if true, if the given date was the last day of a month, the returned date will
 *          also always be the last day of a month.
 */
function addMonthsToDate(date, months, keepEndOfMonth) {
    const yStart = date.getFullYear();
    const mStart = date.getMonth();
    const dStart = date.getDate();
    const jsDate = new DateTime$1(yStart, mStart + months, 1);
    if (keepEndOfMonth && dStart === getDaysInMonth(date)) {
        jsDate.setDate(getDaysInMonth(jsDate));
    }
    else if (dStart > getDaysInMonth(jsDate)) {
        // 31/03 minus one month should be 28/02, not 31/02
        jsDate.setDate(getDaysInMonth(jsDate));
    }
    else {
        jsDate.setDate(dStart);
    }
    return jsDate;
}
function isLeapYear(year) {
    const _year = Math.trunc(year);
    return (_year % 4 === 0 && _year % 100 !== 0) || _year % 400 === 0;
}
function getYearFrac(startDate, endDate, _dayCountConvention) {
    if (startDate === endDate) {
        return 0;
    }
    if (startDate > endDate) {
        const stack = endDate;
        endDate = startDate;
        startDate = stack;
    }
    const jsStartDate = numberToJsDate$1(startDate);
    const jsEndDate = numberToJsDate$1(endDate);
    let dayStart = jsStartDate.getDate();
    let dayEnd = jsEndDate.getDate();
    const monthStart = jsStartDate.getMonth(); // january is 0
    const monthEnd = jsEndDate.getMonth(); // january is 0
    const yearStart = jsStartDate.getFullYear();
    const yearEnd = jsEndDate.getFullYear();
    let yearsStart = 0;
    let yearsEnd = 0;
    switch (_dayCountConvention) {
        // 30/360 US convention --------------------------------------------------
        case 0:
            if (dayStart === 31)
                dayStart = 30;
            if (dayStart === 30 && dayEnd === 31)
                dayEnd = 30;
            // If jsStartDate is the last day of February
            if (monthStart === 1 && dayStart === (isLeapYear(yearStart) ? 29 : 28)) {
                dayStart = 30;
                // If jsEndDate is the last day of February
                if (monthEnd === 1 && dayEnd === (isLeapYear(yearEnd) ? 29 : 28)) {
                    dayEnd = 30;
                }
            }
            yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
            yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
            break;
        // actual/actual convention ----------------------------------------------
        case 1:
            let daysInYear = 365;
            const isSameYear = yearStart === yearEnd;
            const isOneDeltaYear = yearStart + 1 === yearEnd;
            const isMonthEndBigger = monthStart < monthEnd;
            const isSameMonth = monthStart === monthEnd;
            const isDayEndBigger = dayStart < dayEnd;
            // |-----|  <-- one Year
            // 'A' is start date
            // 'B' is end date
            if ((!isSameYear && !isOneDeltaYear) ||
                (!isSameYear && isMonthEndBigger) ||
                (!isSameYear && isSameMonth && isDayEndBigger)) {
                // |---A-|-----|-B---|  <-- !isSameYear && !isOneDeltaYear
                // |---A-|----B|-----|  <-- !isSameYear && isMonthEndBigger
                // |---A-|---B-|-----|  <-- !isSameYear && isSameMonth && isDayEndBigger
                let countYears = 0;
                let countDaysInYears = 0;
                for (let y = yearStart; y <= yearEnd; y++) {
                    countYears++;
                    countDaysInYears += isLeapYear(y) ? 366 : 365;
                }
                daysInYear = countDaysInYears / countYears;
            }
            else if (!isSameYear) {
                // |-AF--|B----|-----|
                if (isLeapYear(yearStart) && monthStart < 2) {
                    daysInYear = 366;
                }
                // |--A--|FB---|-----|
                if (isLeapYear(yearEnd) && (monthEnd > 1 || (monthEnd === 1 && dayEnd === 29))) {
                    daysInYear = 366;
                }
            }
            else {
                // remaining cases:
                //
                // |-F-AB|-----|-----|
                // |AB-F-|-----|-----|
                // |A-F-B|-----|-----|
                // if February 29 occurs between date1 (exclusive) and date2 (inclusive)
                // daysInYear --> 366
                if (isLeapYear(yearStart)) {
                    daysInYear = 366;
                }
            }
            yearsStart = startDate / daysInYear;
            yearsEnd = endDate / daysInYear;
            break;
        // actual/360 convention -------------------------------------------------
        case 2:
            yearsStart = startDate / 360;
            yearsEnd = endDate / 360;
            break;
        // actual/365 convention -------------------------------------------------
        case 3:
            yearsStart = startDate / 365;
            yearsEnd = endDate / 365;
            break;
        // 30/360 European convention --------------------------------------------
        case 4:
            if (dayStart === 31)
                dayStart = 30;
            if (dayEnd === 31)
                dayEnd = 30;
            yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
            yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
            break;
    }
    return yearsEnd - yearsStart;
}
/**
 * Get the number of whole months between two dates.
 * e.g.
 *  2002/01/01 -> 2002/02/01 = 1 month,
 *  2002/01/01 -> 2003/02/01 = 13 months
 * @param startDate
 * @param endDate
 * @returns
 */
function getTimeDifferenceInWholeMonths(startDate, endDate) {
    const months = (endDate.getFullYear() - startDate.getFullYear()) * 12 +
        endDate.getMonth() -
        startDate.getMonth();
    return startDate.getDate() > endDate.getDate() ? months - 1 : months;
}
function getTimeDifferenceInWholeDays(startDate, endDate) {
    const startUtc = startDate.getTime();
    const endUtc = endDate.getTime();
    return Math.floor((endUtc - startUtc) / MS_PER_DAY$1);
}
function getTimeDifferenceInWholeYears(startDate, endDate) {
    const years = endDate.getFullYear() - startDate.getFullYear();
    const monthStart = startDate.getMonth();
    const monthEnd = endDate.getMonth();
    const dateStart = startDate.getDate();
    const dateEnd = endDate.getDate();
    const isEndMonthDateBigger = monthEnd > monthStart || (monthEnd === monthStart && dateEnd >= dateStart);
    return isEndMonthDateBigger ? years : years - 1;
}
function areTwoDatesWithinOneYear(startDate, endDate) {
    return getYearFrac(startDate, endDate, 1) < 1;
}
function areDatesSameDay(startDate, endDate) {
    return Math.trunc(startDate) === Math.trunc(endDate);
}
function isDateBetween(date, startDate, endDate) {
    if (startDate > endDate) {
        return isDateBetween(date, endDate, startDate);
    }
    date = Math.trunc(date);
    startDate = Math.trunc(startDate);
    endDate = Math.trunc(endDate);
    return date >= startDate && date <= endDate;
}
/** Check if the first date is strictly before the second date */
function isDateStrictlyBefore(date, dateBefore) {
    return Math.trunc(date) < Math.trunc(dateBefore);
}
/** Check if the first date is before or equal to the second date */
function isDateBefore(date, dateBefore) {
    return Math.trunc(date) <= Math.trunc(dateBefore);
}
/** Check if the first date is strictly after the second date */
function isDateStrictlyAfter(date, dateAfter) {
    return Math.trunc(date) > Math.trunc(dateAfter);
}
/** Check if the first date is after or equal to the second date */
function isDateAfter(date, dateAfter) {
    return Math.trunc(date) >= Math.trunc(dateAfter);
}

/**
 * This function returns a regexp that is supposed to be as close as possible as the numberRegexp,
 * but its purpose is to be used by the tokenizer.
 *
 * - it tolerates extra characters at the end. This is useful because the tokenizer
 *   only needs to find the number at the start of a string
 * - it does not support % symbol, in formulas % is an operator
 */
const getFormulaNumberRegex = memoize$1(function getFormulaNumberRegex(decimalSeparator) {
    decimalSeparator = escapeRegExp$1(decimalSeparator);
    return new RegExp(`(?:^-?\\d+(?:${decimalSeparator}?\\d*(?:e(\\+|-)?\\d+)?)?|^-?${decimalSeparator}\\d+)(?!\\w|!)`);
});
const getNumberRegex = memoize$1(function getNumberRegex(locale) {
    const decimalSeparator = escapeRegExp$1(locale.decimalSeparator);
    const thousandsSeparator = escapeRegExp$1(locale.thousandsSeparator || "");
    const pIntegerAndDecimals = `(?:\\d+(?:${thousandsSeparator}\\d{3,})*(?:${decimalSeparator}\\d*)?)`; // pattern that match integer number with or without decimal digits
    const pOnlyDecimals = `(?:${decimalSeparator}\\d+)`; // pattern that match only expression with decimal digits
    const pScientificFormat = "(?:e(?:\\+|-)?\\d+)?"; // pattern that match scientific format between zero and one time (should be placed before pPercentFormat)
    const pPercentFormat = "(?:\\s*%)?"; // pattern that match percent symbol between zero and one time
    const pNumber = "(?:\\s*" +
        pIntegerAndDecimals +
        "|" +
        pOnlyDecimals +
        ")" +
        pScientificFormat +
        pPercentFormat;
    const pMinus = "(?:\\s*-)?"; // pattern that match negative symbol between zero and one time
    const pCurrencyFormat = "(?:\\s*[\\$€])?";
    const p1 = pMinus + pCurrencyFormat + pNumber;
    const p2 = pMinus + pNumber + pCurrencyFormat;
    const p3 = pCurrencyFormat + pMinus + pNumber;
    const pNumberExp = "^(?:(?:" + [p1, p2, p3].join(")|(?:") + "))$";
    return new RegExp(pNumberExp, "i");
});
/**
 * Return true if the argument is a "number string".
 *
 * Note that "" (empty string) does not count as a number string
 */
function isNumber(value, locale) {
    if (!value)
        return false;
    // TO DO: add regexp for DATE string format (ex match: "28 02 2020")
    return getNumberRegex(locale).test(value.trim());
}
const getInvaluableSymbolsRegexp = memoize$1(function getInvaluableSymbolsRegexp(locale) {
    return new RegExp(`[\$€${escapeRegExp$1(locale.thousandsSeparator || "")}]`, "g");
});
/**
 * Convert a string into a number. It assumes that the string actually represents
 * a number (as determined by the isNumber function)
 *
 * Note that it accepts "" (empty string), even though it does not count as a
 * number from the point of view of the isNumber function.
 */
function parseNumber(str, locale) {
    // remove invaluable characters
    str = str.replace(getInvaluableSymbolsRegexp(locale), "");
    if (locale.decimalSeparator !== ".") {
        str = str.replace(locale.decimalSeparator, ".");
    }
    let n = Number(str);
    if (isNaN(n) && str.includes("%")) {
        n = Number(str.split("%")[0]);
        if (!isNaN(n)) {
            return n / 100;
        }
    }
    return n;
}
function percentile(values, percent, isInclusive) {
    const sortedValues = [...values].sort((a, b) => a - b);
    let percentIndex = (sortedValues.length + (isInclusive ? -1 : 1)) * percent;
    if (!isInclusive) {
        percentIndex--;
    }
    if (Number.isInteger(percentIndex)) {
        return sortedValues[percentIndex];
    }
    const indexSup = Math.ceil(percentIndex);
    const indexLow = Math.floor(percentIndex);
    return (sortedValues[indexSup] * (percentIndex - indexLow) +
        sortedValues[indexLow] * (indexSup - percentIndex));
}

// HELPERS
const SORT_TYPES_ORDER = ["number", "string", "boolean", "undefined"];
function inferFormat(data) {
    if (data === undefined) {
        return undefined;
    }
    if (isMatrix(data)) {
        return data[0][0]?.format;
    }
    return data.format;
}
function isEvaluationError(error) {
    return typeof error === "string" && errorTypes.has(error);
}
function valueNotAvailable(searchKey) {
    return {
        value: CellErrorType$1.NotAvailable,
        message: _t$1("Did not find value '%s' in [[FUNCTION_NAME]] evaluation.", toString(searchKey)),
    };
}
// -----------------------------------------------------------------------------
// FORMAT FUNCTIONS
// -----------------------------------------------------------------------------
const expectNumberValueError = (value) => _t$1("The function [[FUNCTION_NAME]] expects a number value, but '%s' is a string, and cannot be coerced to a number.", value);
const expectNumberRangeError = (lowerBound, upperBound, value) => _t$1("The function [[FUNCTION_NAME]] expects a number value between %s and %s inclusive, but receives %s.", lowerBound.toString(), upperBound.toString(), value.toString());
const expectStringSetError = (stringSet, value) => {
    const stringSetString = stringSet.map((str) => `'${str}'`).join(", ");
    return _t$1("The function [[FUNCTION_NAME]] has an argument with value '%s'. It should be one of: %s.", value, stringSetString);
};
function toNumber(data, locale) {
    const value = toValue(data);
    switch (typeof value) {
        case "number":
            return value;
        case "boolean":
            return value ? 1 : 0;
        case "string":
            if (isNumber(value, locale) || value === "") {
                return parseNumber(value, locale);
            }
            const internalDate = parseDateTime(value, locale);
            if (internalDate) {
                return internalDate.value;
            }
            throw new EvaluationError(expectNumberValueError(value));
        default:
            return 0;
    }
}
function tryToNumber(value, locale) {
    try {
        return toNumber(value, locale);
    }
    catch (e) {
        return undefined;
    }
}
function toNumberMatrix(data, argName) {
    return toMatrix(data).map((row) => {
        return row.map((cell) => {
            if (typeof cell.value !== "number") {
                let message = "";
                if (typeof cell === "object") {
                    message = _t$1("Function [[FUNCTION_NAME]] expects number values for %s, but got an empty value.", argName);
                }
                else if (typeof cell === "string") {
                    message = _t$1("Function [[FUNCTION_NAME]] expects number values for %s, but got a string.", argName);
                }
                else if (typeof cell === "boolean") {
                    message = _t$1("Function [[FUNCTION_NAME]] expects number values for %s, but got a boolean.", argName);
                }
                throw new EvaluationError(message);
            }
            return cell.value;
        });
    });
}
function strictToNumber(data, locale) {
    const value = toValue(data);
    if (value === "") {
        throw new EvaluationError(expectNumberValueError(value));
    }
    return toNumber(value, locale);
}
function toInteger(value, locale) {
    return Math.trunc(toNumber(value, locale));
}
function strictToInteger(value, locale) {
    return Math.trunc(strictToNumber(value, locale));
}
function toString(data) {
    const value = toValue(data);
    switch (typeof value) {
        case "string":
            return value;
        case "number":
            return value.toString();
        case "boolean":
            return value ? "TRUE" : "FALSE";
        default:
            return "";
    }
}
/** Normalize string by setting it to lowercase and replacing accent letters with plain letters */
const normalizeString = memoize$1(function normalizeString(str) {
    return str
        .toLowerCase()
        .normalize("NFD")
        .replace(/[\u0300-\u036f]/g, "");
});
const expectBooleanValueError = (value) => _t$1("The function [[FUNCTION_NAME]] expects a boolean value, but '%s' is a text, and cannot be coerced to a boolean.", value);
function toBoolean(data) {
    const value = toValue(data);
    switch (typeof value) {
        case "boolean":
            return value;
        case "string":
            if (value) {
                const uppercaseVal = value.toUpperCase();
                if (uppercaseVal === "TRUE") {
                    return true;
                }
                if (uppercaseVal === "FALSE") {
                    return false;
                }
                throw new EvaluationError(expectBooleanValueError(value));
            }
            else {
                return false;
            }
        case "number":
            return value ? true : false;
        default:
            return false;
    }
}
function strictToBoolean(data) {
    const value = toValue(data);
    if (value === "") {
        throw new EvaluationError(expectBooleanValueError(value));
    }
    return toBoolean(value);
}
function toJsDate(data, locale) {
    const value = toValue(data);
    return numberToJsDate$1(toNumber(value, locale));
}
function toValue(data) {
    if (typeof data === "object" && data !== null && "value" in data) {
        if (isEvaluationError(data.value)) {
            throw data;
        }
        return data.value;
    }
    if (isEvaluationError(data)) {
        throw new EvaluationError("", data);
    }
    return data;
}
// -----------------------------------------------------------------------------
// VISIT FUNCTIONS
// -----------------------------------------------------------------------------
function visitArgs(args, cellCb, dataCb) {
    for (const arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const lenRow = arg.length;
            const lenCol = arg[0].length;
            for (let y = 0; y < lenCol; y++) {
                for (let x = 0; x < lenRow; x++) {
                    cellCb(arg[x][y]);
                }
            }
        }
        else {
            // arg is set directly in the formula function
            dataCb(arg);
        }
    }
}
function visitAny(args, cb) {
    visitArgs(args, (cell) => {
        if (isEvaluationError(cell.value)) {
            throw cell;
        }
        cb(cell);
    }, (arg) => {
        if (isEvaluationError(arg?.value)) {
            throw arg;
        }
        cb(arg);
    });
}
function visitNumbers(args, cb, locale) {
    visitArgs(args, (cell) => {
        if (typeof cell?.value === "number") {
            cb(cell);
        }
        if (isEvaluationError(cell?.value)) {
            throw cell;
        }
    }, (arg) => {
        cb({ value: strictToNumber(arg, locale), format: arg?.format });
    });
}
// -----------------------------------------------------------------------------
// REDUCE FUNCTIONS
// -----------------------------------------------------------------------------
function reduceArgs(args, cellCb, dataCb, initialValue, dir = "rowFirst") {
    let val = initialValue;
    for (const arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const numberOfCols = arg.length;
            const numberOfRows = arg[0].length;
            if (dir === "rowFirst") {
                for (let row = 0; row < numberOfRows; row++) {
                    for (let col = 0; col < numberOfCols; col++) {
                        val = cellCb(val, arg[col][row]);
                    }
                }
            }
            else {
                for (let col = 0; col < numberOfCols; col++) {
                    for (let row = 0; row < numberOfRows; row++) {
                        val = cellCb(val, arg[col][row]);
                    }
                }
            }
        }
        else {
            // arg is set directly in the formula function
            val = dataCb(val, arg);
        }
    }
    return val;
}
function reduceAny(args, cb, initialValue, dir = "rowFirst") {
    return reduceArgs(args, cb, cb, initialValue, dir);
}
function reduceNumbers(args, cb, initialValue, locale) {
    return reduceArgs(args, (acc, arg) => {
        const argValue = arg?.value;
        if (typeof argValue === "number") {
            return cb(acc, argValue);
        }
        else if (isEvaluationError(argValue)) {
            throw arg;
        }
        return acc;
    }, (acc, arg) => {
        return cb(acc, strictToNumber(arg, locale));
    }, initialValue);
}
function reduceNumbersTextAs0(args, cb, initialValue, locale) {
    return reduceArgs(args, (acc, arg) => {
        const argValue = arg?.value;
        if (argValue !== undefined && argValue !== null) {
            if (typeof argValue === "number") {
                return cb(acc, argValue);
            }
            else if (typeof argValue === "boolean") {
                return cb(acc, toNumber(argValue, locale));
            }
            else if (isEvaluationError(argValue)) {
                throw arg;
            }
            else {
                return cb(acc, 0);
            }
        }
        return acc;
    }, (acc, arg) => {
        return cb(acc, toNumber(arg, locale));
    }, initialValue);
}
// -----------------------------------------------------------------------------
// MATRIX FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * Generate a matrix of size nColumns x nRows and apply a callback on each position
 */
function generateMatrix(nColumns, nRows, callback) {
    const returned = Array(nColumns);
    for (let col = 0; col < nColumns; col++) {
        returned[col] = Array(nRows);
        for (let row = 0; row < nRows; row++) {
            returned[col][row] = callback(col, row);
        }
    }
    return returned;
}
function matrixMap(matrix, callback) {
    if (matrix.length === 0) {
        return [];
    }
    return generateMatrix(matrix.length, matrix[0].length, (col, row) => callback(matrix[col][row]));
}
function matrixForEach(matrix, fn) {
    const numberOfCols = matrix.length;
    const numberOfRows = matrix[0]?.length ?? 0;
    for (let col = 0; col < numberOfCols; col++) {
        for (let row = 0; row < numberOfRows; row++) {
            fn(matrix[col][row]);
        }
    }
}
function transposeMatrix(matrix) {
    if (!matrix.length) {
        return [];
    }
    return generateMatrix(matrix[0].length, matrix.length, (i, j) => matrix[j][i]);
}
/**
 * Enables a formula function to accept matrix or vector inputs instead of simple value, computing results across multiple dimensions.
 *
 * ```
 *                    /         |‾                 ‾| \        |‾                                                    ‾|
 *                   |          | [A]               |  |       | compute(A, D, E), compute(A, D, F), compute(A, D, G) |
 * applyVectorization| compute, | [B], D, [E, F, G] |  |  <=>  | compute(B, D, E), compute(B, D, F), compute(B, D, G) |
 *                   |          | [C]               |  |       | compute(C, D, E), compute(C, D, F), compute(C, D, G) |
 *                    \         |_                 _| /        |_                                                    _|
 * ```
 *
 * By default, all arguments are vectorized. To control which arguments are vectorized,
 * pass an `acceptToVectorize` boolean array of the same length as `args`:
 * - `true`  enables vectorization for that argument
 * - `false` disables vectorization for that argument
 *
 * For example, with `[true, true, false]` on previous example you get:
 *
 * ```
 * |‾                        ‾|
 * | compute(A, D, [E, F, G]) |
 * | compute(B, D, [E, F, G]) |
 * | compute(C, D, [E, F, G]) |
 * |_                        _|
 * ```
 *
 * @remarks
 * This helper is automatically applied (by default) to **all** `compute` functions
 * across the various spreadsheet formula modules:
 * - If an argument is declared **scalar** (not `"range"`), it is vectorized.
 * - If **all** arguments are declared **ranges**, no vectorization occurs.
 *   - e.g. `SUM(A1:B2)` returns a 1×1 sum over the range.
 *   - e.g. `COS(A1:B2)` over `A1:B2` returns a 2×2 element-wise result.
 * - For special behaviors (e.g. the `IF` function), you may declare all arguments
 *   as ranges and invoke this helper directly within your `compute` implementation.
 */
function applyVectorization(formula, args, acceptToVectorize = undefined) {
    let countVectorizedCol = 1;
    let countVectorizedRow = 1;
    let vectorizedColLimit = Infinity;
    let vectorizedRowLimit = Infinity;
    let vectorArgsType = undefined;
    for (let i = 0; i < args.length; i++) {
        const arg = args[i];
        if (isMatrix(arg) && (acceptToVectorize === undefined || acceptToVectorize[i])) {
            const nColumns = arg.length;
            const nRows = arg[0].length;
            if (nColumns !== 1 || nRows !== 1) {
                vectorArgsType ??= new Array(args.length);
                if (nColumns !== 1 && nRows !== 1) {
                    vectorArgsType[i] = "matrix";
                    countVectorizedCol = Math.max(countVectorizedCol, nColumns);
                    countVectorizedRow = Math.max(countVectorizedRow, nRows);
                    vectorizedColLimit = Math.min(vectorizedColLimit, nColumns);
                    vectorizedRowLimit = Math.min(vectorizedRowLimit, nRows);
                }
                else if (nColumns !== 1) {
                    vectorArgsType[i] = "horizontal";
                    countVectorizedCol = Math.max(countVectorizedCol, nColumns);
                    vectorizedColLimit = Math.min(vectorizedColLimit, nColumns);
                }
                else if (nRows !== 1) {
                    vectorArgsType[i] = "vertical";
                    countVectorizedRow = Math.max(countVectorizedRow, nRows);
                    vectorizedRowLimit = Math.min(vectorizedRowLimit, nRows);
                }
            }
            else {
                args[i] = arg[0][0];
            }
        }
    }
    if (countVectorizedCol === 1 && countVectorizedRow === 1) {
        // either this function is not vectorized or it ends up with a 1x1 dimension
        return formula(...args);
    }
    const getArgOffset = (i, j) => args.map((arg, index) => {
        switch (vectorArgsType?.[index]) {
            case "matrix":
                return arg[i][j];
            case "horizontal":
                return arg[i][0];
            case "vertical":
                return arg[0][j];
            case undefined:
                return arg;
        }
    });
    return generateMatrix(countVectorizedCol, countVectorizedRow, (col, row) => {
        if (col > vectorizedColLimit - 1 || row > vectorizedRowLimit - 1) {
            return new NotAvailableError(_t$1("Array arguments to [[FUNCTION_NAME]] are of different size."));
        }
        const singleCellComputeResult = formula(...getArgOffset(col, row));
        // In the case where the user tries to vectorize arguments of an array formula, we will get an
        // array for every combination of the vectorized arguments, which will lead to a 3D matrix and
        // we won't be able to return the values.
        // In this case, we keep the first element of each spreading part, just as Excel does, and
        // create an array with these parts.
        // For exemple, we have MUNIT(x) that return an unitary matrix of x*x. If we use it with a
        // range, like MUNIT(A1:A2), we will get two unitary matrices (one for the value in A1 and one
        // for the value in A2). In this case, we will simply take the first value of each matrix and
        // return the array [First value of MUNIT(A1), First value of MUNIT(A2)].
        return isMatrix(singleCellComputeResult)
            ? singleCellComputeResult[0][0]
            : singleCellComputeResult;
    });
}
// -----------------------------------------------------------------------------
// CONDITIONAL EXPLORE FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * This function allows to visit arguments and stop the visit if necessary.
 * It is mainly used to bypass argument evaluation for functions like OR or AND.
 */
function conditionalVisitArgs(args, cellCb, dataCb) {
    for (const arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const lenRow = arg.length;
            const lenCol = arg[0].length;
            for (let y = 0; y < lenCol; y++) {
                for (let x = 0; x < lenRow; x++) {
                    if (!cellCb(arg[x][y] ?? undefined))
                        return;
                }
            }
        }
        else {
            // arg is set directly in the formula function
            if (!dataCb(arg))
                return;
        }
    }
}
function conditionalVisitBoolean(args, cb) {
    return conditionalVisitArgs(args, (arg) => {
        const argValue = arg?.value;
        if (typeof argValue === "boolean") {
            return cb(argValue);
        }
        if (typeof argValue === "number") {
            return cb(argValue ? true : false);
        }
        if (isEvaluationError(argValue)) {
            throw arg;
        }
        return true;
    }, (arg) => {
        if (arg !== undefined && arg.value !== null) {
            return cb(strictToBoolean(arg));
        }
        return true;
    });
}
function getPredicate(descr, locale) {
    let operator;
    let operand;
    let subString = descr.substring(0, 2);
    if (subString === "<=" || subString === ">=" || subString === "<>") {
        operator = subString;
        operand = descr.substring(2);
    }
    else {
        subString = descr.substring(0, 1);
        if (subString === "<" || subString === ">" || subString === "=") {
            operator = subString;
            operand = descr.substring(1);
        }
        else {
            operator = "=";
            operand = descr;
        }
    }
    if (isNumber(operand, locale) || isDateTime(operand, locale)) {
        operand = toNumber(operand, locale);
    }
    else if (operand === "TRUE" || operand === "FALSE") {
        operand = toBoolean(operand);
    }
    return { operator, operand };
}
/**
 * Converts a search string containing wildcard characters to a regular expression.
 *
 * The function iterates over each character in the input string. If the character is a wildcard
 * character ("?" or "*") and is not preceded by a "~", it is replaced by the corresponding regular
 * expression.
 * If the character is a special regular expression character, it is escaped with "\\".
 */
const wildcardToRegExp = memoize$1(function wildcardToRegExp(operand) {
    if (operand === "*") {
        return /.+/;
    }
    let exp = "";
    let predecessor = "";
    for (const char of operand) {
        if (char === "?" && predecessor !== "~") {
            exp += ".";
        }
        else if (char === "*" && predecessor !== "~") {
            exp += ".*";
        }
        else {
            if (char === "*" || char === "?") {
                //remove "~"
                exp = exp.slice(0, -1);
            }
            if (["^", ".", "[", "]", "$", "(", ")", "*", "+", "?", "|", "{", "}", "\\"].includes(char)) {
                exp += "\\";
            }
            exp += char;
        }
        predecessor = char;
    }
    return new RegExp("^" + exp + "$", "i");
});
function evaluatePredicate(value = "", criterion, locale) {
    const { operator, operand } = criterion;
    if (operand === undefined || value === null || operand === null) {
        return false;
    }
    if (typeof operand === "number" && operator === "=") {
        if (typeof value === "string" && (isNumber(value, locale) || isDateTime(value, locale))) {
            return toNumber(value, locale) === operand;
        }
        return value === operand;
    }
    if (operator === "<>" || operator === "=") {
        let result;
        if (typeof value === typeof operand) {
            if (typeof value === "string" && typeof operand === "string") {
                result = wildcardToRegExp(operand).test(value);
            }
            else {
                result = value === operand;
            }
        }
        else {
            result = false;
        }
        return operator === "=" ? result : !result;
    }
    if (typeof value === typeof operand) {
        switch (operator) {
            case "<":
                return value < operand;
            case ">":
                return value > operand;
            case "<=":
                return value <= operand;
            case ">=":
                return value >= operand;
        }
    }
    return false;
}
/**
 * Functions used especially for predicate evaluation on ranges.
 *
 * Take ranges with same dimensions and take predicates, one for each range.
 * For (i, j) coordinates, if all elements with coordinates (i, j) of each
 * range correspond to the associated predicate, then the function uses a callback
 * function with the parameters "i" and "j".
 *
 * Syntax:
 * visitMatchingRanges([range1, predicate1, range2, predicate2, ...], cb(i,j), likeSelection)
 *
 * - range1 (range): The range to check against predicate1.
 * - predicate1 (string): The pattern or test to apply to range1.
 * - range2: (range, repeatable) ranges to check.
 * - predicate2 (string, repeatable): Additional pattern or test to apply to range2.
 *
 * - cb(i: number, j: number) => void: the callback function.
 *
 * - isQuery (boolean) indicates if the comparison with a string should be done as a SQL-like query.
 * (Ex1 isQuery = true, predicate = "abc", element = "abcde": predicate match the element),
 * (Ex2 isQuery = false, predicate = "abc", element = "abcde": predicate not match the element).
 * (Ex3 isQuery = true, predicate = "abc", element = "abc": predicate match the element),
 * (Ex4 isQuery = false, predicate = "abc", element = "abc": predicate match the element).
 */
function visitMatchingRanges(args, cb, locale, isQuery = false) {
    const countArg = args.length;
    if (countArg % 2 === 1) {
        throw new EvaluationError(_t$1("Function [[FUNCTION_NAME]] expects criteria_range and criterion to be in pairs."));
    }
    const firstArg = toMatrix(args[0]);
    const dimRow = firstArg.length;
    const dimCol = firstArg[0].length;
    const predicates = [];
    for (let i = 0; i < countArg - 1; i += 2) {
        const criteriaRange = toMatrix(args[i]);
        if (criteriaRange.length !== dimRow || criteriaRange[0].length !== dimCol) {
            throw new EvaluationError(_t$1("Function [[FUNCTION_NAME]] expects criteria_range to have the same dimension"));
        }
        const description = toString(args[i + 1]);
        const predicate = getPredicate(description, locale);
        if (isQuery && typeof predicate.operand === "string") {
            predicate.operand += "*";
        }
        predicates.push(predicate);
    }
    for (let i = 0; i < dimRow; i++) {
        for (let j = 0; j < dimCol; j++) {
            let validatedPredicates = true;
            for (let k = 0; k < countArg - 1; k += 2) {
                const criteriaValue = toMatrix(args[k])[i][j].value;
                const criterion = predicates[k / 2];
                validatedPredicates = evaluatePredicate(criteriaValue ?? undefined, criterion, locale);
                if (!validatedPredicates) {
                    break;
                }
            }
            if (validatedPredicates) {
                cb(i, j);
            }
        }
    }
}
// -----------------------------------------------------------------------------
// COMMON FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * Perform a dichotomic search on an array and return the index of the nearest match.
 *
 * The array should be sorted, if not an incorrect value might be returned. In the case where multiple
 * element of the array match the target, the method will return the first match if the array is sorted
 * in descending order, and the last match if the array is in ascending order.
 *
 *
 * @param data the array in which to search.
 * @param target the value to search.
 * @param mode "nextGreater/nextSmaller" : return next greater/smaller value if no exact match is found.
 * @param sortOrder whether the array is sorted in ascending or descending order.
 * @param rangeLength the number of elements to consider in the search array.
 * @param getValueInData function returning the element at index i in the search array.
 */
function dichotomicSearch(data, target, mode, sortOrder, rangeLength, getValueInData) {
    if (target === undefined || target.value === null) {
        return -1;
    }
    if (isEvaluationError(target.value)) {
        throw target;
    }
    const _target = normalizeValue(target.value);
    const targetType = typeof _target;
    let matchVal = undefined;
    let matchValIndex = undefined;
    let indexLeft = 0;
    let indexRight = rangeLength - 1;
    let indexMedian;
    let currentIndex;
    let currentVal;
    let currentType;
    const getValue = sortOrder === "desc"
        ? (i) => normalizeValue(getValueInData(data, rangeLength - i - 1))
        : (i) => normalizeValue(getValueInData(data, i));
    while (indexRight - indexLeft >= 0) {
        indexMedian = Math.floor((indexLeft + indexRight) / 2);
        currentIndex = indexMedian;
        currentVal = getValue(currentIndex);
        currentType = typeof currentVal;
        // 1 - linear search to find value with the same type
        while (indexLeft < currentIndex && targetType !== currentType) {
            currentIndex--;
            currentVal = getValue(currentIndex);
            currentType = typeof currentVal;
        }
        if (currentType !== targetType || currentVal === undefined || currentVal === null) {
            indexLeft = indexMedian + 1;
            continue;
        }
        // 2 - check if value match
        if (mode === "strict" && currentVal === _target) {
            matchVal = currentVal;
            matchValIndex = currentIndex;
        }
        else if (mode === "nextSmaller" && currentVal <= _target) {
            if (matchVal === undefined ||
                matchVal === null ||
                matchVal < currentVal ||
                (matchVal === currentVal && matchValIndex < currentIndex)) {
                matchVal = currentVal;
                matchValIndex = currentIndex;
            }
        }
        else if (mode === "nextGreater" && currentVal >= _target) {
            if (matchVal === undefined ||
                matchVal > currentVal ||
                (matchVal === currentVal && matchValIndex < currentIndex)) {
                matchVal = currentVal;
                matchValIndex = currentIndex;
            }
        }
        // 3 - give new indexes for the Binary search
        if (currentVal > _target || (mode === "strict" && currentVal === _target)) {
            indexRight = currentIndex - 1;
        }
        else {
            indexLeft = indexMedian + 1;
        }
    }
    // note that valMinIndex could be 0
    if (matchValIndex === undefined) {
        return -1;
    }
    return sortOrder === "desc" ? rangeLength - matchValIndex - 1 : matchValIndex;
}
/**
 * Perform a linear search and return the index of the match.
 * -1 is returned if no value is found.
 *
 * Example:
 * - [3, 6, 10], 3 => 0
 * - [3, 6, 10], 6 => 1
 * - [3, 6, 10], 9 => -1
 * - [3, 6, 10], 2 => -1
 *
 * @param data the array to search in.
 * @param target the value to search in the array.
 * @param mode if "strict" return exact match index. "nextGreater" returns the next greater
 * element from the target and "nextSmaller" the next smaller
 * @param numberOfValues the number of elements to consider in the search array.
 * @param getValueInData function returning the element at index i in the search array.
 * @param reverseSearch if true, search in the array starting from the end.

 */
function linearSearch(data, target, mode, numberOfValues, getValueInData, lookupCaches, reverseSearch = false) {
    if (target === undefined || target.value === null) {
        return -1;
    }
    if (isEvaluationError(target.value)) {
        throw target;
    }
    const _target = normalizeValue(target.value);
    const getValue = reverseSearch
        ? (data, i) => normalizeValue(getValueInData(data, numberOfValues - i - 1))
        : (data, i) => normalizeValue(getValueInData(data, i));
    // first check if the target is in the cache
    const isNotWildcardTarget = mode !== "wildcard" ||
        typeof _target !== "string" ||
        !(_target.includes("*") || _target.includes("?"));
    if (lookupCaches && isNotWildcardTarget) {
        const searchMode = reverseSearch ? "reverseSearch" : "forwardSearch";
        let cache = lookupCaches[searchMode].get(data);
        if (cache === undefined) {
            // build the cache for all the values
            cache = new Map();
            for (let i = 0; i < numberOfValues; i++) {
                const value = getValue(data, i) ?? null;
                if (!cache.has(value)) {
                    cache.set(value, i);
                }
            }
            lookupCaches[searchMode].set(data, cache);
        }
        if (cache.has(_target)) {
            const resultIndex = cache.get(_target);
            return reverseSearch ? numberOfValues - resultIndex - 1 : resultIndex;
        }
        if (mode === "strict") {
            return -1;
        }
    }
    // else perform the linear search
    const resultIndex = _linearSearch(data, _target, mode, numberOfValues, getValue);
    return reverseSearch && resultIndex !== -1 ? numberOfValues - resultIndex - 1 : resultIndex;
}
function _linearSearch(data, _target, mode, numberOfValues, getNormalizeValue) {
    let indexMatchTarget = (i) => {
        return getNormalizeValue(data, i) === _target;
    };
    if (mode === "wildcard" &&
        typeof _target === "string" &&
        (_target.includes("*") || _target.includes("?"))) {
        const regExp = wildcardToRegExp(_target);
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if (typeof value === "string") {
                return regExp.test(value);
            }
            return false;
        };
    }
    let closestMatch = undefined;
    let closestMatchIndex = -1;
    if (mode === "nextSmaller") {
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if ((!closestMatch && compareCellValues(_target, value) >= 0) ||
                (compareCellValues(_target, value) >= 0 && compareCellValues(value, closestMatch) > 0)) {
                closestMatch = value;
                closestMatchIndex = i;
            }
            return value === _target;
        };
    }
    if (mode === "nextGreater") {
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if ((!closestMatch && compareCellValues(_target, value) <= 0) ||
                (compareCellValues(_target, value) <= 0 && compareCellValues(value, closestMatch) < 0)) {
                closestMatch = value;
                closestMatchIndex = i;
            }
            return value === _target;
        };
    }
    for (let i = 0; i < numberOfValues; i++) {
        if (indexMatchTarget(i)) {
            return i;
        }
    }
    return closestMatchIndex;
}
/**
 * Normalize a value.
 * If the cell value is a string, this will set it to lowercase and replacing accent letters with plain letters
 */
function normalizeValue(value) {
    return typeof value === "string" ? normalizeString(value) : value;
}
function compareCellValues(left, right) {
    let typeOrder = SORT_TYPES_ORDER.indexOf(typeof left) - SORT_TYPES_ORDER.indexOf(typeof right);
    if (typeOrder === 0) {
        if (typeof left === "string" && typeof right === "string") {
            typeOrder = left.localeCompare(right);
        }
        else if (typeof left === "number" && typeof right === "number") {
            typeOrder = left - right;
        }
        else if (typeof left === "boolean" && typeof right === "boolean") {
            typeOrder = Number(left) - Number(right);
        }
    }
    return typeOrder;
}
function toMatrix(data) {
    if (data === undefined) {
        return [[]];
    }
    return isMatrix(data) ? data : [[data]];
}
/**
 * Flatten an array of items, where each item can be a single value or a 2D array, and apply the
 * callback to each element.
 *
 * The 2D array are flattened row first.
 */
function flattenRowFirst(items, callback) {
    /**/
    return reduceAny(items, (array, val) => {
        array.push(callback(val));
        return array;
    }, [], "rowFirst");
}
function isDataNonEmpty(data) {
    if (data === undefined) {
        return false;
    }
    const { value } = data;
    if (value === null || value === "") {
        return false;
    }
    return true;
}
const noValidInputErrorMessage = _t$1("[[FUNCTION_NAME]] has no valid input data.");
function emptyDataErrorMessage(argName) {
    return _t$1("[[FUNCTION_NAME]] expects the provided values of %(argName)s to be a non-empty matrix.", { argName });
}

function createComputeFunction(descr) {
    function vectorizedCompute(...args) {
        const acceptToVectorize = [];
        const getArgToFocus = argTargeting(descr, args.length);
        //#region Compute vectorisation limits
        for (let i = 0; i < args.length; i++) {
            const argIndex = getArgToFocus(i) ?? -1;
            const argDefinition = descr.args[argIndex];
            const arg = args[i];
            if (!isMatrix(arg) && argDefinition.acceptMatrixOnly) {
                throw new BadExpressionError(_t$1("Function %s expects the parameter '%s' to be reference to a cell or range.", descr.name, (i + 1).toString()));
            }
            acceptToVectorize.push(!argDefinition.acceptMatrix);
        }
        return applyVectorization(errorHandlingCompute.bind(this), args, acceptToVectorize);
    }
    function errorHandlingCompute(...args) {
        for (let i = 0; i < args.length; i++) {
            const arg = args[i];
            const getArgToFocus = argTargeting(descr, args.length);
            const argDefinition = descr.args[getArgToFocus(i) || i];
            // Early exit if the argument is an error and the function does not accept errors
            // We only check scalar arguments, not matrix arguments for performance reasons.
            // Casting helpers are responsible for handling errors in matrix arguments.
            if (!argDefinition.acceptErrors && !isMatrix(arg) && isEvaluationError(arg?.value)) {
                return arg;
            }
        }
        try {
            return computeFunctionToObject.apply(this, args);
        }
        catch (e) {
            return handleError(e, descr.name);
        }
    }
    function computeFunctionToObject(...args) {
        if (this.debug) {
            // eslint-disable-next-line no-debugger
            debugger;
        }
        const result = descr.compute.apply(this, args);
        if (!isMatrix(result)) {
            if (typeof result === "object" && result !== null && "value" in result) {
                replaceFunctionNamePlaceholder(result, descr.name);
                return result;
            }
            return { value: result };
        }
        if (typeof result[0][0] === "object" && result[0][0] !== null && "value" in result[0][0]) {
            matrixForEach(result, (result) => replaceFunctionNamePlaceholder(result, descr.name));
            return result;
        }
        return matrixMap(result, (row) => ({ value: row }));
    }
    return vectorizedCompute;
}
function handleError(e, functionName) {
    // the error could be a user error (instance of EvaluationError)
    // or a javascript error (instance of Error)
    // we don't want block the user with an implementation error
    // so we fallback to a generic error
    if (hasStringValue(e) && isEvaluationError(e.value)) {
        if (hasStringMessage(e)) {
            replaceFunctionNamePlaceholder(e, functionName);
        }
        return e;
    }
    console.error(e);
    return new EvaluationError(implementationErrorMessage + (hasStringMessage(e) ? " " + e.message : ""));
}
function hasStringValue(obj) {
    return (obj?.value !== undefined &&
        typeof obj.value === "string");
}
function replaceFunctionNamePlaceholder(functionResult, functionName) {
    // for performance reasons: change in place and only if needed
    if (functionResult.message?.includes("[[FUNCTION_NAME]]")) {
        functionResult.message = functionResult.message.replace("[[FUNCTION_NAME]]", functionName);
    }
}
const implementationErrorMessage = _t$1("An unexpected error occurred. Submit a support ticket at odoo.com/help.");
function hasStringMessage(obj) {
    return (obj?.message !== undefined &&
        typeof obj.message === "string");
}

function assert(condition, message) {
    if (!condition) {
        throw new EvaluationError(message);
    }
}
function assertNotZero(value, message = _t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error.")) {
    if (value === 0) {
        throw new DivisionByZeroError(message);
    }
}
function isSingleColOrRow(arg) {
    return arg.length === 1 || arg[0].length === 1;
}
function areSameDimensions(...args) {
    if (args.every(isMatrix)) {
        const cols = args[0].length;
        const rows = args[0][0].length;
        for (const arg of args) {
            if (arg.length !== cols || arg[0].length !== rows) {
                return false;
            }
        }
        return true;
    }
    return !args.some((arg) => Array.isArray(arg) && (arg.length !== 1 || arg[0].length !== 1));
}
function isSquareMatrix(arg) {
    return arg.length === arg[0].length;
}
const expectNumberGreaterThanOrEqualToOne = (value) => _t$1("The function [[FUNCTION_NAME]] expects a number value to be greater than or equal to 1, but receives %s.", value);

function getUnitMatrix(n) {
    const matrix = Array(n);
    for (let i = 0; i < n; i++) {
        matrix[i] = Array(n).fill(0);
        matrix[i][i] = 1;
    }
    return matrix;
}
/**
 * Invert a matrix and compute its determinant using Gaussian Elimination.
 *
 * The Matrix should be a square matrix, and should be indexed [col][row] instead of the
 * standard mathematical indexing [row][col].
 */
function invertMatrix(M) {
    // Use Gaussian Elimination to calculate the inverse:
    // (1) 'augment' the matrix (left) by the identity (on the right)
    // (2) Turn the matrix on the left into the identity using elementary row operations
    // (3) The matrix on the right becomes the inverse (was the identity matrix)
    //
    // There are 3 elementary row operations:
    // (a) Swap 2 rows. This multiply the determinant by -1.
    // (b) Multiply a row by a scalar. This multiply the determinant by that scalar.
    // (c) Add to a row a multiple of another row. This does not change the determinant.
    if (M.length < 1 || M[0].length < 1) {
        throw new Error("invertMatrix: an empty matrix cannot be inverted.");
    }
    if (M.length !== M[0].length) {
        throw new Error("invertMatrix: only square matrices are invertible");
    }
    let determinant = 1;
    const dim = M.length;
    const I = getUnitMatrix(dim);
    const C = M.map((row) => row.slice());
    // Perform elementary row operations
    for (let pivot = 0; pivot < dim; pivot++) {
        let diagonalElement = C[pivot][pivot];
        // if we have a 0 on the diagonal we'll need to swap with a lower row
        if (diagonalElement === 0) {
            //look through every row below the i'th row
            for (let row = pivot + 1; row < dim; row++) {
                //if the ii'th row has a non-0 in the i'th col, swap it with that row
                if (C[pivot][row] !== 0) {
                    swapMatrixRows(C, pivot, row);
                    swapMatrixRows(I, pivot, row);
                    determinant *= -1;
                    break;
                }
            }
            diagonalElement = C[pivot][pivot];
            //if it's still 0, matrix isn't invertible
            if (diagonalElement === 0) {
                return { determinant: 0 };
            }
        }
        // Scale this row down by e (so we have a 1 on the diagonal)
        for (let col = 0; col < dim; col++) {
            C[col][pivot] = C[col][pivot] / diagonalElement;
            I[col][pivot] = I[col][pivot] / diagonalElement;
        }
        determinant *= diagonalElement;
        // Subtract a multiple of the current row from ALL of
        // the other rows so that there will be 0's in this column in the
        // rows above and below this one
        for (let row = 0; row < dim; row++) {
            if (row === pivot) {
                continue;
            }
            // We want to change this element to 0
            const e = C[pivot][row];
            // Subtract (the row above(or below) scaled by e) from (the
            // current row) but start at the i'th column and assume all the
            // stuff left of diagonal is 0 (which it should be if we made this
            // algorithm correctly)
            for (let col = 0; col < dim; col++) {
                C[col][row] -= e * C[col][pivot];
                I[col][row] -= e * I[col][pivot];
            }
        }
    }
    // We've done all operations, C should be the identity matrix I should be the inverse
    return { inverted: I, determinant };
}
function swapMatrixRows(matrix, row1, row2) {
    for (let i = 0; i < matrix.length; i++) {
        const tmp = matrix[i][row1];
        matrix[i][row1] = matrix[i][row2];
        matrix[i][row2] = tmp;
    }
}
/**
 * Matrix multiplication of 2 matrices.
 * ex: matrix1 : n x l, matrix2 : m x n => result : m x l
 *
 * Note: we use indexing [col][row] instead of the standard mathematical notation [row][col]
 */
function multiplyMatrices(matrix1, matrix2) {
    if (matrix1.length < 1 || matrix2.length < 1) {
        throw new Error("multiplyMatrices: empty matrices cannot be multiplied.");
    }
    if (matrix1.length !== matrix2[0].length) {
        throw new Error("multiplyMatrices: incompatible matrices size.");
    }
    const rowsM1 = matrix1[0].length;
    const colsM2 = matrix2.length;
    const n = matrix1.length;
    const result = Array(colsM2);
    for (let col = 0; col < colsM2; col++) {
        result[col] = Array(rowsM1);
        for (let row = 0; row < rowsM1; row++) {
            let sum = 0;
            for (let k = 0; k < n; k++) {
                sum += matrix1[k][row] * matrix2[col][k];
            }
            result[col][row] = sum;
        }
    }
    return result;
}
/**
 * Return the input if it's a scalar or the first element of the input if it's a matrix.
 */
function toScalar(arg) {
    if (!isMatrix(arg)) {
        return arg;
    }
    if (!isSingleElementMatrix(arg)) {
        throw new Error("The value should be a scalar or a 1x1 matrix");
    }
    return arg[0][0];
}
function isSingleElementMatrix(matrix) {
    return matrix.length === 1 && matrix[0].length === 1;
}
function isMultipleElementMatrix(arg) {
    return isMatrix(arg) && !isSingleElementMatrix(arg);
}

// -----------------------------------------------------------------------------
// ARRAY_CONSTRAIN
// -----------------------------------------------------------------------------
const ARRAY_CONSTRAIN = {
    description: _t$1("Returns a result array constrained to a specific width and height."),
    args: [
        arg("input_range (any, range<any>)", _t$1("The range to constrain.")),
        arg("rows (number)", _t$1("The number of rows in the constrained array.")),
        arg("columns (number)", _t$1("The number of columns in the constrained array.")),
    ],
    compute: function (array, rows, columns) {
        const _array = toMatrix(array);
        const _rowsArg = toInteger(rows?.value, this.locale);
        const _columnsArg = toInteger(columns?.value, this.locale);
        if (_rowsArg <= 0) {
            return new EvaluationError(_t$1("The rows argument (%s) must be strictly positive.", _rowsArg.toString()));
        }
        if (_columnsArg <= 0) {
            return new EvaluationError(_t$1("The columns argument (%s) must be strictly positive.", _columnsArg.toString()));
        }
        const _nbRows = Math.min(_rowsArg, _array[0].length);
        const _nbColumns = Math.min(_columnsArg, _array.length);
        return generateMatrix(_nbColumns, _nbRows, (col, row) => _array[col][row]);
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// CHOOSECOLS
// -----------------------------------------------------------------------------
const CHOOSECOLS = {
    description: _t$1("Creates a new array from the selected columns in the existing range."),
    args: [
        arg("array (any, range<any>)", _t$1("The array that contains the columns to be returned.")),
        arg("col_num (number, range<number>)", _t$1("The first column index of the columns to be returned.")),
        arg("col_num2 (number, range<number>, repeating)", _t$1("The columns indexes of the columns to be returned.")),
    ],
    compute: function (array, ...columns) {
        const _array = toMatrix(array);
        const _columns = flattenRowFirst(columns, (item) => toInteger(item?.value, this.locale));
        const argOutOfRange = _columns.filter((col) => col === 0 || _array.length < Math.abs(col));
        if (argOutOfRange.length !== 0) {
            return new EvaluationError(_t$1("The columns arguments must be between -%s and %s (got %s), excluding 0.", _array.length.toString(), _array.length.toString(), argOutOfRange.join(",")));
        }
        const result = Array(_columns.length);
        for (let col = 0; col < _columns.length; col++) {
            if (_columns[col] > 0) {
                result[col] = _array[_columns[col] - 1]; // -1 because columns arguments are 1-indexed
            }
            else {
                result[col] = _array[_array.length + _columns[col]];
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CHOOSEROWS
// -----------------------------------------------------------------------------
const CHOOSEROWS = {
    description: _t$1("Creates a new array from the selected rows in the existing range."),
    args: [
        arg("array (any, range<any>)", _t$1("The array that contains the rows to be returned.")),
        arg("row_num (number, range<number>)", _t$1("The first row index of the rows to be returned.")),
        arg("row_num2 (number, range<number>, repeating)", _t$1("The rows indexes of the rows to be returned.")),
    ],
    compute: function (array, ...rows) {
        const _array = toMatrix(array);
        const _rows = flattenRowFirst(rows, (item) => toInteger(item?.value, this.locale));
        const _nbColumns = _array.length;
        const argOutOfRange = _rows.filter((row) => row === 0 || _array[0].length < Math.abs(row));
        if (argOutOfRange.length !== 0) {
            return new EvaluationError(_t$1("The rows arguments must be between -%s and %s (got %s), excluding 0.", _array[0].length.toString(), _array[0].length.toString(), argOutOfRange.join(",")));
        }
        return generateMatrix(_nbColumns, _rows.length, (col, row) => {
            if (_rows[row] > 0) {
                return _array[col][_rows[row] - 1]; // -1 because columns arguments are 1-indexed
            }
            return _array[col][_array[col].length + _rows[row]];
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EXPAND
// -----------------------------------------------------------------------------
const EXPAND = {
    description: _t$1("Expands or pads an array to specified row and column dimensions."),
    args: [
        arg("array (any, range<any>)", _t$1("The array to expand.")),
        arg("rows (number)", _t$1("The number of rows in the expanded array. If missing, rows will not be expanded.")),
        arg("columns (number, optional)", _t$1("The number of columns in the expanded array. If missing, columns will not be expanded.")),
        arg("pad_with (any, default=0)", _t$1("The value with which to pad.")), // @compatibility: on Excel, pad with #N/A
    ],
    compute: function (arg, rows, columns, padWith = { value: 0 } // TODO : Replace with #N/A errors once it's supported
    ) {
        const _array = toMatrix(arg);
        const _nbRows = toInteger(rows?.value, this.locale);
        const _nbColumns = columns !== undefined ? toInteger(columns.value, this.locale) : _array.length;
        if (_nbRows < _array[0].length) {
            return new EvaluationError(_t$1("The rows arguments (%s) must be greater or equal than the number of rows of the array.", _nbRows.toString()));
        }
        if (_nbColumns < _array.length) {
            return new EvaluationError(_t$1("The columns arguments (%s) must be greater or equal than the number of columns of the array.", _nbColumns.toString()));
        }
        return generateMatrix(_nbColumns, _nbRows, (col, row) => col >= _array.length || row >= _array[col].length ? padWith : _array[col][row]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLATTEN
// -----------------------------------------------------------------------------
const FLATTEN = {
    description: _t$1("Flattens all the values from one or more ranges into a single column."),
    args: [
        arg("range (any, range<any>)", _t$1("The first range to flatten.")),
        arg("range2 (any, range<any>, repeating)", _t$1("Additional ranges to flatten.")),
    ],
    compute: function (...ranges) {
        return [flattenRowFirst(ranges, (val) => (val === undefined ? { value: "" } : val))];
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// FREQUENCY
// -----------------------------------------------------------------------------
const FREQUENCY = {
    description: _t$1("Calculates the frequency distribution of a range."),
    args: [
        arg("data (range<number>)", _t$1("The array of ranges containing the values to be counted.")),
        arg("classes (number, range<number>)", _t$1("The range containing the set of classes.")),
    ],
    compute: function (data, classes) {
        const _data = flattenRowFirst([data], (data) => data.value).filter((val) => typeof val === "number");
        const _classes = flattenRowFirst([classes], (data) => data.value).filter((val) => typeof val === "number");
        /**
         * Returns the frequency distribution of the data in the classes, ie. the number of elements in the range
         * between each classes.
         *
         * For example:
         * - data = [1, 3, 2, 5, 4]
         * - classes = [3, 5, 1]
         *
         * The result will be:
         * - 2 ==> number of elements 1 > el >= 3
         * - 2 ==> number of elements 3 > el >= 5
         * - 1 ==> number of elements <= 1
         * - 0 ==> number of elements > 5
         *
         * @compatibility: GSheet sort the input classes. We do the implemntation of Excel, where we kee the classes unsorted.
         */
        const sortedClasses = _classes
            .map((value, index) => ({ initialIndex: index, value, count: 0 }))
            .sort((a, b) => a.value - b.value);
        sortedClasses.push({ initialIndex: sortedClasses.length, value: Infinity, count: 0 });
        const sortedData = _data.sort((a, b) => a - b);
        let index = 0;
        for (const val of sortedData) {
            while (val > sortedClasses[index].value && index < sortedClasses.length - 1) {
                index++;
            }
            sortedClasses[index].count++;
        }
        const result = sortedClasses
            .sort((a, b) => a.initialIndex - b.initialIndex)
            .map((val) => val.count);
        return [result];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HSTACK
// -----------------------------------------------------------------------------
const HSTACK = {
    description: _t$1("Appends ranges horizontally and in sequence to return a larger array."),
    args: [
        arg("range1 (any, range<any>)", _t$1("The first range to be appended.")),
        arg("range2 (any, range<any>, repeating)", _t$1("Additional ranges to add to range1.")),
    ],
    compute: function (...ranges) {
        const nbRows = Math.max(...ranges.map((r) => r?.[0]?.length ?? 0));
        const result = [];
        for (const range of ranges) {
            const _range = toMatrix(range);
            for (let col = 0; col < _range.length; col++) {
                //TODO: fill with #N/A for unavailable values instead of zeroes
                const array = Array(nbRows).fill({ value: null });
                for (let row = 0; row < _range[col].length; row++) {
                    array[row] = _range[col][row];
                }
                result.push(array);
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MDETERM
// -----------------------------------------------------------------------------
const MDETERM = {
    description: _t$1("Returns the matrix determinant of a square matrix."),
    args: [
        arg("square_matrix (number, range<number>)", _t$1("An range with an equal number of rows and columns representing a matrix whose determinant will be calculated.")),
    ],
    compute: function (matrix) {
        const _matrix = toNumberMatrix(matrix, "square_matrix");
        if (!isSquareMatrix(_matrix)) {
            return new EvaluationError(_t$1("The argument square_matrix must have the same number of columns and rows."));
        }
        return invertMatrix(_matrix).determinant;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINVERSE
// -----------------------------------------------------------------------------
const MINVERSE = {
    description: _t$1("Returns the multiplicative inverse of a square matrix."),
    args: [
        arg("square_matrix (number, range<number>)", _t$1("An range with an equal number of rows and columns representing a matrix whose multiplicative inverse will be calculated.")),
    ],
    compute: function (matrix) {
        const _matrix = toNumberMatrix(matrix, "square_matrix");
        if (!isSquareMatrix(_matrix)) {
            return new EvaluationError(_t$1("The argument square_matrix must have the same number of columns and rows."));
        }
        const { inverted } = invertMatrix(_matrix);
        if (!inverted) {
            return new EvaluationError(_t$1("The matrix is not invertible."));
        }
        return inverted;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MMULT
// -----------------------------------------------------------------------------
const MMULT = {
    description: _t$1("Calculates the matrix product of two matrices."),
    args: [
        arg("matrix1 (number, range<number>)", _t$1("The first matrix in the matrix multiplication operation.")),
        arg("matrix2 (number, range<number>)", _t$1("The second matrix in the matrix multiplication operation.")),
    ],
    compute: function (matrix1, matrix2) {
        const _matrix1 = toNumberMatrix(matrix1, "matrix1");
        const _matrix2 = toNumberMatrix(matrix2, "matrix2");
        if (_matrix1.length === 0 || _matrix2.length === 0) {
            return new EvaluationError(_t$1("The first and second arguments of [[FUNCTION_NAME]] must be non-empty matrices."));
        }
        if (_matrix1.length !== _matrix2[0].length) {
            return new EvaluationError(_t$1("In [[FUNCTION_NAME]], the number of columns of the first matrix (%s) must be equal to the \
          number of rows of the second matrix (%s).", _matrix1.length.toString(), _matrix2[0].length.toString()));
        }
        return multiplyMatrices(_matrix1, _matrix2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMPRODUCT
// -----------------------------------------------------------------------------
const SUMPRODUCT = {
    description: _t$1("Calculates the sum of the products of corresponding entries in equal-sized ranges."),
    args: [
        arg("range1 (number, range<number>)", _t$1("The first range whose entries will be multiplied with corresponding entries in the other ranges.")),
        arg("range2 (number, range<number>, repeating)", _t$1("The other range whose entries will be multiplied with corresponding entries in the other ranges.")),
    ],
    compute: function (...args) {
        if (!areSameDimensions(...args)) {
            return new EvaluationError(_t$1("All the ranges must have the same dimensions."));
        }
        const _args = args.map(toMatrix);
        let result = 0;
        for (let col = 0; col < _args[0].length; col++) {
            for (let row = 0; row < _args[0][col].length; row++) {
                if (!_args.every((range) => typeof range[col][row].value === "number")) {
                    continue;
                }
                let product = 1;
                for (const range of _args) {
                    product *= toNumber(range[col][row], this.locale);
                }
                result += product;
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMX2MY2
// -----------------------------------------------------------------------------
/**
 * Return the sum of the callback applied to each pair of values in the two arrays.
 *
 * Ignore the pairs X,Y where one of the value isn't a number. Throw an error if no pair of numbers is found.
 */
function getSumXAndY(arrayX, arrayY, cb) {
    if (!areSameDimensions(arrayX, arrayY)) {
        return new EvaluationError(_t$1("The arguments array_x and array_y must have the same dimensions."));
    }
    const _arrayX = toMatrix(arrayX);
    const _arrayY = toMatrix(arrayY);
    let validPairFound = false;
    let result = 0;
    for (const col in _arrayX) {
        for (const row in _arrayX[col]) {
            const arrayXValue = _arrayX[col][row].value;
            const arrayYValue = _arrayY[col][row].value;
            if (typeof arrayXValue !== "number" || typeof arrayYValue !== "number") {
                continue;
            }
            validPairFound = true;
            result += cb(arrayXValue, arrayYValue);
        }
    }
    if (!validPairFound) {
        return new EvaluationError(_t$1("The arguments array_x and array_y must contain at least one pair of numbers."));
    }
    return result;
}
const SUMX2MY2 = {
    description: _t$1("Calculates the sum of the difference of the squares of the values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t$1("The array or range of values whose squares will be reduced by the squares of corresponding entries in array_y and added together.")),
        arg("array_y (number, range<number>)", _t$1("The array or range of values whose squares will be subtracted from the squares of corresponding entries in array_x and added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 - y ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMX2PY2
// -----------------------------------------------------------------------------
const SUMX2PY2 = {
    description: _t$1("Calculates the sum of the sum of the squares of the values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t$1("The array or range of values whose squares will be added to the squares of corresponding entries in array_y and added together.")),
        arg("array_y (number, range<number>)", _t$1("The array or range of values whose squares will be added to the squares of corresponding entries in array_x and added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 + y ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMXMY2
// -----------------------------------------------------------------------------
const SUMXMY2 = {
    description: _t$1("Calculates the sum of squares of the differences of values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t$1("The array or range of values that will be reduced by corresponding entries in array_y, squared, and added together.")),
        arg("array_y (number, range<number>)", _t$1("The array or range of values that will be subtracted from corresponding entries in array_x, the result squared, and all such results added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => (x - y) ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TOCOL
// -----------------------------------------------------------------------------
const TO_COL_ROW_DEFAULT_IGNORE = 0;
const TO_COL_ROW_DEFAULT_SCAN = false;
const TO_COL_ROW_ARGS = [
    arg("array (any, range<any>)", _t$1("The array which will be transformed.")),
    arg(`ignore (number, default=${TO_COL_ROW_DEFAULT_IGNORE})`, _t$1("Whether to ignore certain types of values. By default, no values are ignored."), [
        { value: 0, label: _t$1("Keep all values (default)") },
        { value: 1, label: _t$1("Ignore blanks") },
        { value: 2, label: _t$1("Ignore errors") },
        { value: 3, label: _t$1("Ignore blanks and errors") },
    ]),
    arg(`scan_by_column (number, default=${TO_COL_ROW_DEFAULT_SCAN})`, _t$1("Scan the array by column. By default, the array is scanned by row."), [
        { value: false, label: _t$1("Scan by row (default)") },
        { value: true, label: _t$1("Scan by column") },
    ]),
];
function shouldKeepValue(ignore) {
    const _ignore = Math.trunc(ignore);
    if (_ignore === 0) {
        return () => true;
    }
    if (_ignore === 1) {
        return (data) => data.value !== null;
    }
    if (_ignore === 2) {
        return (data) => !isEvaluationError(data.value);
    }
    if (_ignore === 3) {
        return (data) => data.value !== null && !isEvaluationError(data.value);
    }
    throw new EvaluationError(_t$1("Argument ignore must be between 0 and 3"));
}
const TOCOL = {
    description: _t$1("Transforms a range of cells into a single column."),
    args: TO_COL_ROW_ARGS,
    compute: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
        const _array = toMatrix(array);
        const _ignore = toNumber(ignore.value, this.locale);
        const _scanByColumn = toBoolean(scanByColumn.value);
        const result = (_scanByColumn ? _array : transposeMatrix(_array))
            .flat()
            .filter(shouldKeepValue(_ignore));
        if (result.length === 0) {
            return new NotAvailableError(_t$1("No results for the given arguments of TOCOL."));
        }
        return [result];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TOROW
// -----------------------------------------------------------------------------
const TOROW = {
    description: _t$1("Transforms a range of cells into a single row."),
    args: TO_COL_ROW_ARGS,
    compute: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
        const _array = toMatrix(array);
        const _ignore = toNumber(ignore.value, this.locale);
        const _scanByColumn = toBoolean(scanByColumn.value);
        const result = (_scanByColumn ? _array : transposeMatrix(_array))
            .flat()
            .filter(shouldKeepValue(_ignore))
            .map((item) => [item]);
        if (result.length === 0 || result[0].length === 0) {
            return new NotAvailableError(_t$1("No results for the given arguments of TOROW."));
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRANSPOSE
// -----------------------------------------------------------------------------
const TRANSPOSE = {
    description: _t$1("Transposes the rows and columns of a range."),
    args: [arg("range (any, range<any>)", _t$1("The range to be transposed."))],
    compute: function (arg) {
        const _array = toMatrix(arg);
        const nbColumns = _array[0].length;
        const nbRows = _array.length;
        return generateMatrix(nbColumns, nbRows, (col, row) => _array[row][col]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VSTACK
// -----------------------------------------------------------------------------
const VSTACK = {
    description: _t$1("Appends ranges vertically and in sequence to return a larger array."),
    args: [
        arg("range1 (any, range<any>)", _t$1("The first range to be appended.")),
        arg("range2 (any, range<any>, repeating)", _t$1("Additional ranges to add to range1.")),
    ],
    compute: function (...ranges) {
        const nbColumns = Math.max(...ranges.map((range) => toMatrix(range).length));
        const nbRows = ranges.reduce((acc, range) => acc + toMatrix(range)[0].length, 0);
        const result = Array(nbColumns)
            .fill([])
            .map(() => Array(nbRows).fill({ value: 0 })); // TODO fill with #N/A
        let currentRow = 0;
        for (const range of ranges) {
            const _array = toMatrix(range);
            for (let col = 0; col < _array.length; col++) {
                for (let row = 0; row < _array[col].length; row++) {
                    result[col][currentRow + row] = _array[col][row];
                }
            }
            currentRow += _array[0].length;
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WRAPCOLS
// -----------------------------------------------------------------------------
const WRAPCOLS = {
    description: _t$1("Wraps the provided row or column of cells by columns after a specified number of elements to form a new array."),
    args: [
        arg("range (any, range<any>)", _t$1("The range to wrap.")),
        arg("wrap_count (number)", _t$1("The maximum number of cells for each column, rounded down to the nearest whole number.")),
        arg("pad_with  (any, default=0)", // TODO : replace with #N/A
        _t$1("The value with which to fill the extra cells in the range.")),
    ],
    compute: function (range, wrapCount, padWith = { value: 0 }) {
        const _array = toMatrix(range);
        const nbRows = toInteger(wrapCount?.value, this.locale);
        if (!isSingleColOrRow(_array)) {
            return new EvaluationError(_t$1("Argument range must be a single row or column."));
        }
        const array = _array.flat();
        const nbColumns = Math.ceil(array.length / nbRows);
        return generateMatrix(nbColumns, nbRows, (col, row) => {
            const index = col * nbRows + row;
            return index < array.length ? array[index] : padWith;
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WRAPROWS
// -----------------------------------------------------------------------------
const WRAPROWS = {
    description: _t$1("Wraps the provided row or column of cells by rows after a specified number of elements to form a new array."),
    args: [
        arg("range (any, range<any>)", _t$1("The range to wrap.")),
        arg("wrap_count (number)", _t$1("The maximum number of cells for each row, rounded down to the nearest whole number.")),
        arg("pad_with  (any, default=0)", // TODO : replace with #N/A
        _t$1("The value with which to fill the extra cells in the range.")),
    ],
    compute: function (range, wrapCount, padWith = { value: 0 }) {
        const _array = toMatrix(range);
        const nbColumns = toInteger(wrapCount?.value, this.locale);
        if (!isSingleColOrRow(_array)) {
            return new EvaluationError(_t$1("Argument range must be a single row or column."));
        }
        const array = _array.flat();
        const nbRows = Math.ceil(array.length / nbColumns);
        return generateMatrix(nbColumns, nbRows, (col, row) => {
            const index = row * nbColumns + col;
            return index < array.length ? array[index] : padWith;
        });
    },
    isExported: true,
};

var array = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ARRAY_CONSTRAIN: ARRAY_CONSTRAIN,
    CHOOSECOLS: CHOOSECOLS,
    CHOOSEROWS: CHOOSEROWS,
    EXPAND: EXPAND,
    FLATTEN: FLATTEN,
    FREQUENCY: FREQUENCY,
    HSTACK: HSTACK,
    MDETERM: MDETERM,
    MINVERSE: MINVERSE,
    MMULT: MMULT,
    SUMPRODUCT: SUMPRODUCT,
    SUMX2MY2: SUMX2MY2,
    SUMX2PY2: SUMX2PY2,
    SUMXMY2: SUMXMY2,
    TOCOL: TOCOL,
    TOROW: TOROW,
    TRANSPOSE: TRANSPOSE,
    VSTACK: VSTACK,
    WRAPCOLS: WRAPCOLS,
    WRAPROWS: WRAPROWS
});

function tokenizeFormat$1(str) {
    const chars = new TokenizingChars$1(str);
    const result = [];
    let currentFormatPart = [];
    result.push(currentFormatPart);
    while (!chars.isOver()) {
        if (chars.current === ";") {
            currentFormatPart = [];
            result.push(currentFormatPart);
            chars.shift();
            continue;
        }
        const token = tokenizeDigit$1(chars) ||
            tokenizeString$2(chars) ||
            tokenizeEscapedChars$1(chars) ||
            tokenizeThousandsSeparator$1(chars) ||
            tokenizeDecimalPoint$1(chars) ||
            tokenizePercent$1(chars) ||
            tokenizeDatePart$1(chars) ||
            tokenizeTextPlaceholder$1(chars) ||
            tokenizeRepeatedChar$1(chars);
        if (!token) {
            throw new Error("Unknown token at " + chars.remaining());
        }
        currentFormatPart.push(token);
    }
    return result;
}
function tokenizeString$2(chars) {
    let enfOfStringChar;
    if (chars.current === '"') {
        chars.shift();
        enfOfStringChar = '"';
    }
    else if (chars.currentStartsWith("[$")) {
        chars.advanceBy(2);
        enfOfStringChar = "]";
    }
    if (!enfOfStringChar) {
        return null;
    }
    let letters = "";
    while (chars.current && chars.current !== enfOfStringChar) {
        letters += chars.shift();
    }
    if (chars.current === enfOfStringChar) {
        chars.shift();
    }
    else {
        throw new Error("Unterminated string in format");
    }
    return {
        type: "STRING",
        value: letters,
    };
}
const alwaysEscapedCharsInFormat$1 = new Set("$+-/():!^&~{}<>= ");
function tokenizeEscapedChars$1(chars) {
    if (chars.current === "\\") {
        chars.shift();
        const escapedChar = chars.shift();
        if (!escapedChar) {
            throw new Error("Unexpected end of format string");
        }
        return {
            type: "CHAR",
            value: escapedChar,
        };
    }
    if (alwaysEscapedCharsInFormat$1.has(chars.current)) {
        return {
            type: "CHAR",
            value: chars.shift(),
        };
    }
    return null;
}
function tokenizeThousandsSeparator$1(chars) {
    if (chars.current === ",") {
        chars.shift();
        return { type: "THOUSANDS_SEPARATOR", value: "," };
    }
    return null;
}
function tokenizeTextPlaceholder$1(chars) {
    if (chars.current === "@") {
        chars.shift();
        return { type: "TEXT_PLACEHOLDER", value: "@" };
    }
    return null;
}
function tokenizeDecimalPoint$1(chars) {
    if (chars.current === ".") {
        chars.shift();
        return { type: "DECIMAL_POINT", value: "." };
    }
    return null;
}
function tokenizePercent$1(chars) {
    if (chars.current === "%") {
        chars.shift();
        return { type: "PERCENT", value: "%" };
    }
    return null;
}
function tokenizeDigit$1(chars) {
    if (chars.current === "0" || chars.current === "#") {
        const value = chars.current;
        chars.shift();
        return { type: "DIGIT", value };
    }
    return null;
}
const dateSymbols$1 = new Set("dmqyhsa");
function tokenizeDatePart$1(chars) {
    if (!dateSymbols$1.has(chars.current)) {
        return null;
    }
    const char = chars.current;
    let value = "";
    while (chars.current === char) {
        value += chars.shift();
    }
    return { type: "DATE_PART", value };
}
function tokenizeRepeatedChar$1(chars) {
    if (chars.current !== "*") {
        return null;
    }
    chars.shift();
    const repeatedChar = chars.shift();
    if (!repeatedChar) {
        throw new Error("Unexpected end of format string");
    }
    return {
        type: "REPEATED_CHAR",
        value: repeatedChar,
    };
}

/**
 *  Constant used to indicate the maximum of digits that is possible to display
 *  in a cell with standard size.
 */
const MAX_DECIMAL_PLACES$1 = 20;
const internalFormatCache$1 = {};
function parseFormat$1(formatString) {
    let internalFormat = internalFormatCache$1[formatString];
    if (internalFormat === undefined) {
        internalFormat = convertFormatToInternalFormat$1(formatString);
        internalFormatCache$1[formatString] = internalFormat;
    }
    return internalFormat;
}
function convertFormatToInternalFormat$1(format) {
    const formatParts = tokenizeFormat$1(format);
    // A format can only have a single REPEATED_CHAR token. The rest are converted to simple CHAR tokens.
    for (const part of formatParts) {
        const repeatedCharTokens = part.filter((token) => token.type === "REPEATED_CHAR");
        for (const repeatedCharToken of repeatedCharTokens.slice(1)) {
            repeatedCharToken.type = "CHAR";
        }
    }
    const positiveFormat = parseDateFormatTokens$1(formatParts[0]) ||
        parseNumberFormatTokens$1(formatParts[0]) ||
        tokensToTextInternalFormat$1(formatParts[0]);
    if (!positiveFormat) {
        throw new Error("Invalid first format part of: " + format);
    }
    if (formatParts.length > 1 && positiveFormat.type === "text") {
        throw new Error("The first format in a multi-part format must be a number format: " + format);
    }
    const negativeFormat = parseDateFormatTokens$1(formatParts[1]) || parseNumberFormatTokens$1(formatParts[1]);
    if (formatParts[1]?.length && !negativeFormat) {
        throw new Error("Invalid second format part of: " + format);
    }
    const zeroFormat = parseDateFormatTokens$1(formatParts[2]) || parseNumberFormatTokens$1(formatParts[2]);
    if (formatParts[2]?.length && !zeroFormat) {
        throw new Error("Invalid third format part of: " + format);
    }
    const textFormat = tokensToTextInternalFormat$1(formatParts[3]);
    if (formatParts[3]?.length && !textFormat) {
        throw new Error("Invalid fourth format part of: " + format);
    }
    return { positive: positiveFormat, negative: negativeFormat, zero: zeroFormat, text: textFormat };
}
function areValidDateFormatTokens$1(tokens) {
    return tokens.every((token) => token.type === "DATE_PART" ||
        token.type === "DECIMAL_POINT" ||
        token.type === "THOUSANDS_SEPARATOR" ||
        token.type === "STRING" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function areValidNumberFormatTokens$1(tokens) {
    return tokens.every((token) => token.type === "DIGIT" ||
        token.type === "DECIMAL_POINT" ||
        token.type === "THOUSANDS_SEPARATOR" ||
        token.type === "PERCENT" ||
        token.type === "STRING" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function areValidTextFormatTokens$1(tokens) {
    return tokens.every((token) => token.type === "STRING" ||
        token.type === "TEXT_PLACEHOLDER" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function parseNumberFormatTokens$1(tokens) {
    if (!tokens || !areValidNumberFormatTokens$1(tokens)) {
        return undefined;
    }
    const integerPart = [];
    let decimalPart = undefined;
    let parsedPart = integerPart;
    let percentSymbols = 0;
    let magnitude = 0;
    let lastIndexOfDigit = tokens.findLastIndex((token) => token.type === "DIGIT");
    let hasThousandSeparator = false;
    let numberOfDecimalsDigits = 0;
    for (let i = 0; i < tokens.length; i++) {
        const token = tokens[i];
        switch (token.type) {
            case "DIGIT":
                if (parsedPart === integerPart) {
                    parsedPart.push(token);
                }
                else if (numberOfDecimalsDigits < MAX_DECIMAL_PLACES$1) {
                    parsedPart.push(token);
                    numberOfDecimalsDigits++;
                }
                break;
            case "DECIMAL_POINT":
                if (parsedPart === integerPart) {
                    decimalPart = [];
                    parsedPart = decimalPart;
                }
                else {
                    throw new Error("Multiple decimal points in a number format");
                }
                break;
            case "REPEATED_CHAR":
            case "CHAR":
            case "STRING":
                parsedPart.push(token);
                break;
            case "PERCENT":
                percentSymbols++;
                parsedPart.push(token);
                break;
            // Per OpenXML Spec:
            // - If a comma is between two DIGIT tokens, and in the integer part, a thousand separator is applied in the formatted value.
            // - If a comma is at the end of the number placeholder, the number is divided by a thousand.
            // - Otherwise, it's a string.
            case "THOUSANDS_SEPARATOR":
                if (i - 1 === lastIndexOfDigit) {
                    magnitude += 1;
                    lastIndexOfDigit++; // Can have multiple commas in a row
                    parsedPart.push(token);
                }
                else if (tokens[i + 1]?.type === "DIGIT" && tokens[i - 1]?.type === "DIGIT") {
                    if (parsedPart === integerPart) {
                        hasThousandSeparator = true;
                    }
                    parsedPart.push(token);
                }
                else {
                    parsedPart.push({ type: "CHAR", value: "," });
                }
                break;
        }
    }
    return {
        type: "number",
        integerPart,
        decimalPart,
        percentSymbols,
        thousandsSeparator: hasThousandSeparator,
        magnitude,
    };
}
function parseDateFormatTokens$1(tokens) {
    const internalFormat = tokens && areValidDateFormatTokens$1(tokens) ? { type: "date", tokens } : undefined;
    if (!internalFormat) {
        return undefined;
    }
    if (internalFormat.tokens.length &&
        internalFormat.tokens.every((token) => token.type === "DATE_PART" && token.value === "a")) {
        throw new Error("Invalid date format");
    }
    const dateTokens = internalFormat.tokens.map((token) => {
        if (token.type === "THOUSANDS_SEPARATOR" || token.type === "DECIMAL_POINT") {
            return { type: "CHAR", value: token.value };
        }
        return token;
    });
    const convertedTokens = convertTokensToMinutesInDateFormat$1(dateTokens);
    return { type: "date", tokens: convertedTokens };
}
function tokensToTextInternalFormat$1(tokens) {
    return tokens && areValidTextFormatTokens$1(tokens) ? { type: "text", tokens } : undefined;
}
/**
 * Replace in place tokens "mm" and "m" that denote minutes in date format with "MM" to avoid confusion with months.
 *
 * As per OpenXML specification, in date formats if a date token "m" or "mm" is followed by a date token "s" or
 * preceded by a data token "h", then it's not a month but a minute.
 */
function convertTokensToMinutesInDateFormat$1(tokens) {
    const dateParts = tokens.filter((token) => token.type === "DATE_PART");
    for (let i = 0; i < dateParts.length; i++) {
        if (!dateParts[i].value.startsWith("m") || dateParts[i].value.length > 2) {
            continue;
        }
        if (dateParts[i - 1]?.value.startsWith("h") || dateParts[i + 1]?.value.startsWith("s")) {
            dateParts[i].value = dateParts[i].value.replaceAll("m", "M");
        }
    }
    return tokens;
}
function convertInternalFormatToFormat(internalFormat) {
    return [
        internalFormatPartToFormat(internalFormat.positive),
        internalFormatPartToFormat(internalFormat.negative),
        internalFormatPartToFormat(internalFormat.zero),
        internalFormatPartToFormat(internalFormat.text),
    ]
        .filter(isDefined$1)
        .join(";");
}
function internalFormatPartToFormat(internalFormat) {
    if (!internalFormat) {
        return undefined;
    }
    let format = "";
    const tokens = internalFormat.type !== "number"
        ? internalFormat.tokens
        : numberInternalFormatToTokenList(internalFormat);
    for (const token of tokens) {
        switch (token.type) {
            case "STRING":
                format += `[$${token.value}]`;
                break;
            case "CHAR":
                format += shouldEscapeFormatChar(token.value) ? `\\${token.value}` : token.value;
                break;
            case "REPEATED_CHAR":
                format += "*" + token.value;
                break;
            case "DATE_PART":
                format += token.value === "MM" ? "mm" : token.value; // Convert "MM" back to "mm" for minutes
                break;
            default:
                format += token.value;
        }
    }
    return format;
}
function numberInternalFormatToTokenList(internalFormat) {
    const tokens = [...internalFormat.integerPart];
    if (internalFormat.decimalPart) {
        tokens.push({ type: "DECIMAL_POINT", value: "." });
        tokens.push(...internalFormat.decimalPart);
    }
    return tokens;
}
function shouldEscapeFormatChar(char) {
    return !alwaysEscapedCharsInFormat$1.has(char);
}

/**
 * Number of digits for the default number format. This number of digit make a number fit well in a cell
 * with default size and default font size.
 */
const DEFAULT_FORMAT_NUMBER_OF_DIGITS$1 = 11;
const REPEATED_CHAR_PLACEHOLDER$1 = "REPEATED_CHAR_PLACEHOLDER_";
// TODO in the future : remove these constants MONTHS/DAYS, and use a library such as luxon to handle it
// + possibly handle automatic translation of day/month
const MONTHS$1 = {
    0: _t$1("January"),
    1: _t$1("February"),
    2: _t$1("March"),
    3: _t$1("April"),
    4: _t$1("May"),
    5: _t$1("June"),
    6: _t$1("July"),
    7: _t$1("August"),
    8: _t$1("September"),
    9: _t$1("October"),
    10: _t$1("November"),
    11: _t$1("December"),
};
const DAYS$2 = {
    0: _t$1("Sunday"),
    1: _t$1("Monday"),
    2: _t$1("Tuesday"),
    3: _t$1("Wednesday"),
    4: _t$1("Thursday"),
    5: _t$1("Friday"),
    6: _t$1("Saturday"),
};
function formatOrHumanizeValue(value, format, locale, humanize = false) {
    if (humanize) {
        return humanizeNumber({ value, format }, locale);
    }
    else {
        return formatValue$1(value, { format, locale });
    }
}
/**
 * Formats a cell value with its format.
 */
function formatValue$1(value, { format, locale, formatWidth }) {
    if (typeof value === "boolean") {
        value = value ? "TRUE" : "FALSE";
    }
    switch (typeof value) {
        case "string": {
            if (value.includes('\\"')) {
                value = value.replaceAll(/\\"/g, '"');
            }
            if (!format) {
                return value;
            }
            const internalFormat = parseFormat$1(format);
            const formatToApply = getFormatToApply$1(value, internalFormat).format;
            if (!formatToApply || formatToApply.type !== "text") {
                return value;
            }
            return applyTextInternalFormat$1(value, formatToApply, formatWidth);
        }
        case "number":
            if (!format) {
                format = createDefaultFormat$1(value);
            }
            const internalFormat = parseFormat$1(format);
            const { format: formatToApply, isNegativeFormat } = getFormatToApply$1(value, internalFormat);
            if (!formatToApply) {
                return value.toString();
            }
            if (formatToApply.type === "text") {
                return applyTextInternalFormat$1(value.toString(), formatToApply, formatWidth);
            }
            if (isNegativeFormat) {
                value = Math.abs(value);
            }
            if (formatToApply.type === "date") {
                return repeatCharToFitWidth$1(applyDateTimeFormat$1(value, formatToApply), formatWidth);
            }
            const isNegative = value < 0;
            const formatted = repeatCharToFitWidth$1(applyInternalNumberFormat$1(Math.abs(value), formatToApply, locale), formatWidth);
            return isNegative ? "-" + formatted : formatted;
        case "object": // case value === null
            return "";
    }
}
function getFormatToApply$1(value, internalFormat) {
    let formatToApply = undefined;
    let isNegativeFormat = false;
    switch (typeof value) {
        case "number":
            if (value < 0 && internalFormat.negative) {
                formatToApply = internalFormat.negative;
                isNegativeFormat = true;
            }
            else if (value === 0 && internalFormat.zero) {
                formatToApply = internalFormat.zero;
            }
            else {
                formatToApply = internalFormat.positive;
            }
            break;
        case "string":
            const format = internalFormat.text || internalFormat.positive;
            if (format.type === "text") {
                formatToApply = format;
            }
            break;
    }
    return { format: formatToApply, isNegativeFormat };
}
function applyTextInternalFormat$1(value, internalFormat, formatWidth) {
    let formattedValue = "";
    for (const token of internalFormat.tokens) {
        switch (token.type) {
            case "TEXT_PLACEHOLDER":
                formattedValue += value;
                break;
            case "CHAR":
            case "STRING":
                formattedValue += token.value;
                break;
            case "REPEATED_CHAR":
                formattedValue += REPEATED_CHAR_PLACEHOLDER$1 + token.value;
                break;
        }
    }
    return repeatCharToFitWidth$1(formattedValue, formatWidth);
}
function repeatCharToFitWidth$1(formattedValue, formatWidth) {
    const placeholderIndex = formattedValue.indexOf(REPEATED_CHAR_PLACEHOLDER$1);
    if (placeholderIndex === -1) {
        return formattedValue;
    }
    const prefix = formattedValue.slice(0, placeholderIndex);
    const suffix = formattedValue.slice(placeholderIndex + REPEATED_CHAR_PLACEHOLDER$1.length + 1);
    const repeatedChar = formattedValue[placeholderIndex + REPEATED_CHAR_PLACEHOLDER$1.length];
    function getTimesToRepeat() {
        if (!formatWidth) {
            return { timesToRepeat: 0, padding: "" };
        }
        const widthTaken = formatWidth.measureText(prefix + suffix);
        const charWidth = formatWidth.measureText(repeatedChar);
        const availableWidth = formatWidth.availableWidth - widthTaken;
        if (availableWidth <= 0) {
            return { timesToRepeat: 0, padding: "" };
        }
        const timesToRepeat = Math.floor(availableWidth / charWidth);
        const remainingWidth = availableWidth - timesToRepeat * charWidth;
        const paddingChar = "\u2009"; // thin space
        const paddingWidth = formatWidth.measureText(paddingChar);
        const padding = paddingChar.repeat(Math.floor(remainingWidth / paddingWidth));
        return { timesToRepeat, padding };
    }
    const { timesToRepeat, padding } = getTimesToRepeat();
    return prefix + repeatedChar.repeat(timesToRepeat) + padding + suffix;
}
function applyInternalNumberFormat$1(value, format, locale) {
    if (value === Infinity) {
        return "∞" + (format.percentSymbols ? "%" : "");
    }
    const multiplier = format.percentSymbols * 2 - format.magnitude * 3;
    value = value * 10 ** multiplier;
    let maxDecimals = 0;
    if (format.decimalPart !== undefined) {
        maxDecimals = format.decimalPart.filter((token) => token.type === "DIGIT").length;
    }
    const { integerDigits, decimalDigits } = splitNumber$1(Math.abs(value), maxDecimals);
    let formattedValue = applyIntegerFormat$1(integerDigits, format, format.thousandsSeparator ? locale.thousandsSeparator : undefined);
    if (format.decimalPart !== undefined) {
        formattedValue += locale.decimalSeparator + applyDecimalFormat$1(decimalDigits || "", format);
    }
    return formattedValue;
}
function applyIntegerFormat$1(integerDigits, internalFormat, thousandsSeparator) {
    let tokens = internalFormat.integerPart;
    if (!tokens.some((token) => token.type === "DIGIT")) {
        tokens = [...tokens, { type: "DIGIT", value: "#" }];
    }
    if (integerDigits === "0") {
        integerDigits = "";
    }
    let formattedInteger = "";
    const firstDigitIndex = tokens.findIndex((token) => token.type === "DIGIT");
    let indexInIntegerString = integerDigits.length - 1;
    function appendDigitToFormattedValue(digit, digitType) {
        if (digitType === "0") {
            digit = digit || "0";
        }
        if (!digit)
            return;
        const digitIndex = integerDigits.length - 1 - indexInIntegerString;
        if (thousandsSeparator && digitIndex > 0 && digitIndex % 3 === 0) {
            formattedInteger = digit + thousandsSeparator + formattedInteger;
        }
        else {
            formattedInteger = digit + formattedInteger;
        }
    }
    for (let i = tokens.length - 1; i >= 0; i--) {
        const token = tokens[i];
        switch (token.type) {
            case "DIGIT":
                const digit = integerDigits[indexInIntegerString];
                appendDigitToFormattedValue(digit, token.value);
                indexInIntegerString--;
                // Apply the rest of the integer digits at the first digit character
                if (firstDigitIndex === i) {
                    while (indexInIntegerString >= 0) {
                        appendDigitToFormattedValue(integerDigits[indexInIntegerString], "0");
                        indexInIntegerString--;
                    }
                }
                break;
            case "THOUSANDS_SEPARATOR":
                break;
            case "REPEATED_CHAR":
                formattedInteger = REPEATED_CHAR_PLACEHOLDER$1 + token.value + formattedInteger;
                break;
            default:
                formattedInteger = token.value + formattedInteger;
                break;
        }
    }
    return formattedInteger;
}
function applyDecimalFormat$1(decimalDigits, internalFormat) {
    if (!internalFormat.decimalPart) {
        return "";
    }
    let formattedDecimals = "";
    let indexInDecimalString = 0;
    for (const token of internalFormat.decimalPart) {
        switch (token.type) {
            case "DIGIT":
                const digit = token.value === "#"
                    ? decimalDigits[indexInDecimalString] || ""
                    : decimalDigits[indexInDecimalString] || "0";
                formattedDecimals += digit;
                indexInDecimalString++;
                break;
            case "THOUSANDS_SEPARATOR":
                break;
            case "REPEATED_CHAR":
                formattedDecimals += REPEATED_CHAR_PLACEHOLDER$1 + token.value;
                break;
            default:
                formattedDecimals += token.value;
                break;
        }
    }
    return formattedDecimals;
}
/**
 * this is a cache that can contains number representation formats
 * from 0 (minimum) to 20 (maximum) digits after the decimal point
 */
const numberRepresentation$1 = [];
/** split a number into two strings that contain respectively:
 * - all digit stored in the integer part of the number
 * - all digit stored in the decimal part of the number
 *
 * The 'maxDecimal' parameter allows to indicate the number of digits to not
 * exceed in the decimal part, in which case digits are rounded.
 *
 **/
function splitNumber$1(value, maxDecimals = MAX_DECIMAL_PLACES$1) {
    const asString = value.toString();
    if (asString.includes("e"))
        return splitNumberIntl$1(value, maxDecimals);
    if (Number.isInteger(value)) {
        return { integerDigits: asString, decimalDigits: undefined };
    }
    const indexOfDot = asString.indexOf(".");
    let integerDigits = asString.substring(0, indexOfDot);
    let decimalDigits = asString.substring(indexOfDot + 1);
    if (maxDecimals === 0) {
        if (Number(decimalDigits[0]) >= 5) {
            integerDigits = (Number(integerDigits) + 1).toString();
        }
        return { integerDigits, decimalDigits: undefined };
    }
    if (decimalDigits.length > maxDecimals) {
        const { integerDigits: roundedIntegerDigits, decimalDigits: roundedDecimalDigits } = limitDecimalDigits$1(decimalDigits, maxDecimals);
        decimalDigits = roundedDecimalDigits;
        if (roundedIntegerDigits !== "0") {
            integerDigits = (Number(integerDigits) + Number(roundedIntegerDigits)).toString();
        }
    }
    return { integerDigits, decimalDigits: removeTrailingZeroes$1(decimalDigits || "") };
}
/**
 *  Return the given string minus the trailing "0" characters.
 *
 * @param numberString : a string of integers
 * @returns the numberString, minus the eventual zeroes at the end
 */
function removeTrailingZeroes$1(numberString) {
    let i = numberString.length - 1;
    while (i >= 0 && numberString[i] === "0") {
        i--;
    }
    return numberString.slice(0, i + 1) || undefined;
}
const leadingZeroesRegexp$1 = /^0+/;
/**
 * Limit the size of the decimal part of a number to the given number of digits.
 */
function limitDecimalDigits$1(decimalDigits, maxDecimals) {
    let integerDigits = "0";
    let resultDecimalDigits = decimalDigits;
    // Note : we'd want to simply use number.toFixed() to handle the max digits & rounding,
    // but it has very strange behaviour. Ex: 12.345.toFixed(2) => "12.35", but 1.345.toFixed(2) => "1.34"
    const slicedDecimalDigits = decimalDigits.slice(0, maxDecimals);
    const i = maxDecimals;
    if (Number(decimalDigits[i]) < 5) {
        return { integerDigits, decimalDigits: slicedDecimalDigits };
    }
    // round up
    const leadingZeroes = slicedDecimalDigits.match(leadingZeroesRegexp$1)?.[0] || "";
    const slicedRoundedUp = (Number(slicedDecimalDigits) + 1).toString();
    const withoutLeadingZeroes = slicedDecimalDigits.slice(leadingZeroes.length);
    // e.g. carry over from 99 to 100
    const carryOver = slicedRoundedUp.length > withoutLeadingZeroes.length;
    if (carryOver && !leadingZeroes) {
        integerDigits = "1";
        resultDecimalDigits = undefined;
    }
    else if (carryOver) {
        resultDecimalDigits = leadingZeroes.slice(0, -1) + slicedRoundedUp;
    }
    else {
        resultDecimalDigits = leadingZeroes + slicedRoundedUp;
    }
    return { integerDigits, decimalDigits: resultDecimalDigits };
}
/**
 * Split numbers into decimal/integer digits using Intl.NumberFormat.
 * Supports numbers with a lot of digits that are transformed to scientific notation by
 * number.toString(), but is slow.
 */
function splitNumberIntl$1(value, maxDecimals = MAX_DECIMAL_PLACES$1) {
    let formatter = numberRepresentation$1[maxDecimals];
    if (!formatter) {
        formatter = new Intl.NumberFormat("en-US", {
            maximumFractionDigits: maxDecimals,
            useGrouping: false,
        });
        numberRepresentation$1[maxDecimals] = formatter;
    }
    const [integerDigits, decimalDigits] = formatter.format(value).split(".");
    return { integerDigits, decimalDigits };
}
/** Convert a number into a string, without scientific notation */
function numberToString(number, decimalSeparator) {
    const { integerDigits, decimalDigits } = splitNumber$1(number, 20);
    return decimalDigits ? integerDigits + decimalSeparator + decimalDigits : integerDigits;
}
/**
 * Check if the given format is a time, date or date time format. Only check the first part of a multi-part format.
 */
const isDateTimeFormat = memoize$1(function isDateTimeFormat(format) {
    if (!format) {
        return false;
    }
    try {
        const internalFormat = parseFormat$1(format);
        return internalFormat.positive.type === "date";
    }
    catch (error) {
        return false;
    }
});
function applyDateTimeFormat$1(value, internalFormat) {
    const jsDate = numberToJsDate$1(value);
    const isMeridian = internalFormat.tokens.some((token) => token.type === "DATE_PART" && token.value === "a");
    let currentValue = "";
    for (const token of internalFormat.tokens) {
        switch (token.type) {
            case "DATE_PART":
                currentValue += formatJSDatePart$1(jsDate, token.value, isMeridian);
                break;
            case "REPEATED_CHAR":
                currentValue += REPEATED_CHAR_PLACEHOLDER$1 + token.value;
                break;
            default:
                currentValue += token.value;
                break;
        }
    }
    return currentValue;
}
function formatJSDatePart$1(jsDate, tokenValue, isMeridian) {
    switch (tokenValue) {
        case "d":
            return jsDate.getDate();
        case "dd":
            return jsDate.getDate().toString().padStart(2, "0");
        case "ddd":
            return DAYS$2[jsDate.getDay()].slice(0, 3);
        case "dddd":
            // force translation because somehow node 22 doesn't call LazyTranslatedString.toString() whe concatenating it to a string
            return DAYS$2[jsDate.getDay()].toString();
        case "m":
            return jsDate.getMonth() + 1;
        case "mm":
            return String(jsDate.getMonth() + 1).padStart(2, "0");
        case "mmm":
            return MONTHS$1[jsDate.getMonth()].slice(0, 3);
        case "mmmm":
            return MONTHS$1[jsDate.getMonth()].toString();
        case "mmmmm":
            return MONTHS$1[jsDate.getMonth()].slice(0, 1);
        case "qq":
            return _t$1("Q%(quarter)s", { quarter: jsDate.getQuarter() }).toString();
        case "qqqq":
            return _t$1("Quarter %(quarter)s", { quarter: jsDate.getQuarter() }).toString();
        case "yy":
            const fullYear = String(jsDate.getFullYear()).replace("-", "").padStart(2, "0");
            return fullYear.slice(fullYear.length - 2);
        case "yyyy":
            return jsDate.getFullYear();
        case "hhhh":
            const elapsedHours = Math.floor((jsDate.getTime() - INITIAL_1900_DAY$1.getTime()) / (60 * 60 * 1000));
            return elapsedHours.toString();
        case "hh":
            const dateHours = jsDate.getHours();
            let hours = dateHours;
            if (isMeridian) {
                hours = hours === 0 ? 12 : hours > 12 ? hours - 12 : hours;
            }
            return hours.toString().padStart(2, "0");
        case "MM": // "MM" replaces "mm" for minutes during format parsing
            return jsDate.getMinutes().toString().padStart(2, "0");
        case "ss":
            return jsDate.getSeconds().toString().padStart(2, "0");
        case "a":
            return jsDate.getHours() >= 12 ? "PM" : "AM";
        default:
            throw new Error(`invalid date format token: ${tokenValue}`);
    }
}
/**
 * Get a regex matching decimal number based on the locale's thousand separator
 *
 * eg. if the locale's thousand separator is a comma, this will return a regex /[0-9]+,[0-9]/
 */
const getDecimalNumberRegex = memoize$1(function getDecimalNumberRegex(locale) {
    return new RegExp(`[0-9]+${escapeRegExp$1(locale.decimalSeparator)}[0-9]`);
});
// -----------------------------------------------------------------------------
// CREATE / MODIFY FORMAT
// -----------------------------------------------------------------------------
/**
 * Create a default format for a number.
 *
 * If possible this will try round the number to have less than DEFAULT_FORMAT_NUMBER_OF_DIGITS characters
 * in the number. This is obviously only possible for number with a big decimal part. For number with a lot
 * of digits in the integer part, keep the number as it is.
 */
function createDefaultFormat$1(value) {
    let { integerDigits, decimalDigits } = splitNumber$1(value);
    if (!decimalDigits)
        return "0";
    const digitsInIntegerPart = integerDigits.replace("-", "").length;
    // If there's no space for at least the decimal separator + a decimal digit, don't display decimals
    if (digitsInIntegerPart + 2 > DEFAULT_FORMAT_NUMBER_OF_DIGITS$1) {
        return "0";
    }
    // -1 for the decimal separator character
    const spaceForDecimalsDigits = DEFAULT_FORMAT_NUMBER_OF_DIGITS$1 - digitsInIntegerPart - 1;
    ({ decimalDigits } = splitNumber$1(value, Math.min(spaceForDecimalsDigits, decimalDigits.length)));
    return decimalDigits ? "0." + "0".repeat(decimalDigits.length) : "0";
}
function detectDateFormat(content, locale) {
    if (!isDateTime(content, locale)) {
        return undefined;
    }
    const internalDate = parseDateTime(content, locale);
    return internalDate.format;
}
/** use this function only if the content corresponds to a number (means that isNumber(content) return true */
function detectNumberFormat(content) {
    const digitBase = content.includes(".") ? "0.00" : "0";
    const matchedCurrencies = content.match(/[\$€]/);
    if (matchedCurrencies) {
        const matchedFirstDigit = content.match(/[\d]/);
        const currency = "[$" + matchedCurrencies.values().next().value + "]";
        if (matchedFirstDigit.index < matchedCurrencies.index) {
            return "#,##" + digitBase + currency;
        }
        return currency + "#,##" + digitBase;
    }
    if (content.includes("%")) {
        return digitBase + "%";
    }
    return undefined;
}
function createCurrencyFormat(currency) {
    const decimalPlaces = currency.decimalPlaces ?? 2;
    const position = currency.position ?? "before";
    const code = currency.code ?? "";
    const symbol = currency.symbol ?? "";
    const decimalRepresentation = decimalPlaces ? "." + "0".repeat(decimalPlaces) : "";
    const numberFormat = "#,##0" + decimalRepresentation;
    let textExpression = `${code} ${symbol}`.trim();
    if (position === "after" && code) {
        textExpression = " " + textExpression;
    }
    return insertTextInFormat(textExpression, position, numberFormat);
}
function createAccountingFormat(currency) {
    const decimalPlaces = currency.decimalPlaces ?? 2;
    const position = currency.position ?? "before";
    const code = currency.code ?? "";
    const symbol = currency.symbol ?? "";
    const decimalRepresentation = decimalPlaces ? "." + "0".repeat(decimalPlaces) : "";
    const numberFormat = "#,##0" + decimalRepresentation;
    let textExpression = `${code} ${symbol}`.trim();
    if (position === "after" && code) {
        textExpression = " " + textExpression;
    }
    const positivePart = insertTextInAccountingFormat(textExpression, position, ` ${numberFormat} `);
    const negativePart = insertTextInAccountingFormat(textExpression, position, `(${numberFormat})`);
    const zeroPart = insertTextInAccountingFormat(textExpression, position, "  -  ");
    return [positivePart, negativePart, zeroPart].join(";");
}
function insertTextInAccountingFormat(text, position, format) {
    const textExpression = `[$${text}]`;
    return position === "before" ? textExpression + "* " + format : format + "* " + textExpression;
}
function insertTextInFormat(text, position, format) {
    const textExpression = `[$${text}]`;
    return position === "before" ? textExpression + format : format + textExpression;
}
function roundFormat(format) {
    const multiPartFormat = parseFormat$1(format);
    const roundedInternalFormat = {
        positive: _roundFormat(multiPartFormat.positive),
        negative: multiPartFormat.negative ? _roundFormat(multiPartFormat.negative) : undefined,
        zero: multiPartFormat.zero ? _roundFormat(multiPartFormat.zero) : undefined,
        text: multiPartFormat.text,
    };
    return convertInternalFormatToFormat(roundedInternalFormat);
}
function _roundFormat(internalFormat) {
    if (internalFormat.type !== "number" || !internalFormat.decimalPart) {
        return internalFormat;
    }
    const nonDigitDecimalPart = internalFormat.decimalPart.filter((token) => token.type !== "DIGIT");
    return {
        ...internalFormat,
        decimalPart: undefined,
        integerPart: [...internalFormat.integerPart, ...nonDigitDecimalPart],
    };
}
function humanizeNumber({ value, format }, locale) {
    const numberFormat = formatLargeNumber({
        value,
        format,
    }, undefined, locale);
    return formatValue$1(value, { format: numberFormat, locale });
}
function formatLargeNumber(arg, unit, locale) {
    let value = 0;
    try {
        value = Math.abs(toNumber(arg?.value, locale));
    }
    catch (e) {
        return "";
    }
    const format = arg?.format;
    if (unit !== undefined) {
        const postFix = unit?.value;
        switch (postFix) {
            case "k":
                return createLargeNumberFormat(format, 1, "k");
            case "m":
                return createLargeNumberFormat(format, 2, "m");
            case "b":
                return createLargeNumberFormat(format, 3, "b");
            default:
                throw new EvaluationError(_t$1("The formatting unit should be 'k', 'm' or 'b'."));
        }
    }
    if (value < 1e5) {
        return createLargeNumberFormat(format, 0, "");
    }
    else if (value < 1e8) {
        return createLargeNumberFormat(format, 1, "k");
    }
    else if (value < 1e11) {
        return createLargeNumberFormat(format, 2, "m");
    }
    return createLargeNumberFormat(format, 3, "b");
}
function createLargeNumberFormat(format, magnitude, postFix, locale) {
    const multiPartFormat = parseFormat$1(format || "#,##0");
    const roundedInternalFormat = {
        positive: _createLargeNumberFormat(multiPartFormat.positive, magnitude, postFix),
        negative: multiPartFormat.negative
            ? _createLargeNumberFormat(multiPartFormat.negative, magnitude, postFix)
            : undefined,
        zero: multiPartFormat.zero
            ? _createLargeNumberFormat(multiPartFormat.zero, magnitude, postFix)
            : undefined,
        text: multiPartFormat.text,
    };
    return convertInternalFormatToFormat(roundedInternalFormat);
}
function _createLargeNumberFormat(format, magnitude, postFix) {
    if (format.type !== "number") {
        return format;
    }
    const postFixToken = { type: "STRING", value: postFix };
    let newIntegerPart = [...format.integerPart];
    const lastDigitIndex = newIntegerPart.findLastIndex((token) => token.type === "DIGIT");
    if (lastDigitIndex === -1) {
        throw new Error("Cannot create a large number format from a format with no digit.");
    }
    while (newIntegerPart[lastDigitIndex + 1]?.type === "THOUSANDS_SEPARATOR") {
        newIntegerPart = removeIndexesFromArray(newIntegerPart, [lastDigitIndex + 1]);
    }
    const tokenAfterDigits = newIntegerPart[lastDigitIndex + 1];
    if (tokenAfterDigits?.type === "STRING" && ["m", "k", "b"].includes(tokenAfterDigits.value)) {
        newIntegerPart = replaceItemAtIndex(newIntegerPart, postFixToken, lastDigitIndex + 1);
    }
    else {
        newIntegerPart = insertItemsAtIndex(newIntegerPart, [postFixToken], lastDigitIndex + 1);
    }
    if (magnitude > 0) {
        newIntegerPart = insertItemsAtIndex(newIntegerPart, Array(magnitude).fill({ type: "THOUSANDS_SEPARATOR", value: "," }), lastDigitIndex + 1);
    }
    const missingPercents = format.percentSymbols - newIntegerPart.filter((tk) => tk.type === "PERCENT").length;
    newIntegerPart.push(...new Array(missingPercents).fill({ type: "PERCENT", value: "%" }));
    return { ...format, integerPart: newIntegerPart, decimalPart: undefined, magnitude };
}
function changeDecimalPlaces(format, step) {
    const multiPartFormat = parseFormat$1(format);
    const newInternalFormat = {
        positive: _changeDecimalPlace(multiPartFormat.positive, step),
        negative: multiPartFormat.negative
            ? _changeDecimalPlace(multiPartFormat.negative, step)
            : undefined,
        zero: multiPartFormat.zero ? _changeDecimalPlace(multiPartFormat.zero, step) : undefined,
        text: multiPartFormat.text,
    };
    // Re-parse the format to make sure we don't break the number of digit limit
    return convertInternalFormatToFormat(parseFormat$1(convertInternalFormatToFormat(newInternalFormat)));
}
function _changeDecimalPlace(format, step) {
    if (format.type !== "number") {
        return format;
    }
    return (step > 0 ? addDecimalPlaces(format, step) : removeDecimalPlaces(format, Math.abs(step)));
}
function removeDecimalPlaces(format, step) {
    let decimalPart = format.decimalPart;
    if (!decimalPart) {
        return format;
    }
    const indexesToRemove = [];
    let digitCount = 0;
    for (let i = decimalPart.length - 1; i >= 0; i--) {
        if (digitCount >= Math.abs(step)) {
            break;
        }
        if (decimalPart[i].type === "DIGIT") {
            digitCount++;
            indexesToRemove.push(i);
        }
    }
    decimalPart = removeIndexesFromArray(decimalPart, indexesToRemove);
    if (decimalPart.some((token) => token.type === "DIGIT")) {
        return { ...format, decimalPart };
    }
    return {
        ...format,
        decimalPart: undefined,
        integerPart: [...format.integerPart, ...decimalPart],
    };
}
function addDecimalPlaces(format, step) {
    let integerPart = format.integerPart;
    let decimalPart = format.decimalPart;
    if (!decimalPart) {
        const lastDigitIndex = integerPart.findLastIndex((token) => token.type === "DIGIT");
        decimalPart = integerPart.slice(lastDigitIndex + 1);
        integerPart = integerPart.slice(0, lastDigitIndex + 1);
    }
    const digitsToAdd = range$1(0, step).map(() => ({ type: "DIGIT", value: "0" }));
    const lastDigitIndex = decimalPart.findLastIndex((token) => token.type === "DIGIT");
    if (lastDigitIndex === -1) {
        decimalPart = [...digitsToAdd, ...decimalPart];
    }
    else {
        decimalPart = insertItemsAtIndex(decimalPart, digitsToAdd, lastDigitIndex + 1);
    }
    return { ...format, decimalPart, integerPart };
}
function isExcelCompatible(format) {
    const internalFormat = parseFormat$1(format);
    for (const part of [internalFormat.positive, internalFormat.negative, internalFormat.zero]) {
        if (part &&
            part.type === "date" &&
            part.tokens.some((token) => token.type === "DATE_PART" && token.value.includes("q"))) {
            return false;
        }
    }
    return true;
}
function isTextFormat(format) {
    if (!format)
        return false;
    try {
        const internalFormat = parseFormat$1(format);
        return internalFormat.positive.type === "text";
    }
    catch {
        return false;
    }
}
function formatHasRepeatedChar(value, format) {
    if (!format) {
        return false;
    }
    try {
        const internalFormat = parseFormat$1(format);
        const { format: formatToApply } = getFormatToApply$1(value, internalFormat);
        if (formatToApply?.type === "text" || formatToApply?.type === "date") {
            const tokens = formatToApply.tokens;
            return tokens.some((token) => token.type === "REPEATED_CHAR");
        }
        else if (formatToApply?.type === "number") {
            return (formatToApply.integerPart.some((token) => token.type === "REPEATED_CHAR") ||
                (formatToApply.decimalPart
                    ? formatToApply.decimalPart.some((token) => token.type === "REPEATED_CHAR")
                    : false));
        }
    }
    catch { }
    return false;
}

// -----------------------------------------------------------------------------
// FORMAT.LARGE.NUMBER
// -----------------------------------------------------------------------------
const FORMAT_LARGE_NUMBER = {
    description: _t$1("Apply a large number format"),
    args: [
        arg("value (number)", _t$1("The number.")),
        arg("unit (string, optional)", _t$1("The formatting unit. Use 'k', 'm', or 'b' to force the unit"), [
            { value: "k", label: _t$1("Thousand") },
            { value: "m", label: _t$1("Million") },
            { value: "b", label: _t$1("Billion") },
        ]),
    ],
    compute: function (value, unite) {
        return {
            value: toNumber(value, this.locale),
            format: formatLargeNumber(value, unite, this.locale),
        };
    },
};

var misc = /*#__PURE__*/Object.freeze({
    __proto__: null,
    FORMAT_LARGE_NUMBER: FORMAT_LARGE_NUMBER
});

const cellReference = new RegExp(/\$?([A-Z]{1,3})\$?([0-9]{1,7})/, "i");
const singleCellReference = new RegExp(/^\$?([A-Z]{1,3})\$?([0-9]{1,7})$/, "i");
const colHeader = new RegExp(/^\$?([A-Z]{1,3})+$/, "i");
const rowHeader = new RegExp(/^\$?([0-9]{1,7})+$/, "i");
const colReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([A-Z]{1,3})$/, "i");
const rowReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([0-9]{1,7})$/, "i");
const fullRowXc = /(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*:\s*(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*/i;
const fullColXc = /\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*:\s*\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*/i;
const rangeReference = new RegExp(/^\s*('.+'!|[^']+!)?/.source +
    "(" +
    [cellReference.source, fullRowXc.source, fullColXc.source].join("|") +
    ")" +
    /$/.source, "i");
function isColReference(xc) {
    return colReference.test(xc);
}
function isRowReference(xc) {
    return rowReference.test(xc);
}
function isColHeader(str) {
    return colHeader.test(str);
}
function isRowHeader(str) {
    return rowHeader.test(str);
}
function isSingleCellReference(xc) {
    return singleCellReference.test(xc);
}
function splitReference(ref) {
    if (!ref.includes("!")) {
        return { xc: ref };
    }
    const parts = ref.split("!");
    const xc = parts.pop();
    const sheetName = getUnquotedSheetName(parts.join("!")) || undefined;
    return { sheetName, xc };
}
function getFullReference(sheetName, xc) {
    return sheetName !== undefined ? `${getCanonicalSymbolName(sheetName)}!${xc}` : xc;
}
/**
 * Change the reference types inside the given token, if the token represent a range or a cell
 *
 * Eg. :
 *   A1 => $A$1 => A$1 => $A1 => A1
 *   A1:$B$1 => $A$1:B$1 => A$1:$B1 => $A1:B1 => A1:$B$1
 */
function loopThroughReferenceType(token) {
    if (token.type !== "REFERENCE")
        return token;
    const { xc, sheetName } = splitReference(token.value);
    const [left, right] = xc.split(":");
    const updatedLeft = getTokenNextReferenceType(left);
    const updatedRight = right ? `:${getTokenNextReferenceType(right)}` : "";
    return { ...token, value: getFullReference(sheetName, updatedLeft + updatedRight) };
}
/**
 * Get a new token with a changed type of reference from the given cell token symbol.
 * Undefined behavior if given a token other than a cell or if the Xc contains a sheet reference
 *
 * A1 => $A$1 => A$1 => $A1 => A1
 */
function getTokenNextReferenceType(xc) {
    switch (getReferenceType(xc)) {
        case "none":
            xc = setXcToFixedReferenceType(xc, "colrow");
            break;
        case "colrow":
            xc = setXcToFixedReferenceType(xc, "row");
            break;
        case "row":
            xc = setXcToFixedReferenceType(xc, "col");
            break;
        case "col":
            xc = setXcToFixedReferenceType(xc, "none");
            break;
    }
    return xc;
}
/**
 * Returns the given XC with the given reference type.
 */
function setXcToFixedReferenceType(xc, referenceType) {
    let sheetName;
    ({ sheetName, xc } = splitReference(xc));
    sheetName = sheetName ? sheetName + "!" : "";
    xc = xc.replace(/\$/g, "");
    const splitIndex = xc.indexOf(":");
    if (splitIndex >= 0) {
        return `${sheetName}${_setXcToFixedReferenceType(xc.slice(0, splitIndex), referenceType)}:${_setXcToFixedReferenceType(xc.slice(splitIndex + 1), referenceType)}`;
    }
    else {
        return sheetName + _setXcToFixedReferenceType(xc, referenceType);
    }
}
function _setXcToFixedReferenceType(xc, referenceType) {
    const indexOfNumber = xc.search(/[0-9]/);
    const hasCol = indexOfNumber !== 0;
    const hasRow = indexOfNumber >= 0;
    switch (referenceType) {
        case "col":
            if (!hasCol)
                return xc;
            return "$" + xc;
        case "row":
            if (!hasRow)
                return xc;
            return xc.slice(0, indexOfNumber) + "$" + xc.slice(indexOfNumber);
        case "colrow":
            if (!hasRow || !hasCol)
                return "$" + xc;
            return "$" + xc.slice(0, indexOfNumber) + "$" + xc.slice(indexOfNumber);
        case "none":
            return xc;
    }
}
/**
 * Return the type of reference used in the given XC of a cell.
 * Undefined behavior if the XC have a sheet reference
 */
function getReferenceType(xcCell) {
    if (isColAndRowFixed(xcCell)) {
        return "colrow";
    }
    else if (isColFixed(xcCell)) {
        return "col";
    }
    else if (isRowFixed(xcCell)) {
        return "row";
    }
    return "none";
}
function isColFixed(xc) {
    return xc.startsWith("$");
}
function isRowFixed(xc) {
    return xc.includes("$", 1);
}
function isColAndRowFixed(xc) {
    return xc.startsWith("$") && xc.length > 1 && xc.slice(1).includes("$");
}

/**
 * Create an empty structure according to the type of the node key:
 * string: object
 * number: array
 */
function createEmptyStructure(node) {
    if (typeof node === "string") {
        return {};
    }
    else if (typeof node === "number") {
        return [];
    }
    throw new Error(`Cannot create new node`);
}

/*
 * https://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
 * */
class UuidGenerator {
    // Helper to get a crypto object in any environment
    getCrypto() {
        if (typeof globalThis !== "undefined" && globalThis.crypto) {
            return globalThis.crypto;
        }
        // Node.js: try to require('crypto').webcrypto
        if (typeof require === "function") {
            try {
                const askKindly = require; // prevent odoo bundler to try to resolve 'crypto' module
                const nodeCrypto = askKindly("crypto");
                if (nodeCrypto.webcrypto) {
                    return nodeCrypto.webcrypto;
                }
            }
            catch (e) {
                // ignore
            }
        }
        return undefined;
    }
    /**
     * Generates a custom UUID using a simple 36^12 method (8-character alphanumeric string with lowercase letters)
     * This has a higher chance of collision than a UUIDv4, but not only faster to generate than an UUIDV4,
     * it also has a smaller size, which is preferable to alleviate the overall data size.
     *
     * This method is preferable when generating uuids for the core data (sheetId, figureId, etc)
     * as they will appear several times in the revisions and local history.
     *
     */
    smallUuid() {
        const cryptoObj = this.getCrypto();
        if (cryptoObj) {
            return "10000000-1000".replace(/[01]/g, (c) => {
                const n = Number(c);
                return (n ^ (cryptoObj.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
            });
        }
        else {
            // mainly for jest and other browsers that do not have the crypto functionality
            return "xxxxxxxx-xxxx".replace(/[xy]/g, function (c) {
                const r = (Math.random() * 16) | 0, v = c === "x" ? r : (r & 0x3) | 0x8;
                return v.toString(16);
            });
        }
    }
    /**
     * Generates an UUIDV4, has astronomically low chance of collision, but is larger in size than the smallUuid.
     * This method should be used when you need to avoid collisions at all costs, like the id of a revision.
     */
    uuidv4() {
        const cryptoObj = this.getCrypto();
        if (cryptoObj) {
            return "10000000-1000-4000-8000-100000000000".replace(/[018]/g, (c) => {
                const n = Number(c);
                return (n ^ (cryptoObj.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
            });
        }
        else {
            // mainly for jest and other browsers that do not have the crypto functionality
            return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
                const r = (Math.random() * 16) | 0, v = c === "x" ? r : (r & 0x3) | 0x8;
                return v.toString(16);
            });
        }
    }
}

function isSheetDependent(cmd) {
    return "sheetId" in cmd;
}
function isHeadersDependant(cmd) {
    return "dimension" in cmd && "sheetId" in cmd && "elements" in cmd;
}
function isTargetDependent(cmd) {
    return "target" in cmd && "sheetId" in cmd;
}
function isRangeDependant(cmd) {
    return "ranges" in cmd;
}
function isPositionDependent(cmd) {
    return "col" in cmd && "row" in cmd && "sheetId" in cmd;
}
function isZoneDependent(cmd) {
    return "sheetId" in cmd && "zone" in cmd;
}
const invalidateEvaluationCommands = new Set([
    "RENAME_SHEET",
    "DELETE_SHEET",
    "CREATE_SHEET",
    "DUPLICATE_SHEET",
    "ADD_COLUMNS_ROWS",
    "REMOVE_COLUMNS_ROWS",
    "UNDO",
    "REDO",
    "ADD_MERGE",
    "REMOVE_MERGE",
    "DUPLICATE_SHEET",
    "UPDATE_LOCALE",
    "ADD_PIVOT",
    "UPDATE_PIVOT",
    "INSERT_PIVOT",
    "RENAME_PIVOT",
    "REMOVE_PIVOT",
    "DUPLICATE_PIVOT",
]);
const invalidateChartEvaluationCommands = new Set([
    "EVALUATE_CELLS",
    "EVALUATE_CHARTS",
    "UPDATE_CELL",
    "UNHIDE_COLUMNS_ROWS",
    "HIDE_COLUMNS_ROWS",
    "GROUP_HEADERS",
    "UNGROUP_HEADERS",
    "FOLD_ALL_HEADER_GROUPS",
    "FOLD_HEADER_GROUP",
    "FOLD_HEADER_GROUPS_IN_ZONE",
    "UNFOLD_ALL_HEADER_GROUPS",
    "UNFOLD_HEADER_GROUP",
    "UNFOLD_HEADER_GROUPS_IN_ZONE",
    "UPDATE_TABLE",
    "UPDATE_FILTER",
    "UNDO",
    "REDO",
]);
const invalidateDependenciesCommands = new Set(["MOVE_RANGES"]);
const invalidateCFEvaluationCommands = new Set([
    "EVALUATE_CELLS",
    "ADD_CONDITIONAL_FORMAT",
    "REMOVE_CONDITIONAL_FORMAT",
    "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
]);
const invalidateBordersCommands = new Set([
    "AUTOFILL_CELL",
    "SET_BORDER",
    "SET_ZONE_BORDERS",
    "SET_BORDERS_ON_TARGET",
]);
const invalidSubtotalFormulasCommands = new Set([
    "UNHIDE_COLUMNS_ROWS",
    "HIDE_COLUMNS_ROWS",
    "GROUP_HEADERS",
    "UNGROUP_HEADERS",
    "FOLD_ALL_HEADER_GROUPS",
    "FOLD_HEADER_GROUP",
    "FOLD_HEADER_GROUPS_IN_ZONE",
    "UNFOLD_ALL_HEADER_GROUPS",
    "UNFOLD_HEADER_GROUP",
    "UNFOLD_HEADER_GROUPS_IN_ZONE",
    "UPDATE_TABLE",
    "UPDATE_FILTER",
]);
const readonlyAllowedCommands = new Set([
    "START",
    "ACTIVATE_SHEET",
    "COPY",
    "RESIZE_SHEETVIEW",
    "SET_VIEWPORT_OFFSET",
    "EVALUATE_CELLS",
    "EVALUATE_CHARTS",
    "SET_FORMULA_VISIBILITY",
    "UPDATE_FILTER",
    "UPDATE_CHART",
    "UPDATE_CAROUSEL_ACTIVE_ITEM",
    "UPDATE_PIVOT",
]);
const coreTypes = new Set([
    /** CELLS */
    "UPDATE_CELL",
    "UPDATE_CELL_POSITION",
    "CLEAR_CELL",
    "CLEAR_CELLS",
    "DELETE_CONTENT",
    /** GRID SHAPE */
    "ADD_COLUMNS_ROWS",
    "REMOVE_COLUMNS_ROWS",
    "RESIZE_COLUMNS_ROWS",
    "HIDE_COLUMNS_ROWS",
    "UNHIDE_COLUMNS_ROWS",
    "SET_GRID_LINES_VISIBILITY",
    "UNFREEZE_COLUMNS",
    "UNFREEZE_ROWS",
    "FREEZE_COLUMNS",
    "FREEZE_ROWS",
    "UNFREEZE_COLUMNS_ROWS",
    /** MERGE */
    "ADD_MERGE",
    "REMOVE_MERGE",
    /** SHEETS MANIPULATION */
    "CREATE_SHEET",
    "DELETE_SHEET",
    "DUPLICATE_SHEET",
    "MOVE_SHEET",
    "RENAME_SHEET",
    "COLOR_SHEET",
    "HIDE_SHEET",
    "SHOW_SHEET",
    /** RANGES MANIPULATION */
    "MOVE_RANGES",
    /** CONDITIONAL FORMAT */
    "ADD_CONDITIONAL_FORMAT",
    "REMOVE_CONDITIONAL_FORMAT",
    "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
    /** FIGURES */
    "CREATE_FIGURE",
    "DELETE_FIGURE",
    "UPDATE_FIGURE",
    "CREATE_CAROUSEL",
    "UPDATE_CAROUSEL",
    /** FORMATTING */
    "SET_FORMATTING",
    "CLEAR_FORMATTING",
    "SET_BORDER",
    "SET_ZONE_BORDERS",
    "SET_BORDERS_ON_TARGET",
    /** CHART */
    "CREATE_CHART",
    "UPDATE_CHART",
    "DELETE_CHART",
    /** FILTERS */
    "CREATE_TABLE",
    "REMOVE_TABLE",
    "UPDATE_TABLE",
    "CREATE_TABLE_STYLE",
    "REMOVE_TABLE_STYLE",
    /** IMAGE */
    "CREATE_IMAGE",
    /** HEADER GROUP */
    "GROUP_HEADERS",
    "UNGROUP_HEADERS",
    "UNFOLD_HEADER_GROUP",
    "FOLD_HEADER_GROUP",
    "FOLD_ALL_HEADER_GROUPS",
    "UNFOLD_ALL_HEADER_GROUPS",
    "UNFOLD_HEADER_GROUPS_IN_ZONE",
    "FOLD_HEADER_GROUPS_IN_ZONE",
    /** DATA VALIDATION */
    "ADD_DATA_VALIDATION_RULE",
    "REMOVE_DATA_VALIDATION_RULE",
    /** MISC */
    "UPDATE_LOCALE",
    /** PIVOT */
    "ADD_PIVOT",
    "UPDATE_PIVOT",
    "INSERT_PIVOT",
    "RENAME_PIVOT",
    "REMOVE_PIVOT",
    "DUPLICATE_PIVOT",
]);
function isCoreCommand(cmd) {
    return coreTypes.has(cmd.type);
}
function canExecuteInReadonly(cmd) {
    return readonlyAllowedCommands.has(cmd.type);
}
/**
 * Holds the result of a command dispatch.
 * The command may have been successfully dispatched or cancelled
 * for one or more reasons.
 */
class DispatchResult {
    reasons;
    constructor(results = []) {
        if (!Array.isArray(results)) {
            results = [results];
        }
        results = [...new Set(results)];
        this.reasons = results.filter((result) => result !== "Success" /* CommandResult.Success */);
    }
    /**
     * Static helper which returns a successful DispatchResult
     */
    static get Success() {
        return SUCCESS;
    }
    get isSuccessful() {
        return this.reasons.length === 0;
    }
    /**
     * Check if the dispatch has been cancelled because of
     * the given reason.
     */
    isCancelledBecause(reason) {
        return this.reasons.includes(reason);
    }
}
const SUCCESS = new DispatchResult();
var CommandResult;
(function (CommandResult) {
    CommandResult["Success"] = "Success";
    CommandResult["CancelledForUnknownReason"] = "CancelledForUnknownReason";
    CommandResult["WillRemoveExistingMerge"] = "WillRemoveExistingMerge";
    CommandResult["CannotMoveTableHeader"] = "CannotMoveTableHeader";
    CommandResult["MergeIsDestructive"] = "MergeIsDestructive";
    CommandResult["CellIsMerged"] = "CellIsMerged";
    CommandResult["InvalidTarget"] = "InvalidTarget";
    CommandResult["EmptyUndoStack"] = "EmptyUndoStack";
    CommandResult["EmptyRedoStack"] = "EmptyRedoStack";
    CommandResult["NotEnoughElements"] = "NotEnoughElements";
    CommandResult["NotEnoughSheets"] = "NotEnoughSheets";
    CommandResult["MissingSheetName"] = "MissingSheetName";
    CommandResult["UnchangedSheetName"] = "UnchangedSheetName";
    CommandResult["DuplicatedSheetName"] = "DuplicatedSheetName";
    CommandResult["DuplicatedSheetId"] = "DuplicatedSheetId";
    CommandResult["ForbiddenCharactersInSheetName"] = "ForbiddenCharactersInSheetName";
    CommandResult["WrongSheetMove"] = "WrongSheetMove";
    CommandResult["WrongSheetPosition"] = "WrongSheetPosition";
    CommandResult["InvalidAnchorZone"] = "InvalidAnchorZone";
    CommandResult["SelectionOutOfBound"] = "SelectionOutOfBound";
    CommandResult["TargetOutOfSheet"] = "TargetOutOfSheet";
    CommandResult["WrongCutSelection"] = "WrongCutSelection";
    CommandResult["WrongPasteSelection"] = "WrongPasteSelection";
    CommandResult["WrongPasteOption"] = "WrongPasteOption";
    CommandResult["WrongFigurePasteOption"] = "WrongFigurePasteOption";
    CommandResult["EmptyClipboard"] = "EmptyClipboard";
    CommandResult["EmptyRange"] = "EmptyRange";
    CommandResult["InvalidRange"] = "InvalidRange";
    CommandResult["InvalidZones"] = "InvalidZones";
    CommandResult["InvalidSheetId"] = "InvalidSheetId";
    CommandResult["InvalidCellId"] = "InvalidCellId";
    CommandResult["InvalidFigureId"] = "InvalidFigureId";
    CommandResult["InputAlreadyFocused"] = "InputAlreadyFocused";
    CommandResult["MaximumRangesReached"] = "MaximumRangesReached";
    CommandResult["MinimumRangesReached"] = "MinimumRangesReached";
    CommandResult["InvalidChartDefinition"] = "InvalidChartDefinition";
    CommandResult["InvalidDataSet"] = "InvalidDataSet";
    CommandResult["InvalidLabelRange"] = "InvalidLabelRange";
    CommandResult["InvalidScorecardKeyValue"] = "InvalidScorecardKeyValue";
    CommandResult["InvalidScorecardBaseline"] = "InvalidScorecardBaseline";
    CommandResult["InvalidGaugeDataRange"] = "InvalidGaugeDataRange";
    CommandResult["EmptyGaugeRangeMin"] = "EmptyGaugeRangeMin";
    CommandResult["GaugeRangeMinNaN"] = "GaugeRangeMinNaN";
    CommandResult["EmptyGaugeRangeMax"] = "EmptyGaugeRangeMax";
    CommandResult["GaugeRangeMaxNaN"] = "GaugeRangeMaxNaN";
    CommandResult["GaugeLowerInflectionPointNaN"] = "GaugeLowerInflectionPointNaN";
    CommandResult["GaugeUpperInflectionPointNaN"] = "GaugeUpperInflectionPointNaN";
    CommandResult["InvalidAutofillSelection"] = "InvalidAutofillSelection";
    CommandResult["MinBiggerThanMax"] = "MinBiggerThanMax";
    CommandResult["LowerBiggerThanUpper"] = "LowerBiggerThanUpper";
    CommandResult["MidBiggerThanMax"] = "MidBiggerThanMax";
    CommandResult["MinBiggerThanMid"] = "MinBiggerThanMid";
    CommandResult["FirstArgMissing"] = "FirstArgMissing";
    CommandResult["SecondArgMissing"] = "SecondArgMissing";
    CommandResult["MinNaN"] = "MinNaN";
    CommandResult["MidNaN"] = "MidNaN";
    CommandResult["MaxNaN"] = "MaxNaN";
    CommandResult["ValueUpperInflectionNaN"] = "ValueUpperInflectionNaN";
    CommandResult["ValueLowerInflectionNaN"] = "ValueLowerInflectionNaN";
    CommandResult["MinInvalidFormula"] = "MinInvalidFormula";
    CommandResult["MidInvalidFormula"] = "MidInvalidFormula";
    CommandResult["MaxInvalidFormula"] = "MaxInvalidFormula";
    CommandResult["ValueUpperInvalidFormula"] = "ValueUpperInvalidFormula";
    CommandResult["ValueLowerInvalidFormula"] = "ValueLowerInvalidFormula";
    CommandResult["InvalidSortAnchor"] = "InvalidSortAnchor";
    CommandResult["InvalidSortZone"] = "InvalidSortZone";
    CommandResult["SortZoneWithArrayFormulas"] = "SortZoneWithArrayFormulas";
    CommandResult["WaitingSessionConfirmation"] = "WaitingSessionConfirmation";
    CommandResult["MergeOverlap"] = "MergeOverlap";
    CommandResult["TooManyHiddenElements"] = "TooManyHiddenElements";
    CommandResult["Readonly"] = "Readonly";
    CommandResult["InvalidViewportSize"] = "InvalidViewportSize";
    CommandResult["InvalidScrollingDirection"] = "InvalidScrollingDirection";
    CommandResult["ViewportScrollLimitsReached"] = "ViewportScrollLimitsReached";
    CommandResult["FigureDoesNotExist"] = "FigureDoesNotExist";
    CommandResult["InvalidConditionalFormatId"] = "InvalidConditionalFormatId";
    CommandResult["InvalidCellPopover"] = "InvalidCellPopover";
    CommandResult["EmptyTarget"] = "EmptyTarget";
    CommandResult["InvalidFreezeQuantity"] = "InvalidFreezeQuantity";
    CommandResult["FrozenPaneOverlap"] = "FrozenPaneOverlap";
    CommandResult["ValuesNotChanged"] = "ValuesNotChanged";
    CommandResult["InvalidFilterZone"] = "InvalidFilterZone";
    CommandResult["TableNotFound"] = "TableNotFound";
    CommandResult["TableOverlap"] = "TableOverlap";
    CommandResult["InvalidTableConfig"] = "InvalidTableConfig";
    CommandResult["InvalidTableStyle"] = "InvalidTableStyle";
    CommandResult["FilterNotFound"] = "FilterNotFound";
    CommandResult["MergeInTable"] = "MergeInTable";
    CommandResult["NonContinuousTargets"] = "NonContinuousTargets";
    CommandResult["DuplicatedFigureId"] = "DuplicatedFigureId";
    CommandResult["InvalidSelectionStep"] = "InvalidSelectionStep";
    CommandResult["DuplicatedChartId"] = "DuplicatedChartId";
    CommandResult["ChartDoesNotExist"] = "ChartDoesNotExist";
    CommandResult["InvalidHeaderIndex"] = "InvalidHeaderIndex";
    CommandResult["InvalidQuantity"] = "InvalidQuantity";
    CommandResult["MoreThanOneColumnSelected"] = "MoreThanOneColumnSelected";
    CommandResult["EmptySplitSeparator"] = "EmptySplitSeparator";
    CommandResult["SplitWillOverwriteContent"] = "SplitWillOverwriteContent";
    CommandResult["NoSplitSeparatorInSelection"] = "NoSplitSeparatorInSelection";
    CommandResult["NoActiveSheet"] = "NoActiveSheet";
    CommandResult["InvalidLocale"] = "InvalidLocale";
    CommandResult["MoreThanOneRangeSelected"] = "MoreThanOneRangeSelected";
    CommandResult["NoColumnsProvided"] = "NoColumnsProvided";
    CommandResult["ColumnsNotIncludedInZone"] = "ColumnsNotIncludedInZone";
    CommandResult["DuplicatesColumnsSelected"] = "DuplicatesColumnsSelected";
    CommandResult["InvalidHeaderGroupStartEnd"] = "InvalidHeaderGroupStartEnd";
    CommandResult["HeaderGroupAlreadyExists"] = "HeaderGroupAlreadyExists";
    CommandResult["UnknownHeaderGroup"] = "UnknownHeaderGroup";
    CommandResult["UnknownDataValidationRule"] = "UnknownDataValidationRule";
    CommandResult["UnknownDataValidationCriterionType"] = "UnknownDataValidationCriterionType";
    CommandResult["InvalidDataValidationCriterionValue"] = "InvalidDataValidationCriterionValue";
    CommandResult["InvalidNumberOfCriterionValues"] = "InvalidNumberOfCriterionValues";
    CommandResult["InvalidCopyPasteSelection"] = "InvalidCopyPasteSelection";
    CommandResult["NoChanges"] = "NoChanges";
    CommandResult["InvalidInputId"] = "InvalidInputId";
    CommandResult["SheetIsHidden"] = "SheetIsHidden";
    CommandResult["InvalidTableResize"] = "InvalidTableResize";
    CommandResult["PivotIdNotFound"] = "PivotIdNotFound";
    CommandResult["PivotInError"] = "PivotInError";
    CommandResult["EmptyName"] = "EmptyName";
    CommandResult["ValueCellIsInvalidFormula"] = "ValueCellIsInvalidFormula";
    CommandResult["InvalidDefinition"] = "InvalidDefinition";
    CommandResult["InvalidColor"] = "InvalidColor";
    CommandResult["InvalidPivotDataSet"] = "InvalidPivotDataSet";
    CommandResult["InvalidPivotCustomField"] = "InvalidPivotCustomField";
    CommandResult["MissingFigureArguments"] = "MissingFigureArguments";
    CommandResult["InvalidCarouselItem"] = "InvalidCarouselItem";
})(CommandResult || (CommandResult = {}));

/**
 * BasePlugin
 *
 * Since the spreadsheet internal state is quite complex, it is split into
 * multiple parts, each managing a specific concern.
 *
 * This file introduces the BasePlugin, which is the common class that defines
 * how each of these model sub parts should interact with each other.
 * There are two kinds of plugins: core plugins handling persistent data
 * and UI plugins handling transient data.
 */
class BasePlugin {
    static getters = [];
    history;
    constructor(stateObserver) {
        this.history = Object.assign(Object.create(stateObserver), {
            update: stateObserver.addChange.bind(stateObserver, this),
            selectCell: () => { },
        });
    }
    /**
     * Export for excel should be available for all plugins, even for the UI.
     * In some cases, we need to export evaluated value, which is available from
     * UI plugin only.
     */
    exportForExcel(data) { }
    // ---------------------------------------------------------------------------
    // Command handling
    // ---------------------------------------------------------------------------
    /**
     * Before a command is accepted, the model will ask each plugin if the command
     * is allowed. If all of them return true, then we can proceed. Otherwise,
     * the command is cancelled.
     *
     * There should not be any side effects in this method.
     */
    allowDispatch(command) {
        return "Success" /* CommandResult.Success */;
    }
    /**
     * This method is useful when a plugin needs to perform some action before a
     * command is handled in another plugin. This should only be used if it is not
     * possible to do the work in the handle method.
     */
    beforeHandle(command) { }
    /**
     * This is the standard place to handle any command. Most of the plugin
     * command handling work should take place here.
     */
    handle(command) { }
    /**
     * Sometimes, it is useful to perform some work after a command (and all its
     * subcommands) has been completely handled. For example, when we paste
     * multiple cells, we only want to reevaluate the cell values once at the end.
     */
    finalize() { }
    /**
     * Combine multiple validation functions into a single function
     * returning the list of results of every validation.
     */
    batchValidations(...validations) {
        return (toValidate) => validations.map((validation) => validation.call(this, toValidate)).flat();
    }
    /**
     * Combine multiple validation functions. Every validation is executed one after
     * the other. As soon as one validation fails, it stops and the cancelled reason
     * is returned.
     */
    chainValidations(...validations) {
        return (toValidate) => {
            for (const validation of validations) {
                let results = validation.call(this, toValidate);
                if (!Array.isArray(results)) {
                    results = [results];
                }
                const cancelledReasons = results.filter((result) => result !== "Success" /* CommandResult.Success */);
                if (cancelledReasons.length) {
                    return cancelledReasons;
                }
            }
            return "Success" /* CommandResult.Success */;
        };
    }
    checkValidations(command, ...validations) {
        return this.batchValidations(...validations)(command);
    }
}

/**
 * UI plugins handle any transient data required to display a spreadsheet.
 * They can draw on the grid canvas.
 */
class UIPlugin extends BasePlugin {
    static layers = [];
    getters;
    ui;
    selection;
    dispatch;
    canDispatch;
    constructor({ getters, stateObserver, dispatch, canDispatch, uiActions, selection, }) {
        super(stateObserver);
        this.getters = getters;
        this.ui = uiActions;
        this.selection = selection;
        this.dispatch = dispatch;
        this.canDispatch = canDispatch;
    }
    // ---------------------------------------------------------------------------
    // Grid rendering
    // ---------------------------------------------------------------------------
    drawLayer(ctx, layer) { }
}

class SubtotalEvaluationPlugin extends UIPlugin {
    subtotalCells = new Set();
    handle(cmd) {
        switch (cmd.type) {
            case "START": {
                this.subtotalCells.clear();
                for (const sheetId of this.getters.getSheetIds()) {
                    const cells = this.getters.getCells(sheetId);
                    for (const cellId in cells) {
                        const cell = cells[cellId];
                        if (isSubtotalCell(cell)) {
                            this.subtotalCells.add(cell.id);
                        }
                    }
                }
                break;
            }
            case "UPDATE_CELL": {
                if (!("content" in cmd))
                    return;
                const cell = this.getters.getCell(cmd);
                if (!cell)
                    return;
                if (isSubtotalCell(cell)) {
                    this.subtotalCells.add(cell.id);
                }
                else {
                    this.subtotalCells.delete(cell.id);
                }
                break;
            }
        }
        if (invalidSubtotalFormulasCommands.has(cmd.type)) {
            this.dispatch("EVALUATE_CELLS", { cellIds: Array.from(this.subtotalCells) });
        }
    }
}
function isSubtotalCell(cell) {
    return (cell.isFormula &&
        cell.compiledFormula.tokens.some((t) => t.type === "SYMBOL" && t.value.toUpperCase() === "SUBTOTAL"));
}

function sum(values, locale) {
    return reduceNumbers(values, (acc, a) => acc + a, 0, locale);
}
function countUnique(args) {
    return reduceAny(args, (acc, a) => (isDataNonEmpty(a) ? acc.add(a?.value) : acc), new Set()).size;
}

const DEFAULT_FACTOR = 1;
const DEFAULT_MODE = 0;
const DEFAULT_PLACES = 0;
const DEFAULT_SIGNIFICANCE = 1;
const DECIMAL_REPRESENTATION = /^-?[a-z0-9]+$/i;
// -----------------------------------------------------------------------------
// ABS
// -----------------------------------------------------------------------------
const ABS = {
    description: _t$1("Absolute value of a number."),
    args: [arg("value (number)", _t$1("The number of which to return the absolute value."))],
    compute: function (value) {
        return Math.abs(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOS
// -----------------------------------------------------------------------------
const ACOS = {
    description: _t$1("Inverse cosine of a value, in radians."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse cosine. Must be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (Math.abs(_value) > 1) {
            return new EvaluationError(_t$1("The value (%s) must be between -1 and 1 inclusive.", _value));
        }
        return Math.acos(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOSH
// -----------------------------------------------------------------------------
const ACOSH = {
    description: _t$1("Inverse hyperbolic cosine of a number."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse hyperbolic cosine. Must be greater than or equal to 1.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (_value < 1) {
            return new EvaluationError(_t$1("The value (%s) must be greater than or equal to 1.", _value));
        }
        return Math.acosh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOT
// -----------------------------------------------------------------------------
const ACOT = {
    description: _t$1("Inverse cotangent of a value."),
    args: [arg("value (number)", _t$1("The value for which to calculate the inverse cotangent."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        const sign = Math.sign(_value) || 1;
        // ACOT has two possible configurations:
        // @compatibility Excel: return Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
        // @compatibility Google: return sign * Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
        return (sign * Math.PI) / 2 - Math.atan(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOTH
// -----------------------------------------------------------------------------
const ACOTH = {
    description: _t$1("Inverse hyperbolic cotangent of a value."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse hyperbolic cotangent. Must not be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (Math.abs(_value) <= 1) {
            return new EvaluationError(_t$1("The value (%s) cannot be between -1 and 1 inclusive.", _value));
        }
        return Math.log((_value + 1) / (_value - 1)) / 2;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ASIN
// -----------------------------------------------------------------------------
const ASIN = {
    description: _t$1("Inverse sine of a value, in radians."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse sine. Must be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (Math.abs(_value) > 1) {
            return new EvaluationError(_t$1("The value (%s) must be between -1 and 1 inclusive.", _value));
        }
        return Math.asin(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ASINH
// -----------------------------------------------------------------------------
const ASINH = {
    description: _t$1("Inverse hyperbolic sine of a number."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse hyperbolic sine.")),
    ],
    compute: function (value) {
        return Math.asinh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATAN
// -----------------------------------------------------------------------------
const ATAN = {
    description: _t$1("Inverse tangent of a value, in radians."),
    args: [arg("value (number)", _t$1("The value for which to calculate the inverse tangent."))],
    compute: function (value) {
        return Math.atan(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATAN2
// -----------------------------------------------------------------------------
const ATAN2 = {
    description: _t$1("Angle from the X axis to a point (x,y), in radians."),
    args: [
        arg("x (number)", _t$1("The x coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
        arg("y (number)", _t$1("The y coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
    ],
    compute: function (x, y) {
        const _x = toNumber(x, this.locale);
        const _y = toNumber(y, this.locale);
        if (_x === 0 && _y === 0) {
            return new DivisionByZeroError(_t$1("Function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return Math.atan2(_y, _x);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATANH
// -----------------------------------------------------------------------------
const ATANH = {
    description: _t$1("Inverse hyperbolic tangent of a number."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the inverse hyperbolic tangent. Must be between -1 and 1, exclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (Math.abs(_value) >= 1) {
            return new EvaluationError(_t$1("The value (%s) must be between -1 and 1 exclusive.", _value));
        }
        return Math.atanh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING
// -----------------------------------------------------------------------------
const CEILING = {
    description: _t$1("Rounds number up to nearest multiple of factor."),
    args: [
        arg("value (number)", _t$1("The value to round up to the nearest integer multiple of factor.")),
        arg(`factor (number, default=${DEFAULT_FACTOR})`, _t$1("The number to whose multiples value will be rounded.")),
    ],
    compute: function (value, factor = { value: DEFAULT_FACTOR }) {
        const _value = toNumber(value, this.locale);
        const _factor = toNumber(factor, this.locale);
        if (_factor < 0 && _value > 0) {
            return new EvaluationError(_t$1("The factor (%s) must be positive when the value (%s) is positive.", _factor, _value));
        }
        return {
            value: _factor ? Math.ceil(_value / _factor) * _factor : 0,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING.MATH
// -----------------------------------------------------------------------------
function ceilingMath(number, significance, mode = 0) {
    if (significance === 0) {
        return 0;
    }
    significance = Math.abs(significance);
    if (number >= 0) {
        return Math.ceil(number / significance) * significance;
    }
    if (mode === 0) {
        return -Math.floor(Math.abs(number) / significance) * significance;
    }
    return -Math.ceil(Math.abs(number) / significance) * significance;
}
const CEILING_MATH = {
    description: _t$1("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t$1("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t$1("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
        arg(`mode (number, default=${DEFAULT_MODE})`, _t$1("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded towards zero. Otherwise, it is rounded away from zero.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }, mode = { value: DEFAULT_MODE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        const _mode = toNumber(mode, this.locale);
        return {
            value: ceilingMath(_number, _significance, _mode),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING.PRECISE
// -----------------------------------------------------------------------------
const CEILING_PRECISE = {
    description: _t$1("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t$1("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t$1("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        return {
            value: ceilingMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COS
// -----------------------------------------------------------------------------
const COS = {
    description: _t$1("Cosine of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the cosine of, in radians."))],
    compute: function (angle) {
        return Math.cos(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COSH
// -----------------------------------------------------------------------------
const COSH = {
    description: _t$1("Hyperbolic cosine of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic cosine of."))],
    compute: function (value) {
        return Math.cosh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COT
// -----------------------------------------------------------------------------
const COT = {
    description: _t$1("Cotangent of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the cotangent of, in radians."))],
    compute: function (angle) {
        const _angle = toNumber(angle, this.locale);
        if (_angle === 0) {
            return new DivisionByZeroError(_t$1("Function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return 1 / Math.tan(_angle);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COTH
// -----------------------------------------------------------------------------
const COTH = {
    description: _t$1("Hyperbolic cotangent of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic cotangent of."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (_value === 0) {
            return new DivisionByZeroError(_t$1("Function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return 1 / Math.tanh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTBLANK
// -----------------------------------------------------------------------------
const COUNTBLANK = {
    description: _t$1("Number of empty values."),
    args: [
        arg("value1 (any, range)", _t$1("The first value or range in which to count the number of blanks.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values or ranges in which to count the number of blanks.")),
    ],
    compute: function (...args) {
        return reduceAny(args, (acc, a) => {
            if (a === undefined) {
                return acc + 1;
            }
            if (a.value === null) {
                return acc + 1;
            }
            if (a.value === "") {
                return acc + 1;
            }
            return acc;
        }, 0);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTIF
// -----------------------------------------------------------------------------
const COUNTIF = {
    description: _t$1("A conditional count across a range."),
    args: [
        arg("range (range)", _t$1("The range that is tested against criterion.")),
        arg("criterion (string)", _t$1("The pattern or test to apply to range.")),
    ],
    compute: function (...args) {
        let count = 0;
        visitMatchingRanges(args, (i, j) => {
            count += 1;
        }, this.locale);
        return count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTIFS
// -----------------------------------------------------------------------------
const COUNTIFS = {
    description: _t$1("Count values depending on multiple criteria."),
    args: [
        arg("criteria_range1 (range)", _t$1("The range to check against criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t$1("Additional criteria to check.")),
    ],
    compute: function (...args) {
        let count = 0;
        visitMatchingRanges(args, (i, j) => {
            count += 1;
        }, this.locale);
        return count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTUNIQUE
// -----------------------------------------------------------------------------
const COUNTUNIQUE = {
    description: _t$1("Counts number of unique values in a range."),
    args: [
        arg("value1 (any, range)", _t$1("The first value or range to consider for uniqueness.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values or ranges to consider for uniqueness.")),
    ],
    compute: function (...args) {
        return countUnique(args);
    },
};
// -----------------------------------------------------------------------------
// COUNTUNIQUEIFS
// -----------------------------------------------------------------------------
const COUNTUNIQUEIFS = {
    description: _t$1("Counts number of unique values in a range, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t$1("The range of cells from which the number of unique values will be counted.")),
        arg("criteria_range1 (range)", _t$1("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t$1("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        const uniqueValues = new Set();
        visitMatchingRanges(args, (i, j) => {
            const data = range[i]?.[j];
            if (isDataNonEmpty(data)) {
                uniqueValues.add(data.value);
            }
        }, this.locale);
        return uniqueValues.size;
    },
};
// -----------------------------------------------------------------------------
// CSC
// -----------------------------------------------------------------------------
const CSC = {
    description: _t$1("Cosecant of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the cosecant of, in radians."))],
    compute: function (angle) {
        const _angle = toNumber(angle, this.locale);
        if (_angle === 0) {
            return new DivisionByZeroError(_t$1("Function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return 1 / Math.sin(_angle);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CSCH
// -----------------------------------------------------------------------------
const CSCH = {
    description: _t$1("Hyperbolic cosecant of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic cosecant of."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (_value === 0) {
            return new DivisionByZeroError(_t$1("Function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return 1 / Math.sinh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DECIMAL
// -----------------------------------------------------------------------------
const DECIMAL = {
    description: _t$1("Converts from another base to decimal."),
    args: [
        arg("value (string)", _t$1("The number to convert.")),
        arg("base (number)", _t$1("The base to convert the value from.")),
    ],
    compute: function (value, base) {
        let _base = toNumber(base, this.locale);
        _base = Math.floor(_base);
        if (2 > _base || _base > 36) {
            return new EvaluationError(_t$1("The base (%s) must be between 2 and 36 inclusive.", _base));
        }
        const _value = toString(value);
        if (_value === "") {
            return 0;
        }
        /**
         * @compatibility: on Google sheets, expects the parameter 'value' to be positive.
         * Return error if 'value' is positive.
         * Remove '-?' in the next regex to catch this error.
         */
        if (!DECIMAL_REPRESENTATION.test(_value)) {
            return new EvaluationError(_t$1("The value (%s) must be a valid base %s representation.", _value, _base));
        }
        const deci = parseInt(_value, _base);
        if (isNaN(deci)) {
            return new EvaluationError(_t$1("The value (%s) must be a valid base %s representation.", _value, _base));
        }
        return deci;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DEGREES
// -----------------------------------------------------------------------------
const DEGREES = {
    description: _t$1("Converts an angle value in radians to degrees."),
    args: [arg("angle (number)", _t$1("The angle to convert from radians to degrees."))],
    compute: function (angle) {
        return (toNumber(angle, this.locale) * 180) / Math.PI;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EXP
// -----------------------------------------------------------------------------
const EXP = {
    description: _t$1("Euler's number, e (~2.718) raised to a power."),
    args: [arg("value (number)", _t$1("The exponent to raise e."))],
    compute: function (value) {
        return Math.exp(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR
// -----------------------------------------------------------------------------
const FLOOR = {
    description: _t$1("Rounds number down to nearest multiple of factor."),
    args: [
        arg("value (number)", _t$1("The value to round down to the nearest integer multiple of factor.")),
        arg(`factor (number, default=${DEFAULT_FACTOR})`, _t$1("The number to whose multiples value will be rounded.")),
    ],
    compute: function (value, factor = { value: DEFAULT_FACTOR }) {
        const _value = toNumber(value, this.locale);
        const _factor = toNumber(factor, this.locale);
        if (_factor < 0 && _value > 0) {
            return new EvaluationError(_t$1("The factor (%s) must be positive when the value (%s) is positive.", _factor, _value));
        }
        return {
            value: _factor ? Math.floor(_value / _factor) * _factor : 0,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR.MATH
// -----------------------------------------------------------------------------
function floorMath(number, significance, mode = 0) {
    if (significance === 0) {
        return 0;
    }
    significance = Math.abs(significance);
    if (number >= 0) {
        return Math.floor(number / significance) * significance;
    }
    if (mode === 0) {
        return -Math.ceil(Math.abs(number) / significance) * significance;
    }
    return -Math.floor(Math.abs(number) / significance) * significance;
}
const FLOOR_MATH = {
    description: _t$1("Rounds number down to nearest multiple of factor."),
    args: [
        arg("number (number)", _t$1("The value to round down to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t$1("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
        arg(`mode (number, default=${DEFAULT_MODE})`, _t$1("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded away from zero. Otherwise, it is rounded towards zero.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }, mode = { value: DEFAULT_MODE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        const _mode = toNumber(mode, this.locale);
        return {
            value: floorMath(_number, _significance, _mode),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR.PRECISE
// -----------------------------------------------------------------------------
const FLOOR_PRECISE = {
    description: _t$1("Rounds number down to nearest multiple of factor."),
    args: [
        arg("number (number)", _t$1("The value to round down to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t$1("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        return {
            value: floorMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISEVEN
// -----------------------------------------------------------------------------
const ISEVEN = {
    description: _t$1("Whether the provided value is even."),
    args: [arg("value (number)", _t$1("The value to be verified as even."))],
    compute: function (value) {
        const _value = strictToNumber(value, this.locale);
        return Math.floor(Math.abs(_value)) & 1 ? false : true;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISO.CEILING
// -----------------------------------------------------------------------------
const ISO_CEILING = {
    description: _t$1("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t$1("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t$1("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _number = toNumber(number, this.locale);
        const _significance = toNumber(significance, this.locale);
        return {
            value: ceilingMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISODD
// -----------------------------------------------------------------------------
const ISODD = {
    description: _t$1("Whether the provided value is even."),
    args: [arg("value (number)", _t$1("The value to be verified as even."))],
    compute: function (value) {
        const _value = strictToNumber(value, this.locale);
        return Math.floor(Math.abs(_value)) & 1 ? true : false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LN
// -----------------------------------------------------------------------------
const LN = {
    description: _t$1("The logarithm of a number, base e (euler's number)."),
    args: [arg("value (number)", _t$1("The value for which to calculate the logarithm, base e."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (_value <= 0) {
            return new EvaluationError(_t$1("The value (%s) must be strictly positive.", _value));
        }
        return Math.log(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOG
// -----------------------------------------------------------------------------
const LOG = {
    description: _t$1("The logarithm of a number, for a given base."),
    args: [
        arg("value (number)", _t$1("The value for which to calculate the logarithm.")),
        arg("base (number, default=10)", _t$1("The base of the logarithm.")),
    ],
    compute: function (value, base = { value: 10 }) {
        const _value = toNumber(value, this.locale);
        const _base = toNumber(base, this.locale);
        if (_value <= 0) {
            return new EvaluationError(_t$1("The value (%s) must be strictly positive.", _value));
        }
        if (_base <= 0) {
            return new EvaluationError(_t$1("The base (%s) must be strictly positive.", _base));
        }
        if (_base === 1) {
            return new EvaluationError(_t$1("The base must be different from 1."));
        }
        return Math.log10(_value) / Math.log10(_base);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MOD
// -----------------------------------------------------------------------------
function mod(dividend, divisor) {
    assertNotZero(divisor, _t$1("The divisor must be different from 0."));
    const modulus = dividend % divisor;
    // -42 % 10 = -2 but we want 8, so need the code below
    if ((modulus > 0 && divisor < 0) || (modulus < 0 && divisor > 0)) {
        return modulus + divisor;
    }
    return modulus;
}
const MOD = {
    description: _t$1("Modulo (remainder) operator."),
    args: [
        arg("dividend (number)", _t$1("The number to be divided to find the remainder.")),
        arg("divisor (number)", _t$1("The number to divide by.")),
    ],
    compute: function (dividend, divisor) {
        const _divisor = toNumber(divisor, this.locale);
        const _dividend = toNumber(dividend, this.locale);
        return {
            value: mod(_dividend, _divisor),
            format: dividend?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MUNIT
// -----------------------------------------------------------------------------
const MUNIT = {
    description: _t$1("Returns a n x n unit matrix, where n is the input dimension."),
    args: [
        arg("dimension (number)", _t$1("An integer specifying the dimension size of the unit matrix. It must be positive.")),
    ],
    compute: function (n) {
        const _n = toInteger(n, this.locale);
        if (_n < 1) {
            return new EvaluationError(_t$1("The argument dimension must be positive"));
        }
        return getUnitMatrix(_n);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ODD
// -----------------------------------------------------------------------------
const ODD = {
    description: _t$1("Rounds a number up to the nearest odd integer."),
    args: [arg("value (number)", _t$1("The value to round to the next greatest odd number."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        let temp = Math.ceil(Math.abs(_value));
        temp = temp & 1 ? temp : temp + 1;
        return {
            value: _value < 0 ? -temp : temp,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PI
// -----------------------------------------------------------------------------
const PI = {
    description: _t$1("The number pi."),
    args: [],
    compute: function () {
        return Math.PI;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// POWER
// -----------------------------------------------------------------------------
const POWER = {
    description: _t$1("A number raised to a power."),
    args: [
        arg("base (number)", _t$1("The number to raise to the exponent power.")),
        arg("exponent (number)", _t$1("The exponent to raise base to.")),
    ],
    compute: function (base, exponent) {
        const _base = toNumber(base, this.locale);
        const _exponent = toNumber(exponent, this.locale);
        if (_base < 0 && !Number.isInteger(_exponent)) {
            return new EvaluationError(_t$1("The exponent (%s) must be an integer when the base is negative.", _exponent));
        }
        return { value: Math.pow(_base, _exponent), format: base?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRODUCT
// -----------------------------------------------------------------------------
const PRODUCT = {
    description: _t$1("Result of multiplying a series of numbers together."),
    args: [
        arg("factor1 (number, range<number>)", _t$1("The first number or range to calculate for the product.")),
        arg("factor2 (number, range<number>, repeating)", _t$1("More numbers or ranges to calculate for the product.")),
    ],
    compute: function (...factors) {
        let count = 0;
        let acc = 1;
        for (const n of factors) {
            if (isMatrix(n)) {
                for (const i of n) {
                    for (const j of i) {
                        const f = j.value;
                        if (typeof f === "number") {
                            acc *= f;
                            count += 1;
                        }
                        if (isEvaluationError(f)) {
                            return j;
                        }
                    }
                }
            }
            else if (n !== undefined && n.value !== null) {
                acc *= strictToNumber(n, this.locale);
                count += 1;
            }
        }
        return {
            value: count === 0 ? 0 : acc,
            format: inferFormat(factors[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RAND
// -----------------------------------------------------------------------------
const RAND = {
    description: _t$1("A random number between 0 inclusive and 1 exclusive."),
    args: [],
    compute: function () {
        return Math.random();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RANDARRAY
// -----------------------------------------------------------------------------
const RANDARRAY = {
    description: _t$1("Returns a grid of random numbers between 0 inclusive and 1 exclusive."),
    args: [
        arg("rows (number, default=1)", _t$1("The number of rows to be returned.")),
        arg("columns (number, default=1)", _t$1("The number of columns to be returned.")),
        arg("min (number, default=0)", _t$1("The minimum number you would like returned.")),
        arg("max (number, default=1)", _t$1("The maximum number you would like returned.")),
        arg("whole_number (boolean, default=FALSE)", _t$1("Return a whole number or a decimal value."), [
            { value: false, label: _t$1("Decimal (default)") },
            { value: true, label: _t$1("Integer") },
        ]),
    ],
    compute: function (rows = { value: 1 }, columns = { value: 1 }, min = { value: 0 }, max = { value: 1 }, wholeNumber = { value: false }) {
        const _cols = toInteger(columns, this.locale);
        const _rows = toInteger(rows, this.locale);
        const _min = toNumber(min, this.locale);
        const _max = toNumber(max, this.locale);
        const _whole_number = toBoolean(wholeNumber);
        if (_cols < 1) {
            return new EvaluationError(_t$1("The number of columns (%s) must be positive.", _cols));
        }
        if (_rows < 1) {
            return new EvaluationError(_t$1("The number of rows (%s) must be positive.", _rows));
        }
        if (_min > _max) {
            return new EvaluationError(_t$1("The maximum (%s) must be greater than or equal to the minimum (%s).", _max, _min));
        }
        if (_whole_number) {
            if (!Number.isInteger(_min) || !Number.isInteger(_max)) {
                return new EvaluationError(_t$1("The maximum (%s) and minimum (%s) must be integers when whole_number is TRUE.", _max.toString(), _min.toString()));
            }
        }
        const result = Array(_cols);
        for (let col = 0; col < _cols; col++) {
            result[col] = Array(_rows);
            for (let row = 0; row < _rows; row++) {
                if (!_whole_number) {
                    result[col][row] = _min + Math.random() * (_max - _min);
                }
                else {
                    result[col][row] = Math.floor(Math.random() * (_max - _min + 1) + _min);
                }
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RANDBETWEEN
// -----------------------------------------------------------------------------
const RANDBETWEEN = {
    description: _t$1("Random integer between two values, inclusive."),
    args: [
        arg("low (number)", _t$1("The low end of the random range.")),
        arg("high (number)", _t$1("The high end of the random range.")),
    ],
    compute: function (low, high) {
        let _low = toNumber(low, this.locale);
        if (!Number.isInteger(_low)) {
            _low = Math.ceil(_low);
        }
        let _high = toNumber(high, this.locale);
        if (!Number.isInteger(_high)) {
            _high = Math.floor(_high);
        }
        if (_low > _high) {
            return new EvaluationError(_t$1("The high (%s) must be greater than or equal to the low (%s).", _high, _low));
        }
        return {
            value: _low + Math.ceil((_high - _low + 1) * Math.random()) - 1,
            format: low?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUND
// -----------------------------------------------------------------------------
const ROUND = {
    description: _t$1("Rounds a number according to standard rules."),
    args: [
        arg("value (number)", _t$1("The value to round to places number of places.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t$1("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.round(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.round(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUNDDOWN
// -----------------------------------------------------------------------------
const ROUNDDOWN = {
    description: _t$1("Rounds down a number."),
    args: [
        arg("value (number)", _t$1("The value to round to places number of places, always rounding down.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t$1("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.floor(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.floor(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUNDUP
// -----------------------------------------------------------------------------
const ROUNDUP = {
    description: _t$1("Rounds up a number."),
    args: [
        arg("value (number)", _t$1("The value to round to places number of places, always rounding up.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t$1("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.ceil(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.ceil(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SEC
// -----------------------------------------------------------------------------
const SEC = {
    description: _t$1("Secant of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the secant of, in radians."))],
    compute: function (angle) {
        return 1 / Math.cos(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SECH
// -----------------------------------------------------------------------------
const SECH = {
    description: _t$1("Hyperbolic secant of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic secant of."))],
    compute: function (value) {
        return 1 / Math.cosh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SEQUENCE
// -----------------------------------------------------------------------------
const SEQUENCE = {
    description: _t$1("Returns a sequence of numbers."),
    args: [
        arg("rows (number)", _t$1("The number of rows to return")),
        arg("columns (number, optional, default=1)", _t$1("The number of columns to return")),
        arg("start (number, optional, default=1)", _t$1("The first number in the sequence")),
        arg("step (number, optional, default=1)", _t$1("The amount to increment each value in the sequence")),
    ],
    compute: function (rows, columns = { value: 1 }, start = { value: 1 }, step = { value: 1 }) {
        const _start = toNumber(start, this.locale);
        const _step = toNumber(step, this.locale);
        const _rows = toInteger(rows, this.locale);
        const _columns = toInteger(columns, this.locale);
        if (_columns < 1) {
            return new EvaluationError(_t$1("The number of columns (%s) must be positive.", _columns));
        }
        if (_rows < 1) {
            return new EvaluationError(_t$1("The number of rows (%s) must be positive.", _rows));
        }
        return generateMatrix(_columns, _rows, (col, row) => {
            return {
                value: _start + row * _columns * _step + col * _step,
            };
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SIN
// -----------------------------------------------------------------------------
const SIN = {
    description: _t$1("Sine of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the sine of, in radians."))],
    compute: function (angle) {
        return Math.sin(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SINH
// -----------------------------------------------------------------------------
const SINH = {
    description: _t$1("Hyperbolic sine of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic sine of."))],
    compute: function (value) {
        return Math.sinh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SQRT
// -----------------------------------------------------------------------------
const SQRT = {
    description: _t$1("Positive square root of a positive number."),
    args: [arg("value (number)", _t$1("The number for which to calculate the positive square root."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        if (_value < 0) {
            return new EvaluationError(_t$1("The value (%s) must be positive or null.", _value));
        }
        return { value: Math.sqrt(_value), format: value?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUBTOTAL
// -----------------------------------------------------------------------------
const subtotalFunctionAggregateByCode = {
    1: "AVERAGE",
    2: "COUNT",
    3: "COUNTA",
    4: "MAX",
    5: "MIN",
    6: "PRODUCT",
    7: "STDEV",
    8: "STDEVP",
    9: "SUM",
    10: "VAR",
    11: "VARP",
};
const subtotalFunctionOptionsIncludeHiddenRows = Object.entries(subtotalFunctionAggregateByCode).map(([number, functionName]) => ({
    value: parseInt(number),
    label: _t$1("%s (include manually-hidden rows)", functionName),
}));
const subtotalFunctionOptionsExcludeHiddenRows = Object.entries(subtotalFunctionAggregateByCode).map(([number, functionName]) => ({
    value: parseInt(number) + 100,
    label: _t$1("%s (exclude manually-hidden rows)", functionName),
}));
const SUBTOTAL = {
    description: _t$1("Returns a subtotal for a vertical range of cells using a specified aggregation function."),
    args: [
        arg("function_code (number)", _t$1("The function to use in subtotal aggregation."), [
            ...subtotalFunctionOptionsIncludeHiddenRows,
            ...subtotalFunctionOptionsExcludeHiddenRows,
        ]),
        arg("ref1 (meta, range<meta>)", _t$1("The range or reference for which you want the subtotal.")),
        arg("ref2 (meta, range<meta>, repeating)", _t$1("Additional ranges or references for which you want the subtotal.")),
    ],
    compute: function (functionCode, ...refs) {
        let code = toInteger(functionCode, this.locale);
        let acceptHiddenCells = true;
        if (code > 100) {
            code -= 100;
            acceptHiddenCells = false;
        }
        if (code < 1 || code > 11) {
            return new EvaluationError(_t$1("The function code (%s) must be between 1 to 11 or 101 to 111.", code));
        }
        const evaluatedCellToKeep = [];
        for (const ref of refs) {
            const ref0 = ref[0][0];
            const sheetName = splitReference(ref0.value).sheetName;
            const sheetId = sheetName ? this.getters.getSheetIdByName(sheetName) : this.__originSheetId;
            if (!sheetId)
                continue;
            const { top, left } = toZone(ref0.value);
            const right = left + ref.length - 1;
            const bottom = top + ref[0].length - 1;
            for (let row = top; row <= bottom; row++) {
                if (this.getters.isRowFiltered(sheetId, row))
                    continue;
                if (!acceptHiddenCells && this.getters.isRowHiddenByUser(sheetId, row))
                    continue;
                for (let col = left; col <= right; col++) {
                    const cell = this.getters.getCell({ sheetId, col, row });
                    if (!cell || !isSubtotalCell(cell)) {
                        evaluatedCellToKeep.push(this.getters.getEvaluatedCell({ sheetId, col, row }));
                    }
                }
            }
        }
        return this[subtotalFunctionAggregateByCode[code]].apply(this, [[evaluatedCellToKeep]]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUM
// -----------------------------------------------------------------------------
const SUM = {
    description: _t$1("Sum of a series of numbers and/or cells."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first number or range to add together.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional numbers or ranges to add to value1.")),
    ],
    compute: function (...values) {
        const v1 = values[0];
        return {
            value: sum(values, this.locale),
            format: inferFormat(v1),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMIF
// -----------------------------------------------------------------------------
const SUMIF = {
    description: _t$1("A conditional sum across a range."),
    args: [
        arg("criteria_range (range)", _t$1("The range which is tested against criterion.")),
        arg("criterion (string)", _t$1("The pattern or test to apply to range.")),
        arg("sum_range (range, default=criteria_range)", _t$1("The range to be summed, if different from range.")),
    ],
    compute: function (criteriaRange, criterion, sumRange) {
        if (sumRange === undefined) {
            sumRange = criteriaRange;
        }
        let sum = 0;
        visitMatchingRanges([criteriaRange, criterion], (i, j) => {
            const value = sumRange[i]?.[j]?.value;
            if (typeof value === "number") {
                sum += value;
            }
        }, this.locale);
        return sum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMIFS
// -----------------------------------------------------------------------------
const SUMIFS = {
    description: _t$1("Sums a range depending on multiple criteria."),
    args: [
        arg("sum_range (range)", _t$1("The range to sum.")),
        arg("criteria_range1 (range)", _t$1("The range to check against criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional ranges to check.")),
        arg("criterion2 (string, repeating)", _t$1("Additional criteria to check.")),
    ],
    compute: function (sumRange, ...criters) {
        let sum = 0;
        visitMatchingRanges(criters, (i, j) => {
            const value = sumRange[i]?.[j]?.value;
            if (typeof value === "number") {
                sum += value;
            }
        }, this.locale);
        return sum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TAN
// -----------------------------------------------------------------------------
const TAN = {
    description: _t$1("Tangent of an angle provided in radians."),
    args: [arg("angle (number)", _t$1("The angle to find the tangent of, in radians."))],
    compute: function (angle) {
        return Math.tan(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TANH
// -----------------------------------------------------------------------------
const TANH = {
    description: _t$1("Hyperbolic tangent of any real number."),
    args: [arg("value (number)", _t$1("Any real value to calculate the hyperbolic tangent of."))],
    compute: function (value) {
        return Math.tanh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRUNC
// -----------------------------------------------------------------------------
function trunc(value, places) {
    if (places === 0) {
        return Math.trunc(value);
    }
    if (!Number.isInteger(places)) {
        places = Math.trunc(places);
    }
    return Math.trunc(value * Math.pow(10, places)) / Math.pow(10, places);
}
const TRUNC = {
    description: _t$1("Truncates a number."),
    args: [
        arg("value (number)", _t$1("The value to be truncated.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t$1("The number of significant digits to the right of the decimal point to retain.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        const _places = toNumber(places, this.locale);
        return { value: trunc(_value, _places), format: value?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INT
// -----------------------------------------------------------------------------
const INT = {
    description: _t$1("Rounds a number down to the nearest integer that is less than or equal to it."),
    args: [arg("value (number)", _t$1("The number to round down to the nearest integer."))],
    compute: function (value) {
        return Math.floor(toNumber(value, this.locale));
    },
    isExported: true,
};

var math = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ABS: ABS,
    ACOS: ACOS,
    ACOSH: ACOSH,
    ACOT: ACOT,
    ACOTH: ACOTH,
    ASIN: ASIN,
    ASINH: ASINH,
    ATAN: ATAN,
    ATAN2: ATAN2,
    ATANH: ATANH,
    CEILING: CEILING,
    CEILING_MATH: CEILING_MATH,
    CEILING_PRECISE: CEILING_PRECISE,
    COS: COS,
    COSH: COSH,
    COT: COT,
    COTH: COTH,
    COUNTBLANK: COUNTBLANK,
    COUNTIF: COUNTIF,
    COUNTIFS: COUNTIFS,
    COUNTUNIQUE: COUNTUNIQUE,
    COUNTUNIQUEIFS: COUNTUNIQUEIFS,
    CSC: CSC,
    CSCH: CSCH,
    DECIMAL: DECIMAL,
    DEGREES: DEGREES,
    EXP: EXP,
    FLOOR: FLOOR,
    FLOOR_MATH: FLOOR_MATH,
    FLOOR_PRECISE: FLOOR_PRECISE,
    INT: INT,
    ISEVEN: ISEVEN,
    ISODD: ISODD,
    ISO_CEILING: ISO_CEILING,
    LN: LN,
    LOG: LOG,
    MOD: MOD,
    MUNIT: MUNIT,
    ODD: ODD,
    PI: PI,
    POWER: POWER,
    PRODUCT: PRODUCT,
    RAND: RAND,
    RANDARRAY: RANDARRAY,
    RANDBETWEEN: RANDBETWEEN,
    ROUND: ROUND,
    ROUNDDOWN: ROUNDDOWN,
    ROUNDUP: ROUNDUP,
    SEC: SEC,
    SECH: SECH,
    SEQUENCE: SEQUENCE,
    SIN: SIN,
    SINH: SINH,
    SQRT: SQRT,
    SUBTOTAL: SUBTOTAL,
    SUM: SUM,
    SUMIF: SUMIF,
    SUMIFS: SUMIFS,
    TAN: TAN,
    TANH: TANH,
    TRUNC: TRUNC
});

function assertSameNumberOfElements(...args) {
    const dims = args[0].length;
    args.forEach((arg, i) => assert(arg.length === dims, _t$1("[[FUNCTION_NAME]] has mismatched dimensions for argument %s (%s vs %s).", i.toString(), dims.toString(), arg.length.toString())));
}
function average(values, locale) {
    let count = 0;
    const sum = reduceNumbers(values, (acc, a) => {
        count += 1;
        return acc + a;
    }, 0, locale);
    assertNotZero(count);
    return sum / count;
}
function countNumbers(values, locale) {
    let count = 0;
    for (const n of values) {
        if (isMatrix(n)) {
            for (const i of n) {
                for (const j of i) {
                    if (typeof j.value === "number") {
                        count += 1;
                    }
                }
            }
        }
        else {
            const value = n?.value;
            if (!isEvaluationError(value) &&
                (typeof value !== "string" || isNumber(value, locale) || parseDateTime(value, locale))) {
                count += 1;
            }
        }
    }
    return count;
}
function countAny(values) {
    return reduceAny(values, (acc, a) => (a !== undefined && a.value !== null ? acc + 1 : acc), 0);
}
function max(values, locale) {
    let max = { value: -Infinity };
    visitNumbers(values, (a) => {
        if (a.value >= max.value) {
            max = a;
        }
    }, locale);
    return max.value === -Infinity ? { value: 0 } : max;
}
function min(values, locale) {
    let min = { value: Infinity };
    visitNumbers(values, (a) => {
        if (a.value <= min.value) {
            min = a;
        }
    }, locale);
    return min.value === Infinity ? { value: 0 } : min;
}
function prepareDataForRegression(X, Y, newX) {
    const _X = X[0].length ? X : [range$1(1, Y.flat().length + 1)];
    const nVar = _X.length;
    let _newX = newX[0].length ? newX : _X;
    _newX = _newX.length === nVar ? transposeMatrix(_newX) : _newX;
    return { _X, _newX };
}
/*
 * This function performs a linear regression on the data set. It returns an array with two elements.
 * The first element is the slope, and the second element is the intercept.
 * The linear regression line is: y = slope*x + intercept
 * The function use the least squares method to find the best fit for the data set :
 * see https://www.mathsisfun.com/data/least-squares-regression.html
 *     https://www.statology.org/standard-error-of-estimate/
 *     https://agronomy4future.org/?p=16670
 *     https://vitalflux.com/interpreting-f-statistics-in-linear-regression-formula-examples/
 *     https://web.ist.utl.pt/~ist11038/compute/errtheory/,regression/regrthroughorigin.pdf
 */
function fullLinearRegression(X, Y, computeIntercept = true, verbose = false) {
    const y = Y.flat();
    const n = y.length;
    let { _X } = prepareDataForRegression(X, Y, [[]]);
    _X = _X.length === n ? transposeMatrix(_X) : _X.slice();
    assertSameNumberOfElements(_X[0], y);
    const nVar = _X.length;
    const nDeg = n - nVar - (computeIntercept ? 1 : 0);
    const yMatrix = [y];
    const xMatrix = transposeMatrix(_X.reverse());
    const avgX = [];
    for (let i = 0; i < nVar; i++) {
        avgX.push(0);
        if (computeIntercept) {
            for (const xij of _X[i]) {
                avgX[i] += xij;
            }
            avgX[i] /= n;
        }
    }
    let avgY = 0;
    if (computeIntercept) {
        for (const yi of y) {
            avgY += yi;
        }
        avgY /= n;
    }
    const redX = xMatrix.map((row) => row.map((value, i) => value - avgX[i]));
    if (computeIntercept) {
        xMatrix.forEach((row) => row.push(1));
    }
    const coeffs = getLMSCoefficients(xMatrix, yMatrix);
    if (!computeIntercept) {
        coeffs.push([0]);
    }
    if (!verbose) {
        return coeffs;
    }
    const dot1 = multiplyMatrices(redX, transposeMatrix(redX));
    const { inverted: dotInv } = invertMatrix(dot1);
    if (dotInv === undefined) {
        throw new EvaluationError(_t$1("Matrix is not invertible"));
    }
    let SSE = 0, SSR = 0;
    for (let i = 0; i < n; i++) {
        const yi = y[i] - avgY;
        let temp = 0;
        for (let j = 0; j < nVar; j++) {
            const xi = redX[i][j];
            temp += xi * coeffs[j][0];
        }
        const ei = yi - temp;
        SSE += ei * ei;
        SSR += temp * temp;
    }
    const RMSE = Math.sqrt(SSE / nDeg);
    const r2 = SSR / (SSR + SSE);
    const f_stat = SSR / nVar / (SSE / nDeg);
    const deltaCoeffs = [];
    for (let i = 0; i < nVar; i++) {
        deltaCoeffs.push(RMSE * Math.sqrt(dotInv[i][i]));
    }
    if (computeIntercept) {
        const dot2 = multiplyMatrices(dotInv, [avgX]);
        const dot3 = multiplyMatrices(transposeMatrix([avgX]), dot2);
        deltaCoeffs.push(RMSE * Math.sqrt(dot3[0][0] + 1 / y.length));
    }
    const returned = [
        [coeffs[0][0], deltaCoeffs[0], r2, f_stat, SSR],
        [coeffs[1][0], deltaCoeffs[1], RMSE, nDeg, SSE],
    ];
    for (let i = 2; i < nVar; i++) {
        returned.push([coeffs[i][0], deltaCoeffs[i], "", "", ""]);
    }
    if (computeIntercept) {
        returned.push([coeffs[nVar][0], deltaCoeffs[nVar], "", "", ""]);
    }
    else {
        returned.push([0, "", "", "", ""]);
    }
    return returned;
}
/*
  This function performs a polynomial regression on the data set. It returns the coefficients of
  the polynomial function that best fits the data set.
  The polynomial function is: y = c0 + c1*x + c2*x^2 + ... + cn*x^n, where n is the order (degree)
  of the polynomial. The returned coefficients are then in the form: [c0, c1, c2, ..., cn]
  The function is based on the method of least squares :
  see: https://mathworld.wolfram.com/LeastSquaresFittingPolynomial.html
*/
function polynomialRegression(flatY, flatX, order, intercept) {
    assertSameNumberOfElements(flatX, flatY);
    assert(order >= 1, _t$1("Function [[FUNCTION_NAME]] A regression of order less than 1 cannot be possible."));
    const yMatrix = [flatY];
    const xMatrix = flatX.map((x) => range$1(0, order).map((i) => Math.pow(x, order - i)));
    if (intercept) {
        xMatrix.forEach((row) => row.push(1));
    }
    const coeffs = getLMSCoefficients(xMatrix, yMatrix);
    if (!intercept) {
        coeffs.push([0]);
    }
    return coeffs;
}
function getLMSCoefficients(xMatrix, yMatrix) {
    const xMatrixT = transposeMatrix(xMatrix);
    const dot1 = multiplyMatrices(xMatrix, xMatrixT);
    const { inverted: dotInv } = invertMatrix(dot1);
    if (dotInv === undefined) {
        throw new EvaluationError(_t$1("Matrix is not invertible"));
    }
    const dot2 = multiplyMatrices(xMatrix, yMatrix);
    return transposeMatrix(multiplyMatrices(dotInv, dot2));
}
function evaluatePolynomial(coeffs, x, order) {
    return coeffs.reduce((acc, coeff, i) => acc + coeff * Math.pow(x, order - i), 0);
}
function expM(M) {
    return M.map((col) => col.map((cell) => Math.exp(cell)));
}
function logM(M) {
    return M.map((col) => col.map((cell) => Math.log(cell)));
}
function predictLinearValues(Y, X, newX, computeIntercept) {
    const { _X, _newX } = prepareDataForRegression(X, Y, newX);
    const coeffs = fullLinearRegression(_X, Y, computeIntercept, false);
    const nVar = coeffs.length - 1;
    const newY = _newX.map((col) => {
        let value = 0;
        for (let i = 0; i < nVar; i++) {
            value += coeffs[i][0] * col[nVar - i - 1];
        }
        value += coeffs[nVar][0];
        return [value];
    });
    return newY.length === newX.length ? newY : transposeMatrix(newY);
}
function getMovingAverageValues(dataset, labels, windowSize = DEFAULT_WINDOW_SIZE) {
    const values = [];
    // Fill the starting values with null until we have a full window
    for (let i = 0; i < windowSize - 1; i++) {
        values.push({ x: labels[i], y: NaN });
    }
    for (let i = 0; i <= dataset.length - windowSize; i++) {
        let sum = 0;
        for (let j = i; j < i + windowSize; j++) {
            sum += dataset[j];
        }
        values.push({ x: labels[i + windowSize - 1], y: sum / windowSize });
    }
    return values;
}

const CALCULATE_B_OPTIONS = [
    { value: true, label: _t$1("b is calculated normally") },
    { value: false, label: _t$1("b is forced to 1") },
];
const RETURN_VERBOSE_OPTIONS = [
    { value: false, label: _t$1("do not return additional regression statistics") },
    { value: true, label: _t$1("return additional regression statistics") },
];
const POLYNOMIAL_ORDER_OPTIONS = [
    { value: 1, label: _t$1("order 1 (Linear)") },
    { value: 2, label: _t$1("order 2 (Quadratic)") },
    { value: 3, label: _t$1("order 3 (Cubic)") },
    { value: 4, label: _t$1("order 4 (Quartic)") },
    { value: 5, label: _t$1("order 5 (Quintic)") },
    { value: 6, label: _t$1("order 6 (Sextic)") },
];
const COMPUTE_INTERCEPT_OPTIONS = [
    { value: true, label: _t$1("Compute intercept") },
    { value: false, label: _t$1("Force intercept to 0") },
];
const QUARTILE_NUMBER_OPTIONS = [
    { value: 0, label: _t$1("Minimum value") },
    { value: 1, label: _t$1("First quartile (25th percentile)") },
    { value: 2, label: _t$1("Median value (50th percentile)") },
    { value: 3, label: _t$1("Third quartile (75th percentile)") },
    { value: 4, label: _t$1("Maximum value") },
];
function filterAndFlatData(dataY, dataX) {
    const _flatDataY = [];
    const _flatDataX = [];
    let lenY = 0;
    let lenX = 0;
    visitAny([dataY], (y) => {
        _flatDataY.push(y);
        lenY += 1;
    });
    visitAny([dataX], (x) => {
        _flatDataX.push(x);
        lenX += 1;
    });
    assert(lenY === lenX, _t$1("[[FUNCTION_NAME]] has mismatched argument count %s vs %s.", lenY, lenX));
    const flatDataX = [];
    const flatDataY = [];
    for (let i = 0; i < lenY; i++) {
        const valueY = _flatDataY[i]?.value;
        const valueX = _flatDataX[i]?.value;
        if (typeof valueY === "number" && typeof valueX === "number") {
            flatDataY.push(valueY);
            flatDataX.push(valueX);
        }
    }
    return { flatDataX, flatDataY };
}
// Note: dataY and dataX may not have the same dimension
function covariance(dataY, dataX, isSample) {
    const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
    const count = flatDataY.length;
    assertNotZero(count);
    if (isSample) {
        assertNotZero(count - 1);
    }
    let sumY = 0;
    let sumX = 0;
    for (let i = 0; i < count; i++) {
        sumY += flatDataY[i];
        sumX += flatDataX[i];
    }
    const averageY = sumY / count;
    const averageX = sumX / count;
    let acc = 0;
    for (let i = 0; i < count; i++) {
        acc += (flatDataY[i] - averageY) * (flatDataX[i] - averageX);
    }
    return acc / (count - (isSample ? 1 : 0));
}
function variance(args, isSample, textAs0, locale) {
    let count = 0;
    const reduceFunction = textAs0 ? reduceNumbersTextAs0 : reduceNumbers;
    const sum = reduceFunction(args, (acc, a) => {
        count += 1;
        return acc + a;
    }, 0, locale);
    assertNotZero(count);
    if (isSample) {
        assertNotZero(count - 1);
    }
    const average = sum / count;
    return (reduceFunction(args, (acc, a) => acc + Math.pow(a - average, 2), 0, locale) /
        (count - (isSample ? 1 : 0)));
}
function centile(data, percent, isInclusive, locale) {
    const _percent = toNumber(percent, locale);
    assert(isInclusive ? 0 <= _percent && _percent <= 1 : 0 < _percent && _percent < 1, _t$1("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
    const sortedArray = [];
    let index;
    let count = 0;
    visitAny(data, (d) => {
        const value = d?.value;
        if (typeof value === "number") {
            index = dichotomicSearch(sortedArray, d, "nextSmaller", "asc", sortedArray.length, (array, i) => array[i]);
            sortedArray.splice(index + 1, 0, value);
            count++;
        }
    });
    assert(count !== 0, noValidInputErrorMessage);
    if (!isInclusive) {
        // 2nd argument must be between 1/(n+1) and n/(n+1) with n the number of data
        assert(1 / (count + 1) <= _percent && _percent <= count / (count + 1), _t$1("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
    }
    return percentile(sortedArray, _percent, isInclusive);
}
// -----------------------------------------------------------------------------
// AVEDEV
// -----------------------------------------------------------------------------
const AVEDEV = {
    description: _t$1("Average magnitude of deviations from mean."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...values) {
        let count = 0;
        const sum = reduceNumbers(values, (acc, a) => {
            count += 1;
            return acc + a;
        }, 0, this.locale);
        if (count === 0) {
            return new DivisionByZeroError(_t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        const average = sum / count;
        return reduceNumbers(values, (acc, a) => acc + Math.abs(average - a), 0, this.locale) / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGE
// -----------------------------------------------------------------------------
const AVERAGE = {
    description: _t$1("Numerical average value in a dataset, ignoring text."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range to consider when calculating the average value.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to consider when calculating the average value.")),
    ],
    compute: function (...values) {
        return {
            value: average(values, this.locale),
            format: inferFormat(values[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGE.WEIGHTED
// -----------------------------------------------------------------------------
const rangeError = _t$1("[[FUNCTION_NAME]] has mismatched range sizes.");
const negativeWeightError = _t$1("[[FUNCTION_NAME]] expects the weight to be positive or equal to 0.");
const AVERAGE_WEIGHTED = {
    description: _t$1("Weighted average."),
    args: [
        arg("values (number, range<number>)", _t$1("Values to average.")),
        arg("weights (number, range<number>)", _t$1("Weights for each corresponding value.")),
        arg("additional_values (number, range<number>, repeating)", _t$1("Additional values to average.")),
        arg("additional_weights (number, range<number>, repeating)", _t$1("Additional weights.")),
    ],
    compute: function (...args) {
        let sum = 0;
        let count = 0;
        for (let n = 0; n < args.length - 1; n += 2) {
            const argN = args[n];
            const argN1 = args[n + 1];
            if (!areSameDimensions(argN, argN1)) {
                return new EvaluationError(rangeError);
            }
            if (isMatrix(argN)) {
                for (let i = 0; i < argN.length; i++) {
                    for (let j = 0; j < argN[0].length; j++) {
                        const value = argN[i][j].value;
                        const weight = isMatrix(argN1) ? argN1?.[i][j].value : toNumber(argN1, this.locale);
                        const valueIsNumber = typeof value === "number";
                        const weightIsNumber = typeof weight === "number";
                        if (valueIsNumber && weightIsNumber) {
                            if (weight < 0) {
                                return new EvaluationError(negativeWeightError);
                            }
                            sum += value * weight;
                            count += weight;
                            continue;
                        }
                        if (valueIsNumber !== weightIsNumber) {
                            return new EvaluationError(_t$1("[[FUNCTION_NAME]] expects number values."));
                        }
                    }
                }
            }
            else {
                const value = toNumber(argN, this.locale);
                const weight = isMatrix(argN1) ? argN1?.[0][0].value : toNumber(argN1, this.locale);
                if (typeof weight === "number") {
                    if (weight < 0) {
                        return new EvaluationError(negativeWeightError);
                    }
                    sum += value * weight;
                    count += weight;
                }
            }
        }
        if (count === 0) {
            return new DivisionByZeroError(_t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return { value: sum / count, format: inferFormat(args[0]) };
    },
};
// -----------------------------------------------------------------------------
// AVERAGEA
// -----------------------------------------------------------------------------
const AVERAGEA = {
    description: _t$1("Numerical average value in a dataset."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range to consider when calculating the average value.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to consider when calculating the average value.")),
    ],
    compute: function (...args) {
        let count = 0;
        const sum = reduceNumbersTextAs0(args, (acc, a) => {
            count += 1;
            return acc + a;
        }, 0, this.locale);
        if (count === 0) {
            return new DivisionByZeroError(_t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return {
            value: sum / count,
            format: inferFormat(args[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGEIF
// -----------------------------------------------------------------------------
const AVERAGEIF = {
    description: _t$1("Average of values depending on criteria."),
    args: [
        arg("criteria_range (number, range<number>)", _t$1("The range to check against criterion.")),
        arg("criterion (string)", _t$1("The pattern or test to apply to criteria_range.")),
        arg("average_range (number, range<number>, default=criteria_range)", _t$1("The range to average. If not included, criteria_range is used for the average instead.")),
    ],
    compute: function (criteriaRange, criterion, averageRange) {
        const _averageRange = averageRange === undefined ? toMatrix(criteriaRange) : toMatrix(averageRange);
        let count = 0;
        let sum = 0;
        visitMatchingRanges([criteriaRange, criterion], (i, j) => {
            const value = _averageRange[i]?.[j]?.value;
            if (typeof value === "number") {
                count += 1;
                sum += value;
            }
        }, this.locale);
        if (count === 0) {
            return new DivisionByZeroError(_t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGEIFS
// -----------------------------------------------------------------------------
const AVERAGEIFS = {
    description: _t$1("Average of values depending on multiple criteria."),
    args: [
        arg("average_range (range)", _t$1("The range to average.")),
        arg("criteria_range1 (range)", _t$1("The range to check against criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional criteria_range and criterion to check.")),
        arg("criterion2 (string, repeating)", _t$1("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (averageRange, ...args) {
        const _averageRange = toMatrix(averageRange);
        let count = 0;
        let sum = 0;
        visitMatchingRanges(args, (i, j) => {
            const value = _averageRange[i]?.[j]?.value;
            if (typeof value === "number") {
                count += 1;
                sum += value;
            }
        }, this.locale);
        if (count === 0) {
            return new DivisionByZeroError(_t$1("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        }
        return sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNT
// -----------------------------------------------------------------------------
const COUNT = {
    description: _t$1("The number of numeric values in dataset."),
    args: [
        arg("value1 (number, any, range<number>)", _t$1("The first value or range to consider when counting.")),
        arg("value2 (number, any, range<number>, repeating)", _t$1("Additional values or ranges to consider when counting.")),
    ],
    compute: function (...values) {
        return countNumbers(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTA
// -----------------------------------------------------------------------------
const COUNTA = {
    description: _t$1("The number of values in a dataset."),
    args: [
        arg("value1 (any, range)", _t$1("The first value or range to consider when counting.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values or ranges to consider when counting.")),
    ],
    compute: function (...values) {
        return countAny(values);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVAR
// -----------------------------------------------------------------------------
// Note: Unlike the VAR function which corresponds to the variance over a sample (VAR.S),
// the COVAR function corresponds to the covariance over an entire population (COVAR.P)
const COVAR = {
    description: _t$1("The covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, false);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVARIANCE.P
// -----------------------------------------------------------------------------
const COVARIANCE_P = {
    description: _t$1("The covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, false);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVARIANCE.S
// -----------------------------------------------------------------------------
const COVARIANCE_S = {
    description: _t$1("The sample covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, true);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FORECAST
// -----------------------------------------------------------------------------
const FORECAST = {
    description: _t$1("Calculates the expected y-value for a specified x based on a linear regression of a dataset."),
    args: [
        arg("x (number, range<number>)", _t$1("The value(s) on the x-axis to forecast.")),
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (x, dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        return predictLinearValues([flatDataY], [flatDataX], matrixMap(toMatrix(x), (value) => toNumber(value, this.locale)), true);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// GROWTH
// -----------------------------------------------------------------------------
const GROWTH = {
    description: _t$1("Fits points to exponential growth trend."),
    args: [
        arg("known_data_y (range<number>)", _t$1("The array or range containing dependent (y) values that are already known, used to curve fit an ideal exponential growth curve.")),
        arg("known_data_x (range<number>, default={1;2;3;...})", _t$1("The values of the independent variable(s) corresponding with known_data_y.")),
        arg("new_data_x (any, range, default=known_data_x)", _t$1("The data points to return the y values for on the ideal curve fit.")),
        arg("b (boolean, default=TRUE)", _t$1("Given a general exponential form of y = b*m^x for a curve fit, calculates b if TRUE or forces b to be 1 and only calculates the m values if FALSE."), CALCULATE_B_OPTIONS),
    ],
    compute: function (knownDataY, knownDataX = [[]], newDataX = [[]], b = { value: true }) {
        if (knownDataY.length === 0 || knownDataY[0].length === 0) {
            return new EvaluationError(emptyDataErrorMessage("known_data_y"));
        }
        return expM(predictLinearValues(logM(toNumberMatrix(knownDataY, "known_data_y")), toNumberMatrix(knownDataX, "known_data_x"), toNumberMatrix(newDataX, "new_data_y"), toBoolean(b)));
    },
};
// -----------------------------------------------------------------------------
// INTERCEPT
// -----------------------------------------------------------------------------
const INTERCEPT = {
    description: _t$1("Compute the intercept of the linear regression."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const [[], [intercept]] = fullLinearRegression([flatDataX], [flatDataY]);
        return intercept;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LARGE
// -----------------------------------------------------------------------------
const LARGE = {
    description: _t$1("Nth largest element from a data set."),
    args: [
        arg("data (any, range)", _t$1("Array or range containing the dataset to consider.")),
        arg("n (number)", _t$1("The rank from largest to smallest of the element to return.")),
    ],
    compute: function (data, n) {
        const _n = Math.trunc(toNumber(n?.value, this.locale));
        const largests = [];
        let index;
        let count = 0;
        visitAny([data], (d) => {
            if (typeof d?.value === "number") {
                index = dichotomicSearch(largests, d, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                largests.splice(index + 1, 0, d);
                count++;
                if (count > _n) {
                    largests.shift();
                    count--;
                }
            }
        });
        const result = largests.shift();
        if (result === undefined) {
            return new EvaluationError(noValidInputErrorMessage);
        }
        if (count < _n) {
            return new EvaluationError(_t$1("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LINEST
// -----------------------------------------------------------------------------
const LINEST = {
    description: _t$1("Given partial data about a linear trend, calculates various parameters about the ideal linear trend using the least-squares method."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>, default={1;2;3;...})", _t$1("The range representing the array or matrix of independent data.")),
        arg("calculate_b (boolean, default=TRUE)", _t$1("A flag specifying whether to compute the slope or not"), CALCULATE_B_OPTIONS),
        arg("verbose (boolean, default=FALSE)", _t$1("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept"), RETURN_VERBOSE_OPTIONS),
    ],
    compute: function (dataY, dataX = [[]], calculateB = { value: true }, verbose = { value: false }) {
        if (dataY.length === 0 || dataY[0].length === 0) {
            return new EvaluationError(emptyDataErrorMessage("data_y"));
        }
        return fullLinearRegression(toNumberMatrix(dataX, "data_x"), toNumberMatrix(dataY, "data_y"), toBoolean(calculateB), toBoolean(verbose));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOGEST
// -----------------------------------------------------------------------------
const LOGEST = {
    description: _t$1("Given partial data about an exponential growth curve, calculates various parameters about the best fit ideal exponential growth curve."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>, optional, default={1;2;3;...})", _t$1("The range representing the array or matrix of independent data.")),
        arg("calculate_b (boolean, default=TRUE)", _t$1("A flag specifying whether to compute the slope or not"), CALCULATE_B_OPTIONS),
        arg("verbose (boolean, default=FALSE)", _t$1("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept"), RETURN_VERBOSE_OPTIONS),
    ],
    compute: function (dataY, dataX = [[]], calculateB = { value: true }, verbose = { value: false }) {
        if (dataY.length === 0 || dataY[0].length === 0) {
            return new EvaluationError(emptyDataErrorMessage("data_y"));
        }
        const coeffs = fullLinearRegression(toNumberMatrix(dataX, "data_x"), logM(toNumberMatrix(dataY, "data_y")), toBoolean(calculateB), toBoolean(verbose));
        for (let i = 0; i < coeffs.length; i++) {
            coeffs[i][0] = Math.exp(coeffs[i][0]);
        }
        return coeffs;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MATTHEWS
// -----------------------------------------------------------------------------
const MATTHEWS = {
    description: _t$1("Compute the Matthews correlation coefficient of a dataset."),
    args: [
        arg("data_x (range)", _t$1("The range representing the array or matrix of observed data.")),
        arg("data_y (range)", _t$1("The range representing the array or matrix of predicted data.")),
    ],
    compute: function (dataX, dataY) {
        const flatX = dataX.flat();
        const flatY = dataY.flat();
        assertSameNumberOfElements(flatX, flatY);
        if (flatX.length === 0 || flatY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const n = flatX.length;
        let trueN = 0, trueP = 0, falseP = 0, falseN = 0;
        for (let i = 0; i < n; ++i) {
            const isTrue1 = toBoolean(flatX[i]);
            const isTrue2 = toBoolean(flatY[i]);
            if (isTrue1 === isTrue2) {
                if (isTrue1) {
                    trueP++;
                }
                else {
                    trueN++;
                }
            }
            else {
                if (isTrue1) {
                    falseN++;
                }
                else {
                    falseP++;
                }
            }
        }
        return ((trueP * trueN - falseP * falseN) /
            Math.sqrt((trueP + falseP) * (trueP + falseN) * (trueN + falseP) * (trueN + falseN)));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// MAX
// -----------------------------------------------------------------------------
const MAX = {
    description: _t$1("Maximum value in a numeric dataset."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range to consider when calculating the maximum value.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to consider when calculating the maximum value.")),
    ],
    compute: function (...values) {
        return max(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MAXA
// -----------------------------------------------------------------------------
const MAXA = {
    description: _t$1("Maximum numeric value in a dataset."),
    args: [
        arg("value1 (any, range)", _t$1("The first value or range to consider when calculating the maximum value.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values or ranges to consider when calculating the maximum value.")),
    ],
    compute: function (...args) {
        const maxa = reduceNumbersTextAs0(args, (acc, a) => {
            return Math.max(a, acc);
        }, -Infinity, this.locale);
        return { value: maxa === -Infinity ? 0 : maxa, format: inferFormat(args[0]) };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MAXIFS
// -----------------------------------------------------------------------------
const MAXIFS = {
    description: _t$1("Returns the maximum value in a range of cells, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t$1("The range of cells from which the maximum will be determined.")),
        arg("criteria_range1 (range)", _t$1("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t$1("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        let result = -Infinity;
        visitMatchingRanges(args, (i, j) => {
            const value = range[i]?.[j]?.value;
            if (typeof value === "number") {
                result = result < value ? value : result;
            }
        }, this.locale);
        return result === -Infinity ? 0 : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MEDIAN
// -----------------------------------------------------------------------------
const MEDIAN = {
    description: _t$1("Median value in a numeric dataset."),
    args: [
        arg("value1 (any, range)", _t$1("The first value or range to consider when calculating the median value.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values or ranges to consider when calculating the median value.")),
    ],
    compute: function (...values) {
        const data = [];
        visitNumbers(values, (value) => {
            data.push(value);
        }, this.locale);
        return {
            value: centile(data, { value: 0.5 }, true, this.locale),
            format: inferFormat(data[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MIN
// -----------------------------------------------------------------------------
const MIN = {
    description: _t$1("Minimum value in a numeric dataset."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range to consider when calculating the minimum value.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to consider when calculating the minimum value.")),
    ],
    compute: function (...values) {
        return min(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINA
// -----------------------------------------------------------------------------
const MINA = {
    description: _t$1("Minimum numeric value in a dataset."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range to consider when calculating the minimum value.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to consider when calculating the minimum value.")),
    ],
    compute: function (...args) {
        const mina = reduceNumbersTextAs0(args, (acc, a) => {
            return Math.min(a, acc);
        }, Infinity, this.locale);
        return { value: mina === Infinity ? 0 : mina, format: inferFormat(args[0]) };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINIFS
// -----------------------------------------------------------------------------
const MINIFS = {
    description: _t$1("Returns the minimum value in a range of cells, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t$1("The range of cells from which the minimum will be determined.")),
        arg("criteria_range1 (range)", _t$1("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t$1("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t$1("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t$1("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        let result = Infinity;
        visitMatchingRanges(args, (i, j) => {
            const value = range[i]?.[j]?.value;
            if (typeof value === "number") {
                result = result > value ? value : result;
            }
        }, this.locale);
        return result === Infinity ? 0 : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PEARSON
// -----------------------------------------------------------------------------
function pearson(dataY, dataX) {
    const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
    if (flatDataX.length === 0 || flatDataY.length === 0) {
        return new NotAvailableError(noValidInputErrorMessage);
    }
    const n = flatDataX.length;
    let sumX = 0, sumY = 0, sumXY = 0, sumXX = 0, sumYY = 0;
    for (let i = 0; i < n; i++) {
        const xij = flatDataX[i];
        const yij = flatDataY[i];
        sumX += xij;
        sumY += yij;
        sumXY += xij * yij;
        sumXX += xij * xij;
        sumYY += yij * yij;
    }
    return ((n * sumXY - sumX * sumY) / Math.sqrt((n * sumXX - sumX * sumX) * (n * sumYY - sumY * sumY)));
}
const PEARSON = {
    description: _t$1("Compute the Pearson product-moment correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return pearson(dataY, dataX);
    },
    isExported: true,
};
// CORREL
// In GSheet, CORREL is just an alias to PEARSON
const CORREL = PEARSON;
// -----------------------------------------------------------------------------
// PERCENTILE
// -----------------------------------------------------------------------------
const PERCENTILE = {
    description: _t$1("Value at a given percentile of a dataset."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t$1("The percentile whose value within data will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return PERCENTILE_INC.compute.bind(this)(data, percentile);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PERCENTILE.EXC
// -----------------------------------------------------------------------------
const PERCENTILE_EXC = {
    description: _t$1("Value at a given percentile of a dataset exclusive of 0 and 1."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t$1("The percentile, exclusive of 0 and 1, whose value within 'data' will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return {
            value: centile([data], percentile, false, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PERCENTILE.INC
// -----------------------------------------------------------------------------
const PERCENTILE_INC = {
    description: _t$1("Value at a given percentile of a dataset."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t$1("The percentile whose value within data will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return {
            value: centile([data], percentile, true, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// POLYFIT
// -----------------------------------------------------------------------------
const POLYFIT_COEFFS = {
    description: _t$1("Compute the coefficients of polynomial regression of the dataset."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
        arg("order (number)", _t$1("The order of the polynomial to fit the data, between 1 and 6."), POLYNOMIAL_ORDER_OPTIONS),
        arg("intercept (boolean, default=TRUE)", _t$1("A flag specifying whether to compute the intercept or not."), COMPUTE_INTERCEPT_OPTIONS),
    ],
    compute: function (dataY, dataX, order, intercept = { value: true }) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        return polynomialRegression(flatDataY, flatDataX, toNumber(order, this.locale), toBoolean(intercept));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// POLYFIT.FORECAST
// -----------------------------------------------------------------------------
const POLYFIT_FORECAST = {
    description: _t$1("Predict value by computing a polynomial regression of the dataset."),
    args: [
        arg("x (number, range<number>)", _t$1("The value(s) on the x-axis to forecast.")),
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
        arg("order (number)", _t$1("The order of the polynomial to fit the data, between 1 and 6."), POLYNOMIAL_ORDER_OPTIONS),
        arg("intercept (boolean, default=TRUE)", _t$1("A flag specifying whether to compute the intercept or not."), COMPUTE_INTERCEPT_OPTIONS),
    ],
    compute: function (x, dataY, dataX, order, intercept = { value: true }) {
        const _order = toNumber(order, this.locale);
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const coeffs = polynomialRegression(flatDataY, flatDataX, _order, toBoolean(intercept)).flat();
        return matrixMap(toMatrix(x), (xij) => evaluatePolynomial(coeffs, toNumber(xij, this.locale), _order));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// QUARTILE
// -----------------------------------------------------------------------------
const QUARTILE = {
    description: _t$1("Value nearest to a specific quartile of a dataset."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t$1("Which quartile value to return."), QUARTILE_NUMBER_OPTIONS),
    ],
    compute: function (data, quartileNumber) {
        return QUARTILE_INC.compute.bind(this)(data, quartileNumber);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// QUARTILE.EXC
// -----------------------------------------------------------------------------
const QUARTILE_EXC = {
    description: _t$1("Value nearest to a specific quartile of a dataset exclusive of 0 and 4."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t$1("Which quartile value, exclusive of 0 and 4, to return."), [
            { value: 1, label: _t$1("First quartile (25th percentile)") },
            { value: 2, label: _t$1("Median value (50th percentile)") },
            { value: 3, label: _t$1("Third quartile (75th percentile)") },
        ]),
    ],
    compute: function (data, quartileNumber) {
        const _quartileNumber = Math.trunc(toNumber(quartileNumber, this.locale));
        const percent = { value: 0.25 * _quartileNumber };
        return {
            value: centile([data], percent, false, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// QUARTILE.INC
// -----------------------------------------------------------------------------
const QUARTILE_INC = {
    description: _t$1("Value nearest to a specific quartile of a dataset."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t$1("Which quartile value to return."), QUARTILE_NUMBER_OPTIONS),
    ],
    compute: function (data, quartileNumber) {
        const percent = { value: 0.25 * Math.trunc(toNumber(quartileNumber, this.locale)) };
        return {
            value: centile([data], percent, true, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// RANK
// -----------------------------------------------------------------------------
const RANK = {
    description: _t$1("Returns the rank of a specified value in a dataset."),
    args: [
        arg("value (number)", _t$1("The value whose rank will be determined.")),
        arg("data (range)", _t$1("The range containing the dataset to consider.")),
        arg("is_ascending (boolean, default=FALSE)", _t$1("Whether to consider the values in data in descending or ascending order."), [
            { value: false, label: _t$1("Descending") },
            { value: true, label: _t$1("Ascending") },
        ]),
    ],
    compute: function (value, data, isAscending = { value: false }) {
        const _isAscending = toBoolean(isAscending);
        const _value = toNumber(value, this.locale);
        let rank = 1;
        let found = false;
        for (const row of data) {
            for (const cell of row) {
                if (typeof cell.value !== "number") {
                    continue;
                }
                const _cell = toNumber(cell, this.locale);
                if (_cell === _value) {
                    found = true;
                }
                else if (_cell > _value !== _isAscending) {
                    rank++;
                }
            }
        }
        if (!found) {
            return new NotAvailableError(_t$1("Value not found in the given data."));
        }
        return rank;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RSQ
// -----------------------------------------------------------------------------
const RSQ = {
    description: _t$1("Compute the square of r, the Pearson product-moment correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const value = pearson(dataY, dataX);
        if (value instanceof Error) {
            throw value;
        }
        return Math.pow(value, 2.0);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SLOPE
// -----------------------------------------------------------------------------
const SLOPE = {
    description: _t$1("Compute the slope of the linear regression."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const [[slope]] = fullLinearRegression([flatDataX], [flatDataY]);
        return slope;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SMALL
// -----------------------------------------------------------------------------
const SMALL = {
    description: _t$1("Nth smallest element in a data set."),
    args: [
        arg("data (any, range)", _t$1("The array or range containing the dataset to consider.")),
        arg("n (number)", _t$1("The rank from smallest to largest of the element to return.")),
    ],
    compute: function (data, n) {
        const _n = Math.trunc(toNumber(n?.value, this.locale));
        const largests = [];
        let index;
        let count = 0;
        visitAny([data], (d) => {
            if (typeof d?.value === "number") {
                index = dichotomicSearch(largests, d, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                largests.splice(index + 1, 0, d);
                count++;
                if (count > _n) {
                    largests.pop();
                    count--;
                }
            }
        });
        const result = largests.pop();
        if (result === undefined) {
            return new EvaluationError(noValidInputErrorMessage);
        }
        if (count < _n) {
            return new EvaluationError(_t$1("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SPEARMAN
// -----------------------------------------------------------------------------
const SPEARMAN = {
    description: _t$1("Compute the Spearman rank correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataX, dataY) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const n = flatDataX.length;
        const order = flatDataX.map((e, i) => [e, flatDataY[i]]);
        order.sort((a, b) => a[0] - b[0]);
        for (let i = 0; i < n; ++i) {
            order[i][0] = i;
        }
        order.sort((a, b) => a[1] - b[1]);
        let sum = 0.0;
        for (let i = 0; i < n; ++i) {
            sum += (order[i][0] - i) ** 2;
        }
        return 1 - (6 * sum) / (n ** 3 - n);
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// STDEV
// -----------------------------------------------------------------------------
const STDEV = {
    description: _t$1("Standard deviation."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEV.P
// -----------------------------------------------------------------------------
const STDEV_P = {
    description: _t$1("Standard deviation of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR_P.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEV.S
// -----------------------------------------------------------------------------
const STDEV_S = {
    description: _t$1("Standard deviation."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR_S.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVA
// -----------------------------------------------------------------------------
const STDEVA = {
    description: _t$1("Standard deviation of sample (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARA.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVP
// -----------------------------------------------------------------------------
const STDEVP = {
    description: _t$1("Standard deviation of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARP.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVPA
// -----------------------------------------------------------------------------
const STDEVPA = {
    description: _t$1("Standard deviation of entire population (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARPA.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STEYX
// -----------------------------------------------------------------------------
const STEYX = {
    description: _t$1("Calculates the standard error of the predicted y-value for each x in the regression of a dataset."),
    args: [
        arg("data_y (range<number>)", _t$1("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t$1("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        if (flatDataX.length === 0 || flatDataY.length === 0) {
            return new NotAvailableError(noValidInputErrorMessage);
        }
        const data = fullLinearRegression([flatDataX], [flatDataY], true, true);
        return data[1][2];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TREND
// -----------------------------------------------------------------------------
const TREND = {
    description: _t$1("Fits points to linear trend derived via least-squares."),
    args: [
        arg("known_data_y (number, range<number>)", _t$1("The array or range containing dependent (y) values that are already known, used to curve fit an ideal linear trend.")),
        arg("known_data_x (number, range<number>, optional, default={1;2;3;...})", _t$1("The values of the independent variable(s) corresponding with known_data_y.")),
        arg("new_data_x (number, range<number>, optional, default=known_data_x)", _t$1("The data points to return the y values for on the ideal curve fit.")),
        arg("b (boolean, optional, default=TRUE)", _t$1("Given a general linear form of y = m*x+b for a curve fit, calculates b if TRUE or forces b to be 0 and only calculates the m values if FALSE, i.e. forces the curve fit to pass through the origin."), CALCULATE_B_OPTIONS),
    ],
    compute: function (knownDataY, knownDataX = [[]], newDataX = [[]], b = { value: true }) {
        if (knownDataY.length === 0 || knownDataY[0].length === 0) {
            return new EvaluationError(emptyDataErrorMessage("known_data_y"));
        }
        return predictLinearValues(toNumberMatrix(knownDataY, "known_data_y"), toNumberMatrix(knownDataX, "known_data_x"), toNumberMatrix(newDataX, "new_data_y"), toBoolean(b));
    },
};
// -----------------------------------------------------------------------------
// VAR
// -----------------------------------------------------------------------------
const VAR = {
    description: _t$1("Variance."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VAR.P
// -----------------------------------------------------------------------------
const VAR_P = {
    description: _t$1("Variance of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VAR.S
// -----------------------------------------------------------------------------
const VAR_S = {
    description: _t$1("Variance."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARA
// -----------------------------------------------------------------------------
const VARA = {
    description: _t$1("Variance of sample (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, true, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARP
// -----------------------------------------------------------------------------
const VARP = {
    description: _t$1("Variance of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARPA
// -----------------------------------------------------------------------------
const VARPA = {
    description: _t$1("Variance of entire population (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t$1("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t$1("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, true, this.locale);
    },
    isExported: true,
};

var statistical = /*#__PURE__*/Object.freeze({
    __proto__: null,
    AVEDEV: AVEDEV,
    AVERAGE: AVERAGE,
    AVERAGEA: AVERAGEA,
    AVERAGEIF: AVERAGEIF,
    AVERAGEIFS: AVERAGEIFS,
    AVERAGE_WEIGHTED: AVERAGE_WEIGHTED,
    CORREL: CORREL,
    COUNT: COUNT,
    COUNTA: COUNTA,
    COVAR: COVAR,
    COVARIANCE_P: COVARIANCE_P,
    COVARIANCE_S: COVARIANCE_S,
    FORECAST: FORECAST,
    GROWTH: GROWTH,
    INTERCEPT: INTERCEPT,
    LARGE: LARGE,
    LINEST: LINEST,
    LOGEST: LOGEST,
    MATTHEWS: MATTHEWS,
    MAX: MAX,
    MAXA: MAXA,
    MAXIFS: MAXIFS,
    MEDIAN: MEDIAN,
    MIN: MIN,
    MINA: MINA,
    MINIFS: MINIFS,
    PEARSON: PEARSON,
    PERCENTILE: PERCENTILE,
    PERCENTILE_EXC: PERCENTILE_EXC,
    PERCENTILE_INC: PERCENTILE_INC,
    POLYFIT_COEFFS: POLYFIT_COEFFS,
    POLYFIT_FORECAST: POLYFIT_FORECAST,
    QUARTILE: QUARTILE,
    QUARTILE_EXC: QUARTILE_EXC,
    QUARTILE_INC: QUARTILE_INC,
    RANK: RANK,
    RSQ: RSQ,
    SLOPE: SLOPE,
    SMALL: SMALL,
    SPEARMAN: SPEARMAN,
    STDEV: STDEV,
    STDEVA: STDEVA,
    STDEVP: STDEVP,
    STDEVPA: STDEVPA,
    STDEV_P: STDEV_P,
    STDEV_S: STDEV_S,
    STEYX: STEYX,
    TREND: TREND,
    VAR: VAR,
    VARA: VARA,
    VARP: VARP,
    VARPA: VARPA,
    VAR_P: VAR_P,
    VAR_S: VAR_S
});

function getMatchingCells(database, field, criteria, locale) {
    // Example
    // # DATABASE             # CRITERIA          # field = "C"
    //
    // | A | B | C |          | A | C |
    // |===========|          |=======|
    // | 1 | x | j |          |<2 | j |
    // | 1 | Z | k |          |   | 7 |
    // | 5 | y | 7 |
    // 1 - Select coordinates of database columns ----------------------------------------------------
    const indexColNameDB = new Map();
    const dimRowDB = database.length;
    for (let indexCol = dimRowDB - 1; indexCol >= 0; indexCol--) {
        indexColNameDB.set(toString(database[indexCol][0]).toUpperCase(), indexCol);
    }
    // Example continuation: indexColNameDB = {"A" => 0, "B" => 1, "C" => 2}
    // 2 - Check if the field parameter exists in the column names of the database -------------------
    // field may either be a text label corresponding to a column header in the
    // first row of database or a numeric index indicating which column to consider,
    // where the first column has the value 1.
    const fieldValue = field?.value;
    if (typeof fieldValue !== "number" && typeof fieldValue !== "string") {
        throw new EvaluationError(_t$1("The field must be a number or a string"));
    }
    let index;
    if (typeof fieldValue === "number") {
        index = Math.trunc(fieldValue) - 1;
        if (index < 0 || dimRowDB - 1 < index) {
            throw new EvaluationError(_t$1("The field (%(fieldValue)s) must be one of %(dimRowDB)s or must be a number between 1 and %s inclusive.", {
                fieldValue: fieldValue.toString(),
                dimRowDB: dimRowDB.toString(),
            }));
        }
    }
    else {
        const colName = toString(field).toUpperCase();
        index = indexColNameDB.get(colName) ?? -1;
        if (index === -1) {
            throw new EvaluationError(_t$1("The field (%s) must be one of %s.", toString(field), [...indexColNameDB.keys()].toString()));
        }
    }
    // Example continuation: index = 2
    // 3 - For each criteria row, find database row that correspond ----------------------------------
    const dimColCriteria = criteria[0].length;
    if (dimColCriteria < 2) {
        throw new EvaluationError(_t$1("The criteria range contains %s row, it must be at least 2 rows.", dimColCriteria.toString()));
    }
    let matchingRows = new Set();
    const dimColDB = database[0].length;
    for (let indexRow = 1; indexRow < dimColCriteria; indexRow++) {
        const args = [];
        let existColNameDB = true;
        for (let indexCol = 0; indexCol < criteria.length; indexCol++) {
            const currentName = toString(criteria[indexCol][0]).toUpperCase();
            const indexColDB = indexColNameDB.get(currentName);
            const criter = criteria[indexCol][indexRow];
            if (criter.value !== null) {
                if (indexColDB !== undefined) {
                    args.push([database[indexColDB].slice(1, dimColDB)]);
                    args.push(criter);
                }
                else {
                    existColNameDB = false;
                    break;
                }
            }
        }
        // Example continuation: args1 = [[1,1,5], "<2", ["j","k",7], "j"]
        // Example continuation: args2 = [["j","k",7], "7"]
        if (existColNameDB) {
            if (args.length > 0) {
                visitMatchingRanges(args, (i, j) => {
                    matchingRows.add(j);
                }, locale, true);
            }
            else {
                // return indices of each database row when a criteria table row is void
                matchingRows = new Set(Array(dimColDB - 1).keys());
                break;
            }
        }
    }
    // Example continuation: matchingRows = {0, 2}
    // 4 - return for each database row corresponding, the cells corresponding to the field parameter
    const fieldCol = database[index];
    // Example continuation:: fieldCol = ["C", "j", "k", 7]
    // Example continuation:: matchingCells = ["j", 7]
    return [...matchingRows].map((x) => fieldCol[x + 1]);
}
const databaseArgs = [
    arg("database (range)", _t$1("The array or range containing the data to consider, structured in such a way that the first row contains the labels for each column's values.")),
    arg("field (number, string)", _t$1("Indicates which column in database contains the values to be extracted and operated on.")),
    arg("criteria (range)", _t$1("An array or range containing zero or more criteria to filter the database values by before operating.")),
];
// -----------------------------------------------------------------------------
// DAVERAGE
// -----------------------------------------------------------------------------
const DAVERAGE = {
    description: _t$1("Average of a set of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return AVERAGE.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DCOUNT
// -----------------------------------------------------------------------------
const DCOUNT = {
    description: _t$1("Counts values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return COUNT.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DCOUNTA
// -----------------------------------------------------------------------------
const DCOUNTA = {
    description: _t$1("Counts values and text from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return COUNTA.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DGET
// -----------------------------------------------------------------------------
const DGET = {
    description: _t$1("Single value from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        if (cells.length !== 1) {
            return new EvaluationError(_t$1("More than one match found in DGET evaluation."));
        }
        return cells[0];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DMAX
// -----------------------------------------------------------------------------
const DMAX = {
    description: _t$1("Maximum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return MAX.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DMIN
// -----------------------------------------------------------------------------
const DMIN = {
    description: _t$1("Minimum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return MIN.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DPRODUCT
// -----------------------------------------------------------------------------
const DPRODUCT = {
    description: _t$1("Product of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return PRODUCT.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSTDEV
// -----------------------------------------------------------------------------
const DSTDEV = {
    description: _t$1("Standard deviation of population sample from table."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return STDEV.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSTDEVP
// -----------------------------------------------------------------------------
const DSTDEVP = {
    description: _t$1("Standard deviation of entire population from table."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return STDEVP.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSUM
// -----------------------------------------------------------------------------
const DSUM = {
    description: _t$1("Sum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return SUM.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DVAR
// -----------------------------------------------------------------------------
const DVAR = {
    description: _t$1("Variance of population sample from table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return VAR.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DVARP
// -----------------------------------------------------------------------------
const DVARP = {
    description: _t$1("Variance of a population from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return VARP.compute.bind(this)([cells]);
    },
    isExported: true,
};

var database = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DAVERAGE: DAVERAGE,
    DCOUNT: DCOUNT,
    DCOUNTA: DCOUNTA,
    DGET: DGET,
    DMAX: DMAX,
    DMIN: DMIN,
    DPRODUCT: DPRODUCT,
    DSTDEV: DSTDEV,
    DSTDEVP: DSTDEVP,
    DSUM: DSUM,
    DVAR: DVAR,
    DVARP: DVARP
});

const DEFAULT_LOCALES = [
    {
        name: "English (US)",
        code: "en_US",
        thousandsSeparator: ",",
        decimalSeparator: ".",
        weekStart: 7, // Sunday
        dateFormat: "m/d/yyyy",
        timeFormat: "hh:mm:ss a",
        formulaArgSeparator: ",",
    },
    {
        name: "French",
        code: "fr_FR",
        thousandsSeparator: " ",
        decimalSeparator: ",",
        weekStart: 1, // Monday
        dateFormat: "dd/mm/yyyy",
        timeFormat: "hh:mm:ss",
        formulaArgSeparator: ";",
    },
];
const DEFAULT_LOCALE = DEFAULT_LOCALES[0];

/**
 * Tokenizer
 *
 * A tokenizer is a piece of code whose job is to transform a string into a list
 * of "tokens". For example, "(12+" is converted into:
 *   [{type: "LEFT_PAREN", value: "("},
 *    {type: "NUMBER", value: "12"},
 *    {type: "OPERATOR", value: "+"}]
 *
 * As the example shows, a tokenizer does not care about the meaning behind those
 * tokens. It only cares about the structure.
 *
 * The tokenizer is usually the first step in a compilation pipeline.  Also, it
 * is useful for the composer, which needs to be able to work with incomplete
 * formulas.
 */
const POSTFIX_UNARY_OPERATORS = ["%"];
const OPERATORS = "+,-,*,/,:,=,<>,>=,>,<=,<,^,&".split(",").concat(POSTFIX_UNARY_OPERATORS);
function tokenize(str, locale = DEFAULT_LOCALE) {
    str = replaceNewLines(str);
    const chars = new TokenizingChars$1(str);
    const result = [];
    const tokenizeSpace = specialWhiteSpaceRegexp.test(str)
        ? tokenizeSpecialCharacterSpace
        : tokenizeSimpleSpace;
    while (!chars.isOver()) {
        let token = tokenizeNewLine(chars) ||
            tokenizeSpace(chars) ||
            tokenizeArgsSeparator(chars, locale) ||
            tokenizeParenthesis(chars) ||
            tokenizeOperator(chars) ||
            tokenizeString$1(chars) ||
            tokenizeDebugger(chars) ||
            tokenizeInvalidRange(chars) ||
            tokenizeNumber(chars, locale) ||
            tokenizeSymbol(chars);
        if (!token) {
            token = { type: "UNKNOWN", value: chars.shift() };
        }
        result.push(token);
    }
    return result;
}
function tokenizeDebugger(chars) {
    if (chars.current === "?") {
        chars.shift();
        return { type: "DEBUGGER", value: "?" };
    }
    return null;
}
const parenthesis = {
    "(": { type: "LEFT_PAREN", value: "(" },
    ")": { type: "RIGHT_PAREN", value: ")" },
};
function tokenizeParenthesis(chars) {
    if (chars.current === "(" || chars.current === ")") {
        const value = chars.shift();
        return parenthesis[value];
    }
    return null;
}
function tokenizeArgsSeparator(chars, locale) {
    if (chars.current === locale.formulaArgSeparator) {
        const value = chars.shift();
        const type = "ARG_SEPARATOR";
        return { type, value };
    }
    return null;
}
function tokenizeOperator(chars) {
    for (const op of OPERATORS) {
        if (chars.currentStartsWith(op)) {
            chars.advanceBy(op.length);
            return { type: "OPERATOR", value: op };
        }
    }
    return null;
}
const FIRST_POSSIBLE_NUMBER_CHARS = new Set("0123456789");
function tokenizeNumber(chars, locale) {
    if (!FIRST_POSSIBLE_NUMBER_CHARS.has(chars.current) &&
        chars.current !== locale.decimalSeparator) {
        return null;
    }
    const match = chars.remaining().match(getFormulaNumberRegex(locale.decimalSeparator));
    if (match) {
        chars.advanceBy(match[0].length);
        return { type: "NUMBER", value: match[0] };
    }
    return null;
}
function tokenizeString$1(chars) {
    if (chars.current === '"') {
        const startChar = chars.shift();
        let letters = startChar;
        while (chars.current && (chars.current !== startChar || letters[letters.length - 1] === "\\")) {
            letters += chars.shift();
        }
        if (chars.current === '"') {
            letters += chars.shift();
        }
        return {
            type: "STRING",
            value: letters,
        };
    }
    return null;
}
/**
  - \p{L} is for any letter (from any language)
  - \p{N} is for any number
  - the u flag at the end is for unicode, which enables the `\p{...}` syntax
 */
const unicodeSymbolCharRegexp = /\p{L}|\p{N}|_|\.|!|\$/u;
const SYMBOL_CHARS = new Set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.!$");
/**
 * A "Symbol" is just basically any word-like element that can appear in a
 * formula, which is not a string. So:
 *   A1
 *   SUM
 *   CEILING.MATH
 *   A$1
 *   Sheet2!A2
 *   'Sheet 2'!A2
 *
 * are examples of symbols
 */
function tokenizeSymbol(chars) {
    let result = "";
    // there are two main cases to manage: either something which starts with
    // a ', like 'Sheet 2'A2, or a word-like element.
    if (chars.current === "'") {
        let lastChar = chars.shift();
        result += lastChar;
        while (chars.current) {
            lastChar = chars.shift();
            result += lastChar;
            if (lastChar === "'") {
                if (chars.current && chars.current === "'") {
                    lastChar = chars.shift();
                    result += lastChar;
                }
                else {
                    break;
                }
            }
        }
        if (lastChar !== "'") {
            return {
                type: "UNKNOWN",
                value: result,
            };
        }
    }
    while (chars.current &&
        (SYMBOL_CHARS.has(chars.current) || chars.current.match(unicodeSymbolCharRegexp))) {
        result += chars.shift();
    }
    if (result.length) {
        const value = result;
        const isReference = rangeReference.test(value);
        if (isReference) {
            return { type: "REFERENCE", value };
        }
        return { type: "SYMBOL", value };
    }
    return null;
}
function tokenizeSpecialCharacterSpace(chars) {
    let spaces = "";
    while (chars.current === " " || (chars.current && chars.current.match(specialWhiteSpaceRegexp))) {
        spaces += chars.shift();
    }
    if (spaces) {
        return { type: "SPACE", value: spaces };
    }
    return null;
}
function tokenizeSimpleSpace(chars) {
    let spaces = "";
    while (chars.current === " ") {
        spaces += chars.shift();
    }
    if (spaces) {
        return { type: "SPACE", value: spaces };
    }
    return null;
}
function tokenizeNewLine(chars) {
    let length = 0;
    while (chars.current === NEWLINE) {
        length++;
        chars.shift();
    }
    if (length) {
        return { type: "SPACE", value: NEWLINE.repeat(length) };
    }
    return null;
}
function tokenizeInvalidRange(chars) {
    if (chars.currentStartsWith(CellErrorType$1.InvalidReference)) {
        chars.advanceBy(CellErrorType$1.InvalidReference.length);
        return { type: "INVALID_REFERENCE", value: CellErrorType$1.InvalidReference };
    }
    return null;
}

function isValidLocale(locale) {
    if (!locale ||
        typeof locale !== "object" ||
        !(!locale.thousandsSeparator || typeof locale.thousandsSeparator === "string")) {
        return false;
    }
    for (const property of [
        "code",
        "name",
        "decimalSeparator",
        "dateFormat",
        "timeFormat",
        "formulaArgSeparator",
    ]) {
        if (!locale[property] || typeof locale[property] !== "string") {
            return false;
        }
    }
    if (locale.formulaArgSeparator === locale.decimalSeparator) {
        return false;
    }
    if (locale.thousandsSeparator === locale.decimalSeparator) {
        return false;
    }
    try {
        formatValue$1(1, { locale, format: "#,##0.00" });
        formatValue$1(1, { locale, format: locale.dateFormat });
        formatValue$1(1, { locale, format: locale.timeFormat });
    }
    catch {
        return false;
    }
    return true;
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Don't convert date string.
 *
 * @example
 * canonicalizeNumberContent("=SUM(1,5; 02/12/2012)", FR_LOCALE) // "=SUM(1.5, 02/12/2012)"
 * canonicalizeNumberContent("125,9", FR_LOCALE) // "125.9"
 * canonicalizeNumberContent("02/12/2012", FR_LOCALE) // "02/12/2012"
 */
function canonicalizeNumberContent(content, locale) {
    return isFormula(content)
        ? canonicalizeFormula(content, locale)
        : canonicalizeNumberLiteral(content, locale);
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * canonicalizeContent("=SUM(1,5; 5)", FR_LOCALE) // "=SUM(1.5, 5)"
 * canonicalizeContent("125,9", FR_LOCALE) // "125.9"
 * canonicalizeContent("02/12/2012", FR_LOCALE) // "12/02/2012"
 * canonicalizeContent("02-12-2012", FR_LOCALE) // "12/02/2012"
 */
function canonicalizeContent(content, locale) {
    return isFormula(content)
        ? canonicalizeFormula(content, locale)
        : canonicalizeLiteral(content, locale);
}
/**
 * Change a content string from its canonical form (en_US locale) to the given locale. Also convert date string.
 *
 * @example
 * localizeContent("=SUM(1.5, 5)", FR_LOCALE) // "=SUM(1,5; 5)"
 * localizeContent("125.9", FR_LOCALE) // "125,9"
 * localizeContent("12/02/2012", FR_LOCALE) // "02/12/2012"
 */
function localizeContent(content, locale) {
    return content.startsWith("=")
        ? localizeFormula(content, locale)
        : localizeLiteral(content, locale);
}
/** Change a number string to its canonical form (en_US locale) */
function canonicalizeNumberValue(content, locale) {
    return isFormula(content)
        ? canonicalizeFormula(content, locale)
        : canonicalizeNumberLiteral(content, locale);
}
/** Change a formula to its canonical form (en_US locale) */
function canonicalizeFormula(formula, locale) {
    return _localizeFormula(formula.startsWith("+") ? "=" + formula.slice(1) : formula, locale, DEFAULT_LOCALE);
}
/** Change a formula from the canonical form to the given locale */
function localizeFormula(formula, locale) {
    return _localizeFormula(formula, DEFAULT_LOCALE, locale);
}
function _localizeFormula(formula, fromLocale, toLocale) {
    if (fromLocale.formulaArgSeparator === toLocale.formulaArgSeparator &&
        fromLocale.decimalSeparator === toLocale.decimalSeparator) {
        return formula;
    }
    const tokens = tokenize(formula, fromLocale);
    let localizedFormula = "";
    for (const token of tokens) {
        if (token.type === "NUMBER") {
            localizedFormula += token.value.replace(fromLocale.decimalSeparator, toLocale.decimalSeparator);
        }
        else if (token.type === "ARG_SEPARATOR") {
            localizedFormula += toLocale.formulaArgSeparator;
        }
        else {
            localizedFormula += token.value;
        }
    }
    return localizedFormula;
}
/**
 * Change a literal string from the given locale to its canonical form (en_US locale). Don't convert date string.
 *
 * @example
 * canonicalizeNumberLiteral("125,9", FR_LOCALE) // "125.9"
 * canonicalizeNumberLiteral("02/12/2012", FR_LOCALE) // "02/12/2012"
 */
function canonicalizeNumberLiteral(content, locale) {
    if (locale.decimalSeparator === "." || !isNumber(content, locale)) {
        return content;
    }
    if (locale.thousandsSeparator) {
        content = content.replaceAll(locale.thousandsSeparator, "");
    }
    return content.replace(locale.decimalSeparator, ".");
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * canonicalizeLiteral("125,9", FR_LOCALE) // "125.9"
 * canonicalizeLiteral("02/12/2012", FR_LOCALE) // "12/02/2012"
 * canonicalizeLiteral("02-12-2012", FR_LOCALE) // "12/02/2012"
 */
function canonicalizeLiteral(content, locale) {
    if (isDateTime(content, locale)) {
        const dateNumber = toNumber(content, locale);
        let format = DEFAULT_LOCALE.dateFormat;
        if (!Number.isInteger(dateNumber)) {
            format += " " + DEFAULT_LOCALE.timeFormat;
        }
        return formatValue$1(dateNumber, { locale: DEFAULT_LOCALE, format });
    }
    return canonicalizeNumberLiteral(content, locale);
}
/**
 * Change a literal string from its canonical form (en_US locale) to the given locale. Don't convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * localizeNumberLiteral("125.9", FR_LOCALE) // "125,9"
 * localizeNumberLiteral("12/02/2012", FR_LOCALE) // "12/02/2012"
 * localizeNumberLiteral("12-02-2012", FR_LOCALE) // "12/02/2012"
 */
function localizeNumberLiteral(literal, locale) {
    if (locale.decimalSeparator === "." || !isNumber(literal, DEFAULT_LOCALE)) {
        return literal;
    }
    const decimalNumberRegex = getDecimalNumberRegex(DEFAULT_LOCALE);
    return literal.replace(decimalNumberRegex, (match) => {
        return match.replace(".", locale.decimalSeparator);
    });
}
/**
 * Change a literal string from its canonical form (en_US locale) to the given locale. Also convert date string.
 *
 * @example
 * localizeLiteral("125.9", FR_LOCALE) // "125,9"
 * localizeLiteral("12/02/2012", FR_LOCALE) // "02/12/2012"
 */
function localizeLiteral(literal, locale) {
    if (isDateTime(literal, DEFAULT_LOCALE)) {
        const dateNumber = toNumber(literal, DEFAULT_LOCALE);
        let format = locale.dateFormat;
        if (!Number.isInteger(dateNumber)) {
            format += " " + locale.timeFormat;
        }
        return formatValue$1(dateNumber, { locale, format });
    }
    return localizeNumberLiteral(literal, locale);
}
function canonicalizeCFRule(cf, locale) {
    return changeCFRuleLocale(cf, (content) => canonicalizeContent(content, locale));
}
function localizeCFRule(cf, locale) {
    return changeCFRuleLocale(cf, (content) => localizeContent(content, locale));
}
function localizeDataValidationRule(rule, locale) {
    const localizedDVRule = deepCopy$1(rule);
    localizedDVRule.criterion.values = localizedDVRule.criterion.values.map((content) => localizeContent(content, locale));
    return localizedDVRule;
}
function changeCFRuleLocale(rule, changeContentLocale) {
    rule = deepCopy$1(rule);
    switch (rule.type) {
        case "CellIsRule":
            // Only change value for number operators
            switch (rule.operator) {
                case "isBetween":
                case "isNotBetween":
                case "isEqual":
                case "isNotEqual":
                case "isGreaterThan":
                case "isGreaterOrEqualTo":
                case "isLessThan":
                case "isLessOrEqualTo":
                case "customFormula":
                    rule.values = rule.values.map((v) => changeContentLocale(v));
                    return rule;
                case "beginsWithText":
                case "containsText":
                case "endsWithText":
                case "notContainsText":
                case "isEmpty":
                case "isNotEmpty":
                    return rule;
            }
        case "DataBarRule":
            return rule;
        case "ColorScaleRule":
            rule.minimum = changeCFRuleThresholdLocale(rule.minimum, changeContentLocale);
            rule.maximum = changeCFRuleThresholdLocale(rule.maximum, changeContentLocale);
            if (rule.midpoint) {
                rule.midpoint = changeCFRuleThresholdLocale(rule.midpoint, changeContentLocale);
            }
            return rule;
        case "IconSetRule":
            rule.lowerInflectionPoint.value = changeContentLocale(rule.lowerInflectionPoint.value);
            rule.upperInflectionPoint.value = changeContentLocale(rule.upperInflectionPoint.value);
            return rule;
    }
}
function changeCFRuleThresholdLocale(threshold, changeContentLocale) {
    if (!threshold?.value) {
        return threshold;
    }
    const value = threshold.type === "formula" ? "=" + threshold.value : threshold.value;
    const modified = changeContentLocale(value);
    const newValue = threshold.type === "formula" ? modified.slice(1) : modified;
    return { ...threshold, value: newValue };
}
function getDateTimeFormat(locale) {
    return locale.dateFormat + " " + locale.timeFormat;
}

const expectCashFlowsAndDatesHaveSameDimension = _t$1("The cashflow_amounts and cashflow_dates ranges must have the same dimensions.");
const expectCashFlowsHavePositiveAndNegativesValues = _t$1("There must be both positive and negative values in cashflow_amounts.");
const expectCostPositiveOrZero = (cost) => _t$1("The cost (%s) must be positive or null.", cost);
const expectCostStrictlyPositive = (cost) => _t$1("The cost (%s) must be strictly positive.", cost);
const expectCouponFrequencyIsValid = (frequency) => _t$1("The frequency (%s) must be one of %s", frequency, [1, 2, 4].toString());
const expectDayCountConventionIsValid = (dayCountConvention) => _t$1("The day_count_convention (%s) must be between 0 and 4 inclusive.", dayCountConvention);
const expectDeprecationFactorStrictlyPositive = (factor) => _t$1("The depreciation factor (%s) must be strictly positive.", factor);
const expectDiscountDifferentFromMinusOne = (discount) => _t$1("The discount (%s) must be different from -1.", discount);
const expectDiscountStrictlyPositive = (discount) => _t$1("The discount (%s) must be strictly positive.", discount);
const expectDiscountStrictlySmallerThanOne = (discount) => _t$1("The discount (%s) must be smaller than 1.", discount);
const expectEffectiveRateStrictlyPositive = (effectiveRate) => _t$1("The effective_rate (%s) must be strictly positive.", effectiveRate);
const expectEndPeriodPositiveOrZero = (endPeriod) => _t$1("The end_period (%s) must be positive or null.", endPeriod);
const expectEndPeriodSmallerOrEqualToLife = (end, life) => _t$1("The end_period (%(end)s) must be smaller or equal to the life (%(life)s).", { end, life });
const expectEveryDateGreaterThanFirstDateOfCashFlowDates = (firstDate) => _t$1("All the dates should be greater or equal to the first date in cashflow_dates (%s).", firstDate);
const expectFirstPeriodSmallerOrEqualLastPeriod = (first, last) => _t$1("The first_period (%(first)s) must be smaller or equal to the last_period (%(last)s).", {
    first,
    last,
});
const expectFirstPeriodStrictlyPositive = (period) => _t$1("The first_period (%s) must be strictly positive.", period);
const expectFutureValueStrictlyPositive = (pv) => _t$1("The future_value (%s) must be strictly positive.", pv);
const expectInvestmentStrictlyPositive = (investment) => _t$1("The investment (%s) must be strictly positive.", investment);
const expectIssuePositiveOrZero = (issue) => _t$1("The issue (%s) must be positive or null.", issue);
const expectLastPeriodSmallerOrEqualNumberOfPeriods = (last, nPeriods) => _t$1("The last_period (%(last)s) must be smaller or equal to the number_of_periods (%(nPeriods)s).", { last, nPeriods });
const expectLastPeriodStrictlyPositive = (period) => _t$1("The last_period (%s) must be strictly positive.", period);
const expectLifeStrictlyPositive = (life) => _t$1("The life (%s) must be strictly positive.", life);
const expectMaturityStrictlyGreaterThanSettlement = (settlement, maturity) => _t$1("The maturity (%(maturity)s) must be strictly greater than the settlement (%(settlement)s).", {
    maturity,
    settlement,
});
const expectMonthBetweenOneAndTwelve = (month) => _t$1("The month (%s) must be between 1 and 12 inclusive.", month);
const expectNominalRateStrictlyPositive = (nominalRate) => _t$1("The nominal_rate (%s) must be strictly positive.", nominalRate);
const expectNumberOfPeriodDifferentFromZero = (nPeriods) => _t$1("The number_of_periods (%s) must be different from zero.", nPeriods);
const expectNumberOfPeriodsStrictlyPositive = (nPeriods) => _t$1("The number_of_periods (%s) must be strictly positive.", nPeriods);
const expectPeriodBetweenOneAndNumberOfPeriods = (nPeriods) => _t$1("The period must be between 1 and number_of_periods (%s)", nPeriods);
const expectPeriodLessOrEqualToLifeLimit = (period, lifeLimit) => _t$1("The period (%(period)s) must be less than or equal to %(lifeLimit)s.", { period, lifeLimit });
const expectPeriodPositiveOrZero = (period) => _t$1("The period (%s) must be positive or null.", period);
const expectPeriodsByYearStrictlyPositive = (periodsByYear) => _t$1("The periods_by_year (%s) must be strictly positive.", periodsByYear);
const expectPeriodSmallerOrEqualToLife = (period, life) => _t$1("The period (%(period)s) must be less than or equal life (%(life)s).", { period, life });
const expectPeriodStrictlyPositive = (period) => _t$1("The period (%s) must be strictly positive.", period);
const expectPresentValueStrictlyPositive = (pv) => _t$1("The present_value (%s) must be strictly positive.", pv);
const expectPriceStrictlyPositive = (price) => _t$1("The price (%s) must be strictly positive.", price);
const expectPurchaseDateBeforeFirstPeriodEnd = (purchaseDate, firstPeriodEnd) => _t$1("The purchase_date (%(purchaseDate)s) must be before the first_period_end (%(firstPeriodEnd)s).", { purchaseDate, firstPeriodEnd });
const expectPurchaseDatePositiveOrZero = (purchaseDate) => _t$1("The purchase_date (%s) must be positive or null.", purchaseDate);
const expectRateGuessStrictlyGreaterThanMinusOne = (guess) => _t$1("The rate_guess (%s) must be strictly greater than -1.", guess);
const expectRatePositiveOrZero = (rate) => _t$1("The rate (%s) must be positive or null.", rate);
const expectRateStrictlyPositive = (rate) => _t$1("The rate (%s) must be strictly positive.", rate);
const expectRedemptionStrictlyPositive = (redemption) => _t$1("The redemption (%s) must be strictly positive.", redemption);
const expectSalvagePositiveOrZero = (salvage) => _t$1("The salvage (%s) must be positive or null.", salvage);
const expectSalvageSmallerOrEqualThanCost = (salvage, cost) => _t$1("The salvage (%(salvage)s) must be smaller or equal than the cost (%(cost)s).", {
    salvage,
    cost,
});
const expectSettlementGreaterOrEqualToIssue = (settlement, issue) => _t$1("The settlement date (%(settlement)s) must be greater or equal to the issue date (%(issue)s).", { settlement, issue });
const expectSettlementLessThanOneYearBeforeMaturity = (settlement, maturity) => _t$1("The settlement date (%(settlement)s) must at most one year after the maturity date (%(maturity)s).", { settlement, maturity });
const expectSettlementStrictlyGreaterThanIssue = (settlement, issue) => _t$1("The settlement date (%(settlement)s) must be strictly greater than the issue date (%(issue)s).", { settlement, issue });
const expectStartPeriodPositiveOrZero = (startPeriod) => _t$1("The start_period (%s) must be positive or null.", startPeriod);
const expectStartPeriodSmallerOrEqualEndPeriod = (start, end) => _t$1("The start_period (%(start)s) must be smaller or equal to the end_period (%(end)s).", {
    start,
    end,
});
const expectUnitStrictlyPositive = (unit) => _t$1("The unit (%s) must be strictly positive.", unit);
const expectYieldPositiveOrZero = (yeld) => _t$1("The yield (%s) must be positive or null.", yeld);
function havePositiveAndNegativeValues(arrayNumbers) {
    return arrayNumbers.some((val) => val > 0) && arrayNumbers.some((val) => val < 0);
}
function isInvalidDayCountConvention(dayCountConvention) {
    return ![0, 1, 2, 3, 4].includes(dayCountConvention);
}
function isInvalidFrequency(frequency) {
    return ![1, 2, 4].includes(frequency);
}
function isSettlementLessThanOneYearBeforeMaturity(settlement, maturity, locale) {
    const startDate = toJsDate(settlement, locale);
    const endDate = toJsDate(maturity, locale);
    const startDatePlusOneYear = toJsDate(settlement, locale);
    startDatePlusOneYear.setFullYear(startDate.getFullYear() + 1);
    return endDate.getTime() <= startDatePlusOneYear.getTime();
}
const DAY_COUNT_CONVENTION_OPTIONS = [
    { value: 0, label: _t$1("US (NASD) 30/360") },
    { value: 1, label: _t$1("Actual/Actual") },
    { value: 2, label: _t$1("Actual/360") },
    { value: 3, label: _t$1("Actual/365") },
    { value: 4, label: _t$1("European 30/360") },
];

const DEFAULT_TYPE = 1;
const DEFAULT_WEEKEND = 1;
var TIME_UNIT;
(function (TIME_UNIT) {
    TIME_UNIT["WHOLE_YEARS"] = "Y";
    TIME_UNIT["WHOLE_MONTHS"] = "M";
    TIME_UNIT["WHOLE_DAYS"] = "D";
    TIME_UNIT["DAYS_WITHOUT_WHOLE_MONTHS"] = "MD";
    TIME_UNIT["MONTH_WITHOUT_WHOLE_YEARS"] = "YM";
    TIME_UNIT["DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR"] = "YD";
})(TIME_UNIT || (TIME_UNIT = {}));
// -----------------------------------------------------------------------------
// DATE
// -----------------------------------------------------------------------------
const DATE = {
    description: _t$1("Converts year/month/day into a date."),
    args: [
        arg("year (number)", _t$1("The year component of the date.")),
        arg("month (number)", _t$1("The month component of the date.")),
        arg("day (number)", _t$1("The day component of the date.")),
    ],
    compute: function (year, month, day) {
        let _year = Math.trunc(toNumber(year, this.locale));
        const _month = Math.trunc(toNumber(month, this.locale));
        const _day = Math.trunc(toNumber(day, this.locale));
        // For years less than 0 or greater than 10000, return #ERROR.
        if (_year < 0 || _year > 9999) {
            return new EvaluationError(_t$1("The year (%s) must be between 0 and 9999 inclusive.", _year.toString()));
        }
        // Between 0 and 1899, we add that value to 1900 to calculate the year
        if (_year < 1900) {
            _year += 1900;
        }
        const jsDate = new DateTime$1(_year, _month - 1, _day);
        const result = jsDateToRoundNumber(jsDate);
        if (result < 0) {
            return new EvaluationError(_t$1("The function [[FUNCTION_NAME]] result must be greater than or equal 01/01/1900."));
        }
        return {
            value: result,
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DATEDIF
// -----------------------------------------------------------------------------
const DATEDIF = {
    description: _t$1("Calculates the number of days, months, or years between two dates."),
    args: [
        arg("start_date (date)", _t$1("The start date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
        arg("end_date (date)", _t$1("The end date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
        arg("unit (string)", _t$1("A text abbreviation for unit of time."), [
            { value: "Y", label: _t$1("The number of whole years between start_date and end_date") },
            { value: "M", label: _t$1("The number of whole months between start_date and end_date") },
            { value: "D", label: _t$1("The number of days between start_date and end_date") },
            {
                value: "MD",
                label: _t$1("The number of days between start_date and end_date after subtracting whole months"),
            },
            {
                value: "YM",
                label: _t$1("The number of whole months between start_date and end_date after subtracting whole years"),
            },
            {
                value: "YD",
                label: _t$1("The number of days between start_date and end_date, assuming start_date and end_date were no more than one year apart"),
            },
        ]),
    ],
    compute: function (startDate, endDate, unit) {
        const _unit = toString(unit).toUpperCase();
        if (!Object.values(TIME_UNIT).includes(_unit)) {
            return new EvaluationError(expectStringSetError(Object.values(TIME_UNIT), toString(unit)));
        }
        const _startDate = Math.trunc(toNumber(startDate, this.locale));
        const _endDate = Math.trunc(toNumber(endDate, this.locale));
        const jsStartDate = numberToJsDate$1(_startDate);
        const jsEndDate = numberToJsDate$1(_endDate);
        if (_endDate < _startDate) {
            return new EvaluationError(_t$1("start_date (%s) should be on or before end_date (%s).", jsStartDate.toLocaleDateString(), jsEndDate.toLocaleDateString()));
        }
        switch (_unit) {
            case TIME_UNIT.WHOLE_YEARS:
                return getTimeDifferenceInWholeYears(jsStartDate, jsEndDate);
            case TIME_UNIT.WHOLE_MONTHS:
                return getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate);
            case TIME_UNIT.WHOLE_DAYS: {
                return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
            }
            case TIME_UNIT.MONTH_WITHOUT_WHOLE_YEARS: {
                return (getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate) -
                    getTimeDifferenceInWholeYears(jsStartDate, jsEndDate) * 12);
            }
            case TIME_UNIT.DAYS_WITHOUT_WHOLE_MONTHS:
                // Using "MD" may get incorrect result in Excel
                // See: https://support.microsoft.com/en-us/office/datedif-function-25dba1a4-2812-480b-84dd-8b32a451b35c
                let days = jsEndDate.getDate() - jsStartDate.getDate();
                if (days < 0) {
                    const monthBeforeEndMonth = new DateTime$1(jsEndDate.getFullYear(), jsEndDate.getMonth() - 1, 1);
                    const daysInMonthBeforeEndMonth = getDaysInMonth(monthBeforeEndMonth);
                    days = daysInMonthBeforeEndMonth - Math.abs(days);
                }
                return days;
            case TIME_UNIT.DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR: {
                if (areTwoDatesWithinOneYear(_startDate, _endDate)) {
                    return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
                }
                const endDateWithinOneYear = new DateTime$1(jsStartDate.getFullYear(), jsEndDate.getMonth(), jsEndDate.getDate());
                let days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                if (days < 0) {
                    endDateWithinOneYear.setFullYear(jsStartDate.getFullYear() + 1);
                    days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                }
                return days;
            }
        }
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DATEVALUE
// -----------------------------------------------------------------------------
const DATEVALUE = {
    description: _t$1("Converts a date string to a date value."),
    args: [arg("date_string (string)", _t$1("The string representing the date."))],
    compute: function (dateString) {
        const _dateString = toString(dateString);
        const internalDate = parseDateTime(_dateString, this.locale);
        if (internalDate === null) {
            return new EvaluationError(_t$1("The date_string (%s) cannot be parsed to date/time.", _dateString.toString()));
        }
        return Math.trunc(internalDate.value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAY
// -----------------------------------------------------------------------------
const DAY = {
    description: _t$1("Day of the month that a specific date falls on."),
    args: [arg("date (string)", _t$1("The date from which to extract the day."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getDate();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAYS
// -----------------------------------------------------------------------------
const DAYS$1 = {
    description: _t$1("Number of days between two dates."),
    args: [
        arg("end_date (date)", _t$1("The end of the date range.")),
        arg("start_date (date)", _t$1("The start of the date range.")),
    ],
    compute: function (endDate, startDate) {
        const _endDate = toJsDate(endDate, this.locale);
        const _startDate = toJsDate(startDate, this.locale);
        const dateDif = _endDate.getTime() - _startDate.getTime();
        return Math.round(dateDif / MS_PER_DAY$1);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAYS360
// -----------------------------------------------------------------------------
const DEFAULT_DAY_COUNT_METHOD = false;
const DAYS360 = {
    description: _t$1("Number of days between two dates on a 360-day year (months of 30 days)."),
    args: [
        arg("start_date (date)", _t$1("The start date to consider in the calculation.")),
        arg("end_date (date)", _t$1("The end date to consider in the calculation.")),
        arg(`method (boolean, default=${DEFAULT_DAY_COUNT_METHOD})`, _t$1("An indicator of what day count method to use."), [
            { value: false, label: _t$1("U.S. NASD method (default)") },
            { value: true, label: _t$1("European method") },
        ]),
    ],
    compute: function (startDate, endDate, method = { value: DEFAULT_DAY_COUNT_METHOD }) {
        const _startDate = Math.trunc(toNumber(startDate, this.locale));
        const _endDate = Math.trunc(toNumber(endDate, this.locale));
        const dayCountConvention = toBoolean(method) ? 4 : 0;
        const yearFrac = getYearFrac(_startDate, _endDate, dayCountConvention);
        return Math.sign(_endDate - _startDate) * Math.round(yearFrac * 360);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EDATE
// -----------------------------------------------------------------------------
const EDATE = {
    description: _t$1("Date a number of months before/after another date."),
    args: [
        arg("start_date (date)", _t$1("The date from which to calculate the result.")),
        arg("months (number)", _t$1("The number of months before (negative) or after (positive) 'start_date' to calculate.")),
    ],
    compute: function (startDate, months) {
        const _startDate = toJsDate(startDate, this.locale);
        const _months = Math.trunc(toNumber(months, this.locale));
        const jsDate = addMonthsToDate(_startDate, _months, false);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EOMONTH
// -----------------------------------------------------------------------------
const EOMONTH = {
    description: _t$1("Last day of a month before or after a date."),
    args: [
        arg("start_date (date)", _t$1("The date from which to calculate the result.")),
        arg("months (number)", _t$1("The number of months before (negative) or after (positive) 'start_date' to consider.")),
    ],
    compute: function (startDate, months) {
        const _startDate = toJsDate(startDate, this.locale);
        const _months = Math.trunc(toNumber(months, this.locale));
        const yStart = _startDate.getFullYear();
        const mStart = _startDate.getMonth();
        const jsDate = new DateTime$1(yStart, mStart + _months + 1, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HOUR
// -----------------------------------------------------------------------------
const HOUR = {
    description: _t$1("Hour component of a specific time."),
    args: [arg("time (date)", _t$1("The time from which to calculate the hour component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getHours();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISOWEEKNUM
// -----------------------------------------------------------------------------
const ISOWEEKNUM = {
    description: _t$1("ISO week number of the year."),
    args: [
        arg("date (date)", _t$1("The date for which to determine the ISO week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
    ],
    compute: function (date) {
        const _date = toJsDate(date, this.locale);
        const y = _date.getFullYear();
        // 1 - As the 1st week of a year can start the previous year or after the 1st
        // january we first look if the date is in the weeks of the current year, previous
        // year or year after.
        // A - We look for the current year, the first days of the first week
        // and the last days of the last week
        // The first week of the year is the week that contains the first
        // Thursday of the year.
        let firstThursday = 1;
        while (new DateTime$1(y, 0, firstThursday).getDay() !== 4) {
            firstThursday += 1;
        }
        const firstDayOfFirstWeek = new DateTime$1(y, 0, firstThursday - 3);
        // The last week of the year is the week that contains the last Thursday of
        // the year.
        let lastThursday = 31;
        while (new DateTime$1(y, 11, lastThursday).getDay() !== 4) {
            lastThursday -= 1;
        }
        const lastDayOfLastWeek = new DateTime$1(y, 11, lastThursday + 3);
        // B - If our date > lastDayOfLastWeek then it's in the weeks of the year after
        // If our date < firstDayOfFirstWeek then it's in the weeks of the year before
        let offsetYear;
        if (firstDayOfFirstWeek.getTime() <= _date.getTime()) {
            if (_date.getTime() <= lastDayOfLastWeek.getTime()) {
                offsetYear = 0;
            }
            else {
                offsetYear = 1;
            }
        }
        else {
            offsetYear = -1;
        }
        // 2 - now that the year is known, we are looking at the difference between
        // the first day of this year and the date. The difference in days divided by
        // 7 gives us the week number
        let firstDay;
        switch (offsetYear) {
            case 0:
                firstDay = firstDayOfFirstWeek;
                break;
            case 1:
                // firstDay is the 1st day of the 1st week of the year after
                // firstDay = lastDayOfLastWeek + 1 Day
                firstDay = new DateTime$1(y, 11, lastThursday + 3 + 1);
                break;
            case -1:
                // firstDay is the 1st day of the 1st week of the previous year.
                // The first week of the previous year is the week that contains the
                // first Thursday of the previous year.
                let firstThursdayPreviousYear = 1;
                while (new DateTime$1(y - 1, 0, firstThursdayPreviousYear).getDay() !== 4) {
                    firstThursdayPreviousYear += 1;
                }
                firstDay = new DateTime$1(y - 1, 0, firstThursdayPreviousYear - 3);
                break;
        }
        const diff = (_date.getTime() - firstDay.getTime()) / MS_PER_DAY$1;
        return Math.floor(diff / 7) + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINUTE
// -----------------------------------------------------------------------------
const MINUTE = {
    description: _t$1("Minute component of a specific time."),
    args: [arg("time (date)", _t$1("The time from which to calculate the minute component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getMinutes();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MONTH
// -----------------------------------------------------------------------------
const MONTH = {
    description: _t$1("Month of the year a specific date falls in"),
    args: [arg("date (date)", _t$1("The date from which to extract the month."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getMonth() + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NETWORKDAYS
// -----------------------------------------------------------------------------
const NETWORKDAYS = {
    description: _t$1("Net working days between two provided days."),
    args: [
        arg("start_date (date)", _t$1("The start date of the period from which to calculate the number of net working days.")),
        arg("end_date (date)", _t$1("The end date of the period from which to calculate the number of net working days.")),
        arg("holidays (date, range<date>, optional)", _t$1("A range or array constant containing the date serial numbers to consider holidays.")),
    ],
    compute: function (startDate, endDate, holidays) {
        return NETWORKDAYS_INTL.compute.bind(this)(startDate, endDate, { value: 1 }, holidays);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NETWORKDAYS.INTL
// -----------------------------------------------------------------------------
/**
 * Transform weekend Spreadsheet information into Date Day JavaScript information.
 * Take string (String method) or number (Number method), return array of numbers.
 *
 * String method: weekends can be specified using seven 0’s and 1’s, where the
 * first number in the set represents Monday and the last number is for Sunday.
 * A zero means that the day is a work day, a 1 means that the day is a weekend.
 * For example, “0000011” would mean Saturday and Sunday are weekends.
 *
 * Number method: instead of using the string method above, a single number can
 * be used. 1 = Saturday/Sunday are weekends, 2 = Sunday/Monday, and this pattern
 * repeats until 7 = Friday/Saturday. 11 = Sunday is the only weekend, 12 = Monday
 * is the only weekend, and this pattern repeats until 17 = Saturday is the only
 * weekend.
 *
 * Example:
 * - 11 return [0] (correspond to Sunday)
 * - 12 return [1] (correspond to Monday)
 * - 3 return [1,2] (correspond to Monday and Tuesday)
 * - "0101010" return [2,4,6] (correspond to Tuesday, Thursday and Saturday)
 */
function weekendToDayNumber(data) {
    const weekend = data?.value;
    // case "string"
    if (typeof weekend === "string") {
        assert(weekend.length === 7 && [...weekend].every((c) => c === "0" || c === "1"), _t$1('When weekend is a string (%s) it must be composed of "0" or "1".', weekend));
        const result = [];
        for (let i = 0; i < 7; i++) {
            if (weekend[i] === "1") {
                result.push((i + 1) % 7);
            }
        }
        return result;
    }
    //case "number"
    if (typeof weekend === "number") {
        assert((1 <= weekend && weekend <= 7) || (11 <= weekend && weekend <= 17), _t$1("The weekend (%s) must be a string or a number in the range 1-7 or 11-17.", weekend.toString()));
        // case 1 <= weekend <= 7
        if (weekend <= 7) {
            // 1 = Saturday/Sunday are weekends
            // 2 = Sunday/Monday
            // ...
            // 7 = Friday/Saturday.
            return [weekend - 2 === -1 ? 6 : weekend - 2, weekend - 1];
        }
        // case 11 <= weekend <= 17
        // 11 = Sunday is the only weekend
        // 12 = Monday is the only weekend
        // ...
        // 17 = Saturday is the only weekend.
        return [weekend - 11];
    }
    throw new EvaluationError(_t$1("The weekend must be a number or a string."));
}
const WEEKEND_OPTIONS = [
    { value: 1, label: _t$1("Saturday/Sunday are weekends") },
    { value: 2, label: _t$1("Sunday/Monday are weekends") },
    { value: 3, label: _t$1("Monday/Tuesday are weekends") },
    { value: 4, label: _t$1("Tuesday/Wednesday are weekends") },
    { value: 5, label: _t$1("Wednesday/Thursday are weekends") },
    { value: 6, label: _t$1("Thursday/Friday are weekends") },
    { value: 7, label: _t$1("Friday/Saturday are weekends") },
    { value: 11, label: _t$1("Sunday is the only weekend") },
    { value: 12, label: _t$1("Monday is the only weekend") },
    { value: 13, label: _t$1("Tuesday is the only weekend") },
    { value: 14, label: _t$1("Wednesday is the only weekend") },
    { value: 15, label: _t$1("Thursday is the only weekend") },
    { value: 16, label: _t$1("Friday is the only weekend") },
    { value: 17, label: _t$1("Saturday is the only weekend") },
];
const NETWORKDAYS_INTL = {
    description: _t$1("Net working days between two dates (specifying weekends)."),
    args: [
        arg("start_date (date)", _t$1("The start date of the period from which to calculate the number of net working days.")),
        arg("end_date (date)", _t$1("The end date of the period from which to calculate the number of net working days.")),
        arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t$1("A number or string representing which days of the week are considered weekends."), WEEKEND_OPTIONS),
        arg("holidays (date, range<date>, optional)", _t$1("A range or array constant containing the dates to consider as holidays.")),
    ],
    compute: function (startDate, endDate, weekend = { value: DEFAULT_WEEKEND }, holidays) {
        const _startDate = toJsDate(startDate, this.locale);
        const _endDate = toJsDate(endDate, this.locale);
        const daysWeekend = weekendToDayNumber(weekend);
        const timesHoliday = new Set();
        if (holidays !== undefined) {
            visitAny([holidays], (h) => {
                const holiday = toJsDate(h, this.locale);
                timesHoliday.add(holiday.getTime());
            });
        }
        const invertDate = _startDate.getTime() > _endDate.getTime();
        const stopDate = DateTime$1.fromTimestamp((invertDate ? _startDate : _endDate).getTime());
        const stepDate = DateTime$1.fromTimestamp((invertDate ? _endDate : _startDate).getTime());
        const timeStopDate = stopDate.getTime();
        let timeStepDate = stepDate.getTime();
        let netWorkingDay = 0;
        while (timeStepDate <= timeStopDate) {
            if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                netWorkingDay += 1;
            }
            stepDate.setDate(stepDate.getDate() + 1);
            timeStepDate = stepDate.getTime();
        }
        return invertDate ? -netWorkingDay : netWorkingDay;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOW
// -----------------------------------------------------------------------------
const NOW = {
    description: _t$1("Current date and time as a date value."),
    args: [],
    compute: function () {
        const today = DateTime$1.now();
        const delta = today.getTime() - INITIAL_1900_DAY$1.getTime();
        const time = today.getHours() / 24 + today.getMinutes() / 1440 + today.getSeconds() / 86400;
        return {
            value: Math.floor(delta / MS_PER_DAY$1) + time,
            format: getDateTimeFormat(this.locale),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SECOND
// -----------------------------------------------------------------------------
const SECOND = {
    description: _t$1("Minute component of a specific time."),
    args: [arg("time (date)", _t$1("The time from which to calculate the second component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getSeconds();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TIME
// -----------------------------------------------------------------------------
const TIME = {
    description: _t$1("Converts hour/minute/second into a time."),
    args: [
        arg("hour (number)", _t$1("The hour component of the time.")),
        arg("minute (number)", _t$1("The minute component of the time.")),
        arg("second (number)", _t$1("The second component of the time.")),
    ],
    compute: function (hour, minute, second) {
        let _hour = Math.trunc(toNumber(hour, this.locale));
        let _minute = Math.trunc(toNumber(minute, this.locale));
        let _second = Math.trunc(toNumber(second, this.locale));
        _minute += Math.floor(_second / 60);
        _second = (_second % 60) + (_second < 0 ? 60 : 0);
        _hour += Math.floor(_minute / 60);
        _minute = (_minute % 60) + (_minute < 0 ? 60 : 0);
        _hour %= 24;
        if (_hour < 0) {
            return new EvaluationError(_t$1("The function [[FUNCTION_NAME]] result cannot be negative"));
        }
        return {
            value: _hour / 24 + _minute / (24 * 60) + _second / (24 * 60 * 60),
            format: this.locale.timeFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TIMEVALUE
// -----------------------------------------------------------------------------
const TIMEVALUE = {
    description: _t$1("Converts a time string into its serial number representation."),
    args: [arg("time_string (string)", _t$1("The string that holds the time representation."))],
    compute: function (timeString) {
        const _timeString = toString(timeString);
        const internalDate = parseDateTime(_timeString, this.locale);
        if (internalDate === null) {
            return new EvaluationError(_t$1("The time_string (%s) cannot be parsed to date/time.", _timeString));
        }
        const result = internalDate.value - Math.trunc(internalDate.value);
        return result < 0 ? 1 + result : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TODAY
// -----------------------------------------------------------------------------
const TODAY = {
    description: _t$1("Current date as a date value."),
    args: [],
    compute: function () {
        const today = DateTime$1.now();
        const jsDate = new DateTime$1(today.getFullYear(), today.getMonth(), today.getDate());
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WEEKDAY
// -----------------------------------------------------------------------------
const WEEKDAY = {
    description: _t$1("Day of the week of the date provided (as number)."),
    args: [
        arg("date (date)", _t$1("The date for which to determine the day of the week. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`type (number, default=${DEFAULT_TYPE})`, _t$1("A number indicating which numbering system to use to represent weekdays. By default, counts starting with Sunday = 1."), [
            { value: 1, label: _t$1("Numbers 1 (Sunday) trough 7 (Saturday)") },
            { value: 2, label: _t$1("Numbers 1 (Monday) trough 7 (Sunday)") },
            { value: 3, label: _t$1("Numbers 0 (Monday) trough 6 (Sunday)") },
            { value: 11, label: _t$1("Numbers 1 (Monday) trough 7 (Sunday)") },
            { value: 12, label: _t$1("Numbers 1 (Tuesday) trough 7 (Monday)") },
            { value: 13, label: _t$1("Numbers 1 (Wednesday) trough 7 (Tuesday)") },
            { value: 14, label: _t$1("Numbers 1 (Thursday) trough 7 (Wednesday)") },
            { value: 15, label: _t$1("Numbers 1 (Friday) trough 7 (Thursday)") },
            { value: 16, label: _t$1("Numbers 1 (Saturday) trough 7 (Friday)") },
            { value: 17, label: _t$1("Numbers 1 (Sunday) trough 7 (Saturday)") },
        ]),
    ],
    compute: function (date, type = { value: DEFAULT_TYPE }) {
        const _date = toJsDate(date, this.locale);
        const _type = Math.round(toNumber(type, this.locale));
        const m = _date.getDay(); // "getDay()+1" return 1 for Sunday, 2 for Monday, ..., 7 for Saturday
        if (!(1 <= _type && _type <= 3) && !(11 <= _type && _type <= 17)) {
            return new EvaluationError(_t$1("The type (%s) must be between 1 and 3 or between 11 and 17.", _type));
        }
        switch (_type) {
            case 1:
                return m + 1;
            case 2:
                return m === 0 ? 7 : m;
            case 3:
                return m === 0 ? 6 : m - 1;
        }
        const delta = _type - 10;
        const result = (m + 1 - delta + 7) % 7; // +7 to avoid applying modulo on negative numbers
        return result === 0 ? 7 : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WEEKNUM
// -----------------------------------------------------------------------------
const WEEKNUM = {
    description: _t$1("Week number of the year."),
    args: [
        arg("date (date)", _t$1("The date for which to determine the week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`type (number, default=${DEFAULT_TYPE})`, _t$1("A number representing the day that a week starts on. Sunday = 1."), [
            { value: 1, label: _t$1("Sunday") },
            { value: 2, label: _t$1("Monday") },
            { value: 11, label: _t$1("Monday") },
            { value: 12, label: _t$1("Tuesday") },
            { value: 13, label: _t$1("Wednesday") },
            { value: 14, label: _t$1("Thursday") },
            { value: 15, label: _t$1("Friday") },
            { value: 16, label: _t$1("Saturday") },
            { value: 17, label: _t$1("Sunday") },
            { value: 21, label: _t$1("ISO week number (Monday as first day of the week)") },
        ]),
    ],
    compute: function (date, type = { value: DEFAULT_TYPE }) {
        const _date = toJsDate(date, this.locale);
        const _type = Math.round(toNumber(type, this.locale));
        if (![1, 2, 11, 12, 13, 14, 15, 16, 17, 21].includes(_type)) {
            return new EvaluationError(_t$1("The type (%s) is out of range.", _type.toString()));
        }
        if (_type === 21) {
            return ISOWEEKNUM.compute.bind(this)(date);
        }
        let startDayOfWeek;
        if (_type === 1 || _type === 2) {
            startDayOfWeek = _type - 1;
        }
        else {
            // case 11 <= _type <= 17
            startDayOfWeek = _type - 10 === 7 ? 0 : _type - 10;
        }
        const y = _date.getFullYear();
        let dayStart = 1;
        let startDayOfFirstWeek = new DateTime$1(y, 0, dayStart);
        while (startDayOfFirstWeek.getDay() !== startDayOfWeek) {
            dayStart += 1;
            startDayOfFirstWeek = new DateTime$1(y, 0, dayStart);
        }
        const dif = (_date.getTime() - startDayOfFirstWeek.getTime()) / MS_PER_DAY$1;
        if (dif < 0) {
            return 1;
        }
        return Math.floor(dif / 7) + (dayStart === 1 ? 1 : 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WORKDAY
// -----------------------------------------------------------------------------
const WORKDAY = {
    description: _t$1("Date after a number of workdays."),
    args: [
        arg("start_date (date)", _t$1("The date from which to begin counting.")),
        arg("num_days (number)", _t$1("The number of working days to advance from start_date. If negative, counts backwards.")),
        arg("holidays (date, range<date>, optional)", _t$1("A range or array constant containing the dates to consider holidays.")),
    ],
    compute: function (startDate, numDays, holidays = { value: null }) {
        return WORKDAY_INTL.compute.bind(this)(startDate, numDays, { value: 1 }, holidays);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WORKDAY.INTL
// -----------------------------------------------------------------------------
const WORKDAY_INTL = {
    description: _t$1("Date after a number of workdays (specifying weekends)."),
    args: [
        arg("start_date (date)", _t$1("The date from which to begin counting.")),
        arg("num_days (number)", _t$1("The number of working days to advance from start_date. If negative, counts backwards.")),
        arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t$1("A number or string representing which days of the week are considered weekends."), WEEKEND_OPTIONS),
        arg("holidays (date, range<date>, optional)", _t$1("A range or array constant containing the dates to consider holidays.")),
    ],
    compute: function (startDate, numDays, weekend = { value: DEFAULT_WEEKEND }, holidays) {
        const _startDate = toJsDate(startDate, this.locale);
        const _numDays = Math.trunc(toNumber(numDays, this.locale));
        if (weekend.value === "1111111") {
            return new EvaluationError(_t$1("The weekend must be different from '1111111'."));
        }
        const daysWeekend = weekendToDayNumber(weekend);
        const timesHoliday = new Set();
        if (holidays !== undefined) {
            visitAny([holidays], (h) => {
                const holiday = toJsDate(h, this.locale);
                timesHoliday.add(holiday.getTime());
            });
        }
        const stepDate = DateTime$1.fromTimestamp(_startDate.getTime());
        let timeStepDate = stepDate.getTime();
        const unitDay = Math.sign(_numDays);
        let stepDay = Math.abs(_numDays);
        while (stepDay > 0) {
            stepDate.setDate(stepDate.getDate() + unitDay);
            timeStepDate = stepDate.getTime();
            if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                stepDay -= 1;
            }
        }
        const delta = timeStepDate - INITIAL_1900_DAY$1.getTime();
        return {
            value: Math.round(delta / MS_PER_DAY$1),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YEAR
// -----------------------------------------------------------------------------
const YEAR = {
    description: _t$1("Year specified by a given date."),
    args: [arg("date (date)", _t$1("The date from which to extract the year."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getFullYear();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YEARFRAC
// -----------------------------------------------------------------------------
const DEFAULT_DAY_COUNT_CONVENTION$1 = 0;
const YEARFRAC = {
    description: _t$1("Exact number of years between two dates."),
    args: [
        arg("start_date (date)", _t$1("The start date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg("end_date (date)", _t$1("The end date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION$1})`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (startDate, endDate, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION$1 }) {
        const _startDate = Math.trunc(toNumber(startDate, this.locale));
        const _endDate = Math.trunc(toNumber(endDate, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_startDate < 0) {
            return new EvaluationError(_t$1("The start_date (%s) must be positive or null.", _startDate));
        }
        if (_endDate < 0) {
            return new EvaluationError(_t$1("The end_date (%s) must be positive or null.", _endDate));
        }
        if (0 > _dayCountConvention || _dayCountConvention > 4) {
            return new EvaluationError(_t$1("The day_count_convention (%s) must be between 0 and 4 inclusive.", _dayCountConvention));
        }
        return getYearFrac(_startDate, _endDate, _dayCountConvention);
    },
};
// -----------------------------------------------------------------------------
// MONTH.START
// -----------------------------------------------------------------------------
const MONTH_START = {
    description: _t$1("First day of the month preceding a date."),
    args: [arg("date (date)", _t$1("The date from which to calculate the result."))],
    compute: function (date) {
        const _startDate = toJsDate(date, this.locale);
        const yStart = _startDate.getFullYear();
        const mStart = _startDate.getMonth();
        const jsDate = new DateTime$1(yStart, mStart, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// MONTH.END
// -----------------------------------------------------------------------------
const MONTH_END = {
    description: _t$1("Last day of the month following a date."),
    args: [arg("date (date)", _t$1("The date from which to calculate the result."))],
    compute: function (date) {
        return EOMONTH.compute.bind(this)(date, { value: 0 });
    },
};
// -----------------------------------------------------------------------------
// QUARTER
// -----------------------------------------------------------------------------
const QUARTER = {
    description: _t$1("Quarter of the year a specific date falls in"),
    args: [arg("date (date)", _t$1("The date from which to extract the quarter."))],
    compute: function (date) {
        return Math.ceil((toJsDate(date, this.locale).getMonth() + 1) / 3);
    },
};
// -----------------------------------------------------------------------------
// QUARTER.START
// -----------------------------------------------------------------------------
const QUARTER_START = {
    description: _t$1("First day of the quarter of the year a specific date falls in."),
    args: [arg("date (date)", _t$1("The date from which to calculate the start of quarter."))],
    compute: function (date) {
        const quarter = QUARTER.compute.bind(this)(date);
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime$1(year, (quarter - 1) * 3, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// QUARTER.END
// -----------------------------------------------------------------------------
const QUARTER_END = {
    description: _t$1("Last day of the quarter of the year a specific date falls in."),
    args: [arg("date (date)", _t$1("The date from which to calculate the end of quarter."))],
    compute: function (date) {
        const quarter = QUARTER.compute.bind(this)(date);
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime$1(year, quarter * 3, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// YEAR.START
// -----------------------------------------------------------------------------
const YEAR_START = {
    description: _t$1("First day of the year a specific date falls in."),
    args: [arg("date (date)", _t$1("The date from which to calculate the start of the year."))],
    compute: function (date) {
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime$1(year, 0, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// YEAR.END
// -----------------------------------------------------------------------------
const YEAR_END = {
    description: _t$1("Last day of the year a specific date falls in."),
    args: [arg("date (date)", _t$1("The date from which to calculate the end of the year."))],
    compute: function (date) {
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime$1(year + 1, 0, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};

var date = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DATE: DATE,
    DATEDIF: DATEDIF,
    DATEVALUE: DATEVALUE,
    DAY: DAY,
    DAYS: DAYS$1,
    DAYS360: DAYS360,
    EDATE: EDATE,
    EOMONTH: EOMONTH,
    HOUR: HOUR,
    ISOWEEKNUM: ISOWEEKNUM,
    MINUTE: MINUTE,
    MONTH: MONTH,
    MONTH_END: MONTH_END,
    MONTH_START: MONTH_START,
    NETWORKDAYS: NETWORKDAYS,
    NETWORKDAYS_INTL: NETWORKDAYS_INTL,
    NOW: NOW,
    QUARTER: QUARTER,
    QUARTER_END: QUARTER_END,
    QUARTER_START: QUARTER_START,
    SECOND: SECOND,
    TIME: TIME,
    TIMEVALUE: TIMEVALUE,
    TODAY: TODAY,
    WEEKDAY: WEEKDAY,
    WEEKNUM: WEEKNUM,
    WORKDAY: WORKDAY,
    WORKDAY_INTL: WORKDAY_INTL,
    YEAR: YEAR,
    YEARFRAC: YEARFRAC,
    YEAR_END: YEAR_END,
    YEAR_START: YEAR_START
});

const DEFAULT_DELTA_ARG = 0;
// -----------------------------------------------------------------------------
// DELTA
// -----------------------------------------------------------------------------
const DELTA = {
    description: _t$1("Compare two numeric values, returning 1 if they're equal."),
    args: [
        arg("number1 (number)", _t$1("The first number to compare.")),
        arg(`number2 (number, default=${DEFAULT_DELTA_ARG})`, _t$1("The second number to compare.")),
    ],
    compute: function (number1, number2 = { value: DEFAULT_DELTA_ARG }) {
        const _number1 = toNumber(number1, this.locale);
        const _number2 = toNumber(number2, this.locale);
        return _number1 === _number2 ? 1 : 0;
    },
    isExported: true,
};

var engineering = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DELTA: DELTA
});

var CellValueType;
(function (CellValueType) {
    CellValueType["boolean"] = "boolean";
    CellValueType["number"] = "number";
    CellValueType["text"] = "text";
    CellValueType["empty"] = "empty";
    CellValueType["error"] = "error";
})(CellValueType || (CellValueType = {}));

const SORT_TYPES = [
    CellValueType.number,
    CellValueType.error,
    CellValueType.text,
    CellValueType.boolean,
];
function cellsSortingCriterion(sortingOrder) {
    const inverse = sortingOrder === "asc" ? 1 : -1;
    return (left, right) => {
        if (left.type === CellValueType.empty) {
            return right.type === CellValueType.empty ? 0 : 1;
        }
        else if (right.type === CellValueType.empty) {
            return -1;
        }
        let typeOrder = SORT_TYPES.indexOf(left.type) - SORT_TYPES.indexOf(right.type);
        if (typeOrder === 0) {
            if (left.type === CellValueType.text || left.type === CellValueType.error) {
                typeOrder = left.value.localeCompare(right.value);
            }
            else {
                typeOrder = left.value - right.value;
            }
        }
        return inverse * typeOrder;
    };
}
function sortCells(cells, sortDirection, emptyCellAsZero) {
    const cellsWithIndex = cells.map((cell, index) => ({
        index,
        type: cell.type,
        value: cell.value,
    }));
    const cellsToSort = emptyCellAsZero
        ? cellsWithIndex.map((cell) => cell.type === CellValueType.empty ? { ...cell, type: CellValueType.number, value: 0 } : cell)
        : cellsWithIndex;
    return cellsToSort.sort(cellsSortingCriterion(sortDirection));
}

function sortMatrix(matrix, locale, ...criteria) {
    for (let i = 0; i < criteria.length; i++) {
        const param = i % 2 === 0 ? "sort_column" : "is_ascending";
        assert(criteria[i] !== undefined, _t$1("Value for parameter %s is missing in [[FUNCTION_NAME]].", param));
    }
    const sortingOrders = [];
    const sortColumns = [];
    const nRows = matrix.length;
    for (let i = 0; i < criteria.length; i += 2) {
        sortingOrders.push(toBoolean(toScalar(criteria[i + 1])?.value) ? "asc" : "desc");
        const sortColumn = criteria[i];
        if (isMatrix(sortColumn) && (sortColumn.length > 1 || sortColumn[0].length > 1)) {
            assert(sortColumn.length === 1 && sortColumn[0].length === nRows, _t$1("Wrong size for %s. Expected a range of size 1x%s. Got %sx%s.", `sort_column${i + 1}`, nRows, sortColumn.length, sortColumn[0].length));
            sortColumns.push(sortColumn.flat().map((c) => c.value));
        }
        else {
            const colIndex = toNumber(toScalar(sortColumn)?.value, locale);
            if (colIndex < 1 || colIndex > matrix[0].length) {
                return matrix;
            }
            sortColumns.push(matrix.map((row) => row[colIndex - 1].value));
        }
    }
    if (sortColumns.length === 0) {
        for (let i = 0; i < matrix[0].length; i++) {
            sortColumns.push(matrix.map((row) => row[i].value));
            sortingOrders.push("asc");
        }
    }
    const sortingCriteria = {
        desc: cellsSortingCriterion("desc"),
        asc: cellsSortingCriterion("asc"),
    };
    const indexes = range$1(0, matrix.length);
    indexes.sort((a, b) => {
        for (const [i, sortColumn] of sortColumns.entries()) {
            const left = sortColumn[a];
            const right = sortColumn[b];
            const leftCell = {
                value: left,
                type: left === null
                    ? CellValueType.empty
                    : typeof left === "string"
                        ? CellValueType.text
                        : typeof left,
            };
            const rightCell = {
                value: right,
                type: right === null
                    ? CellValueType.empty
                    : typeof right === "string"
                        ? CellValueType.text
                        : typeof right,
            };
            const result = sortingCriteria[sortingOrders[i]](leftCell, rightCell);
            if (result !== 0) {
                return result;
            }
        }
        return 0;
    });
    return indexes.map((i) => matrix[i]);
}
// -----------------------------------------------------------------------------
// FILTER
// -----------------------------------------------------------------------------
const FILTER = {
    description: _t$1("Returns a filtered version of the source range, returning only rows or columns that meet the specified conditions."),
    // TODO modify args description when vectorization on formulas is available
    args: [
        arg("range (any, range<any>)", _t$1("The data to be filtered.")),
        arg("condition1 (boolean, range<boolean>)", _t$1("A column or row containing true or false values corresponding to the first column or row of range.")),
        arg("condition2 (boolean, range<boolean>, repeating)", _t$1("Additional column or row containing true or false values.")),
    ],
    compute: function (range, ...conditions) {
        let _array = toMatrix(range);
        const _conditionsMatrices = conditions.map((cond) => matrixMap(toMatrix(cond), (data) => data.value));
        for (const c of _conditionsMatrices) {
            if (!isSingleColOrRow(c)) {
                return new EvaluationError(_t$1("The arguments condition must be a single column or row."));
            }
        }
        if (!areSameDimensions(...conditions)) {
            return new EvaluationError(_t$1("The arguments conditions must have the same dimensions."));
        }
        const _conditions = _conditionsMatrices.map((c) => c.flat());
        const mode = _conditionsMatrices[0].length === 1 ? "row" : "col";
        _array = mode === "row" ? transposeMatrix(_array) : _array;
        if (_conditions.some((cond) => cond.length !== _array.length)) {
            return new EvaluationError(_t$1("FILTER has mismatched sizes on the range and conditions."));
        }
        const result = [];
        for (let i = 0; i < _array.length; i++) {
            const row = _array[i];
            if (_conditions.every((c) => (typeof c[i] === "boolean" || typeof c[i] === "number") && c[i])) {
                result.push(row);
            }
        }
        if (!result.length) {
            return new NotAvailableError(_t$1("No match found in FILTER evaluation"));
        }
        return mode === "row" ? transposeMatrix(result) : result;
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// SORT
// -----------------------------------------------------------------------------
const SORT = {
    description: _t$1("Sorts the rows of a given array or range by the values in one or more columns."),
    args: [
        arg("range (range)", _t$1("The data to be sorted.")),
        arg("sort_column (any, range<number>, repeating)", _t$1("The index of the column in range or a range outside of range containing the values by which to sort.")),
        arg("is_ascending (boolean, repeating)", _t$1("TRUE or FALSE indicating whether to sort sort_column in ascending order."), [
            { value: true, label: _t$1("Ascending") },
            { value: false, label: _t$1("Descending") },
        ]),
    ],
    compute: function (range, ...sortingCriteria) {
        const _range = transposeMatrix(range);
        return transposeMatrix(sortMatrix(_range, this.locale, ...sortingCriteria));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SORTN
// -----------------------------------------------------------------------------
const SORTN = {
    description: _t$1("Returns the first n items in a data set after performing a sort."),
    args: [
        arg("range (range)", _t$1("The data to be sorted.")),
        arg("n (number)", _t$1("The number of items to return.")),
        arg("display_ties_mode (number, default=0)", _t$1("A number representing the way to display ties.")),
        arg("sort_column (number, range<number>, repeating)", _t$1("The index of the column in range or a range outside of range containing the values by which to sort.")),
        arg("is_ascending (boolean, repeating)", _t$1("TRUE or FALSE indicating whether to sort sort_column in ascending order."), [
            { value: true, label: _t$1("Ascending") },
            { value: false, label: _t$1("Descending") },
        ]),
    ],
    compute: function (range, n, ...displayTiesMode_sortingCriteria) {
        const _n = toNumber(n?.value ?? 1, this.locale);
        const _displayTiesMode = displayTiesMode_sortingCriteria.length % 2 === 0
            ? 0
            : toNumber(displayTiesMode_sortingCriteria[0]?.value, this.locale);
        const sortingCriteria = displayTiesMode_sortingCriteria.length % 2 === 0
            ? displayTiesMode_sortingCriteria
            : displayTiesMode_sortingCriteria.slice(1);
        if (_n < 0) {
            return new EvaluationError(_t$1("Wrong value of 'n'. Expected a positive number. Got %s.", _n));
        }
        if (_displayTiesMode < 0 || _displayTiesMode > 3) {
            return new EvaluationError(_t$1("Wrong value of 'display_ties_mode'. Expected a positive number between 0 and 3. Got %s.", _displayTiesMode));
        }
        const sortedData = sortMatrix(transposeMatrix(range), this.locale, ...sortingCriteria);
        const sameRows = (i, j) => JSON.stringify(sortedData[i].map((c) => c.value)) ===
            JSON.stringify(sortedData[j].map((c) => c.value));
        /*
         * displayTiesMode determine how ties (equal values) are dealt with:
         * 0 - ignore ties and show first n rows only
         * 1 - show first n rows plus any additional ties with nth row
         * 2 - show n rows but remove duplicates
         * 3 - show first n unique rows and all duplicates of these rows
         */
        switch (_displayTiesMode) {
            case 0:
                return transposeMatrix(sortedData.slice(0, _n));
            case 1:
                for (let i = _n; i < sortedData.length; i++) {
                    if (!sameRows(i, _n - 1)) {
                        return transposeMatrix(sortedData.slice(0, i));
                    }
                }
                return transposeMatrix(sortedData);
            case 2: {
                const uniques = [sortedData[0]];
                for (let i = 1; i < sortedData.length; i++) {
                    for (let j = 0; j < i; j++) {
                        if (sameRows(i, j)) {
                            break;
                        }
                        if (j === i - 1) {
                            uniques.push(sortedData[i]);
                        }
                    }
                }
                return transposeMatrix(uniques.slice(0, _n));
            }
            case 3: {
                const uniques = [sortedData[0]];
                let counter = 1;
                for (let i = 1; i < sortedData.length; i++) {
                    if (!sameRows(i, i - 1)) {
                        counter++;
                    }
                    if (counter > _n) {
                        break;
                    }
                    uniques.push(sortedData[i]);
                }
                return transposeMatrix(uniques);
            }
        }
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// UNIQUE
// -----------------------------------------------------------------------------
const UNIQUE = {
    description: _t$1("Unique rows in the provided source range."),
    args: [
        arg("range (any, range<any>)", _t$1("The data to filter by unique entries.")),
        arg("by_column (boolean, default=FALSE)", _t$1("Whether to filter the data by columns or by rows."), [
            { value: true, label: _t$1("Return unique columns") },
            { value: false, label: _t$1("Return unique rows") },
        ]),
        arg("exactly_once (boolean, default=FALSE)", _t$1("Whether to return only entries with no duplicates."), [
            { value: true, label: _t$1("Return items that appear exactly once") },
            { value: false, label: _t$1("Return every distinct item") },
        ]),
    ],
    compute: function (range = { value: "" }, byColumn, exactlyOnce) {
        if (!isMatrix(range)) {
            return [[range]];
        }
        const _byColumn = toBoolean(byColumn?.value) || false;
        const _exactlyOnce = toBoolean(exactlyOnce?.value) || false;
        if (!_byColumn) {
            range = transposeMatrix(range);
        }
        const map = new Map();
        for (const data of range) {
            const key = JSON.stringify(data.map((item) => item.value));
            const occurrence = map.get(key);
            if (!occurrence) {
                map.set(key, { data, count: 1 });
            }
            else {
                occurrence.count++;
            }
        }
        const result = [];
        for (const row of map.values()) {
            if (_exactlyOnce && row.count > 1) {
                continue;
            }
            result.push(row.data);
        }
        if (!result.length)
            return new EvaluationError(_t$1("No unique values found"));
        return _byColumn ? result : transposeMatrix(result);
    },
    isExported: true,
};

var filter = /*#__PURE__*/Object.freeze({
    __proto__: null,
    FILTER: FILTER,
    SORT: SORT,
    SORTN: SORTN,
    UNIQUE: UNIQUE
});

const DEFAULT_DAY_COUNT_CONVENTION = 0;
const DEFAULT_END_OR_BEGINNING = 0;
const DEFAULT_FUTURE_VALUE = 0;
const FREQUENCY_OPTIONS = [
    { value: 1, label: _t$1("Annual") },
    { value: 2, label: _t$1("Semi-annual") },
    { value: 4, label: _t$1("Quarterly") },
];
const PAYMENT_TIMING_OPTIONS = [
    { value: 0, label: _t$1("End of period (default)") },
    { value: 1, label: _t$1("Beginning of period") },
];
const COUPON_FUNCTION_ARGS = [
    arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
    arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
    arg("frequency (number)", _t$1("The number of interest or coupon payments per year (1, 2, or 4)."), FREQUENCY_OPTIONS),
    arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
];
/**
 * Use the Newton–Raphson method to find a root of the given function in an iterative manner.
 *
 * @param func the function to find a root of
 * @param derivFunc the derivative of the function
 * @param startValue the initial value for the first iteration of the algorithm
 * @param maxIterations the maximum number of iterations
 * @param epsMax the epsilon for the root
 * @param nanFallback a function giving a fallback value to use if func(x) returns NaN. Useful if the
 *                       function is not defined for some range, but we know approximately where the root is when the Newton
 *                       algorithm ends up in this range.
 */
function newtonMethod(func, derivFunc, startValue, maxIterations, epsMax = 1e-10, nanFallback) {
    let x = startValue;
    let newX;
    let xDelta;
    let y;
    let yEqual0 = false;
    let count = 0;
    let previousFallback = undefined;
    do {
        y = func(x);
        if (isNaN(y)) {
            assert(count < maxIterations && nanFallback !== undefined, _t$1("Function [[FUNCTION_NAME]] didn't find any result."));
            count++;
            x = nanFallback(previousFallback);
            previousFallback = x;
            continue;
        }
        newX = x - y / derivFunc(x);
        xDelta = Math.abs(newX - x);
        x = newX;
        yEqual0 = xDelta < epsMax || Math.abs(y) < epsMax;
        assert(count < maxIterations, _t$1("Function [[FUNCTION_NAME]] didn't find any result."));
        count++;
    } while (!yEqual0);
    return x;
}
// -----------------------------------------------------------------------------
// ACCRINTM
// -----------------------------------------------------------------------------
const ACCRINTM = {
    description: _t$1("Accrued interest of security paying at maturity."),
    args: [
        arg("issue (date)", _t$1("The date the security was initially issued.")),
        arg("maturity (date)", _t$1("The maturity date of the security.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (issue, maturity, rate, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const start = Math.trunc(toNumber(issue, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _redemption = toNumber(redemption, this.locale);
        const _rate = toNumber(rate, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start < 0) {
            return new EvaluationError(expectIssuePositiveOrZero(start));
        }
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        if (_rate <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(_rate));
        }
        const yearFrac = getYearFrac(start, end, _dayCountConvention);
        return _redemption * _rate * yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AMORLINC
// -----------------------------------------------------------------------------
const AMORLINC = {
    description: _t$1("Depreciation for an accounting period."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("purchase_date (date)", _t$1("The date the asset was purchased.")),
        arg("first_period_end (date)", _t$1("The date the first period ended.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("period (number)", _t$1("The single period within life for which to calculate depreciation.")),
        arg("rate (number)", _t$1("The deprecation rate.")),
        arg("day_count_convention (number, optional)", _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (cost, purchaseDate, firstPeriodEnd, salvage, period, rate, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _cost = toNumber(cost, this.locale);
        const _purchaseDate = Math.trunc(toNumber(purchaseDate, this.locale));
        const _firstPeriodEnd = Math.trunc(toNumber(firstPeriodEnd, this.locale));
        const _salvage = toNumber(salvage, this.locale);
        const _period = toNumber(period, this.locale);
        const _rate = toNumber(rate, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_cost <= 0) {
            return new EvaluationError(expectCostStrictlyPositive(_cost));
        }
        if (_purchaseDate < 0) {
            return new EvaluationError(expectPurchaseDatePositiveOrZero(_purchaseDate));
        }
        if (_salvage < 0) {
            return new EvaluationError(expectSalvagePositiveOrZero(_salvage));
        }
        if (_salvage > _cost) {
            return new EvaluationError(expectSalvageSmallerOrEqualThanCost(_salvage, _cost));
        }
        if (_period < 0) {
            return new EvaluationError(expectPeriodPositiveOrZero(_period));
        }
        if (_rate <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(_rate));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_purchaseDate > _firstPeriodEnd) {
            return new EvaluationError(expectPurchaseDateBeforeFirstPeriodEnd(_purchaseDate, _firstPeriodEnd));
        }
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/AMORLINC
         *
         * AMORLINC period 0 = cost * rate * YEARFRAC(purchase date, first period end)
         * AMORLINC period n = cost * rate
         * AMORLINC at the last period is such that the remaining deprecated cost is equal to the salvage value.
         *
         * The period is and rounded to 1 if < 1 truncated if > 1,
         *
         * Compatibility note :
         * If (purchase date) === (first period end), on GSheet the deprecation at the first period is 0, and on Excel
         * it is a full period deprecation. We choose to use the Excel behaviour.
         */
        const roundedPeriod = _period < 1 && _period > 0 ? 1 : Math.trunc(_period);
        const deprec = _cost * _rate;
        const yearFrac = getYearFrac(_purchaseDate, _firstPeriodEnd, _dayCountConvention);
        const firstDeprec = _purchaseDate === _firstPeriodEnd ? deprec : deprec * yearFrac;
        const valueAtPeriod = _cost - firstDeprec - deprec * roundedPeriod;
        if (valueAtPeriod >= _salvage) {
            return roundedPeriod === 0 ? firstDeprec : deprec;
        }
        return _salvage - valueAtPeriod < deprec ? deprec - (_salvage - valueAtPeriod) : 0;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYS
// -----------------------------------------------------------------------------
const COUPDAYS = {
    description: _t$1("Days in coupon period containing settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        // https://wiki.documentfoundation.org/Documentation/Calc_Functions/COUPDAYS
        if (_dayCountConvention === 1) {
            const before = COUPPCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
            const after = COUPNCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
            return toNumber(after, this.locale) - toNumber(before, this.locale);
        }
        const daysInYear = _dayCountConvention === 3 ? 365 : 360;
        return daysInYear / _frequency;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYBS
// -----------------------------------------------------------------------------
const COUPDAYBS = {
    description: _t$1("Days from settlement until next coupon."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        const couponBeforeStart = COUPPCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
        const _couponBeforeStart = toNumber(couponBeforeStart, this.locale);
        if ([1, 2, 3].includes(_dayCountConvention)) {
            return start - _couponBeforeStart;
        }
        if (_dayCountConvention === 4) {
            const yearFrac = getYearFrac(_couponBeforeStart, start, _dayCountConvention);
            return Math.round(yearFrac * 360);
        }
        const startDate = toJsDate(start, this.locale);
        const dateCouponBeforeStart = toJsDate(_couponBeforeStart, this.locale);
        const y1 = dateCouponBeforeStart.getFullYear();
        const y2 = startDate.getFullYear();
        const m1 = dateCouponBeforeStart.getMonth() + 1; // +1 because months in js start at 0 and it's confusing
        const m2 = startDate.getMonth() + 1;
        let d1 = dateCouponBeforeStart.getDate();
        let d2 = startDate.getDate();
        /**
         * Rules based on https://en.wikipedia.org/wiki/Day_count_convention#30/360_US
         *
         * These are slightly modified (no mention of if investment is EOM and rules order is modified),
         * but from my testing this seems the rules used by Excel/GSheet.
         */
        if (m1 === 2 &&
            m2 === 2 &&
            isLastDayOfMonth(dateCouponBeforeStart) &&
            isLastDayOfMonth(startDate)) {
            d2 = 30;
        }
        if (d2 === 31 && (d1 === 30 || d1 === 31)) {
            d2 = 30;
        }
        if (m1 === 2 && isLastDayOfMonth(dateCouponBeforeStart)) {
            d1 = 30;
        }
        if (d1 === 31) {
            d1 = 30;
        }
        return (y2 - y1) * 360 + (m2 - m1) * 30 + (d2 - d1);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYSNC
// -----------------------------------------------------------------------------
const COUPDAYSNC = {
    description: _t$1("Days from settlement until next coupon."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        const couponAfterStart = COUPNCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
        const _couponAfterStart = toNumber(couponAfterStart, this.locale);
        if ([1, 2, 3].includes(_dayCountConvention)) {
            return _couponAfterStart - start;
        }
        if (_dayCountConvention === 4) {
            const yearFrac = getYearFrac(start, _couponAfterStart, _dayCountConvention);
            return Math.round(yearFrac * 360);
        }
        const coupDayBs = COUPDAYBS.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const coupDays = COUPDAYS.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        return toNumber(coupDays, this.locale) - toNumber(coupDayBs, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPNCD
// -----------------------------------------------------------------------------
const COUPNCD = {
    description: _t$1("Next coupon date after the settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        const monthsPerPeriod = 12 / _frequency;
        const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const date = addMonthsToDate(toJsDate(end, this.locale), -(toNumber(coupNum, this.locale) - 1) * monthsPerPeriod, true);
        return {
            value: jsDateToRoundNumber(date),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPNUM
// -----------------------------------------------------------------------------
const COUPNUM = {
    description: _t$1("Number of coupons between settlement and maturity."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        let num = 1;
        let currentDate = end;
        const monthsPerPeriod = 12 / _frequency;
        while (currentDate > start) {
            currentDate = jsDateToRoundNumber(addMonthsToDate(toJsDate(currentDate, this.locale), -monthsPerPeriod, false));
            num++;
        }
        return num - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPPCD
// -----------------------------------------------------------------------------
const COUPPCD = {
    description: _t$1("Last coupon date prior to or on the settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        const monthsPerPeriod = 12 / _frequency;
        const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const date = addMonthsToDate(toJsDate(end, this.locale), -coupNum * monthsPerPeriod, true);
        return {
            value: jsDateToRoundNumber(date),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CUMIPMT
// -----------------------------------------------------------------------------
const CUMIPMT = {
    description: _t$1("Cumulative interest paid over a set of periods."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg("first_period (number)", _t$1("The number of the payment period to begin the cumulative calculation.")),
        arg("last_period (number)", _t$1("The number of the payment period to end the cumulative calculation.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const first = toNumber(firstPeriod, this.locale);
        const last = toNumber(lastPeriod, this.locale);
        const r = toNumber(rate, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        if (n <= 0) {
            return new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
        }
        if (first <= 0) {
            return new EvaluationError(expectFirstPeriodStrictlyPositive(first));
        }
        if (last <= 0) {
            return new EvaluationError(expectLastPeriodStrictlyPositive(last));
        }
        if (first > last) {
            return new EvaluationError(expectFirstPeriodSmallerOrEqualLastPeriod(first, last));
        }
        if (last > n) {
            return new EvaluationError(expectLastPeriodSmallerOrEqualNumberOfPeriods(last, n));
        }
        if (r <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(r));
        }
        if (pv <= 0) {
            return new EvaluationError(expectPresentValueStrictlyPositive(pv));
        }
        let cumSum = 0;
        for (let i = first; i <= last; i++) {
            cumSum += impt(r, i, n, pv, 0, type);
        }
        return cumSum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CUMPRINC
// -----------------------------------------------------------------------------
const CUMPRINC = {
    description: _t$1("Cumulative principal paid over a set of periods."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg("first_period (number)", _t$1("The number of the payment period to begin the cumulative calculation.")),
        arg("last_period (number)", _t$1("The number of the payment period to end the cumulative calculation.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const first = toNumber(firstPeriod, this.locale);
        const last = toNumber(lastPeriod, this.locale);
        const r = toNumber(rate, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        if (n <= 0) {
            return new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
        }
        if (first <= 0) {
            return new EvaluationError(expectFirstPeriodStrictlyPositive(first));
        }
        if (last <= 0) {
            return new EvaluationError(expectLastPeriodStrictlyPositive(last));
        }
        if (first > last) {
            return new EvaluationError(expectFirstPeriodSmallerOrEqualLastPeriod(first, last));
        }
        if (last > n) {
            return new EvaluationError(expectLastPeriodSmallerOrEqualNumberOfPeriods(last, n));
        }
        if (r <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(r));
        }
        if (pv <= 0) {
            return new EvaluationError(expectPresentValueStrictlyPositive(pv));
        }
        let cumSum = 0;
        for (let i = first; i <= last; i++) {
            cumSum += ppmt(r, i, n, pv, 0, type);
        }
        return cumSum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DB
// -----------------------------------------------------------------------------
const DB = {
    description: _t$1("Depreciation via declining balance method."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t$1("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t$1("The single period within life for which to calculate depreciation.")),
        arg("month (number, optional)", _t$1("The number of months in the first year of depreciation.")),
    ],
    // to do: replace by dollar format
    compute: function (cost, salvage, life, period, ...args) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = Math.trunc(toNumber(period, this.locale));
        const _month = args.length ? Math.trunc(toNumber(args[0], this.locale)) : 12;
        const lifeLimit = _life + (_month === 12 ? 0 : 1);
        if (_cost < 0) {
            return new EvaluationError(expectCostPositiveOrZero(_cost));
        }
        if (_salvage < 0) {
            return new EvaluationError(expectSalvagePositiveOrZero(_salvage));
        }
        if (_period <= 0) {
            return new EvaluationError(expectPeriodStrictlyPositive(_period));
        }
        if (_life <= 0) {
            return new EvaluationError(expectLifeStrictlyPositive(_life));
        }
        if (1 > _month || _month > 12) {
            return new EvaluationError(expectMonthBetweenOneAndTwelve(_month));
        }
        if (_period > lifeLimit) {
            return new EvaluationError(expectPeriodLessOrEqualToLifeLimit(_period, lifeLimit));
        }
        const monthPart = _month / 12;
        let rate = 1 - Math.pow(_salvage / _cost, 1 / _life);
        // round to 3 decimal places
        rate = Math.round(rate * 1000) / 1000;
        let before = _cost;
        let after = _cost * (1 - rate * monthPart);
        for (let i = 1; i < _period; i++) {
            before = after;
            after = before * (1 - rate);
            if (i === _life) {
                after = before * (1 - rate * (1 - monthPart));
            }
        }
        return {
            value: before - after,
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DDB
// -----------------------------------------------------------------------------
const DEFAULT_DDB_DEPRECIATION_FACTOR = 2;
const DEFAULT_DDB_FORMAT = "#,##0.00";
const DDB = {
    description: _t$1("Depreciation via double-declining balance method."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t$1("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t$1("The single period within life for which to calculate depreciation.")),
        arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t$1("The factor by which depreciation decreases.")),
    ],
    compute: function (cost, salvage, life, period, factor = { value: DEFAULT_DDB_DEPRECIATION_FACTOR }) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = toNumber(period, this.locale);
        const _factor = toNumber(factor, this.locale);
        if (_cost < 0) {
            return new EvaluationError(expectCostPositiveOrZero(_cost));
        }
        if (_salvage < 0) {
            return new EvaluationError(expectSalvagePositiveOrZero(_salvage));
        }
        if (_period <= 0) {
            return new EvaluationError(expectPeriodStrictlyPositive(_period));
        }
        if (_life <= 0) {
            return new EvaluationError(expectLifeStrictlyPositive(_life));
        }
        if (_period > _life) {
            return new EvaluationError(expectPeriodSmallerOrEqualToLife(_period, _life));
        }
        if (_factor <= 0) {
            return new EvaluationError(expectDeprecationFactorStrictlyPositive(_factor));
        }
        if (_cost === 0 || _salvage >= _cost) {
            return { value: 0, format: DEFAULT_DDB_FORMAT };
        }
        const deprecFactor = _factor / _life;
        if (deprecFactor > 1) {
            return { value: _period === 1 ? _cost - _salvage : 0, format: DEFAULT_DDB_FORMAT };
        }
        if (_period <= 1) {
            return {
                value: _cost * deprecFactor,
                format: DEFAULT_DDB_FORMAT,
            };
        }
        const previousCost = _cost * Math.pow(1 - deprecFactor, _period - 1);
        const nextCost = _cost * Math.pow(1 - deprecFactor, _period);
        const deprec = nextCost < _salvage ? previousCost - _salvage : previousCost - nextCost;
        return {
            value: Math.max(deprec, 0),
            format: DEFAULT_DDB_FORMAT,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DISC
// -----------------------------------------------------------------------------
const DISC = {
    description: _t$1("Discount rate of a security based on price."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t$1("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, price, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_price <= 0) {
            return new EvaluationError(expectPriceStrictlyPositive(_price));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        /**
         * https://support.microsoft.com/en-us/office/disc-function-71fce9f3-3f05-4acf-a5a3-eac6ef4daa53
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         *
         *        redemption - price          B
         * DISC = ____________________  *    ____
         *            redemption             DSM
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption - _price) / _redemption / yearsFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DOLLARDE
// -----------------------------------------------------------------------------
const DOLLARDE = {
    description: _t$1("Convert a decimal fraction to decimal value."),
    args: [
        arg("fractional_price (number)", _t$1("The price quotation given using fractional decimal conventions.")),
        arg("unit (number)", _t$1("The units of the fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
    ],
    compute: function (fractionalPrice, unit) {
        const price = toNumber(fractionalPrice, this.locale);
        const _unit = Math.trunc(toNumber(unit, this.locale));
        if (_unit <= 0) {
            return new EvaluationError(expectUnitStrictlyPositive(_unit));
        }
        const truncatedPrice = Math.trunc(price);
        const priceFractionalPart = price - truncatedPrice;
        const frac = 10 ** Math.ceil(Math.log10(_unit)) / _unit;
        return truncatedPrice + priceFractionalPart * frac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DOLLARFR
// -----------------------------------------------------------------------------
const DOLLARFR = {
    description: _t$1("Convert a decimal value to decimal fraction."),
    args: [
        arg("decimal_price (number)", _t$1("The price quotation given as a decimal value.")),
        arg("unit (number)", _t$1("The units of the desired fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
    ],
    compute: function (decimalPrice, unit) {
        const price = toNumber(decimalPrice, this.locale);
        const _unit = Math.trunc(toNumber(unit, this.locale));
        if (_unit <= 0) {
            return new EvaluationError(expectUnitStrictlyPositive(_unit));
        }
        const truncatedPrice = Math.trunc(price);
        const priceFractionalPart = price - truncatedPrice;
        const frac = _unit / 10 ** Math.ceil(Math.log10(_unit));
        return truncatedPrice + priceFractionalPart * frac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DURATION
// -----------------------------------------------------------------------------
const DURATION = {
    description: _t$1("Number of periods for an investment to reach a value."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("yield (number)", _t$1("The expected annual yield of the security.")),
        arg("frequency (number)", _t$1("The number of interest or coupon payments per year (1, 2, or 4)."), FREQUENCY_OPTIONS),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_rate < 0) {
            return new EvaluationError(expectRatePositiveOrZero(_rate));
        }
        if (_yield < 0) {
            return new EvaluationError(expectYieldPositiveOrZero(_yield));
        }
        const years = getYearFrac(start, end, _dayCountConvention);
        const timeFirstYear = years - Math.trunc(years) || 1 / _frequency;
        const nbrCoupons = Math.ceil(years * _frequency);
        // The DURATION function return the Macaulay duration
        // See example: https://en.wikipedia.org/wiki/Bond_duration#Formulas
        const cashFlowFromCoupon = _rate / _frequency;
        const yieldPerPeriod = _yield / _frequency;
        let count = 0;
        let sum = 0;
        for (let i = 1; i <= nbrCoupons; i++) {
            const cashFlowPerPeriod = cashFlowFromCoupon + (i === nbrCoupons ? 1 : 0);
            const presentValuePerPeriod = cashFlowPerPeriod / (1 + yieldPerPeriod) ** i;
            sum += (timeFirstYear + (i - 1) / _frequency) * presentValuePerPeriod;
            count += presentValuePerPeriod;
        }
        return count === 0 ? 0 : sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EFFECT
// -----------------------------------------------------------------------------
const EFFECT = {
    description: _t$1("Annual effective interest rate."),
    args: [
        arg("nominal_rate (number)", _t$1("The nominal interest rate per year.")),
        arg("periods_per_year (number)", _t$1("The number of compounding periods per year.")),
    ],
    compute: function (nominal_rate, periods_per_year) {
        const nominal = toNumber(nominal_rate, this.locale);
        const periods = Math.trunc(toNumber(periods_per_year, this.locale));
        if (nominal <= 0) {
            return new EvaluationError(expectNominalRateStrictlyPositive(nominal));
        }
        if (periods <= 0) {
            return new EvaluationError(expectPeriodsByYearStrictlyPositive(periods));
        }
        // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
        return Math.pow(1 + nominal / periods, periods) - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FV
// -----------------------------------------------------------------------------
const DEFAULT_PRESENT_VALUE = 0;
function fv(r, n, p, pv, t) {
    if (r === 0) {
        return -(pv + p * n);
    }
    return -pv * (1 + r) ** n - (p * (1 + r * t) * ((1 + r) ** n - 1)) / r;
}
const FV = {
    description: _t$1("Future value of an annuity investment."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("payment_amount (number)", _t$1("The amount per period to be paid.")),
        arg(`present_value (number, default=${DEFAULT_PRESENT_VALUE})`, _t$1("The current value of the annuity.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    // to do: replace by dollar format
    compute: function (rate, numberOfPeriods, paymentAmount, presentValue = { value: DEFAULT_PRESENT_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        presentValue = presentValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        return {
            value: fv(r, n, p, pv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FVSCHEDULE
// -----------------------------------------------------------------------------
const FVSCHEDULE = {
    description: _t$1("Future value of principal from series of rates."),
    args: [
        arg("principal (number)", _t$1("The amount of initial capital or value to compound against.")),
        arg("rate_schedule (number, range<number>)", _t$1("A series of interest rates to compound against the principal.")),
    ],
    compute: function (principalAmount, rateSchedule) {
        const principal = toNumber(principalAmount, this.locale);
        return reduceAny([rateSchedule], (acc, rate) => acc * (1 + toNumber(rate, this.locale)), principal);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INTRATE
// -----------------------------------------------------------------------------
const INTRATE = {
    description: _t$1("Calculates effective interest rate."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("investment (number)", _t$1("The amount invested in the security.")),
        arg("redemption (number)", _t$1("The amount to be received at maturity.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, investment, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _redemption = toNumber(redemption, this.locale);
        const _investment = toNumber(investment, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (_investment <= 0) {
            return new EvaluationError(expectInvestmentStrictlyPositive(_investment));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/INTRATE
         *
         *             (Redemption  - Investment) / Investment
         * INTRATE =  _________________________________________
         *              YEARFRAC(settlement, maturity, basis)
         */
        const yearFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption - _investment) / _investment / yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IPMT
// -----------------------------------------------------------------------------
function impt(r, per, n, pv, fv, type) {
    return pmt(r, n, pv, fv, type) - ppmt(r, per, n, pv, fv, type);
}
const IPMT = {
    description: _t$1("Payment on the principal of an investment."),
    args: [
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("period (number)", _t$1("The amortization period, in terms of number of periods.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const r = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        return {
            value: impt(r, period, n, pv, fv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IRR
// -----------------------------------------------------------------------------
const DEFAULT_RATE_GUESS = 0.1;
const IRR = {
    description: _t$1("Internal rate of return given periodic cashflows."),
    args: [
        arg("cashflow_amounts (number, range<number>)", _t$1("An array or range containing the income or payments associated with the investment.")),
        arg(`rate_guess (number, default=${DEFAULT_RATE_GUESS})`, _t$1("An estimate for what the internal rate of return will be.")),
    ],
    compute: function (cashFlowAmounts, rateGuess = { value: DEFAULT_RATE_GUESS }) {
        const _rateGuess = toNumber(rateGuess, this.locale);
        if (_rateGuess <= -1) {
            return new EvaluationError(expectRateGuessStrictlyGreaterThanMinusOne(_rateGuess));
        }
        // check that values contains at least one positive value and one negative value
        // and extract number present in the cashFlowAmount argument
        let positive = false;
        let negative = false;
        const amounts = [];
        visitNumbers([cashFlowAmounts], ({ value: amount }) => {
            if (amount > 0)
                positive = true;
            if (amount < 0)
                negative = true;
            amounts.push(amount);
        }, this.locale);
        if (!positive || !negative) {
            return new EvaluationError(expectCashFlowsHavePositiveAndNegativesValues);
        }
        const firstAmount = amounts.shift();
        // The result of IRR is the rate at which the NPV() function will return zero with the given values.
        // This algorithm uses the Newton's method on the NPV function to determine the result
        // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
        // As the NPV function isn't continuous, we apply the Newton's method on the numerator of the NPV formula.
        function npvNumerator(rate, startValue, values) {
            const nbrValue = values.length;
            let i = 0;
            return values.reduce((acc, v) => {
                i++;
                return acc + v * rate ** (nbrValue - i);
            }, startValue * rate ** nbrValue);
        }
        function npvNumeratorDeriv(rate, startValue, values) {
            const nbrValue = values.length;
            let i = 0;
            return values.reduce((acc, v) => {
                i++;
                return acc + v * (nbrValue - i) * rate ** (nbrValue - i - 1);
            }, startValue * nbrValue * rate ** (nbrValue - 1));
        }
        function func(x) {
            return npvNumerator(x, firstAmount, amounts);
        }
        function derivFunc(x) {
            return npvNumeratorDeriv(x, firstAmount, amounts);
        }
        return {
            value: newtonMethod(func, derivFunc, _rateGuess + 1, 20, 1e-5) - 1,
            format: "0%",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISPMT
// -----------------------------------------------------------------------------
const ISPMT = {
    description: _t$1("Returns the interest paid at a particular period of an investment."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("period (number)", _t$1("The period for which you want to view the interest payment.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue) {
        const interestRate = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const nOfPeriods = toNumber(numberOfPeriods, this.locale);
        const investment = toNumber(presentValue, this.locale);
        if (nOfPeriods === 0) {
            return new EvaluationError(expectNumberOfPeriodDifferentFromZero(nOfPeriods));
        }
        const currentInvestment = investment - investment * (period / nOfPeriods);
        return -1 * currentInvestment * interestRate;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MDURATION
// -----------------------------------------------------------------------------
const MDURATION = {
    description: _t$1("Modified Macaulay duration."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("yield (number)", _t$1("The expected annual yield of the security.")),
        arg("frequency (number)", _t$1("The number of interest or coupon payments per year (1, 2, or 4)."), FREQUENCY_OPTIONS),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const duration = DURATION.compute.bind(this)(settlement, maturity, rate, securityYield, frequency, dayCountConvention);
        const y = toNumber(securityYield, this.locale);
        const k = Math.trunc(toNumber(frequency, this.locale));
        return toNumber(duration, this.locale) / (1 + y / k);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MIRR
// -----------------------------------------------------------------------------
const MIRR = {
    description: _t$1("Modified internal rate of return."),
    args: [
        arg("cashflow_amounts (range<number>)", _t$1("A range containing the income or payments associated with the investment. The array should contain bot payments and incomes.")),
        arg("financing_rate (number)", _t$1("The interest rate paid on funds invested.")),
        arg("reinvestment_return_rate (number)", _t$1("The return (as a percentage) earned on reinvestment of income received from the investment.")),
    ],
    compute: function (cashflowAmount, financingRate, reinvestmentRate) {
        const fRate = toNumber(financingRate, this.locale);
        const rRate = toNumber(reinvestmentRate, this.locale);
        const cashFlow = transposeMatrix(cashflowAmount)
            .flat()
            .filter((t) => t.value !== null)
            .map((val) => toNumber(val, this.locale));
        const n = cashFlow.length;
        /**
         * https://en.wikipedia.org/wiki/Modified_internal_rate_of_return
         *
         *         /  FV(positive cash flows, reinvestment rate) \  ^ (1 / (n - 1))
         * MIRR = |  ___________________________________________  |                 - 1
         *         \   - PV(negative cash flows, finance rate)   /
         *
         * with n the number of cash flows.
         *
         * You can compute FV and PV as :
         *
         * FV =    SUM      [ (cashFlow[i]>0 ? cashFlow[i] : 0) * (1 + rRate)**(n - i-1) ]
         *       i= 0 => n
         *
         * PV =    SUM      [ (cashFlow[i]<0 ? cashFlow[i] : 0) / (1 + fRate)**i ]
         *       i= 0 => n
         */
        let fv = 0;
        let pv = 0;
        for (const i of range$1(0, n)) {
            const amount = cashFlow[i];
            if (amount >= 0) {
                fv += amount * (rRate + 1) ** (n - i - 1);
            }
            else {
                pv += amount / (fRate + 1) ** i;
            }
        }
        if (pv === 0 || fv === 0) {
            return new EvaluationError(expectCashFlowsHavePositiveAndNegativesValues);
        }
        const exponent = 1 / (n - 1);
        return (-fv / pv) ** exponent - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOMINAL
// -----------------------------------------------------------------------------
const NOMINAL = {
    description: _t$1("Annual nominal interest rate."),
    args: [
        arg("effective_rate (number)", _t$1("The effective interest rate per year.")),
        arg("periods_per_year (number)", _t$1("The number of compounding periods per year.")),
    ],
    compute: function (effective_rate, periods_per_year) {
        const effective = toNumber(effective_rate, this.locale);
        const periods = Math.trunc(toNumber(periods_per_year, this.locale));
        if (effective <= 0) {
            return new EvaluationError(expectEffectiveRateStrictlyPositive(effective));
        }
        if (periods <= 0) {
            return new EvaluationError(expectPeriodsByYearStrictlyPositive(periods));
        }
        // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
        return (Math.pow(effective + 1, 1 / periods) - 1) * periods;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NPER
// -----------------------------------------------------------------------------
const NPER = {
    description: _t$1("Number of payment periods for an investment."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("payment_amount (number)", _t$1("The amount of each payment made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, paymentAmount, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        futureValue = futureValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const t = toBoolean(endOrBeginning) ? 1 : 0;
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/NPER
         *
         * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
         *
         * We solve the equation for N:
         *
         * with C = [ p * (1 + r * t)] / r and
         *      R = 1 + r
         *
         * => 0 = pv * R^N + C * R^N - C + fv
         * <=> (C - fv) = R^N * (pv + C)
         * <=> log[(C - fv) / (pv + C)] = N * log(R)
         */
        if (r === 0) {
            return -(fv + pv) / p;
        }
        const c = (p * (1 + r * t)) / r;
        return Math.log((c - fv) / (pv + c)) / Math.log(1 + r);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NPV
// -----------------------------------------------------------------------------
function npvResult(r, startValue, values, locale) {
    let i = 0;
    return reduceNumbers(values, (acc, v) => {
        i++;
        return acc + v / (1 + r) ** i;
    }, startValue, locale);
}
const NPV = {
    description: _t$1("The net present value of an investment based on a series of periodic cash flows and a discount rate."),
    args: [
        arg("discount (number)", _t$1("The discount rate of the investment over one period.")),
        arg("cashflow1 (number, range<number>)", _t$1("The first future cash flow.")),
        arg("cashflow2 (number, range<number>, repeating)", _t$1("Additional future cash flows.")),
    ],
    // to do: replace by dollar format
    compute: function (discount, ...values) {
        const _discount = toNumber(discount, this.locale);
        if (_discount === -1) {
            return new EvaluationError(expectDiscountDifferentFromMinusOne(_discount));
        }
        return {
            value: npvResult(_discount, 0, values, this.locale),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PDURATION
// -----------------------------------------------------------------------------
const PDURATION = {
    description: _t$1("Computes the number of periods needed for an investment to reach a value."),
    args: [
        arg("rate (number)", _t$1("The rate at which the investment grows each period.")),
        arg("present_value (number)", _t$1("The investment's current value.")),
        arg("future_value (number)", _t$1("The investment's desired future value.")),
    ],
    compute: function (rate, presentValue, futureValue) {
        const _rate = toNumber(rate, this.locale);
        const _presentValue = toNumber(presentValue, this.locale);
        const _futureValue = toNumber(futureValue, this.locale);
        if (_rate <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(_rate));
        }
        if (_presentValue <= 0) {
            return new EvaluationError(expectPresentValueStrictlyPositive(_presentValue));
        }
        if (_futureValue <= 0) {
            return new EvaluationError(expectFutureValueStrictlyPositive(_futureValue));
        }
        return (Math.log(_futureValue) - Math.log(_presentValue)) / Math.log(1 + _rate);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PMT
// -----------------------------------------------------------------------------
function pmt(r, n, pv, fv, t) {
    if (n <= 0) {
        throw new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
    }
    /**
     * https://wiki.documentfoundation.org/Documentation/Calc_Functions/PMT
     *
     * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
     *
     * We simply the equation for p
     */
    if (r === 0) {
        return -(fv + pv) / n;
    }
    let payment = -(pv * (1 + r) ** n + fv);
    payment = (payment * r) / ((1 + r * t) * ((1 + r) ** n - 1));
    return payment;
}
const PMT = {
    description: _t$1("Periodic payment for an annuity investment."),
    args: [
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const r = toNumber(rate, this.locale);
        const t = toBoolean(endOrBeginning) ? 1 : 0;
        const fv = toNumber(futureValue, this.locale);
        const pv = toNumber(presentValue, this.locale);
        return { value: pmt(r, n, pv, fv, t), format: "#,##0.00" };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PPMT
// -----------------------------------------------------------------------------
function ppmt(r, per, n, pValue, fValue, t) {
    if (n <= 0) {
        throw new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
    }
    if (per <= 0 || per > n) {
        throw new EvaluationError(expectPeriodBetweenOneAndNumberOfPeriods(n));
    }
    const payment = pmt(r, n, pValue, fValue, t);
    if (t === 1 && per === 1)
        return payment;
    const eqPeriod = t === 0 ? per - 1 : per - 2;
    const eqPv = pValue + payment * t;
    const capitalAtPeriod = -fv(r, eqPeriod, payment, eqPv, 0);
    const currentInterest = capitalAtPeriod * r;
    return payment + currentInterest;
}
const PPMT = {
    description: _t$1("Payment on the principal of an investment."),
    args: [
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("period (number)", _t$1("The amortization period, in terms of number of periods.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const r = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        const fv = toNumber(futureValue, this.locale);
        const pv = toNumber(presentValue, this.locale);
        return {
            value: ppmt(r, period, n, pv, fv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PV
// -----------------------------------------------------------------------------
const PV = {
    description: _t$1("Present value of an annuity investment."),
    args: [
        arg("rate (number)", _t$1("The interest rate.")),
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("payment_amount (number)", _t$1("The amount per period to be paid.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
    ],
    // to do: replace by dollar format
    compute: function (rate, numberOfPeriods, paymentAmount, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        futureValue = futureValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        // https://wiki.documentfoundation.org/Documentation/Calc_Functions/PV
        return {
            value: r
                ? -((p * (1 + r * type) * ((1 + r) ** n - 1)) / r + fv) / (1 + r) ** n
                : -(fv + p * n),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICE
// -----------------------------------------------------------------------------
const PRICE = {
    description: _t$1("Price of a security paying periodic interest."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("yield (number)", _t$1("The expected annual yield of the security.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg("frequency (number)", _t$1("The number of interest or coupon payments per year (1, 2, or 4)."), FREQUENCY_OPTIONS),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, rate, securityYield, redemption, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_rate < 0) {
            return new EvaluationError(expectRatePositiveOrZero(_rate));
        }
        if (_yield < 0) {
            return new EvaluationError(expectYieldPositiveOrZero(_yield));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        const years = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const nbrRealCoupons = years * _frequency;
        const nbrFullCoupons = Math.ceil(nbrRealCoupons);
        const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
        const yieldFactorPerPeriod = 1 + _yield / _frequency;
        const cashFlowFromCoupon = (100 * _rate) / _frequency;
        if (nbrFullCoupons === 1) {
            return ((cashFlowFromCoupon + _redemption) / ((timeFirstCoupon * _yield) / _frequency + 1) -
                cashFlowFromCoupon * (1 - timeFirstCoupon));
        }
        let cashFlowsPresentValue = 0;
        for (let i = 1; i <= nbrFullCoupons; i++) {
            cashFlowsPresentValue +=
                cashFlowFromCoupon / yieldFactorPerPeriod ** (i - 1 + timeFirstCoupon);
        }
        const redemptionPresentValue = _redemption / yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
        return (redemptionPresentValue + cashFlowsPresentValue - cashFlowFromCoupon * (1 - timeFirstCoupon));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICEDISC
// -----------------------------------------------------------------------------
const PRICEDISC = {
    description: _t$1("Price of a discount security."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t$1("The discount rate of the security at time of purchase.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, discount, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _discount = toNumber(discount, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_discount <= 0) {
            return new EvaluationError(expectDiscountStrictlyPositive(_discount));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        /**
         * https://support.microsoft.com/en-us/office/pricedisc-function-d06ad7c1-380e-4be7-9fd9-75e3079acfd3
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         *
         * PRICEDISC = redemption - discount * redemption * (DSM/B)
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return _redemption - _discount * _redemption * yearsFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICEMAT
// -----------------------------------------------------------------------------
const PRICEMAT = {
    description: _t$1("Calculates the price of a security paying interest at maturity, based on expected yield."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("issue (date)", _t$1("The date the security was initially issued.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("yield (number)", _t$1("The expected annual yield of the security.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, issue, rate, securityYield, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _issue = Math.trunc(toNumber(issue, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _dayCount = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement <= _issue) {
            return new EvaluationError(expectSettlementStrictlyGreaterThanIssue(_settlement, _issue));
        }
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCount)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCount));
        }
        if (_rate < 0) {
            return new EvaluationError(expectRatePositiveOrZero(_rate));
        }
        if (_yield < 0) {
            return new EvaluationError(expectYieldPositiveOrZero(_yield));
        }
        /**
         * https://support.microsoft.com/en-us/office/pricemat-function-52c3b4da-bc7e-476a-989f-a95f675cae77
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         * DIM = number of days from issue to maturity
         * DIS = number of days from issue to settlement
         *
         *             100 + (DIM/B * rate * 100)
         *  PRICEMAT =  __________________________   - (DIS/B * rate * 100)
         *              1 + (DSM/B * yield)
         *
         * The ratios number_of_days / days_in_year are computed using the YEARFRAC function, that handle
         * differences due to day count conventions.
         *
         * Compatibility note :
         *
         * Contrary to GSheet and OpenOffice, Excel doesn't seems to always use its own YEARFRAC function
         * to compute PRICEMAT, and give different values for some combinations of dates and day count
         * conventions ( notably for leap years and dayCountConvention = 1 (Actual/Actual)).
         *
         * Our function PRICEMAT give us the same results as LibreOffice Calc.
         * Google Sheet use the formula with YEARFRAC, but its YEARFRAC function results are different
         * from the results of Excel/LibreOffice, thus we get different values with PRICEMAT.
         *
         */
        const settlementToMaturity = getYearFrac(_settlement, _maturity, _dayCount);
        const issueToSettlement = getYearFrac(_settlement, _issue, _dayCount);
        const issueToMaturity = getYearFrac(_issue, _maturity, _dayCount);
        const numerator = 100 + issueToMaturity * _rate * 100;
        const denominator = 1 + settlementToMaturity * _yield;
        const term2 = issueToSettlement * _rate * 100;
        return numerator / denominator - term2;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RATE
// -----------------------------------------------------------------------------
const RATE_GUESS_DEFAULT = 0.1;
const RATE = {
    description: _t$1("Interest rate of an annuity investment."),
    args: [
        arg("number_of_periods (number)", _t$1("The number of payments to be made.")),
        arg("payment_per_period (number)", _t$1("The amount per period to be paid.")),
        arg("present_value (number)", _t$1("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t$1("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t$1("The timing of the payment payments are due for each period."), PAYMENT_TIMING_OPTIONS),
        arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t$1("An estimate for what the interest rate will be.")),
    ],
    compute: function (numberOfPeriods, paymentPerPeriod, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }, rateGuess = { value: RATE_GUESS_DEFAULT }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const payment = toNumber(paymentPerPeriod, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        const guess = toNumber(rateGuess, this.locale) || RATE_GUESS_DEFAULT;
        let fv = toNumber(futureValue, this.locale);
        let pv = toNumber(presentValue, this.locale);
        if (n <= 0) {
            return new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
        }
        if (!havePositiveAndNegativeValues([payment, pv, fv])) {
            return new EvaluationError(_t$1("There must be both positive and negative values in [payment_amount, present_value, future_value]."));
        }
        if (guess <= -1) {
            return new EvaluationError(expectRateGuessStrictlyGreaterThanMinusOne(guess));
        }
        fv -= payment * type;
        pv += payment * type;
        // https://github.com/apache/openoffice/blob/trunk/main/sc/source/core/tool/interpr2.cxx
        const func = (rate) => {
            const powN = Math.pow(1 + rate, n);
            const intResult = (powN - 1) / rate;
            return fv + pv * powN + payment * intResult;
        };
        const derivFunc = (rate) => {
            const powNMinus1 = Math.pow(1 + rate, n - 1);
            const powN = Math.pow(1 + rate, n);
            const intResult = (powN - 1) / rate;
            const intResultDeriv = (n * powNMinus1) / rate - intResult / rate;
            const fTermDerivation = pv * n * powNMinus1 + payment * intResultDeriv;
            return fTermDerivation;
        };
        return {
            value: newtonMethod(func, derivFunc, guess, 40, 1e-5),
            format: "0%",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RECEIVED
// -----------------------------------------------------------------------------
const RECEIVED = {
    description: _t$1("Amount received at maturity for a security."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("investment (number)", _t$1("The amount invested (irrespective of face value of each security).")),
        arg("discount (number)", _t$1("The discount rate of the security invested in.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, investment, discount, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _investment = toNumber(investment, this.locale);
        const _discount = toNumber(discount, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_investment <= 0) {
            return new EvaluationError(expectInvestmentStrictlyPositive(_investment));
        }
        if (_discount <= 0) {
            return new EvaluationError(expectDiscountStrictlyPositive(_discount));
        }
        /**
         * https://support.microsoft.com/en-us/office/received-function-7a3f8b93-6611-4f81-8576-828312c9b5e5
         *
         *                    investment
         * RECEIVED = _________________________
         *              1 - discount * DSM / B
         *
         * with DSM = number of days from settlement to maturity and B = number of days in a year
         *
         * The ratio DSM/B can be computed with the YEARFRAC function to take the dayCountConvention into account.
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return _investment / (1 - _discount * yearsFrac);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RRI
// -----------------------------------------------------------------------------
const RRI = {
    description: _t$1("Computes the rate needed for an investment to reach a specific value within a specific number of periods."),
    args: [
        arg("number_of_periods (number)", _t$1("The number of periods.")),
        arg("present_value (number)", _t$1("The present value of the investment.")),
        arg("future_value (number)", _t$1("The future value of the investment.")),
    ],
    compute: function (numberOfPeriods, presentValue, futureValue) {
        const n = toNumber(numberOfPeriods, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        if (n <= 0) {
            return new EvaluationError(expectNumberOfPeriodsStrictlyPositive(n));
        }
        /**
         * https://support.microsoft.com/en-us/office/rri-function-6f5822d8-7ef1-4233-944c-79e8172930f4
         *
         * RRI = (future value / present value) ^ (1 / number of periods) - 1
         */
        return (fv / pv) ** (1 / n) - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SLN
// -----------------------------------------------------------------------------
const SLN = {
    description: _t$1("Depreciation of an asset using the straight-line method."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t$1("The number of periods over which the asset is depreciated.")),
    ],
    compute: function (cost, salvage, life) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        // No assertion is done on the values of the arguments to be compatible with Excel/Gsheet that don't check the values.
        // It's up to the user to make sure the arguments make sense, which is good design because the user is smart.
        return {
            value: (_cost - _salvage) / _life,
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SYD
// -----------------------------------------------------------------------------
const SYD = {
    description: _t$1("Depreciation via sum of years digit method."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t$1("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t$1("The single period within life for which to calculate depreciation.")),
    ],
    compute: function (cost, salvage, life, period) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = toNumber(period, this.locale);
        if (_period <= 0) {
            return new EvaluationError(expectPeriodStrictlyPositive(_period));
        }
        if (_life <= 0) {
            return new EvaluationError(expectLifeStrictlyPositive(_life));
        }
        if (_period > _life) {
            return new EvaluationError(expectPeriodSmallerOrEqualToLife(_period, _life));
        }
        /**
         * This deprecation method use the sum of digits of the periods of the life as the deprecation factor.
         * For example for a life = 5, we have a deprecation factor or 1 + 2 + 3 + 4 + 5 = 15 = life * (life + 1) / 2 = F.
         *
         * The deprecation for a period p is then computed based on F and the remaining lifetime at the period P.
         *
         * deprecation = (cost - salvage) * (number of remaining periods / F)
         */
        const deprecFactor = (_life * (_life + 1)) / 2;
        const remainingPeriods = _life - _period + 1;
        return {
            value: (_cost - _salvage) * (remainingPeriods / deprecFactor),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLPRICE
// -----------------------------------------------------------------------------
function tBillPrice(start, end, disc) {
    /**
     * https://support.microsoft.com/en-us/office/tbillprice-function-eacca992-c29d-425a-9eb8-0513fe6035a2
     *
     * TBILLPRICE = 100 * (1 - discount * DSM / 360)
     *
     * with DSM = number of days from settlement to maturity
     *
     * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
     */
    const yearFrac = getYearFrac(start, end, 2);
    return 100 * (1 - disc * yearFrac);
}
const TBILLPRICE = {
    description: _t$1("Price of a US Treasury bill."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t$1("The discount rate of the bill at time of purchase.")),
    ],
    compute: function (settlement, maturity, discount) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const disc = toNumber(discount, this.locale);
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (!isSettlementLessThanOneYearBeforeMaturity(start, end, this.locale)) {
            return new EvaluationError(expectSettlementLessThanOneYearBeforeMaturity(start, end));
        }
        if (disc <= 0) {
            return new EvaluationError(expectDiscountStrictlyPositive(disc));
        }
        if (disc >= 1) {
            return new EvaluationError(expectDiscountStrictlySmallerThanOne(disc));
        }
        return tBillPrice(start, end, disc);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLEQ
// -----------------------------------------------------------------------------
const TBILLEQ = {
    description: _t$1("Equivalent rate of return for a US Treasury bill."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t$1("The discount rate of the bill at time of purchase.")),
    ],
    compute: function (settlement, maturity, discount) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const disc = toNumber(discount, this.locale);
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (!isSettlementLessThanOneYearBeforeMaturity(start, end, this.locale)) {
            return new EvaluationError(expectSettlementLessThanOneYearBeforeMaturity(start, end));
        }
        if (disc <= 0) {
            return new EvaluationError(expectDiscountStrictlyPositive(disc));
        }
        if (disc >= 1) {
            return new EvaluationError(expectDiscountStrictlySmallerThanOne(disc));
        }
        /**
         * https://support.microsoft.com/en-us/office/tbilleq-function-2ab72d90-9b4d-4efe-9fc2-0f81f2c19c8c
         *
         *               365 * discount
         * TBILLEQ = ________________________
         *            360 - discount * DSM
         *
         * with DSM = number of days from settlement to maturity
         *
         * What is not indicated in the Excel documentation is that this formula only works for duration between settlement
         * and maturity that are less than 6 months (182 days). This is because US Treasury bills use semi-annual interest,
         * and thus we have to take into account the compound interest for the calculation.
         *
         * For this case, the formula becomes (Treasury Securities and Derivatives, by Frank J. Fabozzi, page 49)
         *
         *            -2X + 2* SQRT[ X² - (2X - 1) * (1 - 100/p) ]
         * TBILLEQ = ________________________________________________
         *                            2X - 1
         *
         * with X = DSM / (number of days in a year),
         *  and p is the price, computed with TBILLPRICE
         *
         * Note that from my tests in Excel, we take (number of days in a year) = 366 ONLY if DSM is 366, not if
         * the settlement year is a leap year.
         *
         */
        const nDays = DAYS$1.compute.bind(this)({ value: end }, { value: start });
        if (nDays <= 182) {
            return (365 * disc) / (360 - disc * nDays);
        }
        const p = tBillPrice(start, end, disc) / 100;
        const daysInYear = nDays === 366 ? 366 : 365;
        const x = nDays / daysInYear;
        const num = -2 * x + 2 * Math.sqrt(x ** 2 - (2 * x - 1) * (1 - 1 / p));
        const denom = 2 * x - 1;
        return num / denom;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLYIELD
// -----------------------------------------------------------------------------
const TBILLYIELD = {
    description: _t$1("The yield of a US Treasury bill based on price."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t$1("The price at which the security is bought per 100 face value.")),
    ],
    compute: function (settlement, maturity, price) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const p = toNumber(price, this.locale);
        if (start >= end) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(start, end));
        }
        if (!isSettlementLessThanOneYearBeforeMaturity(start, end, this.locale)) {
            return new EvaluationError(expectSettlementLessThanOneYearBeforeMaturity(start, end));
        }
        if (p <= 0) {
            return new EvaluationError(expectPriceStrictlyPositive(p));
        }
        /**
         * https://support.microsoft.com/en-us/office/tbillyield-function-6d381232-f4b0-4cd5-8e97-45b9c03468ba
         *
         *              100 - price     360
         * TBILLYIELD = ____________ * _____
         *                 price        DSM
         *
         * with DSM = number of days from settlement to maturity
         *
         * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
         *
         */
        const yearFrac = getYearFrac(start, end, 2);
        return ((100 - p) / p) * (1 / yearFrac);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VDB
// -----------------------------------------------------------------------------
const DEFAULT_VDB_NO_SWITCH = false;
const VDB = {
    description: _t$1("Variable declining balance. WARNING : does not handle decimal periods."),
    args: [
        arg("cost (number)", _t$1("The initial cost of the asset.")),
        arg("salvage (number)", _t$1("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t$1("The number of periods over which the asset is depreciated.")),
        arg("start (number)", _t$1("Starting period to calculate depreciation.")),
        arg("end (number)", _t$1("Ending period to calculate depreciation.")),
        arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t$1("The number of months in the first year of depreciation.")),
        arg(`no_switch (number, default=${DEFAULT_VDB_NO_SWITCH})`, _t$1("Whether to switch to straight-line depreciation when the depreciation is greater than the declining balance calculation."), [
            { value: false, label: _t$1("Switch to straight-line depreciation") },
            { value: true, label: _t$1("Do not switch to straight-line depreciation") },
        ]),
    ],
    compute: function (cost, salvage, life, startPeriod, endPeriod, factor = { value: DEFAULT_DDB_DEPRECIATION_FACTOR }, noSwitch = { value: DEFAULT_VDB_NO_SWITCH }) {
        factor = factor || 0;
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        /* TODO : handle decimal periods
         * on end_period it looks like it is a simple linear function, but I cannot understand exactly how
         * decimals periods are handled with start_period.
         */
        const _startPeriod = Math.trunc(toNumber(startPeriod, this.locale));
        const _endPeriod = Math.trunc(toNumber(endPeriod, this.locale));
        const _factor = toNumber(factor, this.locale);
        const _noSwitch = toBoolean(noSwitch);
        if (_cost < 0) {
            return new EvaluationError(expectCostPositiveOrZero(_cost));
        }
        if (_salvage < 0) {
            return new EvaluationError(expectSalvagePositiveOrZero(_salvage));
        }
        if (_life <= 0) {
            return new EvaluationError(expectLifeStrictlyPositive(_life));
        }
        if (_startPeriod < 0) {
            return new EvaluationError(expectStartPeriodPositiveOrZero(_startPeriod));
        }
        if (_endPeriod < 0) {
            return new EvaluationError(expectEndPeriodPositiveOrZero(_endPeriod));
        }
        if (_startPeriod > _endPeriod) {
            return new EvaluationError(expectStartPeriodSmallerOrEqualEndPeriod(_startPeriod, _endPeriod));
        }
        if (_endPeriod > _life) {
            return new EvaluationError(expectEndPeriodSmallerOrEqualToLife(_endPeriod, _life));
        }
        if (_factor <= 0) {
            return new EvaluationError(expectDeprecationFactorStrictlyPositive(_factor));
        }
        if (_cost === 0)
            return 0;
        if (_salvage >= _cost) {
            return _startPeriod < 1 ? _cost - _salvage : 0;
        }
        const doubleDeprecFactor = _factor / _life;
        if (doubleDeprecFactor >= 1) {
            return _startPeriod < 1 ? _cost - _salvage : 0;
        }
        let previousCost = _cost;
        let currentDeprec = 0;
        let resultDeprec = 0;
        let isLinearDeprec = false;
        for (let i = 0; i < _endPeriod; i++) {
            // compute the current deprecation, or keep the last one if we reached a stage of linear deprecation
            if (!isLinearDeprec || _noSwitch) {
                const doubleDeprec = previousCost * doubleDeprecFactor;
                const remainingPeriods = _life - i;
                const linearDeprec = (previousCost - _salvage) / remainingPeriods;
                if (!_noSwitch && linearDeprec > doubleDeprec) {
                    isLinearDeprec = true;
                    currentDeprec = linearDeprec;
                }
                else {
                    currentDeprec = doubleDeprec;
                }
            }
            const nextCost = Math.max(previousCost - currentDeprec, _salvage);
            if (i >= _startPeriod) {
                resultDeprec += previousCost - nextCost;
            }
            previousCost = nextCost;
        }
        return resultDeprec;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XIRR
// -----------------------------------------------------------------------------
const XIRR = {
    description: _t$1("Internal rate of return given non-periodic cash flows."),
    args: [
        arg("cashflow_amounts (range<number>)", _t$1("An range containing the income or payments associated with the investment.")),
        arg("cashflow_dates (range<number>)", _t$1("An range with dates corresponding to the cash flows in cashflow_amounts.")),
        arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t$1("An estimate for what the internal rate of return will be.")),
    ],
    compute: function (cashflowAmounts, cashflowDates, rateGuess = { value: RATE_GUESS_DEFAULT }) {
        const guess = toNumber(rateGuess, this.locale);
        if (!areSameDimensions(cashflowAmounts, cashflowDates)) {
            return new EvaluationError(expectCashFlowsAndDatesHaveSameDimension);
        }
        const _cashFlows = cashflowAmounts.flat().map((val) => toNumber(val, this.locale));
        const _dates = cashflowDates.flat().map((val) => toNumber(val, this.locale));
        if (!havePositiveAndNegativeValues(_cashFlows)) {
            return new EvaluationError(expectCashFlowsHavePositiveAndNegativesValues);
        }
        if (_dates.some((date) => date < _dates[0])) {
            return new EvaluationError(expectEveryDateGreaterThanFirstDateOfCashFlowDates(_dates[0]));
        }
        if (guess <= -1) {
            return new EvaluationError(expectRateGuessStrictlyGreaterThanMinusOne(guess));
        }
        const map = new Map();
        for (const i of range$1(0, _dates.length)) {
            const date = _dates[i];
            if (map.has(date))
                map.set(date, map.get(date) + _cashFlows[i]);
            else
                map.set(date, _cashFlows[i]);
        }
        const dates = Array.from(map.keys());
        const values = dates.map((date) => map.get(date));
        /**
         * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
         *
         * The rate is computed iteratively by trying to solve the equation
         *
         *
         * 0 =    SUM     [ P_i * (1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
         *     i = 1 => n
         *
         * with P_i = price number i
         *      d_i = date number i
         *
         * This function is not defined for rate < -1. For the case where we get rates < -1 in the Newton method, add
         * a fallback for a number very close to -1 to continue the Newton method.
         *
         */
        const func = (rate) => {
            let value = values[0];
            for (const i of range$1(1, values.length)) {
                const dateDiff = (dates[0] - dates[i]) / 365;
                value += values[i] * (1 + rate) ** dateDiff;
            }
            return value;
        };
        const derivFunc = (rate) => {
            let deriv = 0;
            for (const i of range$1(1, values.length)) {
                const dateDiff = (dates[0] - dates[i]) / 365;
                deriv += dateDiff * values[i] * (1 + rate) ** (dateDiff - 1);
            }
            return deriv;
        };
        const nanFallback = (previousFallback) => {
            // -0.9 => -0.99 => -0.999 => ...
            if (!previousFallback)
                return -0.9;
            return previousFallback / 10 - 0.9;
        };
        return newtonMethod(func, derivFunc, guess, 40, 1e-5, nanFallback);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XNPV
// -----------------------------------------------------------------------------
const XNPV = {
    description: _t$1("Net present value given to non-periodic cash flows.."),
    args: [
        arg("discount (number)", _t$1("The discount rate of the investment over one period.")),
        arg("cashflow_amounts (number, range<number>)", _t$1("An range containing the income or payments associated with the investment.")),
        arg("cashflow_dates (number, range<number>)", _t$1("An range with dates corresponding to the cash flows in cashflow_amounts.")),
    ],
    compute: function (discount, cashflowAmounts, cashflowDates) {
        const rate = toNumber(discount, this.locale);
        if (!areSameDimensions(cashflowAmounts, cashflowDates)) {
            return new EvaluationError(expectCashFlowsAndDatesHaveSameDimension);
        }
        const _cashFlows = toMatrix(cashflowAmounts)
            .flat()
            .map((val) => strictToNumber(val, this.locale));
        const _dates = toMatrix(cashflowDates)
            .flat()
            .map((val) => strictToNumber(val, this.locale));
        if (_dates.some((date) => date < _dates[0])) {
            return new EvaluationError(expectEveryDateGreaterThanFirstDateOfCashFlowDates(_dates[0]));
        }
        if (rate <= 0) {
            return new EvaluationError(expectRateStrictlyPositive(rate));
        }
        if (_cashFlows.length === 1)
            return _cashFlows[0];
        // aggregate values of the same date
        const map = new Map();
        for (const i of range$1(0, _dates.length)) {
            const date = _dates[i];
            if (map.has(date))
                map.set(date, map.get(date) + _cashFlows[i]);
            else
                map.set(date, _cashFlows[i]);
        }
        const dates = Array.from(map.keys());
        const values = dates.map((date) => map.get(date));
        /**
         * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
         *
         * The present value is computed using
         *
         *
         * NPV =    SUM     [ P_i *(1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
         *       i = 1 => n
         *
         * with P_i = price number i
         *      d_i = date number i
         *
         *
         */
        let pv = values[0];
        for (const i of range$1(1, values.length)) {
            const dateDiff = (dates[0] - dates[i]) / 365;
            pv += values[i] * (1 + rate) ** dateDiff;
        }
        return pv;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELD
// -----------------------------------------------------------------------------
const YIELD = {
    description: _t$1("Annual yield of a security paying periodic interest."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("price (number)", _t$1("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg("frequency (number)", _t$1("The number of interest or coupon payments per year (1, 2, or 4)."), FREQUENCY_OPTIONS),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, rate, price, redemption, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidFrequency(_frequency)) {
            return new EvaluationError(expectCouponFrequencyIsValid(_frequency));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_rate < 0) {
            return new EvaluationError(expectRatePositiveOrZero(_rate));
        }
        if (_price <= 0) {
            return new EvaluationError(expectPriceStrictlyPositive(_price));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        const years = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const nbrRealCoupons = years * _frequency;
        const nbrFullCoupons = Math.ceil(nbrRealCoupons);
        const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
        const cashFlowFromCoupon = (100 * _rate) / _frequency;
        if (nbrFullCoupons === 1) {
            const subPart = _price + cashFlowFromCoupon * (1 - timeFirstCoupon);
            return (((_redemption + cashFlowFromCoupon - subPart) * _frequency * (1 / timeFirstCoupon)) /
                subPart);
        }
        // The result of YIELD function is the yield at which the PRICE function will return the given price.
        // This algorithm uses the Newton's method on the PRICE function to determine the result.
        // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
        // As the PRICE function isn't continuous, we apply the Newton's method on the numerator of the PRICE formula.
        // For simplicity, it is not yield but yieldFactorPerPeriod (= 1 + yield / frequency) which will be calibrated in Newton's method.
        // yield can be deduced from yieldFactorPerPeriod in sequence.
        function priceNumerator(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon, redemption) {
            let result = redemption -
                (price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                    yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
            for (let i = 1; i <= nbrFullCoupons; i++) {
                result += cashFlowFromCoupon * yieldFactorPerPeriod ** (i - 1);
            }
            return result;
        }
        function priceNumeratorDeriv(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon) {
            let result = -(price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                (nbrFullCoupons - 1 + timeFirstCoupon) *
                yieldFactorPerPeriod ** (nbrFullCoupons - 2 + timeFirstCoupon);
            for (let i = 1; i <= nbrFullCoupons; i++) {
                result += cashFlowFromCoupon * (i - 1) * yieldFactorPerPeriod ** (i - 2);
            }
            return result;
        }
        function func(x) {
            return priceNumerator(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon, _redemption);
        }
        function derivFunc(x) {
            return priceNumeratorDeriv(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon);
        }
        const initYield = _rate + 1;
        const initYieldFactorPerPeriod = 1 + initYield / _frequency;
        const methodResult = newtonMethod(func, derivFunc, initYieldFactorPerPeriod, 100, 1e-5);
        return (methodResult - 1) * _frequency;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELDDISC
// -----------------------------------------------------------------------------
const YIELDDISC = {
    description: _t$1("Annual yield of a discount security."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t$1("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t$1("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, price, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_price <= 0) {
            return new EvaluationError(expectPriceStrictlyPositive(_price));
        }
        if (_redemption <= 0) {
            return new EvaluationError(expectRedemptionStrictlyPositive(_redemption));
        }
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/YIELDDISC
         *
         *                    (redemption / price) - 1
         * YIELDDISC = _____________________________________
         *             YEARFRAC(settlement, maturity, basis)
         */
        const yearFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption / _price - 1) / yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELDMAT
// -----------------------------------------------------------------------------
const YIELDMAT = {
    description: _t$1("Annual yield of a security paying interest at maturity."),
    args: [
        arg("settlement (date)", _t$1("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t$1("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("issue (date)", _t$1("The date the security was initially issued.")),
        arg("rate (number)", _t$1("The annualized rate of interest.")),
        arg("price (number)", _t$1("The price at which the security is bought.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t$1("An indicator of what day count method to use."), DAY_COUNT_CONVENTION_OPTIONS),
    ],
    compute: function (settlement, maturity, issue, rate, price, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _issue = Math.trunc(toNumber(issue, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _price = toNumber(price, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        if (_settlement >= _maturity) {
            return new EvaluationError(expectMaturityStrictlyGreaterThanSettlement(_settlement, _maturity));
        }
        if (isInvalidDayCountConvention(_dayCountConvention)) {
            return new EvaluationError(expectDayCountConventionIsValid(_dayCountConvention));
        }
        if (_settlement < _issue) {
            return new EvaluationError(expectSettlementGreaterOrEqualToIssue(_settlement, _issue));
        }
        if (_rate < 0) {
            return new EvaluationError(expectRatePositiveOrZero(_rate));
        }
        if (_price <= 0) {
            return new EvaluationError(expectPriceStrictlyPositive(_price));
        }
        const issueToMaturity = getYearFrac(_issue, _maturity, _dayCountConvention);
        const issueToSettlement = getYearFrac(_issue, _settlement, _dayCountConvention);
        const settlementToMaturity = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const numerator = (100 * (1 + _rate * issueToMaturity)) / (_price + 100 * _rate * issueToSettlement) - 1;
        return numerator / settlementToMaturity;
    },
    isExported: true,
};

var financial = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ACCRINTM: ACCRINTM,
    AMORLINC: AMORLINC,
    COUPDAYBS: COUPDAYBS,
    COUPDAYS: COUPDAYS,
    COUPDAYSNC: COUPDAYSNC,
    COUPNCD: COUPNCD,
    COUPNUM: COUPNUM,
    COUPPCD: COUPPCD,
    CUMIPMT: CUMIPMT,
    CUMPRINC: CUMPRINC,
    DB: DB,
    DDB: DDB,
    DISC: DISC,
    DOLLARDE: DOLLARDE,
    DOLLARFR: DOLLARFR,
    DURATION: DURATION,
    EFFECT: EFFECT,
    FV: FV,
    FVSCHEDULE: FVSCHEDULE,
    INTRATE: INTRATE,
    IPMT: IPMT,
    IRR: IRR,
    ISPMT: ISPMT,
    MDURATION: MDURATION,
    MIRR: MIRR,
    NOMINAL: NOMINAL,
    NPER: NPER,
    NPV: NPV,
    PDURATION: PDURATION,
    PMT: PMT,
    PPMT: PPMT,
    PRICE: PRICE,
    PRICEDISC: PRICEDISC,
    PRICEMAT: PRICEMAT,
    PV: PV,
    RATE: RATE,
    RECEIVED: RECEIVED,
    RRI: RRI,
    SLN: SLN,
    SYD: SYD,
    TBILLEQ: TBILLEQ,
    TBILLPRICE: TBILLPRICE,
    TBILLYIELD: TBILLYIELD,
    VDB: VDB,
    XIRR: XIRR,
    XNPV: XNPV,
    YIELD: YIELD,
    YIELDDISC: YIELDDISC,
    YIELDMAT: YIELDMAT
});

// -----------------------------------------------------------------------------
// CELL
// -----------------------------------------------------------------------------
// NOTE: missing from Excel: "color", "filename", "parentheses", "prefix", "protect" and "width"
const CELL_INFO_TYPES = [
    {
        value: "address",
        label: _t$1("Returns an absolute reference as plain text of the top left cell in reference."),
    },
    { value: "col", label: _t$1("Returns the column number of the cell in reference.") },
    {
        value: "contents",
        label: _t$1("Returns the value contained in the top left cell in reference."),
    },
    { value: "format", label: _t$1("Returns the format of the top left cell in reference.") },
    { value: "row", label: _t$1("Returns the row number of the top left cell in reference.") },
    {
        value: "type",
        label: _t$1('Returns the type of data in the cell in reference. The following values are returned: "b" for a blank cell, "l" (for label) if the cell contains plain text, and "v" (for value) if the cell contains any other type of data.'),
    },
];
const CELL = {
    description: _t$1("Gets information about a cell."),
    args: [
        arg("info_type (string)", _t$1("The type of information requested."), CELL_INFO_TYPES),
        arg("reference (meta, range<meta>)", _t$1("The reference to the cell.")),
    ],
    compute: function (info, reference) {
        const _info = toString(info).toLowerCase();
        if (!CELL_INFO_TYPES.map((type) => type.value).includes(_info)) {
            return new EvaluationError(_t$1("The info_type should be one of %s.", CELL_INFO_TYPES.join(", ")));
        }
        const sheetId = this.__originSheetId;
        const _reference = reference[0][0].value;
        let { sheetName, xc } = splitReference(_reference);
        // only put the sheet name if the referenced range is in another sheet than the cell the formula is on
        sheetName = sheetName === this.getters.getSheetName(sheetId) ? undefined : sheetName;
        const fixedRef = getFullReference(sheetName, setXcToFixedReferenceType(xc, "colrow"));
        const range = this.getters.getRangeFromSheetXC(sheetId, fixedRef);
        switch (_info) {
            case "address":
                return this.getters.getRangeString(range, sheetId);
            case "col":
                return range.zone.left + 1;
            case "contents": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                return this.getters.getEvaluatedCell(position).value;
            }
            case "format": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                return this.getters.getEvaluatedCell(position).format || "";
            }
            case "row":
                return range.zone.top + 1;
            case "type": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                const type = this.getters.getEvaluatedCell(position).type;
                if (type === CellValueType.empty) {
                    return "b"; // blank
                }
                else if (type === CellValueType.text) {
                    return "l"; // label
                }
                else {
                    return "v"; // value
                }
            }
        }
        return "";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISERR
// -----------------------------------------------------------------------------
const ISERR = {
    description: _t$1("Whether a value is an error other than #N/A."),
    args: [arg("value (any)", _t$1("The value to be verified as an error type."))],
    compute: function (data) {
        const value = data?.value;
        return isEvaluationError(value) && value !== CellErrorType$1.NotAvailable;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISERROR
// -----------------------------------------------------------------------------
const ISERROR = {
    description: _t$1("Whether a value is an error."),
    args: [arg("value (any)", _t$1("The value to be verified as an error type."))],
    compute: function (data) {
        const value = data?.value;
        return isEvaluationError(value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISLOGICAL
// -----------------------------------------------------------------------------
const ISLOGICAL = {
    description: _t$1("Whether a value is `true` or `false`."),
    args: [arg("value (any)", _t$1("The value to be verified as a logical TRUE or FALSE."))],
    compute: function (value) {
        return typeof value?.value === "boolean";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNA
// -----------------------------------------------------------------------------
const ISNA = {
    description: _t$1("Whether a value is the error #N/A."),
    args: [arg("value (any)", _t$1("The value to be verified as an error type."))],
    compute: function (data) {
        return data?.value === CellErrorType$1.NotAvailable;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNONTEXT
// -----------------------------------------------------------------------------
const ISNONTEXT = {
    description: _t$1("Whether a value is non-textual."),
    args: [arg("value (any)", _t$1("The value to be checked."))],
    compute: function (value) {
        return !ISTEXT.compute.bind(this)(value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNUMBER
// -----------------------------------------------------------------------------
const ISNUMBER = {
    description: _t$1("Whether a value is a number."),
    args: [arg("value (any)", _t$1("The value to be verified as a number."))],
    compute: function (value) {
        return typeof value?.value === "number";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISTEXT
// -----------------------------------------------------------------------------
const ISTEXT = {
    description: _t$1("Whether a value is text."),
    args: [arg("value (any)", _t$1("The value to be verified as text."))],
    compute: function (value) {
        return typeof value?.value === "string" && isEvaluationError(value?.value) === false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISBLANK
// -----------------------------------------------------------------------------
const ISBLANK = {
    description: _t$1("Whether the referenced cell is empty"),
    args: [arg("value (any)", _t$1("Reference to the cell that will be checked for emptiness."))],
    compute: function (value) {
        return value?.value === null;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NA
// -----------------------------------------------------------------------------
const NA = {
    description: _t$1("Returns the error value #N/A."),
    args: [],
    compute: function () {
        return { value: CellErrorType$1.NotAvailable };
    },
    isExported: true,
};

var info = /*#__PURE__*/Object.freeze({
    __proto__: null,
    CELL: CELL,
    ISBLANK: ISBLANK,
    ISERR: ISERR,
    ISERROR: ISERROR,
    ISLOGICAL: ISLOGICAL,
    ISNA: ISNA,
    ISNONTEXT: ISNONTEXT,
    ISNUMBER: ISNUMBER,
    ISTEXT: ISTEXT,
    NA: NA
});

function boolAnd(args) {
    let foundBoolean = false;
    let acc = true;
    conditionalVisitBoolean(args, (arg) => {
        foundBoolean = true;
        acc = acc && arg;
        return acc;
    });
    return {
        foundBoolean,
        result: acc,
    };
}
function boolOr(args) {
    let foundBoolean = false;
    let acc = false;
    conditionalVisitBoolean(args, (arg) => {
        foundBoolean = true;
        acc = acc || arg;
        return !acc;
    });
    return {
        foundBoolean,
        result: acc,
    };
}

// -----------------------------------------------------------------------------
// AND
// -----------------------------------------------------------------------------
const AND = {
    description: _t$1("Logical `and` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t$1("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t$1("More expressions that represent logical values.")),
    ],
    compute: function (...logicalExpressions) {
        const { result, foundBoolean } = boolAnd(logicalExpressions);
        if (!foundBoolean) {
            return new EvaluationError(noValidInputErrorMessage);
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FALSE
// -----------------------------------------------------------------------------
const FALSE = {
    description: _t$1("Logical value `false`."),
    args: [],
    compute: function () {
        return false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IF
// -----------------------------------------------------------------------------
const IF = {
    description: _t$1("Returns value depending on logical expression."),
    args: [
        arg("logical_expression (boolean, range<boolean>)", _t$1("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE.")),
        arg("value_if_true (any, range)", _t$1("The value the function returns if logical_expression is TRUE.")),
        arg("value_if_false (any, range, default=FALSE)", _t$1("The value the function returns if logical_expression is FALSE.")),
    ],
    compute: function (logicalExpression, valueIfTrue, valueIfFalse) {
        if (isMultipleElementMatrix(logicalExpression)) {
            return applyVectorization(IF.compute, [logicalExpression, valueIfTrue, valueIfFalse]);
        }
        const result = toBoolean(toScalar(logicalExpression)) ? valueIfTrue : valueIfFalse;
        return result ?? { value: 0 };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFERROR
// -----------------------------------------------------------------------------
const IFERROR = {
    description: _t$1("Value if it is not an error, otherwise 2nd argument."),
    args: [
        arg("value (any, range)", _t$1("The value to return if value itself is not an error.")),
        arg(`value_if_error (any, range, default="empty")`, _t$1("The value the function returns if value is an error.")),
    ],
    compute: function (value, valueIfError) {
        if (isMultipleElementMatrix(value)) {
            return applyVectorization(IFERROR.compute, [value, valueIfError]);
        }
        const result = isEvaluationError(toScalar(value)?.value) ? valueIfError : value;
        return result ?? { value: 0 };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFNA
// -----------------------------------------------------------------------------
const IFNA = {
    description: _t$1("Value if it is not an #N/A error, otherwise 2nd argument."),
    args: [
        arg("value (any, range)", _t$1("The value to return if value itself is not #N/A an error.")),
        arg(`value_if_error (any, range, default="empty")`, _t$1("The value the function returns if value is an #N/A error.")),
    ],
    compute: function (value, valueIfError) {
        if (isMultipleElementMatrix(value)) {
            return applyVectorization(IFNA.compute, [value, valueIfError]);
        }
        const result = toScalar(value)?.value === CellErrorType$1.NotAvailable ? valueIfError : value;
        return result ?? { value: 0 };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFS
// -----------------------------------------------------------------------------
const IFS = {
    description: _t$1("Returns a value depending on multiple logical expressions."),
    args: [
        arg("condition1 (boolean, range<boolean>)", _t$1("The first condition to be evaluated. This can be a boolean, a number, an array, or a reference to any of those.")),
        arg("value1 (any, range)", _t$1("The returned value if condition1 is TRUE.")),
        arg("condition2 (boolean, any, range, repeating)", _t$1("Additional conditions to be evaluated if the previous ones are FALSE.")),
        arg("value2 (any, range, repeating)", _t$1("Additional values to be returned if their corresponding conditions are TRUE.")),
    ],
    compute: function (...values) {
        if (values.length % 2 !== 0) {
            return new EvaluationError(_t$1("Wrong number of arguments. Expected an even number of arguments."));
        }
        while (values.length > 0) {
            if (isMultipleElementMatrix(values[0])) {
                return applyVectorization(IFS.compute, values);
            }
            const condition = toBoolean(toScalar(values.shift()));
            const valueIfTrue = values.shift();
            if (condition) {
                return valueIfTrue ?? { value: 0 };
            }
        }
        return new EvaluationError(_t$1("No match."));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOT
// -----------------------------------------------------------------------------
const NOT = {
    description: _t$1("Returns opposite of provided logical value."),
    args: [
        arg("logical_expression (boolean)", _t$1("An expression or reference to a cell holding an expression that represents some logical value.")),
    ],
    compute: function (logicalExpression) {
        return !toBoolean(logicalExpression);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// OR
// -----------------------------------------------------------------------------
const OR = {
    description: _t$1("Logical `or` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t$1("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t$1("More expressions that evaluate to logical values.")),
    ],
    compute: function (...logicalExpressions) {
        const { result, foundBoolean } = boolOr(logicalExpressions);
        if (!foundBoolean) {
            return new EvaluationError(noValidInputErrorMessage);
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SWITCH
// -----------------------------------------------------------------------------
const SWITCH = {
    description: _t$1("Returns a value by comparing cases to an expression."),
    args: [
        arg("expression (number, boolean, string)", _t$1("The value to be checked.")),
        arg("case1 (number, boolean, string)", _t$1("The first case to be checked against expression.")),
        arg("value1 (any)", _t$1("The corresponding value to be returned if case1 matches expression.")),
        arg("case2 (any, repeating)", _t$1("Additional cases to try if the previous ones don't match expression.")),
        arg("value2 (any, repeating)", _t$1("Additional values to be returned if their corresponding cases match expression.")),
        arg(`default (any, default="empty")`, _t$1("An optional default value to be returned if none of the cases match expression.")),
    ],
    compute: function (expression, ...casesAndValues) {
        const defaultValue = casesAndValues.length % 2 === 0 ? valueNotAvailable(expression) : casesAndValues.pop();
        for (let i = 0; i < casesAndValues.length; i += 2) {
            const iCase = casesAndValues[i];
            if (iCase && isEvaluationError(iCase.value)) {
                return iCase;
            }
            if (expression?.value === iCase?.value) {
                return casesAndValues[i + 1] || { value: 0 };
            }
        }
        return defaultValue || { value: 0 };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRUE
// -----------------------------------------------------------------------------
const TRUE = {
    description: _t$1("Logical value `true`."),
    args: [],
    compute: function () {
        return true;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XOR
// -----------------------------------------------------------------------------
const XOR = {
    description: _t$1("Logical `xor` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t$1("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t$1("More expressions that evaluate to logical values.")),
    ],
    compute: function (...logicalExpressions) {
        let foundBoolean = false;
        let acc = false;
        conditionalVisitBoolean(logicalExpressions, (arg) => {
            foundBoolean = true;
            acc = acc ? !arg : arg;
            return true; // no stop condition
        });
        if (!foundBoolean) {
            return new EvaluationError(noValidInputErrorMessage);
        }
        return acc;
    },
    isExported: true,
};

var logical = /*#__PURE__*/Object.freeze({
    __proto__: null,
    AND: AND,
    FALSE: FALSE,
    IF: IF,
    IFERROR: IFERROR,
    IFNA: IFNA,
    IFS: IFS,
    NOT: NOT,
    OR: OR,
    SWITCH: SWITCH,
    TRUE: TRUE,
    XOR: XOR
});

const CfTerms = {
    Errors: {
        ["InvalidRange" /* CommandResult.InvalidRange */]: _t$1("The range is invalid"),
        ["FirstArgMissing" /* CommandResult.FirstArgMissing */]: _t$1("The argument is missing. Please provide a value"),
        ["SecondArgMissing" /* CommandResult.SecondArgMissing */]: _t$1("The second argument is missing. Please provide a value"),
        ["MinNaN" /* CommandResult.MinNaN */]: _t$1("The minpoint must be a number"),
        ["MidNaN" /* CommandResult.MidNaN */]: _t$1("The midpoint must be a number"),
        ["MaxNaN" /* CommandResult.MaxNaN */]: _t$1("The maxpoint must be a number"),
        ["ValueUpperInflectionNaN" /* CommandResult.ValueUpperInflectionNaN */]: _t$1("The first value must be a number"),
        ["ValueLowerInflectionNaN" /* CommandResult.ValueLowerInflectionNaN */]: _t$1("The second value must be a number"),
        ["MinBiggerThanMax" /* CommandResult.MinBiggerThanMax */]: _t$1("Minimum must be smaller then Maximum"),
        ["MinBiggerThanMid" /* CommandResult.MinBiggerThanMid */]: _t$1("Minimum must be smaller then Midpoint"),
        ["MidBiggerThanMax" /* CommandResult.MidBiggerThanMax */]: _t$1("Midpoint must be smaller then Maximum"),
        ["LowerBiggerThanUpper" /* CommandResult.LowerBiggerThanUpper */]: _t$1("Lower inflection point must be smaller than upper inflection point"),
        ["MinInvalidFormula" /* CommandResult.MinInvalidFormula */]: _t$1("Invalid Minpoint formula"),
        ["MaxInvalidFormula" /* CommandResult.MaxInvalidFormula */]: _t$1("Invalid Maxpoint formula"),
        ["MidInvalidFormula" /* CommandResult.MidInvalidFormula */]: _t$1("Invalid Midpoint formula"),
        ["ValueUpperInvalidFormula" /* CommandResult.ValueUpperInvalidFormula */]: _t$1("Invalid upper inflection point formula"),
        ["ValueLowerInvalidFormula" /* CommandResult.ValueLowerInvalidFormula */]: _t$1("Invalid lower inflection point formula"),
        ["EmptyRange" /* CommandResult.EmptyRange */]: _t$1("A range needs to be defined"),
        ["ValueCellIsInvalidFormula" /* CommandResult.ValueCellIsInvalidFormula */]: _t$1("At least one of the provided values is an invalid formula"),
        Unexpected: _t$1("The rule is invalid for an unknown reason"),
    },
    ColorScale: _t$1("Color scale"),
    IconSet: _t$1("Icon set"),
    DataBar: _t$1("Data bar"),
};
const ChartTerms = {
    Series: _t$1("Series"),
    BackgroundColor: _t$1("Background color"),
    StackedBarChart: _t$1("Stacked bar chart"),
    StackedLineChart: _t$1("Stacked line chart"),
    StackedAreaChart: _t$1("Stacked area chart"),
    StackedColumnChart: _t$1("Stacked column chart"),
    CumulativeData: _t$1("Cumulative data"),
    TreatLabelsAsText: _t$1("Treat labels as text"),
    AggregatedChart: _t$1("Aggregate"),
    Errors: {
        Unexpected: _t$1("The chart definition is invalid for an unknown reason"),
        // BASIC CHART ERRORS (LINE | BAR | PIE)
        ["InvalidDataSet" /* CommandResult.InvalidDataSet */]: _t$1("The dataset is invalid"),
        ["InvalidLabelRange" /* CommandResult.InvalidLabelRange */]: _t$1("Labels are invalid"),
        // SCORECARD CHART ERRORS
        ["InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */]: _t$1("The key value is invalid"),
        ["InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */]: _t$1("The baseline value is invalid"),
        // GAUGE CHART ERRORS
        ["InvalidGaugeDataRange" /* CommandResult.InvalidGaugeDataRange */]: _t$1("The data range is invalid"),
        ["EmptyGaugeRangeMin" /* CommandResult.EmptyGaugeRangeMin */]: _t$1("A minimum range limit value is needed"),
        ["GaugeRangeMinNaN" /* CommandResult.GaugeRangeMinNaN */]: _t$1("The minimum range limit value must be a number"),
        ["EmptyGaugeRangeMax" /* CommandResult.EmptyGaugeRangeMax */]: _t$1("A maximum range limit value is needed"),
        ["GaugeRangeMaxNaN" /* CommandResult.GaugeRangeMaxNaN */]: _t$1("The maximum range limit value must be a number"),
        ["GaugeLowerInflectionPointNaN" /* CommandResult.GaugeLowerInflectionPointNaN */]: _t$1("The lower inflection point value must be a number"),
        ["GaugeUpperInflectionPointNaN" /* CommandResult.GaugeUpperInflectionPointNaN */]: _t$1("The upper inflection point value must be a number"),
    },
    GeoChart: {
        ColorScales: {
            blues: _t$1("Blues"),
            cividis: _t$1("Cividis"),
            greens: _t$1("Greens"),
            greys: _t$1("Greys"),
            oranges: _t$1("Oranges"),
            purples: _t$1("Purples"),
            rainbow: _t$1("Rainbow"),
            reds: _t$1("Reds"),
            viridis: _t$1("Viridis"),
        },
    },
};
const CustomCurrencyTerms = {
    Custom: _t$1("Custom"),
};
const MergeErrorMessage = _t$1("Merged cells are preventing this operation. Unmerge those cells and try again.");
const TableHeaderMoveErrorMessage = _t$1("The header row of a table can't be moved.");
const SplitToColumnsTerms = {
    Errors: {
        Unexpected: _t$1("Cannot split the selection for an unknown reason"),
        ["NoSplitSeparatorInSelection" /* CommandResult.NoSplitSeparatorInSelection */]: _t$1("There is no match for the selected separator in the selection"),
        ["MoreThanOneColumnSelected" /* CommandResult.MoreThanOneColumnSelected */]: _t$1("Only a selection from a single column can be split"),
        ["SplitWillOverwriteContent" /* CommandResult.SplitWillOverwriteContent */]: _t$1("Splitting will overwrite existing content"),
    },
};
const RemoveDuplicateTerms = {
    Errors: {
        Unexpected: _t$1("Cannot remove duplicates for an unknown reason"),
        ["MoreThanOneRangeSelected" /* CommandResult.MoreThanOneRangeSelected */]: _t$1("Please select only one range of cells"),
        ["EmptyTarget" /* CommandResult.EmptyTarget */]: _t$1("Please select a range of cells containing values."),
        ["NoColumnsProvided" /* CommandResult.NoColumnsProvided */]: _t$1("Please select at latest one column to analyze."),
        //TODO: Remove it when accept to copy and paste merge cells
        ["WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */]: _t$1("This operation is not possible due to a merge. Please remove the merges first than try again."),
    },
};
const DVTerms = {
    DateIs: {
        today: _t$1("today"),
        yesterday: _t$1("yesterday"),
        tomorrow: _t$1("tomorrow"),
        lastWeek: _t$1("in the past week"),
        lastMonth: _t$1("in the past month"),
        lastYear: _t$1("in the past year"),
    },
    DateIsBefore: {
        today: _t$1("today"),
        yesterday: _t$1("yesterday"),
        tomorrow: _t$1("tomorrow"),
        lastWeek: _t$1("one week ago"),
        lastMonth: _t$1("one month ago"),
        lastYear: _t$1("one year ago"),
    },
    CriterionError: {
        notEmptyValue: _t$1("The value must not be empty"),
        numberValue: _t$1("The value must be a number"),
        dateValue: _t$1("The value must be a date"),
        validRange: _t$1("The value must be a valid range"),
        validFormula: _t$1("The formula must be valid"),
    },
    Errors: {
        ["InvalidRange" /* CommandResult.InvalidRange */]: _t$1("The range is invalid."),
        ["InvalidDataValidationCriterionValue" /* CommandResult.InvalidDataValidationCriterionValue */]: _t$1("One or more of the provided criteria values are invalid. Please review and correct them."),
        ["InvalidNumberOfCriterionValues" /* CommandResult.InvalidNumberOfCriterionValues */]: _t$1("One or more of the provided criteria values are missing."),
        Unexpected: _t$1("The rule is invalid for an unknown reason."),
    },
};
const TableTerms = {
    Errors: {
        Unexpected: _t$1("The table zone is invalid for an unknown reason"),
        ["TableOverlap" /* CommandResult.TableOverlap */]: _t$1("You cannot create overlapping tables."),
        ["NonContinuousTargets" /* CommandResult.NonContinuousTargets */]: _t$1("A table can only be created on a continuous selection."),
        ["InvalidRange" /* CommandResult.InvalidRange */]: _t$1("The range is invalid"),
        ["TargetOutOfSheet" /* CommandResult.TargetOutOfSheet */]: _t$1("The range is out of the sheet"),
    },
    Checkboxes: {
        hasFilters: _t$1("Filter button"),
        headerRow: _t$1("Header row(s)"),
        bandedRows: _t$1("Banded rows"),
        firstColumn: _t$1("First column"),
        lastColumn: _t$1("Last column"),
        bandedColumns: _t$1("Banded columns"),
        automaticAutofill: _t$1("Automatically autofill formulas"),
        totalRow: _t$1("Total row"),
        isDynamic: _t$1("Auto-adjust to formula result"),
    },
    Tooltips: {
        filterWithoutHeader: _t$1("Cannot have filters without a header row"),
        isDynamic: _t$1("For tables based on array formulas only"),
    },
};
const measureDisplayTerms = {
    labels: {
        no_calculations: _t$1("No calculations"),
        "%_of_grand_total": _t$1("% of grand total"),
        "%_of_col_total": _t$1("% of column total"),
        "%_of_row_total": _t$1("% of row total"),
        "%_of": _t$1("% of"),
        "%_of_parent_row_total": _t$1("% of parent row total"),
        "%_of_parent_col_total": _t$1("% of parent column total"),
        "%_of_parent_total": _t$1("% of parent total"),
        difference_from: _t$1("Difference from"),
        "%_difference_from": _t$1("% difference from"),
        running_total: _t$1("Running total"),
        "%_running_total": _t$1("% Running total"),
        rank_asc: _t$1("Rank smallest to largest"),
        rank_desc: _t$1("Rank largest to smallest"),
        index: _t$1("Index"),
    },
    descriptions: {
        "%_of_grand_total": () => _t$1("Displayed as % of grand total"),
        "%_of_col_total": () => _t$1("Displayed as % of column total"),
        "%_of_row_total": () => _t$1("Displayed as % of row total"),
        "%_of": (field) => _t$1('Displayed as % of "%s"', field),
        "%_of_parent_row_total": (field) => _t$1('Displayed as % of parent row total of "%s"', field),
        "%_of_parent_col_total": () => _t$1("Displayed as % of parent column total"),
        "%_of_parent_total": (field) => _t$1('Displayed as % of parent "%s" total', field),
        difference_from: (field) => _t$1('Displayed as difference from "%s"', field),
        "%_difference_from": (field) => _t$1('Displayed as % difference from "%s"', field),
        running_total: (field) => _t$1('Displayed as running total based on "%s"', field),
        "%_running_total": (field) => _t$1('Displayed as % running total based on "%s"', field),
        rank_asc: (field) => _t$1('Displayed as rank from smallest to largest based on "%s"', field),
        rank_desc: (field) => _t$1('Displayed as rank largest to smallest based on "%s"', field),
        index: () => _t$1("Displayed as index"),
    },
    documentation: {
        no_calculations: _t$1("Displays the value that is entered in the field."),
        "%_of_grand_total": _t$1("Displays values as a percentage of the grand total of all the values or data points in the report."),
        "%_of_col_total": _t$1("Displays all the values in each column or series as a percentage of the total for the column or series."),
        "%_of_row_total": _t$1("Displays the value in each row or category as a percentage of the total for the row or category."),
        "%_of": _t$1("Displays values as a percentage of the value of the Base item in the Base field."),
        "%_of_parent_row_total": _t$1("Calculates values as follows:\n(value for the item) / (value for the parent item on rows)"),
        "%_of_parent_col_total": _t$1("Calculates values as follows:\n(value for the item) / (value for the parent item on columns)"),
        "%_of_parent_total": _t$1("Calculates values as follows:\n(value for the item) / (value for the parent item of the selected Base field)"),
        difference_from: _t$1("Displays values as the difference from the value of the Base item in the Base field."),
        "%_difference_from": _t$1("Displays values as the percentage difference from the value of the Base item in the Base field."),
        running_total: _t$1("Displays the value for successive items in the Base field as a running total."),
        "%_running_total": _t$1("Calculates the value as a percentage for successive items in the Base field that are displayed as a running total."),
        rank_asc: _t$1("Displays the rank of selected values in a specific field, listing the smallest item in the field as 1, and each larger value with a higher rank value."),
        rank_desc: _t$1("Displays the rank of selected values in a specific field, listing the largest item in the field as 1, and each smaller value with a higher rank value."),
        index: _t$1("Calculates values as follows:\n((value in cell) x (Grand Total of Grand Totals)) / ((Grand Row Total) x (Grand Column Total))"),
    },
};
function getPivotTooBigErrorMessage$1(numberOfCells, locale) {
    const formattedNumber = formatValue$1(numberOfCells, {
        format: "0,00",
        locale: locale,
    });
    return _t$1("Oops—this pivot table is quite large (%s cells). Try simplifying it using the side panel.", formattedNumber);
}

/**
 * Registry
 *
 * The Registry class is basically just a mapping from a string key to an object.
 * It is really not much more than an object. It is however useful for the
 * following reasons:
 *
 * 1. it let us react and execute code when someone add something to the registry
 *   (for example, the FunctionRegistry subclass this for this purpose)
 * 2. it throws an error when the get operation fails
 * 3. it provides a chained API to add items to the registry.
 */
class Registry {
    content = {};
    /**
     * Add an item to the registry, you can only add if there is no item
     * already present in the registery with the given key
     *
     * Note that this also returns the registry, so another add method call can
     * be chained
     */
    add(key, value) {
        if (key in this.content) {
            throw new Error(`${key} is already present in this registry!`);
        }
        return this.replace(key, value);
    }
    /**
     * Replace (or add) an item to the registry
     *
     * Note that this also returns the registry, so another add method call can
     * be chained
     */
    replace(key, value) {
        this.content[key] = value;
        return this;
    }
    /**
     * Get an item from the registry
     */
    get(key) {
        /**
         * Note: key in {} is ~12 times slower than {}[key].
         * So, we check the absence of key only when the direct access returns
         * a falsy value. It's done to ensure that the registry can contains falsy values
         */
        const content = this.content[key];
        if (!content) {
            if (!(key in this.content)) {
                throw new Error(`Cannot find ${key} in this registry!`);
            }
        }
        return content;
    }
    /**
     * Check if the key is already in the registry
     */
    contains(key) {
        return key in this.content;
    }
    /**
     * Get a list of all elements in the registry
     */
    getAll() {
        return Object.values(this.content);
    }
    /**
     * Get a list of all keys in the registry
     */
    getKeys() {
        return Object.keys(this.content);
    }
    /**
     * Remove an item from the registry
     */
    remove(key) {
        delete this.content[key];
    }
}

const pivotTimeAdapterRegistry = new Registry();
function pivotTimeAdapter(granularity) {
    return pivotTimeAdapterRegistry.get(granularity);
}
/**
 * The Time Adapter: Managing Time Periods for Pivot Functions
 *
 * Overview:
 * A time adapter is responsible for managing time periods associated with pivot functions.
 * Each type of period (day, week, month, quarter, etc.) has its own dedicated adapter.
 * The adapter's primary role is to normalize period values between spreadsheet functions,
 * and the pivot.
 * By normalizing the period value, it can be stored consistently in the pivot.
 *
 * Normalization Process:
 * When working with functions in the spreadsheet, the time adapter normalizes
 * the provided period to facilitate accurate lookup of values in the pivot.
 * For instance, if the spreadsheet function represents a day period as a number generated
 * by the DATE function (DATE(2023, 12, 25)), the time adapter will normalize it accordingly.
 *
 */
/**
 * Normalized value: "12/25/2023"
 *
 * Note: Those two format are equivalent:
 * - "MM/dd/yyyy" (luxon format)
 * - "mm/dd/yyyy" (spreadsheet format)
 **/
const dayAdapter = {
    normalizeFunctionValue(value) {
        return toNumber(value, DEFAULT_LOCALE);
    },
    toValueAndFormat(normalizedValue, locale) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "dd mmm yyyy",
        };
    },
    toFunctionValue(normalizedValue) {
        const jsDate = toJsDate(normalizedValue, DEFAULT_LOCALE);
        return `DATE(${jsDate.getFullYear()},${jsDate.getMonth() + 1},${jsDate.getDate()})`;
    },
};
/**
 * normalizes day of month number
 */
const dayOfMonthAdapter = {
    normalizeFunctionValue(value) {
        const day = toNumber(value, DEFAULT_LOCALE);
        if (day < 1 || day > 31) {
            throw new EvaluationError(_t$1("%s is not a valid day of month (it should be a number between 1 and 31)", day));
        }
        return day;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes day of week number
 *
 * The day of week is a bit special as it depends on the locale week start day.
 * =PIVOT.VALUE(1, "xx:day_of_week", 1) will be different depending on the locale
 *  - fr_FR: 1: Monday, 7: Sunday   (weekStart = 1)
 *  - en_US: 1: Sunday, 7: Saturday (weekStart = 7)
 *
 * The function that normalizes the value coming from the function
 * (`normalizeFunctionValue`) will return the day of week (1 based index)
 * depending on the locale week start day.
 * To display the value in the pivot, we need to convert it to retrieve the
 * correct day of week name (1 should be "Monday" in fr_FR and "Sunday" in en_US).
 */
const dayOfWeekAdapter = {
    normalizeFunctionValue(value) {
        const day = toNumber(value, DEFAULT_LOCALE);
        if (day < 1 || day > 7) {
            throw new EvaluationError(_t$1("%s is not a valid day of week (it should be a number between 1 and 7)", day));
        }
        return day;
    },
    toValueAndFormat(normalizedValue, locale) {
        /**
         * As explain above, normalizedValue is the day of week (1 based index)
         * depending on the locale week start day. To retrieve the correct day name,
         * we need to convert it to a 0 based index with 0 being Sunday. (DAYS is
         * an object of day names with 0 being Sunday)
         */
        const index = (normalizedValue - 1 + (locale || DEFAULT_LOCALE).weekStart) % 7;
        return {
            value: DAYS$2[index].toString(),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes iso week number
 */
const isoWeekNumberAdapter = {
    normalizeFunctionValue(value) {
        const isoWeek = toNumber(value, DEFAULT_LOCALE);
        if (isoWeek < 0 || isoWeek > 53) {
            throw new EvaluationError(_t$1("%s is not a valid week (it should be a number between 0 and 53)", isoWeek));
        }
        return isoWeek;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes month number
 */
const monthNumberAdapter = {
    normalizeFunctionValue(value) {
        const month = toNumber(value, DEFAULT_LOCALE);
        if (month < 1 || month > 12) {
            throw new EvaluationError(_t$1("%s is not a valid month (it should be a number between 1 and 12)", month));
        }
        return month;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: MONTHS$1[toNumber(normalizedValue, DEFAULT_LOCALE) - 1].toString(),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes month number + year
 */
const monthAdapter = {
    normalizeFunctionValue(value) {
        const date = toNumber(value, DEFAULT_LOCALE);
        return formatValue$1(date, { locale: DEFAULT_LOCALE, format: "mm/yyyy" });
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "mmmm yyyy",
        };
    },
    toFunctionValue(normalizedValue) {
        const jsDate = toJsDate(normalizedValue, DEFAULT_LOCALE);
        return `DATE(${jsDate.getFullYear()},${jsDate.getMonth() + 1},1)`;
    },
};
/**
 * normalizes quarter number
 */
const quarterNumberAdapter = {
    normalizeFunctionValue(value) {
        const quarter = toNumber(value, DEFAULT_LOCALE);
        if (quarter < 1 || quarter > 4) {
            throw new EvaluationError(_t$1("%s is not a valid quarter (it should be a number between 1 and 4)", quarter));
        }
        return quarter;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t$1("Q%(quarter_number)s", { quarter_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
const yearAdapter = {
    normalizeFunctionValue(value) {
        const year = toNumber(value, DEFAULT_LOCALE);
        if (year > 3000) {
            // interpret the value as a full date
            return toJsDate(year, DEFAULT_LOCALE).getFullYear();
        }
        return year;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes hour number
 */
const hourNumberAdapter = {
    normalizeFunctionValue(value) {
        const hour = toNumber(value, DEFAULT_LOCALE);
        if (hour < 0 || hour > 23) {
            throw new EvaluationError(_t$1("%s is not a valid hour (it should be a number between 0 and 23)", hour));
        }
        return hour;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t$1("%(hour_number)sh", { hour_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes hour number
 */
const minuteNumberAdapter = {
    normalizeFunctionValue(value) {
        const minute = toNumber(value, DEFAULT_LOCALE);
        if (minute < 0 || minute > 59) {
            throw new EvaluationError(_t$1("%s is not a valid minute (it should be a number between 0 and 59)", minute));
        }
        return minute;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t$1("%(minute_number)s'", { minute_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes second number
 */
const secondNumberAdapter = {
    normalizeFunctionValue(value) {
        const second = toNumber(value, DEFAULT_LOCALE);
        if (second < 0 || second > 59) {
            throw new EvaluationError(_t$1("%s is not a valid second (it should be a number between 0 and 59)", second));
        }
        return second;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t$1("%(second_number)s''", { second_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * This function takes an adapter and wraps it with a null handler.
 * null value means that the value is not set.
 */
function nullHandlerDecorator(adapter) {
    return {
        normalizeFunctionValue(value) {
            if (value === null) {
                return null;
            }
            return adapter.normalizeFunctionValue(value);
        },
        toValueAndFormat(normalizedValue, locale) {
            if (normalizedValue === null) {
                return { value: _t$1("(Undefined)") }; //TODO Return NA ?
            }
            return adapter.toValueAndFormat(normalizedValue, locale);
        },
        toFunctionValue(normalizedValue) {
            if (normalizedValue === null) {
                return "false"; //TODO Return NA ?
            }
            return adapter.toFunctionValue(normalizedValue);
        },
    };
}
pivotTimeAdapterRegistry
    .add("day", nullHandlerDecorator(dayAdapter))
    .add("year", nullHandlerDecorator(yearAdapter))
    .add("day_of_month", nullHandlerDecorator(dayOfMonthAdapter))
    .add("iso_week_number", nullHandlerDecorator(isoWeekNumberAdapter))
    .add("month_number", nullHandlerDecorator(monthNumberAdapter))
    .add("month", nullHandlerDecorator(monthAdapter))
    .add("quarter_number", nullHandlerDecorator(quarterNumberAdapter))
    .add("day_of_week", nullHandlerDecorator(dayOfWeekAdapter))
    .add("hour_number", nullHandlerDecorator(hourNumberAdapter))
    .add("minute_number", nullHandlerDecorator(minuteNumberAdapter))
    .add("second_number", nullHandlerDecorator(secondNumberAdapter));

const AGGREGATOR_NAMES = {
    count: _t$1("Count"),
    count_distinct: _t$1("Count Distinct"),
    bool_and: _t$1("Boolean And"),
    bool_or: _t$1("Boolean Or"),
    max: _t$1("Maximum"),
    min: _t$1("Minimum"),
    avg: _t$1("Average"),
    sum: _t$1("Sum"),
};
const DEFAULT_AGGREGATORS = ["max", "min", "avg", "sum", "count_distinct", "count"];
const AGGREGATORS_BY_FIELD_TYPE = {
    integer: DEFAULT_AGGREGATORS,
    char: DEFAULT_AGGREGATORS,
    datetime: DEFAULT_AGGREGATORS,
    boolean: ["count_distinct", "count", "bool_and", "bool_or"],
};
const AGGREGATORS = {};
for (const type in AGGREGATORS_BY_FIELD_TYPE) {
    AGGREGATORS[type] = {};
    for (const aggregator of AGGREGATORS_BY_FIELD_TYPE[type]) {
        AGGREGATORS[type][aggregator] = AGGREGATOR_NAMES[aggregator];
    }
}
const AGGREGATORS_FN = {
    count: (args) => ({
        value: countAny([args]),
        format: "0",
    }),
    count_distinct: (args) => ({
        value: countUnique([args]),
        format: "0",
    }),
    bool_and: (args) => ({
        value: boolAnd([args]).result,
    }),
    bool_or: (args) => ({
        value: boolOr([args]).result,
    }),
    max: (args, locale) => max([args], locale),
    min: (args, locale) => min([args], locale),
    avg: (args, locale) => ({
        value: average([args], locale),
        format: inferFormat(args),
    }),
    sum: (args, locale) => ({
        value: sum([args], locale),
        format: inferFormat(args),
    }),
};
/**
 * Given an object of form {"1": {...}, "2": {...}, ...} get the maximum ID used
 * in this object
 * If the object has no keys, return 0
 *
 */
function getMaxObjectId(o) {
    const keys = Object.keys(o);
    if (!keys.length) {
        return 0;
    }
    const nums = keys.map((id) => parseInt(id, 10));
    return Math.max(...nums);
}
const ALL_PERIODS = {
    year: _t$1("Year"),
    quarter: _t$1("Quarter & Year"),
    month: _t$1("Month & Year"),
    week: _t$1("Week & Year"),
    day: _t$1("Day"),
    quarter_number: _t$1("Quarter"),
    month_number: _t$1("Month"),
    iso_week_number: _t$1("Week"),
    day_of_month: _t$1("Day of Month"),
    day_of_week: _t$1("Day of Week"),
    hour_number: _t$1("Hour"),
    minute_number: _t$1("Minute"),
    second_number: _t$1("Second"),
};
const DATE_FIELDS = ["date", "datetime"];
/**
 * Parse a dimension string into a pivot dimension definition.
 * e.g "create_date:month" => { name: "create_date", granularity: "month" }
 */
function parseDimension(dimension) {
    const [fieldName, granularity] = dimension.split(":");
    if (granularity) {
        return { fieldName, granularity };
    }
    return { fieldName };
}
function isDateOrDatetimeField(field) {
    return DATE_FIELDS.includes(field.type);
}
function generatePivotArgs(formulaId, domain, measure) {
    const args = [formulaId];
    if (measure) {
        args.push(`"${measure}"`);
    }
    for (const { field, value, type } of domain) {
        if (field === "measure") {
            args.push(`"measure"`, `"${value}"`);
            continue;
        }
        const { granularity } = parseDimension(field);
        const formattedValue = toFunctionPivotValue(value, { type, granularity });
        args.push(`"${field}"`, formattedValue);
    }
    return args;
}
/**
 * Check if the fields in the domain part of
 * a pivot function are valid according to the pivot definition.
 * e.g. =PIVOT.VALUE(1,"revenue","country_id",...,"create_date:month",...,"source_id",...)
 */
function areDomainArgsFieldsValid(dimensions, definition) {
    let argIndex = 0;
    let definitionIndex = 0;
    const cols = definition.columns.map((col) => col.nameWithGranularity);
    const rows = definition.rows.map((row) => row.nameWithGranularity);
    while (dimensions[argIndex] !== undefined && dimensions[argIndex] === rows[definitionIndex]) {
        argIndex++;
        definitionIndex++;
    }
    definitionIndex = 0;
    while (dimensions[argIndex] !== undefined && dimensions[argIndex] === cols[definitionIndex]) {
        argIndex++;
        definitionIndex++;
    }
    return dimensions.length === argIndex;
}
function createPivotFormula(formulaId, cell) {
    switch (cell.type) {
        case "HEADER":
            return `=PIVOT.HEADER(${generatePivotArgs(formulaId, cell.domain).join(",")})`;
        case "VALUE":
            return `=PIVOT.VALUE(${generatePivotArgs(formulaId, cell.domain, cell.measure).join(",")})`;
        case "MEASURE_HEADER":
            return `=PIVOT.HEADER(${generatePivotArgs(formulaId, [
                ...cell.domain,
                { field: "measure", value: cell.measure, type: "char" },
            ]).join(",")})`;
    }
    return "";
}
/**
 * Parses the value defining a pivot group in a PIVOT formula
 * e.g. given the following formula PIVOT.VALUE("1", "stage_id", "42", "status", "won"),
 * the two group values are "42" and "won".
 */
function toNormalizedPivotValue(dimension, groupValue) {
    if (groupValue === null || groupValue === "null") {
        return null;
    }
    const extractedGroupValue = typeof groupValue === "object" ? groupValue.value : groupValue;
    if (isEvaluationError(extractedGroupValue)) {
        return extractedGroupValue;
    }
    if (dimension.type === "custom") {
        return toValue(groupValue) ?? null;
    }
    const groupValueString = typeof groupValue === "boolean"
        ? toString(groupValue).toLocaleLowerCase()
        : toString(groupValue);
    if (groupValueString === "null") {
        return null;
    }
    if (!pivotNormalizationValueRegistry.contains(dimension.type)) {
        throw new EvaluationError(_t$1("Field %(field)s is not supported because of its type (%(type)s)", {
            field: dimension.displayName,
            type: dimension.type,
        }));
    }
    // represents a field which is not set (=False server side)
    if (groupValueString.toLowerCase() === "false") {
        return false;
    }
    const normalizer = pivotNormalizationValueRegistry.get(dimension.type);
    return normalizer(groupValueString, dimension.granularity);
}
function normalizeDateTime(value, granularity) {
    return pivotTimeAdapter(granularity ?? "month").normalizeFunctionValue(value);
}
function toFunctionPivotValue(value, dimension) {
    if (value === null) {
        return `"null"`;
    }
    if (!pivotToFunctionValueRegistry.contains(dimension.type)) {
        return `"${value}"`;
    }
    return pivotToFunctionValueRegistry.get(dimension.type)(value, dimension.granularity);
}
function toFunctionValueDateTime(value, granularity) {
    return pivotTimeAdapter(granularity ?? "month").toFunctionValue(value);
}
const pivotNormalizationValueRegistry = new Registry();
pivotNormalizationValueRegistry
    .add("date", normalizeDateTime)
    .add("datetime", normalizeDateTime)
    .add("integer", (value) => toNumber(value, DEFAULT_LOCALE))
    .add("boolean", (value) => toBoolean(value))
    .add("char", (value) => toString(value))
    .add("custom", (value) => value);
const pivotToFunctionValueRegistry = new Registry();
pivotToFunctionValueRegistry
    .add("date", toFunctionValueDateTime)
    .add("datetime", toFunctionValueDateTime)
    .add("integer", (value) => `${toNumber(value, DEFAULT_LOCALE)}`)
    .add("boolean", (value) => (toBoolean(value) ? "TRUE" : "FALSE"))
    .add("char", (value) => `"${toString(value).replace(/"/g, '\\"')}"`)
    .add("custom", (value) => (typeof value === "string" ? `"${value}"` : String(value)));
function getFieldDisplayName(field) {
    return field.displayName + (field.granularity ? ` (${ALL_PERIODS[field.granularity]})` : "");
}
function addAlignFormatToPivotHeader(domain, functionResult) {
    if (domain.length === 0) {
        return functionResult;
    }
    return { ...functionResult, format: (functionResult.format || "@") + "* " };
}
function isSortedColumnValid(sortedColumn, pivot) {
    try {
        if (!pivot.getMeasure(sortedColumn.measure)) {
            return false;
        }
        const columns = pivot.definition.columns;
        for (let i = 0; i < sortedColumn.domain.length; i++) {
            if (columns[i].nameWithGranularity !== sortedColumn.domain[i].field) {
                return false;
            }
            const possibleValues = pivot
                .getPossibleFieldValues(columns[i])
                .map((v) => v.value);
            if (!possibleValues.includes(sortedColumn.domain[i].value) &&
                !(sortedColumn.domain[i].value === null && possibleValues.includes(""))) {
                return false;
            }
        }
        return true;
    }
    catch (e) {
        return false;
    }
}
function getUniquePivotGroupName(baseName, field) {
    const groupNames = field.groups.map((g) => g.name);
    return getUniqueText(baseName, groupNames, {
        compute: (name, i) => `${name}${i}`,
        start: 2,
    });
}
function getUniquePivotFieldName(baseName, fields) {
    const namesToAvoid = Object.values(fields)
        .map((f) => [f?.name, f?.string])
        .flat()
        .filter(isDefined$1);
    return getUniqueText(baseName, namesToAvoid, {
        compute: (name, i) => `${name}${i}`,
        start: 2,
    });
}
function createCustomFields(definition, fields) {
    const newFields = {};
    for (const customField of Object.values(definition.customFields || {})) {
        const parentField = fields[customField.parentField];
        if (!parentField) {
            continue;
        }
        newFields[customField.name] = {
            type: "custom",
            isCustomField: true,
            name: customField.name,
            string: customField.name,
            customGroups: customField.groups,
            parentField: customField.parentField,
        };
    }
    return newFields;
}
function removePivotGroupsContainingValues(valuesToRemove, customField) {
    customField.groups = customField.groups.filter((group) => !group.values.some((value) => valuesToRemove.includes(value)));
}
/**
 * Adds a new dimension to the pivot definition before a specified base dimension.
 * If the new dimension already exists, it does nothing.
 */
function addDimensionToPivotDefinition(definition, baseDimension, newDimension) {
    const dimensions = definition.rows.some((dim) => dim.fieldName === baseDimension)
        ? definition.rows
        : definition.columns;
    const baseIndex = dimensions.findIndex((dim) => dim.fieldName === baseDimension);
    if (baseIndex === -1) {
        return definition;
    }
    if (dimensions.some((dim) => dim.fieldName === newDimension)) {
        return definition;
    }
    dimensions.splice(baseIndex, 0, { fieldName: newDimension });
    return definition;
}
function getCustomFieldWithParentField(definition, parentField, fields) {
    return (Object.values(definition.customFields || {}).find((field) => field.parentField === parentField.name) || {
        parentField: parentField.name,
        name: getUniquePivotFieldName(parentField.string, fields),
        groups: [],
    });
}
function togglePivotCollapse(position, env) {
    const pivotCell = env.model.getters.getPivotCellFromPosition(position);
    const pivotId = env.model.getters.getPivotIdFromPosition(position);
    if (!pivotId || pivotCell.type !== "HEADER") {
        return;
    }
    const definition = env.model.getters.getPivotCoreDefinition(pivotId);
    const collapsedDomains = definition.collapsedDomains?.[pivotCell.dimension]
        ? [...definition.collapsedDomains[pivotCell.dimension]]
        : [];
    const index = collapsedDomains.findIndex((domain) => deepEquals$1(domain, pivotCell.domain));
    if (index !== -1) {
        collapsedDomains.splice(index, 1);
    }
    else {
        collapsedDomains.push(pivotCell.domain);
    }
    const newDomains = definition.collapsedDomains
        ? { ...definition.collapsedDomains }
        : { COL: [], ROW: [] };
    newDomains[pivotCell.dimension] = collapsedDomains;
    env.model.dispatch("UPDATE_PIVOT", {
        pivotId,
        pivot: { ...definition, collapsedDomains: newDomains },
    });
}

/**
 * Get the pivot ID from the formula pivot ID.
 */
function getPivotId(pivotFormulaId, getters) {
    const pivotId = getters.getPivotId(pivotFormulaId);
    if (!pivotId) {
        throw new EvaluationError(_t$1('There is no pivot with id "%s"', pivotFormulaId));
    }
    return pivotId;
}
function assertMeasureExist(pivotId, measure, getters) {
    const { measures } = getters.getPivotCoreDefinition(pivotId);
    if (!measures.find((m) => m.id === measure)) {
        const validMeasures = `(${measures.map((m) => m.id).join(", ")})`;
        throw new EvaluationError(_t$1("The argument %s is not a valid measure. Here are the measures: %s", measure, validMeasures));
    }
}
function assertDomainLength(domain) {
    if (domain.length % 2 !== 0) {
        throw new EvaluationError(_t$1("Function PIVOT takes an even number of arguments."));
    }
}
function addPivotDependencies(evalContext, coreDefinition, forMeasures) {
    //TODO This function can be very costly when used with PIVOT.VALUE and PIVOT.HEADER
    const dependencies = [];
    if (coreDefinition.type === "SPREADSHEET" && coreDefinition.dataSet) {
        const { sheetId, zone } = coreDefinition.dataSet;
        const xc = zoneToXc(zone);
        const range = evalContext.getters.getRangeFromSheetXC(sheetId, xc);
        if (range === undefined || range.invalidXc || range.invalidSheetName) {
            throw new InvalidReferenceError();
        }
        if (evalContext.__originCellPosition &&
            range.sheetId === evalContext.__originSheetId &&
            isZoneInside(positionToZone(evalContext.__originCellPosition), zone)) {
            throw new CircularDependencyError();
        }
        dependencies.push(range);
    }
    for (const measure of forMeasures) {
        if (measure.computedBy) {
            const formula = evalContext.getters.getMeasureCompiledFormula(measure);
            dependencies.push(...formula.dependencies.filter((range) => !range.invalidXc));
        }
    }
    const originPosition = evalContext.__originCellPosition;
    if (originPosition && dependencies.length) {
        // The following line is used to reset the dependencies of the cell, to avoid
        // keeping dependencies from previous evaluation of the PIVOT formula (i.e.
        // in case the reference has been changed).
        evalContext.updateDependencies?.(originPosition);
        evalContext.addDependencies?.(originPosition, dependencies);
    }
}

const DEFAULT_IS_SORTED = true;
const DEFAULT_MATCH_MODE = 0;
const DEFAULT_SEARCH_MODE = 1;
const DEFAULT_ABSOLUTE_RELATIVE_MODE = 1;
const A1_NOTATION_OPTIONS = [
    { value: true, label: _t$1("A1 style (default)") },
    { value: false, label: _t$1("R1C1 style") },
];
const IS_SORTED_OPTIONS = [
    { value: true, label: _t$1("Approximate match (default)") },
    { value: false, label: _t$1("Exact match") },
];
// -----------------------------------------------------------------------------
// ADDRESS
// -----------------------------------------------------------------------------
const ADDRESS = {
    description: _t$1("Returns a cell reference as a string. "),
    args: [
        arg("row (number)", _t$1("The row number of the cell reference. ")),
        arg("column (number)", _t$1("The column number (not name) of the cell reference. A is column number 1. ")),
        arg(`absolute_relative_mode (number, default=${DEFAULT_ABSOLUTE_RELATIVE_MODE})`, _t$1("An indicator of whether the reference is row/column absolute."), [
            { value: 1, label: _t$1("Absolute row and column (e.g. $A$1)") },
            { value: 2, label: _t$1("Absolute row, relative column (e.g. A$1)") },
            { value: 3, label: _t$1("Relative row, absolute column (e.g. $A1)") },
            { value: 4, label: _t$1("Relative row and column (e.g. A1)") },
        ]),
        arg("use_a1_notation (boolean, default=TRUE)", _t$1("A boolean indicating whether to use A1 style notation or R1C1 style notation."), A1_NOTATION_OPTIONS),
        arg("sheet (string, optional)", _t$1("A string indicating the name of the sheet into which the address points.")),
    ],
    compute: function (row, column, absoluteRelativeMode = { value: DEFAULT_ABSOLUTE_RELATIVE_MODE }, useA1Notation = { value: true }, sheet) {
        const rowNumber = strictToInteger(row, this.locale);
        const colNumber = strictToInteger(column, this.locale);
        if (rowNumber < 1) {
            return new EvaluationError(expectNumberGreaterThanOrEqualToOne(rowNumber));
        }
        if (colNumber < 1) {
            return new EvaluationError(expectNumberGreaterThanOrEqualToOne(colNumber));
        }
        const _absoluteRelativeMode = strictToInteger(absoluteRelativeMode, this.locale);
        if (![1, 2, 3, 4].includes(_absoluteRelativeMode)) {
            return new EvaluationError(expectNumberRangeError(1, 4, _absoluteRelativeMode));
        }
        const _useA1Notation = toBoolean(useA1Notation);
        let cellReference;
        if (_useA1Notation) {
            const rangePart = {
                rowFixed: [1, 2].includes(_absoluteRelativeMode),
                colFixed: [1, 3].includes(_absoluteRelativeMode),
            };
            cellReference = toXC(colNumber - 1, rowNumber - 1, rangePart);
        }
        else {
            const rowPart = [1, 2].includes(_absoluteRelativeMode) ? `R${rowNumber}` : `R[${rowNumber}]`;
            const colPart = [1, 3].includes(_absoluteRelativeMode) ? `C${colNumber}` : `C[${colNumber}]`;
            cellReference = rowPart + colPart;
        }
        if (sheet !== undefined) {
            return getFullReference(toString(sheet), cellReference);
        }
        return cellReference;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COLUMN
// -----------------------------------------------------------------------------
const COLUMN = {
    description: _t$1("Column number of a specified cell."),
    args: [
        arg("cell_reference (meta, range<meta>, default='this cell')", _t$1("The cell whose column number will be returned. Column A corresponds to 1. By default, the function use the cell in which the formula is entered.")),
    ],
    compute: function (cellReference) {
        if (cellReference === undefined) {
            if (this.__originCellPosition?.col === undefined) {
                return new EvaluationError(_t$1("In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter."));
            }
            return this.__originCellPosition.col + 1;
        }
        if (cellReference[0][0] === undefined) {
            return new EvaluationError(_t$1("The range is out of bounds."));
        }
        if (cellReference[0][0].value === CellErrorType$1.InvalidReference) {
            return cellReference[0][0]; // return the same error
        }
        const left = this.getters.getRangeFromSheetXC(this.getters.getActiveSheetId(), cellReference[0][0].value).zone.left;
        if (cellReference.length === 1) {
            return left + 1;
        }
        return generateMatrix(cellReference.length, 1, (col, row) => ({ value: left + col + 1 }));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COLUMNS
// -----------------------------------------------------------------------------
const COLUMNS = {
    description: _t$1("Number of columns in a specified array or range."),
    args: [arg("range (any, range<any>)", _t$1("The range whose column count will be returned."))],
    compute: function (range) {
        const _range = toMatrix(range);
        if (_range[0][0] === undefined) {
            return new EvaluationError(_t$1("The range is out of bounds."));
        }
        if (_range[0][0].value === CellErrorType$1.InvalidReference) {
            return _range[0][0];
        }
        return _range.length;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HLOOKUP
// -----------------------------------------------------------------------------
const HLOOKUP = {
    description: _t$1("Horizontal lookup"),
    args: [
        arg("search_key (string, number, boolean)", _t$1("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t$1("The range to consider for the search. The first row in the range is searched for the key specified in search_key.")),
        arg("index (number)", _t$1("The row index of the value to be returned, where the first row in range is numbered 1.")),
        arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t$1("Indicates whether the row to be searched (the first row of the specified range) is sorted, in which case the closest match for search_key will be returned."), IS_SORTED_OPTIONS),
    ],
    compute: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
        const _index = Math.trunc(toNumber(index?.value, this.locale));
        const _range = toMatrix(range);
        if (1 > _index || _index > _range[0].length) {
            return new EvaluationError(_t$1("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
        }
        const getValueFromRange = (range, index) => range[index][0].value;
        const _isSorted = toBoolean(isSorted.value);
        const colIndex = _isSorted
            ? dichotomicSearch(_range, searchKey, "nextSmaller", "asc", _range.length, getValueFromRange)
            : linearSearch(_range, searchKey, "wildcard", _range.length, getValueFromRange, this.lookupCaches);
        const col = _range[colIndex];
        if (col === undefined) {
            return valueNotAvailable(searchKey);
        }
        return col[_index - 1];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INDEX
// -----------------------------------------------------------------------------
const INDEX = {
    description: _t$1("Returns the content of a cell, specified by row and column offset."),
    args: [
        arg("reference (any, range)", _t$1("The range of cells from which the values are returned.")),
        arg("row (number, default=0)", _t$1("The index of the row to be returned from within the reference range of cells.")),
        arg("column (number, default=0)", _t$1("The index of the column to be returned from within the reference range of cells.")),
    ],
    compute: function (reference, row = { value: 0 }, column = { value: 0 }) {
        const _reference = toMatrix(reference);
        const _row = toNumber(row.value, this.locale);
        const _column = toNumber(column.value, this.locale);
        if (_column < 0 ||
            _column - 1 >= _reference.length ||
            _row < 0 ||
            _row - 1 >= _reference[0].length) {
            return new EvaluationError(_t$1("Index out of range."));
        }
        if (_row === 0 && _column === 0) {
            return _reference;
        }
        if (_row === 0) {
            return [_reference[_column - 1]];
        }
        if (_column === 0) {
            return _reference.map((col) => [col[_row - 1]]);
        }
        return _reference[_column - 1][_row - 1];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INDIRECT
// -----------------------------------------------------------------------------
const INDIRECT = {
    description: _t$1("Returns the content of a cell, specified by a string."),
    args: [
        arg("reference (string)", _t$1("The range of cells from which the values are returned.")),
        arg("use_a1_notation (boolean, default=TRUE)", _t$1("A boolean indicating whether to use A1 style notation (TRUE) or R1C1 style notation (FALSE)."), A1_NOTATION_OPTIONS),
    ],
    compute: function (reference, useA1Notation = { value: true }) {
        const _reference = reference?.value?.toString();
        if (!_reference) {
            return new InvalidReferenceError(_t$1("Reference should be defined."));
        }
        const _useA1Notation = toBoolean(useA1Notation);
        if (!_useA1Notation) {
            return new EvaluationError(_t$1("R1C1 notation is not supported."));
        }
        const sheetId = this.__originSheetId;
        const originPosition = this.__originCellPosition;
        if (originPosition) {
            // The following line is used to reset the dependencies of the cell, to avoid
            // keeping dependencies from previous evaluation of the INDIRECT formula (i.e.
            // in case the reference has been changed).
            this.updateDependencies?.(originPosition);
        }
        const range = this.getters.getRangeFromSheetXC(sheetId, _reference);
        if (range === undefined || range.invalidXc || range.invalidSheetName) {
            return new InvalidReferenceError();
        }
        if (originPosition) {
            this.addDependencies?.(originPosition, [range]);
        }
        const values = [];
        for (let col = range.zone.left; col <= range.zone.right; col++) {
            const colValues = [];
            for (let row = range.zone.top; row <= range.zone.bottom; row++) {
                const position = { sheetId: range.sheetId, col, row };
                colValues.push(this.getters.getEvaluatedCell(position));
            }
            values.push(colValues);
        }
        return values.length === 1 && values[0].length === 1 ? values[0][0] : values;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOOKUP
// -----------------------------------------------------------------------------
const LOOKUP = {
    description: _t$1("Look up a value."),
    args: [
        arg("search_key (string, number, boolean)", _t$1("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("search_array (any, range)", _t$1("One method of using this function is to provide a single sorted row or column search_array to look through for the search_key with a second argument result_range. The other way is to combine these two arguments into one search_array where the first row or column is searched and a value is returned from the last row or column in the array. If search_key is not found, a non-exact match may be returned.")),
        arg("result_range (any, range, optional)", _t$1("The range from which to return a result. The value returned corresponds to the location where search_key is found in search_range. This range must be only a single row or column and should not be used if using the search_result_array method.")),
    ],
    compute: function (searchKey, searchArray, resultRange) {
        const _searchArray = toMatrix(searchArray);
        const _resultRange = toMatrix(resultRange);
        let nbCol = _searchArray.length;
        let nbRow = _searchArray[0].length;
        const verticalSearch = nbRow >= nbCol;
        const getElement = verticalSearch
            ? (range, index) => range[0][index].value
            : (range, index) => range[index][0].value;
        const rangeLength = verticalSearch ? nbRow : nbCol;
        const index = dichotomicSearch(_searchArray, searchKey, "nextSmaller", "asc", rangeLength, getElement);
        if (index === -1 ||
            (verticalSearch && _searchArray[0][index] === undefined) ||
            (!verticalSearch && _searchArray[index][nbRow - 1] === undefined)) {
            return valueNotAvailable(searchKey);
        }
        if (_resultRange[0].length === 0) {
            return verticalSearch ? _searchArray[nbCol - 1][index] : _searchArray[index][nbRow - 1];
        }
        nbCol = _resultRange.length;
        nbRow = _resultRange[0].length;
        if (nbCol !== 1 && nbRow !== 1) {
            return new EvaluationError(_t$1("The result_range must be a single row or a single column."));
        }
        if (nbCol > 1) {
            if (index > nbCol - 1) {
                return new EvaluationError(_t$1("[[FUNCTION_NAME]] evaluates to an out of range row value %s.", index + 1));
            }
            return _resultRange[index][0];
        }
        if (index > nbRow - 1) {
            return new EvaluationError(_t$1("[[FUNCTION_NAME]] evaluates to an out of range column value %s.", index + 1));
        }
        return _resultRange[0][index];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MATCH
// -----------------------------------------------------------------------------
const DEFAULT_SEARCH_TYPE = 1;
const MATCH = {
    description: _t$1("Position of item in range that matches value."),
    args: [
        arg("search_key (string, number, boolean)", _t$1("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t$1("The one-dimensional array to be searched.")),
        arg(`search_type (number, default=${DEFAULT_SEARCH_TYPE})`, _t$1("The search method is a number 1, 0 or -1 indicating which value to return. 1 finds the largest value less than or equal to search_key when range is sorted in ascending order. 0 finds the exact value when range is unsorted. -1 finds the smallest value greater than or equal to search_key when range is sorted in descending order."), [
            { value: 1, label: _t$1("Ascending order (default)") },
            { value: 0, label: _t$1("Exact match") },
            { value: -1, label: _t$1("Descending order") },
        ]),
    ],
    compute: function (searchKey, range, searchType = { value: DEFAULT_SEARCH_TYPE }) {
        let _searchType = toNumber(searchType, this.locale);
        const _range = toMatrix(range);
        const nbCol = _range.length;
        const nbRow = _range[0].length;
        if (nbCol !== 1 && nbRow !== 1) {
            return new EvaluationError(_t$1("The range must be a single row or a single column."));
        }
        let index = -1;
        const getElement = nbCol === 1
            ? (_range, index) => _range[0][index].value
            : (_range, index) => _range[index][0].value;
        const rangeLen = nbCol === 1 ? _range[0].length : _range.length;
        _searchType = Math.sign(_searchType);
        switch (_searchType) {
            case 1:
                index = dichotomicSearch(_range, searchKey, "nextSmaller", "asc", rangeLen, getElement);
                break;
            case 0:
                index = linearSearch(_range, searchKey, "wildcard", rangeLen, getElement, this.lookupCaches);
                break;
            case -1:
                index = dichotomicSearch(_range, searchKey, "nextGreater", "desc", rangeLen, getElement);
                break;
        }
        if ((nbCol === 1 && _range[0][index] === undefined) ||
            (nbCol !== 1 && _range[index] === undefined)) {
            return valueNotAvailable(searchKey);
        }
        return index + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROW
// -----------------------------------------------------------------------------
const ROW = {
    description: _t$1("Row number of a specified cell."),
    args: [
        arg("cell_reference (meta, range<meta>, default='this cell')", _t$1("The cell whose row number will be returned. By default, this function uses the cell in which the formula is entered.")),
    ],
    compute: function (cellReference) {
        if (cellReference === undefined) {
            if (this.__originCellPosition?.row === undefined) {
                return new EvaluationError(_t$1("In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter."));
            }
            return this.__originCellPosition.row + 1;
        }
        if (cellReference[0][0] === undefined) {
            return new EvaluationError(_t$1("The range is out of bounds."));
        }
        if (cellReference[0][0].value === CellErrorType$1.InvalidReference) {
            return cellReference[0][0]; // return the same error
        }
        const top = this.getters.getRangeFromSheetXC(this.getters.getActiveSheetId(), cellReference[0][0].value).zone.top;
        if (cellReference[0].length === 1) {
            return top + 1;
        }
        return generateMatrix(1, cellReference[0].length, (col, row) => ({ value: top + row + 1 }));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROWS
// -----------------------------------------------------------------------------
const ROWS = {
    description: _t$1("Number of rows in a specified array or range."),
    args: [arg("range (any, range<any>)", _t$1("The range whose row count will be returned."))],
    compute: function (range) {
        const _range = toMatrix(range);
        if (_range[0][0] === undefined) {
            return new EvaluationError(_t$1("The range is out of bounds."));
        }
        if (_range[0][0].value === CellErrorType$1.InvalidReference) {
            return _range[0][0];
        }
        return _range[0].length;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VLOOKUP
// -----------------------------------------------------------------------------
const VLOOKUP = {
    description: _t$1("Vertical lookup."),
    args: [
        arg("search_key (string, number, boolean)", _t$1("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t$1("The range to consider for the search. The first column in the range is searched for the key specified in search_key.")),
        arg("index (number)", _t$1("The column index of the value to be returned, where the first column in range is numbered 1.")),
        arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t$1("Indicates whether the column to be searched (the first column of the specified range) is sorted, in which case the closest match for search_key will be returned."), IS_SORTED_OPTIONS),
    ],
    compute: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
        const _index = Math.trunc(toNumber(index?.value, this.locale));
        const _range = toMatrix(range);
        if (1 > _index || _index > _range.length) {
            return new EvaluationError(_t$1("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
        }
        const getValueFromRange = (range, index) => range[0][index].value;
        const _isSorted = toBoolean(isSorted.value);
        const rowIndex = _isSorted
            ? dichotomicSearch(_range, searchKey, "nextSmaller", "asc", _range[0].length, getValueFromRange)
            : linearSearch(_range, searchKey, "wildcard", _range[0].length, getValueFromRange, this.lookupCaches);
        const value = _range[_index - 1][rowIndex];
        if (value === undefined) {
            return valueNotAvailable(searchKey);
        }
        return value;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XLOOKUP
// -----------------------------------------------------------------------------
const MATCH_MODE = {
    "0": "strict",
    "1": "nextGreater",
    "-1": "nextSmaller",
    "2": "wildcard",
};
const XLOOKUP = {
    description: _t$1("Search a range for a match and return the corresponding item from a second range."),
    args: [
        arg("search_key (string,number,boolean)", _t$1("The value to search for.")),
        arg("lookup_range (any, range)", _t$1("The range to consider for the search. Should be a single column or a single row.")),
        arg("return_range (any, range)", _t$1("The range containing the return value. Should have the same dimensions as lookup_range.")),
        arg("if_not_found (any, optional)", _t$1("If a valid match is not found, return this value.")),
        arg(`match_mode (any, default=${DEFAULT_MATCH_MODE})`, _t$1("Specifies how to match search_key with the items in lookup_range. "), [
            { value: 0, label: _t$1("Exact match (default)") },
            { value: -1, label: _t$1("Exact match or next smaller item") },
            { value: 1, label: _t$1("Exact match or next larger item") },
            { value: 2, label: _t$1("Wildcard character match") },
        ]),
        arg(`search_mode (any, default=${DEFAULT_SEARCH_MODE})`, _t$1("Specifies the search mode to use. By default, a first to last search will be used."), [
            { value: 1, label: _t$1("Search first to last (default)") },
            { value: -1, label: _t$1("Search last to first") },
            { value: 2, label: _t$1("Binary search (sorted ascending order)") },
            { value: -2, label: _t$1("Binary search (sorted descending order)") },
        ]),
    ],
    compute: function (searchKey, lookupRange, returnRange, defaultValue, matchMode = { value: DEFAULT_MATCH_MODE }, searchMode = { value: DEFAULT_SEARCH_MODE }) {
        const _matchMode = Math.trunc(toNumber(matchMode.value, this.locale));
        const _searchMode = Math.trunc(toNumber(searchMode.value, this.locale));
        const _lookupRange = toMatrix(lookupRange);
        const _returnRange = toMatrix(returnRange);
        if (_lookupRange.length !== 1 && _lookupRange[0].length !== 1) {
            return new EvaluationError(_t$1("lookup_range should be either a single row or single column."));
        }
        if (![1, -1, 2, -2].includes(_searchMode)) {
            return new EvaluationError(_t$1("search_mode should be a value in [-1, 1, -2, 2]."));
        }
        if (![-1, 0, 1, 2].includes(_matchMode)) {
            return new EvaluationError(_t$1("match_mode should be a value in [-1, 0, 1, 2]."));
        }
        const lookupDirection = _lookupRange.length === 1 ? "col" : "row";
        if (_matchMode === 2 && [-2, 2].includes(_searchMode)) {
            return new EvaluationError(_t$1("The search and match mode combination is not supported for XLOOKUP evaluation."));
        }
        if (lookupDirection === "col"
            ? _returnRange[0].length !== _lookupRange[0].length
            : _returnRange.length !== _lookupRange.length) {
            return new EvaluationError(_t$1("return_range should have the same dimensions as lookup_range."));
        }
        const getElement = lookupDirection === "col"
            ? (range, index) => range[0][index].value
            : (range, index) => range[index][0].value;
        const rangeLen = lookupDirection === "col" ? _lookupRange[0].length : _lookupRange.length;
        const mode = MATCH_MODE[_matchMode];
        const reverseSearch = _searchMode === -1;
        const index = _searchMode === 2 || _searchMode === -2
            ? dichotomicSearch(_lookupRange, searchKey, mode, _searchMode === 2 ? "asc" : "desc", rangeLen, getElement)
            : linearSearch(_lookupRange, searchKey, mode, rangeLen, getElement, this.lookupCaches, reverseSearch);
        if (index !== -1) {
            return lookupDirection === "col"
                ? _returnRange.map((col) => [col[index]])
                : [_returnRange[index]];
        }
        if (defaultValue === undefined) {
            return valueNotAvailable(searchKey);
        }
        return [[defaultValue]];
    },
    isExported: true,
};
//--------------------------------------------------------------------------
// Pivot functions
//--------------------------------------------------------------------------
// PIVOT.VALUE
const PIVOT_VALUE = {
    description: _t$1("Get the value from a pivot."),
    args: [
        arg("pivot_id (number,string)", _t$1("ID of the pivot.")),
        arg("measure_name (string)", _t$1("Name of the measure.")),
        arg("domain_field_name (string,repeating)", _t$1("Field name.")),
        arg("domain_value (number,string,boolean,repeating)", _t$1("Value.")),
    ],
    compute: function (formulaId, measureName, ...domainArgs) {
        const _pivotFormulaId = toString(formulaId);
        const _measure = toString(measureName);
        const pivotId = getPivotId(_pivotFormulaId, this.getters);
        assertMeasureExist(pivotId, _measure, this.getters);
        assertDomainLength(domainArgs);
        const pivot = this.getters.getPivot(pivotId);
        const coreDefinition = this.getters.getPivotCoreDefinition(pivotId);
        addPivotDependencies(this, coreDefinition, coreDefinition.measures.filter((m) => m.id === _measure));
        pivot.init({ reload: pivot.needsReevaluation });
        const error = pivot.assertIsValid({ throwOnError: false });
        if (error) {
            return error;
        }
        if (!pivot.areDomainArgsFieldsValid(domainArgs)) {
            const suggestion = _t$1("Consider using a dynamic pivot formula: %s. Or re-insert the static pivot from the Data menu.", `=PIVOT(${_pivotFormulaId})`);
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("Dimensions don't match the pivot definition") + ". " + suggestion,
            };
        }
        const domain = pivot.parseArgsToPivotDomain(domainArgs);
        if (this.getters.getActiveSheetId() === this.__originSheetId) {
            this.getters.getPivotPresenceTracker(pivotId)?.trackValue(_measure, domain);
        }
        return pivot.getPivotCellValueAndFormat(_measure, domain);
    },
};
// PIVOT.HEADER
const PIVOT_HEADER = {
    description: _t$1("Get the header of a pivot."),
    args: [
        arg("pivot_id (number,string)", _t$1("ID of the pivot.")),
        arg("domain_field_name (string,repeating)", _t$1("Field name.")),
        arg("domain_value (number,string,value,repeating)", _t$1("Value.")),
    ],
    compute: function (pivotId, ...domainArgs) {
        const _pivotFormulaId = toString(pivotId);
        const _pivotId = getPivotId(_pivotFormulaId, this.getters);
        assertDomainLength(domainArgs);
        const pivot = this.getters.getPivot(_pivotId);
        const coreDefinition = this.getters.getPivotCoreDefinition(_pivotId);
        addPivotDependencies(this, coreDefinition, []);
        pivot.init({ reload: pivot.needsReevaluation });
        const error = pivot.assertIsValid({ throwOnError: false });
        if (error) {
            return error;
        }
        if (!pivot.areDomainArgsFieldsValid(domainArgs)) {
            const suggestion = _t$1("Consider using a dynamic pivot formula: %s. Or re-insert the static pivot from the Data menu.", `=PIVOT(${_pivotFormulaId})`);
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("Dimensions don't match the pivot definition") + ". " + suggestion,
            };
        }
        const domain = pivot.parseArgsToPivotDomain(domainArgs);
        if (this.getters.getActiveSheetId() === this.__originSheetId) {
            this.getters.getPivotPresenceTracker(_pivotId)?.trackHeader(domain);
        }
        const lastNode = domain.at(-1);
        if (lastNode?.field === "measure") {
            return pivot.getPivotMeasureValue(toString(lastNode.value), domain);
        }
        const { value, format } = pivot.getPivotHeaderValueAndFormat(domain);
        return {
            value,
            format: !lastNode || lastNode.field === "measure" || lastNode.value === "false"
                ? undefined
                : format,
        };
    },
};
const PIVOT = {
    description: _t$1("Get a pivot table."),
    args: [
        arg("pivot_id (string)", _t$1("ID of the pivot.")),
        arg("row_count (number, optional)", _t$1("number of rows")),
        arg("include_total (boolean, default=TRUE)", _t$1("Whether to include total/sub-totals or not.")),
        arg("include_column_titles (boolean, default=TRUE)", _t$1("Whether to include the column titles or not.")),
        arg("column_count (number, optional)", _t$1("number of columns")),
        arg("include_measure_titles (boolean, default=TRUE)", _t$1("Whether to include the measure titles row or not.")),
    ],
    compute: function (pivotFormulaId, rowCount = { value: 10000 }, includeTotal = { value: true }, includeColumnHeaders = { value: true }, columnCount = { value: Number.MAX_VALUE }, includeMeasureTitles = { value: true }) {
        const _pivotFormulaId = toString(pivotFormulaId);
        const _rowCount = toNumber(rowCount, this.locale);
        if (_rowCount < 0) {
            return new EvaluationError(_t$1("The number of rows must be positive."));
        }
        const _columnCount = toNumber(columnCount, this.locale);
        if (_columnCount < 0) {
            return new EvaluationError(_t$1("The number of columns must be positive."));
        }
        const visibilityOptions = {
            displayColumnHeaders: toBoolean(includeColumnHeaders),
            displayTotals: toBoolean(includeTotal),
            displayMeasuresRow: toBoolean(includeMeasureTitles),
        };
        const pivotId = getPivotId(_pivotFormulaId, this.getters);
        const pivot = this.getters.getPivot(pivotId);
        const coreDefinition = this.getters.getPivotCoreDefinition(pivotId);
        addPivotDependencies(this, coreDefinition, coreDefinition.measures);
        pivot.init({ reload: pivot.needsReevaluation });
        const error = pivot.assertIsValid({ throwOnError: false });
        if (error) {
            return error;
        }
        const table = pivot.getCollapsedTableStructure();
        if (table.numberOfCells > PIVOT_MAX_NUMBER_OF_CELLS) {
            return new EvaluationError(getPivotTooBigErrorMessage$1(table.numberOfCells, this.locale));
        }
        const cells = table.getPivotCells(visibilityOptions);
        let headerRows = 0;
        if (visibilityOptions.displayColumnHeaders) {
            headerRows = table.columns.length - 1;
        }
        if (visibilityOptions.displayMeasuresRow) {
            headerRows++;
        }
        const pivotTitle = this.getters.getPivotName(pivotId);
        const tableHeight = Math.min(headerRows + _rowCount, cells[0].length);
        if (tableHeight === 0) {
            return [[{ value: pivotTitle }]];
        }
        const tableWidth = Math.min(1 + _columnCount, cells.length);
        const result = [];
        for (const col of range$1(0, tableWidth)) {
            result[col] = [];
            for (const row of range$1(0, tableHeight)) {
                const pivotCell = cells[col][row];
                switch (pivotCell.type) {
                    case "EMPTY":
                        result[col].push({ value: "" });
                        break;
                    case "HEADER":
                        const valueAndFormat = pivot.getPivotHeaderValueAndFormat(pivotCell.domain);
                        result[col].push(addAlignFormatToPivotHeader(pivotCell.domain, valueAndFormat));
                        break;
                    case "MEASURE_HEADER":
                        result[col].push(pivot.getPivotMeasureValue(pivotCell.measure, pivotCell.domain));
                        break;
                    case "VALUE":
                        result[col].push(pivot.getPivotCellValueAndFormat(pivotCell.measure, pivotCell.domain));
                        break;
                }
            }
        }
        if (visibilityOptions.displayColumnHeaders || visibilityOptions.displayMeasuresRow) {
            result[0][0] = { value: pivotTitle };
        }
        return result;
    },
};
//--------------------------------------------------------------------------
// OFFSET
//--------------------------------------------------------------------------
const OFFSET = {
    description: _t$1("Returns a range reference shifted by a specified number of rows and columns from a starting cell reference."),
    args: [
        arg("cell_reference (meta, range<meta>)", _t$1("The starting point from which to count the offset rows and columns.")),
        arg("offset_rows (number)", _t$1("The number of rows to offset by.")),
        arg("offset_columns (number)", _t$1("The number of columns to offset by.")),
        arg("height (number, default='height of cell_reference')", _t$1("The number of rows of the range to return starting at the offset target.")),
        arg("width (number, default='width of cell_reference')", _t$1("The number of columns of the range to return starting at the offset target.")),
    ],
    compute: function (cellReference, offsetRows, offsetColumns, height, width) {
        if (isEvaluationError(cellReference[0][0].value)) {
            return cellReference[0][0];
        }
        const ref0 = cellReference[0][0].value;
        if (!ref0) {
            return new EvaluationError("In this context, the function OFFSET needs to have a cell or range in parameter.");
        }
        const zone = toZone(ref0);
        let offsetHeight = cellReference[0].length;
        let offsetWidth = cellReference.length;
        if (height) {
            const _height = toNumber(height, this.locale);
            if (_height < 1) {
                return new EvaluationError(_t$1("Height value is %(_height)s. It should be greater than or equal to 1.", { _height }));
            }
            offsetHeight = _height;
        }
        if (width) {
            const _width = toNumber(width, this.locale);
            if (_width < 1) {
                return new EvaluationError(_t$1("Width value is %(_width)s. It should be greater than or equal to 1.", { _width }));
            }
            offsetWidth = _width;
        }
        const { sheetName } = splitReference(ref0);
        const sheetId = (sheetName && this.getters.getSheetIdByName(sheetName)) || this.getters.getActiveSheetId();
        const _offsetRows = toNumber(offsetRows, this.locale);
        const _offsetColumns = toNumber(offsetColumns, this.locale);
        const originPosition = this.__originCellPosition;
        if (originPosition) {
            this.updateDependencies?.(originPosition);
        }
        const startingCol = zone.left + _offsetColumns;
        const startingRow = zone.top + _offsetRows;
        if (startingCol < 0 || startingRow < 0) {
            return new InvalidReferenceError(_t$1("OFFSET evaluates to an out of bounds range."));
        }
        const dependencyZone = {
            left: startingCol,
            top: startingRow,
            right: startingCol + offsetWidth - 1,
            bottom: startingRow + offsetHeight - 1,
        };
        const range = this.getters.getRangeFromZone(sheetId, dependencyZone);
        if (range.invalidXc || range.invalidSheetName) {
            return new InvalidReferenceError();
        }
        if (originPosition) {
            this.addDependencies?.(originPosition, [range]);
        }
        return generateMatrix(offsetWidth, offsetHeight, (col, row) => this.getters.getEvaluatedCell({
            sheetId,
            col: startingCol + col,
            row: startingRow + row,
        }));
    },
};

var lookup = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ADDRESS: ADDRESS,
    COLUMN: COLUMN,
    COLUMNS: COLUMNS,
    HLOOKUP: HLOOKUP,
    INDEX: INDEX,
    INDIRECT: INDIRECT,
    LOOKUP: LOOKUP,
    MATCH: MATCH,
    OFFSET: OFFSET,
    PIVOT: PIVOT,
    PIVOT_HEADER: PIVOT_HEADER,
    PIVOT_VALUE: PIVOT_VALUE,
    ROW: ROW,
    ROWS: ROWS,
    VLOOKUP: VLOOKUP,
    XLOOKUP: XLOOKUP
});

// -----------------------------------------------------------------------------
// ADD
// -----------------------------------------------------------------------------
const ADD = {
    description: _t$1("Sum of two numbers."),
    args: [
        arg("value1 (number)", _t$1("The first addend.")),
        arg("value2 (number)", _t$1("The second addend.")),
    ],
    compute: function (value1, value2) {
        return {
            value: toNumber(value1, this.locale) + toNumber(value2, this.locale),
            format: value1?.format || value2?.format,
        };
    },
};
// -----------------------------------------------------------------------------
// CONCAT
// -----------------------------------------------------------------------------
const CONCAT = {
    description: _t$1("Concatenation of two values."),
    args: [
        arg("value1 (string)", _t$1("The value to which value2 will be appended.")),
        arg("value2 (string)", _t$1("The value to append to value1.")),
    ],
    compute: function (value1, value2) {
        return toString(value1) + toString(value2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DIVIDE
// -----------------------------------------------------------------------------
const DIVIDE = {
    description: _t$1("One number divided by another."),
    args: [
        arg("dividend (number)", _t$1("The number to be divided.")),
        arg("divisor (number)", _t$1("The number to divide by.")),
    ],
    compute: function (dividend, divisor) {
        const _divisor = toNumber(divisor, this.locale);
        if (_divisor === 0) {
            return new DivisionByZeroError(_t$1("The divisor must be different from zero."));
        }
        return {
            value: toNumber(dividend, this.locale) / _divisor,
            format: dividend?.format || divisor?.format,
        };
    },
};
// -----------------------------------------------------------------------------
// EQ
// -----------------------------------------------------------------------------
function isEmpty(data) {
    return data === undefined || data.value === null;
}
const getNeutral = { number: 0, string: "", boolean: false };
function areAlmostEqual(value1, value2, epsilon = 2e-16) {
    return Math.abs(value1 - value2) < epsilon;
}
const EQ = {
    description: _t$1("Equal."),
    args: [
        arg("value1 (string, number, boolean)", _t$1("The first value.")),
        arg("value2 (string, number, boolean)", _t$1("The value to test against value1 for equality.")),
    ],
    compute: function (value1, value2) {
        if (isEvaluationError(value1?.value)) {
            return value1;
        }
        if (isEvaluationError(value2?.value)) {
            return value2;
        }
        let _value1 = isEmpty(value1) ? getNeutral[typeof value2?.value] : value1?.value;
        let _value2 = isEmpty(value2) ? getNeutral[typeof value1?.value] : value2?.value;
        if (typeof _value1 === "string") {
            _value1 = _value1.toUpperCase();
        }
        if (typeof _value2 === "string") {
            _value2 = _value2.toUpperCase();
        }
        if (typeof _value1 === "number" && typeof _value2 === "number") {
            return { value: areAlmostEqual(_value1, _value2) };
        }
        return { value: _value1 === _value2 };
    },
};
// -----------------------------------------------------------------------------
// GT
// -----------------------------------------------------------------------------
function applyRelationalOperator(value1, value2, cb) {
    if (isEvaluationError(value1?.value)) {
        return value1;
    }
    if (isEvaluationError(value2?.value)) {
        return value2;
    }
    let _value1 = isEmpty(value1) ? getNeutral[typeof value2?.value] : value1?.value;
    let _value2 = isEmpty(value2) ? getNeutral[typeof value1?.value] : value2?.value;
    if (typeof _value1 !== "number") {
        _value1 = toString(_value1).toUpperCase();
    }
    if (typeof _value2 !== "number") {
        _value2 = toString(_value2).toUpperCase();
    }
    const tV1 = typeof _value1;
    const tV2 = typeof _value2;
    if (tV1 === "string" && tV2 === "number") {
        return { value: true };
    }
    if (tV2 === "string" && tV1 === "number") {
        return { value: false };
    }
    return { value: cb(_value1, _value2) };
}
const GT = {
    description: _t$1("Strictly greater than."),
    args: [
        arg("value1 (number, string, boolean)", _t$1("The value to test as being greater than value2.")),
        arg("value2 (number, string, boolean)", _t$1("The second value.")),
    ],
    compute: function (value1, value2) {
        return applyRelationalOperator(value1, value2, (v1, v2) => {
            if (typeof v1 === "number" && typeof v2 === "number") {
                return !areAlmostEqual(v1, v2) && v1 > v2;
            }
            return v1 > v2;
        });
    },
};
// -----------------------------------------------------------------------------
// GTE
// -----------------------------------------------------------------------------
const GTE = {
    description: _t$1("Greater than or equal to."),
    args: [
        arg("value1 (number, string, boolean)", _t$1("The value to test as being greater than or equal to value2.")),
        arg("value2 (number, string, boolean)", _t$1("The second value.")),
    ],
    compute: function (value1, value2) {
        return applyRelationalOperator(value1, value2, (v1, v2) => {
            if (typeof v1 === "number" && typeof v2 === "number") {
                return areAlmostEqual(v1, v2) || v1 > v2;
            }
            return v1 >= v2;
        });
    },
};
// -----------------------------------------------------------------------------
// LT
// -----------------------------------------------------------------------------
const LT = {
    description: _t$1("Less than."),
    args: [
        arg("value1 (number, string, boolean)", _t$1("The value to test as being less than value2.")),
        arg("value2 (number, string, boolean)", _t$1("The second value.")),
    ],
    compute: function (value1, value2) {
        const result = GTE.compute.bind(this)(value1, value2);
        if (isEvaluationError(result.value)) {
            return result;
        }
        return { value: !result.value };
    },
};
// -----------------------------------------------------------------------------
// LTE
// -----------------------------------------------------------------------------
const LTE = {
    description: _t$1("Less than or equal to."),
    args: [
        arg("value1 (number, string, boolean)", _t$1("The value to test as being less than or equal to value2.")),
        arg("value2 (number, string, boolean)", _t$1("The second value.")),
    ],
    compute: function (value1, value2) {
        const result = GT.compute.bind(this)(value1, value2);
        if (isEvaluationError(result.value)) {
            return result;
        }
        return { value: !result.value };
    },
};
// -----------------------------------------------------------------------------
// MINUS
// -----------------------------------------------------------------------------
const MINUS = {
    description: _t$1("Difference of two numbers."),
    args: [
        arg("value1 (number)", _t$1("The minuend, or number to be subtracted from.")),
        arg("value2 (number)", _t$1("The subtrahend, or number to subtract from value1.")),
    ],
    compute: function (value1, value2) {
        return {
            value: toNumber(value1, this.locale) - toNumber(value2, this.locale),
            format: value1?.format || value2?.format,
        };
    },
};
// -----------------------------------------------------------------------------
// MULTIPLY
// -----------------------------------------------------------------------------
const MULTIPLY = {
    description: _t$1("Product of two numbers"),
    args: [
        arg("factor1 (number)", _t$1("The first multiplicand.")),
        arg("factor2 (number)", _t$1("The second multiplicand.")),
    ],
    compute: function (factor1, factor2) {
        return {
            value: toNumber(factor1, this.locale) * toNumber(factor2, this.locale),
            format: factor1?.format || factor2?.format,
        };
    },
};
// -----------------------------------------------------------------------------
// NE
// -----------------------------------------------------------------------------
const NE = {
    description: _t$1("Not equal."),
    args: [
        arg("value1 (string, number, boolean)", _t$1("The first value.")),
        arg("value2 (string, number, boolean)", _t$1("The value to test against value1 for inequality.")),
    ],
    compute: function (value1, value2) {
        const result = EQ.compute.bind(this)(value1, value2);
        if (isEvaluationError(result.value)) {
            return result;
        }
        return { value: !result.value };
    },
};
// -----------------------------------------------------------------------------
// POW
// -----------------------------------------------------------------------------
const POW = {
    description: _t$1("A number raised to a power."),
    args: [
        arg("base (number)", _t$1("The number to raise to the exponent power.")),
        arg("exponent (number)", _t$1("The exponent to raise base to.")),
    ],
    compute: function (base, exponent) {
        return POWER.compute.bind(this)(base, exponent);
    },
};
// -----------------------------------------------------------------------------
// UMINUS
// -----------------------------------------------------------------------------
const UMINUS = {
    description: _t$1("A number with the sign reversed."),
    args: [
        arg("value (number)", _t$1("The number to have its sign reversed. Equivalently, the number to multiply by -1.")),
    ],
    compute: function (value) {
        return {
            value: -toNumber(value, this.locale),
            format: value?.format,
        };
    },
};
// -----------------------------------------------------------------------------
// UNARY_PERCENT
// -----------------------------------------------------------------------------
const UNARY_PERCENT = {
    description: _t$1("Value interpreted as a percentage."),
    args: [arg("percentage (number)", _t$1("The value to interpret as a percentage."))],
    compute: function (percentage) {
        return toNumber(percentage, this.locale) / 100;
    },
};
// -----------------------------------------------------------------------------
// UPLUS
// -----------------------------------------------------------------------------
const UPLUS = {
    description: _t$1("A specified number, unchanged."),
    args: [arg("value (any)", _t$1("The number to return."))],
    compute: function (value = { value: null }) {
        return value;
    },
};

var operators = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ADD: ADD,
    CONCAT: CONCAT,
    DIVIDE: DIVIDE,
    EQ: EQ,
    GT: GT,
    GTE: GTE,
    LT: LT,
    LTE: LTE,
    MINUS: MINUS,
    MULTIPLY: MULTIPLY,
    NE: NE,
    POW: POW,
    UMINUS: UMINUS,
    UNARY_PERCENT: UNARY_PERCENT,
    UPLUS: UPLUS
});

const transformFromFactor = (factor) => ({
    transform: (x) => x * factor,
    inverseTransform: (x) => x / factor,
});
const standard = { transform: (x) => x, inverseTransform: (x) => x };
const ANG2M = 1e-10;
const IN2M = 0.0254;
const PICAPT2M = IN2M / 72;
const FT2M = 0.3048;
const YD2M = 0.9144;
const MI2M = 1609.34;
const NMI2M = 1852;
const LY2M = 9.46073047258e15;
const UNITS = {
    // WEIGHT UNITs : Standard = gramme
    g: { ...standard, category: "weight" },
    u: { ...transformFromFactor(1.66053e-24), category: "weight" },
    grain: { ...transformFromFactor(0.0647989), category: "weight" },
    ozm: { ...transformFromFactor(28.3495), category: "weight" },
    lbm: { ...transformFromFactor(453.592), category: "weight" },
    stone: { ...transformFromFactor(6350.29), category: "weight" },
    sg: { ...transformFromFactor(14593.90294), category: "weight" },
    cwt: { ...transformFromFactor(45359.237), category: "weight" },
    uk_cwt: { ...transformFromFactor(50802.3), category: "weight" },
    ton: { ...transformFromFactor(907184.74), category: "weight" },
    uk_ton: { ...transformFromFactor(1016046.9), category: "weight" },
    // DISTANCE UNITS : Standard = meter
    m: { ...standard, category: "distance" },
    km: { ...transformFromFactor(1000), category: "distance" },
    ang: { ...transformFromFactor(ANG2M), category: "distance" },
    Picapt: { ...transformFromFactor(PICAPT2M), category: "distance" },
    pica: { ...transformFromFactor(IN2M / 6), category: "distance" },
    in: { ...transformFromFactor(IN2M), category: "distance" },
    ft: { ...transformFromFactor(FT2M), category: "distance" },
    yd: { ...transformFromFactor(YD2M), category: "distance" },
    ell: { ...transformFromFactor(1.143), category: "distance" },
    mi: { ...transformFromFactor(MI2M), category: "distance" },
    survey_mi: { ...transformFromFactor(1609.34), category: "distance" },
    Nmi: { ...transformFromFactor(NMI2M), category: "distance" },
    ly: { ...transformFromFactor(LY2M), category: "distance" },
    parsec: { ...transformFromFactor(3.0856775814914e16), category: "distance" },
    // TIME UNITS : Standard = second
    sec: { ...standard, category: "time" },
    min: { ...transformFromFactor(60), category: "time" },
    hr: { ...transformFromFactor(3600), category: "time" },
    day: { ...transformFromFactor(86400), category: "time" },
    yr: { ...transformFromFactor(31556952), category: "time" },
    // PRESSURE UNITS : Standard = Pascal
    Pa: { ...standard, category: "pressure" },
    bar: { ...transformFromFactor(100000), category: "pressure" },
    mmHg: { ...transformFromFactor(133.322), category: "pressure" },
    Torr: { ...transformFromFactor(133.322), category: "pressure" },
    psi: { ...transformFromFactor(6894.76), category: "pressure" },
    atm: { ...transformFromFactor(101325), category: "pressure" },
    // FORCE UNITS : Standard = Newton
    N: { ...standard, category: "force" },
    dyn: { ...transformFromFactor(1e-5), category: "force" },
    pond: { ...transformFromFactor(0.00980665), category: "force" },
    lbf: { ...transformFromFactor(4.44822), category: "force" },
    // ENERGY UNITS : Standard = Joule
    J: { ...standard, category: "energy" },
    eV: { ...transformFromFactor(1.60218e-19), category: "energy" },
    e: { ...transformFromFactor(1e-7), category: "energy" },
    flb: { ...transformFromFactor(1.3558179483), category: "energy" },
    c: { ...transformFromFactor(4.184), category: "energy" },
    cal: { ...transformFromFactor(4.1868), category: "energy" },
    BTU: { ...transformFromFactor(1055.06), category: "energy" },
    Wh: { ...transformFromFactor(3600), category: "energy" },
    HPh: { ...transformFromFactor(2684520), category: "energy" },
    // POWER UNITS : Standard = Watt
    W: { ...standard, category: "power" },
    PS: { ...transformFromFactor(735.499), category: "power" },
    HP: { ...transformFromFactor(745.7), category: "power" },
    // MAGNETISM UNITS : Standard = Tesla
    T: { ...standard, category: "magnetism" },
    ga: { ...transformFromFactor(1e-4), category: "magnetism" },
    // TEMPERATURE UNITS : Standard = Kelvin
    K: { ...standard, category: "temperature" },
    C: {
        transform: (T) => T + 273.15,
        inverseTransform: (T) => T - 273.15,
        category: "temperature",
    },
    F: {
        transform: (T) => ((T - 32) * 5) / 9 + 273.15,
        inverseTransform: (T) => ((T - 273.15) * 9) / 5 + 32,
        category: "temperature",
    },
    Rank: { ...transformFromFactor(5 / 9), category: "temperature" },
    Reau: {
        transform: (T) => T * 1.25 + 273.15,
        inverseTransform: (T) => (T - 273.15) / 1.25,
        category: "temperature",
    },
    // VOLUME UNITS : Standard = cubic meter
    "m^3": { ...standard, category: "volume", order: 3 },
    "ang^3": { ...transformFromFactor(Math.pow(ANG2M, 3)), category: "volume", order: 3 },
    "Picapt^3": { ...transformFromFactor(Math.pow(PICAPT2M, 3)), category: "volume", order: 3 },
    tsp: { ...transformFromFactor(4.92892e-6), category: "volume" },
    tspm: { ...transformFromFactor(5e-6), category: "volume" },
    tbs: { ...transformFromFactor(1.4786764825785619e-5), category: "volume" },
    "in^3": { ...transformFromFactor(Math.pow(IN2M, 3)), category: "volume", order: 3 },
    oz: { ...transformFromFactor(2.95735295625e-5), category: "volume" },
    cup: { ...transformFromFactor(0.000237), category: "volume" },
    pt: { ...transformFromFactor(0.0004731765), category: "volume" },
    uk_pt: { ...transformFromFactor(0.000568261), category: "volume" },
    qt: { ...transformFromFactor(0.0009463529), category: "volume" },
    l: { ...transformFromFactor(1e-3), category: "volume" },
    uk_qt: { ...transformFromFactor(0.0011365225), category: "volume" },
    gal: { ...transformFromFactor(0.0037854118), category: "volume" },
    uk_gal: { ...transformFromFactor(0.00454609), category: "volume" },
    "ft^3": { ...transformFromFactor(Math.pow(FT2M, 3)), category: "volume", order: 3 },
    bushel: { ...transformFromFactor(0.0352390704), category: "volume" },
    barrel: { ...transformFromFactor(0.158987295), category: "volume" },
    "yd^3": { ...transformFromFactor(Math.pow(YD2M, 3)), category: "volume", order: 3 },
    MTON: { ...transformFromFactor(1.13267386368), category: "volume" },
    GRT: { ...transformFromFactor(2.83168), category: "volume" },
    "mi^3": { ...transformFromFactor(Math.pow(MI2M, 3)), category: "volume", order: 3 },
    "Nmi^3": { ...transformFromFactor(Math.pow(NMI2M, 3)), category: "volume", order: 3 },
    "ly^3": { ...transformFromFactor(Math.pow(LY2M, 3)), category: "volume", order: 3 },
    // AREA UNITS : Standard = square meter
    "m^2": { ...standard, category: "area", order: 2 },
    "ang^2": { ...transformFromFactor(Math.pow(ANG2M, 2)), category: "area", order: 2 },
    "Picapt^2": { ...transformFromFactor(Math.pow(PICAPT2M, 2)), category: "area", order: 2 },
    "in^2": { ...transformFromFactor(Math.pow(IN2M, 2)), category: "area", order: 2 },
    "ft^2": { ...transformFromFactor(Math.pow(FT2M, 2)), category: "area", order: 2 },
    "yd^2": { ...transformFromFactor(Math.pow(YD2M, 2)), category: "area", order: 2 },
    ar: { ...transformFromFactor(100), category: "area" },
    Morgen: { ...transformFromFactor(2500), category: "area" },
    uk_acre: { ...transformFromFactor(4046.8564224), category: "area" },
    us_acre: { ...transformFromFactor(4046.8726098743), category: "area" },
    ha: { ...transformFromFactor(1e4), category: "area" },
    "mi^2": { ...transformFromFactor(Math.pow(MI2M, 2)), category: "area", order: 2 },
    "Nmi^2": { ...transformFromFactor(Math.pow(NMI2M, 2)), category: "area", order: 2 },
    "ly^2": { ...transformFromFactor(Math.pow(LY2M, 2)), category: "area", order: 2 },
    // INFORMATION UNITS : Standard = bit
    bit: { ...standard, category: "information" },
    byte: { ...transformFromFactor(8), category: "information" },
    // SPEED UNITS : Standard = m/s
    "m/s": { ...standard, category: "speed" },
    "m/hr": { ...transformFromFactor(1 / 3600), category: "speed" },
    "km/hr": { ...transformFromFactor(1 / 3.6), category: "speed" },
    mph: { ...transformFromFactor(0.44704), category: "speed" },
    kn: { ...transformFromFactor(0.5144444444), category: "speed" },
    admkn: { ...transformFromFactor(0.5147733333), category: "speed" },
};
const UNITS_ALIASES = {
    shweight: "cwt",
    lcwt: "uk_cwt",
    hweight: "uk_cwt",
    LTON: "uk_ton",
    brton: "uk_ton",
    pc: "parsec",
    Pica: "Picapt",
    d: "day",
    mn: "min",
    s: "sec",
    p: "Pa",
    at: "atm",
    dy: "dyn",
    ev: "eV",
    hh: "HPh",
    wh: "Wh",
    btu: "BTU",
    h: "HP",
    cel: "C",
    fah: "F",
    kel: "K",
    us_pt: "pt",
    L: "l",
    lt: "l",
    ang3: "ang^3",
    ft3: "ft^3",
    in3: "in^3",
    ly3: "ly^3",
    m3: "m^3",
    mi3: "mi^3",
    yd3: "yd^3",
    Nmi3: "Nmi^3",
    Picapt3: "Picapt^3",
    "Pica^3": "Picapt^3",
    Pica3: "Picapt^3",
    regton: "GRT",
    ang2: "ang^2",
    ft2: "ft^2",
    in2: "in^2",
    ly2: "ly^2",
    m2: "m^2",
    mi2: "mi^2",
    Nmi2: "Nmi^2",
    Picapt2: "Picapt^2",
    "Pica^2": "Picapt^2",
    Pica2: "Picapt^2",
    yd2: "yd^2",
    "m/h": "m/hr",
    "m/sec": "m/s",
};
const UNIT_PREFIXES = {
    "": 1,
    Y: 1e24,
    Z: 1e21,
    E: 1e18,
    P: 1e15,
    T: 1e12,
    G: 1e9,
    M: 1e6,
    k: 1e3,
    h: 1e2,
    da: 1e1,
    e: 1e1,
    d: 1e-1,
    c: 1e-2,
    m: 1e-3,
    u: 1e-6,
    n: 1e-9,
    p: 1e-12,
    f: 1e-15,
    a: 1e-18,
    z: 1e-21,
    y: 1e-21,
    Yi: Math.pow(2, 80),
    Zi: Math.pow(2, 70),
    Ei: Math.pow(2, 60),
    Pi: Math.pow(2, 50),
    Ti: Math.pow(2, 40),
    Gi: Math.pow(2, 30),
    Mi: Math.pow(2, 20),
    ki: Math.pow(2, 10),
};
const TRANSLATED_CATEGORIES = {
    weight: _t$1("Weight"),
    distance: _t$1("Distance"),
    time: _t$1("Time"),
    pressure: _t$1("Pressure"),
    force: _t$1("Force"),
    energy: _t$1("Energy"),
    power: _t$1("Power"),
    magnetism: _t$1("Magnetism"),
    temperature: _t$1("Temperature"),
    volume: _t$1("Volume"),
    area: _t$1("Area"),
    information: _t$1("Information"),
    speed: _t$1("Speed"),
};
const UNIT_OPTIONS = Object.entries(UNITS).map(([key, value]) => ({
    value: key,
    label: getTranslatedCategory(value.category),
}));
function getTranslatedCategory(key) {
    return TRANSLATED_CATEGORIES[key] ?? "";
}
function getTransformation(key) {
    for (const [prefix, value] of Object.entries(UNIT_PREFIXES)) {
        if (prefix && !key.startsWith(prefix))
            continue;
        const _key = key.slice(prefix.length);
        let conversion = UNITS[_key];
        if (!conversion && UNITS_ALIASES[_key]) {
            conversion = UNITS[UNITS_ALIASES[_key]];
        }
        if (conversion) {
            return {
                ...conversion,
                factor: conversion.order ? Math.pow(value, conversion.order) : value,
            };
        }
    }
    return;
}

// -----------------------------------------------------------------------------
// CONVERT
// -----------------------------------------------------------------------------
const CONVERT = {
    description: _t$1("Converts a numeric value to a different unit of measure."),
    args: [
        arg("value (number)", _t$1("the numeric value in start_unit to convert to end_unit")),
        arg("start_unit (string)", _t$1("The starting unit, the unit currently assigned to value"), UNIT_OPTIONS),
        arg("end_unit (string)", _t$1("The unit of measure into which to convert value"), UNIT_OPTIONS),
    ],
    compute: function (value, startUnit, endUnit) {
        const _value = toNumber(value, this.locale);
        const _startUnit = toString(startUnit);
        const _endUnit = toString(endUnit);
        const startConversion = getTransformation(_startUnit);
        const endConversion = getTransformation(_endUnit);
        if (!startConversion) {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("Invalid units of measure ('%s')", _startUnit),
            };
        }
        if (!endConversion) {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("Invalid units of measure ('%s')", _endUnit),
            };
        }
        if (startConversion.category !== endConversion.category) {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("Incompatible units of measure ('%s' vs '%s')", getTranslatedCategory(startConversion.category), getTranslatedCategory(endConversion.category)),
            };
        }
        return {
            value: endConversion.inverseTransform(startConversion.factor * startConversion.transform(_value)) /
                endConversion.factor,
            format: value?.format,
        };
    },
    isExported: true,
};

var parser = /*#__PURE__*/Object.freeze({
    __proto__: null,
    CONVERT: CONVERT
});

const DEFAULT_STARTING_AT = 1;
/** Regex matching all the words in a string */
const wordRegex = /[A-Za-zÀ-ÖØ-öø-ÿ]+/g;
const MATCH_MODE_OPTIONS = [
    { value: 0, label: _t$1("Case-sensitive (default)") },
    { value: 1, label: _t$1("Case-insensitive") },
];
const MATCH_END_OPTIONS = [
    { value: 0, label: _t$1("Don't match to end (default)") },
    { value: 1, label: _t$1("Match to end") },
];
// -----------------------------------------------------------------------------
// CHAR
// -----------------------------------------------------------------------------
const CHAR = {
    description: _t$1("Gets character associated with number."),
    args: [
        arg("table_number (number)", _t$1("The number of the character to look up from the current Unicode table in decimal format.")),
    ],
    compute: function (tableNumber) {
        const _tableNumber = Math.trunc(toNumber(tableNumber, this.locale));
        if (_tableNumber < 1) {
            return new EvaluationError(_t$1("The table_number (%s) is out of range.", _tableNumber));
        }
        return String.fromCharCode(_tableNumber);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CLEAN
// -----------------------------------------------------------------------------
const CLEAN = {
    description: _t$1("Remove non-printable characters from a piece of text."),
    args: [arg("text (string)", _t$1("The text whose non-printable characters are to be removed."))],
    compute: function (text) {
        const _text = toString(text);
        let cleanedStr = "";
        for (const char of _text) {
            if (char && char.charCodeAt(0) > 31) {
                cleanedStr += char;
            }
        }
        return cleanedStr;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CONCATENATE
// -----------------------------------------------------------------------------
const CONCATENATE = {
    description: _t$1("Appends strings to one another."),
    args: [
        arg("string1 (string, range<string>)", _t$1("The initial string.")),
        arg("string2 (string, range<string>, repeating)", _t$1("More strings to append in sequence.")),
    ],
    compute: function (...datas) {
        return reduceAny(datas, (acc, a) => acc + toString(a), "");
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EXACT
// -----------------------------------------------------------------------------
const EXACT = {
    description: _t$1("Tests whether two strings are identical."),
    args: [
        arg("string1 (string)", _t$1("The first string to compare.")),
        arg("string2 (string)", _t$1("The second string to compare.")),
    ],
    compute: function (string1, string2) {
        return toString(string1) === toString(string2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FIND
// -----------------------------------------------------------------------------
const FIND = {
    description: _t$1("First position of string found in text, case-sensitive."),
    args: [
        arg("search_for (string)", _t$1("The string to look for within text_to_search.")),
        arg("text_to_search (string)", _t$1("The text to search for the first occurrence of search_for.")),
        arg(`starting_at (number, default=${DEFAULT_STARTING_AT})`, _t$1("The character within text_to_search at which to start the search.")),
    ],
    compute: function (searchFor, textToSearch, startingAt = { value: DEFAULT_STARTING_AT }) {
        const _searchFor = toString(searchFor);
        const _textToSearch = toString(textToSearch);
        const _startingAt = toNumber(startingAt, this.locale);
        if (_textToSearch === "") {
            return new EvaluationError(_t$1("The text_to_search must be non-empty."));
        }
        if (_startingAt < 1) {
            return new EvaluationError(_t$1("The starting_at (%s) must be greater than or equal to 1.", _startingAt));
        }
        const result = _textToSearch.indexOf(_searchFor, _startingAt - 1);
        if (result === -1) {
            return new EvaluationError(_t$1("In [[FUNCTION_NAME]] evaluation, cannot find '%s' within '%s'.", _searchFor, _textToSearch));
        }
        return result + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// JOIN
// -----------------------------------------------------------------------------
const JOIN = {
    description: _t$1("Concatenates elements of arrays with delimiter."),
    args: [
        arg("delimiter (string)", _t$1("The character or string to place between each concatenated value.")),
        arg("value_or_array1 (string, range<string>)", _t$1("The value or values to be appended using delimiter.")),
        arg("value_or_array2 (string, range<string>, repeating)", _t$1("More values to be appended using delimiter.")),
    ],
    compute: function (delimiter, ...valuesOrArrays) {
        const _delimiter = toString(delimiter);
        return reduceAny(valuesOrArrays, (acc, a) => (acc ? acc + _delimiter : "") + toString(a), "");
    },
};
// -----------------------------------------------------------------------------
// LEFT
// -----------------------------------------------------------------------------
const LEFT = {
    description: _t$1("Substring from beginning of specified string."),
    args: [
        arg("text (string)", _t$1("The string from which the left portion will be returned.")),
        arg("number_of_characters (number, optional)", _t$1("The number of characters to return from the left side of string.")),
    ],
    compute: function (text, ...args) {
        const _numberOfCharacters = args.length ? toNumber(args[0], this.locale) : 1;
        if (_numberOfCharacters < 0) {
            return new EvaluationError(_t$1("The number_of_characters (%s) must be positive or null.", _numberOfCharacters));
        }
        return toString(text).substring(0, _numberOfCharacters);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LEN
// -----------------------------------------------------------------------------
const LEN = {
    description: _t$1("Length of a string."),
    args: [arg("text (string)", _t$1("The string whose length will be returned."))],
    compute: function (text) {
        return toString(text).length;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOWER
// -----------------------------------------------------------------------------
const LOWER = {
    description: _t$1("Converts a specified string to lowercase."),
    args: [arg("text (string)", _t$1("The string to convert to lowercase."))],
    compute: function (text) {
        return toString(text).toLowerCase();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MID
// -----------------------------------------------------------------------------
const MID = {
    description: _t$1("A segment of a string."),
    args: [
        arg("text (string)", _t$1("The string to extract a segment from.")),
        arg("starting_at (number)", _t$1("The index from the left of string from which to begin extracting. The first character in string has the index 1.")),
        arg("extract_length (number)", _t$1("The length of the segment to extract.")),
    ],
    compute: function (text, starting_at, extract_length) {
        const _text = toString(text);
        const _starting_at = toNumber(starting_at, this.locale);
        const _extract_length = toNumber(extract_length, this.locale);
        if (_starting_at < 1) {
            return new EvaluationError(_t$1("The starting_at argument (%s) must be positive greater than one.", _starting_at.toString()));
        }
        if (_extract_length < 0) {
            return new EvaluationError(_t$1("The extract_length argument (%s) must be positive or null.", _extract_length));
        }
        return _text.slice(_starting_at - 1, _starting_at + _extract_length - 1);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PROPER
// -----------------------------------------------------------------------------
const PROPER = {
    description: _t$1("Capitalizes each word in a specified string."),
    args: [
        arg("text_to_capitalize (string)", _t$1("The text which will be returned with the first letter of each word in uppercase and all other letters in lowercase.")),
    ],
    compute: function (text) {
        const _text = toString(text);
        return _text.replace(wordRegex, (word) => {
            return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
        });
    },
    isExported: true,
};
const REGEXEXTRACT_DEFAULT_MODE = 0;
const REGEXEXTRACT_DEFAULT_CASE_SENSITIVITY = 0;
// -----------------------------------------------------------------------------
// REGEXEXTRACT
// -----------------------------------------------------------------------------
const REGEXEXTRACT = {
    description: _t$1("Extract text from a string based on the supplied regular expression."),
    args: [
        arg("text (string)", _t$1("The string on which you want to extract text.")),
        arg("pattern (string)", _t$1("The regular expression pattern to match against the text.")),
        arg(`return_mode (number, default=${REGEXEXTRACT_DEFAULT_MODE})`, _t$1("0 = first match, 1 = all matches as an array, 2 = capturing groups from the first match as an array."), [
            { value: 0, label: _t$1("First match") },
            { value: 1, label: _t$1("All matches") },
            { value: 2, label: _t$1("Capture groups of first match") },
        ]),
        arg(`case_sensitivity (number, default=${REGEXEXTRACT_DEFAULT_CASE_SENSITIVITY})`, _t$1("Whether the match is case-sensitive."), [
            { value: 0, label: _t$1("Case-sensitive") },
            { value: 1, label: _t$1("Case-insensitive") },
        ]),
    ],
    compute: function (text, pattern, return_mode = { value: REGEXEXTRACT_DEFAULT_MODE }, newText = { value: REGEXEXTRACT_DEFAULT_CASE_SENSITIVITY }) {
        const _text = toString(text);
        const _pattern = toString(pattern);
        const _returnMode = toNumber(return_mode, this.locale);
        const _caseSensitivity = toNumber(newText, this.locale);
        if (_text === "" || _pattern === "") {
            return { value: "" };
        }
        if (_returnMode < 0 || _returnMode > 2) {
            return new EvaluationError(_t$1("The return_mode (%s) must be 0, 1 or 2.", _returnMode));
        }
        if (_caseSensitivity !== 0 && _caseSensitivity !== 1) {
            return new EvaluationError(_t$1("The case_sensitivity (%s) must be 0 or 1.", _caseSensitivity));
        }
        const flags = _caseSensitivity === 1 ? "gi" : "g";
        const regex = new RegExp(_pattern, flags);
        const matches = [..._text.matchAll(regex)];
        if (matches.length === 0) {
            return { value: CellErrorType$1.NotAvailable, message: _t$1("No matches found.") };
        }
        if (_returnMode === 0) {
            return matches[0][0];
        }
        else if (_returnMode === 1) {
            return matches.map((match) => [match[0]]);
        }
        else {
            if (matches[0].length < 2) {
                return new EvaluationError(_t$1("No capturing groups found."));
            }
            return matches[0].slice(1).map((s) => [s]);
        }
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// REPLACE
// -----------------------------------------------------------------------------
const REPLACE = {
    description: _t$1("Replaces part of a text string with different text."),
    args: [
        arg("text (string)", _t$1("The text, a part of which will be replaced.")),
        arg("position (number)", _t$1("The position where the replacement will begin (starting from 1).")),
        arg("length (number)", _t$1("The number of characters in the text to be replaced.")),
        arg("new_text (string)", _t$1("The text which will be inserted into the original text.")),
    ],
    compute: function (text, position, length, newText) {
        const _position = toNumber(position, this.locale);
        if (_position < 1) {
            return new EvaluationError(_t$1("The position (%s) must be greater than or equal to 1.", _position));
        }
        const _text = toString(text);
        const _length = toNumber(length, this.locale);
        const _newText = toString(newText);
        return _text.substring(0, _position - 1) + _newText + _text.substring(_position - 1 + _length);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RIGHT
// -----------------------------------------------------------------------------
const RIGHT = {
    description: _t$1("A substring from the end of a specified string."),
    args: [
        arg("text (string)", _t$1("The string from which the right portion will be returned.")),
        arg("number_of_characters (number, optional)", _t$1("The number of characters to return from the right side of string.")),
    ],
    compute: function (text, ...args) {
        const _numberOfCharacters = args.length ? toNumber(args[0], this.locale) : 1;
        if (_numberOfCharacters < 0) {
            return new EvaluationError(_t$1("The number_of_characters (%s) must be positive or null.", _numberOfCharacters));
        }
        const _text = toString(text);
        const stringLength = _text.length;
        return _text.substring(stringLength - _numberOfCharacters, stringLength);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SEARCH
// -----------------------------------------------------------------------------
const SEARCH = {
    description: _t$1("First position of string found in text, ignoring case."),
    args: [
        arg("search_for (string)", _t$1("The string to look for within text_to_search.")),
        arg("text_to_search (string)", _t$1("The text to search for the first occurrence of search_for.")),
        arg(`starting_at (number, default=${DEFAULT_STARTING_AT})`, _t$1("The character within text_to_search at which to start the search.")),
    ],
    compute: function (searchFor, textToSearch, startingAt = { value: DEFAULT_STARTING_AT }) {
        const _searchFor = toString(searchFor).toLowerCase();
        const _textToSearch = toString(textToSearch).toLowerCase();
        const _startingAt = toNumber(startingAt, this.locale);
        if (_textToSearch === "") {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("The text_to_search must be non-empty."),
            };
        }
        if (_startingAt < 1) {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("The starting_at (%s) must be greater than or equal to 1.", _startingAt),
            };
        }
        const result = _textToSearch.indexOf(_searchFor, _startingAt - 1);
        if (result === -1) {
            return {
                value: CellErrorType$1.GenericError,
                message: _t$1("In [[FUNCTION_NAME]] evaluation, cannot find '%s' within '%s'.", _searchFor, _textToSearch),
            };
        }
        return { value: result + 1 };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SPLIT
// -----------------------------------------------------------------------------
const SPLIT_DEFAULT_SPLIT_BY_EACH = true;
const SPLIT_DEFAULT_REMOVE_EMPTY_TEXT = true;
const SPLIT = {
    description: _t$1("Split text by specific character delimiter(s)."),
    args: [
        arg("text (string)", _t$1("The text to divide.")),
        arg("delimiter (string)", _t$1("The character or characters to use to split text.")),
        arg(`split_by_each (boolean, default=${SPLIT_DEFAULT_SPLIT_BY_EACH}})`, _t$1("Whether or not to divide text around each character contained in delimiter.")),
        arg(`remove_empty_text (boolean, default=${SPLIT_DEFAULT_REMOVE_EMPTY_TEXT})`, _t$1("Whether or not to remove empty text messages from the split results. The default behavior is to treat \
        consecutive delimiters as one (if TRUE). If FALSE, empty cells values are added between consecutive delimiters.")),
    ],
    compute: function (text, delimiter, splitByEach = { value: SPLIT_DEFAULT_SPLIT_BY_EACH }, removeEmptyText = { value: SPLIT_DEFAULT_REMOVE_EMPTY_TEXT }) {
        const _text = toString(text);
        const _delimiter = escapeRegExp$1(toString(delimiter));
        const _splitByEach = toBoolean(splitByEach);
        const _removeEmptyText = toBoolean(removeEmptyText);
        if (_delimiter.length <= 0) {
            return new EvaluationError(_t$1("The delimiter (%s) must be not be empty.", _delimiter));
        }
        const regex = _splitByEach ? new RegExp(`[${_delimiter}]`, "g") : new RegExp(_delimiter, "g");
        let result = _text.split(regex);
        if (_removeEmptyText) {
            result = result.filter((text) => text !== "");
        }
        return transposeMatrix([result]);
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// SUBSTITUTE
// -----------------------------------------------------------------------------
const SUBSTITUTE = {
    description: _t$1("Replaces existing text with new text in a string."),
    args: [
        arg("text_to_search (string)", _t$1("The text within which to search and replace.")),
        arg("search_for (string)", _t$1("The string to search for within text_to_search.")),
        arg("replace_with (string)", _t$1("The string that will replace search_for.")),
        arg("occurrence_number (number, optional)", _t$1("The instance of search_for within text_to_search to replace with replace_with. By default, all occurrences of search_for are replaced; however, if occurrence_number is specified, only the indicated instance of search_for is replaced.")),
    ],
    compute: function (textToSearch, searchFor, replaceWith, occurrenceNumber) {
        const _occurrenceNumber = toNumber(occurrenceNumber, this.locale);
        if (_occurrenceNumber < 0) {
            return new EvaluationError(_t$1("The occurrenceNumber (%s) must be positive or null.", _occurrenceNumber));
        }
        const _textToSearch = toString(textToSearch);
        const _searchFor = toString(searchFor);
        if (_searchFor === "") {
            return _textToSearch;
        }
        const _replaceWith = toString(replaceWith);
        const reg = new RegExp(escapeRegExp$1(_searchFor), "g");
        if (_occurrenceNumber === 0) {
            return _textToSearch.replace(reg, _replaceWith);
        }
        let n = 0;
        return _textToSearch.replace(reg, (text) => (++n === _occurrenceNumber ? _replaceWith : text));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TEXTJOIN
// -----------------------------------------------------------------------------
const TEXTJOIN_DEFAULT_IGNORE_EMPTY = true;
const TEXTJOIN = {
    description: _t$1("Combines text from multiple strings and/or arrays."),
    args: [
        arg("delimiter (string)", _t$1(" A string, possible empty, or a reference to a valid string. If empty, the text will be simply concatenated.")),
        arg("ignore_empty (boolean)", _t$1("A boolean; if TRUE, empty cells selected in the text arguments won't be included in the result."), [
            { value: true, label: _t$1("Ignore empty cells") },
            { value: false, label: _t$1("Include empty cells (default)") },
        ]),
        arg("text1 (string, range<string>)", _t$1("Any text item. This could be a string, or an array of strings in a range.")),
        arg("text2 (string, range<string>, repeating)", _t$1("Additional text item(s).")),
    ],
    compute: function (delimiter, ignoreEmpty = { value: TEXTJOIN_DEFAULT_IGNORE_EMPTY }, ...textsOrArrays) {
        const _delimiter = toString(delimiter);
        const _ignoreEmpty = toBoolean(ignoreEmpty);
        let n = 0;
        return reduceAny(textsOrArrays, (acc, a) => !(_ignoreEmpty && toString(a) === "") ? (n++ ? acc + _delimiter : "") + toString(a) : acc, "");
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TEXTSPLIT
// -----------------------------------------------------------------------------
const TEXTSPLIT_DEFAULT_IGNORE_EMPTY = false;
const TEXTSPLIT_DEFAULT_MATCH_MODE = 0;
const TEXTSPLIT = {
    description: _t$1("Splits text into rows or columns using specified column and row delimiters."),
    args: [
        arg("text (string)", _t$1("The text to split.")),
        arg("col_delimiter (string, range<string>)", _t$1("Character or string to split columns by.")),
        arg("row_delimiter (string, range<string>, optional)", _t$1("Character or string to split rows by.")),
        arg(`ignore_empty (boolean, default=${TEXTSPLIT_DEFAULT_IGNORE_EMPTY})`, _t$1("Whether to ignore empty cells."), [
            { value: false, label: _t$1("Include empty cells (default)") },
            { value: true, label: _t$1("Ignore empty cells") },
        ]),
        arg(`match_mode (number, default=${TEXTSPLIT_DEFAULT_MATCH_MODE})`, _t$1("Searches the text for a delimiter match. By default, a case-sensitive match is done."), MATCH_MODE_OPTIONS),
        arg(`pad_with (string, default="${CellErrorType$1.NotAvailable}")`, _t$1("The value to use for padding empty cells.")),
    ],
    compute: function (text, colDelimiter, rowDelimiter, ignoreEmpty = { value: TEXTSPLIT_DEFAULT_IGNORE_EMPTY }, matchMode = { value: TEXTSPLIT_DEFAULT_MATCH_MODE }, padWith = new NotAvailableError()) {
        const _text = toString(text);
        if (_text.length <= 0) {
            return new EvaluationError(_t$1("No text to split."));
        }
        if (colDelimiter === undefined && rowDelimiter === undefined) {
            return new EvaluationError(_t$1("At least one delimiter must be provided."));
        }
        const _colDelimiters = toMatrix(colDelimiter)
            .flat()
            .map((v) => escapeRegExp$1(toString(v)));
        const _rowDelimiters = toMatrix(rowDelimiter)
            .flat()
            .map((v) => escapeRegExp$1(toString(v)));
        if (_colDelimiters.some((v) => v === "") || _rowDelimiters.some((v) => v === "")) {
            return new EvaluationError(_t$1("The delimiters cannot be empty values."));
        }
        const _ignoreEmpty = toBoolean(ignoreEmpty);
        const _matchMode = toNumber(matchMode, this.locale);
        if (![0, 1].includes(_matchMode)) {
            return new EvaluationError(_t$1("match_mode should be a value of 0 or 1."));
        }
        const cells = [];
        const regexpFlags = _matchMode === 1 ? "gi" : "g";
        // only keep the row delimiters that are not in the column delimiters to prioritize spliting by columns
        const filteredRowDelimiters = _rowDelimiters.filter((delim) => !_colDelimiters.includes(delim));
        let rowParts = filteredRowDelimiters.length
            ? _text.split(new RegExp(filteredRowDelimiters.join("|"), regexpFlags))
            : [_text];
        if (_ignoreEmpty) {
            rowParts = rowParts.filter((v) => v !== "");
        }
        const colRegexp = new RegExp(_colDelimiters.join("|"), regexpFlags);
        for (const rowText of rowParts) {
            let columns = _colDelimiters.length ? rowText.split(colRegexp) : [rowText];
            if (_ignoreEmpty) {
                columns = columns.filter((v) => v !== "");
            }
            cells.push(columns.map((value) => ({ value })));
        }
        const maxLength = Math.max(...cells.map((row) => row.length));
        for (const row of cells) {
            while (row.length < maxLength) {
                row.push(padWith);
            }
        }
        return transposeMatrix(cells);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRIM
// -----------------------------------------------------------------------------
const TRIM = {
    description: _t$1("Removes space characters."),
    args: [
        arg("text (string)", _t$1("The text or reference to a cell containing text to be trimmed.")),
    ],
    compute: function (text) {
        return trimContent$1(toString(text));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// UPPER
// -----------------------------------------------------------------------------
const UPPER = {
    description: _t$1("Converts a specified string to uppercase."),
    args: [arg("text (string)", _t$1("The string to convert to uppercase."))],
    compute: function (text) {
        return toString(text).toUpperCase();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TEXT
// -----------------------------------------------------------------------------
const TEXT = {
    description: _t$1("Converts a number to text according to a specified format."),
    args: [
        arg("number (number)", _t$1("The number, date or time to format.")),
        arg("format (string)", _t$1('The case-sensitive format of the result, enclosed in quotation marks. Examples: "0.00" rounded to 2 decimal places, "hh:mm:ss" for hour:minutes:seconds.')),
    ],
    compute: function (number, format) {
        const _number = toNumber(number, this.locale);
        return formatValue$1(_number, { format: toString(format), locale: this.locale });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VALUE
// -----------------------------------------------------------------------------
const VALUE = {
    description: _t$1("Converts a string to a numeric value."),
    args: [arg("value (number)", _t$1("the string to be converted"))],
    compute: function (value) {
        return toNumber(value, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TEXTAFTER
// -----------------------------------------------------------------------------
const TEXT_FN_DEFAULT_INSTANCE = 1;
const TEXT_FN_DEFAULT_MATCH_MODE = 0;
const TEXT_FN_DEFAULT_MATCH_END = 0;
const TEXTAFTER = {
    description: _t$1("Returns text that occurs after a given substring or delimiter."),
    args: [
        arg("text (string)", _t$1("The source text.")),
        arg("delimiter (string)", _t$1("The substring after which text will be returned.")),
        arg(`instance_num (number, default=${TEXT_FN_DEFAULT_INSTANCE})`, _t$1("The desired instance of the delimiter after which we extract the text. A negative number searches from the end.")),
        arg(`match_mode (number, default=${TEXT_FN_DEFAULT_MATCH_MODE})`, _t$1("Searches the text for a delimiter match. By default, a case-sensitive match is done."), MATCH_MODE_OPTIONS),
        arg(`match_end (number, default=${TEXT_FN_DEFAULT_MATCH_END}))`, _t$1("Whether to treat the end of text as a delimiter."), MATCH_END_OPTIONS),
        arg(`if_not_found (string, default="${CellErrorType$1.NotAvailable}")`, _t$1("Value to return if the delimiter is not found.")),
    ],
    compute: function (text, delimiter, matchIndex = { value: TEXT_FN_DEFAULT_INSTANCE }, matchMode = { value: TEXT_FN_DEFAULT_MATCH_MODE }, matchEnd = { value: TEXT_FN_DEFAULT_MATCH_END }, ifNotFound = new NotAvailableError()) {
        const _text = toString(text);
        const _matchIndex = toNumber(matchIndex, this.locale);
        const _matchMode = toNumber(matchMode, this.locale);
        const _matchEnd = toNumber(matchEnd, this.locale);
        if (_matchIndex === 0) {
            return new EvaluationError(_t$1("The instance_num (%s) must not be zero.", _matchIndex));
        }
        if (_matchMode !== 0 && _matchMode !== 1) {
            return new EvaluationError(_t$1("match_mode should have a value of 0 or 1."));
        }
        if (_matchEnd !== 0 && _matchEnd !== 1) {
            return new EvaluationError(_t$1("match_end should have a value of 0 or 1."));
        }
        const _delimiter = toString(delimiter);
        if (_delimiter === "") {
            return Math.sign(_matchIndex) > 0 ? { value: _text } : { value: "" };
        }
        const flags = _matchMode === 1 ? "gi" : "g";
        const pattern = escapeRegExp$1(_delimiter);
        const regexp = new RegExp(pattern, flags);
        let matchIndices = [..._text.matchAll(regexp)].map((match) => match.index + pattern.length);
        if (_matchIndex < 0) {
            matchIndices = matchIndices.reverse();
        }
        // If _matchEnd, we act like the text is appended by the delimiter (or prepended if negative index)
        if (_matchEnd && Math.abs(_matchIndex) === matchIndices.length + 1) {
            return Math.sign(_matchIndex) > 0 ? { value: "" } : { value: _text };
        }
        const targetIndex = matchIndices[Math.abs(_matchIndex) - 1];
        return targetIndex === undefined ? ifNotFound : { value: _text.substring(targetIndex) };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TEXTBEFORE
// -----------------------------------------------------------------------------
const TEXTBEFORE = {
    description: _t$1("Returns text that occurs before a given substring or delimiter."),
    args: [
        arg("text (string)", _t$1("The source text.")),
        arg("delimiter (string)", _t$1("The substring after which text will be returned.")),
        arg(`instance_num (number, default=${TEXT_FN_DEFAULT_INSTANCE})`, _t$1("The desired instance of the delimiter before which we extract the text. A negative number searches from the end.")),
        arg(`match_mode (number, default=${TEXT_FN_DEFAULT_MATCH_MODE})`, _t$1("Searches the text for a delimiter match. By default, a case-sensitive match is done."), MATCH_MODE_OPTIONS),
        arg(`match_end (number, default=${TEXT_FN_DEFAULT_MATCH_END}))`, _t$1("Whether to match a delimiter against the end of the text."), MATCH_END_OPTIONS),
        arg(`if_not_found (string, default="${CellErrorType$1.NotAvailable}")`, _t$1("Value to return if the delimiter is not found.")),
    ],
    compute: function (text, delimiter, matchIndex = { value: TEXT_FN_DEFAULT_INSTANCE }, matchMode = { value: TEXT_FN_DEFAULT_MATCH_MODE }, matchEnd = { value: TEXT_FN_DEFAULT_MATCH_END }, ifNotFound = new NotAvailableError()) {
        const _text = toString(text);
        const _matchIndex = toNumber(matchIndex, this.locale);
        const _matchMode = toNumber(matchMode, this.locale);
        const _matchEnd = toNumber(matchEnd, this.locale);
        if (_matchIndex === 0) {
            return new EvaluationError(_t$1("The instance_num (%s) must not be zero.", _matchIndex));
        }
        if (_matchMode !== 0 && _matchMode !== 1) {
            return new EvaluationError(_t$1("match_mode should have a value of 0 or 1."));
        }
        if (_matchEnd !== 0 && _matchEnd !== 1) {
            return new EvaluationError(_t$1("match_end should have a value of 0 or 1."));
        }
        const _delimiter = toString(delimiter);
        if (_delimiter === "") {
            return Math.sign(_matchIndex) > 0 ? { value: "" } : { value: _text };
        }
        const flags = _matchMode === 1 ? "gi" : "g";
        const pattern = escapeRegExp$1(_delimiter);
        const regexp = new RegExp(pattern, flags);
        let matchIndices = [..._text.matchAll(regexp)].map((match) => match.index + pattern.length);
        if (_matchIndex < 0) {
            matchIndices = matchIndices.reverse();
        }
        // If _matchEnd, we act like the text is appended by the delimiter (or prepended if negative index)
        if (_matchEnd && Math.abs(_matchIndex) === matchIndices.length + 1) {
            return Math.sign(_matchIndex) > 0 ? { value: _text } : { value: "" };
        }
        const targetIndex = matchIndices[Math.abs(_matchIndex) - 1];
        return targetIndex === undefined
            ? ifNotFound
            : { value: _text.substring(0, targetIndex - _delimiter.length) };
    },
    isExported: true,
};

var text = /*#__PURE__*/Object.freeze({
    __proto__: null,
    CHAR: CHAR,
    CLEAN: CLEAN,
    CONCATENATE: CONCATENATE,
    EXACT: EXACT,
    FIND: FIND,
    JOIN: JOIN,
    LEFT: LEFT,
    LEN: LEN,
    LOWER: LOWER,
    MID: MID,
    PROPER: PROPER,
    REGEXEXTRACT: REGEXEXTRACT,
    REPLACE: REPLACE,
    RIGHT: RIGHT,
    SEARCH: SEARCH,
    SPLIT: SPLIT,
    SUBSTITUTE: SUBSTITUTE,
    TEXT: TEXT,
    TEXTAFTER: TEXTAFTER,
    TEXTBEFORE: TEXTBEFORE,
    TEXTJOIN: TEXTJOIN,
    TEXTSPLIT: TEXTSPLIT,
    TRIM: TRIM,
    UPPER: UPPER,
    VALUE: VALUE
});

// -----------------------------------------------------------------------------
// HYPERLINK
// -----------------------------------------------------------------------------
const HYPERLINK = {
    description: _t$1("Creates a hyperlink in a cell."),
    args: [
        arg("url (string)", _t$1("The full URL of the link enclosed in quotation marks.")),
        arg("link_label (string, optional)", _t$1("The text to display in the cell, enclosed in quotation marks.")),
    ],
    compute: function (url, linkLabel) {
        const processedUrl = toString(url).trim();
        const processedLabel = toString(linkLabel) || processedUrl;
        if (processedUrl === "")
            return processedLabel;
        return markdownLink(processedLabel, processedUrl);
    },
    isExported: true,
};

var web = /*#__PURE__*/Object.freeze({
    __proto__: null,
    HYPERLINK: HYPERLINK
});

const functionNameRegex = /^[A-Z0-9\_\.]+$/;
class FunctionRegistry extends Registry$1 {
    mapping = {};
    add(name, addDescr) {
        name = name.toUpperCase();
        if (name in this.content) {
            throw new Error(`${name} is already present in this registry!`);
        }
        return this.replace(name, addDescr);
    }
    replace(name, addDescr) {
        name = name.toUpperCase();
        if (!functionNameRegex.test(name)) {
            throw new Error(_t$1("Invalid function name %s. Function names can exclusively contain alphanumerical values separated by dots (.) or underscore (_)", name));
        }
        const descr = addMetaInfoFromArg(name, addDescr);
        validateArguments(descr);
        this.mapping[name] = createComputeFunction(descr);
        super.replace(name, descr);
        return this;
    }
}
const functionRegistry = new FunctionRegistry();
const categories = [
    { name: _t$1("Array"), functions: array },
    { name: _t$1("Database"), functions: database },
    { name: _t$1("Date"), functions: date },
    { name: _t$1("Filter"), functions: filter },
    { name: _t$1("Financial"), functions: financial },
    { name: _t$1("Info"), functions: info },
    { name: _t$1("Lookup"), functions: lookup },
    { name: _t$1("Logical"), functions: logical },
    { name: _t$1("Math"), functions: math },
    { name: _t$1("Misc"), functions: misc },
    { name: _t$1("Operator"), functions: operators },
    { name: _t$1("Statistical"), functions: statistical },
    { name: _t$1("Text"), functions: text },
    { name: _t$1("Engineering"), functions: engineering },
    { name: _t$1("Web"), functions: web },
    { name: _t$1("Parser"), functions: parser },
];
for (const category of categories) {
    const fns = category.functions;
    for (let name in fns) {
        const addDescr = fns[name];
        addDescr.category = addDescr.category || category.name;
        name = name.replace(/_/g, ".");
        functionRegistry.add(name, { isExported: false, ...addDescr });
    }
}

var State;
(function (State) {
    /**
     * Initial state.
     * Expecting any reference for the left part of a range
     * e.g. "A1", "1", "A", "Sheet1!A1", "Sheet1!A"
     */
    State[State["LeftRef"] = 0] = "LeftRef";
    /**
     * Expecting any reference for the right part of a range
     * e.g. "A1", "1", "A", "Sheet1!A1", "Sheet1!A"
     */
    State[State["RightRef"] = 1] = "RightRef";
    /**
     * Expecting the separator without any constraint on the right part
     */
    State[State["Separator"] = 2] = "Separator";
    /**
     * Expecting the separator for a full column range
     */
    State[State["FullColumnSeparator"] = 3] = "FullColumnSeparator";
    /**
     * Expecting the separator for a full row range
     */
    State[State["FullRowSeparator"] = 4] = "FullRowSeparator";
    /**
     * Expecting the right part of a full column range
     * e.g. "1", "A1"
     */
    State[State["RightColumnRef"] = 5] = "RightColumnRef";
    /**
     * Expecting the right part of a full row range
     * e.g. "A", "A1"
     */
    State[State["RightRowRef"] = 6] = "RightRowRef";
    /**
     * Final state. A range has been matched
     */
    State[State["Found"] = 7] = "Found";
})(State || (State = {}));
const goTo = (state, guard = () => true) => [
    {
        goTo: state,
        guard,
    },
];
const goToMulti = (state, guard = () => true) => ({
    goTo: state,
    guard,
});
const machine = {
    [State.LeftRef]: {
        REFERENCE: goTo(State.Separator),
        NUMBER: goTo(State.FullRowSeparator),
        SYMBOL: [
            goToMulti(State.FullColumnSeparator, (token) => isColReference(token.value)),
            goToMulti(State.FullRowSeparator, (token) => isRowReference(token.value)),
        ],
    },
    [State.FullColumnSeparator]: {
        SPACE: goTo(State.FullColumnSeparator),
        OPERATOR: goTo(State.RightColumnRef, (token) => token.value === ":"),
    },
    [State.FullRowSeparator]: {
        SPACE: goTo(State.FullRowSeparator),
        OPERATOR: goTo(State.RightRowRef, (token) => token.value === ":"),
    },
    [State.Separator]: {
        SPACE: goTo(State.Separator),
        OPERATOR: goTo(State.RightRef, (token) => token.value === ":"),
    },
    [State.RightRef]: {
        SPACE: goTo(State.RightRef),
        NUMBER: goTo(State.Found),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
        SYMBOL: goTo(State.Found, (token) => isColHeader(token.value) || isRowHeader(token.value)),
    },
    [State.RightColumnRef]: {
        SPACE: goTo(State.RightColumnRef),
        SYMBOL: goTo(State.Found, (token) => isColHeader(token.value)),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
    },
    [State.RightRowRef]: {
        SPACE: goTo(State.RightRowRef),
        NUMBER: goTo(State.Found),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
        SYMBOL: goTo(State.Found, (token) => isRowHeader(token.value)),
    },
    [State.Found]: {},
};
/**
 * Check if the list of tokens starts with a sequence of tokens representing
 * a range.
 * If a range is found, the sequence is removed from the list and is returned
 * as a single token.
 */
function matchReference(tokens) {
    let head = 0;
    let transitions = machine[State.LeftRef];
    let matchedTokens = "";
    while (transitions !== undefined) {
        const token = tokens[head++];
        if (!token) {
            return null;
        }
        const transition = transitions[token.type]?.find((candidate) => candidate.guard(token));
        const nextState = transition ? transition.goTo : undefined;
        switch (nextState) {
            case undefined:
                return null;
            case State.Found:
                matchedTokens += token.value;
                tokens.splice(0, head);
                return {
                    type: "REFERENCE",
                    value: matchedTokens,
                };
            default:
                transitions = machine[nextState];
                matchedTokens += token.value;
                break;
        }
    }
    return null;
}
/**
 * Take the result of the tokenizer and transform it to be usable in the
 * manipulations of range
 *
 * @param formula
 */
function rangeTokenize(formula, locale = DEFAULT_LOCALE) {
    const tokens = tokenize(formula, locale);
    const result = [];
    while (tokens.length) {
        result.push(matchReference(tokens) || tokens.shift());
    }
    return result;
}

const functionRegex = /[a-zA-Z0-9\_]+(\.[a-zA-Z0-9\_]+)*/;
const UNARY_OPERATORS_PREFIX = ["-", "+"];
const UNARY_OPERATORS_POSTFIX = ["%"];
class TokenList {
    tokens;
    currentIndex = 0;
    current;
    length;
    constructor(tokens) {
        this.tokens = tokens;
        this.current = tokens[0];
        this.length = tokens.length;
    }
    shift() {
        const current = this.tokens[this.currentIndex];
        this.current = this.tokens[++this.currentIndex];
        return current;
    }
    get next() {
        return this.tokens[this.currentIndex + 1];
    }
}
const OP_PRIORITY = {
    "%": 40,
    "^": 30,
    "*": 20,
    "/": 20,
    "+": 15,
    "-": 15,
    "&": 13,
    ">": 10,
    "<>": 10,
    ">=": 10,
    "<": 10,
    "<=": 10,
    "=": 10,
};
/**
 * Parse the next operand in an arithmetic expression.
 * e.g.
 *  for 1+2*3, the next operand is 1
 *  for (1+2)*3, the next operand is (1+2)
 *  for SUM(1,2)+3, the next operand is SUM(1,2)
 */
function parseOperand(tokens) {
    const current = tokens.shift();
    if (!current) {
        throw new BadExpressionError();
    }
    switch (current.type) {
        case "DEBUGGER":
            const next = parseExpression(tokens, 1000);
            next.debug = true;
            return next;
        case "NUMBER":
            return {
                type: "NUMBER",
                value: parseNumber(current.value, DEFAULT_LOCALE),
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: current.tokenIndex,
            };
        case "STRING":
            return {
                type: "STRING",
                value: unquote(current.value),
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: current.tokenIndex,
            };
        case "INVALID_REFERENCE":
            return {
                type: "REFERENCE",
                value: CellErrorType$1.InvalidReference,
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: current.tokenIndex,
            };
        case "REFERENCE":
            if (tokens.current?.value === ":" && tokens.next?.type === "REFERENCE") {
                tokens.shift();
                const rightReference = tokens.shift();
                return {
                    type: "REFERENCE",
                    value: `${current.value}:${rightReference?.value}`,
                    tokenStartIndex: current.tokenIndex,
                    tokenEndIndex: rightReference.tokenIndex,
                };
            }
            return {
                type: "REFERENCE",
                value: current.value,
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: current.tokenIndex,
            };
        case "SYMBOL":
            const value = current.value;
            const nextToken = tokens.current;
            if (nextToken?.type === "LEFT_PAREN" &&
                functionRegex.test(current.value) &&
                value === unquote(value, "'")) {
                const { args, rightParen } = parseFunctionArgs(tokens);
                return {
                    type: "FUNCALL",
                    value: value,
                    args,
                    tokenStartIndex: current.tokenIndex,
                    tokenEndIndex: rightParen.tokenIndex,
                };
            }
            const upperCaseValue = value.toUpperCase();
            if (upperCaseValue === "TRUE" || upperCaseValue === "FALSE") {
                return {
                    type: "BOOLEAN",
                    value: upperCaseValue === "TRUE",
                    tokenStartIndex: current.tokenIndex,
                    tokenEndIndex: current.tokenIndex,
                };
            }
            return {
                type: "SYMBOL",
                value: unquote(current.value, "'"),
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: current.tokenIndex,
            };
        case "LEFT_PAREN":
            const result = parseExpression(tokens);
            const rightParen = consumeOrThrow(tokens, "RIGHT_PAREN", _t$1("Missing closing parenthesis"));
            return {
                ...result,
                tokenStartIndex: current.tokenIndex,
                tokenEndIndex: rightParen.tokenIndex,
            };
        case "OPERATOR":
            const operator = current.value;
            if (UNARY_OPERATORS_PREFIX.includes(operator)) {
                const operand = parseExpression(tokens, OP_PRIORITY[operator]);
                return {
                    type: "UNARY_OPERATION",
                    value: operator,
                    operand,
                    tokenStartIndex: current.tokenIndex,
                    tokenEndIndex: operand.tokenEndIndex,
                };
            }
            throw new BadExpressionError(_t$1("Unexpected token: %s", current.value));
        default:
            throw new BadExpressionError(_t$1("Unexpected token: %s", current.value));
    }
}
function parseFunctionArgs(tokens) {
    consumeOrThrow(tokens, "LEFT_PAREN", _t$1("Missing opening parenthesis"));
    const nextToken = tokens.current;
    if (nextToken?.type === "RIGHT_PAREN") {
        const rightParen = consumeOrThrow(tokens, "RIGHT_PAREN");
        return { args: [], rightParen };
    }
    const args = [];
    args.push(parseOneFunctionArg(tokens));
    while (tokens.current?.type !== "RIGHT_PAREN") {
        consumeOrThrow(tokens, "ARG_SEPARATOR", _t$1("Wrong function call"));
        args.push(parseOneFunctionArg(tokens));
    }
    const rightParen = consumeOrThrow(tokens, "RIGHT_PAREN");
    return { args, rightParen };
}
function parseOneFunctionArg(tokens) {
    const nextToken = tokens.current;
    if (nextToken?.type === "ARG_SEPARATOR" || nextToken?.type === "RIGHT_PAREN") {
        // arg is empty: "sum(1,,2)" "sum(,1)" "sum(1,)"
        return {
            type: "EMPTY",
            value: "",
            tokenStartIndex: nextToken.tokenIndex,
            tokenEndIndex: nextToken.tokenIndex,
        };
    }
    return parseExpression(tokens);
}
function consumeOrThrow(tokens, type, message) {
    const token = tokens.shift();
    if (!token || token.type !== type) {
        throw new BadExpressionError(message);
    }
    return token;
}
function parseExpression(tokens, parent_priority = 0) {
    if (tokens.length === 0) {
        throw new BadExpressionError();
    }
    let left = parseOperand(tokens);
    // as long as we have operators with higher priority than the parent one,
    // continue parsing the expression because it is a child sub-expression
    while (tokens.current?.type === "OPERATOR" &&
        OP_PRIORITY[tokens.current.value] > parent_priority) {
        const operatorToken = tokens.shift();
        const operator = operatorToken.value;
        if (UNARY_OPERATORS_POSTFIX.includes(operator)) {
            left = {
                type: "UNARY_OPERATION",
                value: operator,
                operand: left,
                postfix: true,
                tokenStartIndex: left.tokenStartIndex,
                tokenEndIndex: operatorToken.tokenIndex,
            };
        }
        else {
            const right = parseExpression(tokens, OP_PRIORITY[operator]);
            left = {
                type: "BIN_OPERATION",
                value: operator,
                left,
                right,
                tokenStartIndex: left.tokenStartIndex,
                tokenEndIndex: right.tokenEndIndex,
            };
        }
    }
    return left;
}
/**
 * Parse an expression (as a string) into an AST.
 */
function parse(str) {
    return parseTokens(rangeTokenize(str));
}
function parseTokens(tokens) {
    const richTokens = tokens.map((token, index) => ({
        type: token.type,
        value: token.value,
        tokenIndex: index,
    }));
    const tokensToParse = richTokens.filter((x) => x.type !== "SPACE");
    const tokenList = new TokenList(tokensToParse);
    if (tokenList.current?.value === "=") {
        tokenList.shift();
    }
    const result = parseExpression(tokenList);
    if (tokenList.current) {
        throw new BadExpressionError();
    }
    return result;
}
/**
 * Allows to visit all nodes of an AST and apply a mapping function
 * to nodes of a specific type.
 * Useful if you want to convert some part of a formula.
 *
 * @example
 * convertAstNodes(ast, "FUNCALL", convertFormulaToExcel)
 *
 * function convertFormulaToExcel(ast: ASTFuncall) {
 *   // ...
 *   return modifiedAst
 * }
 */
function convertAstNodes(ast, type, fn) {
    return mapAst(ast, (ast) => {
        if (ast.type === type) {
            return fn(ast);
        }
        return ast;
    });
}
function iterateAstNodes(ast) {
    return Array.from(astIterator(ast));
}
function* astIterator(ast) {
    yield ast;
    switch (ast.type) {
        case "FUNCALL":
            for (const arg of ast.args) {
                yield* astIterator(arg);
            }
            break;
        case "UNARY_OPERATION":
            yield* astIterator(ast.operand);
            break;
        case "BIN_OPERATION":
            yield* astIterator(ast.left);
            yield* astIterator(ast.right);
            break;
    }
}
function mapAst(ast, fn) {
    ast = fn(ast);
    switch (ast.type) {
        case "FUNCALL":
            return {
                ...ast,
                args: ast.args.map((child) => mapAst(child, fn)),
            };
        case "UNARY_OPERATION":
            return {
                ...ast,
                operand: mapAst(ast.operand, fn),
            };
        case "BIN_OPERATION":
            return {
                ...ast,
                right: mapAst(ast.right, fn),
                left: mapAst(ast.left, fn),
            };
        default:
            return ast;
    }
}

const functions$2 = functionRegistry.content;
function isExportableToExcel(tokens) {
    try {
        const nonExportableFunctions = iterateAstNodes(parseTokens(tokens)).filter((ast) => ast.type === "FUNCALL" && !functions$2[ast.value.toUpperCase()]?.isExported);
        return nonExportableFunctions.length === 0;
    }
    catch (error) {
        return false;
    }
}
function getFunctionsFromTokens(tokens, functionNames) {
    // Parsing is an expensive operation, so we first check if the
    // formula contains one of the function names
    if (!tokens.some((t) => t.type === "SYMBOL" && functionNames.includes(t.value.toUpperCase()))) {
        return [];
    }
    let ast;
    try {
        ast = parseTokens(tokens);
    }
    catch {
        return [];
    }
    return getFunctionsFromAST(ast, functionNames);
}
function getFunctionsFromAST(ast, functionNames) {
    return iterateAstNodes(ast)
        .filter((node) => node.type === "FUNCALL" && functionNames.includes(node.value.toUpperCase()))
        .map((node) => ({
        functionName: node.value.toUpperCase(),
        args: node.args,
    }));
}

/**
 * Add the `https` prefix to the url if it's missing
 */
function withHttps(url) {
    return !/^https?:\/\//i.test(url) ? `https://${url}` : url;
}
const urlRegistry = new Registry();
function createWebLink(url, label) {
    url = withHttps(url);
    return {
        url,
        label: label || url,
        isExternal: true,
        isUrlEditable: true,
    };
}
urlRegistry.add("sheet_URL", {
    match: (url) => isSheetUrl(url),
    createLink: (url, label) => {
        return {
            label,
            url,
            isExternal: false,
            isUrlEditable: false,
        };
    },
    urlRepresentation(url, getters) {
        const sheetId = parseSheetUrl(url);
        return getters.tryGetSheetName(sheetId) || _t$1("Invalid sheet");
    },
    open(url, env) {
        const sheetId = parseSheetUrl(url);
        const result = env.model.dispatch("ACTIVATE_SHEET", {
            sheetIdFrom: env.model.getters.getActiveSheetId(),
            sheetIdTo: sheetId,
        });
        if (result.isCancelledBecause("SheetIsHidden" /* CommandResult.SheetIsHidden */)) {
            env.notifyUser({
                type: "warning",
                sticky: false,
                text: _t$1("Cannot open the link because the linked sheet is hidden."),
            });
        }
    },
    sequence: 0,
});
const WebUrlSpec = {
    createLink: createWebLink,
    match: (url) => isWebLink(url),
    open: (url) => window.open(url, "_blank"),
    urlRepresentation: (url) => url,
    sequence: 0,
};
function findMatchingSpec(url) {
    return (urlRegistry
        .getAll()
        .sort((a, b) => a.sequence - b.sequence)
        .find((urlType) => urlType.match(url)) || WebUrlSpec);
}
function urlRepresentation(link, getters) {
    return findMatchingSpec(link.url).urlRepresentation(link.url, getters);
}
function openLink(link, env, isMiddleClick) {
    findMatchingSpec(link.url).open(link.url, env, isMiddleClick);
}
function detectLink(value) {
    if (typeof value !== "string") {
        return undefined;
    }
    if (isMarkdownLink(value)) {
        const { label, url } = parseMarkdownLink(value);
        return findMatchingSpec(url).createLink(url, label);
    }
    else if (isWebLink(value)) {
        return createWebLink(value);
    }
    return undefined;
}

function createActions(menuItems) {
    return menuItems.map(createAction).sort((a, b) => a.sequence - b.sequence);
}
let nextItemId = 1;
function createAction(item) {
    const name = item.name;
    const children = item.children;
    const description = item.description;
    const icon = item.icon;
    const secondaryIcon = item.secondaryIcon;
    const itemId = item.id || nextItemId++;
    const isEnabled = item.isEnabled ? item.isEnabled : () => true;
    return {
        id: itemId.toString(),
        name: typeof name === "function" ? name : () => name,
        isVisible: item.isVisible ? item.isVisible : () => true,
        isEnabled: isEnabled,
        isActive: item.isActive,
        execute: item.execute
            ? (env, isMiddleClick) => {
                if (isEnabled(env)) {
                    return item.execute(env, isMiddleClick);
                }
                return undefined;
            }
            : undefined,
        children: children
            ? (env) => {
                return children
                    .map((child) => (typeof child === "function" ? child(env) : child))
                    .flat()
                    .map(createAction);
            }
            : () => [],
        isReadonlyAllowed: item.isReadonlyAllowed || false,
        separator: item.separator || false,
        icon: typeof icon === "function" ? icon : () => icon || "",
        iconColor: item.iconColor,
        secondaryIcon: typeof secondaryIcon === "function" ? secondaryIcon : () => secondaryIcon || "",
        description: typeof description === "function" ? description : () => description || "",
        textColor: item.textColor,
        sequence: item.sequence || 0,
        onStartHover: item.onStartHover,
        onStopHover: item.onStopHover,
    };
}

/**
 * This is a generic event bus based on the Owl event bus.
 * This bus however ensures type safety across events and subscription callbacks.
 */
class EventBus {
    subscriptions = {};
    /**
     * Add a listener for the 'eventType' events.
     *
     * Note that the 'owner' of this event can be anything, but will more likely
     * be a component or a class. The idea is that the callback will be called with
     * the proper owner bound.
     *
     * Also, the owner should be kind of unique. This will be used to remove the
     * listener.
     */
    on(type, owner, callback) {
        if (!callback) {
            throw new Error("Missing callback");
        }
        if (!this.subscriptions[type]) {
            this.subscriptions[type] = [];
        }
        this.subscriptions[type].push({
            owner,
            callback,
        });
    }
    /**
     * Emit an event of type 'eventType'.  Any extra arguments will be passed to
     * the listeners callback.
     */
    trigger(type, payload) {
        const subs = this.subscriptions[type] || [];
        for (let i = 0, iLen = subs.length; i < iLen; i++) {
            const sub = subs[i];
            sub.callback.call(sub.owner, payload);
        }
    }
    /**
     * Remove a listener
     */
    off(eventType, owner) {
        const subs = this.subscriptions[eventType];
        if (subs) {
            this.subscriptions[eventType] = subs.filter((s) => s.owner !== owner);
        }
    }
    /**
     * Remove all subscriptions.
     */
    clear() {
        this.subscriptions = {};
    }
}

/**
 * A type-safe dependency container
 */
class DependencyContainer extends EventBus {
    dependencies = new Map();
    factory = new StoreFactory(this.get.bind(this));
    /**
     * Injects a store instance in the dependency container.
     * Useful for injecting an external store that is not created by the container.
     * Also useful for mocking a store.
     */
    inject(Store, instance) {
        if (this.dependencies.has(Store) && this.dependencies.get(Store) !== instance) {
            throw new Error(`Store ${Store.name} already has an instance`);
        }
        this.dependencies.set(Store, instance);
    }
    /**
     * Get an instance of a store.
     */
    get(Store) {
        if (!this.dependencies.has(Store)) {
            this.dependencies.set(Store, this.instantiate(Store));
        }
        return this.dependencies.get(Store);
    }
    instantiate(Store, ...args) {
        return this.factory.build(Store, ...args);
    }
    resetStores() {
        this.dependencies.clear();
    }
    dispose() {
        for (const instance of this.dependencies.values()) {
            if ("dispose" in instance && typeof instance.dispose === "function") {
                instance.dispose();
            }
        }
    }
}
class StoreFactory {
    get;
    pendingBuilds = new Set();
    constructor(get) {
        this.get = get;
    }
    /**
     * Build a store instance and get all its dependencies
     * while detecting and preventing circular dependencies
     */
    build(Store, ...args) {
        if (this.pendingBuilds.has(Store)) {
            throw new Error(`Circular dependency detected: ${[...this.pendingBuilds, Store]
                .map((s) => s.name)
                .join(" -> ")}`);
        }
        this.pendingBuilds.add(Store);
        const instance = new Store(this.get, ...args);
        this.pendingBuilds.delete(Store);
        return instance;
    }
}

/**
 * Create a store to expose an external resource (which is not a store itself)
 * to other stores.
 * The external resource needs to be injected in the store provider to provide
 * the store implementation.
 *
 * @example
 * const MyMetaStore = createAbstractStore("MyStore");
 * const stores = useStoreProvider();
 * stores.inject(MyMetaStore, externalResourceInstance);
 */
function createAbstractStore(storeName) {
    class MetaStore {
        constructor(get) {
            throw new Error(`This is a abstract store for ${storeName}, it cannot be instantiated.
Did you forget to inject your store instance?

const stores = useStoreProvider();
stores.inject(MyMetaStore, storeInstance);
`);
        }
    }
    return MetaStore;
}
class DisposableStore {
    get;
    disposeCallbacks = [];
    constructor(get) {
        this.get = get;
    }
    onDispose(callback) {
        this.disposeCallbacks.push(callback);
    }
    dispose() {
        this.disposeCallbacks.forEach((cb) => cb());
    }
}

/**
 * This hook should be used at the root of your app to provide the store container.
 */
function useStoreProvider() {
    const env = useEnv();
    if (env.__spreadsheet_stores__ instanceof DependencyContainer) {
        return env.__spreadsheet_stores__;
    }
    const container = new DependencyContainer();
    useSubEnv({
        __spreadsheet_stores__: container,
        getStore: (Store) => {
            const store = container.get(Store);
            return proxifyStoreMutation(store, () => container.trigger("store-updated"));
        },
    });
    onWillUnmount(() => container.dispose());
    return container;
}
/**
 * Get the instance of a store.
 */
function useStore(Store) {
    const env = useEnv();
    const container = getDependencyContainer(env);
    const store = container.get(Store);
    return useStoreRenderProxy(container, store);
}
function useLocalStore(Store, ...args) {
    const env = useEnv();
    const container = getDependencyContainer(env);
    const store = container.instantiate(Store, ...args);
    onWillUnmount(() => store.dispose());
    return useStoreRenderProxy(container, store);
}
/**
 * Trigger an event to re-render the app (deep render) when
 * a store is mutated by invoking one of its mutator methods.
 */
function useStoreRenderProxy(container, store) {
    const component = useComponent();
    const proxy = proxifyStoreMutation(store, () => {
        if (status(component) === "mounted") {
            container.trigger("store-updated");
        }
    });
    return proxy;
}
/**
 * Creates a proxied version of a store object with mutation tracking.
 * Whenever a mutator method of the store is called, the provided callback function is invoked.
 */
function proxifyStoreMutation(store, callback) {
    const proxy = new Proxy(store, {
        get(target, property, receiver) {
            const thisStore = target;
            // The third argument is `thisStore` (target) instead of `receiver`.
            // The goal is to always have the same `this` value in getter functions
            // (when `target[property]` is an accessor property).
            // `thisStore` is always the same object reference. `receiver` however is the
            // object on which the property is called, which is the Proxy object which is different for each component.
            const value = Reflect.get(target, property, thisStore);
            if (store.mutators?.includes(property)) {
                const functionProxy = new Proxy(value, {
                    // trap the function call
                    apply(target, thisArg, argArray) {
                        const res = Reflect.apply(target, thisStore, argArray);
                        if (res === "noStateChange") {
                            return;
                        }
                        callback();
                    },
                });
                return functionProxy;
            }
            return value;
        },
    });
    return proxy;
}
function getDependencyContainer(env) {
    const container = env.__spreadsheet_stores__;
    if (!(container instanceof DependencyContainer)) {
        throw new Error("No store provider found. Did you forget to call useStoreProvider()?");
    }
    return container;
}

const ModelStore = createAbstractStore("Model");

const LAYERS = {
    Background: 0,
    Highlights: 1,
    Clipboard: 2,
    Chart: 4,
    Autofill: 5,
    Selection: 6,
    Headers: 100, // ensure that we end up on  top
};
const OrderedLayers = memoize$1(() => Object.keys(LAYERS).sort((a, b) => LAYERS[a] - LAYERS[b]));
/**
 *
 * @param layer New layer name
 * @param priority The lower priorities are rendered first
 */
function addRenderingLayer(layer, priority) {
    if (LAYERS[layer]) {
        throw new Error(`Layer ${layer} already exists`);
    }
    LAYERS[layer] = priority;
}

class RendererStore {
    mutators = ["register", "unRegister", "draw", "startAnimation", "stopAnimation"];
    renderers = {};
    model;
    context = undefined;
    animationFrameId = null;
    registeredAnimations = new Set();
    constructor(get) {
        this.model = get(ModelStore);
    }
    register(renderer) {
        if (!renderer.renderingLayers.length) {
            return;
        }
        for (const layer of renderer.renderingLayers) {
            if (!this.renderers[layer]) {
                this.renderers[layer] = [];
            }
            this.renderers[layer].push(renderer);
        }
    }
    unRegister(renderer) {
        for (const layer of Object.keys(this.renderers)) {
            this.renderers[layer] = this.renderers[layer].filter((r) => r !== renderer);
        }
    }
    drawLayer(context, layer, timeStamp) {
        const renderers = this.renderers[layer];
        if (renderers) {
            for (const renderer of renderers) {
                context.ctx.save();
                renderer.drawLayer(context, layer, timeStamp);
                context.ctx.restore();
            }
        }
        return "noStateChange";
    }
    draw(context, timestamp) {
        context = context || this.context;
        if (!context) {
            throw new Error("Rendering context is not defined");
        }
        this.context = context;
        for (const layer of OrderedLayers()) {
            this.model.drawLayer(context, layer);
            this.drawLayer(context, layer, timestamp);
        }
        return "noStateChange";
    }
    startAnimation(animationId) {
        this.registeredAnimations.add(animationId);
        if (!this.animationFrameId) {
            const animationCallback = (timestamp) => {
                this.animationFrameId = requestAnimationFrame(animationCallback);
                this.draw(undefined, timestamp);
            };
            this.animationFrameId = requestAnimationFrame(animationCallback);
        }
        return "noStateChange";
    }
    stopAnimation(animationId) {
        this.registeredAnimations.delete(animationId);
        if (this.registeredAnimations.size === 0 && this.animationFrameId !== null) {
            cancelAnimationFrame(this.animationFrameId);
            this.animationFrameId = null;
        }
        return "noStateChange";
    }
    dispose() {
        if (this.animationFrameId) {
            cancelAnimationFrame(this.animationFrameId);
            this.animationFrameId = null;
        }
    }
}

class SpreadsheetStore extends DisposableStore {
    // cast the model store as Model to allow model.dispatch to return the DispatchResult
    model = this.get(ModelStore);
    getters = this.model.getters;
    renderer = this.get(RendererStore);
    constructor(get) {
        super(get);
        this.model.on("command-dispatched", this, this.handle);
        this.model.on("command-finalized", this, this.finalize);
        this.renderer.register(this);
        this.onDispose(() => {
            this.model.off("command-dispatched", this);
            this.model.off("command-finalized", this);
            this.renderer.unRegister(this);
        });
    }
    get renderingLayers() {
        return [];
    }
    handle(cmd) { }
    finalize() { }
    drawLayer(ctx, layer, timestamp) { }
}

const VOID_COMPOSER = {
    id: "void-composer",
    get editionMode() {
        return "inactive";
    },
    startEdition: () => {
        throw new Error("No composer is registered");
    },
    stopEdition: () => {
        throw new Error("No composer is registered");
    },
    setCurrentContent: () => {
        throw new Error("No composer is registered");
    },
};
class ComposerFocusStore extends SpreadsheetStore {
    mutators = ["focusComposer", "focusActiveComposer"];
    activeComposer = VOID_COMPOSER;
    _focusMode = "inactive";
    get focusMode() {
        return this.activeComposer.editionMode === "inactive" ? "inactive" : this._focusMode;
    }
    focusComposer(listener, args) {
        this.activeComposer = listener;
        if (this.getters.isReadonly()) {
            return "noStateChange";
        }
        this._focusMode = args.focusMode || "contentFocus";
        if (this._focusMode !== "inactive") {
            this.setComposerContent(args);
        }
        return;
    }
    focusActiveComposer(args) {
        if (this.getters.isReadonly()) {
            return "noStateChange";
        }
        if (!this.activeComposer) {
            throw new Error("No composer is registered");
        }
        this._focusMode = args.focusMode || "contentFocus";
        if (this._focusMode !== "inactive") {
            this.setComposerContent(args);
        }
        return;
    }
    /**
     * Start the edition or update the content if it's already started.
     */
    setComposerContent({ content, selection, }) {
        if (this.activeComposer.editionMode === "inactive") {
            this.activeComposer.startEdition(content, selection);
        }
        else if (content) {
            this.activeComposer.setCurrentContent(content, selection);
        }
    }
}

const RBA_REGEX = /rgba?\(|\s+|\)/gi;
const HEX_MATCH = /^#([A-F\d]{2}){3,4}$/;
const colors = [
    "#eb6d00",
    "#0074d9",
    "#ad8e00",
    "#169ed4",
    "#b10dc9",
    "#00a82d",
    "#00a3a3",
    "#f012be",
    "#3d9970",
    "#111111",
    "#62A300",
    "#ff4136",
    "#949494",
    "#85144b",
    "#001f3f",
];
/*
 * transform a color number (R * 256^2 + G * 256 + B) into classic hex (+alpha) value
 * */
function colorNumberToHex(color, alpha = 1) {
    const alphaHex = alpha !== 1
        ? Math.round(alpha * 255)
            .toString(16)
            .padStart(2, "0")
        : "";
    return toHex(color.toString(16).padStart(6, "0")) + alphaHex;
}
function colorToNumber(color) {
    if (typeof color === "number") {
        return color;
    }
    return Number.parseInt(toHex(color).slice(1, 7), 16);
}
/**
 * Converts any CSS color value to a standardized hex6 value.
 * Accepts: hex3, hex6, hex8, rgb[1] and rgba[1].
 *
 * [1] under the form rgb(r, g, b, a?) or rgba(r, g, b, a?)
 * with r,g,b ∈ [0, 255] and a ∈ [0, 1]
 *
 * toHex("#ABC")
 * >> "#AABBCC"
 *
 * toHex("#AAAFFF")
 * >> "#AAAFFF"
 *
 * toHex("rgb(30, 80, 16)")
 * >> "#1E5010"
 *
 *  * toHex("rgb(30, 80, 16, 0.5)")
 * >> "#1E501080"
 *
 */
function toHex(color) {
    let hexColor = color;
    if (color.startsWith("rgb")) {
        hexColor = rgbaStringToHex(color);
    }
    else {
        hexColor = color.replace("#", "").toUpperCase();
        if (hexColor.length === 3 || hexColor.length === 4) {
            hexColor = hexColor.split("").reduce((acc, h) => acc + h + h, "");
        }
        hexColor = `#${hexColor}`;
    }
    if (!HEX_MATCH.test(hexColor)) {
        throw new Error(`invalid color input: ${color}`);
    }
    return hexColor;
}
function isColorValid(color) {
    try {
        toHex(color);
        return true;
    }
    catch (error) {
        return false;
    }
}
function isHSLAValid(color) {
    try {
        hslaToHex(color);
        return true;
    }
    catch (error) {
        return false;
    }
}
const isColorValueValid = (v) => v >= 0 && v <= 255;
function rgba(r, g, b, a = 1) {
    const isInvalid = !isColorValueValid(r) || !isColorValueValid(g) || !isColorValueValid(b) || a < 0 || a > 1;
    if (isInvalid) {
        throw new Error(`Invalid RGBA values ${[r, g, b, a]}`);
    }
    return { a, b, g, r };
}
/**
 * The relative brightness of a point in the colorspace, normalized to 0 for
 * darkest black and 1 for lightest white.
 * https://www.w3.org/TR/WCAG20/#relativeluminancedef
 */
function relativeLuminance(color) {
    let { r, g, b } = colorToRGBA(color);
    r /= 255;
    g /= 255;
    b /= 255;
    const toLinearValue = (c) => (c <= 0.03928 ? c / 12.92 : ((c + 0.055) / 1.055) ** 2.4);
    const R = toLinearValue(r);
    const G = toLinearValue(g);
    const B = toLinearValue(b);
    return 0.2126 * R + 0.7152 * G + 0.0722 * B;
}
/**
 * Convert a CSS rgb color string to a standardized hex6 color value.
 *
 * rgbaStringToHex("rgb(30, 80, 16)")
 * >> "#1E5010"
 *
 * rgbaStringToHex("rgba(30, 80, 16, 0.5)")
 * >> "#1E501080"
 *
 * DOES NOT SUPPORT NON INTEGER RGB VALUES
 */
function rgbaStringToHex(color) {
    const stringVals = color.replace(RBA_REGEX, "").split(",");
    let alphaHex = 255;
    if (stringVals.length !== 3 && stringVals.length !== 4) {
        throw new Error("invalid color");
    }
    else if (stringVals.length === 4) {
        const alpha = parseFloat(stringVals.pop() || "1");
        if (isNaN(alpha)) {
            throw new Error("invalid alpha value");
        }
        alphaHex = Math.round(alpha * 255);
    }
    const vals = stringVals.map((val) => parseInt(val, 10));
    if (alphaHex !== 255) {
        vals.push(alphaHex);
    }
    return "#" + concat$1(vals.map((value) => value.toString(16).padStart(2, "0"))).toUpperCase();
}
/**
 * RGBA to HEX representation (#RRGGBBAA).
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function rgbaToHex(rgba) {
    let r = rgba.r.toString(16);
    let g = rgba.g.toString(16);
    let b = rgba.b.toString(16);
    let a = Math.round(rgba.a * 255).toString(16);
    if (r.length === 1)
        r = "0" + r;
    if (g.length === 1)
        g = "0" + g;
    if (b.length === 1)
        b = "0" + b;
    if (a.length === 1)
        a = "0" + a;
    if (a === "ff")
        a = "";
    return ("#" + r + g + b + a).toUpperCase();
}
/**
 * Color string to RGBA representation
 */
function colorToRGBA(color) {
    color = toHex(color);
    let r;
    let g;
    let b;
    let a;
    if (color.length === 7) {
        r = parseInt(color[1] + color[2], 16);
        g = parseInt(color[3] + color[4], 16);
        b = parseInt(color[5] + color[6], 16);
        a = 255;
    }
    else if (color.length === 9) {
        r = parseInt(color[1] + color[2], 16);
        g = parseInt(color[3] + color[4], 16);
        b = parseInt(color[5] + color[6], 16);
        a = parseInt(color[7] + color[8], 16);
    }
    else {
        throw new Error("Invalid color");
    }
    a = +(a / 255).toFixed(3);
    return { a, r, g, b };
}
/**
 * HSLA to RGBA.
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function hslaToRGBA(hsla) {
    hsla = { ...hsla };
    // Must be fractions of 1
    hsla.s /= 100;
    hsla.l /= 100;
    const c = (1 - Math.abs(2 * hsla.l - 1)) * hsla.s;
    const x = c * (1 - Math.abs(((hsla.h / 60) % 2) - 1));
    const m = hsla.l - c / 2;
    let r = 0;
    let g = 0;
    let b = 0;
    if (0 <= hsla.h && hsla.h < 60) {
        r = c;
        g = x;
        b = 0;
    }
    else if (60 <= hsla.h && hsla.h < 120) {
        r = x;
        g = c;
        b = 0;
    }
    else if (120 <= hsla.h && hsla.h < 180) {
        r = 0;
        g = c;
        b = x;
    }
    else if (180 <= hsla.h && hsla.h < 240) {
        r = 0;
        g = x;
        b = c;
    }
    else if (240 <= hsla.h && hsla.h < 300) {
        r = x;
        g = 0;
        b = c;
    }
    else if (300 <= hsla.h && hsla.h < 360) {
        r = c;
        g = 0;
        b = x;
    }
    r = Math.round((r + m) * 255);
    g = Math.round((g + m) * 255);
    b = Math.round((b + m) * 255);
    return { a: hsla.a, r, g, b };
}
/**
 * HSLA to RGBA.
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function rgbaToHSLA(rgba) {
    // Make r, g, and b fractions of 1
    const r = rgba.r / 255;
    const g = rgba.g / 255;
    const b = rgba.b / 255;
    // Find greatest and smallest channel values
    const cMin = Math.min(r, g, b);
    const cMax = Math.max(r, g, b);
    const delta = cMax - cMin;
    let h = 0;
    let s = 0;
    let l = 0;
    // Calculate hue
    // No difference
    if (delta === 0)
        h = 0;
    // Red is max
    else if (cMax === r)
        h = ((g - b) / delta) % 6;
    // Green is max
    else if (cMax === g)
        h = (b - r) / delta + 2;
    // Blue is max
    else
        h = (r - g) / delta + 4;
    h = Math.round(h * 60);
    // Make negative hues positive behind 360°
    if (h < 0)
        h += 360;
    l = (cMax + cMin) / 2;
    // Calculate saturation
    s = delta === 0 ? 0 : delta / (1 - Math.abs(2 * l - 1));
    // Multiply l and s by 100
    s = +(s * 100).toFixed(1);
    l = +(l * 100).toFixed(1);
    return { a: rgba.a, h, s, l };
}
function hslaToHex(hsla) {
    return rgbaToHex(hslaToRGBA(hsla));
}
function hexToHSLA(hex) {
    return rgbaToHSLA(colorToRGBA(hex));
}
/**
 * Blend color2 on top of color1, with alpha blending.
 */
function blendColors(color1, color2) {
    const rgba2 = colorToRGBA(color2);
    const rgba1 = colorToRGBA(color1);
    const a = rgba2.a + rgba1.a * (1 - rgba2.a);
    const r = Math.round((rgba2.r * rgba2.a + rgba1.r * rgba1.a * (1 - rgba2.a)) / a);
    const g = Math.round((rgba2.g * rgba2.a + rgba1.g * rgba1.a * (1 - rgba2.a)) / a);
    const b = Math.round((rgba2.b * rgba2.a + rgba1.b * rgba1.a * (1 - rgba2.a)) / a);
    return rgbaToHex({ r, g, b, a });
}
function colorOrNumberToRGBA(color) {
    if (typeof color === "number") {
        return colorToRGBA(colorNumberToHex(color));
    }
    return colorToRGBA(color);
}
/**
 * Will compare two color strings
 * A tolerance can be provided to account for small differences that could
 * be introduced by non-bijective transformations between color spaces.
 *
 * E.g. HSV <-> RGB is not a bijection
 *
 * Note that the tolerance is applied on the euclidean distance between
 * the two **normalized** color values.
 */
function isSameColor(color1, color2, tolerance = 0) {
    if (!(isColorValid(color1) && isColorValid(color2))) {
        return false;
    }
    const rgb1 = colorToRGBA(color1);
    const rgb2 = colorToRGBA(color2);
    // alpha cannot differ as it is not impacted by transformations
    if (rgb1.a !== rgb2.a) {
        return false;
    }
    const diff = Math.sqrt(((rgb1.r - rgb2.r) / 255) ** 2 + ((rgb1.g - rgb2.g) / 255) ** 2 + ((rgb1.b - rgb2.b) / 255) ** 2);
    return diff <= tolerance;
}
function setColorAlpha(color, alpha) {
    return alpha === 1 ? toHex(color).slice(0, 7) : rgbaToHex({ ...colorToRGBA(color), a: alpha });
}
function lightenColor(color, percentage) {
    const hsla = hexToHSLA(color);
    if (percentage === 1) {
        return "#fff";
    }
    hsla.l = percentage * (100 - hsla.l) + hsla.l;
    return hslaToHex(hsla);
}
function darkenColor(color, percentage) {
    const hsla = hexToHSLA(color);
    if (percentage === 1) {
        return "#000";
    }
    // increase saturation to compensate and make it more vivid
    hsla.s = Math.min(100, percentage * hsla.s + hsla.s);
    hsla.l = hsla.l - percentage * hsla.l;
    return hslaToHex(hsla);
}
function chipTextColor(chipBackgroundColor) {
    return relativeLuminance(chipBackgroundColor) < 0.6
        ? lightenColor(chipBackgroundColor, 0.9)
        : darkenColor(chipBackgroundColor, 0.75);
}
const COLORS_SM = [
    "#4EA7F2", // Blue
    "#EA6175", // Red
    "#43C5B1", // Teal
    "#F4A261", // Orange
    "#8481DD", // Purple
    "#FFD86D", // Yellow
];
const COLORS_MD = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
];
const COLORS_LG = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#056BD9", // Blue #3
    "#A76DBC", // Violet #1
    "#7F4295", // Violet #2
    "#6D2387", // Violet #3
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#982738", // Red #3
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#0E8270", // Teal #3
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#BE5D10", // Orange #3
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#3A3580", // Purple #3
    "#A4A8B6", // Gray #1
    "#7E8290", // Gray #2
    "#545B70", // Gray #3
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
    "#C08A16", // Yellow #3
];
const COLORS_XL = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#056BD9", // Blue #3
    "#155193", // Blue #4
    "#A76DBC", // Violet #1
    "#7F4295", // Violet #2
    "#6D2387", // Violet #3
    "#4F1565", // Violet #4
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#982738", // Red #3
    "#791B29", // Red #4
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#0E8270", // Teal #3
    "#105F53", // Teal #4
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#BE5D10", // Orange #3
    "#7D380D", // Orange #4
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#3A3580", // Purple #3
    "#26235F", // Purple #4
    "#A4A8B6", // Grey #1
    "#7E8290", // Grey #2
    "#545B70", // Grey #3
    "#3F4250", // Grey #4
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
    "#C08A16", // Yellow #3
    "#936A12", // Yellow #4
];
// Same as above but with alternating colors
const ALTERNATING_COLORS_MD = [
    "#4EA7F2", // Blue    #1
    "#43C5B1", // Teal    #1
    "#EA6175", // Red     #1
    "#F4A261", // Orange  #1
    "#8481DD", // Purple  #1
    "#FFD86D", // Yellow  #1
    "#3188E6", // Blue    #2
    "#00A78D", // Teal    #2
    "#CE4257", // Red     #2
    "#F48935", // Orange  #2
    "#5752D1", // Purple  #2
    "#FFBC2C", // Yellow  #2
];
const ALTERNATING_COLORS_LG = [
    "#4EA7F2", // Blue    #1
    "#A76DBC", // Violet  #1
    "#EA6175", // Red     #1
    "#43C5B1", // Teal    #1
    "#F4A261", // Orange  #1
    "#8481DD", // Purple  #1
    "#A4A8B6", // Gray    #1
    "#FFD86D", // Yellow  #1
    "#3188E6", // Blue    #2
    "#7F4295", // Violet  #2
    "#CE4257", // Red     #2
    "#00A78D", // Teal    #2
    "#F48935", // Orange  #2
    "#5752D1", // Purple  #2
    "#7E8290", // Gray    #2
    "#FFBC2C", // Yellow  #2
    "#056BD9", // Blue    #3
    "#6D2387", // Violet  #3
    "#982738", // Red     #3
    "#0E8270", // Teal    #3
    "#BE5D10", // Orange  #3
    "#3A3580", // Purple  #3
    "#545B70", // Gray    #3
    "#C08A16", // Yellow  #3
];
const ALTERNATING_COLORS_XL = [
    "#4EA7F2", // Blue    #1
    "#A76DBC", // Violet  #1
    "#EA6175", // Red     #1
    "#43C5B1", // Teal    #1
    "#F4A261", // Orange  #1
    "#8481DD", // Purple  #1
    "#A4A8B6", // Grey    #1
    "#FFD86D", // Yellow  #1
    "#3188E6", // Blue    #2
    "#7F4295", // Violet  #2
    "#CE4257", // Red     #2
    "#00A78D", // Teal    #2
    "#F48935", // Orange  #2
    "#5752D1", // Purple  #2
    "#7E8290", // Grey    #2
    "#FFBC2C", // Yellow  #2
    "#056BD9", // Blue    #3
    "#6D2387", // Violet  #3
    "#982738", // Red     #3
    "#0E8270", // Teal    #3
    "#BE5D10", // Orange  #3
    "#3A3580", // Purple  #3
    "#545B70", // Grey    #3
    "#C08A16", // Yellow  #3
    "#155193", // Blue    #4
    "#4F1565", // Violet  #4
    "#791B29", // Red     #4
    "#105F53", // Teal    #4
    "#7D380D", // Orange  #4
    "#26235F", // Purple  #4
    "#3F4250", // Grey    #4
    "#936A12", // Yellow  #4
];
function getNthColor(index, palette) {
    return palette[index % palette.length];
}
function getColorsPalette(quantity) {
    if (quantity <= 6) {
        return COLORS_SM;
    }
    else if (quantity <= 12) {
        return COLORS_MD;
    }
    else if (quantity <= 24) {
        return COLORS_LG;
    }
    else {
        return COLORS_XL;
    }
}
function getAlternatingColorsPalette(quantity) {
    if (quantity <= 6) {
        return COLORS_SM;
    }
    else if (quantity <= 12) {
        return ALTERNATING_COLORS_MD;
    }
    else if (quantity <= 24) {
        return ALTERNATING_COLORS_LG;
    }
    else {
        return ALTERNATING_COLORS_XL;
    }
}
class ColorGenerator {
    preferredColors;
    currentColorIndex = 0;
    palette;
    constructor(paletteSize, preferredColors = []) {
        this.preferredColors = preferredColors;
        this.palette = getColorsPalette(paletteSize).filter((c) => !preferredColors.includes(c));
    }
    next() {
        return this.preferredColors?.[this.currentColorIndex]
            ? this.preferredColors[this.currentColorIndex++]
            : getNthColor(this.currentColorIndex++, this.palette);
    }
}
class AlternatingColorGenerator extends ColorGenerator {
    constructor(paletteSize, preferredColors = []) {
        super(paletteSize, preferredColors);
        this.palette = getAlternatingColorsPalette(paletteSize).filter((c) => !preferredColors.includes(c));
    }
}
class AlternatingColorMap {
    availableColors;
    colors = {};
    constructor(paletteSize = 12) {
        this.availableColors = new AlternatingColorGenerator(paletteSize);
    }
    get(id) {
        if (!this.colors[id]) {
            this.colors[id] = this.availableColors.next();
        }
        return this.colors[id];
    }
}
/**
 * Returns a function that maps a value to a color using a color scale defined by the given
 * color/threshold values pairs.
 */
function getColorScale(colorScalePoints) {
    if (colorScalePoints.length < 2) {
        throw new Error("Color scale must have at least 2 points");
    }
    const sortedColorScalePoints = [...colorScalePoints.sort((a, b) => a.value - b.value)];
    const thresholds = [];
    for (let i = 1; i < sortedColorScalePoints.length; i++) {
        const minColorAlpha = colorOrNumberToRGBA(sortedColorScalePoints[i - 1].color).a;
        const maxColorAlpha = colorOrNumberToRGBA(sortedColorScalePoints[i].color).a;
        const minColor = colorToNumber(sortedColorScalePoints[i - 1].color);
        const maxColor = colorToNumber(sortedColorScalePoints[i].color);
        thresholds.push({
            min: sortedColorScalePoints[i - 1].value,
            max: sortedColorScalePoints[i].value,
            minColor,
            maxColor,
            minColorAlpha: minColorAlpha,
            maxColorAlpha: maxColorAlpha,
            colorDiff: computeColorDiffUnits(sortedColorScalePoints[i - 1].value, sortedColorScalePoints[i].value, minColor, maxColor),
        });
    }
    return (value) => {
        if (value < thresholds[0].min) {
            return colorNumberToHex(thresholds[0].minColor, thresholds[0].minColorAlpha);
        }
        for (const threshold of thresholds) {
            if (value >= threshold.min && value <= threshold.max) {
                return colorNumberToHex(colorCell(value, threshold.min, threshold.minColor, threshold.colorDiff), threshold.maxColorAlpha);
            }
        }
        return colorNumberToHex(thresholds[thresholds.length - 1].maxColor, thresholds[thresholds.length - 1].maxColorAlpha);
    };
}
function computeColorDiffUnits(minValue, maxValue, minColor, maxColor) {
    const deltaValue = maxValue - minValue;
    const deltaColorR = ((minColor >> 16) % 256) - ((maxColor >> 16) % 256);
    const deltaColorG = ((minColor >> 8) % 256) - ((maxColor >> 8) % 256);
    const deltaColorB = (minColor % 256) - (maxColor % 256);
    const colorDiffUnitR = deltaColorR / deltaValue;
    const colorDiffUnitG = deltaColorG / deltaValue;
    const colorDiffUnitB = deltaColorB / deltaValue;
    return [colorDiffUnitR, colorDiffUnitG, colorDiffUnitB];
}
function colorCell(value, minValue, minColor, colorDiffUnit) {
    const [colorDiffUnitR, colorDiffUnitG, colorDiffUnitB] = colorDiffUnit;
    const r = Math.round(((minColor >> 16) % 256) - colorDiffUnitR * (value - minValue));
    const g = Math.round(((minColor >> 8) % 256) - colorDiffUnitG * (value - minValue));
    const b = Math.round((minColor % 256) - colorDiffUnitB * (value - minValue));
    return (r << 16) | (g << 8) | b;
}

function evaluateLiteral(literalCell, localeFormat, position) {
    const value = isTextFormat(localeFormat.format) && literalCell.parsedValue !== null
        ? literalCell.content
        : literalCell.parsedValue;
    const functionResult = { value, format: localeFormat.format, origin: position };
    return createEvaluatedCell(functionResult, localeFormat.locale);
}
function parseLiteral(content, locale) {
    if (content.startsWith("=")) {
        throw new Error(`Cannot parse "${content}" because it's not a literal value. It's a formula`);
    }
    if (content.startsWith("'")) {
        return content.slice(1);
    }
    if (content === "") {
        return null;
    }
    if (content.includes("\n")) {
        return content;
    }
    if (isNumber(content, DEFAULT_LOCALE)) {
        return parseNumber(content, DEFAULT_LOCALE);
    }
    const internalDate = parseDateTime(content, locale);
    if (internalDate) {
        return internalDate.value;
    }
    if (isBoolean(content)) {
        return content.toUpperCase() === "TRUE";
    }
    return content;
}
function createEvaluatedCell(functionResult, locale = DEFAULT_LOCALE, cell, origin) {
    const link = detectLink(functionResult.value);
    if (!link) {
        const evaluateCell = _createEvaluatedCell(functionResult, locale, cell);
        return addOrigin(evaluateCell, functionResult.origin ?? origin);
    }
    const value = parseLiteral(link.label, locale);
    const format = functionResult.format ||
        (typeof value === "number"
            ? detectDateFormat(link.label, locale) || detectNumberFormat(link.label)
            : undefined);
    const linkPayload = {
        value,
        format,
    };
    return addOrigin({
        ..._createEvaluatedCell(linkPayload, locale, cell),
        link,
    }, functionResult.origin ?? origin);
}
function _createEvaluatedCell(functionResult, locale, cell) {
    let { value, format, message } = functionResult;
    format = cell?.format || format;
    const formattedValue = formatValue$1(value, { format, locale });
    if (isEvaluationError(value)) {
        return errorCell(value, message);
    }
    if (value === null) {
        return emptyCell(format);
    }
    if (isTextFormat(format)) {
        // TO DO:
        // with the next line, the value of the cell is transformed depending on the format.
        // This shouldn't happen, by doing this, the formulas handling numbers are not able
        // to interpret the value as a number.
        return textCell(toString(value), format, formattedValue);
    }
    if (typeof value === "number") {
        if (isDateTimeFormat(format || "")) {
            return dateTimeCell(value, format, formattedValue);
        }
        return numberCell(value, format, formattedValue);
    }
    if (typeof value === "boolean") {
        return booleanCell(value, format, formattedValue);
    }
    return textCell(value, format, formattedValue);
}
function textCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.text,
        isAutoSummable: true,
        defaultAlign: "left",
    };
}
function numberCell(value, format, formattedValue) {
    return {
        value: value || 0, // necessary to avoid "-0" and NaN values,
        format,
        formattedValue,
        type: CellValueType.number,
        isAutoSummable: true,
        defaultAlign: "right",
    };
}
const emptyCell = memoize$1(function emptyCell(format) {
    return {
        value: null,
        format,
        formattedValue: "",
        type: CellValueType.empty,
        isAutoSummable: true,
        defaultAlign: "left",
    };
});
function dateTimeCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.number,
        isAutoSummable: false,
        defaultAlign: "right",
    };
}
function booleanCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.boolean,
        isAutoSummable: false,
        defaultAlign: "center",
    };
}
function errorCell(value, message) {
    return {
        value,
        formattedValue: value,
        message,
        type: CellValueType.error,
        isAutoSummable: false,
        defaultAlign: "center",
    };
}
function addOrigin(cell, origin) {
    if (cell.value === null) {
        // ignore empty cells to allow sharing the same object instance
        return cell;
    }
    if ("origin" in cell) {
        return cell;
    }
    cell.origin = origin;
    return cell;
}

function toCriterionDateNumber(dateValue) {
    const today = DateTime$1.now();
    switch (dateValue) {
        case "today":
            return jsDateToNumber(today);
        case "yesterday":
            return jsDateToNumber(DateTime$1.fromTimestamp(today.setDate(today.getDate() - 1)));
        case "tomorrow":
            return jsDateToNumber(DateTime$1.fromTimestamp(today.setDate(today.getDate() + 1)));
        case "lastWeek":
            return jsDateToNumber(DateTime$1.fromTimestamp(today.setDate(today.getDate() - 7)));
        case "lastMonth":
            return jsDateToNumber(DateTime$1.fromTimestamp(today.setMonth(today.getMonth() - 1)));
        case "lastYear":
            return jsDateToNumber(DateTime$1.fromTimestamp(today.setFullYear(today.getFullYear() - 1)));
    }
}
/** Get all the dates values of a criterion converted to numbers, converting date values such as "today" to actual dates  */
function getDateNumberCriterionValues(criterion, locale) {
    if ("dateValue" in criterion && criterion.dateValue !== "exactDate") {
        return [toCriterionDateNumber(criterion.dateValue)];
    }
    return criterion.values.map((value) => valueToDateNumber(value, locale));
}
function getDateCriterionFormattedValues(values, locale) {
    return values.map((valueStr) => {
        if (valueStr.startsWith("=")) {
            return valueStr;
        }
        const value = parseLiteral(valueStr, locale);
        if (typeof value === "number") {
            return formatValue$1(value, { format: locale.dateFormat, locale });
        }
        return "";
    });
}

const globalReverseLookup$1 = new WeakMap();
const globalIdCounter = new WeakMap();
/**
 * Get the id of the given item (its key in the given dictionary).
 * If the given item does not exist in the dictionary, it creates one with a new id.
 */
function getItemId(item, itemsDic) {
    if (!globalReverseLookup$1.has(itemsDic)) {
        globalReverseLookup$1.set(itemsDic, new Map());
        globalIdCounter.set(itemsDic, 0);
    }
    const reverseLookup = globalReverseLookup$1.get(itemsDic);
    const canonical = getCanonicalRepresentation(item);
    if (reverseLookup.has(canonical)) {
        const id = reverseLookup.get(canonical);
        itemsDic[id] = item;
        return id;
    }
    // Generate new Id if the item didn't exist in the dictionary
    const newId = globalIdCounter.get(itemsDic) + 1;
    reverseLookup.set(canonical, newId);
    globalIdCounter.set(itemsDic, newId);
    itemsDic[newId] = item;
    return newId;
}
function groupItemIdsByZones(positionsByItemId) {
    const result = {};
    for (const itemId in positionsByItemId) {
        const zones = recomputeZones(positionsByItemId[itemId].map(positionToZone));
        for (const zone of zones) {
            result[zoneToXc(zone)] = Number(itemId);
        }
    }
    return result;
}
function* iterateItemIdsPositions(sheetId, itemIdsByZones) {
    for (const zoneXc in itemIdsByZones) {
        const zone = toZone(zoneXc);
        const itemId = itemIdsByZones[zoneXc];
        for (let row = zone.top; row <= zone.bottom; row++) {
            for (let col = zone.left; col <= zone.right; col++) {
                const position = { sheetId, col, row };
                yield [position, itemId];
            }
        }
    }
}
function getCanonicalRepresentation(item) {
    if (item === null)
        return "null";
    if (item === undefined)
        return "undefined";
    if (typeof item !== "object")
        return String(item);
    if (Array.isArray(item)) {
        const len = item.length;
        let result = "[";
        for (let i = 0; i < len; i++) {
            if (i > 0)
                result += ",";
            result += getCanonicalRepresentation(item[i]);
        }
        return result + "]";
    }
    const keys = Object.keys(item).sort();
    let repr = "{";
    for (const key of keys) {
        if (item[key] !== undefined) {
            repr += `"${key}":${getCanonicalRepresentation(item[key])},`;
        }
    }
    repr += "}";
    return repr;
}

const MAX_DELAY = 140;
const MIN_DELAY = 20;
const ACCELERATION = 0.035;
/**
 * Decreasing exponential function used to determine the "speed" of edge-scrolling
 * as the timeout delay.
 *
 * Returns a timeout delay in milliseconds.
 */
function scrollDelay(value) {
    // decreasing exponential from MAX_DELAY to MIN_DELAY
    return MIN_DELAY + (MAX_DELAY - MIN_DELAY) * Math.exp(-ACCELERATION * (value - 1));
}

function createDefaultRows(rowNumber) {
    const rows = [];
    for (let i = 0; i < rowNumber; i++) {
        const row = {
            cells: {},
        };
        rows.push(row);
    }
    return rows;
}
function moveHeaderIndexesOnHeaderAddition(indexHeaderAdded, numberAdded, headers) {
    return headers.map((header) => {
        if (header >= indexHeaderAdded) {
            return header + numberAdded;
        }
        return header;
    });
}
function moveHeaderIndexesOnHeaderDeletion(deletedHeaders, headers) {
    deletedHeaders = [...deletedHeaders].sort((a, b) => b - a);
    return headers
        .map((header) => {
        for (const deletedHeader of deletedHeaders) {
            if (header > deletedHeader) {
                header--;
            }
            else if (header === deletedHeader) {
                return undefined;
            }
        }
        return header;
    })
        .filter(isDefined$1);
}
function getNextSheetName(existingNames, baseName = "Sheet") {
    let i = 1;
    let name = `${baseName}${i}`;
    while (existingNames.includes(name)) {
        name = `${baseName}${i}`;
        i++;
    }
    return name;
}
function getDuplicateSheetName(nameToDuplicate, existingNames) {
    let i = 1;
    const baseName = _t$1("Copy of %s", nameToDuplicate);
    let name = baseName.toString();
    while (existingNames.includes(name)) {
        name = `${baseName} (${i})`;
        i++;
    }
    return name;
}
function isSheetNameEqual(name1, name2) {
    if (name1 === undefined || name2 === undefined) {
        return false;
    }
    return (getUnquotedSheetName(name1.trim().toUpperCase()) ===
        getUnquotedSheetName(name2.trim().toUpperCase()));
}

function createRange(args, getSheetSize) {
    const unboundedZone = args.zone;
    const zone = boundUnboundedZone(unboundedZone, getSheetSize(args.sheetId));
    let parts = args.parts;
    if (args.parts.length === 1 && getZoneArea(zone) > 1) {
        parts = [args.parts[0], args.parts[0]];
    }
    else if (args.parts.length === 2 && getZoneArea(zone) === 1) {
        parts = [args.parts[0]];
    }
    return {
        unboundedZone,
        zone,
        parts,
        prefixSheet: args.prefixSheet,
        invalidSheetName: args.invalidSheetName,
        sheetId: args.sheetId,
    };
}
/**
 * Create a range from a string XC: A1, Sheet1!A1
 * The XC is expected to be valid.
 */
function createRangeFromXc(args, getSheetSize) {
    const fullXc = args.xc;
    const { xc, sheetName } = splitReference(fullXc);
    const unboundedZone = toUnboundedZone(xc);
    const parts = getRangeParts(xc, unboundedZone);
    return createRange({
        zone: unboundedZone,
        parts,
        sheetId: args.sheetId,
        prefixSheet: Boolean(sheetName),
        invalidSheetName: args.invalidSheetName,
    }, getSheetSize);
}
function createInvalidRange(sheetXC) {
    const invalidZone = { left: -1, top: -1, right: -1, bottom: -1 };
    return {
        sheetId: "",
        zone: invalidZone,
        unboundedZone: invalidZone,
        parts: [],
        invalidXc: sheetXC,
        prefixSheet: false,
    };
}
function isFullColRange(range) {
    return isFullCol(range.unboundedZone);
}
function isFullRowRange(range) {
    return isFullRow(range.unboundedZone);
}
function getRangeString(range, forSheetId, getSheetName, options = { useBoundedReference: false, useFixedReference: false }) {
    if (range.invalidXc) {
        return range.invalidXc;
    }
    if (range.zone.bottom - range.zone.top < 0 || range.zone.right - range.zone.left < 0) {
        return CellErrorType$1.InvalidReference;
    }
    if (range.zone.left < 0 || range.zone.top < 0) {
        return CellErrorType$1.InvalidReference;
    }
    const prefixSheet = range.sheetId !== forSheetId || range.invalidSheetName || range.prefixSheet;
    let sheetName = "";
    if (prefixSheet) {
        if (range.invalidSheetName) {
            sheetName = range.invalidSheetName;
        }
        else {
            sheetName = getCanonicalSymbolName(getSheetName(range.sheetId));
        }
    }
    if (prefixSheet && !sheetName) {
        return CellErrorType$1.InvalidReference;
    }
    let rangeString = getRangePartString(range, 0, options);
    if (range.parts && range.parts.length === 2) {
        // range if converts A2:A2 into A2 except if any part of the original range had fixed row or column (with $)
        if (range.zone.top !== range.zone.bottom ||
            range.zone.left !== range.zone.right ||
            range.parts[0].rowFixed ||
            range.parts[0].colFixed ||
            range.parts[1].rowFixed ||
            range.parts[1].colFixed) {
            rangeString += ":";
            rangeString += getRangePartString(range, 1, options);
        }
    }
    return `${prefixSheet ? sheetName + "!" : ""}${rangeString}`;
}
/**
 * Duplicate a range. If the range is on the sheetIdFrom, the range will target
 * sheetIdTo.
 */
function duplicateRangeInDuplicatedSheet(sheetIdFrom, sheetIdTo, range) {
    const sheetId = range.sheetId === sheetIdFrom ? sheetIdTo : range.sheetId;
    return { ...range, sheetId };
}
/**
 * Create a range from a xc. If the xc is empty, this function returns undefined.
 */
function createValidRange(getters, sheetId, xc) {
    if (!xc)
        return;
    const range = getters.getRangeFromSheetXC(sheetId, xc);
    return !(range.invalidSheetName || range.invalidXc) ? range : undefined;
}
/**
 * Get all the cell positions in the given ranges. If a cell is in multiple ranges, it will be returned multiple times.
 */
function getCellPositionsInRanges(ranges) {
    const cellPositions = [];
    for (const range of ranges) {
        for (const position of positions(range.zone)) {
            cellPositions.push({ ...position, sheetId: range.sheetId });
        }
    }
    return cellPositions;
}
function getRangeParts(xc, zone) {
    const parts = xc.split(":").map((p) => {
        const isFullRow = isRowReference(p);
        return {
            colFixed: isFullRow ? false : p.startsWith("$"),
            rowFixed: isFullRow ? p.startsWith("$") : p.includes("$", 1),
        };
    });
    const isFullCol = zone.bottom === undefined;
    const isFullRow = zone.right === undefined;
    if (isFullCol) {
        parts[0].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
        parts[1].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
    }
    if (isFullRow) {
        parts[0].colFixed = parts[0].colFixed || parts[1].colFixed;
        parts[1].colFixed = parts[0].colFixed || parts[1].colFixed;
    }
    return parts;
}
/**
 * Check that a zone is valid regarding the order of top-bottom and left-right.
 * Left should be smaller than right, top should be smaller than bottom.
 * If it's not the case, simply invert them, and invert the linked parts
 */
function orderRange(range) {
    if (isZoneOrdered(range.zone)) {
        return range;
    }
    const unboundedZone = { ...range.unboundedZone };
    const zone = { ...range.zone };
    let parts = range.parts;
    if (unboundedZone.right !== undefined && unboundedZone.right < unboundedZone.left) {
        const right = unboundedZone.right;
        unboundedZone.right = unboundedZone.left;
        unboundedZone.left = right;
        zone.right = zone.left;
        zone.left = right;
        parts = [
            {
                colFixed: parts[1]?.colFixed || false,
                rowFixed: parts[0]?.rowFixed || false,
            },
            {
                colFixed: parts[0]?.colFixed || false,
                rowFixed: parts[1]?.rowFixed || false,
            },
        ];
    }
    if (unboundedZone.bottom !== undefined && unboundedZone.bottom < unboundedZone.top) {
        const bottom = unboundedZone.bottom;
        unboundedZone.bottom = unboundedZone.top;
        unboundedZone.top = bottom;
        zone.bottom = zone.top;
        zone.top = bottom;
        parts = [
            {
                colFixed: parts[0]?.colFixed || false,
                rowFixed: parts[1]?.rowFixed || false,
            },
            {
                colFixed: parts[1]?.colFixed || false,
                rowFixed: parts[0]?.rowFixed || false,
            },
        ];
    }
    return {
        unboundedZone,
        zone,
        parts,
        invalidXc: range.invalidXc,
        prefixSheet: range.prefixSheet,
        invalidSheetName: range.invalidSheetName,
        sheetId: range.sheetId,
    };
}
function getRangeAdapter(cmd) {
    return rangeAdapterRegistry.get(cmd.type)?.(cmd);
}
class RangeAdapterRegistry extends Registry {
    add(cmdType, fn) {
        super.add(cmdType, fn);
        return this;
    }
    get(cmdType) {
        return this.content[cmdType];
    }
}
const rangeAdapterRegistry = new RangeAdapterRegistry();
rangeAdapterRegistry
    .add("REMOVE_COLUMNS_ROWS", (cmd) => ({
    applyChange: getApplyRangeChangeRemoveColRow(cmd),
    sheetId: cmd.sheetId,
    sheetName: { old: cmd.sheetName, current: cmd.sheetName },
}))
    .add("ADD_COLUMNS_ROWS", (cmd) => ({
    applyChange: getApplyRangeChangeAddColRow(cmd),
    sheetId: cmd.sheetId,
    sheetName: { old: cmd.sheetName, current: cmd.sheetName },
}))
    .add("DELETE_SHEET", (cmd) => ({
    applyChange: getApplyRangeChangeDeleteSheet(cmd),
    sheetId: cmd.sheetId,
    sheetName: { old: cmd.sheetName, current: cmd.sheetName },
}))
    .add("RENAME_SHEET", (cmd) => ({
    applyChange: getApplyRangeChangeRenameSheet(cmd),
    sheetId: cmd.sheetId,
    sheetName: { old: cmd.oldName, current: cmd.newName },
}))
    .add("MOVE_RANGES", (cmd) => ({
    applyChange: getApplyRangeChangeMoveRange(cmd),
    sheetId: cmd.sheetId,
    sheetName: { old: cmd.sheetName, current: cmd.sheetName },
}));
function getApplyRangeChangeRemoveColRow(cmd) {
    const start = cmd.dimension === "COL" ? "left" : "top";
    const end = cmd.dimension === "COL" ? "right" : "bottom";
    const dimension = cmd.dimension === "COL" ? "columns" : "rows";
    const elements = [...cmd.elements];
    elements.sort((a, b) => b - a);
    const groups = groupConsecutive$1(elements);
    return (range) => {
        if (!isSheetNameEqual(range.sheetId, cmd.sheetId)) {
            return { changeType: "NONE" };
        }
        let newRange = range;
        let changeType = "NONE";
        for (const group of groups) {
            const min = largeMin(group);
            const max = largeMax(group);
            if (range.zone[start] <= min && min <= range.zone[end]) {
                const toRemove = Math.min(range.zone[end], max) - min + 1;
                changeType = "RESIZE";
                newRange = createAdaptedRange(newRange, dimension, changeType, -toRemove);
            }
            else if (range.zone[start] >= min && range.zone[end] <= max) {
                changeType = "REMOVE";
                newRange = createInvalidRange(CellErrorType$1.InvalidReference);
            }
            else if (range.zone[start] <= max && range.zone[end] >= max) {
                const toRemove = max - range.zone[start] + 1;
                changeType = "RESIZE";
                newRange = createAdaptedRange(newRange, dimension, changeType, -toRemove);
                newRange = createAdaptedRange(newRange, dimension, "MOVE", -(range.zone[start] - min));
            }
            else if (min < range.zone[start]) {
                changeType = "MOVE";
                newRange = createAdaptedRange(newRange, dimension, changeType, -(max - min + 1));
            }
        }
        if (changeType !== "NONE") {
            return { changeType, range: newRange };
        }
        return { changeType: "NONE" };
    };
}
function getApplyRangeChangeAddColRow(cmd) {
    const start = cmd.dimension === "COL" ? "left" : "top";
    const end = cmd.dimension === "COL" ? "right" : "bottom";
    const dimension = cmd.dimension === "COL" ? "columns" : "rows";
    return (range) => {
        if (range.sheetId !== cmd.sheetId) {
            return { changeType: "NONE" };
        }
        if (cmd.position === "after") {
            if (range.zone[start] <= cmd.base && cmd.base < range.zone[end]) {
                return {
                    changeType: "RESIZE",
                    range: createAdaptedRange(range, dimension, "RESIZE", cmd.quantity),
                };
            }
            if (cmd.base < range.zone[start]) {
                return {
                    changeType: "MOVE",
                    range: createAdaptedRange(range, dimension, "MOVE", cmd.quantity),
                };
            }
        }
        else {
            if (range.zone[start] < cmd.base && cmd.base <= range.zone[end]) {
                return {
                    changeType: "RESIZE",
                    range: createAdaptedRange(range, dimension, "RESIZE", cmd.quantity),
                };
            }
            if (cmd.base <= range.zone[start]) {
                return {
                    changeType: "MOVE",
                    range: createAdaptedRange(range, dimension, "MOVE", cmd.quantity),
                };
            }
        }
        return { changeType: "NONE" };
    };
}
function getApplyRangeChangeDeleteSheet(cmd) {
    return (range) => {
        if (range.sheetId !== cmd.sheetId && range.invalidSheetName !== cmd.sheetName) {
            return { changeType: "NONE" };
        }
        const invalidSheetName = cmd.sheetName;
        range = {
            ...createInvalidRange(CellErrorType$1.InvalidReference),
            invalidSheetName,
        };
        return { changeType: "REMOVE", range };
    };
}
function getApplyRangeChangeRenameSheet(cmd) {
    return (range) => {
        if (range.sheetId === cmd.sheetId) {
            return { changeType: "CHANGE", range };
        }
        if (cmd.newName && range.invalidSheetName === cmd.newName) {
            const invalidSheetName = undefined;
            const sheetId = cmd.sheetId;
            const newRange = { ...range, sheetId, invalidSheetName };
            return { changeType: "CHANGE", range: newRange };
        }
        if (cmd.oldName && range.invalidSheetName === cmd.oldName) {
            const invalidSheetName = undefined;
            const sheetId = cmd.sheetId;
            const newRange = { ...range, sheetId, invalidSheetName };
            return { changeType: "CHANGE", range: newRange };
        }
        return { changeType: "NONE" };
    };
}
function getApplyRangeChangeMoveRange(cmd) {
    const originZone = cmd.target[0];
    return (range) => {
        if (range.sheetId !== cmd.sheetId || !isZoneInside(range.zone, originZone)) {
            return { changeType: "NONE" };
        }
        const targetSheetId = cmd.targetSheetId;
        const offsetX = cmd.col - originZone.left;
        const offsetY = cmd.row - originZone.top;
        const adaptedRange = createAdaptedRange(range, "both", "MOVE", [offsetX, offsetY]);
        const prefixSheet = cmd.sheetId === targetSheetId ? adaptedRange.prefixSheet : true;
        return {
            changeType: "MOVE",
            range: { ...adaptedRange, sheetId: targetSheetId, prefixSheet },
        };
    };
}
function createAdaptedRange(range, dimension, operation, by) {
    return {
        ...range,
        unboundedZone: createAdaptedZone(range.unboundedZone, dimension, operation, by),
        zone: createAdaptedZone(range.zone, dimension, operation, by),
    };
}
function getRangePartString(range, part, options = { useBoundedReference: false, useFixedReference: false }) {
    const colFixed = range.parts[part]?.colFixed || options.useFixedReference ? "$" : "";
    const col = part === 0 ? numberToLetters(range.zone.left) : numberToLetters(range.zone.right);
    const rowFixed = range.parts[part]?.rowFixed || options.useFixedReference ? "$" : "";
    const row = part === 0 ? String(range.zone.top + 1) : String(range.zone.bottom + 1);
    let str = "";
    if (isFullCol(range.unboundedZone) && !options.useBoundedReference) {
        if (part === 0 && range.unboundedZone.hasHeader) {
            str = colFixed + col + rowFixed + row;
        }
        else {
            str = colFixed + col;
        }
    }
    else if (isFullRow(range.unboundedZone) && !options.useBoundedReference) {
        if (part === 0 && range.unboundedZone.hasHeader) {
            str = colFixed + col + rowFixed + row;
        }
        else {
            str = rowFixed + row;
        }
    }
    else {
        str = colFixed + col + rowFixed + row;
    }
    return str;
}

function computeTextLinesHeight(textLineHeight, numberOfLines = 1) {
    return numberOfLines * (textLineHeight + MIN_CELL_TEXT_MARGIN) - MIN_CELL_TEXT_MARGIN;
}
function getCanvas(width = 100, height = 100) {
    // Browser environment
    return new OffscreenCanvas(width, height).getContext("2d");
}
/**
 * Get the default height of the cell given its style.
 */
function getDefaultCellHeight(ctx, cell, colSize) {
    if (!cell || (!cell.isFormula && !cell.content)) {
        return DEFAULT_CELL_HEIGHT;
    }
    const content = cell.isFormula ? "" : cell.content;
    return getCellContentHeight(ctx, content, cell.style, colSize);
}
function getCellContentHeight(ctx, content, style, colSize) {
    const maxWidth = style?.wrapping === "wrap" ? colSize - 2 * MIN_CELL_TEXT_MARGIN : undefined;
    const numberOfLines = splitTextToWidth(ctx, content, style, maxWidth).length;
    const fontSize = computeTextFontSizeInPixels(style);
    return computeTextLinesHeight(fontSize, numberOfLines) + 2 * PADDING_AUTORESIZE_VERTICAL;
}
function getDefaultContextFont(fontSize, bold = false, italic = false) {
    const italicStr = italic ? "italic" : "";
    const weight = bold ? "bold" : "";
    return `${italicStr} ${weight} ${fontSize}px ${DEFAULT_FONT}`;
}
const textWidthCache = {};
function computeTextWidth(context, text, style, fontUnit = "pt") {
    const font = computeTextFont(style, fontUnit);
    return computeCachedTextWidth(context, text, font);
}
function computeCachedTextWidth(context, text, font) {
    if (!textWidthCache[font]) {
        textWidthCache[font] = {};
    }
    if (textWidthCache[font][text] === undefined) {
        const oldFont = context.font;
        context.font = font;
        textWidthCache[font][text] = context.measureText(text).width;
        context.font = oldFont;
    }
    return textWidthCache[font][text];
}
const textDimensionsCache = {};
function computeTextDimension(context, text, style, fontUnit = "pt") {
    const font = computeTextFont(style, fontUnit);
    context.save();
    context.font = font;
    const dimensions = computeCachedTextDimension(context, text);
    context.restore();
    return dimensions;
}
function computeCachedTextDimension(context, text) {
    const font = context.font;
    if (!textDimensionsCache[font]) {
        textDimensionsCache[font] = {};
    }
    if (textDimensionsCache[font][text] === undefined) {
        const measure = context.measureText(text);
        const width = measure.width;
        const height = measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent;
        textDimensionsCache[font][text] = { width, height };
    }
    return textDimensionsCache[font][text];
}
function fontSizeInPixels(fontSize) {
    return Math.round((fontSize * 96) / 72);
}
function computeTextFont(style, fontUnit = "pt") {
    const italic = style.italic ? "italic " : "";
    const weight = style.bold ? "bold" : DEFAULT_FONT_WEIGHT;
    const size = fontUnit === "pt" ? computeTextFontSizeInPixels(style) : style.fontSize;
    return `${italic}${weight} ${size ?? DEFAULT_FONT_SIZE}px ${DEFAULT_FONT}`;
}
function computeTextFontSizeInPixels(style) {
    const sizeInPt = style?.fontSize || DEFAULT_FONT_SIZE;
    return fontSizeInPixels(sizeInPt);
}
function splitWordToSpecificWidth(ctx, word, width, style) {
    const wordWidth = computeTextWidth(ctx, word, style);
    if (wordWidth <= width) {
        return [word];
    }
    const splitWord = [];
    let wordPart = "";
    for (const l of word) {
        const wordPartWidth = computeTextWidth(ctx, wordPart + l, style);
        if (wordPartWidth > width) {
            splitWord.push(wordPart);
            wordPart = l;
        }
        else {
            wordPart += l;
        }
    }
    splitWord.push(wordPart);
    return splitWord;
}
/**
 * Return the given text, split in multiple lines if needed. The text will be split in multiple
 * line if it contains NEWLINE characters, or if it's longer than the given width.
 */
function splitTextToWidth(ctx, text, style, width) {
    if (!style)
        style = {};
    if (isMarkdownLink(text))
        text = parseMarkdownLink(text).label;
    const brokenText = [];
    // Checking if text contains NEWLINE before split makes it very slightly slower if text contains it,
    // but 5-10x faster if it doesn't
    const lines = text.includes(NEWLINE) ? text.split(NEWLINE) : [text];
    for (const line of lines) {
        const words = line.includes(" ") ? line.split(" ") : [line];
        if (!width) {
            brokenText.push(line);
            continue;
        }
        let textLine = "";
        let availableWidth = width;
        for (const word of words) {
            const splitWord = splitWordToSpecificWidth(ctx, word, width, style);
            const lastPart = splitWord.pop();
            const lastPartWidth = computeTextWidth(ctx, lastPart, style);
            // At this step: "splitWord" is an array composed of parts of word whose
            // length is at most equal to "width".
            // Last part contains the end of the word.
            // Note that: When word length is less than width, then lastPart is equal
            // to word and splitWord is empty
            if (splitWord.length) {
                if (textLine !== "") {
                    brokenText.push(textLine);
                    textLine = "";
                    availableWidth = width;
                }
                splitWord.forEach((wordPart) => {
                    brokenText.push(wordPart);
                });
                textLine = lastPart;
                availableWidth = width - lastPartWidth;
            }
            else {
                // here "lastPart" is equal to "word" and the "word" size is smaller than "width"
                const _word = textLine === "" ? lastPart : " " + lastPart;
                const wordWidth = computeTextWidth(ctx, _word, style);
                if (wordWidth <= availableWidth) {
                    textLine += _word;
                    availableWidth -= wordWidth;
                }
                else {
                    brokenText.push(textLine);
                    textLine = lastPart;
                    availableWidth = width - lastPartWidth;
                }
            }
        }
        if (textLine !== "") {
            brokenText.push(textLine);
        }
    }
    return brokenText;
}
/**
 * Return the font size that makes the width of a text match the given line width.
 * Minimum font size is 1.
 *
 * @param getTextWidth function that takes a fontSize as argument, and return the width of the text with this font size.
 */
function getFontSizeMatchingWidth(lineWidth, maxFontSize, getTextWidth, precision = 0.25) {
    let minFontSize = 1;
    if (getTextWidth(minFontSize) > lineWidth)
        return minFontSize;
    if (getTextWidth(maxFontSize) < lineWidth)
        return maxFontSize;
    // Dichotomic search
    let fontSize = (minFontSize + maxFontSize) / 2;
    let currentTextWidth = getTextWidth(fontSize);
    // Use a maximum number of iterations to be safe, because measuring text isn't 100% precise
    let iterations = 0;
    while (Math.abs(currentTextWidth - lineWidth) > precision && iterations < 20) {
        if (currentTextWidth >= lineWidth) {
            maxFontSize = (minFontSize + maxFontSize) / 2;
        }
        else {
            minFontSize = (minFontSize + maxFontSize) / 2;
        }
        fontSize = (minFontSize + maxFontSize) / 2;
        currentTextWidth = getTextWidth(fontSize);
        iterations++;
    }
    return fontSize;
}
/** Transform a string to lower case. If the string is undefined, return an empty string */
function toLowerCase(str) {
    return str ? str.toLowerCase() : "";
}
/**
 * Extract the fontSize from a context font string
 * @param font The (context) font string to parse
 * @returns The fontSize in pixels
 */
const pxRegex = /([0-9\.]*)px/;
function getContextFontSize(font) {
    return Number(font.match(pxRegex)?.[1]);
}
// Inspired from https://stackoverflow.com/a/10511598
function clipTextWithEllipsis(ctx, text, maxWidth) {
    let width = computeCachedTextWidth(ctx, text, ctx.font);
    if (width <= maxWidth) {
        return text;
    }
    const ellipsis = "…";
    const ellipsisWidth = computeCachedTextWidth(ctx, ellipsis, ctx.font);
    if (width <= ellipsisWidth) {
        return text;
    }
    let len = text.length;
    while (width >= maxWidth - ellipsisWidth && len-- > 0) {
        text = text.substring(0, len);
        width = computeCachedTextWidth(ctx, text, ctx.font);
    }
    return text + ellipsis;
}
function drawDecoratedText(context, text, position, underline = false, strikethrough = false, strokeWidth = getContextFontSize(context.font) / 10 //This value is defined to get a good looking stroke
) {
    context.fillText(text, position.x, position.y);
    if (!underline && !strikethrough) {
        return;
    }
    const measure = context.measureText(text);
    const textWidth = measure.width;
    const textHeight = measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent;
    const boxHeight = measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent;
    let { x, y } = position;
    let strikeY = y, underlineY = y;
    switch (context.textAlign) {
        case "center":
            x -= textWidth / 2;
            break;
        case "right":
            x -= textWidth;
            break;
    }
    switch (context.textBaseline) {
        case "top":
            underlineY += boxHeight - 2 * strokeWidth;
            strikeY += boxHeight / 2 - strokeWidth;
            break;
        case "middle":
            underlineY += boxHeight / 2 - strokeWidth;
            break;
        case "alphabetic":
            underlineY += 2 * strokeWidth;
            strikeY -= 3 * strokeWidth;
            break;
        case "bottom":
            underlineY = y;
            strikeY -= textHeight / 2 - strokeWidth / 2;
            break;
    }
    if (underline) {
        context.lineWidth = strokeWidth;
        context.strokeStyle = context.fillStyle;
        context.beginPath();
        context.moveTo(x, underlineY);
        context.lineTo(x + textWidth, underlineY);
        context.stroke();
    }
    if (strikethrough) {
        context.lineWidth = strokeWidth;
        context.strokeStyle = context.fillStyle;
        context.beginPath();
        context.moveTo(x, strikeY);
        context.lineTo(x + textWidth, strikeY);
        context.stroke();
    }
}
function sliceTextToFitWidth(context, width, text, style, fontUnit = "pt") {
    if (computeTextWidth(context, text, style, fontUnit) <= width) {
        return text;
    }
    const ellipsis = "...";
    const ellipsisWidth = computeTextWidth(context, ellipsis, style, fontUnit);
    if (ellipsisWidth >= width) {
        return "";
    }
    let lowerBoundLen = 1;
    let upperBoundLen = text.length;
    let currentWidth;
    while (lowerBoundLen <= upperBoundLen) {
        const currentLen = Math.floor((lowerBoundLen + upperBoundLen) / 2);
        const currentText = text.slice(0, currentLen);
        currentWidth = computeTextWidth(context, currentText, style, fontUnit);
        if (currentWidth + ellipsisWidth > width) {
            upperBoundLen = currentLen - 1;
        }
        else {
            lowerBoundLen = currentLen + 1;
        }
    }
    const slicedText = text.slice(0, Math.max(0, lowerBoundLen - 1));
    return slicedText ? slicedText + ellipsis : "";
}

/** Methods from Odoo Web Utils  */
/**
 * This function computes a score that represent the fact that the
 * string contains the pattern, or not
 *
 * - If the score is 0, the string does not contain the letters of the pattern in
 *   the correct order.
 * - if the score is > 0, it actually contains the letters.
 *
 * Better matches will get a higher score: consecutive letters are better,
 * and a match closer to the beginning of the string is also scored higher.
 */
function fuzzyMatch(pattern, str) {
    pattern = pattern.toLocaleLowerCase();
    str = str.toLocaleLowerCase();
    let totalScore = 0;
    let currentScore = 0;
    const len = str.length;
    let patternIndex = 0;
    for (let i = 0; i < len; i++) {
        if (str[i] === pattern[patternIndex]) {
            patternIndex++;
            currentScore += 100 + currentScore - i / 200;
        }
        else {
            currentScore = 0;
        }
        totalScore = totalScore + currentScore;
    }
    return patternIndex === pattern.length ? totalScore : 0;
}
/**
 * Return a list of things that matches a pattern, ordered by their 'score' (
 * higher score first). An higher score means that the match is better. For
 * example, consecutive letters are considered a better match.
 */
function fuzzyLookup(pattern, list, fn) {
    const results = [];
    list.forEach((data) => {
        const score = fuzzyMatch(pattern, fn(data));
        if (score > 0) {
            results.push({ score, elem: data });
        }
    });
    // we want better matches first
    results.sort((a, b) => b.score - a.score);
    return results.map((r) => r.elem);
}

const chartJsExtensionRegistry = new Registry();
function areChartJSExtensionsLoaded() {
    return !!window.Chart.registry.plugins.get("chartShowValuesPlugin");
}
function registerChartJSExtensions() {
    if (!window.Chart || areChartJSExtensionsLoaded()) {
        return;
    }
    for (const registryItem of chartJsExtensionRegistry.getAll()) {
        registryItem.register(window.Chart);
    }
}
function unregisterChartJsExtensions() {
    if (!window.Chart) {
        return;
    }
    for (const registryItem of chartJsExtensionRegistry.getAll()) {
        registryItem.unregister(window.Chart);
    }
}

class ChartAnimationStore extends SpreadsheetStore {
    mutators = ["disableAnimationForChart", "enableAnimationForChart"];
    animationPlayed = {};
    disableAnimationForChart(chartId, chartType) {
        this.animationPlayed[chartId] = chartType;
        return "noStateChange";
    }
    enableAnimationForChart(chartId) {
        this.animationPlayed[chartId] = undefined;
        return "noStateChange";
    }
}

function getFunnelChartController() {
    return class FunnelChartController extends window.Chart.BarController {
        static id = "funnel";
        static defaults = {
            ...window.Chart?.BarController.defaults,
            dataElementType: "funnel",
            animation: {
                duration: (ctx) => {
                    if (ctx.type !== "data") {
                        return 1000;
                    }
                    const value = ctx.raw[1];
                    const maxValue = Math.max(...ctx.dataset.data.map((data) => data[1]));
                    return 1000 * (value / maxValue);
                },
            },
        };
        /** Called at each chart render to update the elements of the chart (FunnelChartElement) with the updated data */
        updateElements(rects, start, count, mode) {
            super.updateElements(rects, start, count, mode);
            for (let i = start; i < start + count; i++) {
                const rect = rects[i];
                // Add the next element to the element's props so we can get the bottom width of the trapezoid
                this.updateElement(rect, i, { nextElement: rects[i + 1] }, mode);
            }
        }
    };
}
function getFunnelChartElement() {
    /**
     * Similar to a bar chart element, but it's a trapezoid rather than a rectangle. The top is of width
     * `width`, and the bottom is of width `nextElementWidth`.
     */
    return class FunnelChartElement extends window.Chart.BarElement {
        static id = "funnel";
        /** Overwrite this to draw a trapezoid rather then a rectangle */
        draw(ctx) {
            ctx.save();
            const props = ["x", "y", "width", "height", "nextElement", "base", "options"];
            const { x, y, height, nextElement, base, options } = this.getProps(props);
            const width = getElementWidth(this);
            const nextElementWidth = nextElement ? getElementWidth(nextElement) : 0;
            const offset = (width - nextElementWidth) / 2;
            const startX = Math.min(x, base);
            const startY = y - height / 2;
            ctx.fillStyle = options.backgroundColor;
            ctx.beginPath();
            ctx.moveTo(startX, startY);
            ctx.lineTo(startX + width, startY);
            ctx.lineTo(startX + width - offset, startY + height);
            ctx.lineTo(startX + offset, startY + height);
            ctx.closePath();
            ctx.fill();
            if (options.borderWidth) {
                ctx.strokeStyle = options.borderColor;
                ctx.lineWidth = options.borderWidth;
                ctx.stroke();
            }
            ctx.restore();
        }
        /** Check if the mouse is inside the trapezoid */
        inRange(mouseX, mouseY) {
            const props = ["x", "y", "width", "height", "nextElement", "base", "options"];
            const { x, y, height, nextElement, base } = this.getProps(props);
            const width = getElementWidth(this);
            const nextElementWidth = nextElement ? getElementWidth(nextElement) : 0;
            const startX = Math.min(x, base);
            const startY = y - height / 2;
            if (mouseY < startY || mouseY > startY + height) {
                return false;
            }
            const offset = (width - nextElementWidth) / 2;
            const left = startX + (offset * (mouseY - startY)) / height;
            const right = startX + width - (offset * (mouseY - startY)) / height;
            if (mouseX < left || mouseX > right) {
                return false;
            }
            return true;
        }
    };
}
/**
 * Get an element width.
 *
 * The property width is undefined during animations, we need to compute it manually.
 */
function getElementWidth(element) {
    const { x, base } = element.getProps(["x", "base"]);
    const left = Math.min(x, base);
    const right = Math.max(x, base);
    return right - left;
}
/**
 * Position the tooltip inside the trapezoid.
 * The default position for tooltips of bar elements is at the end of rectangle, which is not ideal for trapezoids.
 */
const funnelTooltipPositioner = function (elements) {
    if (!elements.length) {
        return { x: 0, y: 0 };
    }
    const element = elements[0].element;
    const { x, y, base, width, height } = element.getProps(["x", "y", "width", "height", "base"]);
    const startX = Math.min(x, base);
    const startY = y - height / 2;
    return {
        x: startX + (width * 2) / 3,
        y: startY + height / 2,
    };
};

/** In XLSX color format (no #)  */
const AUTO_COLOR = "000000";
const XLSX_ICONSET_MAP = {
    arrows: "3Arrows",
    smiley: "3Symbols",
    dots: "3TrafficLights1",
};
const NAMESPACE = {
    styleSheet: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    sst: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    Relationships: "http://schemas.openxmlformats.org/package/2006/relationships",
    Types: "http://schemas.openxmlformats.org/package/2006/content-types",
    worksheet: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    workbook: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    drawing: "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing",
    table: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    revision: "http://schemas.microsoft.com/office/spreadsheetml/2014/revision",
    revision3: "http://schemas.microsoft.com/office/spreadsheetml/2016/revision3",
    markupCompatibility: "http://schemas.openxmlformats.org/markup-compatibility/2006",
};
const DRAWING_NS_A = "http://schemas.openxmlformats.org/drawingml/2006/main";
const DRAWING_NS_C = "http://schemas.openxmlformats.org/drawingml/2006/chart";
const CONTENT_TYPES = {
    workbook: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",
    macroEnabledWorkbook: "application/vnd.ms-excel.sheet.macroEnabled.main+xml",
    templateWorkbook: "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml",
    macroEnabledTemplateWorkbook: "application/vnd.ms-excel.template.macroEnabled.main+xml",
    excelAddInWorkbook: "application/vnd.ms-excel.addin.macroEnabled.main+xml",
    sheet: "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",
    metadata: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml",
    sharedStrings: "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",
    styles: "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",
    drawing: "application/vnd.openxmlformats-officedocument.drawing+xml",
    chart: "application/vnd.openxmlformats-officedocument.drawingml.chart+xml",
    themes: "application/vnd.openxmlformats-officedocument.theme+xml",
    table: "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml",
    pivot: "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml",
    externalLink: "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml",
};
const XLSX_RELATION_TYPE = {
    document: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",
    sheet: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet",
    metadata: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sheetMetadata",
    sharedStrings: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings",
    styles: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles",
    drawing: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",
    chart: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart",
    theme: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme",
    table: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/table",
    hyperlink: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink",
    image: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
};
const ARRAY_FORMULA_URI = "bdbb8cdc-fa1e-496e-a857-3c3f30c029c3";
const RELATIONSHIP_NSR = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
const HEIGHT_FACTOR = 0.75; // 100px => 75 u
/**
 * Excel says its default column width is 8.43 characters (64px)
 * which makes WIDTH_FACTOR = 0.1317, but it doesn't work well
 * 0.143 is a value from dev's experiments.
 */
const WIDTH_FACTOR = 0.143;
/** unit : maximum number of characters a column can hold at the standard font size. What. */
const EXCEL_DEFAULT_COL_WIDTH = 8.43;
/** unit : points */
const EXCEL_DEFAULT_ROW_HEIGHT = 12.75;
const EXCEL_IMPORT_DEFAULT_NUMBER_OF_COLS = 30;
const EXCEL_IMPORT_DEFAULT_NUMBER_OF_ROWS = 100;
/** The possible values for the XLSX polynomial trendline order are defined by the ST_Order simple type (§21.2.3.29) */
const MAX_XLSX_POLYNOMIAL_DEGREE = 6;
const FIRST_NUMFMT_ID = 164;
const DEFAULT_DOUGHNUT_CHART_HOLE_SIZE = 50;
const FORCE_DEFAULT_ARGS_FUNCTIONS = {
    FLOOR: [{ type: "NUMBER", value: 1 }],
    CEILING: [{ type: "NUMBER", value: 1 }],
    ROUND: [{ type: "NUMBER", value: 0 }],
    ROUNDUP: [{ type: "NUMBER", value: 0 }],
    ROUNDDOWN: [{ type: "NUMBER", value: 0 }],
};
/**
 * This list contains all "future" functions that are not compatible with older versions of Excel
 * For more information, see https://docs.microsoft.com/en-us/openspecs/office_standards/ms-xlsx/5d1b6d44-6fc1-4ecd-8fef-0b27406cc2bf
 */
const NON_RETROCOMPATIBLE_FUNCTIONS = [
    "ACOT",
    "ACOTH",
    "AGGREGATE",
    "ARABIC",
    "BASE",
    "BETA.DIST",
    "BETA.INV",
    "BINOM.DIST",
    "BINOM.DIST.RANGE",
    "BINOM.INV",
    "BITAND",
    "BITLSHIFT",
    "BITOR",
    "BITRSHIFT",
    "BITXOR",
    "BYCOL",
    "BYROW",
    "CEILING.MATH",
    "CEILING.PRECISE",
    "CHISQ.DIST",
    "CHISQ.DIST.RT",
    "CHISQ.INV",
    "CHISQ.INV.RT",
    "CHISQ.TEST",
    "CHOOSECOLS",
    "CHOOSEROWS",
    "COMBINA",
    "CONCAT",
    "CONFIDENCE.NORM",
    "CONFIDENCE.T",
    "COT",
    "COTH",
    "COVARIANCE.P",
    "COVARIANCE.S",
    "CSC",
    "CSCH",
    "DAYS",
    "DECIMAL",
    "DROP",
    "ERF.PRECISE",
    "ERFC.PRECISE",
    "EXPAND",
    "EXPON.DIST",
    "F.DIST",
    "F.DIST.RT",
    "F.INV",
    "F.INV.RT",
    "F.TEST",
    "FIELDVALUE",
    "FILTERXML",
    "FLOOR.MATH",
    "FLOOR.PRECISE",
    "FORECAST.ETS",
    "FORECAST.ETS.CONFINT",
    "FORECAST.ETS.SEASONALITY",
    "FORECAST.ETS.STAT",
    "FORECAST.LINEAR",
    "FORMULATEXT",
    "GAMMA",
    "GAMMA.DIST",
    "GAMMA.INV",
    "GAMMALN.PRECISE",
    "GAUSS",
    "HSTACK",
    "HYPGEOM.DIST",
    "IFNA",
    "IFS",
    "IMCOSH",
    "IMCOT",
    "IMCSC",
    "IMCSCH",
    "IMSEC",
    "IMSECH",
    "IMSINH",
    "IMTAN",
    "ISFORMULA",
    "ISOMITTED",
    "ISOWEEKNUM",
    "LAMBDA",
    "LET",
    "LOGNORM.DIST",
    "LOGNORM.INV",
    "MAKEARRAY",
    "MAP",
    "MAXIFS",
    "MINIFS",
    "MODE.MULT",
    "MODE.SNGL",
    "MUNIT",
    "NEGBINOM.DIST",
    "NORM.DIST",
    "NORM.INV",
    "NORM.S.DIST",
    "NORM.S.INV",
    "NUMBERVALUE",
    "PDURATION",
    "PERCENTILE.EXC",
    "PERCENTILE.INC",
    "PERCENTRANK.EXC",
    "PERCENTRANK.INC",
    "PERMUTATIONA",
    "PHI",
    "POISSON.DIST",
    "PQSOURCE",
    "PYTHON_STR",
    "PYTHON_TYPE",
    "PYTHON_TYPENAME",
    "QUARTILE.EXC",
    "QUARTILE.INC",
    "QUERYSTRING",
    "RANDARRAY",
    "RANK.AVG",
    "RANK.EQ",
    "REDUCE",
    "RRI",
    "SCAN",
    "SEC",
    "SECH",
    "SEQUENCE",
    "SHEET",
    "SHEETS",
    "SKEW.P",
    "SORTBY",
    "STDEV.P",
    "STDEV.S",
    "SWITCH",
    "T.DIST",
    "T.DIST.2T",
    "T.DIST.RT",
    "T.INV",
    "T.INV.2T",
    "T.TEST",
    "TAKE",
    "TEXTAFTER",
    "TEXTBEFORE",
    "TEXTJOIN",
    "TEXTSPLIT",
    "TOCOL",
    "TOROW",
    "UNICHAR",
    "UNICODE",
    "UNIQUE",
    "VAR.P",
    "VAR.S",
    "VSTACK",
    "WEBSERVICE",
    "WEIBULL.DIST",
    "WRAPCOLS",
    "WRAPROWS",
    "XLOOKUP",
    "XOR",
    "Z.TEST",
];
const CONTENT_TYPES_FILE = "[Content_Types].xml";

function adaptFormulaStringRanges(defaultSheetId, formula, applyChange) {
    if (!formula.startsWith("=")) {
        return formula;
    }
    const tokens = rangeTokenize(formula);
    for (let tokenIdx = 1; tokenIdx < tokens.length; tokenIdx++) {
        if (tokens[tokenIdx].type !== "REFERENCE") {
            continue;
        }
        const sheetXC = tokens[tokenIdx].value;
        const newSheetXC = adaptStringRange(defaultSheetId, sheetXC, applyChange);
        if (sheetXC !== newSheetXC) {
            tokens[tokenIdx] = {
                value: newSheetXC,
                type: "REFERENCE",
            };
        }
    }
    return concat$1(tokens.map((token) => token.value));
}
function adaptStringRange(defaultSheetId, sheetXC, applyChange) {
    const sheetName = splitReference(sheetXC).sheetName;
    if (sheetName
        ? !isSheetNameEqual(sheetName, applyChange.sheetName.old)
        : defaultSheetId !== applyChange.sheetId) {
        return sheetXC;
    }
    const sheetId = sheetName ? applyChange.sheetId : defaultSheetId;
    const range = getRange(sheetXC, sheetId);
    if (range.invalidXc) {
        return sheetXC;
    }
    const change = applyChange.applyChange(range);
    if (change.changeType === "NONE" || change.changeType === "REMOVE") {
        return sheetXC;
    }
    return getRangeString(change.range, defaultSheetId, getSheetNameGetter(applyChange));
}
function getSheetNameGetter(applyChange) {
    return (sheetId) => {
        return sheetId === applyChange.sheetId ? applyChange.sheetName.current : "";
    };
}
function defaultGetSheetSize(sheetId) {
    return { numberOfRows: Number.MAX_SAFE_INTEGER, numberOfCols: Number.MAX_SAFE_INTEGER };
}
function getRange(sheetXC, sheetId) {
    if (!rangeReference.test(sheetXC)) {
        return createInvalidRange(sheetXC);
    }
    return createRangeFromXc({ xc: sheetXC, sheetId }, defaultGetSheetSize);
}

const TREND_LINE_XAXIS_ID = "x1";
const MOVING_AVERAGE_TREND_LINE_XAXIS_ID = "xMovingAverage";
const SPREADSHEET_TO_EXCEL_TRENDLINE_TYPE_MAPPING = {
    exponential: "exp",
    logarithmic: "log",
    polynomial: "poly",
    trailingMovingAverage: "movingAvg",
};
/**
 * This file contains helpers that are common to different charts (mainly
 * line, bar and pie charts)
 */
/**
 * Adapt ranges of a chart which support DataSet (dataSets and LabelRange).
 */
function updateChartRangesWithDataSets(getters, applyChange, chartDataSets, chartLabelRange) {
    let isStale = false;
    const dataSetsWithUndefined = [];
    for (const index in chartDataSets) {
        let ds = chartDataSets[index];
        if (ds.labelCell) {
            const labelCell = adaptChartRange(ds.labelCell, applyChange);
            if (ds.labelCell !== labelCell) {
                isStale = true;
                ds = {
                    ...ds,
                    labelCell: labelCell,
                };
            }
        }
        const dataRange = adaptChartRange(ds.dataRange, applyChange);
        if (dataRange === undefined ||
            getters.getRangeString(dataRange, dataRange.sheetId) === CellErrorType$1.InvalidReference) {
            isStale = true;
            ds = undefined;
        }
        else if (dataRange !== ds.dataRange) {
            isStale = true;
            ds = {
                ...ds,
                dataRange,
            };
        }
        dataSetsWithUndefined[index] = ds;
    }
    let labelRange = chartLabelRange;
    const range = adaptChartRange(labelRange, applyChange);
    if (range !== labelRange) {
        isStale = true;
        labelRange = range;
    }
    const dataSets = dataSetsWithUndefined.filter(isDefined$1);
    return {
        isStale,
        dataSets,
        labelRange,
    };
}
/**
 * Duplicate the dataSets. All ranges on sheetIdFrom are adapted to target
 * sheetIdTo.
 */
function duplicateDataSetsInDuplicatedSheet(sheetIdFrom, sheetIdTo, dataSets) {
    return dataSets.map((ds) => {
        return {
            dataRange: duplicateRangeInDuplicatedSheet(sheetIdFrom, sheetIdTo, ds.dataRange),
            labelCell: ds.labelCell
                ? duplicateRangeInDuplicatedSheet(sheetIdFrom, sheetIdTo, ds.labelCell)
                : undefined,
        };
    });
}
/**
 * Duplicate a range. If the range is on the sheetIdFrom, the range will target
 * sheetIdTo.
 */
function duplicateLabelRangeInDuplicatedSheet(sheetIdFrom, sheetIdTo, range) {
    return range ? duplicateRangeInDuplicatedSheet(sheetIdFrom, sheetIdTo, range) : undefined;
}
/**
 * Adapt a single range of a chart
 */
function adaptChartRange(range, applyChange) {
    if (!range) {
        return undefined;
    }
    const change = applyChange(range);
    switch (change.changeType) {
        case "NONE":
            return range;
        case "REMOVE":
            return undefined;
        default:
            return change.range;
    }
}
/**
 * Create the dataSet objects from xcs
 */
function createDataSets(getters, customizedDataSets, sheetId, dataSetsHaveTitle) {
    const dataSets = [];
    for (const dataSet of customizedDataSets) {
        const dataRange = getters.getRangeFromSheetXC(sheetId, dataSet.dataRange);
        const { unboundedZone: zone, sheetId: dataSetSheetId, invalidSheetName, invalidXc } = dataRange;
        if (invalidSheetName || invalidXc) {
            continue;
        }
        // It's a rectangle. We treat all columns (arbitrary) as different data series.
        if (zone.left !== zone.right && zone.top !== zone.bottom) {
            if (zone.right === undefined) {
                // Should never happens because of the allowDispatch of charts, but just making sure
                continue;
            }
            for (let column = zone.left; column <= zone.right; column++) {
                const columnZone = {
                    ...zone,
                    left: column,
                    right: column,
                };
                dataSets.push({
                    ...createDataSet(getters, dataSetSheetId, columnZone, dataSetsHaveTitle
                        ? {
                            top: columnZone.top,
                            bottom: columnZone.top,
                            left: columnZone.left,
                            right: columnZone.left,
                        }
                        : undefined),
                    backgroundColor: dataSet.backgroundColor,
                    rightYAxis: dataSet.yAxisId === "y1",
                    customLabel: dataSet.label,
                    trend: dataSet.trend,
                });
            }
        }
        else {
            /* 1 cell, 1 row or 1 column */
            dataSets.push({
                ...createDataSet(getters, dataSetSheetId, zone, dataSetsHaveTitle
                    ? {
                        top: zone.top,
                        bottom: zone.top,
                        left: zone.left,
                        right: zone.left,
                    }
                    : undefined),
                backgroundColor: dataSet.backgroundColor,
                rightYAxis: dataSet.yAxisId === "y1",
                customLabel: dataSet.label,
                trend: dataSet.trend,
            });
        }
    }
    return dataSets;
}
function createDataSet(getters, sheetId, fullZone, titleZone) {
    if (fullZone.left !== fullZone.right && fullZone.top !== fullZone.bottom) {
        throw new Error(`Zone should be a single column or row: ${zoneToXc(fullZone)}`);
    }
    if (titleZone) {
        const dataXC = zoneToXc(fullZone);
        const labelCellXC = zoneToXc(titleZone);
        return {
            labelCell: getters.getRangeFromSheetXC(sheetId, labelCellXC),
            dataRange: getters.getRangeFromSheetXC(sheetId, dataXC),
        };
    }
    else {
        return {
            labelCell: undefined,
            dataRange: getters.getRangeFromSheetXC(sheetId, zoneToXc(fullZone)),
        };
    }
}
/**
 * Transform a dataSet to a ExcelDataSet
 */
function toExcelDataset(getters, ds) {
    const labelZone = ds.labelCell?.zone;
    let dataZone = ds.dataRange.zone;
    if (labelZone) {
        const { numberOfRows, numberOfCols } = zoneToDimension(dataZone);
        if (numberOfRows === 1) {
            dataZone = { ...dataZone, left: dataZone.left + 1 };
        }
        else if (numberOfCols === 1) {
            dataZone = { ...dataZone, top: dataZone.top + 1 };
        }
    }
    const dataRange = createRange({ ...ds.dataRange, zone: dataZone }, getters.getSheetSize);
    let label = {};
    if (ds.customLabel) {
        label = {
            text: ds.customLabel,
        };
    }
    else if (ds.labelCell) {
        label = {
            reference: getters.getRangeString(ds.labelCell, "forceSheetReference", {
                useBoundedReference: true,
            }),
        };
    }
    let trend;
    if (ds.trend?.type) {
        trend = {
            type: ds.trend.type === "polynomial" && ds.trend.order === 1
                ? "linear"
                : SPREADSHEET_TO_EXCEL_TRENDLINE_TYPE_MAPPING[ds.trend.type],
            color: ds.trend.color,
            order: ds.trend.order ? Math.min(ds.trend.order, MAX_XLSX_POLYNOMIAL_DEGREE) : undefined,
            window: ds.trend.window || DEFAULT_WINDOW_SIZE,
        };
    }
    return {
        label,
        range: getters.getRangeString(dataRange, "forceSheetReference", { useBoundedReference: true }),
        backgroundColor: ds.backgroundColor,
        rightYAxis: ds.rightYAxis,
        trend,
    };
}
function toExcelLabelRange(getters, labelRange, shouldRemoveFirstLabel) {
    if (!labelRange)
        return undefined;
    const zone = {
        ...labelRange.zone,
    };
    if (shouldRemoveFirstLabel && labelRange.zone.bottom > labelRange.zone.top) {
        zone.top = zone.top + 1;
    }
    const range = createRange({ ...labelRange, zone: zone }, getters.getSheetSize);
    return getters.getRangeString(range, "forceSheetReference", { useBoundedReference: true });
}
/**
 * Transform a chart definition which supports dataSets (dataSets and LabelRange)
 * with an executed command
 */
function transformChartDefinitionWithDataSetsWithZone(chartSheetId, definition, applyChange) {
    let labelRange;
    if (definition.labelRange) {
        const adaptedRange = adaptStringRange(chartSheetId, definition.labelRange, applyChange);
        if (adaptedRange !== CellErrorType$1.InvalidReference) {
            labelRange = adaptedRange;
        }
    }
    const dataSets = [];
    for (const dataSet of definition.dataSets) {
        const newDataSet = { ...dataSet };
        const adaptedRange = adaptStringRange(chartSheetId, dataSet.dataRange, applyChange);
        if (adaptedRange !== CellErrorType$1.InvalidReference) {
            newDataSet.dataRange = adaptedRange;
            dataSets.push(newDataSet);
        }
    }
    return {
        ...definition,
        dataSets,
        labelRange,
    };
}
/**
 * Choose a font color based on a background color.
 * The font is white with a dark background.
 */
function chartFontColor(backgroundColor) {
    if (!backgroundColor) {
        return "#000000";
    }
    return relativeLuminance(backgroundColor) < 0.3 ? "#FFFFFF" : "#000000";
}
function chartMutedFontColor(backgroundColor) {
    if (!backgroundColor) {
        return "#666666";
    }
    return relativeLuminance(backgroundColor) < 0.3 ? "#C8C8C8" : "#666666";
}
function checkDataset(definition) {
    if (definition.dataSets) {
        const invalidRanges = definition.dataSets.find((range) => !rangeReference.test(range.dataRange)) !== undefined;
        if (invalidRanges) {
            return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
        }
        const zones = definition.dataSets.map((ds) => toUnboundedZone(ds.dataRange));
        if (zones.some((zone) => zone.top !== zone.bottom && isFullRow(zone))) {
            return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
        }
    }
    return "Success" /* CommandResult.Success */;
}
function checkLabelRange(definition) {
    if (definition.labelRange) {
        const invalidLabels = !rangeReference.test(definition.labelRange || "");
        if (invalidLabels) {
            return "InvalidLabelRange" /* CommandResult.InvalidLabelRange */;
        }
    }
    return "Success" /* CommandResult.Success */;
}
function shouldRemoveFirstLabel(labelRange, dataset, dataSetsHaveTitle) {
    if (!dataSetsHaveTitle)
        return false;
    if (!labelRange)
        return false;
    if (!dataset)
        return true;
    const datasetLength = getZoneArea(dataset.dataRange.zone);
    const labelLength = getZoneArea(labelRange.zone);
    if (labelLength < datasetLength) {
        return false;
    }
    return true;
}
function getChartPositionAtCenterOfViewport(getters, chartSize) {
    const { x, y } = getters.getMainViewportCoordinates();
    const { scrollX, scrollY } = getters.getActiveSheetScrollInfo();
    const { width, height } = getters.getVisibleRect(getters.getActiveMainViewport());
    return {
        x: x + scrollX + Math.max(0, (width - chartSize.width) / 2),
        y: y + scrollY + Math.max(0, (height - chartSize.height) / 2),
    }; // Position at the center of the scrollable viewport
}
function getDefinedAxis(definition) {
    let useLeftAxis = false, useRightAxis = false;
    if ("horizontal" in definition && definition.horizontal) {
        return { useLeftAxis: true, useRightAxis: false };
    }
    for (const design of definition.dataSets || []) {
        if (design.yAxisId === "y1") {
            useRightAxis = true;
        }
        else {
            useLeftAxis = true;
        }
    }
    useLeftAxis ||= !useRightAxis;
    return { useLeftAxis, useRightAxis };
}
function formatChartDatasetValue(axisFormats, locale, humanizeNumbers = false) {
    return (value, axisId) => {
        const format = axisFormats?.[axisId];
        return formatTickValue({ format, locale }, humanizeNumbers)(value);
    };
}
function formatTickValue(localeFormat, humanizeNumbers = false) {
    return (value) => {
        value = Number(value);
        if (isNaN(value))
            return value;
        const { locale, format } = localeFormat;
        const formattedValue = humanizeNumbers
            ? humanizeNumber({ value, format }, locale)
            : formatValue$1(value, {
                locale,
                format: !format && Math.abs(value) >= 1000 ? "#,##" : format,
            });
        return truncateLabel(formattedValue);
    };
}
const CHART_AXIS_CHOICES = [
    { value: "left", label: _t$1("Left") },
    { value: "right", label: _t$1("Right") },
];
function getPieColors(colors, dataSetsValues) {
    const pieColors = [];
    const maxLength = largeMax(dataSetsValues.map((ds) => ds.data.length));
    for (let i = 0; i <= maxLength; i++) {
        pieColors.push(colors.next());
    }
    return pieColors;
}
function truncateLabel(label, maxLen = MAX_CHAR_LABEL) {
    if (!label) {
        return "";
    }
    if (label.length > maxLen) {
        return label.substring(0, maxLen) + "…";
    }
    return label;
}
function isTrendLineAxis(axisID) {
    return axisID === TREND_LINE_XAXIS_ID || axisID === MOVING_AVERAGE_TREND_LINE_XAXIS_ID;
}

/** This is a chartJS plugin that will draw the values of each data next to the point/bar/pie slice */
const chartShowValuesPlugin = {
    id: "chartShowValuesPlugin",
    afterDatasetsDraw(chart, args, options) {
        if (!options.showValues) {
            return;
        }
        const drawData = chart._metasets?.[0]?.data;
        if (!drawData) {
            return;
        }
        const ctx = chart.ctx;
        ctx.save();
        const { left, top, height, width } = chart.chartArea;
        ctx.beginPath();
        ctx.rect(left, top, width, height);
        ctx.clip();
        ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        ctx.miterLimit = 1; // Avoid sharp artifacts on strokeText
        switch (chart.config.type) {
            case "pie":
            case "doughnut":
                drawPieChartValues(chart, options, ctx);
                break;
            case "bar":
            case "line":
            case "radar":
                options.horizontal
                    ? drawHorizontalBarChartValues(chart, options, ctx)
                    : drawLineOrBarOrRadarChartValues(chart, options, ctx);
                break;
            case "funnel":
                drawHorizontalBarChartValues(chart, options, ctx);
                break;
        }
        ctx.restore();
    },
};
function drawTextWithBackground(text, x, y, ctx) {
    ctx.lineWidth = 3; // Stroke the text with a big lineWidth width to have some kind of background
    ctx.strokeText(text, x, y);
    ctx.lineWidth = 1;
    ctx.fillText(text, x, y);
}
function drawLineOrBarOrRadarChartValues(chart, options, ctx) {
    const yMax = chart.chartArea.bottom;
    const yMin = chart.chartArea.top;
    const textsPositions = {};
    for (const dataset of chart._metasets) {
        if (isTrendLineAxis(dataset.xAxisID) || dataset.hidden) {
            continue;
        }
        const yAxisScale = chart.scales[dataset.yAxisID];
        for (let i = 0; i < dataset._parsed.length; i++) {
            const parsedValue = dataset._parsed[i];
            const value = Number(chart.config.type === "radar" ? parsedValue.r : parsedValue.y);
            if (isNaN(value)) {
                continue;
            }
            const point = dataset.data[i];
            const xPosition = point.x;
            let yPosition = 0;
            if (chart.config.type === "line" || chart.config.type === "radar") {
                yPosition = value < 0 ? point.y + 10 : point.y - 10;
            }
            else {
                const yZeroLine = yAxisScale.getPixelForValue(0);
                const distanceFromAxisOrigin = Math.abs(yZeroLine - point.y);
                const textHeight = 12; // ChartJS default text height
                if (distanceFromAxisOrigin < textHeight) {
                    yPosition = value < 0 ? yZeroLine + textHeight / 2 : yZeroLine - textHeight / 2;
                }
                else {
                    yPosition = value < 0 ? point.y - point.height / 2 : point.y + point.height / 2;
                }
            }
            yPosition = Math.min(yPosition, yMax);
            yPosition = Math.max(yPosition, yMin);
            // Avoid overlapping texts with same X
            if (!textsPositions[xPosition]) {
                textsPositions[xPosition] = [];
            }
            for (const otherPosition of textsPositions[xPosition] || []) {
                if (Math.abs(otherPosition - yPosition) < 13) {
                    yPosition = value < 0 ? otherPosition + 13 : otherPosition - 13;
                }
            }
            textsPositions[xPosition].push(yPosition);
            ctx.fillStyle = point.options.backgroundColor;
            ctx.strokeStyle = options.background || "#ffffff";
            const valueToDisplay = options.callback(Number(value), dataset, i);
            drawTextWithBackground(valueToDisplay, xPosition, yPosition, ctx);
        }
    }
}
function drawHorizontalBarChartValues(chart, options, ctx) {
    const xMax = chart.chartArea.right;
    const xMin = chart.chartArea.left;
    const textsPositions = {};
    for (const dataset of chart._metasets) {
        if (isTrendLineAxis(dataset.xAxisID)) {
            return; // ignore trend lines
        }
        const xAxisScale = chart.scales[dataset.xAxisID];
        const xZeroLine = xAxisScale.getPixelForValue(0);
        for (let i = 0; i < dataset._parsed.length; i++) {
            const value = Number(dataset._parsed[i].x);
            if (isNaN(value)) {
                continue;
            }
            const displayValue = options.callback(value, dataset, i);
            const point = dataset.data[i];
            const yPosition = point.y;
            const textWidth = computeTextWidth(ctx, displayValue, { fontSize: 12 }, "px");
            const distanceFromAxisOrigin = Math.abs(point.x - xZeroLine);
            const PADDING = 3;
            let xPosition;
            if (distanceFromAxisOrigin < textWidth) {
                xPosition =
                    value < 0 ? xZeroLine - textWidth / 2 - PADDING : xZeroLine + textWidth / 2 + PADDING;
            }
            else {
                xPosition = value < 0 ? point.x + point.width / 2 : point.x - point.width / 2;
                xPosition = Math.min(xPosition, xMax);
                xPosition = Math.max(xPosition, xMin);
            }
            // Avoid overlapping texts with same Y
            if (!textsPositions[yPosition]) {
                textsPositions[yPosition] = [];
            }
            for (const otherPosition of textsPositions[yPosition]) {
                if (Math.abs(otherPosition - xPosition) < textWidth) {
                    xPosition =
                        value < 0 ? otherPosition - textWidth - PADDING : otherPosition + textWidth + PADDING;
                }
            }
            textsPositions[yPosition].push(xPosition);
            ctx.fillStyle = point.options.backgroundColor;
            ctx.strokeStyle = options.background || "#ffffff";
            drawTextWithBackground(displayValue, xPosition, yPosition, ctx);
        }
    }
}
function drawPieChartValues(chart, options, ctx) {
    for (const dataset of chart._metasets) {
        for (let i = 0; i < dataset._parsed.length; i++) {
            const value = Number(dataset._parsed[i]);
            if (isNaN(value) || value === 0) {
                continue;
            }
            const bar = dataset.data[i];
            const { startAngle, endAngle, innerRadius, outerRadius } = bar;
            const midAngle = (startAngle + endAngle) / 2;
            const midRadius = (innerRadius + outerRadius) / 2;
            const x = bar.x + midRadius * Math.cos(midAngle);
            const y = bar.y + midRadius * Math.sin(midAngle);
            const displayValue = options.callback(value, dataset, i);
            const textHeight = 12; // ChartJS default
            const textWidth = computeTextWidth(ctx, displayValue, { fontSize: textHeight }, "px");
            const radius = outerRadius - innerRadius;
            // Check if the text fits in the slice. Not perfect, but good enough heuristic.
            if (textWidth >= radius || radius < textHeight) {
                continue;
            }
            const sliceAngle = endAngle - startAngle;
            const midWidth = 2 * midRadius * Math.tan(sliceAngle / 2);
            if (sliceAngle < Math.PI / 2 && (textWidth >= midWidth || midWidth < textHeight)) {
                continue;
            }
            ctx.fillStyle = chartFontColor(options.background);
            ctx.strokeStyle = options.background || "#ffffff";
            drawTextWithBackground(displayValue, x, y, ctx);
        }
    }
}

const TreeMapChartDefaults = {
    showHeaders: true,
    headerDesign: {
        align: "center",
        fillColor: "#808080",
        bold: true,
        fontSize: 15,
    },
    showValues: true,
    showLabels: true,
    valuesDesign: {
        align: "left",
        verticalAlign: "bottom",
        fontSize: 12,
    },
    coloringOptions: {
        type: "categoryColor",
        colors: [],
        useValueBasedGradient: true,
    },
};

//------------------------------------------------------------------------------
// Miscellaneous
//------------------------------------------------------------------------------
function isCloneable(obj) {
    return "clone" in obj && obj.clone instanceof Function;
}
/**
 * Escapes a string to use as a literal string in a RegExp.
 * @url https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Escaping
 */
function escapeRegExp(str) {
    return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
/**
 * Deep copy arrays, plain objects and primitive values.
 * Throws an error for other types such as class instances.
 * Sparse arrays remain sparse.
 */
function deepCopy(obj) {
    switch (typeof obj) {
        case "object": {
            if (obj === null) {
                return obj;
            }
            else if (isCloneable(obj)) {
                return obj.clone();
            }
            else if (!(isPlainObject(obj) || obj instanceof Array)) {
                throw new Error("Unsupported type: only objects and arrays are supported");
            }
            const result = Array.isArray(obj) ? new Array(obj.length) : {};
            if (Array.isArray(obj)) {
                for (let i = 0, len = obj.length; i < len; i++) {
                    if (i in obj) {
                        result[i] = deepCopy(obj[i]);
                    }
                }
            }
            else {
                for (const key in obj) {
                    result[key] = deepCopy(obj[key]);
                }
            }
            return result;
        }
        case "number":
        case "string":
        case "boolean":
        case "function":
        case "undefined":
            return obj;
        default:
            throw new Error(`Unsupported type: ${typeof obj}`);
    }
}
/**
 * Check if the object is a plain old javascript object.
 */
function isPlainObject(obj) {
    return (typeof obj === "object" &&
        obj !== null &&
        // obj.constructor can be undefined when there's no prototype (`Object.create(null, {})`)
        (obj?.constructor === Object || obj?.constructor === undefined));
}
/**
 * Create a range from start (included) to end (excluded).
 * range(10, 13) => [10, 11, 12]
 * range(2, 8, 2) => [2, 4, 6]
 */
function range(start, end, step = 1) {
    if (end <= start && step > 0) {
        return [];
    }
    if (step === 0) {
        throw new Error("range() step must not be zero");
    }
    const length = Math.ceil(Math.abs((end - start) / step));
    const array = Array(length);
    for (let i = 0; i < length; i++) {
        array[i] = start + i * step;
    }
    return array;
}
/**
 * Groups consecutive numbers.
 * The input array is assumed to be sorted
 * @param numbers
 */
function groupConsecutive(numbers) {
    return numbers.reduce((groups, currentRow, index, rows) => {
        if (Math.abs(currentRow - rows[index - 1]) === 1) {
            const lastGroup = groups[groups.length - 1];
            lastGroup.push(currentRow);
        }
        else {
            groups.push([currentRow]);
        }
        return groups;
    }, []);
}
/**
 * This helper function can be used as a type guard when filtering arrays.
 * const foo: number[] = [1, 2, undefined, 4].filter(isDefined)
 */
function isDefined(argument) {
    return argument !== undefined;
}
/**
 * Compares n objects.
 */
function deepEquals(...o) {
    if (o.length <= 1)
        return true;
    for (let index = 1; index < o.length; index++) {
        if (!_deepEquals(o[0], o[index]))
            return false;
    }
    return true;
}
function _deepEquals(o1, o2) {
    if (o1 === o2)
        return true;
    if ((o1 && !o2) || (o2 && !o1))
        return false;
    if (typeof o1 !== typeof o2)
        return false;
    if (typeof o1 !== "object")
        return false;
    // Objects can have different keys if the values are undefined
    for (const key in o2) {
        if (!(key in o1) && o2[key] !== undefined) {
            return false;
        }
    }
    for (const key in o1) {
        if (typeof o1[key] !== typeof o2[key])
            return false;
        if (typeof o1[key] === "object") {
            if (!_deepEquals(o1[key], o2[key]))
                return false;
        }
        else {
            if (o1[key] !== o2[key])
                return false;
        }
    }
    return true;
}
/**
 * Return an object with all the keys in the object that have a falsy value removed.
 */
function removeFalsyAttributes(obj) {
    if (!obj)
        return obj;
    const cleanObject = { ...obj };
    Object.keys(cleanObject).forEach((key) => !cleanObject[key] && delete cleanObject[key]);
    return cleanObject;
}
/**
 * Creates a version of the function that's memoized on the value of its first argument, if any.
 */
function memoize(func) {
    const cache = new Map();
    const funcName = func.name ? func.name + " (memoized)" : "memoized";
    return {
        [funcName](...args) {
            if (!cache.has(args[0])) {
                cache.set(args[0], func(...args));
            }
            return cache.get(args[0]);
        },
    }[funcName];
}
function trimContent(content) {
    const contentLines = content.split("\n");
    return contentLines.map((line) => line.replace(/\s+/g, " ").trim()).join("\n");
}
class TokenizingChars {
    text;
    currentIndex = 0;
    current;
    constructor(text) {
        this.text = text;
        this.current = text[0];
    }
    shift() {
        const current = this.current;
        const next = this.text[++this.currentIndex];
        this.current = next;
        return current;
    }
    advanceBy(length) {
        this.currentIndex += length;
        this.current = this.text[this.currentIndex];
    }
    isOver() {
        return this.currentIndex >= this.text.length;
    }
    remaining() {
        return this.text.substring(this.currentIndex);
    }
    currentStartsWith(str) {
        if (this.current !== str[0]) {
            return false;
        }
        for (let j = 1; j < str.length; j++) {
            if (this.text[this.currentIndex + j] !== str[j]) {
                return false;
            }
        }
        return true;
    }
}

const GHOST_SUNBURST_VALUE = "nullValue";
function getBarChartDatasets(definition, args) {
    const { dataSetsValues } = args;
    const dataSets = [];
    const colors = getChartColorsGenerator(definition, dataSetsValues.length);
    const trendDatasets = [];
    for (const index in dataSetsValues) {
        let { label, data, hidden } = dataSetsValues[index];
        label = definition.dataSets?.[index].label || label;
        const backgroundColor = colors.next();
        const dataset = {
            label,
            data,
            hidden,
            borderColor: definition.background || BACKGROUND_CHART_COLOR,
            borderWidth: definition.stacked ? 1 : 0,
            backgroundColor,
            yAxisID: definition.horizontal ? "y" : definition.dataSets?.[index].yAxisId || "y",
            xAxisID: "x",
        };
        dataSets.push(dataset);
        const trendConfig = definition.dataSets?.[index].trend;
        const trendData = args.trendDataSetsValues?.[index];
        if (!trendConfig?.display || definition.horizontal || !trendData) {
            continue;
        }
        trendDatasets.push(getTrendingLineDataSet(dataset, trendConfig, trendData));
    }
    dataSets.push(...trendDatasets);
    return dataSets;
}
function getWaterfallDatasetAndLabels(definition, args) {
    const { dataSetsValues, labels } = args;
    const negativeColor = definition.negativeValuesColor || CHART_WATERFALL_NEGATIVE_COLOR;
    const positiveColor = definition.positiveValuesColor || CHART_WATERFALL_POSITIVE_COLOR;
    const subTotalColor = definition.subTotalValuesColor || CHART_WATERFALL_SUBTOTAL_COLOR;
    const backgroundColor = [];
    const datasetValues = [];
    const dataset = {
        label: "",
        data: datasetValues,
        backgroundColor,
    };
    const labelsWithSubTotals = [];
    let lastValue = 0;
    for (const dataSetsValue of dataSetsValues) {
        if (dataSetsValue.hidden) {
            continue;
        }
        for (let i = 0; i < dataSetsValue.data.length; i++) {
            const data = dataSetsValue.data[i];
            labelsWithSubTotals.push(labels[i]);
            if (isNaN(Number(data))) {
                datasetValues.push([lastValue, lastValue]);
                backgroundColor.push("");
                continue;
            }
            datasetValues.push([lastValue, data + lastValue]);
            let color = data >= 0 ? positiveColor : negativeColor;
            if (i === 0 && dataSetsValue === dataSetsValues[0] && definition.firstValueAsSubtotal) {
                color = subTotalColor;
            }
            backgroundColor.push(color);
            lastValue += data;
        }
        if (definition.showSubTotals) {
            labelsWithSubTotals.push(_t$1("Subtotal"));
            datasetValues.push([0, lastValue]);
            backgroundColor.push(subTotalColor);
        }
    }
    return {
        datasets: [dataset],
        labels: labelsWithSubTotals,
    };
}
function getLineChartDatasets(definition, args) {
    const { dataSetsValues, axisType, labels } = args;
    const dataSets = [];
    const areaChart = !!definition.fillArea;
    const stackedChart = !!definition.stacked;
    const trendDatasets = [];
    const colors = getChartColorsGenerator(definition, dataSetsValues.length);
    for (let index = 0; index < dataSetsValues.length; index++) {
        let { label, data, hidden } = dataSetsValues[index];
        label = definition.dataSets?.[index].label || label;
        const color = colors.next();
        if (axisType && ["linear", "time"].includes(axisType)) {
            // Replace empty string labels by undefined to make sure chartJS doesn't decide that "" is the same as 0
            data = data.map((y, index) => ({ x: labels[index] || undefined, y }));
        }
        const dataset = {
            label,
            data,
            hidden,
            tension: 0, // 0 -> render straight lines, which is much faster
            borderColor: color,
            backgroundColor: areaChart ? setColorAlpha(color, LINE_FILL_TRANSPARENCY) : color,
            pointBackgroundColor: color,
            fill: areaChart ? getFillingMode(index, stackedChart) : false,
            pointRadius: definition.hideDataMarkers ? 0 : LINE_DATA_POINT_RADIUS,
            yAxisID: definition.dataSets?.[index].yAxisId || "y",
        };
        dataSets.push(dataset);
        const trendConfig = definition.dataSets?.[index].trend;
        const trendData = args.trendDataSetsValues?.[index];
        if (!trendConfig?.display || !trendData) {
            continue;
        }
        trendDatasets.push(getTrendingLineDataSet(dataset, trendConfig, trendData));
    }
    dataSets.push(...trendDatasets);
    return dataSets;
}
function getScatterChartDatasets(definition, args) {
    const dataSets = getLineChartDatasets(definition, args);
    for (const dataSet of dataSets) {
        if (!isTrendLineAxis(dataSet.xAxisID)) {
            dataSet.showLine = false;
        }
    }
    return dataSets;
}
function getPieChartDatasets(definition, args) {
    const { dataSetsValues } = args;
    const dataSets = [];
    const dataSetsLength = Math.max(0, ...dataSetsValues.map((ds) => ds?.data?.length ?? 0));
    const backgroundColor = getPieColors(new ColorGenerator(dataSetsLength), dataSetsValues);
    for (const { label, data, hidden } of dataSetsValues) {
        if (hidden)
            continue;
        const dataset = {
            label,
            data,
            borderColor: definition.background || "#FFFFFF",
            backgroundColor,
            hoverOffset: 10,
        };
        dataSets.push(dataset);
    }
    return dataSets;
}
function getComboChartDatasets(definition, args) {
    const { dataSetsValues } = args;
    const dataSets = [];
    const colors = getChartColorsGenerator(definition, dataSetsValues.length);
    const trendDatasets = [];
    for (let index = 0; index < dataSetsValues.length; index++) {
        let { label, data, hidden } = dataSetsValues[index];
        label = definition.dataSets?.[index].label || label;
        const design = definition.dataSets?.[index];
        const color = colors.next();
        const type = design?.type ?? "line";
        const dataset = {
            label: label,
            data,
            hidden,
            borderColor: color,
            backgroundColor: color,
            yAxisID: definition.dataSets?.[index].yAxisId || "y",
            xAxisID: "x",
            type,
            order: type === "bar" ? dataSetsValues.length + index : index,
            pointRadius: definition.hideDataMarkers ? 0 : LINE_DATA_POINT_RADIUS,
        };
        dataSets.push(dataset);
        const trendConfig = definition.dataSets?.[index].trend;
        const trendData = args.trendDataSetsValues?.[index];
        if (!trendConfig?.display || !trendData) {
            continue;
        }
        trendDatasets.push(getTrendingLineDataSet(dataset, trendConfig, trendData));
    }
    dataSets.push(...trendDatasets);
    return dataSets;
}
function getRadarChartDatasets(definition, args) {
    const { dataSetsValues } = args;
    const datasets = [];
    const fill = definition.fillArea ?? false;
    const colors = getChartColorsGenerator(definition, dataSetsValues.length);
    for (let i = 0; i < dataSetsValues.length; i++) {
        let { label, data, hidden } = dataSetsValues[i];
        if (definition.dataSets?.[i]?.label) {
            label = definition.dataSets[i].label;
        }
        const borderColor = colors.next();
        const dataset = {
            label,
            data,
            hidden,
            borderColor,
            backgroundColor: borderColor,
            pointRadius: definition.hideDataMarkers ? 0 : LINE_DATA_POINT_RADIUS,
        };
        if (fill) {
            dataset.backgroundColor = setColorAlpha(borderColor, LINE_FILL_TRANSPARENCY);
            dataset.fill = "start"; // fills from the start of the axes (default is to start at 0)
        }
        datasets.push(dataset);
    }
    return datasets;
}
function getGeoChartDatasets(definition, args) {
    const { availableRegions, dataSetsValues, labels } = args;
    const regionName = definition.region || availableRegions[0]?.id;
    const features = regionName ? args.getGeoJsonFeatures(regionName) : undefined;
    const dataset = {
        outline: features,
        showOutline: !!features,
        data: [],
    };
    if (features && regionName) {
        const labelsAndValues = {};
        if (dataSetsValues[0]) {
            for (let i = 0; i < dataSetsValues[0].data.length; i++) {
                if (!labels[i] || dataSetsValues[0].data[i] === undefined) {
                    continue;
                }
                const featureId = args.geoFeatureNameToId(regionName, labels[i]);
                if (featureId) {
                    labelsAndValues[featureId] = { value: dataSetsValues[0].data[i], label: labels[i] };
                }
            }
        }
        for (const feature of features) {
            if (!feature.id) {
                continue;
            }
            dataset.data.push({
                feature: {
                    ...feature,
                    properties: { name: labelsAndValues[feature.id]?.label },
                },
                value: labelsAndValues[feature.id]?.value,
            });
        }
    }
    return [dataset];
}
function getFunnelChartDatasets(definition, args) {
    const dataSetsValues = args.dataSetsValues[0];
    const labels = args.labels;
    if (!dataSetsValues) {
        return [];
    }
    let { label: datasetLabel, data } = dataSetsValues;
    datasetLabel = definition.dataSets?.[0].label || datasetLabel;
    const dataset = {
        label: datasetLabel,
        data: data.map((value) => (value <= 0 ? [0, 0] : [-value, value])),
        backgroundColor: getFunnelLabelColors(labels, definition.funnelColors),
        yAxisID: "y",
        xAxisID: "x",
        barPercentage: 1,
        categoryPercentage: 1,
        borderColor: definition.background || BACKGROUND_CHART_COLOR,
        borderWidth: 3,
    };
    return [dataset];
}
function getFunnelLabelColors(labels, colors) {
    const colorGenerator = new ColorGenerator(labels.length, colors);
    return labels.map(() => colorGenerator.next());
}
function getSunburstChartDatasets(definition, args) {
    const { dataSetsValues, labels } = args;
    const tree = getSunburstTree(dataSetsValues, labels);
    const data = pyramidizeTree(tree);
    const rootData = data[0] || [];
    const colorGenerator = new ColorGenerator(rootData.length, definition.groupColors || []);
    const groupColors = rootData.map((rawValue) => ({
        label: rawValue.label,
        color: colorGenerator.next(),
    }));
    const dataSets = [];
    for (let i = data.length - 1; i >= 0; i--) {
        const dataset = {
            groupColors,
            parsing: { key: "value" },
            data: data[i],
            borderColor: (ctx) => {
                const data = ctx.type === "data" ? ctx.raw : undefined;
                if (!data || data.label === GHOST_SUNBURST_VALUE) {
                    return COLOR_TRANSPARENT;
                }
                return definition.background || BACKGROUND_CHART_COLOR;
            },
            backgroundColor: (ctx) => {
                const data = ctx.type === "data" ? ctx.raw : undefined;
                if (!data || data.label === GHOST_SUNBURST_VALUE) {
                    return COLOR_TRANSPARENT;
                }
                const rootGroup = data.groups[0];
                return groupColors.find((groupColor) => groupColor.label === rootGroup)?.color;
            },
            hoverOffset: 10,
        };
        dataSets.push(dataset);
    }
    return dataSets;
}
function getDataEntriesFromDatasets(hierarchicalDatasetValues, values) {
    const entries = [];
    const maxDatasetLength = Math.max(...hierarchicalDatasetValues.map((ds) => ds.data.length));
    for (let i = 0; i < maxDatasetLength; i++) {
        entries[i] = {};
        for (let j = 0; j < hierarchicalDatasetValues.length; j++) {
            const groupBy = hierarchicalDatasetValues[j].data[i] === null
                ? GHOST_SUNBURST_VALUE
                : String(hierarchicalDatasetValues[j].data[i]);
            entries[i][j] = groupBy;
        }
        entries[i].value = Number(values[i]);
    }
    return entries;
}
function getSunburstTree(hierarchicalDatasetValues, values) {
    const entries = getDataEntriesFromDatasets(hierarchicalDatasetValues, values);
    return sunburstGroupBy(entries, 0, hierarchicalDatasetValues.length, []);
}
function sunburstGroupBy(entries, index, maxDepth, parentGroups) {
    if (index >= maxDepth) {
        return [];
    }
    const groups = Object.groupBy(entries, (item) => item[index]);
    return Object.keys(groups)
        .map((key) => {
        const total = groups[key]?.reduce((acc, item) => acc + Number(item.value), 0) || 0;
        const itemGroups = [...parentGroups, key];
        const tree = sunburstGroupBy(groups[key] || [], index + 1, maxDepth, [...parentGroups, key]);
        return {
            label: key,
            value: total,
            children: tree,
            groups: itemGroups,
            depth: index,
        };
    })
        .sort((a, b) => b.value - a.value);
}
/**
 * Transform a tree into a "pyramid" array, ie. an array in which each level is an array of nodes at the same depth.
 *
 * Example:
 * ```
 *       A                  [
 *      / \                    [A],
 *     B   C       ===>        [B, C],
 *    / \   \                  [D, E, F],
 *   D   E   F              ]
 *  ```
 */
function pyramidizeTree(tree) {
    const flattened = [];
    const queue = [...tree];
    while (queue.length > 0) {
        const node = queue.shift();
        if (!node) {
            continue;
        }
        if (!flattened[node.depth]) {
            flattened[node.depth] = [];
        }
        flattened[node.depth].push(node);
        if (node.children) {
            queue.push(...node.children);
        }
    }
    return flattened;
}
function getTreeMapChartDatasets(definition, args) {
    const { dataSetsValues, labels, locale, axisFormats } = args;
    const localeFormat = { locale, format: axisFormats?.y };
    if (dataSetsValues.length === 0) {
        return [];
    }
    const tree = getSunburstTree(dataSetsValues, labels).sort((a, b) => b.value - a.value);
    const groupColors = getTreeMapGroupColors(definition, tree);
    const datasetEntries = [];
    const maxDatasetLength = Math.max(...dataSetsValues.map((ds) => ds.data.length));
    for (let i = 0; i < maxDatasetLength; i++) {
        datasetEntries[i] = {};
        for (let j = 0; j < dataSetsValues.length; j++) {
            datasetEntries[i][j] = dataSetsValues[j].data[i]
                ? String(dataSetsValues[j].data[i])
                : undefined;
        }
        datasetEntries[i].value = Number(labels[i]);
    }
    const showLabels = definition.showLabels ?? TreeMapChartDefaults.showLabels;
    const showValues = definition.showValues ?? TreeMapChartDefaults.showValues;
    const coloringOption = definition.coloringOptions || TreeMapChartDefaults.coloringOptions;
    let colorScale;
    if (coloringOption?.type === "colorScale") {
        colorScale = getTreeMapColorScale(tree, coloringOption);
    }
    const dataSets = [
        {
            data: [],
            tree: datasetEntries,
            labels: {
                display: showLabels || showValues,
                overflow: "hidden",
                ...getTextStyle(definition.valuesDesign, TreeMapChartDefaults.valuesDesign),
                formatter: (ctx) => {
                    return [
                        showLabels ? ctx.raw.g : undefined, // group name
                        showValues ? formatValue$1(ctx.raw.v, localeFormat) : undefined, // formatted value
                    ].filter(isDefined);
                },
            },
            captions: {
                display: definition.showHeaders ?? TreeMapChartDefaults.showHeaders,
                padding: 6,
                ...getTextStyle(definition.headerDesign, TreeMapChartDefaults.headerDesign),
            },
            key: "value",
            groups: range(0, dataSetsValues.length).map((i) => String(i)),
            borderWidth: 0,
            spacing: 1,
            displayMode: "headerBoxes",
            groupColors,
            backgroundColor: (ctx) => {
                if (ctx.type !== "data") {
                    return "transparent";
                }
                if (!ctx.raw.isLeaf) {
                    return definition.headerDesign?.fillColor || TreeMapChartDefaults.headerDesign?.fillColor;
                }
                if (coloringOption.type === "colorScale") {
                    return colorScale?.(ctx.raw.v) || "#FF0000";
                }
                else if (coloringOption.type === "categoryColor") {
                    return getTreeMapElementColor(ctx, tree, coloringOption, groupColors);
                }
                throw new Error(`Unsupported coloring option type}`);
            },
        },
    ];
    return dataSets;
}
function getTextStyle(design, defaultDesign) {
    const dynamicColor = (ctx) => {
        const backgroundColor = ctx.element.options.backgroundColor;
        return relativeLuminance(backgroundColor) > 0.7 ? "#666666" : "#FFFFFF";
    };
    return {
        align: design?.align ?? defaultDesign?.align,
        position: design?.verticalAlign ?? defaultDesign?.verticalAlign,
        color: design?.color || dynamicColor,
        hoverColor: design?.color || dynamicColor,
        font: {
            weight: design?.bold ?? defaultDesign?.bold ? "bold" : "normal",
            style: design?.italic ?? defaultDesign?.italic ? "italic" : "normal",
            size: design?.fontSize ?? defaultDesign?.fontSize,
        },
    };
}
function getTrendingLineDataSet(dataset, config, data) {
    const defaultBorderColor = colorToRGBA(dataset.backgroundColor);
    defaultBorderColor.a = 1;
    const borderColor = config.color || lightenColor(rgbaToHex(defaultBorderColor), 0.5);
    return {
        type: "line",
        xAxisID: config.type === "trailingMovingAverage"
            ? MOVING_AVERAGE_TREND_LINE_XAXIS_ID
            : TREND_LINE_XAXIS_ID,
        yAxisID: dataset.yAxisID,
        label: dataset.label ? _t$1("Trend line for %s", dataset.label) : "",
        data,
        order: -1,
        showLine: true,
        pointRadius: 0,
        backgroundColor: borderColor,
        borderColor,
        borderDash: [5, 5],
        borderWidth: undefined,
        fill: false,
        pointBackgroundColor: borderColor,
    };
}
/**
 * If the chart is a stacked area chart, we want to fill until the next dataset.
 * If the chart is a simple area chart, we want to fill until the origin (bottom axis).
 *
 * See https://www.chartjs.org/docs/latest/charts/area.html#filling-modes
 */
function getFillingMode(index, stackedChart) {
    if (!stackedChart) {
        return "origin";
    }
    return index === 0 ? "origin" : "-1";
}
function getChartColorsGenerator(definition, dataSetsSize) {
    return new ColorGenerator(dataSetsSize, definition.dataSets?.map((ds) => ds.backgroundColor) || []);
}
function getTreeMapGroupColors(definition, tree) {
    const colors = definition.coloringOptions?.type === "categoryColor" ? definition.coloringOptions.colors : [];
    const colorGenerator = new ColorGenerator(tree.length, colors);
    return tree.map((node) => ({
        label: node.label,
        color: colorGenerator.next(),
    }));
}
function getTreeMapColorScale(tree, coloringOption) {
    const treeNodesByLevel = pyramidizeTree(tree);
    const nodes = treeNodesByLevel[treeNodesByLevel.length - 1];
    const minValue = Math.min(...nodes.map((node) => node.value));
    const maxValue = Math.max(...nodes.map((node) => node.value));
    if (Number.isFinite(minValue) && Number.isFinite(maxValue)) {
        const colorThresholds = [{ value: minValue, color: coloringOption.minColor }];
        if (coloringOption.midColor) {
            const midValue = (minValue + maxValue) / 2;
            colorThresholds.push({ value: midValue, color: coloringOption.midColor });
        }
        colorThresholds.push({ value: maxValue, color: coloringOption.maxColor });
        return getColorScale(colorThresholds);
    }
    return undefined;
}
function getTreeMapElementColor(ctx, tree, coloringOption, categoryColors) {
    const rootCategory = ctx.raw._data.children[0][0];
    const baseColor = categoryColors.find((color) => color.label === rootCategory)?.color;
    if (!baseColor || !coloringOption.useValueBasedGradient) {
        return baseColor || "#FF0000";
    }
    const rootNode = tree.find((node) => node.label === rootCategory);
    if (!rootNode || !rootNode.children.length) {
        return baseColor;
    }
    const treeNodesByLevel = pyramidizeTree(rootNode.children);
    const leafValues = treeNodesByLevel[treeNodesByLevel.length - 1];
    const max = Math.max(...leafValues.map((node) => node.value));
    const min = Math.min(...leafValues.map((node) => node.value));
    if (min === max || !isFinite(min) || !isFinite(max)) {
        return baseColor;
    }
    const value = Number(ctx.raw.v) || 0;
    const factor = ((value - max) / (min - max)) * 0.5;
    return lightenColor(baseColor, factor);
}

/**
 * When a chart element is hovered (active), this plugin also activates all of its child elements and
 * lightens the color of the other elements.
 */
const sunburstHoverPlugin = {
    id: "sunburstHoverPlugin",
    afterEvent(chart, args, options) {
        if (!options.enabled) {
            return;
        }
        const chartActiveElements = chart.getActiveElements();
        let activeDataPoints = chartActiveElements.map((el) => ({
            datasetIndex: el.datasetIndex,
            index: el.index,
        }));
        for (const activeEl of chartActiveElements) {
            const activeDataset = chart.data.datasets[activeEl.datasetIndex];
            const activeData = activeDataset.data[activeEl.index];
            for (let datasetIndex = 0; datasetIndex < chart.data.datasets.length; datasetIndex++) {
                const dataset = chart.data.datasets[datasetIndex];
                for (let index = 0; index < dataset.data.length; index++) {
                    const data = dataset.data[index];
                    if (isChildGroup(activeData.groups, data.groups)) {
                        activeDataPoints.push({ datasetIndex, index });
                    }
                }
            }
        }
        activeDataPoints = activeDataPoints.filter((point) => {
            const { datasetIndex, index } = point;
            const data = chart.data.datasets[datasetIndex].data[index];
            return data.label !== GHOST_SUNBURST_VALUE;
        });
        chart.setActiveElements(activeDataPoints);
        for (const metaSet of chart.getSortedVisibleDatasetMetas()) {
            for (const arcElement of metaSet.data) {
                const context = arcElement["$context"];
                const { datasetIndex, index, dataset, raw } = context;
                if (raw.label === GHOST_SUNBURST_VALUE) {
                    continue;
                }
                const originalBackgroundColor = typeof dataset.backgroundColor === "function"
                    ? dataset.backgroundColor(context)
                    : dataset.backgroundColor;
                if (activeDataPoints.length &&
                    !activeDataPoints.some((el) => el.datasetIndex === datasetIndex && el.index === index)) {
                    arcElement.options.backgroundColor = lightenColor(originalBackgroundColor, 0.5);
                }
                else {
                    arcElement.options.backgroundColor = originalBackgroundColor;
                }
            }
        }
    },
};
function isChildGroup(parentGroup, childGroup) {
    return (childGroup.length > parentGroup.length &&
        parentGroup.every((group, i) => group === childGroup[i]));
}

const Y_PADDING = 3;
const sunburstLabelsPlugin = {
    id: "sunburstLabelsPlugin",
    afterDatasetsDraw(chart, args, options) {
        if ((!options.showValues && !options.showLabels) || chart.config.type !== "doughnut") {
            return;
        }
        const ctx = chart.ctx;
        drawSunburstChartValues(chart, options, ctx);
    },
};
function drawSunburstChartValues(chart, options, ctx) {
    const style = options.style;
    const fontSize = style.fontSize || 13;
    const lineHeight = fontSize + Y_PADDING;
    for (const dataset of chart._metasets) {
        for (let i = 0; i < dataset._dataset.data.length; i++) {
            const rawData = dataset._dataset.data[i];
            if (rawData.label === GHOST_SUNBURST_VALUE) {
                continue;
            }
            const valuesToDisplay = [
                options.showLabels ? rawData.label : undefined,
                options.showValues ? options.callback(rawData.value, "y") : undefined,
            ].filter(isDefined$1);
            const arc = dataset.data[i];
            let { startAngle, endAngle, innerRadius, outerRadius, circumference } = arc;
            // Same computations as in ChartJs ArcElement's draw method. Don't ask me why they divide by 4.
            const offset = arc.options.offset / 4;
            const fix = 1 - Math.sin(Math.min(Math.PI, circumference || 0));
            const radiusOffset = offset * fix;
            innerRadius += radiusOffset;
            outerRadius += radiusOffset;
            const midAngle = (startAngle + endAngle) / 2;
            const midRadius = (innerRadius + outerRadius) / 2;
            const availableWidth = (outerRadius - innerRadius) * 0.9;
            const angle = endAngle - startAngle;
            const availableHeight = angle >= Math.PI ? outerRadius : Math.sin(angle / 2) * innerRadius * 2;
            if (availableHeight < valuesToDisplay.length * lineHeight) {
                continue;
            }
            ctx.save();
            const centerOffset = { x: Math.cos(midAngle) * offset, y: Math.sin(midAngle) * offset };
            const centerX = chart.chartArea.left + chart.chartArea.width / 2 + centerOffset.x;
            const centerY = chart.chartArea.top + chart.chartArea.height / 2 + centerOffset.y;
            ctx.translate(centerX, centerY);
            let x;
            if (midAngle > Math.PI / 2) {
                ctx.rotate(midAngle - Math.PI);
                x = -midRadius;
            }
            else {
                x = midRadius;
                ctx.rotate(midAngle);
            }
            const backgroundColor = arc.options.backgroundColor;
            const defaultColor = relativeLuminance(backgroundColor) > 0.7 ? "#666666" : "#FFFFFF";
            ctx.fillStyle = style.textColor || defaultColor;
            ctx.textAlign = "center";
            ctx.textBaseline = "middle";
            ctx.font = getDefaultContextFont(fontSize, style.bold, style.italic);
            const y = -((valuesToDisplay.length - 1) * lineHeight) / 2;
            for (let j = 0; j < valuesToDisplay.length; j++) {
                const fittedText = sliceTextToFitWidth(ctx, availableWidth, valuesToDisplay[j], style, "px");
                ctx.fillText(fittedText, x, y + j * lineHeight);
            }
            ctx.restore();
        }
    }
}

/** This is a chartJS plugin that will draw connector lines between the bars of a Waterfall chart */
const waterfallLinesPlugin = {
    id: "waterfallLinesPlugin",
    beforeDraw(chart, args, options) {
        if (!options.showConnectorLines) {
            return;
        }
        // Note: private properties are not in the typing of chartJS (and some of the existing types are missing properties)
        // so we don't type anything in this file
        const drawData = chart._metasets?.[0]?.data;
        if (!drawData) {
            return;
        }
        const ctx = chart.ctx;
        ctx.save();
        ctx.setLineDash([3, 2]);
        for (let i = 0; i < drawData.length; i++) {
            const bar = drawData[i];
            if (bar.height === 0) {
                continue;
            }
            const nextBar = getNextNonEmptyBar(drawData, i);
            if (!nextBar) {
                break;
            }
            const rect = getBarElementRect(bar);
            const nextBarRect = getBarElementRect(nextBar);
            const rawBarValues = bar.$context.raw;
            const value = rawBarValues[1] - rawBarValues[0];
            const lineY = Math.round(value < 0 ? rect.bottom - 1 : rect.top);
            const lineStart = Math.round(rect.right);
            const lineEnd = Math.round(nextBarRect.left);
            ctx.strokeStyle = "#999";
            ctx.beginPath();
            ctx.moveTo(lineStart + 1, lineY + 0.5);
            ctx.lineTo(lineEnd, lineY + 0.5);
            ctx.stroke();
        }
        ctx.restore();
    },
};
function getBarElementRect(bar) {
    const flipped = bar.base < bar.y; // Bar are flipped for negative values in the dataset
    return {
        left: bar.x - bar.width / 2,
        right: bar.x + bar.width / 2,
        bottom: flipped ? bar.base + bar.height : bar.y + bar.height,
        top: flipped ? bar.base : bar.y,
    };
}
function getNextNonEmptyBar(bars, startIndex) {
    return bars.find((bar, i) => i > startIndex && bar.height !== 0);
}

chartJsExtensionRegistry.add("chartShowValuesPlugin", {
    register: (Chart) => Chart.register(chartShowValuesPlugin),
    unregister: (Chart) => Chart.unregister(chartShowValuesPlugin),
});
chartJsExtensionRegistry.add("waterfallLinesPlugin", {
    register: (Chart) => Chart.register(waterfallLinesPlugin),
    unregister: (Chart) => Chart.unregister(waterfallLinesPlugin),
});
chartJsExtensionRegistry.add("funnelController", {
    register: (Chart) => Chart.register(getFunnelChartController()),
    unregister: (Chart) => Chart.unregister(getFunnelChartController()),
});
chartJsExtensionRegistry.add("funnelElement", {
    register: (Chart) => Chart.register(getFunnelChartElement()),
    unregister: (Chart) => Chart.unregister(getFunnelChartElement()),
});
chartJsExtensionRegistry.add("funnelTooltipPositioner", {
    register: (Chart) => (Chart.Tooltip.positioners.funnelTooltipPositioner = funnelTooltipPositioner),
    // @ts-expect-error
    unregister: (Chart) => (Chart.Tooltip.positioners.funnelTooltipPositioner = undefined),
});
chartJsExtensionRegistry.add("sunburstLabelsPlugin", {
    register: (Chart) => Chart.register(sunburstLabelsPlugin),
    unregister: (Chart) => Chart.unregister(sunburstLabelsPlugin),
});
chartJsExtensionRegistry.add("sunburstHoverPlugin", {
    register: (Chart) => Chart.register(sunburstHoverPlugin),
    unregister: (Chart) => Chart.unregister(sunburstHoverPlugin),
});
class ChartJsComponent extends Component {
    static template = "o-spreadsheet-ChartJsComponent";
    static props = {
        chartId: String,
        isFullScreen: { type: Boolean, optional: true },
    };
    canvas = useRef("graphContainer");
    chart;
    currentRuntime;
    animationStore;
    currentDevicePixelRatio = window.devicePixelRatio;
    get background() {
        return this.chartRuntime.background;
    }
    get canvasStyle() {
        return `background-color: ${this.background}`;
    }
    get chartRuntime() {
        const runtime = this.env.model.getters.getChartRuntime(this.props.chartId);
        if (!("chartJsConfig" in runtime)) {
            throw new Error("Unsupported chart runtime");
        }
        return runtime;
    }
    setup() {
        if (this.shouldAnimate) {
            this.animationStore = useStore(ChartAnimationStore);
        }
        onMounted(() => {
            registerChartJSExtensions();
            const runtime = this.chartRuntime;
            this.currentRuntime = runtime;
            // Note: chartJS modify the runtime in place, so it's important to give it a copy
            this.createChart(deepCopy$1(runtime));
        });
        onWillUnmount(this.unmount.bind(this));
        useEffect(() => {
            const runtime = this.chartRuntime;
            if (runtime !== this.currentRuntime) {
                if (runtime.chartJsConfig.type !== this.currentRuntime.chartJsConfig.type) {
                    this.chart?.destroy();
                    this.createChart(deepCopy$1(runtime));
                }
                else {
                    this.updateChartJs(deepCopy$1(runtime));
                }
                this.currentRuntime = runtime;
            }
            else if (this.currentDevicePixelRatio !== window.devicePixelRatio) {
                this.currentDevicePixelRatio = window.devicePixelRatio;
                this.updateChartJs(deepCopy$1(this.currentRuntime));
            }
        });
    }
    unmount() {
        this.chart?.destroy();
    }
    get shouldAnimate() {
        return this.env.model.getters.isDashboard();
    }
    createChart(chartRuntime) {
        let chartData = chartRuntime.chartJsConfig;
        if (this.shouldAnimate && this.animationStore) {
            const chartType = this.env.model.getters.getChart(this.props.chartId)?.type;
            if (chartType && this.animationStore.animationPlayed[this.animationChartId] !== chartType) {
                chartData = this.enableAnimationInChartData(chartData);
                this.animationStore.disableAnimationForChart(this.animationChartId, chartType);
            }
        }
        const canvas = this.canvas.el;
        const ctx = canvas.getContext("2d");
        this.chart = new window.Chart(ctx, chartData);
    }
    updateChartJs(chartRuntime) {
        let chartData = chartRuntime.chartJsConfig;
        if (this.shouldAnimate) {
            const chartType = this.env.model.getters.getChart(this.props.chartId)?.type;
            if (chartType && this.hasChartDataChanged() && this.animationStore) {
                chartData = this.enableAnimationInChartData(chartData);
                this.animationStore.disableAnimationForChart(this.animationChartId, chartType);
            }
        }
        if (chartData.data && chartData.data.datasets) {
            this.chart.data = chartData.data;
            if (chartData.options?.plugins?.title) {
                this.chart.config.options.plugins.title = chartData.options.plugins.title;
            }
        }
        else {
            this.chart.data.datasets = [];
        }
        this.chart.config.options = chartData.options;
        this.chart.update();
    }
    hasChartDataChanged() {
        return !deepEquals$1(this.getChartDataInRuntime(this.currentRuntime), this.getChartDataInRuntime(this.chartRuntime));
    }
    enableAnimationInChartData(chartData) {
        return {
            ...chartData,
            options: { ...chartData.options, animation: { animateRotate: true } },
        };
    }
    getChartDataInRuntime(runtime) {
        const data = runtime.chartJsConfig.data;
        return {
            labels: data.labels,
            dataset: data.datasets.map((dataset) => ({
                data: dataset.data,
                label: dataset.label,
                tree: dataset.tree,
            })),
        };
    }
    get animationChartId() {
        return this.props.isFullScreen ? this.props.chartId + "-fullscreen" : this.props.chartId;
    }
}

/**
 * AbstractChart is the class from which every Chart should inherit.
 * The role of this class is to maintain the state of each chart.
 */
class AbstractChart {
    sheetId;
    title;
    getters;
    humanize;
    constructor(definition, sheetId, getters) {
        this.title = definition.title;
        this.sheetId = sheetId;
        this.getters = getters;
        this.humanize = definition.humanize ?? true;
    }
    /**
     * Validate the chart definition given as arguments. This function will be
     * called from allowDispatch function
     */
    static validateChartDefinition(validator, definition) {
        throw new Error("This method should be implemented by sub class");
    }
    /**
     * Get a new chart definition transformed with the executed command. This
     * functions will be called during operational transform process
     */
    static transformDefinition(chartSheetId, definition, applyChange) {
        throw new Error("This method should be implemented by sub class");
    }
    /**
     * Get an empty definition based on the given context
     */
    static getDefinitionFromContextCreation(context) {
        throw new Error("This method should be implemented by sub class");
    }
    getCommonDataSetAttributesForExcel(labelRange, dataSets, shouldRemoveFirstLabel) {
        const excelDataSets = dataSets
            .map((ds) => toExcelDataset(this.getters, ds))
            .filter((ds) => ds.range !== "" && ds.range !== CellErrorType$1.InvalidReference);
        const excelLabelRange = toExcelLabelRange(this.getters, labelRange, shouldRemoveFirstLabel);
        return {
            dataSets: excelDataSets,
            labelRange: excelLabelRange,
        };
    }
}

function getBaselineText(baseline, keyValue, baselineMode, humanizeNumbers, locale) {
    if (!baseline) {
        return "";
    }
    else if (baselineMode === "text" ||
        keyValue?.type !== CellValueType.number ||
        baseline.type !== CellValueType.number) {
        if (humanizeNumbers) {
            return humanizeNumber(baseline, locale);
        }
        return baseline.formattedValue;
    }
    let { value, format } = baseline;
    if (baselineMode === "progress") {
        value = keyValue.value / value;
        format = "0.0%";
    }
    else {
        value = Math.abs(keyValue.value - value);
        if (baselineMode === "percentage" && value !== 0) {
            value = value / baseline.value;
        }
        if (baselineMode === "percentage") {
            format = "0.0%";
        }
        if (!format) {
            value = Math.round(value * 100) / 100;
        }
    }
    if (humanizeNumbers) {
        return humanizeNumber({ value, format }, locale);
    }
    return formatValue$1(value, { format, locale });
}
function getKeyValueText(keyValueCell, humanizeNumbers, locale) {
    if (!keyValueCell) {
        return "";
    }
    if (humanizeNumbers) {
        return humanizeNumber(keyValueCell, locale);
    }
    return keyValueCell.formattedValue ?? String(keyValueCell.value ?? "");
}
function getBaselineColor(baseline, baselineMode, keyValue, colorUp, colorDown) {
    if (baselineMode === "text" ||
        baselineMode === "progress" ||
        baseline?.type !== CellValueType.number ||
        keyValue?.type !== CellValueType.number) {
        return undefined;
    }
    const diff = keyValue.value - baseline.value;
    if (diff > 0) {
        return colorUp;
    }
    else if (diff < 0) {
        return colorDown;
    }
    return undefined;
}
function getBaselineArrowDirection(baseline, keyValue, baselineMode) {
    if (baselineMode === "text" ||
        baseline?.type !== CellValueType.number ||
        keyValue?.type !== CellValueType.number) {
        return "neutral";
    }
    const diff = keyValue.value - baseline.value;
    if (diff > 0) {
        return "up";
    }
    else if (diff < 0) {
        return "down";
    }
    return "neutral";
}
function checkKeyValue(definition) {
    return definition.keyValue && !rangeReference.test(definition.keyValue)
        ? "InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */
        : "Success" /* CommandResult.Success */;
}
function checkBaseline(definition) {
    return definition.baseline && !rangeReference.test(definition.baseline)
        ? "InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */
        : "Success" /* CommandResult.Success */;
}
const Path2DConstructor = globalThis.Path2D;
const arrowDownPath = Path2DConstructor &&
    new Path2DConstructor("M8.6 4.8a.5.5 0 0 1 0 .75l-3.9 3.9a.5 .5 0 0 1 -.75 0l-3.8 -3.9a.5 .5 0 0 1 0 -.75l.4-.4a.5.5 0 0 1 .75 0l2.3 2.4v-5.7c0-.25.25-.5.5-.5h.6c.25 0 .5.25.5.5v5.8l2.3 -2.4a.5.5 0 0 1 .75 0z");
const arrowUpPath = Path2DConstructor &&
    new Path2DConstructor("M8.7 5.5a.5.5 0 0 0 0-.75l-3.8-4a.5.5 0 0 0-.75 0l-3.8 4a.5.5 0 0 0 0 .75l.4.4a.5.5 0 0 0 .75 0l2.3-2.4v5.8c0 .25.25.5.5.5h.6c.25 0 .5-.25.5-.5v-5.8l2.2 2.4a.5.5 0 0 0 .75 0z");
let ScorecardChart$1 = class ScorecardChart extends AbstractChart {
    keyValue;
    keyDescr;
    baseline;
    baselineMode;
    baselineDescr;
    progressBar = false;
    background;
    baselineColorUp;
    baselineColorDown;
    fontColor;
    humanize;
    type = "scorecard";
    constructor(definition, sheetId, getters) {
        super(definition, sheetId, getters);
        this.keyValue = createValidRange(getters, sheetId, definition.keyValue);
        this.keyDescr = definition.keyDescr;
        this.baseline = createValidRange(getters, sheetId, definition.baseline);
        this.baselineMode = definition.baselineMode;
        this.baselineDescr = definition.baselineDescr;
        this.background = definition.background;
        this.baselineColorUp = definition.baselineColorUp ?? DEFAULT_SCORECARD_BASELINE_COLOR_UP;
        this.baselineColorDown = definition.baselineColorDown ?? DEFAULT_SCORECARD_BASELINE_COLOR_DOWN;
        this.humanize = definition.humanize ?? true;
    }
    static validateChartDefinition(validator, definition) {
        return validator.checkValidations(definition, checkKeyValue, checkBaseline);
    }
    static getDefinitionFromContextCreation(context) {
        return {
            background: context.background,
            type: "scorecard",
            keyValue: context.range ? context.range[0].dataRange : undefined,
            title: context.title || { text: "" },
            baselineMode: DEFAULT_SCORECARD_BASELINE_MODE,
            baselineColorUp: DEFAULT_SCORECARD_BASELINE_COLOR_UP,
            baselineColorDown: DEFAULT_SCORECARD_BASELINE_COLOR_DOWN,
            baseline: context.auxiliaryRange || "",
            humanize: context.humanize,
        };
    }
    static transformDefinition(chartSheetId, definition, applyChange) {
        let baseline;
        let keyValue;
        if (definition.baseline) {
            const adaptedRange = adaptStringRange(chartSheetId, definition.baseline, applyChange);
            if (adaptedRange !== CellErrorType$1.InvalidReference) {
                baseline = adaptedRange;
            }
        }
        if (definition.keyValue) {
            const adaptedRange = adaptStringRange(chartSheetId, definition.keyValue, applyChange);
            if (adaptedRange !== CellErrorType$1.InvalidReference) {
                keyValue = adaptedRange;
            }
        }
        return {
            ...definition,
            baseline,
            keyValue,
        };
    }
    duplicateInDuplicatedSheet(newSheetId) {
        const baseline = duplicateLabelRangeInDuplicatedSheet(this.sheetId, newSheetId, this.baseline);
        const keyValue = duplicateLabelRangeInDuplicatedSheet(this.sheetId, newSheetId, this.keyValue);
        const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue, newSheetId);
        return new ScorecardChart(definition, newSheetId, this.getters);
    }
    copyInSheetId(sheetId) {
        const definition = this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue, sheetId);
        return new ScorecardChart(definition, sheetId, this.getters);
    }
    getDefinition() {
        return this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue);
    }
    getContextCreation() {
        return {
            ...this,
            range: this.keyValue
                ? [{ dataRange: this.getters.getRangeString(this.keyValue, this.sheetId) }]
                : undefined,
            auxiliaryRange: this.baseline
                ? this.getters.getRangeString(this.baseline, this.sheetId)
                : undefined,
        };
    }
    getDefinitionWithSpecificRanges(baseline, keyValue, targetSheetId) {
        return {
            baselineColorDown: this.baselineColorDown,
            baselineColorUp: this.baselineColorUp,
            baselineMode: this.baselineMode,
            title: this.title,
            type: "scorecard",
            background: this.background,
            baseline: baseline
                ? this.getters.getRangeString(baseline, targetSheetId || this.sheetId)
                : undefined,
            baselineDescr: this.baselineDescr,
            keyValue: keyValue
                ? this.getters.getRangeString(keyValue, targetSheetId || this.sheetId)
                : undefined,
            keyDescr: this.keyDescr,
            humanize: this.humanize,
        };
    }
    getDefinitionForExcel() {
        // This kind of graph is not exportable in Excel
        return undefined;
    }
    updateRanges(applyChange) {
        const baseline = adaptChartRange(this.baseline, applyChange);
        const keyValue = adaptChartRange(this.keyValue, applyChange);
        if (this.baseline === baseline && this.keyValue === keyValue) {
            return this;
        }
        const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue);
        return new ScorecardChart(definition, this.sheetId, this.getters);
    }
};
function drawScoreChart(structure, canvas) {
    const ctx = canvas.getContext("2d");
    if (!ctx) {
        throw new Error("Unable to retrieve 2D context from canvas");
    }
    const dpr = typeof globalThis.devicePixelRatio === "number" ? globalThis.devicePixelRatio : 1;
    canvas.width = dpr * structure.canvas.width;
    canvas.height = dpr * structure.canvas.height;
    ctx.scale(dpr, dpr);
    const availableWidth = structure.canvas.width - CHART_PADDING;
    ctx.fillStyle = structure.canvas.backgroundColor;
    ctx.fillRect(0, 0, structure.canvas.width, structure.canvas.height);
    if (structure.title) {
        ctx.font = structure.title.style.font;
        ctx.fillStyle = structure.title.style.color;
        const baseline = ctx.textBaseline;
        ctx.textBaseline = "middle";
        ctx.fillText(clipTextWithEllipsis(ctx, structure.title.text, availableWidth - structure.title.position.x), structure.title.position.x, structure.title.position.y);
        ctx.textBaseline = baseline;
    }
    if (structure.baseline) {
        ctx.font = structure.baseline.style.font;
        ctx.fillStyle = structure.baseline.style.color;
        drawDecoratedText(ctx, structure.baseline.text, structure.baseline.position, structure.baseline.style.underline, structure.baseline.style.strikethrough);
    }
    if (structure.baselineArrow && structure.baselineArrow.style.size > 0 && Path2DConstructor) {
        ctx.save();
        ctx.fillStyle = structure.baselineArrow.style.color;
        ctx.translate(structure.baselineArrow.position.x, structure.baselineArrow.position.y);
        // This ratio is computed according to the original svg size and the final size we want
        const ratio = structure.baselineArrow.style.size / 10;
        ctx.scale(ratio, ratio);
        switch (structure.baselineArrow.direction) {
            case "down": {
                ctx.fill(arrowDownPath);
                break;
            }
            case "up": {
                ctx.fill(arrowUpPath);
                break;
            }
        }
        ctx.restore();
    }
    if (structure.baselineDescr) {
        const descr = structure.baselineDescr;
        ctx.font = descr.style.font;
        ctx.fillStyle = descr.style.color;
        ctx.fillText(clipTextWithEllipsis(ctx, descr.text, availableWidth - descr.position.x), descr.position.x, descr.position.y);
    }
    if (structure.key) {
        ctx.font = structure.key.style.font;
        ctx.fillStyle = structure.key.style.color;
        drawDecoratedText(ctx, clipTextWithEllipsis(ctx, structure.key.text, availableWidth - structure.key.position.x), structure.key.position, structure.key.style.underline, structure.key.style.strikethrough);
    }
    if (structure.keyDescr) {
        const descr = structure.keyDescr;
        ctx.font = structure.keyDescr?.style.font ?? descr.style.font;
        ctx.fillStyle = descr.style.color;
        ctx.fillText(clipTextWithEllipsis(ctx, descr.text, availableWidth - descr.position.x), descr.position.x, descr.position.y);
    }
    if (structure.progressBar) {
        ctx.fillStyle = structure.progressBar.style.backgroundColor;
        ctx.beginPath();
        ctx.roundRect(structure.progressBar.position.x, structure.progressBar.position.y, structure.progressBar.dimension.width, structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        ctx.fill();
        ctx.fillStyle = structure.progressBar.style.color;
        ctx.beginPath();
        if (structure.progressBar.value > 0) {
            ctx.roundRect(structure.progressBar.position.x, structure.progressBar.position.y, structure.progressBar.dimension.width *
                Math.max(0, Math.min(1.0, structure.progressBar.value)), structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        }
        else {
            const width = structure.progressBar.dimension.width *
                Math.max(0, Math.min(1.0, -structure.progressBar.value));
            ctx.roundRect(structure.progressBar.position.x + structure.progressBar.dimension.width - width, structure.progressBar.position.y, width, structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        }
        ctx.fill();
    }
}
function createScorecardChartRuntime(chart, getters) {
    let formattedKeyValue = "";
    let keyValueCell;
    const locale = getters.getLocale();
    if (chart.keyValue) {
        const keyValuePosition = {
            sheetId: chart.keyValue.sheetId,
            col: chart.keyValue.zone.left,
            row: chart.keyValue.zone.top,
        };
        keyValueCell = getters.getEvaluatedCell(keyValuePosition);
        formattedKeyValue = getKeyValueText(keyValueCell, chart.humanize ?? true, locale);
    }
    let baselineCell;
    const baseline = chart.baseline;
    if (baseline) {
        const baselinePosition = {
            sheetId: baseline.sheetId,
            col: baseline.zone.left,
            row: baseline.zone.top,
        };
        baselineCell = getters.getEvaluatedCell(baselinePosition);
    }
    const { background, fontColor } = getters.getStyleOfSingleCellChart(chart.background, chart.keyValue);
    const baselineDisplay = getBaselineText(baselineCell, keyValueCell, chart.baselineMode, chart.humanize ?? true, locale);
    const baselineValue = chart.baselineMode === "progress" && isNumber(baselineDisplay, locale)
        ? toNumber(baselineDisplay, locale)
        : 0;
    return {
        title: {
            ...chart.title,
            text: chart.title.text ? getters.dynamicTranslate(chart.title.text) : "",
        },
        keyValue: formattedKeyValue,
        keyDescr: chart.keyDescr?.text ? getters.dynamicTranslate(chart.keyDescr.text) : "",
        baselineDisplay,
        baselineArrow: getBaselineArrowDirection(baselineCell, keyValueCell, chart.baselineMode),
        baselineColor: getBaselineColor(baselineCell, chart.baselineMode, keyValueCell, chart.baselineColorUp, chart.baselineColorDown),
        baselineDescr: chart.baselineMode !== "progress" && chart.baselineDescr?.text
            ? getters.dynamicTranslate(chart.baselineDescr.text)
            : "",
        fontColor,
        background,
        baselineStyle: {
            ...(chart.baselineMode !== "percentage" && chart.baselineMode !== "progress" && baseline
                ? getters.getCellComputedStyle({
                    sheetId: baseline.sheetId,
                    col: baseline.zone.left,
                    row: baseline.zone.top,
                })
                : undefined),
            fontSize: chart.baselineDescr?.fontSize,
            align: chart.baselineDescr?.align,
        },
        baselineDescrStyle: { textColor: chart.baselineDescr?.color, ...chart.baselineDescr },
        keyValueStyle: {
            ...(chart.keyValue
                ? getters.getCellComputedStyle({
                    sheetId: chart.keyValue.sheetId,
                    col: chart.keyValue.zone.left,
                    row: chart.keyValue.zone.top,
                })
                : undefined),
            fontSize: chart.keyDescr?.fontSize,
            align: chart.keyDescr?.align,
        },
        keyValueDescrStyle: { textColor: chart.keyDescr?.color, ...chart.keyDescr },
        progressBar: chart.baselineMode === "progress"
            ? {
                value: baselineValue,
                color: baselineValue > 0 ? chart.baselineColorUp : chart.baselineColorDown,
            }
            : undefined,
    };
}

/* Padding at the border of the chart */
const BOTTOM_PADDING_RATIO = 0.05;
function formatBaselineDescr(baselineDescr, baseline) {
    const _baselineDescr = baselineDescr || "";
    return baseline && _baselineDescr ? " " + _baselineDescr : _baselineDescr;
}
function getScorecardConfiguration({ width, height }, runtime) {
    const designer = new ScorecardChartConfigBuilder({ width, height }, runtime);
    return designer.computeDesign();
}
class ScorecardChartConfigBuilder {
    runtime;
    context;
    width;
    height;
    constructor({ width, height }, runtime) {
        this.runtime = runtime;
        this.width = width;
        this.height = height;
        if (typeof OffscreenCanvas === "undefined") {
            throw new Error("OffscreenCanvas is not supported in this environment");
        }
        const canvas = new globalThis.OffscreenCanvas(width, height);
        const ctx = canvas.getContext("2d");
        if (!ctx) {
            throw new Error("Unable to create scorecard measurement context");
        }
        this.context = ctx;
    }
    computeDesign() {
        const structure = {
            canvas: {
                width: this.width,
                height: this.height,
                backgroundColor: this.backgroundColor,
            },
        };
        const style = this.getTextStyles();
        let titleHeight = 0;
        if (this.title) {
            let x, titleWidth;
            ({ height: titleHeight, width: titleWidth } = this.getFullTextDimensions(this.title, style.title.font));
            switch (this.runtime.title.align) {
                case "center":
                    x = (this.width - titleWidth) / 2;
                    break;
                case "right":
                    x = this.width - titleWidth - CHART_PADDING;
                    break;
                case "left":
                default:
                    x = CHART_PADDING;
            }
            structure.title = {
                text: this.title,
                style: style.title,
                position: {
                    x,
                    y: CHART_PADDING_BOTTOM + titleHeight / 2,
                },
            };
        }
        const baselineArrowSize = style.baselineArrow?.size ?? 0;
        let { height: baselineHeight, width: baselineWidth } = this.getTextDimensions(this.baseline, style.baselineValue.font);
        if (!this.baseline) {
            baselineHeight = this.getTextDimensions(this.baselineDescr, style.baselineDescr.font).height;
        }
        const baselineDescrWidth = this.getTextDimensions(this.baselineDescr, style.baselineDescr.font).width;
        let baselineX;
        switch (this.runtime.baselineStyle?.align) {
            case "right":
                baselineX = this.width - CHART_PADDING - baselineDescrWidth - baselineWidth;
                break;
            case "left":
                baselineX = CHART_PADDING + baselineArrowSize;
                break;
            default:
                baselineX = (this.width - baselineWidth - baselineDescrWidth + baselineArrowSize) / 2;
        }
        if (this.baseline) {
            structure.baseline = {
                text: this.baseline,
                style: style.baselineValue,
                position: {
                    x: baselineX,
                    y: this.keyValue
                        ? this.height * (1 - BOTTOM_PADDING_RATIO * (this.runtime.progressBar ? 1 : 2))
                        : this.height - (this.height - titleHeight - baselineHeight) / 2 - CHART_PADDING_BOTTOM,
                },
            };
            if (style.baselineArrow && !this.runtime.progressBar) {
                structure.baselineArrow = {
                    direction: this.baselineArrow,
                    style: style.baselineArrow,
                    position: {
                        x: structure.baseline.position.x - baselineArrowSize,
                        y: structure.baseline.position.y - (baselineHeight + baselineArrowSize) / 2,
                    },
                };
            }
        }
        if (structure.baseline && this.baselineDescr) {
            const position = {
                x: structure.baseline.position.x + baselineWidth,
                y: structure.baseline.position.y,
            };
            structure.baselineDescr = {
                text: this.baselineDescr,
                style: style.baselineDescr,
                position,
            };
        }
        let progressBarHeight = 0;
        if (this.runtime.progressBar) {
            progressBarHeight = this.height * 0.05;
            structure.progressBar = {
                position: {
                    x: 2 * CHART_PADDING,
                    y: this.height * (1 - 2 * BOTTOM_PADDING_RATIO) - baselineHeight - progressBarHeight,
                },
                dimension: {
                    height: progressBarHeight,
                    width: this.width - 4 * CHART_PADDING,
                },
                value: this.runtime.progressBar.value,
                style: {
                    color: this.runtime.progressBar.color,
                    backgroundColor: this.secondaryFontColor,
                },
            };
        }
        const { width: keyWidth, height: keyHeight } = this.getFullTextDimensions(this.keyValue, style.keyValue.font);
        const keyDescrWidth = this.getTextDimensions(this.keyDescr, style.keyDescr.font).width;
        let keyX;
        switch (this.runtime.keyValueStyle?.align) {
            case "right":
                keyX = this.width - CHART_PADDING - keyDescrWidth - keyWidth;
                break;
            case "left":
                keyX = CHART_PADDING;
                break;
            default:
                keyX = (this.width - keyWidth - keyDescrWidth) / 2;
        }
        if (this.keyValue) {
            structure.key = {
                text: this.keyValue,
                style: style.keyValue,
                position: {
                    x: Math.max(CHART_PADDING, keyX),
                    y: this.height * (0.5 - BOTTOM_PADDING_RATIO * 2) +
                        CHART_PADDING_BOTTOM / 2 +
                        (titleHeight + keyHeight / 2) / 2,
                },
            };
        }
        if (structure.key && this.keyDescr) {
            const position = {
                x: structure.key.position.x + keyWidth,
                y: structure.key.position.y,
            };
            structure.keyDescr = {
                text: this.keyDescr,
                style: style.keyDescr,
                position,
            };
        }
        return structure;
    }
    get title() {
        return this.runtime.title.text ?? "";
    }
    get keyValue() {
        return this.runtime.keyValue;
    }
    get keyDescr() {
        return formatBaselineDescr(this.runtime.keyDescr, this.keyValue);
    }
    get baseline() {
        return this.runtime.baselineDisplay;
    }
    get baselineDescr() {
        return formatBaselineDescr(this.runtime.baselineDescr, this.baseline);
    }
    get baselineArrow() {
        return this.runtime.baselineArrow;
    }
    get backgroundColor() {
        return this.runtime.background;
    }
    get secondaryFontColor() {
        return chartMutedFontColor(this.backgroundColor);
    }
    getTextDimensions(text, font) {
        this.context.font = font;
        const measure = this.context.measureText(text);
        return {
            width: measure.width,
            height: measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent,
        };
    }
    getFullTextDimensions(text, font) {
        this.context.font = font;
        const measure = this.context.measureText(text);
        return {
            width: measure.width,
            height: measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent,
        };
    }
    getTextStyles() {
        const keyValueFontSize = this.runtime.keyValueStyle?.fontSize ?? DEFAULT_SCORECARD_KEY_VALUE_FONT_SIZE;
        const keyValueDescrFontSize = Math.floor(0.9 * keyValueFontSize);
        let baselineValueFontSize = this.runtime.baselineStyle?.fontSize ?? DEFAULT_SCORECARD_BASELINE_FONT_SIZE;
        const baselineDescrFontSize = Math.floor(0.9 * baselineValueFontSize);
        if (this.runtime.progressBar) {
            baselineValueFontSize /= 1.5;
        }
        return {
            title: {
                font: getDefaultContextFont(this.runtime.title.fontSize ?? SCORECARD_CHART_TITLE_FONT_SIZE, this.runtime.title.bold, this.runtime.title.italic),
                color: this.runtime.title.color ?? this.secondaryFontColor,
            },
            keyValue: {
                color: this.runtime.keyValueStyle?.textColor || this.runtime.fontColor,
                font: getDefaultContextFont(keyValueFontSize, this.runtime.keyValueStyle?.bold, this.runtime.keyValueStyle?.italic),
                strikethrough: this.runtime.keyValueStyle?.strikethrough,
                underline: this.runtime.keyValueStyle?.underline,
            },
            keyDescr: {
                color: this.runtime.keyValueDescrStyle?.textColor || this.runtime.fontColor,
                font: getDefaultContextFont(keyValueDescrFontSize, this.runtime.keyValueDescrStyle?.bold, this.runtime.keyValueDescrStyle?.italic),
                strikethrough: this.runtime.keyValueDescrStyle?.strikethrough,
                underline: this.runtime.keyValueDescrStyle?.underline,
            },
            baselineValue: {
                font: getDefaultContextFont(baselineValueFontSize, this.runtime.baselineStyle?.bold, this.runtime.baselineStyle?.italic),
                strikethrough: this.runtime.baselineStyle?.strikethrough,
                underline: this.runtime.baselineStyle?.underline,
                color: this.runtime.baselineColor ||
                    this.runtime.baselineStyle?.textColor ||
                    this.secondaryFontColor,
            },
            baselineDescr: {
                font: getDefaultContextFont(baselineDescrFontSize, this.runtime.baselineDescrStyle?.bold, this.runtime.baselineDescrStyle?.italic),
                strikethrough: this.runtime.baselineDescrStyle?.strikethrough,
                underline: this.runtime.baselineDescrStyle?.underline,
                color: this.runtime.baselineDescrStyle?.textColor ?? this.secondaryFontColor,
            },
            baselineArrow: this.baselineArrow === "neutral" || this.runtime.progressBar
                ? undefined
                : {
                    size: this.keyValue ? 0.8 * baselineValueFontSize : 0,
                    color: this.runtime.baselineColor ||
                        this.runtime.baselineStyle?.textColor ||
                        this.secondaryFontColor,
                },
        };
    }
}

class ScorecardChart extends Component {
    static template = "o-spreadsheet-ScorecardChart";
    static props = {
        chartId: String,
        isFullScreen: { type: Boolean, optional: true },
    };
    canvas = useRef("chartContainer");
    get runtime() {
        return this.env.model.getters.getChartRuntime(this.props.chartId);
    }
    get title() {
        const title = this.env.model.getters.getChartDefinition(this.props.chartId).title.text;
        return title ? this.env.model.getters.dynamicTranslate(title) : "";
    }
    setup() {
        useEffect(this.createChart.bind(this), () => {
            const canvas = this.canvas.el;
            const rect = canvas.getBoundingClientRect();
            return [rect.width, rect.height, this.runtime, this.canvas.el, window.devicePixelRatio];
        });
    }
    createChart() {
        const canvas = this.canvas.el;
        const config = getScorecardConfiguration(canvas.getBoundingClientRect(), this.runtime);
        drawScoreChart(config, canvas);
    }
}

/**
 * This file is largely inspired by owl 1.
 * `css` tag has been removed from owl 2 without workaround to manage css.
 * So, the solution was to import the behavior of owl 1 directly in our
 * codebase, with one difference: the css is added to the sheet as soon as the
 * css tag is executed. In owl 1, the css was added as soon as a Component was
 * created for the first time.
 */
function getTextDecoration({ strikethrough, underline, }) {
    if (!strikethrough && !underline) {
        return "none";
    }
    return `${strikethrough ? "line-through" : ""} ${underline ? "underline" : ""}`;
}
/**
 * Convert the cell style to CSS properties.
 */
function cellStyleToCss(style) {
    const attributes = cellTextStyleToCss(style);
    if (!style)
        return attributes;
    if (style.fillColor) {
        attributes["background"] = style.fillColor;
    }
    return attributes;
}
/**
 * Convert the cell text style to CSS properties.
 */
function cellTextStyleToCss(style) {
    const attributes = {};
    if (!style)
        return attributes;
    if (style.bold) {
        attributes["font-weight"] = "bold";
    }
    if (style.italic) {
        attributes["font-style"] = "italic";
    }
    if (style.fontSize) {
        attributes["font-size"] = `${style.fontSize}px`;
    }
    if (style.strikethrough || style.underline) {
        let decoration = style.strikethrough ? "line-through" : "";
        decoration = style.underline ? decoration + " underline" : decoration;
        attributes["text-decoration"] = decoration;
    }
    if (style.textColor) {
        attributes["color"] = style.textColor;
    }
    return attributes;
}
/**
 * Transform CSS properties into a CSS string.
 */
function cssPropertiesToCss(attributes) {
    let styleStr = "";
    for (const attName in attributes) {
        if (!attributes[attName]) {
            continue;
        }
        styleStr += `${attName}:${attributes[attName]}; `;
    }
    return styleStr;
}
function getElementMargins(el) {
    const style = window.getComputedStyle(el);
    return {
        top: parseInt(style.marginTop, 10) || 0,
        bottom: parseInt(style.marginBottom, 10) || 0,
        left: parseInt(style.marginLeft, 10) || 0,
        right: parseInt(style.marginRight, 10) || 0,
    };
}

function centerFigurePosition(getters, size) {
    const { scrollX, scrollY } = getters.getActiveSheetScrollInfo();
    const dim = getters.getSheetViewDimension();
    const posX = scrollX + Math.max(0, (dim.width - size.width) / 2);
    const posY = scrollY + Math.max(0, (dim.height - size.height) / 2);
    return getters.getPositionAnchorOffset({ x: posX, y: posY });
}
function getMaxFigureSize(getters, figureSize) {
    const size = deepCopy$1(figureSize);
    const dim = getters.getSheetViewDimension();
    const maxWidth = dim.width;
    const maxHeight = dim.height;
    if (size.width > maxWidth) {
        const ratio = maxWidth / size.width;
        size.width = maxWidth;
        size.height = size.height * ratio;
    }
    if (size.height > maxHeight) {
        const ratio = maxHeight / size.height;
        size.height = maxHeight;
        size.width = size.width * ratio;
    }
    return size;
}

const macRegex = /Mac/i;
const MODIFIER_KEYS = ["Shift", "Control", "Alt", "Meta"];
/**
 * Return true if the event was triggered from
 * a child element.
 */
function isChildEvent(parent, ev) {
    if (!parent)
        return false;
    return !!ev.target && parent.contains(ev.target);
}
function gridOverlayPosition() {
    const spreadsheetElement = document.querySelector(".o-grid-overlay");
    if (spreadsheetElement) {
        const { top, left } = spreadsheetElement.getBoundingClientRect();
        return { top, left };
    }
    throw new Error("Can't find spreadsheet position");
}
function getRefBoundingRect(ref) {
    if (!ref.el) {
        return { x: 0, y: 0, width: 0, height: 0 };
    }
    return getBoundingRectAsPOJO(ref.el);
}
function getBoundingRectAsPOJO(el) {
    const rect = el.getBoundingClientRect();
    return {
        x: rect.x,
        y: rect.y,
        width: rect.width,
        height: rect.height,
    };
}
/**
 * Iterate over all the children of `el` in the dom tree starting at `el`, depth first.
 */
function* iterateChildren(el) {
    yield el;
    if (el.hasChildNodes()) {
        for (const child of el.childNodes) {
            yield* iterateChildren(child);
        }
    }
}
function getOpenedMenus() {
    return Array.from(document.querySelectorAll(".o-spreadsheet .o-menu"));
}
function getCurrentSelection(el) {
    const { startElement, endElement, startSelectionOffset, endSelectionOffset } = getStartAndEndSelection(el);
    const startSizeBefore = findSelectionIndex(el, startElement, startSelectionOffset);
    const endSizeBefore = findSelectionIndex(el, endElement, endSelectionOffset);
    return {
        start: startSizeBefore,
        end: endSizeBefore,
    };
}
function getStartAndEndSelection(el) {
    const selection = document.getSelection();
    return {
        startElement: selection.anchorNode || el,
        startSelectionOffset: selection.anchorOffset,
        endElement: selection.focusNode || el,
        endSelectionOffset: selection.focusOffset,
    };
}
/**
 * Computes the text 'index' inside this.el based on the currently selected node and its offset.
 * The selected node is either a Text node or an Element node.
 *
 * case 1 -Text node:
 * the offset is the number of characters from the start of the node. We have to add this offset to the
 * content length of all previous nodes.
 *
 * case 2 - Element node:
 * the offset is the number of child nodes before the selected node. We have to add the content length of
 * all the nodes prior to the selected node as well as the content of the child node before the offset.
 *
 * See the MDN documentation for more details.
 * https://developer.mozilla.org/en-US/docs/Web/API/Range/startOffset
 * https://developer.mozilla.org/en-US/docs/Web/API/Range/endOffset
 *
 */
function findSelectionIndex(el, nodeToFind, nodeOffset) {
    let usedCharacters = 0;
    const it = iterateChildren(el);
    let current = it.next();
    let isFirstParagraph = true;
    while (!current.done && current.value !== nodeToFind) {
        if (!current.value.hasChildNodes()) {
            if (current.value.textContent) {
                usedCharacters += current.value.textContent.length;
            }
        }
        // One new paragraph = one new line character, except for the first paragraph
        if (current.value.nodeName === "P" ||
            (current.value.nodeName === "DIV" && current.value !== el) // On paste, the HTML may contain <div> instead of <p>
        ) {
            if (isFirstParagraph) {
                isFirstParagraph = false;
            }
            else {
                usedCharacters++;
            }
        }
        current = it.next();
    }
    if (current.value !== nodeToFind) {
        /** This situation can happen if the code is called while the selection is not currently on the element.
         * In this case, we return 0 because we don't know the size of the text before the selection.
         *
         * A known occurrence is triggered since the introduction of commit d4663158 (PR #2038).
         */
        return 0;
    }
    else {
        if (!current.value.hasChildNodes()) {
            usedCharacters += nodeOffset;
        }
        else {
            const children = [...current.value.childNodes].slice(0, nodeOffset);
            usedCharacters += children.reduce((acc, child, index) => {
                if (child.textContent !== null) {
                    // need to account for paragraph nodes that implicitly add a new line
                    // except for the last paragraph
                    let chars = child.textContent.length;
                    if (child.nodeName === "P" && index !== children.length - 1) {
                        chars++;
                    }
                    return acc + chars;
                }
                else {
                    return acc;
                }
            }, 0);
        }
    }
    if (nodeToFind.nodeName === "P" && !isFirstParagraph && nodeToFind.textContent === "") {
        usedCharacters++;
    }
    return usedCharacters;
}
const letterRegex = /^[a-zA-Z]$/;
/**
 * Transform a keyboard event into a shortcut string that represent this event. The letters keys will be uppercased.
 *
 * @argument ev - The keyboard event to transform
 * @argument mode - Use either ev.key of ev.code to get the string shortcut
 *
 * @example
 * event : { ctrlKey: true, key: "a" } => "Ctrl+A"
 * event : { shift: true, alt: true, key: "Home" } => "Alt+Shift+Home"
 */
function keyboardEventToShortcutString(ev, mode = "key") {
    let keyDownString = "";
    if (!MODIFIER_KEYS.includes(ev.key)) {
        if (isCtrlKey(ev))
            keyDownString += "Ctrl+";
        if (ev.altKey)
            keyDownString += "Alt+";
        if (ev.shiftKey)
            keyDownString += "Shift+";
    }
    const key = mode === "key" ? ev.key : ev.code;
    keyDownString += letterRegex.test(key) ? key.toUpperCase() : key;
    return keyDownString;
}
function isMacOS() {
    return Boolean(macRegex.test(navigator.userAgent));
}
/**
 * @param {KeyboardEvent | MouseEvent} ev
 * @returns Returns true if the event was triggered with the "ctrl" modifier pressed.
 * On Mac, this is the "meta" or "command" key.
 */
function isCtrlKey(ev) {
    return isMacOS() || isIOS() ? ev.metaKey : ev.ctrlKey;
}
/**
 * @param {MouseEvent} ev - The mouse event.
 * @returns {boolean} Returns true if the event was triggered by a middle-click
 * or a Ctrl + Click (Cmd + Click on Mac).
 */
function isMiddleClickOrCtrlClick(ev) {
    return ev.button === 1 || (isCtrlKey(ev) && ev.button === 0);
}
function downloadFile(dataUrl, fileName) {
    const a = document.createElement("a");
    a.href = dataUrl;
    a.download = fileName;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}
/**
 * Detects if the current browser is Firefox
 */
function isBrowserFirefox() {
    return /Firefox/i.test(navigator.userAgent);
}
// Mobile detection
function maxTouchPoints() {
    return navigator.maxTouchPoints || 1;
}
function isAndroid() {
    return /Android/i.test(navigator.userAgent);
}
function isIOS() {
    return (/(iPad|iPhone|iPod)/i.test(navigator.userAgent) ||
        (navigator.platform === "MacIntel" && maxTouchPoints() > 1));
}
function isOtherMobileOS() {
    return /(webOS|BlackBerry|Windows Phone)/i.test(navigator.userAgent);
}
function isMobileOS() {
    return isAndroid() || isIOS() || isOtherMobileOS();
}

/**
 * This registry is intended to map a cell content (raw string) to
 * an instance of a cell.
 */
const chartRegistry = new Registry();

function generateMasterChartConfig(chartJsConfig) {
    return {
        ...chartJsConfig,
        data: {
            ...chartJsConfig.data,
            datasets: chartJsConfig.data.datasets
                .filter((ds) => !isTrendLineAxis(ds["xAxisID"]))
                .map((ds) => ({
                ...ds,
                pointRadius: 0,
                showLine: true,
            })),
        },
        options: {
            ...chartJsConfig.options,
            hover: { mode: null },
            plugins: {
                ...chartJsConfig.options.plugins,
                title: { display: false },
                legend: { display: false },
                tooltip: { enabled: false },
                chartShowValuesPlugin: undefined,
            },
            layout: {
                padding: {
                    ...chartJsConfig.options.layout?.padding,
                    top: 5,
                    bottom: 10,
                },
            },
            scales: {
                y: {
                    ...chartJsConfig.options.scales?.y,
                    display: false,
                },
                y1: {
                    ...chartJsConfig.options.scales?.y1,
                    display: false,
                },
                x: {
                    ...chartJsConfig.options.scales?.x,
                    title: undefined,
                    ticks: {
                        ...chartJsConfig.options.scales?.x?.ticks,
                        callback: function (value) {
                            return truncateLabel(chartJsConfig.options.scales?.x?.ticks?.callback?.call(this, value), 5);
                        },
                        padding: 0,
                        font: {
                            size: 9,
                        },
                    },
                },
            },
        },
    };
}

/**
 * Create a function used to create a Chart based on the definition
 */
function chartFactory(getters) {
    const builders = chartRegistry.getAll().sort((a, b) => a.sequence - b.sequence);
    function createChart(figureId, definition, sheetId) {
        const builder = builders.find((builder) => builder.match(definition.type));
        if (!builder) {
            throw new Error(`No builder for this chart: ${definition.type}`);
        }
        return builder.createChart(definition, sheetId, getters);
    }
    return createChart;
}
/**
 * Create a function used to create a Chart Runtime based on the chart class
 * instance
 */
function chartRuntimeFactory(getters) {
    const builders = chartRegistry.getAll().sort((a, b) => a.sequence - b.sequence);
    function createRuntimeChart(chart) {
        const builder = builders.find((builder) => builder.match(chart.type));
        if (!builder) {
            throw new Error("No runtime builder for this chart.");
        }
        const runtime = builder.getChartRuntime(chart, getters);
        const definition = chart.getDefinition();
        if ("chartJsConfig" in runtime && /line|combo|bar|scatter|waterfall/.test(definition.type)) {
            const chartJsConfig = runtime.chartJsConfig;
            runtime["masterChartConfig"] = generateMasterChartConfig(chartJsConfig);
        }
        return runtime;
    }
    return createRuntimeChart;
}
/**
 * Validate the chart definition given in arguments
 */
function validateChartDefinition(validator, definition) {
    const validators = chartRegistry.getAll().find((validator) => validator.match(definition.type));
    if (!validators) {
        throw new Error("Unknown chart type.");
    }
    return validators.validateChartDefinition(validator, definition);
}
/**
 * Get a new chart definition transformed with the executed command. This
 * functions will be called during operational transform process
 */
function transformDefinition(chartSheetId, definition, applyrange) {
    const transformation = chartRegistry.getAll().find((factory) => factory.match(definition.type));
    if (!transformation) {
        throw new Error("Unknown chart type.");
    }
    return transformation.transformDefinition(chartSheetId, definition, applyrange);
}

const GAUGE_PADDING_SIDE = 30;
const GAUGE_PADDING_TOP = 10;
const GAUGE_PADDING_BOTTOM = 20;
const GAUGE_LABELS_FONT_SIZE = 12;
const GAUGE_DEFAULT_VALUE_FONT_SIZE = 80;
const GAUGE_BACKGROUND_COLOR = "#F3F2F1";
const GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN = 6;
const GAUGE_TITLE_SECTION_HEIGHT = 25;
function drawGaugeChart(canvas, runtime, dimensions // TODO VSC: this doesn't look used, consider removing this param
) {
    const size = dimensions ?? getCanvasSize(canvas);
    const dpr = typeof globalThis.devicePixelRatio === "number" ? globalThis.devicePixelRatio : 1;
    canvas.width = size.width * dpr;
    canvas.height = size.height * dpr;
    const ctx = canvas.getContext("2d");
    if (!ctx) {
        throw new Error("Unable to retrieve 2D context from canvas");
    }
    ctx.scale(dpr, dpr);
    const config = getGaugeRenderingConfig({ ...size, x: 0, y: 0 }, runtime, ctx);
    drawBackground(ctx, config);
    drawGauge(ctx, config);
    drawInflectionValues(ctx, config);
    drawLabels(ctx, config);
    drawTitle(ctx, config);
}
function getCanvasSize(canvas) {
    if (canvas instanceof HTMLCanvasElement) {
        const rect = canvas.getBoundingClientRect();
        return { width: rect.width, height: rect.height };
    }
    return { width: canvas.width, height: canvas.height };
}
function drawGauge(ctx, config) {
    ctx.save();
    const gauge = config.gauge;
    const arcCenterX = gauge.rect.x + gauge.rect.width / 2;
    const arcCenterY = gauge.rect.y + gauge.rect.height;
    const arcRadius = gauge.rect.height - gauge.arcWidth / 2;
    if (arcRadius < 0) {
        return;
    }
    const gaugeAngle = gauge.percentage === 1 ? 0 : Math.PI * (1 + gauge.percentage);
    // Gauge background
    ctx.strokeStyle = GAUGE_BACKGROUND_COLOR;
    ctx.beginPath();
    ctx.lineWidth = gauge.arcWidth;
    ctx.arc(arcCenterX, arcCenterY, arcRadius, gaugeAngle, 0);
    ctx.stroke();
    // Gauge value
    ctx.strokeStyle = gauge.color;
    ctx.beginPath();
    ctx.arc(arcCenterX, arcCenterY, arcRadius, Math.PI, gaugeAngle);
    ctx.stroke();
    ctx.restore();
}
function drawBackground(ctx, config) {
    ctx.save();
    ctx.fillStyle = config.backgroundColor;
    ctx.fillRect(0, 0, config.width, config.height);
    ctx.restore();
}
function drawLabels(ctx, config) {
    for (const label of [config.minLabel, config.maxLabel, config.gaugeValue]) {
        ctx.save();
        ctx.textAlign = "center";
        ctx.fillStyle = label.color;
        ctx.font = `${label.fontSize}px ${DEFAULT_FONT}`;
        ctx.fillText(label.label, label.textPosition.x, label.textPosition.y);
        ctx.restore();
    }
}
function drawInflectionValues(ctx, config) {
    const { x: rectX, y: rectY, width, height } = config.gauge.rect;
    for (const inflectionValue of config.inflectionValues) {
        ctx.save();
        ctx.translate(rectX + width / 2 - 0.5, rectY + height - 0.5); // -0.5 for sharper lines. see RendererPlugin.drawBorders comment
        ctx.rotate(Math.PI / 2 - inflectionValue.rotation);
        ctx.lineWidth = 2;
        ctx.strokeStyle = chartMutedFontColor(config.backgroundColor) + "aa";
        ctx.beginPath();
        ctx.moveTo(0, -(height - config.gauge.arcWidth));
        ctx.lineTo(0, -height - 3);
        ctx.stroke();
        ctx.textAlign = "center";
        ctx.font = `${inflectionValue.fontSize}px ${DEFAULT_FONT}`;
        ctx.fillStyle = inflectionValue.color;
        const textY = -height - GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN - inflectionValue.offset;
        ctx.fillText(inflectionValue.label, 0, textY);
        ctx.restore();
    }
}
function drawTitle(ctx, config) {
    ctx.save();
    const title = config.title;
    ctx.font = getDefaultContextFont(title.fontSize, title.bold, title.italic);
    ctx.textBaseline = "middle";
    ctx.fillStyle = title.color;
    ctx.fillText(title.label, title.textPosition.x, title.textPosition.y);
    ctx.restore();
}
function getGaugeRenderingConfig(boundingRect, runtime, ctx) {
    const maxValue = runtime.maxValue;
    const minValue = runtime.minValue;
    const gaugeValue = getGaugeValue(runtime, "animated");
    const gaugeRect = getGaugeRect(boundingRect, runtime.title.text);
    const gaugeArcWidth = gaugeRect.width / 6;
    const gaugePercentage = gaugeValue
        ? (gaugeValue - minValue.value) / (maxValue.value - minValue.value)
        : 0;
    const gaugeValuePosition = {
        x: boundingRect.width / 2,
        y: gaugeRect.y + gaugeRect.height - gaugeRect.height / 12,
    };
    let gaugeValueFontSize = GAUGE_DEFAULT_VALUE_FONT_SIZE;
    // Scale down the font size if the gaugeRect is too small
    if (gaugeRect.height < 300) {
        gaugeValueFontSize = gaugeValueFontSize * (gaugeRect.height / 300);
    }
    // Scale down the font size if the text is too long
    const maxTextWidth = gaugeRect.width / 2;
    const gaugeLabel = runtime.gaugeValue?.label || "-";
    if (computeTextWidth(ctx, gaugeLabel, { fontSize: gaugeValueFontSize }, "px") > maxTextWidth) {
        gaugeValueFontSize = getFontSizeMatchingWidth(maxTextWidth, gaugeValueFontSize, (fontSize) => computeTextWidth(ctx, gaugeLabel, { fontSize }, "px"));
    }
    const minLabelPosition = {
        x: gaugeRect.x + gaugeArcWidth / 2,
        y: gaugeRect.y + gaugeRect.height + GAUGE_LABELS_FONT_SIZE,
    };
    const maxLabelPosition = {
        x: gaugeRect.x + gaugeRect.width - gaugeArcWidth / 2,
        y: gaugeRect.y + gaugeRect.height + GAUGE_LABELS_FONT_SIZE,
    };
    const textColor = chartMutedFontColor(runtime.background);
    const inflectionValues = getInflectionValues(runtime, gaugeRect, textColor, ctx);
    let x = 0, titleWidth = 0, titleHeight = 0;
    if (runtime.title.text) {
        ({ width: titleWidth, height: titleHeight } = computeTextDimension(ctx, runtime.title.text, { fontSize: CHART_TITLE_FONT_SIZE, ...runtime.title }, "px"));
    }
    switch (runtime.title.align) {
        case "right":
            x = boundingRect.width - titleWidth - CHART_PADDING;
            break;
        case "center":
            x = (boundingRect.width - titleWidth) / 2;
            break;
        case "left":
        default:
            x = CHART_PADDING;
            break;
    }
    return {
        width: boundingRect.width,
        height: boundingRect.height,
        title: {
            label: runtime.title.text ?? "",
            fontSize: runtime.title.fontSize ?? CHART_TITLE_FONT_SIZE,
            textPosition: {
                x,
                y: CHART_PADDING_TOP + titleHeight / 2,
            },
            color: runtime.title.color ?? textColor,
            bold: runtime.title.bold,
            italic: runtime.title.italic,
        },
        backgroundColor: runtime.background,
        gauge: {
            rect: gaugeRect,
            arcWidth: gaugeArcWidth,
            percentage: clip(gaugePercentage, 0, 1),
            color: getGaugeColor(runtime),
        },
        inflectionValues,
        gaugeValue: {
            label: gaugeLabel,
            textPosition: gaugeValuePosition,
            fontSize: gaugeValueFontSize,
            color: textColor,
        },
        minLabel: {
            label: runtime.minValue.label,
            textPosition: minLabelPosition,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
        },
        maxLabel: {
            label: runtime.maxValue.label,
            textPosition: maxLabelPosition,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
        },
    };
}
/**
 * Get the rectangle in which the gauge will be drawn, based on the bounding rectangle of the canvas and leaving
 * space for the title and labels.
 */
function getGaugeRect(boundingRect, title) {
    const titleHeight = title ? GAUGE_TITLE_SECTION_HEIGHT : 0;
    const drawHeight = boundingRect.height - GAUGE_PADDING_BOTTOM - titleHeight - GAUGE_PADDING_TOP;
    const drawWidth = boundingRect.width - GAUGE_PADDING_SIDE * 2;
    let gaugeWidth;
    let gaugeHeight;
    if (drawWidth > 2 * drawHeight) {
        gaugeWidth = 2 * drawHeight;
        gaugeHeight = drawHeight;
    }
    else {
        gaugeWidth = drawWidth;
        gaugeHeight = drawWidth / 2;
    }
    const gaugeX = GAUGE_PADDING_SIDE + (drawWidth - gaugeWidth) / 2;
    const gaugeY = titleHeight + GAUGE_PADDING_TOP + (drawHeight - gaugeHeight) / 2;
    return {
        x: gaugeX,
        y: gaugeY,
        width: gaugeWidth,
        height: gaugeHeight,
    };
}
/**
 * Get the infliction values of the gauge, and where to draw them (the angle from the center of the gauge at which they are drawn).
 *
 * Also compute an offset for the text so that it doesn't overlap with other text.
 */
function getInflectionValues(runtime, gaugeRect, textColor, ctx) {
    const maxValue = runtime.maxValue;
    const minValue = runtime.minValue;
    const gaugeCircleCenter = {
        x: gaugeRect.x + gaugeRect.width / 2,
        y: gaugeRect.y + gaugeRect.height,
    };
    const textStyle = { fontSize: GAUGE_LABELS_FONT_SIZE };
    const inflectionValues = [];
    const inflectionValuesTextRects = [];
    for (const inflectionValue of runtime.inflectionValues) {
        const percentage = (inflectionValue.value - minValue.value) / (maxValue.value - minValue.value);
        const labelWidth = computeTextWidth(ctx, inflectionValue.label, textStyle, "px");
        const angle = Math.PI - Math.PI * percentage;
        const textRect = getRectangleTangentToCircle(angle, // angle between X axis and the point where the rectangle is tangent to the circle
        gaugeRect.height + GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN, // radius of the gauge circle + margin below text
        gaugeCircleCenter.x, // center of the gauge circle
        gaugeCircleCenter.y, // center of the gauge circle
        labelWidth + 2, // width of the text + some margin
        GAUGE_LABELS_FONT_SIZE // height of the text
        );
        const offset = inflectionValuesTextRects.some((rect) => doRectanglesIntersect(rect, textRect))
            ? GAUGE_LABELS_FONT_SIZE
            : 0;
        inflectionValuesTextRects.push(textRect);
        inflectionValues.push({
            rotation: angle,
            label: inflectionValue.label,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
            offset,
        });
    }
    return inflectionValues;
}
function getGaugeColor(runtime) {
    const gaugeValue = getGaugeValue(runtime, "final");
    if (gaugeValue === undefined) {
        return GAUGE_BACKGROUND_COLOR;
    }
    for (let i = 0; i < runtime.inflectionValues.length; i++) {
        const inflectionValue = runtime.inflectionValues[i];
        if (inflectionValue.operator === "<" && gaugeValue < inflectionValue.value) {
            return runtime.colors[i];
        }
        else if (inflectionValue.operator === "<=" && gaugeValue <= inflectionValue.value) {
            return runtime.colors[i];
        }
    }
    return runtime.colors.at(-1);
}
function getSegmentsOfRectangle(rectangle) {
    return [
        { start: rectangle.topLeft, end: rectangle.topRight },
        { start: rectangle.topRight, end: rectangle.bottomRight },
        { start: rectangle.bottomRight, end: rectangle.bottomLeft },
        { start: rectangle.bottomLeft, end: rectangle.topLeft },
    ];
}
/**
 * Check if two segment intersect. The case where the segments are colinear (both segments on the same line)
 * is not handled.
 */
function doSegmentIntersect(segment1, segment2) {
    const A = segment1.start;
    const B = segment1.end;
    const C = segment2.start;
    const D = segment2.end;
    /**
     * Line segment intersection algorithm
     * https://bryceboe.com/2006/10/23/line-segment-intersection-algorithm/
     */
    function ccw(a, b, c) {
        return (c.y - a.y) * (b.x - a.x) > (b.y - a.y) * (c.x - a.x);
    }
    return ccw(A, C, D) !== ccw(B, C, D) && ccw(A, B, C) !== ccw(A, B, D);
}
function doRectanglesIntersect(rect1, rect2) {
    const segments1 = getSegmentsOfRectangle(rect1);
    const segments2 = getSegmentsOfRectangle(rect2);
    for (const segment1 of segments1) {
        for (const segment2 of segments2) {
            if (doSegmentIntersect(segment1, segment2)) {
                return true;
            }
        }
    }
    return false;
}
/**
 *  Get the rectangle that is tangent to a circle at a given angle.
 *
 * @param angle angle between X axis and the point where the rectangle is tangent to the circle
 */
function getRectangleTangentToCircle(angle, radius, circleCenterX, circleCenterY, rectWidth, rectHeight) {
    const cos = Math.cos(angle);
    const sin = Math.sin(angle);
    // x, y are the distance from the center of the circle to the point where the rectangle is tangent to the circle
    const x = cos * radius;
    const y = sin * radius;
    // x2, y2 are the distance from the point the rectangle is tangent to the circle to the bottom left corner of the rectangle
    const x2 = sin * (rectWidth / 2); // cos(angle + 90°) = sin(angle)
    const y2 = cos * (rectWidth / 2);
    const bottomRight = {
        x: x + x2 + circleCenterX,
        y: circleCenterY - (y - y2),
    };
    const bottomLeft = {
        x: x - x2 + circleCenterX,
        y: circleCenterY - (y + y2),
    };
    // Same as above but for the top corners of the rectangle (radius + rectangle height instead of radius)
    const xp = cos * (radius + rectHeight);
    const yp = sin * (radius + rectHeight);
    const topLeft = {
        x: xp - x2 + circleCenterX,
        y: circleCenterY - (yp + y2),
    };
    const topRight = {
        x: xp + x2 + circleCenterX,
        y: circleCenterY - (yp - y2),
    };
    return { bottomLeft, bottomRight, topRight, topLeft };
}
function getGaugeValue(runtime, mode) {
    return mode === "animated" && runtime.animationValue !== undefined
        ? runtime.animationValue
        : runtime.gaugeValue?.value;
}

const CHART_COMMON_OPTIONS = {
    // https://www.chartjs.org/docs/latest/general/responsive.html
    responsive: true, // will resize when its container is resized
    maintainAspectRatio: false, // doesn't maintain the aspect ratio (width/height =2 by default) so the user has the choice of the exact layout
    elements: {
        line: {
            fill: false, // do not fill the area under line charts
        },
        point: {
            hitRadius: 15, // increased hit radius to display point tooltip when hovering nearby
        },
    },
    animation: false,
    events: ["mousemove", "mouseout", "click", "touchstart", "touchmove", "mouseup"],
};
async function chartToImageUrl(runtime, figure, type) {
    const canvas = createRenderingSurface(figure.width, figure.height);
    let imageUrl;
    if ("chartJsConfig" in runtime) {
        const config = deepCopy$1(runtime.chartJsConfig);
        config.plugins = [backgroundColorChartJSPlugin];
        const chart = new globalThis.Chart(canvas, config);
        try {
            imageUrl = await canvasToObjectUrl(canvas);
        }
        finally {
            chart.destroy();
        }
    }
    // TODO: make a registry of chart types to their rendering functions
    else {
        if (!globalThis.OffscreenCanvas)
            throw new Error(`converting a ${type} chart to an image using OffscreenCanvas is not supported in this environment`);
        if (type === "scorecard") {
            const design = getScorecardConfiguration(figure, runtime);
            drawScoreChart(design, canvas);
            imageUrl = await canvasToObjectUrl(canvas);
        }
        else if (type === "gauge") {
            drawGaugeChart(canvas, runtime, figure);
            imageUrl = await canvasToObjectUrl(canvas);
        }
    }
    return imageUrl;
}
async function chartToImageFile(runtime, figure, type) {
    const canvas = createRenderingSurface(figure.width, figure.height);
    let chartBlob = null;
    if ("chartJsConfig" in runtime) {
        const config = deepCopy$1(runtime.chartJsConfig);
        config.plugins = [backgroundColorChartJSPlugin];
        const chart = new globalThis.Chart(canvas, config);
        try {
            chartBlob = await canvasToBlob(canvas);
        }
        finally {
            chart.destroy();
        }
    }
    else {
        if (!globalThis.OffscreenCanvas)
            throw new Error(`converting a ${type} chart to an image using OffscreenCanvas is not supported in this environment`);
        if (type === "scorecard") {
            const design = getScorecardConfiguration(figure, runtime);
            drawScoreChart(design, canvas);
            chartBlob = await canvasToBlob(canvas);
        }
        else if (type === "gauge") {
            drawGaugeChart(canvas, runtime, figure);
            chartBlob = await canvasToBlob(canvas);
        }
    }
    return chartBlob;
}
/**
 * Custom chart.js plugin to set the background color of the canvas
 * https://github.com/chartjs/Chart.js/blob/8fdf76f8f02d31684d34704341a5d9217e977491/docs/configuration/canvas-background.md
 */
const backgroundColorChartJSPlugin = {
    id: "customCanvasBackgroundColor",
    beforeDraw: (chart) => {
        const { ctx } = chart;
        ctx.save();
        ctx.globalCompositeOperation = "destination-over";
        ctx.fillStyle = "#ffffff";
        ctx.fillRect(0, 0, chart.width, chart.height);
        ctx.restore();
    },
};
function createRenderingSurface(width, height) {
    return new OffscreenCanvas(width, height);
}
async function canvasToBlob(canvas) {
    if ("convertToBlob" in canvas) {
        return canvas.convertToBlob({ type: "image/png" });
    }
    return new Promise((resolve) => canvas.toBlob(resolve, "image/png"));
}
async function canvasToObjectUrl(canvas) {
    const blob = await canvasToBlob(canvas);
    if (!blob) {
        return undefined;
    }
    if (!URL.createObjectURL)
        throw new Error("URL.createObjectURL is not supported in this environment");
    return URL.createObjectURL(blob);
}

/**
 * Convert a JS color hexadecimal to an excel compatible color.
 *
 * In Excel the color don't start with a '#' and the format is AARRGGBB instead of RRGGBBAA
 */
function toXlsxHexColor(color) {
    color = toHex(color).replace("#", "");
    // alpha channel goes first
    if (color.length === 8) {
        return color.slice(6) + color.slice(0, 6);
    }
    return color;
}

var ClipboardMIMEType;
(function (ClipboardMIMEType) {
    ClipboardMIMEType["PlainText"] = "text/plain";
    ClipboardMIMEType["Html"] = "text/html";
    ClipboardMIMEType["Image"] = "image";
})(ClipboardMIMEType || (ClipboardMIMEType = {}));

const availableConditionalFormatOperators = new Set([
    "containsText",
    "notContainsText",
    "isGreaterThan",
    "isGreaterOrEqualTo",
    "isLessThan",
    "isLessOrEqualTo",
    "isBetween",
    "isNotBetween",
    "beginsWithText",
    "endsWithText",
    "isNotEmpty",
    "isEmpty",
    "isNotEqual",
    "isEqual",
    "customFormula",
]);

const availableDataValidationOperators = new Set([
    "containsText",
    "notContainsText",
    "isEqualText",
    "isEmail",
    "isLink",
    "dateIs",
    "dateIsBefore",
    "dateIsOnOrBefore",
    "dateIsAfter",
    "dateIsOnOrAfter",
    "dateIsBetween",
    "dateIsNotBetween",
    "dateIsValid",
    "isEqual",
    "isNotEqual",
    "isGreaterThan",
    "isGreaterOrEqualTo",
    "isLessThan",
    "isLessOrEqualTo",
    "isBetween",
    "isNotBetween",
    "isBoolean",
    "isValueInList",
    "isValueInRange",
    "customFormula",
]);

const PREVIOUS_VALUE = "(previous)";
const NEXT_VALUE = "(next)";

const filterCriterions = [
    "containsText",
    "notContainsText",
    "isEqualText",
    "dateIs",
    "dateIsBefore",
    "dateIsOnOrBefore",
    "dateIsAfter",
    "dateIsOnOrAfter",
    "dateIsBetween",
    "dateIsNotBetween",
    "isEqual",
    "isNotEqual",
    "isGreaterThan",
    "isGreaterOrEqualTo",
    "isLessThan",
    "isLessOrEqualTo",
    "isBetween",
    "isNotBetween",
    "customFormula",
    "beginsWithText",
    "endsWithText",
    "isNotEmpty",
    "isEmpty",
];
new Set(filterCriterions);
const filterTextCriterionOperators = [
    "containsText",
    "notContainsText",
    "isEqualText",
    "isEmpty",
    "isNotEmpty",
    "beginsWithText",
    "endsWithText",
];
const filterNumberCriterionOperators = [
    "isEqual",
    "isNotEqual",
    "isGreaterThan",
    "isGreaterOrEqualTo",
    "isLessThan",
    "isLessOrEqualTo",
    "isBetween",
    "isNotBetween",
    "isEmpty",
    "isNotEmpty",
];
const filterDateCriterionOperators = [
    "dateIs",
    "dateIsBefore",
    "dateIsOnOrBefore",
    "dateIsAfter",
    "dateIsOnOrAfter",
    "dateIsBetween",
    "dateIsNotBetween",
    "isEmpty",
    "isNotEmpty",
];

const UNIT_LENGTH = {
    second: 1000,
    minute: 1000 * 60,
    hour: 1000 * 3600,
    day: 1000 * 3600 * 24,
    month: 1000 * 3600 * 24 * 30,
    year: 1000 * 3600 * 24 * 365,
};
const Milliseconds = {
    inSeconds: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.second);
    },
    inMinutes: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.minute);
    },
    inHours: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.hour);
    },
    inDays: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.day);
    },
    inMonths: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.month);
    },
    inYears: function (milliseconds) {
        return Math.floor(milliseconds / UNIT_LENGTH.year);
    },
};
/**
 * Regex to test if a format string is a date format that can be translated into a luxon time format
 */
const timeFormatLuxonCompatible = /^((d|dd|m|mm|yyyy|yy|hh|h|ss|a)(-|:|\s|\/))*(d|dd|m|mm|yyyy|yy|hh|h|ss|a)$/i;
/** Get the time options for the XAxis of ChartJS */
function getChartTimeOptions(labels, labelFormat, locale) {
    const luxonFormat = convertDateFormatForLuxon(labelFormat);
    const timeUnit = getBestTimeUnitForScale(labels, luxonFormat, locale);
    const displayFormats = {};
    if (timeUnit) {
        displayFormats[timeUnit] = luxonFormat;
    }
    return {
        parser: luxonFormat,
        displayFormats,
        unit: timeUnit ?? false,
        tooltipFormat: luxonFormat,
    };
}
/**
 * Convert the given date format into a format that moment.js understands.
 *
 * https://github.com/moment/luxon/blob/master/docs/formatting.md#table-of-tokens
 */
function convertDateFormatForLuxon(format) {
    // "m" before "h" === month, "m" after "h" === minute
    const indexH = format.indexOf("h");
    if (indexH >= 0) {
        format = format.slice(0, indexH).replace(/m/g, "M") + format.slice(indexH);
    }
    else {
        format = format.replace(/m/g, "M");
    }
    // If we have an "a", we should display hours as AM/PM (h), otherwise display 24 hours format (H)
    if (!format.includes("a")) {
        format = format.replace(/h/g, "H");
    }
    return format;
}
/** Get the minimum time unit that the format is able to display */
function getFormatMinDisplayUnit(format) {
    if (format.includes("s")) {
        return "second";
    }
    else if (format.includes("m")) {
        return "minute";
    }
    else if (format.includes("h") || format.includes("H")) {
        return "hour";
    }
    else if (format.includes("d")) {
        return "day";
    }
    else if (format.includes("M")) {
        return "month";
    }
    return "year";
}
/**
 * Returns the best time unit that should be used for the X axis of a chart in order to display all
 * the labels correctly.
 *
 * There is two conditions :
 *  - the format of the labels should be able to display the unit. For example if the format is "DD/MM/YYYY"
 *    it makes no sense to try to use minutes in the X axis
 *  - we want the "best fit" unit. For example if the labels span a period of several days, we want to use days
 *    as a unit, but if they span 200 days, we'd like to use months instead
 *
 */
function getBestTimeUnitForScale(labels, format, locale) {
    const labelDates = labels.map((label) => parseDateTime(label, locale)?.jsDate);
    if (labelDates.some((date) => date === undefined) || labels.length < 2) {
        return undefined;
    }
    const labelsTimestamps = labelDates.map((date) => date.getTime());
    const period = largeMax(labelsTimestamps) - largeMin(labelsTimestamps);
    const minUnit = getFormatMinDisplayUnit(format);
    if (UNIT_LENGTH.second >= UNIT_LENGTH[minUnit] && Milliseconds.inSeconds(period) < 180) {
        return "second";
    }
    else if (UNIT_LENGTH.minute >= UNIT_LENGTH[minUnit] && Milliseconds.inMinutes(period) < 180) {
        return "minute";
    }
    else if (UNIT_LENGTH.hour >= UNIT_LENGTH[minUnit] && Milliseconds.inHours(period) < 96) {
        return "hour";
    }
    else if (UNIT_LENGTH.day >= UNIT_LENGTH[minUnit] && Milliseconds.inDays(period) < 90) {
        return "day";
    }
    else if (UNIT_LENGTH.month >= UNIT_LENGTH[minUnit] && Milliseconds.inMonths(period) < 36) {
        return "month";
    }
    return "year";
}

function getBarChartData(definition, dataSets, labelRange, getters) {
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = labelValues.formattedValues;
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterInvalidDataPoints(labels, dataSetsValues));
    if (definition.aggregated) {
        ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    }
    const leftAxisFormat = getChartDatasetFormat(getters, dataSets, "left");
    const rightAxisFormat = getChartDatasetFormat(getters, dataSets, "right");
    const axisFormats = definition.horizontal
        ? { x: leftAxisFormat || rightAxisFormat }
        : { y: leftAxisFormat, y1: rightAxisFormat };
    const trendDataSetsValues = [];
    for (const index in dataSetsValues) {
        const { data } = dataSetsValues[index];
        const trend = definition.dataSets?.[index].trend;
        if (!trend?.display || definition.horizontal) {
            trendDataSetsValues.push(undefined);
            continue;
        }
        const trendDataset = getTrendDatasetForBarChart(trend, data);
        trendDataSetsValues.push(trendDataset);
    }
    return {
        dataSetsValues,
        trendDataSetsValues,
        axisFormats,
        labels,
        locale: getters.getLocale(),
        topPadding: getTopPaddingForDashboard(definition, getters),
    };
}
function getPyramidChartData(definition, dataSets, labelRange, getters) {
    const barChartData = getBarChartData(definition, dataSets.slice(0, 2), labelRange, getters);
    const barDataset = barChartData.dataSetsValues.filter((ds) => !ds.hidden);
    const pyramidDatasetValues = [];
    if (barDataset[0]) {
        const pyramidData = barDataset[0].data.map((value) => (value > 0 ? value : 0));
        pyramidDatasetValues.push({ ...barDataset[0], data: pyramidData });
    }
    if (barDataset[1]) {
        const pyramidData = barDataset[1].data.map((value) => (value > 0 ? -value : 0));
        pyramidDatasetValues.push({ ...barDataset[1], data: pyramidData });
    }
    return {
        ...barChartData,
        dataSetsValues: pyramidDatasetValues,
    };
}
function getLineChartData(definition, dataSets, labelRange, getters) {
    const axisType = getChartAxisType(definition, dataSets, labelRange, getters);
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = axisType === "linear" ? labelValues.values : labelValues.formattedValues;
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    const removeFirstLabel = shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false);
    if (removeFirstLabel) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterInvalidDataPoints(labels, dataSetsValues));
    if (axisType === "time") {
        ({ labels, dataSetsValues } = fixEmptyLabelsForDateCharts(labels, dataSetsValues));
    }
    if (definition.aggregated) {
        ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    }
    if (definition.cumulative) {
        dataSetsValues = makeDatasetsCumulative(dataSetsValues, "asc");
    }
    const leftAxisFormat = getChartDatasetFormat(getters, dataSets, "left");
    const rightAxisFormat = getChartDatasetFormat(getters, dataSets, "right");
    const labelsFormat = getChartLabelFormat(getters, labelRange, removeFirstLabel);
    const axisFormats = { y: leftAxisFormat, y1: rightAxisFormat, x: labelsFormat };
    const trendDataSetsValues = [];
    for (const index in dataSetsValues) {
        const trend = definition.dataSets?.[index].trend;
        if (!trend?.display) {
            trendDataSetsValues.push(undefined);
            continue;
        }
        const { data } = dataSetsValues[index];
        trendDataSetsValues.push(getTrendDatasetForLineChart(trend, data, labels, axisType, getters.getLocale()));
    }
    return {
        dataSetsValues,
        axisFormats,
        labels,
        locale: getters.getLocale(),
        trendDataSetsValues,
        axisType,
        topPadding: getTopPaddingForDashboard(definition, getters),
    };
}
function getPieChartData(definition, dataSets, labelRange, getters) {
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = labelValues.formattedValues;
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterInvalidDataPoints(labels, dataSetsValues));
    if (definition.aggregated) {
        ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    }
    ({ dataSetsValues, labels } = keepOnlyPositiveValues(labels, dataSetsValues));
    const dataSetFormat = getChartDatasetFormat(getters, dataSets, "left");
    return {
        dataSetsValues,
        axisFormats: { y: dataSetFormat },
        labels,
        locale: getters.getLocale(),
        topPadding: getTopPaddingForDashboard(definition, getters),
    };
}
function getRadarChartData(definition, dataSets, labelRange, getters) {
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = labelValues.formattedValues;
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterInvalidDataPoints(labels, dataSetsValues));
    if (definition.aggregated) {
        ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    }
    const dataSetFormat = getChartDatasetFormat(getters, dataSets, "left") ||
        getChartDatasetFormat(getters, dataSets, "right");
    const axisFormats = { r: dataSetFormat };
    return {
        dataSetsValues,
        axisFormats,
        labels,
        locale: getters.getLocale(),
    };
}
function getGeoChartData(definition, fullDataSets, labelRange, getters) {
    const dataSets = fullDataSets.slice(0, 1);
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = labelValues.formattedValues;
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    const format = getChartDatasetFormat(getters, dataSets, "left") ||
        getChartDatasetFormat(getters, dataSets, "right");
    return {
        dataSetsValues,
        axisFormats: { y: format },
        labels,
        locale: getters.getLocale(),
        availableRegions: getters.getGeoChartAvailableRegions(),
        geoFeatureNameToId: getters.geoFeatureNameToId,
        getGeoJsonFeatures: getters.getGeoJsonFeatures,
    };
}
function getFunnelChartData(definition, dataSets, labelRange, getters) {
    const labelValues = getChartLabelValues(getters, dataSets, labelRange);
    let labels = labelValues.formattedValues;
    let dataSetsValues = getChartDatasetValues(getters, dataSets);
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterInvalidDataPoints(labels, dataSetsValues));
    if (definition.aggregated) {
        ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
    }
    if (definition.cumulative) {
        dataSetsValues = makeDatasetsCumulative(dataSetsValues, "desc");
    }
    const format = getChartDatasetFormat(getters, dataSets, "left") ||
        getChartDatasetFormat(getters, dataSets, "right");
    return {
        dataSetsValues,
        axisFormats: { x: format },
        labels,
        locale: getters.getLocale(),
    };
}
function getHierarchalChartData(definition, dataSets, labelRange, getters) {
    // In hierarchical charts, labels are the leaf values (numbers), and the hierarchy is defined in the dataSets (strings)
    let labels = getChartLabelValues(getters, dataSets, labelRange).values;
    let dataSetsValues = getHierarchicalDatasetValues(getters, dataSets);
    const removeFirstLabel = shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false);
    if (removeFirstLabel) {
        labels.shift();
    }
    ({ labels, dataSetsValues } = filterValuesWithDifferentSigns(labels, dataSetsValues));
    ({ labels, dataSetsValues } = filterInvalidHierarchicalPoints(labels, dataSetsValues));
    return {
        dataSetsValues,
        axisFormats: { y: getChartLabelFormat(getters, labelRange, removeFirstLabel) },
        labels,
        locale: getters.getLocale(),
    };
}
function getTrendDatasetForBarChart(config, data) {
    const filteredValues = [];
    const filteredLabels = [];
    const labels = [];
    for (let i = 0; i < data.length; i++) {
        if (typeof data[i] === "number") {
            filteredValues.push(data[i]);
            filteredLabels.push(i + 1);
        }
        labels.push(i + 1);
    }
    const newLabels = range$1(0.5, labels.length + 0.55, 0.2);
    const newValues = interpolateData(config, filteredValues, filteredLabels, newLabels);
    return newValues.length ? newValues : undefined;
}
function getTrendDatasetForLineChart(config, data, labels, axisType, locale) {
    const filteredValues = [];
    const filteredLabels = [];
    const trendLabels = [];
    const datasetLength = data.length;
    if (datasetLength < 2) {
        return;
    }
    switch (axisType) {
        case "category":
            for (let i = 0; i < datasetLength; i++) {
                if (typeof data[i] === "number") {
                    filteredValues.push(data[i]);
                    filteredLabels.push(i + 1);
                }
                trendLabels.push(i + 1);
            }
            break;
        case "linear":
            for (let i = 0; i < data.length; i++) {
                const label = Number(labels[i]);
                if (isNaN(label)) {
                    continue;
                }
                if (typeof data[i] === "number") {
                    filteredValues.push(data[i]);
                    filteredLabels.push(label);
                }
                trendLabels.push(label);
            }
            break;
        case "time":
            for (let i = 0; i < data.length; i++) {
                const date = toNumber({ value: labels[i] }, locale);
                if (data[i] !== null) {
                    filteredValues.push(data[i]);
                    filteredLabels.push(date);
                }
                trendLabels.push(date);
            }
            break;
    }
    const xmin = Math.min(...trendLabels);
    const xmax = Math.max(...trendLabels);
    if (xmax === xmin) {
        return;
    }
    const numberOfStep = 5 * trendLabels.length;
    const step = (xmax - xmin) / numberOfStep;
    const trendNewLabels = range$1(xmin, xmax + step / 2, step);
    const trendValues = interpolateData(config, filteredValues, filteredLabels, trendNewLabels);
    if (!trendValues.length) {
        return;
    }
    return trendValues;
}
function interpolateData(config, values, labels, newLabels) {
    if (values.length < 2 || labels.length < 2 || newLabels.length === 0) {
        return [];
    }
    const { normalizedLabels, normalizedNewLabels } = normalizeLabels(labels, newLabels, config);
    try {
        switch (config.type) {
            case "polynomial": {
                const order = config.order;
                if (!order) {
                    return newLabels.map((x) => ({ x, y: NaN }));
                }
                if (order === 1) {
                    return predictLinearValues([values], [normalizedLabels], [normalizedNewLabels], true)[0].map((y, i) => ({ x: newLabels[i], y }));
                }
                const coeffs = polynomialRegression(values, normalizedLabels, order, true).flat();
                return normalizedNewLabels.map((x, i) => ({
                    x: newLabels[i],
                    y: evaluatePolynomial(coeffs, x, order),
                }));
            }
            case "exponential": {
                const positiveLogValues = [];
                const filteredLabels = [];
                for (let i = 0; i < values.length; i++) {
                    if (values[i] > 0) {
                        positiveLogValues.push(Math.log(values[i]));
                        filteredLabels.push(normalizedLabels[i]);
                    }
                }
                if (!filteredLabels.length) {
                    return newLabels.map((x) => ({ x, y: NaN }));
                }
                return expM(predictLinearValues([positiveLogValues], [filteredLabels], [normalizedNewLabels], true))[0].map((y, i) => ({ x: newLabels[i], y }));
            }
            case "logarithmic": {
                return predictLinearValues([values], logM([normalizedLabels]), logM([normalizedNewLabels]), true)[0].map((y, i) => ({ x: newLabels[i], y }));
            }
            case "trailingMovingAverage": {
                return getMovingAverageValues(values, labels, config.window);
            }
            default:
                return newLabels.map((x) => ({ x, y: NaN }));
        }
    }
    catch (e) {
        return newLabels.map((x) => ({ x, y: NaN }));
    }
}
function normalizeLabels(labels, newLabels, config) {
    let normalizedLabels = [];
    let normalizedNewLabels = [];
    if (config.type === "logarithmic") {
        // Logarithmic trends in charts are used to visualize proportional growth or
        // relative changes. Therefore, we change the normalization technique for
        // logarithmic trend lines for a better fit. The method used here is Max Absolute
        // Scaling. This Technique is ideal for data spanning several orders of magnitude,
        // as it balances differences between small and large values by compressing larger
        // values while preserving proportionality and ensuring all values are scaled relative
        // to the largest magnitude.
        const labelMax = Math.max(...labels.map(Math.abs));
        normalizedLabels = labels.map((l) => l / labelMax);
        normalizedNewLabels = newLabels.map((l) => l / labelMax);
    }
    else {
        const labelMax = Math.max(...labels);
        const labelMin = Math.min(...labels);
        const labelRange = labelMax - labelMin;
        normalizedLabels = labels.map((l) => (l - labelMax) / labelRange);
        normalizedNewLabels = newLabels.map((l) => (l - labelMax) / labelRange);
    }
    return { normalizedLabels, normalizedNewLabels };
}
function getChartAxisType(definition, dataSets, labelRange, getters) {
    if (isDateChart(definition, dataSets, labelRange, getters) && isLuxonTimeAdapterInstalled()) {
        return "time";
    }
    if (isLinearChart(definition, dataSets, labelRange, getters)) {
        return "linear";
    }
    return "category";
}
function isDateChart(definition, dataSets, labelRange, getters) {
    return !definition.labelsAsText && canBeDateChart(definition, dataSets, labelRange, getters);
}
function isLinearChart(definition, dataSets, labelRange, getters) {
    return !definition.labelsAsText && canBeLinearChart(definition, dataSets, labelRange, getters);
}
function canChartParseLabels(definition, dataSets, labelRange, getters) {
    return (canBeDateChart(definition, dataSets, labelRange, getters) ||
        canBeLinearChart(definition, dataSets, labelRange, getters));
}
function canBeDateChart(definition, dataSets, labelRange, getters) {
    if (!labelRange || !canBeLinearChart(definition, dataSets, labelRange, getters)) {
        return false;
    }
    const removeFirstLabel = shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false);
    const labelFormat = getChartLabelFormat(getters, labelRange, removeFirstLabel);
    return Boolean(labelFormat && timeFormatLuxonCompatible.test(labelFormat));
}
function canBeLinearChart(definition, dataSets, labelRange, getters) {
    if (!labelRange) {
        return false;
    }
    const labels = getters.getRangeValues(labelRange);
    if (shouldRemoveFirstLabel(labelRange, dataSets[0], definition.dataSetsHaveTitle || false)) {
        labels.shift();
    }
    if (labels.some((label) => isNaN(Number(label)) && label)) {
        return false;
    }
    if (labels.every((label) => !label)) {
        return false;
    }
    return true;
}
let missingTimeAdapterAlreadyWarned = false;
function isLuxonTimeAdapterInstalled() {
    if (!window.Chart) {
        return false;
    }
    const adapter = new window.Chart._adapters._date({});
    // @ts-ignore
    const isInstalled = adapter._id === "luxon";
    if (!isInstalled && !missingTimeAdapterAlreadyWarned) {
        missingTimeAdapterAlreadyWarned = true;
        console.warn("'chartjs-adapter-luxon' time adapter is not installed. Time scale axes are disabled.");
    }
    return isInstalled;
}
function keepOnlyPositiveValues(labels, datasets) {
    const numberOfDataPoints = Math.max(labels.length, ...datasets.map((dataset) => dataset.data?.length || 0));
    const filteredIndexes = range$1(0, numberOfDataPoints).filter((i) => datasets.some((ds) => typeof ds.data[i] === "number" && ds.data[i] > 0));
    return {
        labels: filteredIndexes.map((i) => labels[i] || ""),
        dataSetsValues: datasets.map((ds) => ({
            ...ds,
            data: filteredIndexes.map((i) => typeof ds.data[i] === "number" && ds.data[i] > 0 ? ds.data[i] : null),
        })),
    };
}
function fixEmptyLabelsForDateCharts(labels, dataSetsValues) {
    if (labels.length === 0 || labels.every((label) => !label)) {
        return { labels, dataSetsValues };
    }
    const newLabels = [...labels];
    const newDatasets = deepCopy$1(dataSetsValues);
    for (let i = 0; i < newLabels.length; i++) {
        if (!newLabels[i]) {
            newLabels[i] = findNextDefinedValue(newLabels, i);
            for (const ds of newDatasets) {
                ds.data[i] = undefined;
            }
        }
    }
    return { labels: newLabels, dataSetsValues: newDatasets };
}
/**
 * Get the data from a dataSet
 */
function getData(getters, ds) {
    if (ds.dataRange) {
        const labelCellZone = ds.labelCell ? [ds.labelCell.zone] : [];
        const dataZone = recomputeZones([ds.dataRange.zone], labelCellZone)[0];
        if (dataZone === undefined) {
            return [];
        }
        const dataRange = getters.getRangeFromZone(ds.dataRange.sheetId, dataZone);
        return getters.getRangeValues(dataRange).map((value) => (value === "" ? undefined : value));
    }
    return [];
}
/**
 * Filter the data points that:
 * - have neither a label nor a value
 * - have no label and a non-numeric value
 */
function filterInvalidDataPoints(labels, datasets) {
    const numberOfDataPoints = Math.max(labels.length, ...datasets.map((dataset) => dataset.data?.length || 0));
    const dataPointsIndexes = range$1(0, numberOfDataPoints).filter((dataPointIndex) => {
        const label = labels[dataPointIndex];
        const values = datasets.map((dataset) => dataset.data?.[dataPointIndex]);
        return label || values.some((value) => typeof value === "number");
    });
    return {
        labels: dataPointsIndexes.map((i) => labels[i] || ""),
        dataSetsValues: datasets.map((dataset) => ({
            ...dataset,
            data: dataPointsIndexes.map((i) => typeof dataset.data[i] === "number" ? dataset.data[i] : null),
        })),
    };
}
/**
 * Filter the data points that have either no value, a negative value, no root group or null group values in the middle
 */
function filterInvalidHierarchicalPoints(values, hierarchy) {
    const numberOfDataPoints = Math.max(values.length, ...hierarchy.map((dataset) => dataset.data?.length || 0));
    const isEmpty = (value) => value === undefined || value === null || value === "";
    const dataPointsIndexes = range$1(0, numberOfDataPoints).filter((dataPointIndex) => {
        const groups = hierarchy.map((dataset) => dataset.data?.[dataPointIndex]);
        if (isEmpty(groups[0])) {
            return false;
        }
        // Filter points with empty group in the middle
        let hasFoundEmptyGroup = false;
        for (const group of groups) {
            hasFoundEmptyGroup ||= isEmpty(group);
            if (hasFoundEmptyGroup && !isEmpty(group)) {
                return false;
            }
        }
        return values[dataPointIndex] && !isNaN(Number(values[dataPointIndex]));
    });
    return {
        labels: dataPointsIndexes.map((i) => values[i]),
        dataSetsValues: hierarchy.map((dataset) => ({
            ...dataset,
            data: dataPointsIndexes.map((i) => dataset.data[i]),
        })),
    };
}
/**
 * If the values are a mix of positive and negative values, keep only the positive ones
 */
function filterValuesWithDifferentSigns(values, hierarchy) {
    const positivePointsIndexes = [];
    const negativePointsIndexes = [];
    for (let i = 0; i < values.length; i++) {
        if (Number(values[i]) <= 0) {
            negativePointsIndexes.push(i);
        }
        else if (Number(values[i]) > 0) {
            positivePointsIndexes.push(i);
        }
    }
    const indexesToKeep = positivePointsIndexes.length
        ? positivePointsIndexes
        : negativePointsIndexes;
    return {
        labels: indexesToKeep.map((i) => values[i]),
        dataSetsValues: hierarchy.map((dataset) => ({
            ...dataset,
            data: indexesToKeep.map((i) => dataset.data[i]),
        })),
    };
}
/**
 * Aggregates data based on labels
 */
function aggregateDataForLabels(labels, datasets) {
    const parseNumber = (value) => (typeof value === "number" ? value : 0);
    const labelSet = new Set(labels);
    const labelMap = {};
    labelSet.forEach((label) => {
        labelMap[label] = new Array(datasets.length).fill(0);
    });
    for (const indexOfLabel of range$1(0, labels.length)) {
        const label = labels[indexOfLabel];
        for (const indexOfDataset of range$1(0, datasets.length)) {
            labelMap[label][indexOfDataset] += parseNumber(datasets[indexOfDataset].data[indexOfLabel]);
        }
    }
    return {
        labels: Array.from(labelSet),
        dataSetsValues: datasets.map((dataset, indexOfDataset) => ({
            ...dataset,
            data: Array.from(labelSet).map((label) => labelMap[label][indexOfDataset]),
        })),
    };
}
function getChartLabelFormat(getters, range, shouldRemoveFirstLabel) {
    if (!range)
        return undefined;
    const { sheetId, zone } = range;
    const formats = positions(zone).map((position) => getters.getEvaluatedCell({ sheetId, ...position }).format);
    if (shouldRemoveFirstLabel) {
        formats.shift();
    }
    return formats.find((format) => format !== undefined);
}
function getChartLabelValues(getters, dataSets, labelRange) {
    let labels = { values: [], formattedValues: [] };
    if (labelRange) {
        const { left } = labelRange.zone;
        if (!labelRange.invalidXc &&
            !labelRange.invalidSheetName &&
            !getters.isColHidden(labelRange.sheetId, left)) {
            labels = {
                formattedValues: getters.getRangeFormattedValues(labelRange),
                values: getters.getRangeValues(labelRange).map((val) => String(val ?? "")),
            };
        }
        else if (dataSets[0]) {
            const ranges = getData(getters, dataSets[0]);
            labels = {
                formattedValues: range$1(0, ranges.length).map((r) => r.toString()),
                values: labels.formattedValues,
            };
        }
    }
    else if (dataSets.length === 1) {
        const dataLength = getData(getters, dataSets[0]).length;
        for (let i = 0; i < dataLength; i++) {
            labels.formattedValues.push("");
            labels.values.push("");
        }
    }
    else {
        if (dataSets[0]) {
            const ranges = getData(getters, dataSets[0]);
            labels = {
                formattedValues: range$1(0, ranges.length).map((r) => r.toString()),
                values: labels.formattedValues,
            };
        }
    }
    return labels;
}
/**
 * Get the format to apply to the the dataset values. This format is defined as the first format
 * found in the dataset ranges that isn't a date format.
 */
function getChartDatasetFormat(getters, allDataSets, axis) {
    const dataSets = allDataSets.filter((ds) => (axis === "right") === !!ds.rightYAxis);
    for (const ds of dataSets) {
        const formatsInDataset = getters.getRangeFormats(ds.dataRange);
        const format = formatsInDataset.find((f) => f !== undefined && !isDateTimeFormat(f));
        if (format)
            ret