import csv
import logging

from io import StringIO
from collections import defaultdict

FP_LOOKUP = {
    ("cy", "VAT_S_IN_CY_0"): "fiscal_position_cy_national,fiscal_position_cy_person_private",
    ("cy", "VAT_P_IN_CY_0"): "fiscal_position_cy_national,fiscal_position_cy_person_private",
    ("cy", "RC_S_IN_CY"): "fiscal_position_cy_national,fiscal_position_cy_person_private",
    ("cy", "RC_P_IN_CY"): "fiscal_position_cy_national,fiscal_position_cy_person_private",
    ("cy", "VAT_P_IN_EU_19_G_ES"): "fiscal_position_cy_eu",
    ("cy", "VAT_P_IN_EU_19_S_ESSS"): "fiscal_position_cy_eu",
    ("cy", "VAT_S_IN_EU_19_S_ESSP"): "fiscal_position_cy_eu",
    ("lu", "lu_2015_tax_AB-ECP-0"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-14"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-17"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-16"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-13"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-7"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-3"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_AB-ECP-8"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-0"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-14"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-17"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-16"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-13"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-7"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-3"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_FB-ECP-8"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-0"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-14"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-17"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-16"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-13"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-7"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-3"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_IB-ECP-8"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2015_tax_V-ART-43_60b"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2015_tax_V-ART-44_56q"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2011_tax_VB-EC-Tab"): "account_fiscal_position_template_LU_EC",
    ("lu", "lu_2011_tax_VB-IC-Tab"): "account_fiscal_position_template_LU_IC",
    ("lu", "lu_2011_tax_VB-PA-Tab"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2015_tax_VB-TR-0"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2011_tax_VP-IC-EX"): "account_fiscal_position_template_LU_IC",
    ("lu", "lu_2015_tax_SANS"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2015_tax_SANS_sale"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2015_tax_ATN_sale"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lu", "lu_2015_tax_ATN_sale_16"): "account_fiscal_position_template_LU_LU,account_fiscal_position_template_private_LU_IC",
    ("lt", "account_tax_template_sales_0_vat5"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_sales_0_vat15"): "account_fiscal_position_template_out_eu",
    ("lt", "account_tax_template_sales_5"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_sales_reversed_21"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_0_vat5"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_0_vat14"): "account_fiscal_position_template_out_eu",
    ("lt", "account_tax_template_purchase_0_vat42"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_0_vat100"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_5"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_not_deductible_9"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_9"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_not_deductible_21"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_reversed_21"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("lt", "account_tax_template_purchase_assumed_21_vat16"): "account_fiscal_position_template_eu",
    ("lt", "account_tax_template_purchase_assumed_21_vat20"): "account_fiscal_position_template_lt,account_fiscal_position_template_b2c_eu",
    ("cm", "tva_exempt_0"): "fiscal_position_template_1",
    ("cm", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("cm_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cm_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("hr_kuna", "rrif_pdv_10"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_avans_25"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_avans_10"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_avans_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_nezar_isp_25"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_nezar_isp_10"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_nezar_isp_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_nepod_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_osl_medpri_0"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_pdv_osl_tuz_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pdv_osl_ost_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pp_10"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pp_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pp_avans_25"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pp_avans_0"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_pp_uvoz_25"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_pp_uvoz_10"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_pp_ino_25"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_pp_ino_10"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_pp_uvoz_samopdv_25"): "account_fiscal_position_template_rrif_4",
    ("hr_kuna", "rrif_ppdnp1_3070_1"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_ppdnp1_7030_1"): "account_fiscal_position_template_rrif_domairpartneri0",
    ("hr_kuna", "rrif_ppdnp1_3070_1_r2"): "account_fiscal_position_template_rrif_2",
    ("hr_kuna", "rrif_ppdnp1_7030_1_r2"): "account_fiscal_position_template_rrif_2",
    ("se", "purchase_construction_services_tax_25_EC"): "fp_euro_b2b",
    ("se", "purchase_construction_services_tax_12_EC"): "fp_euro_b2b",
    ("se", "purchase_construction_services_tax_6_EC"): "fp_euro_b2b",
    ("se", "triangular_tax_25_goods"): "fp_euro_b2b",
    ("se", "triangular_tax_12_goods"): "fp_euro_b2b",
    ("se", "triangular_tax_6_goods"): "fp_euro_b2b",
    ("se", "triangular_tax_0_goods"): "fp_euro_b2b",
    ("at", "account_tax_template_sales_rev_charge_0_code021"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_rev_charge_0_code021_1a"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_rev_charge_0_code021_1b"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_rev_charge_0_code021_1c"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_rev_charge_0_code021_1d"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_rev_charge_0_code021_1e"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_non_eu_0_code012"): "fiscal_position_template_non_eu",
    ("at", "account_tax_template_sales_non_eu_0_code015"): "fiscal_position_template_non_eu",
    ("at", "account_tax_template_sales_eu_0_code018"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_0_code019"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_0_code016"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_0_code020"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_13_code006"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_19_code037"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_add10_code052"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_self_20_code022"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_self_10_code029"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_self_19_code037"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_self_add10_code052"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_sales_self_add7_code007"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_tax_invoiced_accepted_code056"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_eu_0_code071"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_eu_13"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_rev_charge_1a"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_rev_charge_1b"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_rev_charge_1c"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_rev_charge_1d"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_rev_charge_1e"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_eu_xx_code076"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_eu_xx_code077"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_13_code060"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_12_code060"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_xx_code061"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_xx_code083"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_correct_code063"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_correct_code067"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_correct_code090"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_cars_buildings_code027"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_cars_buildings_code028"): "fiscal_position_template_national_w_uid,fiscal_position_template_national",
    ("at", "account_tax_template_purchase_eu_0_vst_071"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_eu_xx_vst_076"): "fiscal_position_template_eu",
    ("at", "account_tax_template_purchase_eu_xx_vst_077"): "fiscal_position_template_eu",
    ("au", "au_tax_witheld"): "l10n_au_domestic_fiscal_position",
    ("au", "au_tax_sale_exempt"): "l10n_au_domestic_fiscal_position",
    ("au", "au_tax_sale_input"): "l10n_au_domestic_fiscal_position",
    ("au", "au_tax_sale_adj"): "l10n_au_domestic_fiscal_position",
    ("au", "au_tax_purchase_taxable_import_service"): "fiscal_position_os_partner",
    ("au", "au_tax_purchase_taxable_import_service_tpar"): "fiscal_position_tpar_partner",
    ("au", "au_tax_purchase_taxable_import_service_tpar_no_abn"): "fiscal_position_tpar_partner_no_abn",
    ("au", "au_tax_dgst"): "l10n_au_domestic_fiscal_position",
    ("bf", "tva_sale_self_18"): "fiscal_position_template_1",
    ("bf", "tva_exempt_0"): "fiscal_position_template_1",
    ("bf", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("bf_syscebnl", "syscebnl_tva_sale_self_18"): "syscebnl_fiscal_position_template_1",
    ("bf_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("bf_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("pe", "sale_tax_exo"): "local_peru",
    ("pe", "sale_tax_ina"): "local_peru",
    ("pe", "sale_tax_gra"): "local_peru",
    ("pe", "sale_tax_ics_0"): "local_peru",
    ("pe", "purchase_tax_igv_18"): "local_peru",
    ("pe", "purchase_tax_igv_18g_ng"): "local_peru",
    ("pe", "purchase_tax_igv_18_ng"): "local_peru",
    ("pe", "purchase_tax_exp_0"): "exportation",
    ("pe", "purchase_tax_exo"): "local_peru",
    ("pe", "purchase_tax_ina"): "local_peru",
    ("pe", "purchase_tax_gra"): "local_peru",
    ("pe", "tax_free_subtract_base"): "local_peru",
    ("pe", "tax_free_igv_18"): "local_peru",
    ("pe", "tax_free_igv_18_expense"): "local_peru",
    ("pe", "tax_free_group"): "local_peru",
    ("dz", "l10n_dz_vat_sale_19_other_services_art21"): "fiscal_position_template_national",
    ("dz", "l10n_dz_vat_sale_0_other_services_art21"): "fiscal_position_template_national",
    ("nl", "btw_overig_buy"): "l10n_nl_domestic_fiscal_position,fiscal_position_template_eu_private",
    ("nl", "btw_overig_buy_d"): "l10n_nl_domestic_fiscal_position,fiscal_position_template_eu_private",
    ("nl", "btw_X0_ABC_levering"): "fiscal_position_template_eu",
    ("nl", "btw_E_overig"): "fiscal_position_template_non_eu",
    ("nl", "btw_X3"): "fiscal_position_template_non_eu",
    ("nl", "btw_E1_d_9"): "fiscal_position_template_non_eu",
    ("nl", "btw_E2_d"): "fiscal_position_template_non_eu",
    ("gq_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gq_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gq", "tva_exempt_0"): "fiscal_position_template_1",
    ("gq", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("lv", "VAT_S_S_0_LV"): "fiscal_position_lv_domestic,fiscal_position_lv_eu_private",
    ("lv", "VAT_S_EU_G_T_0_LV"): "fiscal_position_lv_eu",
    ("lv", "VAT_RC_21_LV"): "fiscal_position_lv_domestic,fiscal_position_lv_eu_private",
    ("be", "attn_VAT-OUT-00-EU-T"): "fiscal_position_template_3",
    ("be", "attn_TVA-21-inclus-dans-prix"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V81-00-CC"): "fiscal_position_template_4",
    ("be", "attn_VAT-IN-V82-00-CC"): "fiscal_position_template_4",
    ("be", "attn_VAT-IN-V83-00-CC"): "fiscal_position_template_4",
    ("be", "attn_VAT-IN-V82-CAR-EXC"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V82-D35"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V82-D85"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V82-21-EU-G-D50"): "fiscal_position_template_3",
    ("be", "attn_VAT-IN-V82-21-EU-G-D35"): "fiscal_position_template_3",
    ("be", "attn_VAT-IN-V82-21-EU-S-D50"): "fiscal_position_template_3",
    ("be", "attn_VAT-IN-V82-21-EU-G-D35-ALRD-IN-BE"): "fiscal_position_template_3",
    ("be", "attn_VAT-IN-V81-00-ROW-CC"): "fiscal_position_template_2",
    ("be", "attn_VAT-IN-V82-00-ROW-CC"): "fiscal_position_template_2",
    ("be", "attn_VAT-IN-V83-00-ROW-CC"): "fiscal_position_template_2",
    ("be", "attn_VAT-IN-V83-277-ROW-CC"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V82-S-ND"): "fiscal_position_template_1,fiscal_position_template_5",
    ("be", "attn_VAT-IN-V83-IG-ND"): "fiscal_position_template_1,fiscal_position_template_5",
    ("pl", "vs_zwrot_podróżnych_0"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vs_kraj_zw_gold"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vp_leas_sale"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vp_leas_purchase"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vs_stal"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vz_stal"): "fiscal_position_template_1,fiscal_position_template_4",
    ("pl", "vs_unia_i42"): "fiscal_position_template_2",
    ("pl", "vs_unia_triangular"): "fiscal_position_template_2",
    ("pl", "vs_unia_i63"): "fiscal_position_template_2",
    ("pl", "vz_unia_triangular"): "fiscal_position_template_2",
    ("be", "tax_alcohol_luxury"): "fiscal_position_template_1,fiscal_position_template_5",
    ("hr", "VAT_S_TAX_PERSON_25%"): "fiscal_position_hr_eu_out",
    ("hr", "VAT_S_TAX_PERSON_13%"): "fiscal_position_hr_eu_out",
    ("hr", "VAT_S_TAX_PERSON_5%"): "fiscal_position_hr_eu_out",
    ("hr", "VAT_S_EU_S"): "fiscal_position_hr_eu",
    ("hr", "VAT_S_reverse_O"): "fiscal_position_hr_national,fiscal_position_hr_person_private",
    ("hr", "VAT_S_carried_other_state_O"): "fiscal_position_hr_eu",
    ("hr", "VAT_S_person_not_in_ROC_O"): "fiscal_position_hr_eu_out",
    ("hr", "VAT_S_new_transport_other_state_O"): "fiscal_position_hr_eu",
    ("hr", "VAT_P_install_assemb_goods_O"): "fiscal_position_hr_eu",
    ("hr", "VAT_P_S_IN_EU_25"): "fiscal_position_hr_eu",
    ("hr", "VAT_P_S_IN_EU_13"): "fiscal_position_hr_eu",
    ("hr", "VAT_P_S_IN_EU_5"): "fiscal_position_hr_eu",
    ("hr", "VAT_P_reverse_charge"): "fiscal_position_hr_national,fiscal_position_hr_person_private",
    ("ch", "vat_O_exclude"): "fiscal_position_template_1",
    ("ch", "vat_100_import"): "fiscal_position_template_1",
    ("ch", "vat_100_import_invest"): "fiscal_position_template_1",
    ("ch", "vat_77_purchase_return"): "fiscal_position_template_1",
    ("ch", "vat_77_purchase"): "fiscal_position_template_1",
    ("ch", "vat_other_movements_900"): "fiscal_position_template_1",
    ("ch", "vat_other_movements_910"): "fiscal_position_template_1",
    ("ch", "vat_purchase_81"): "fiscal_position_template_1",
    ("ch", "vat_purchase_81_return"): "fiscal_position_template_1",
    ("ke", "ST0"): "fiscal_position_template_national",
    ("ke", "STEX"): "fiscal_position_template_national",
    ("ke", "PTEX"): "fiscal_position_template_national",
    ("ke", "PTIM16S"): "fiscal_position_template_non_kenyan",
    ("ke", "CTL2"): "fiscal_position_template_national",
    ("gn_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gn_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gn", "tva_exempt_0"): "fiscal_position_template_1",
    ("gn", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("jo_standard", "jo_standard_purchase_10"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_purchase_4"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_purchase_other"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_purchase_import_16"): "account_fiscal_position_non_jordan",
    ("jo_standard", "jo_standard_purchase_import_10"): "account_fiscal_position_non_jordan",
    ("jo_standard", "jo_standard_purchase_import_4"): "account_fiscal_position_non_jordan",
    ("jo_standard", "jo_standard_purchase_import_deferred"): "account_fiscal_position_non_jordan",
    ("jo_standard", "eg_zero_purchase_exempted"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_sale_10"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_sale_4"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_standard_sale_other"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_zero_sale_0"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_zero_sale_no_tax"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_zero_sale_exempted"): "account_fiscal_position_jordan",
    ("jo_standard", "jo_zero_sale_non_deductible"): "account_fiscal_position_jordan",
    ("ca_2023", "pst_sale_tax_6"): "fiscal_position_template_sk",
    ("ca_2023", "pst_sale_tax_7_bc"): "fiscal_position_template_bc",
    ("ca_2023", "pst_sale_tax_7_mb"): "fiscal_position_template_mb",
    ("ca_2023", "qst_sale_tax_9975"): "fiscal_position_template_qc",
    ("ca_2023", "gst_purchase_tax_5"): "fiscal_position_template_nu,fiscal_position_template_yt,fiscal_position_template_nt,fiscal_position_template_ab",
    ("ca_2023", "pst_purchase_tax_6"): "fiscal_position_template_sk",
    ("ca_2023", "pst_purchase_tax_6_G_resale"): "fiscal_position_template_sk",
    ("ca_2023", "pst_purchase_tax_7_bc"): "fiscal_position_template_bc",
    ("ca_2023", "pst_purchase_tax_7_mb"): "fiscal_position_template_mb",
    ("ca_2023", "qst_purchase_tax_9975"): "fiscal_position_template_qc",
    ("ca_2023", "hst_purchase_tax_13"): "fiscal_position_template_on",
    ("ca_2023", "hst_purchase_tax_15"): "fiscal_position_template_pe,fiscal_position_template_ns,fiscal_position_template_nl,fiscal_position_template_nb",
    ("ca_2023", "gstpst_purchase_tax_11"): "fiscal_position_template_sk",
    ("ca_2023", "gstpst_purchase_tax_11_G_resale"): "fiscal_position_template_sk",
    ("ca_2023", "gstpst_purchase_tax_12_bc"): "fiscal_position_template_bc",
    ("ca_2023", "gstpst_purchase_tax_12_mb"): "fiscal_position_template_mb",
    ("ca_2023", "gstqst_purchase_tax_14975"): "fiscal_position_template_qc",
    ("ca_2023", "int_purchase_tax_0"): "fiscal_position_template_intl",
    ("zm", "zm_tax_sale_16_mtv"): "zm_fiscal_position_template_national",
    ("zm", "zm_tax_sale_0_disposal"): "zm_fiscal_position_template_national",
    ("zm", "zm_tax_purchase_16_mtv"): "zm_fiscal_position_template_national",
    ("zm", "zm_tax_purchase_16_capex"): "zm_fiscal_position_template_national",
    ("zm", "zm_tax_purchase_0_nondeductible"): "zm_fiscal_position_template_national",
    ("zm", "zm_tax_purchase_0_unregistered"): "zm_fiscal_position_template_national",
    ("ml_syscebnl", "syscebnl_tva_self_delivery_18"): "syscebnl_fiscal_position_template_1",
    ("ml_syscebnl", "syscebnl_tva_self_delivery_5"): "syscebnl_fiscal_position_template_1",
    ("ml_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ml_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ml", "tva_self_delivery_18"): "fiscal_position_template_1",
    ("ml", "tva_self_delivery_5"): "fiscal_position_template_1",
    ("ml", "tva_exempt_0"): "fiscal_position_template_1",
    ("ml", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("ga", "tva_sale_lasm_19"): "fiscal_position_template_1",
    ("ga", "tva_sale_18"): "fiscal_position_template_1",
    ("ga", "tva_sale_10"): "fiscal_position_template_1",
    ("ga", "tva_sale_5"): "fiscal_position_template_1",
    ("ga", "css_sale_1"): "fiscal_position_template_1",
    ("ga", "tva_lasm_18"): "fiscal_position_template_1",
    ("ga", "tva_lasm_10"): "fiscal_position_template_1",
    ("ga", "tva_lasm_5"): "fiscal_position_template_1",
    ("ga", "css_lasm_1"): "fiscal_position_template_1",
    ("ga", "tva_purchase_18"): "fiscal_position_template_1",
    ("ga", "tva_purchase_10"): "fiscal_position_template_1",
    ("ga", "tva_purchase_5"): "fiscal_position_template_1",
    ("ga", "css_purchase_1"): "fiscal_position_template_1",
    ("ga", "tva_exempt_0"): "fiscal_position_template_1",
    ("ga", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_sale_lasm_19"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_sale_18"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_sale_10"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_sale_5"): "fiscal_position_template_1",
    ("ga_syscebnl", "css_sale_1"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_lasm_18"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_lasm_10"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_lasm_5"): "fiscal_position_template_1",
    ("ga_syscebnl", "css_lasm_1"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_purchase_18"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_purchase_10"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_purchase_5"): "fiscal_position_template_1",
    ("ga_syscebnl", "css_purchase_1"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_exempt_0"): "fiscal_position_template_1",
    ("ga_syscebnl", "syscebnl_tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("ae", "uae_export_tax"): "account_fiscal_position_non_uae_countries",
    ("ae", "uae_sale_tax_reverse_charge_dubai"): "account_fiscal_position_dubai",
    ("ae", "uae_sale_tax_reverse_charge_abu_dhabi"): "account_fiscal_position_abu_dhabi",
    ("ae", "uae_sale_tax_reverse_charge_sharjah"): "account_fiscal_position_sharjah",
    ("ae", "uae_sale_tax_reverse_charge_ajman"): "account_fiscal_position_ajman",
    ("ae", "uae_sale_tax_reverse_charge_umm_al_quwain"): "account_fiscal_position_umm_al_quwain",
    ("ae", "uae_sale_tax_reverse_charge_ras_al_khaima"): "account_fiscal_position_ras_al_khaima",
    ("ae", "uae_sale_tax_reverse_charge_fujairah"): "account_fiscal_position_fujairah",
    ("ae", "uae_import_tax"): "account_fiscal_position_non_uae_countries",
    ("mt", "VAT_S_IN_MT_5_S"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_S_IN_MT_0_WC"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_S_IN_MT_0_WOC"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_P_IN_MT_0"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_P_IN_MT_RC_0_IC_CG"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_P_IN_MT_RC_0_DOM"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("mt", "VAT_P_IN_MT_IC_NEU_0_OTHER"): "fiscal_position_mt_national,fiscal_position_mt_person_private",
    ("bj", "tva_sale_self_18"): "fiscal_position_template_1",
    ("bj", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("bj_syscebnl", "syscebnl_tva_sale_self_18"): "syscebnl_fiscal_position_template_1",
    ("bj_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cg", "tva_exempt_0"): "fiscal_position_template_1",
    ("cg", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("cg", "tva_sale_18"): "fiscal_position_template_1",
    ("cg", "tva_purchase_18"): "fiscal_position_template_1",
    ("cg", "tva_sale_09"): "fiscal_position_template_1",
    ("cg", "tva_purchase_09"): "fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_sale_18"): "syscebnl_fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_purchase_18"): "syscebnl_fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_sale_09"): "syscebnl_fiscal_position_template_1",
    ("cg_syscebnl", "syscebnl_tva_purchase_09"): "syscebnl_fiscal_position_template_1",
    ("uy", "vat7"): "account_fiscal_position_local_uruguay",
    ("uy", "vat8"): "account_fiscal_position_local_uruguay",
    ("uy", "vat9"): "account_fiscal_position_local_uruguay",
    ("uy", "vat10"): "account_fiscal_position_local_uruguay",
    ("ci_syscebnl", "syscebnl_tva_self_delivery_18"): "syscebnl_fiscal_position_template_1",
    ("ci_syscebnl", "syscebnl_tva_self_delivery_9"): "syscebnl_fiscal_position_template_1",
    ("ci_syscebnl", "syscebnl_tva_exempt_legal_0"): "syscebnl_fiscal_position_template_1",
    ("ci_syscebnl", "syscebnl_tva_exempt_conv_0"): "syscebnl_fiscal_position_template_1",
    ("ci_syscebnl", "syscebnl_tva_non_impos_0"): "syscebnl_fiscal_position_template_1",
    ("ci_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ci", "tva_self_delivery_18"): "fiscal_position_template_1",
    ("ci", "tva_self_delivery_9"): "fiscal_position_template_1",
    ("ci", "tva_exempt_legal_0"): "fiscal_position_template_1",
    ("ci", "tva_exempt_conv_0"): "fiscal_position_template_1",
    ("ci", "tva_non_impos_0"): "fiscal_position_template_1",
    ("ci", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("ie", "ie_tax_purchase_ls_4_8"): "ie_fp_domestic,ie_fp_eu_private",
    ("ie", "ie_tax_purchase_ex_goods_pa_0"): "ie_fp_ex",
    ("tz", "VAT_S_ZERO_O"): "fiscal_position_tz_national",
    ("tz", "VAT_S_SPRECIAL_RELIEF_O"): "fiscal_position_tz_national",
    ("tz", "VAT_P_NCREDITABLE_O"): "fiscal_position_tz_national",
    ("pt", "iva_pt_purchase_eu_normal_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_purchase_eu_intermedia_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_purchase_eu_reduzida_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ma_purchase_eu_normal_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ma_purchase_eu_intermedia_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ma_purchase_eu_reduzida_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ac_purchase_eu_normal_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ac_purchase_eu_intermedia_servicos"): "fiscal_position_foreign_eu",
    ("pt", "iva_pt_ac_purchase_eu_reduzida_servicos"): "fiscal_position_foreign_eu",
    ("rs", "rs_sale_vat_0_deduct_previous_tax"): "fiscal_position_template_domestic",
    ("rs", "rs_sale_vat_0_no_deduct_previous_tax"): "fiscal_position_template_domestic",
    ("rs", "rs_purchase_import_vat_0"): "fiscal_position_template_foreign",
    ("rs", "rs_purchase_import_vat_20"): "fiscal_position_template_foreign",
    ("rs", "rs_purchase_import_vat_10"): "fiscal_position_template_foreign",
    ("rs", "rs_purchase_farmer_deductible_vat_8"): "fiscal_position_template_domestic",
    ("rs", "rs_purchase_farmer_non_deductible_vat_8"): "fiscal_position_template_domestic",
    ("cd_syscebnl", "syscebnl_tva_sale_16_pm"): "syscebnl_fiscal_position_template_1",
    ("cd_syscebnl", "syscebnl_tva_sale_16_goods_sd"): "syscebnl_fiscal_position_template_1",
    ("cd_syscebnl", "syscebnl_tva_sale_16_services_sd"): "syscebnl_fiscal_position_template_1",
    ("cd_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cd_syscebnl", "syscebnl_tva_non_imposable_0"): "syscebnl_fiscal_position_template_1",
    ("cd_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cd", "tva_sale_16_pm"): "fiscal_position_template_1",
    ("cd", "tva_sale_16_goods_sd"): "fiscal_position_template_1",
    ("cd", "tva_sale_16_services_sd"): "fiscal_position_template_1",
    ("cd", "tva_exempt_0"): "fiscal_position_template_1",
    ("cd", "tva_non_imposable_0"): "fiscal_position_template_1",
    ("cd", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("mz", "vat_exempt_sale"): "fiscal_position_template_dom",
    ("mz", "vat_import"): "fiscal_position_import_export",
    ("mz", "vat_exempt_purchase"): "fiscal_position_template_dom",
    ("rw", "VAT_S_exempt_O"): "fiscal_position_rw_national",
    ("rw", "VAT_S_IN_O"): "fiscal_position_rw_national",
    ("rw", "VAT_S_reverse_O"): "fiscal_position_rw_national",
    ("rw", "VAT_P_IN_RW_0"): "fiscal_position_rw_national",
    ("rw", "VAT_P_reverse_18"): "fiscal_position_rw_national",
    ("ee", "l10n_ee_vat_out_0_eu_g_t"): "afpt_eu_ic",
    ("ee", "l10n_ee_vat_out_0_pas"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_out_exempt"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_out_0_kms_41_1"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_out_0_kms_41_2"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_0_eu_g"): "afpt_eu_ic",
    ("ee", "l10n_ee_vat_in_0_eu_s"): "afpt_eu_ic",
    ("ee", "l10n_ee_vat_in_20_car"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_20_car_part"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_22_car"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_22_car_part"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_20_assets"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_22_assets"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_imp_cus"): "afpt_imp_exp",
    ("ee", "l10n_ee_vat_in_0_kms_41_1"): "afpt_national,afpt_eu_private",
    ("ee", "l10n_ee_vat_in_0_kms_41_2"): "afpt_national,afpt_eu_private",
    ("ar_ri", "ri_tax_vat_no_corresponde_ventas"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_vat_no_gravado_ventas"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_vat_25_ventas"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_vat_25_compras"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_vat_5_ventas"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_vat_5_compras"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_percepcion_iva_sufrida"): "l10n_ar_domestic_fiscal_position",
    ("ar_ri", "ri_tax_ganancias_iva_adicional"): "l10n_ar_domestic_fiscal_position",
    ("mx", "tax19"): "l10n_mx_domestic_fiscal_position",
    ("mx", "tax20"): "l10n_mx_domestic_fiscal_position",
    ("gw", "tva_purchase_5"): "fiscal_position_template_1",
    ("gw", "tva_exempt_0"): "fiscal_position_template_1",
    ("gw", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("gw_syscebnl", "syscebnl_tva_purchase_5"): "syscebnl_fiscal_position_template_1",
    ("gw_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gw_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("tg_syscebnl", "syscebnl_tva_sale_18_pm"): "syscebnl_fiscal_position_template_1",
    ("tg_syscebnl", "syscebnl_tva_sale_18_sd"): "syscebnl_fiscal_position_template_1",
    ("tg_syscebnl", "syscebnl_tva_non_imposable_0"): "syscebnl_fiscal_position_template_1",
    ("tg_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("tg", "tva_sale_18_pm"): "fiscal_position_template_1",
    ("tg", "tva_sale_18_sd"): "fiscal_position_template_1",
    ("tg", "tva_non_imposable_0"): "fiscal_position_template_1",
    ("tg", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("dk", "tax_s0"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_s%"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_smf"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_sbrugt"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_smargin"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_smotor"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_sleasing"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_skunstnere"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_slokal"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_s7"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_s8"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_smfeu"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_s4"): "fiscal_position_template_3lande",
    ("dk", "tax_s5"): "fiscal_position_template_3lande",
    ("dk", "tax_k3"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k0"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k7"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k5a"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k5b"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kl1"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k25a"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k25b"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kl2"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kl3"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k2"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k6"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k4"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kbrugtmoms"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kmarginmoms"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_k_brugtbil"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kleasingbil"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdk01"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdko2"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdko3"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdko0"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdko4"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_klokalmoms"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_kdkoi"): "fiscal_position_template_dk_vat,fiscal_position_template_eu",
    ("dk", "tax_keuv3"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuv0"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuv2"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuv4"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuy3"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuy0"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuy2"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuy4"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_kleu2"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_kleu3"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keuyl1"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_keumf"): "fiscal_position_template_eu_taxid",
    ("dk", "tax_k%euv3"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euv0"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euv2"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euv4"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euy3"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euy0"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euy2"): "fiscal_position_template_3lande",
    ("dk", "tax_k%euy4"): "fiscal_position_template_3lande",
    ("fr", "tva_purchase_good_fuel"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_purchase_good_fuel_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_normale_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_specifique_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_intermediaire_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_reduite_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_super_reduite_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_imm_normale"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_imm_specifique"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_imm_intermediaire"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_imm_reduite"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_imm_super_reduite"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_purchase_service_20_import"): "fiscal_position_template_import_export",
    ("fr", "tva_acq_encaissement_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_intermediaire_encaissement_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_encaissement_reduite_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_acq_encaissement_super_reduite_TTC"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_purchase_imm_normale"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_sale_good_0"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_sale_service_0"): "fiscal_position_template_domestic,fiscal_position_template_intraeub2c",
    ("fr", "tva_intra_specifique_services"): "fiscal_position_template_intraeub2b",
    ("lb", "lb_vat_0_goods_sale_exempt"): "account_fiscal_position_lebanon",
    ("lb", "lb_vat_0_services_sale_exempt"): "account_fiscal_position_lebanon",
    ("lb", "lb_vat_11_purchases"): "account_fiscal_position_lebanon",
    ("lb", "lb_vat_0_purchases_exempt"): "account_fiscal_position_lebanon",
    ("mn", "account_tax_purchase_vat3"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat4"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat5"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat6"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat7"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat8"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat9"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat10"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat11"): "fiscal_position_vat0",
    ("mn", "account_tax_sale_vat25"): "fiscal_position_vat0",
    ("mn", "account_tax_sale_vat26"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat12"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat13"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat14"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat15"): "fiscal_position_vat0",
    ("mn", "account_tax_purchase_vat16"): "fiscal_position_vat0",
    ("mu", "mu_tax_sale_0"): "mu_fp_domestic",
    ("mu", "mu_tax_sale_exempt"): "mu_fp_domestic",
    ("mu", "mu_tax_purchase_0"): "mu_fp_domestic",
    ("mu", "mu_tax_purchase_0_import"): "mu_fp_ex",
    ("in", "cess_purchase_5_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cess_purchase_1591_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_0_5_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_0_5_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_1_2_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_1_2_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_14_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_14_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_9_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_9_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_6_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_6_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_purchase_2_5_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_purchase_2_5_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "sgst_sale_9_rc"): "fiscal_position_in_reverse_charge_intra",
    ("in", "cgst_sale_9_rc"): "fiscal_position_in_reverse_charge_intra",
    ("de_skr03", "tax_eu_7_purchase_no_vst_skr03"): "fiscal_position_eu_vat_id_partner_skr03,fiscal_position_eu_vat_id_partner_service_skr03,fiscal_position_eu_no_id_partner_skr03",
    ("de_skr03", "tax_eu_car_purchase_skr03"): "fiscal_position_eu_vat_id_partner_skr03,fiscal_position_eu_vat_id_partner_service_skr03,fiscal_position_eu_no_id_partner_skr03",
    ("de_skr03", "tax_free_skr03_mit_vst"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_free_skr03_ohne_vst"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_eu_purchase_tax_free_skr03"): "fiscal_position_eu_vat_id_partner_skr03,fiscal_position_eu_vat_id_partner_service_skr03,fiscal_position_eu_no_id_partner_skr03",
    ("de_skr03", "tax_not_taxable_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_no_ustpflicht_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_55_farmer_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_107_farmer_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_19_farmer_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_x_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_no_ustpflicht_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_55_farmer_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_107_farmer_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_19_13b_ausland_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_7_13b_ausland_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_19_13b_eu_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_7_13b_eu_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_19_13b_bau_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_7_13b_bau_ohne_vst_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_free_eu_skr03"): "fiscal_position_eu_vat_id_partner_skr03,fiscal_position_eu_vat_id_partner_service_skr03,fiscal_position_eu_no_id_partner_skr03",
    ("de_skr03", "tax_free_newcar_skr03"): "fiscal_position_eu_vat_id_partner_skr03,fiscal_position_eu_vat_id_partner_service_skr03,fiscal_position_eu_no_id_partner_skr03",
    ("de_skr03", "tax_ust_19_3eck_first_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_free_bau_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_free_mobil_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_vst_19_purchase_13b_bau_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_ust_vst_7_purchase_13b_bau_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_ust_19_purchase_13b_mobil_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_ust_19_purchase_3eck_last_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_ust_7_purchase_13b_werk_ausland_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_ust_19_purchase_13a_auslagerung_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr03", "tax_vst_ust_7_purchase_13a_auslagerung_skr03"): "fiscal_position_domestic_skr03",
    ("de_skr04", "tax_eu_7_purchase_no_vst_skr04"): "fiscal_position_eu_vat_id_partner_skr04,fiscal_position_eu_vat_id_partner_service_skr04,fiscal_position_eu_no_id_partner_skr04",
    ("de_skr04", "tax_eu_car_purchase_skr04"): "fiscal_position_eu_vat_id_partner_skr04,fiscal_position_eu_vat_id_partner_service_skr04,fiscal_position_eu_no_id_partner_skr04",
    ("de_skr04", "tax_free_skr04_mit_vst"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_free_skr04_ohne_vst"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_eu_purchase_tax_free_skr04"): "fiscal_position_eu_vat_id_partner_skr04,fiscal_position_eu_vat_id_partner_service_skr04,fiscal_position_eu_no_id_partner_skr04",
    ("de_skr04", "tax_not_taxable_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_no_ustpflicht_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_55_farmer_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_107_farmer_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_19_farmer_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_x_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_no_ustpflicht_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_55_farmer_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_107_farmer_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_19_13b_ausland_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_7_13b_ausland_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_19_13b_eu_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_7_13b_eu_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_19_13b_bau_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_7_13b_bau_ohne_vst_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_free_eu_skr04"): "fiscal_position_eu_vat_id_partner_skr04,fiscal_position_eu_vat_id_partner_service_skr04,fiscal_position_eu_no_id_partner_skr04",
    ("de_skr04", "tax_free_newcar_skr04"): "fiscal_position_eu_vat_id_partner_skr04,fiscal_position_eu_vat_id_partner_service_skr04,fiscal_position_eu_no_id_partner_skr04",
    ("de_skr04", "tax_ust_19_3eck_first_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_free_bau_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_free_mobil_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_vst_19_purchase_13b_bau_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_ust_vst_7_purchase_13b_bau_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_ust_19_purchase_13b_mobil_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_ust_19_purchase_3eck_last_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_ust_7_purchase_13b_werk_ausland_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_ust_19_purchase_13a_auslagerung_skr04"): "fiscal_position_domestic_skr04",
    ("de_skr04", "tax_vst_ust_7_purchase_13a_auslagerung_skr04"): "fiscal_position_domestic_skr04",
    ("ma", "vat_out_0_20"): "afpt_morocco",
    ("ma", "vat_out_0_30"): "afpt_morocco",
    ("ma", "vat_out_0_40"): "afpt_morocco",
    ("ma", "vat_out_0_50"): "afpt_morocco",
    ("ma", "vat_in_20_140"): "afpt_morocco",
    ("ma", "vat_in_20_155"): "afpt_morocco",
    ("ma", "vat_in_20_156"): "afpt_morocco",
    ("ma", "vat_in_20_164"): "afpt_morocco",
    ("ma", "vat_in_20_165"): "afpt_morocco",
    ("ma", "vat_in_20_166"): "afpt_morocco",
    ("ma", "vat_in_20_167"): "afpt_morocco",
    ("ma", "vat_in_14_141"): "afpt_morocco",
    ("ma", "vat_in_14_168"): "afpt_morocco",
    ("ma", "vat_in_10_142"): "afpt_morocco",
    ("ma", "vat_in_10_143"): "afpt_morocco",
    ("ma", "vat_in_10_144"): "afpt_morocco",
    ("ma", "vat_in_10_153"): "afpt_morocco",
    ("ma", "vat_in_10_160"): "afpt_morocco",
    ("ma", "vat_in_7_169"): "afpt_morocco",
    ("cl", "ITAX_19"): "l10n_cl_domestic_fiscal_position",
    ("cl", "iva_activo_fijo"): "l10n_cl_domestic_fiscal_position",
    ("cl", "iva_activo_fijo_uso_no_recup"): "l10n_cl_domestic_fiscal_position",
    ("cl", "iva_compra_uso_comun"): "l10n_cl_domestic_fiscal_position",
    ("uk", "PT5"): "account_fiscal_position_domestic_b2c,account_fiscal_position_domestic_b2b",
    ("uk", "PT_20_RCD"): "account_fiscal_position_domestic_b2c,account_fiscal_position_domestic_b2b",
    ("uk", "ST_20_RCD"): "account_fiscal_position_domestic_b2c,account_fiscal_position_domestic_b2b",
    ("nz", "nz_tax_purchase_taxable_import"): "fiscal_position_os_partner",
    ("nz", "nz_tax_purchase_gst_only"): "l10n_nz_domestic_fiscal_position",
    ("bh", "l10n_bh_purchase_vat_10_ex_df"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_sale_0"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_purchase_0"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_sale_0_EXT"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_purchase_0_EXT"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_purchase_10_RC_D"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_purchase_10_RC"): "fiscal_position_template_dom",
    ("bh", "l10n_bh_sale_10_RC"): "fiscal_position_template_dom",
    ("si", "gd_taxr_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxp_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxp_nr_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxp_nr_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxp_st_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxp_st_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_0_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_0_no_no_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_0_eu_goods_2"): "gd_fp_eu",
    ("si", "gd_taxe_out_0_eu_goods_3"): "gd_fp_eu",
    ("si", "gd_taxe_out_8_no_goods_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_22_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_95_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_out_5_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_95_no_service_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_22_no_service_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_8_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_5_no_service_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_5_no_service_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_8_no_no_2"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_5_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_0_no_no_1"): "gd_fp_do,gd_fp_do1",
    ("si", "gd_taxe_in_22_eu_service"): "gd_fp_eu",
    ("si", "gd_taxe_in_5_3w_goods_1"): "gd_fp_ne",
    ("si", "l10n_si_vat_22_sale_distance"): "gd_fp_eu",
    ("si", "l10n_si_vat_22_sale_installation_eu"): "gd_fp_eu",
    ("si", "l10n_si_vat_0_sale_no_deduction"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_5_purchase_non_deductible"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_9_purchase_services_eu"): "gd_fp_eu",
    ("si", "l10n_si_vat_22_purchase_estate"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_9_purchase_estate"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_22_purchase_fixed"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_9_purchase_fixed"): "gd_fp_do,gd_fp_do1",
    ("si", "l10n_si_vat_5_purchase_fixed"): "gd_fp_do,gd_fp_do1",
    ("km", "tva_purchase"): "fiscal_position_template_1",
    ("km", "tva_exempt_0"): "fiscal_position_template_1",
    ("km_syscebnl", "syscebnl_tva_purchase"): "syscebnl_fiscal_position_template_1",
    ("km_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ne_syscebnl", "syscebnl_tva_sale_self_19"): "syscebnl_fiscal_position_template_1",
    ("ne_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ne_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("ne", "tva_sale_self_19"): "fiscal_position_template_1",
    ("ne", "tva_exempt_0"): "fiscal_position_template_1",
    ("ne", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("ec", "tax_vat_15_412"): "fp_local",
    ("ec", "tax_vat_412"): "fp_local",
    ("ec", "tax_vat_05_411_goods"): "fp_local",
    ("ec", "tax_vat_05_411_services"): "fp_local",
    ("ec", "tax_vat_05_412"): "fp_local",
    ("ec", "tax_vat_416"): "fp_local",
    ("ec", "tax_vat_413"): "fp_local",
    ("ec", "tax_vat_414"): "fp_local",
    ("ec", "tax_vat_418"): "fp_foreign",
    ("ec", "tax_vat_441"): "fp_foreign",
    ("ec", "tax_vat_15_444"): "fp_local",
    ("ec", "tax_vat_444"): "fp_local",
    ("ec", "tax_vat_05_444"): "fp_local",
    ("ec", "tax_vat_444_zero_vat"): "fp_local",
    ("ec", "tax_vat_444_not_charged_vat"): "fp_local",
    ("ec", "tax_vat_444_not_exempt_vat"): "fp_local",
    ("ec", "tax_vat_15_510_sup_01"): "fp_local",
    ("ec", "tax_vat_15_510_sup_05"): "fp_local",
    ("ec", "tax_vat_15_510_sup_06"): "fp_local",
    ("ec", "tax_vat_15_510_sup_15"): "fp_local",
    ("ec", "tax_vat_15_511_sup_03"): "fp_local",
    ("ec", "tax_vat_15_512_sup_04"): "fp_local",
    ("ec", "tax_vat_15_512_sup_05"): "fp_local",
    ("ec", "tax_vat_15_512_sup_07"): "fp_local",
    ("ec", "tax_vat_15_513_sup_01"): "fp_local",
    ("ec", "tax_vat_15_514_sup_06"): "fp_local",
    ("ec", "tax_vat_15_515_sup_03"): "fp_local",
    ("ec", "tax_vat_510_sup_01"): "fp_local",
    ("ec", "tax_vat_510_sup_05"): "fp_local",
    ("ec", "tax_vat_510_sup_06"): "fp_local",
    ("ec", "tax_vat_510_sup_15"): "fp_local",
    ("ec", "tax_vat_511_sup_03"): "fp_local",
    ("ec", "tax_vat_512_sup_04"): "fp_local",
    ("ec", "tax_vat_512_sup_05"): "fp_local",
    ("ec", "tax_vat_512_sup_07"): "fp_local",
    ("ec", "tax_vat_513_sup_01"): "fp_local",
    ("ec", "tax_vat_514_sup_06"): "fp_local",
    ("ec", "tax_vat_515_sup_03"): "fp_local",
    ("ec", "tax_vat_05_510_sup_01"): "fp_local",
    ("ec", "tax_vat_05_510_sup_05"): "fp_local",
    ("ec", "tax_vat_05_510_sup_06"): "fp_local",
    ("ec", "tax_vat_05_510_sup_15"): "fp_local",
    ("ec", "tax_vat_05_511_sup_03"): "fp_local",
    ("ec", "tax_vat_05_512_sup_04"): "fp_local",
    ("ec", "tax_vat_05_512_sup_05"): "fp_local",
    ("ec", "tax_vat_05_512_sup_07"): "fp_local",
    ("ec", "tax_vat_05_513_sup_01"): "fp_local",
    ("ec", "tax_vat_05_514_sup_06"): "fp_local",
    ("ec", "tax_vat_05_515_sup_03"): "fp_local",
    ("ec", "tax_vat_516_sup_07"): "fp_local",
    ("ec", "tax_vat_517_sup_02"): "fp_local",
    ("ec", "tax_vat_517_sup_04"): "fp_local",
    ("ec", "tax_vat_517_sup_05"): "fp_local",
    ("ec", "tax_vat_517_sup_07"): "fp_local",
    ("ec", "tax_vat_517_sup_15"): "fp_local",
    ("ec", "tax_vat_518_sup_02"): "fp_local",
    ("ec", "tax_vat_541_sup_02"): "fp_local",
    ("ec", "tax_vat_510_08_sup_01"): "fp_local",
    ("ec", "tax_vat_542_sup_02"): "fp_local",
    ("ec", "tax_vat_15_545_sup_08"): "fp_local",
    ("ec", "tax_vat_545_sup_08"): "fp_local",
    ("ec", "tax_vat_05_545_sup_08"): "fp_local",
    ("ec", "tax_vat_545_sup_08_vat0"): "fp_local",
    ("ec", "tax_vat_545_sup_08_vat_exempt"): "fp_local",
    ("ec", "tax_vat_545_sup_08_vat_not_charged"): "fp_local",
    ("ec", "tax_vat_15_545_sup_09"): "fp_local",
    ("ec", "tax_vat_545_sup_09"): "fp_local",
    ("ec", "tax_vat_05_545_sup_09"): "fp_local",
    ("ec", "tax_vat_541_sup_02_dividend"): "fp_local",
    ("it", "00art15v"): "it,intra_private",
    ("it", "00art15a"): "it,intra_private",
    ("it", "22rcd"): "it,intra_private",
    ("it", "10rcd"): "it,intra_private",
    ("it", "5rcd"): "it,intra_private",
    ("it", "4rcd"): "it,intra_private",
    ("it", "00rcd"): "it,intra_private",
    ("it", "22vsp"): "it,intra_private",
    ("it", "22vsp_storno"): "it,intra_private",
    ("it", "10vsp"): "it,intra_private",
    ("it", "10vsp_storno"): "it,intra_private",
    ("it", "5vsp"): "it,intra_private",
    ("it", "5vsp_storno"): "it,intra_private",
    ("it", "4vsp"): "it,intra_private",
    ("it", "4vsp_storno"): "it,intra_private",
    ("it", "0rc_n61"): "it,intra_private",
    ("it", "0rc_n62"): "it,intra_private",
    ("it", "0rc_n62b"): "it,intra_private",
    ("it", "0rc_n64"): "it,intra_private",
    ("it", "0rc_n65"): "it,intra_private",
    ("it", "0rc_n66"): "it,intra_private",
    ("it", "0rc_n67"): "it,intra_private",
    ("it", "0rc_n68"): "it,intra_private",
    ("it", "4rc_n61"): "it,intra_private",
    ("it", "4rc_n62"): "it,intra_private",
    ("it", "4rc_n62b"): "it,intra_private",
    ("it", "4rc_n64"): "it,intra_private",
    ("it", "4rc_n65"): "it,intra_private",
    ("it", "4rc_n66"): "it,intra_private",
    ("it", "4rc_n67"): "it,intra_private",
    ("it", "4rc_n68"): "it,intra_private",
    ("it", "5rc_n61"): "it,intra_private",
    ("it", "5rc_n62"): "it,intra_private",
    ("it", "5rc_n62b"): "it,intra_private",
    ("it", "5rc_n64"): "it,intra_private",
    ("it", "5rc_n65"): "it,intra_private",
    ("it", "5rc_n66"): "it,intra_private",
    ("it", "5rc_n67"): "it,intra_private",
    ("it", "5rc_n68"): "it,intra_private",
    ("it", "10rc_n61"): "it,intra_private",
    ("it", "10rc_n62"): "it,intra_private",
    ("it", "10rc_n62b"): "it,intra_private",
    ("it", "10rc_n64"): "it,intra_private",
    ("it", "10rc_n65"): "it,intra_private",
    ("it", "10rc_n66"): "it,intra_private",
    ("it", "10rc_n67"): "it,intra_private",
    ("it", "10rc_n68"): "it,intra_private",
    ("it", "22rc_n61"): "it,intra_private",
    ("it", "22rc_n62"): "it,intra_private",
    ("it", "22rc_n62b"): "it,intra_private",
    ("it", "22rc_n64"): "it,intra_private",
    ("it", "22rc_n65"): "it,intra_private",
    ("it", "22rc_n66"): "it,intra_private",
    ("it", "22rc_n67"): "it,intra_private",
    ("it", "22rc_n68"): "it,intra_private",
    ("ug", "sale_import_services_18"): "fiscal_position_template_non_ugandian",
    ("ug", "purchase_import_services_18"): "fiscal_position_template_non_ugandian",
    ("ug", "sale_import_deferred_vat_18"): "fiscal_position_template_non_ugandian",
    ("ug", "purchase_import_deferred_vat_18"): "fiscal_position_template_non_ugandian",
    ("kz", "l10n_kz_tax_vat_12_sale"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_0_sale"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_0_purchase"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_20_sale"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_12_sale_export"): "l10n_kz_fiscal_position_template_international",
    ("kz", "l10n_kz_tax_vat_0_sale_export"): "l10n_kz_fiscal_position_template_international",
    ("kz", "l10n_kz_tax_vat_20_sale_export"): "l10n_kz_fiscal_position_template_international",
    ("kz", "l10n_kz_tax_vat_12_purchase_non_resident"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_20_purchase_non_resident"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_12_sale_eeu"): "l10n_kz_fiscal_position_template_eeu",
    ("kz", "l10n_kz_tax_vat_0_sale_eeu"): "l10n_kz_fiscal_position_template_eeu",
    ("kz", "l10n_kz_tax_vat_20_sale_eeu"): "l10n_kz_fiscal_position_template_eeu",
    ("kz", "l10n_kz_tax_vat_exempt_sale"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_exempt_purchase"): "l10n_kz_fiscal_position_template_national",
    ("kz", "l10n_kz_tax_vat_exempt_sale_export"): "l10n_kz_fiscal_position_template_international",
    ("kz", "l10n_kz_tax_vat_exempt_purchase_import"): "l10n_kz_fiscal_position_template_international",
    ("kz", "l10n_kz_tax_vat_exempt_sale_eeu"): "l10n_kz_fiscal_position_template_eeu",
    ("kz", "l10n_kz_tax_vat_exempt_purchase_eeu"): "l10n_kz_fiscal_position_template_eeu",
    ("fi", "tax_dom_sales_goods_0"): "eu_no_vat,finland",
    ("fi", "vat0triangulation"): "eu",
    ("fi", "triangulation_purchase"): "eu",
    ("fi", "import_pay25_5"): "non_eu",
    ("fi", "import_pay24"): "non_eu",
    ("fi", "import_deduct25_5"): "non_eu",
    ("fi", "import_deduct24"): "non_eu",
    ("sn_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("sn_syscebnl", "syscebnl_tva_non_impos_0"): "syscebnl_fiscal_position_template_1",
    ("sn_syscebnl", "syscebnl_tva_sale_18_sd"): "syscebnl_fiscal_position_template_1",
    ("sn_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("sn", "tva_exempt_0"): "fiscal_position_template_1",
    ("sn", "tva_non_impos_0"): "fiscal_position_template_1",
    ("sn", "tva_sale_18_sd"): "fiscal_position_template_1",
    ("sn", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("td", "tva_exempt_0"): "fiscal_position_template_1",
    ("td", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("td_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("td_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cf", "tva_exempt_0"): "fiscal_position_template_1",
    ("cf", "tva_purchase_exempt_0"): "fiscal_position_template_1",
    ("cf_syscebnl", "syscebnl_tva_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("cf_syscebnl", "syscebnl_tva_purchase_exempt_0"): "syscebnl_fiscal_position_template_1",
    ("gr", "l10n_gr_tax_s0_deduct"): "fiscal_position_template_domestic,fiscal_position_template_4",
    ("gr", "l10n_gr_tax_s0_exempt"): "fiscal_position_template_domestic,fiscal_position_template_4",
    ("gr", "l10n_gr_tax_p0_G"): "fiscal_position_template_domestic,fiscal_position_template_4",
    ("gr", "l10n_gr_tax_p0_S"): "fiscal_position_template_domestic,fiscal_position_template_4",
    ("gr", "l10n_gr_tax_p0_IG"): "fiscal_position_template_domestic,fiscal_position_template_4",
    ("gr", "l10n_gr_tax_p0_other_imports"): "fiscal_position_template_import_export",
    ("gr", "l10n_gr_tax_p0_G_eu"): "fiscal_position_template_EU",
    ("gr", "l10n_gr_tax_p0_S_eu"): "fiscal_position_template_EU",
    ("gr", "l10n_gr_tax_p0_O_eu"): "fiscal_position_template_EU",
    ("jp", "l10n_jp_tax_sale_non_vat"): "l10n_jp_domestic_fiscal_position",
    ("jp", "l10n_jp_tax_purchase_exempt"): "l10n_jp_domestic_fiscal_position",
    ("hu", "FT"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "FKKS"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "FKKT"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "FF"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "FEUSZ"): "fiscal_position_hu_eu",
    ("hu", "FEXS"): "fiscal_position_hu_eu_out",
    ("hu", "VKOMP7"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VKOMP12"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VT"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VKKS"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VKKT"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VF"): "fiscal_position_hu_national,fiscal_position_hu_eu_private",
    ("hu", "VEU27S"): "fiscal_position_hu_eu",
    ("hu", "VEUM"): "fiscal_position_hu_eu",
    ("hu", "VIMS"): "fiscal_position_hu_eu_out",
    ("hu", "VIM"): "fiscal_position_hu_eu_out",
    ("il", "il_vat_inputs_2_3_18"): "account_fiscal_position_israel",
    ("il", "il_vat_inputs_1_4_18"): "account_fiscal_position_israel",
    ("il", "il_vat_inputs_fa_18"): "account_fiscal_position_israel",
    ("il", "il_vat_only_purchase_18"): "account_fiscal_position_import_export",
    ("tn", "l10n_tn_tax_vat_sale_tax_stamp"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_19_imported_equipment"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_13_imported_equipment"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_7_imported_equipment"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_0_imported_equipment"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_19_other_imported"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_13_other_imported"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_7_other_imported"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_0_other_imported"): "l10n_tn_fp_template_domestic",
    ("tn", "l10n_tn_tax_vat_purchase_tax_stamp"): "l10n_tn_fp_template_domestic",
    ("ro", "tva_ned_5_50"): "fiscal_position_template_1,fiscal_position_template_4",
    ("ro", "tva_ned_9_50"): "fiscal_position_template_1,fiscal_position_template_4",
    ("ro", "tva_ned_19_50"): "fiscal_position_template_1,fiscal_position_template_4",
    ("bg", "l10n_bg_sale_vat_20_remote"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_sale_vat_0_140"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_sale_vat_0_21"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_sale_vat_0_tri"): "fiscal_position_template_in_eu",
    ("bg", "l10n_bg_purchase_vat_20_ftc_82"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_purchase_vat_20_ptc_82"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_purchase_vat_9_ftc"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_purchase_vat_9_otc"): "fiscal_position_template_dom,fiscal_position_bg_private_eu",
    ("bg", "l10n_bg_purchase_vat_0_tri"): "fiscal_position_template_in_eu",
    ("ng", "l10n_ng_vat_out_7_5"): "l10n_ng_fp_domestic",
    ("ng", "l10n_ng_vat_out_0"): "l10n_ng_fp_domestic",
    ("ng", "l10n_ng_vat_out_exempt"): "l10n_ng_fp_domestic",
    ("ng", "l10n_ng_vat_in_0"): "l10n_ng_fp_domestic",
    ("ng", "l10n_ng_vat_in_7_5_auto"): "l10n_ng_fp_domestic",
    ("ng", "l10n_ng_vat_in_7_5_oil"): "l10n_ng_fp_domestic",
    ("es_canary_common", "account_tax_template_igic_r_5"): "fp_canary_1",
    ("es_canary_common", "account_tax_template_igic_re_ex"): "fp_canary_1",
    ("es_canary_common", "account_tax_template_igic_sop_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_sop_3_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_sop_7_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_sop_9_5_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_sop_15_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_sop_20_cmino"): "fp_retailer_canary",
    ("es_canary_common", "account_tax_template_igic_p_ex"): "fp_canary_1",
    ("es_canary_common", "account_tax_template_igic_sop_5"): "fp_canary_1",
    ("es_canary_common", "account_tax_template_igic_sop_5_inv"): "fp_canary_1",
    ("es_common_mainland", "account_tax_template_p_iva21_ibc"): "fp_extra",
    ("es_common_mainland", "account_tax_template_p_iva5_ic_bi"): "fp_intra",
    ("es_common_mainland", "account_tax_template_oss_s_iva_ns"): "fp_intra_private",
    ("es_common_mainland", "account_tax_template_oss_s_iva_ns_b"): "fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva4_ibc"): "fp_extra",
    ("es_common_mainland", "account_tax_template_p_iva5_ibi"): "fp_extra",
    ("es_common_mainland", "account_tax_template_p_iva10_ibc"): "fp_extra",
    ("es_common_mainland", "account_tax_template_p_iva5_ibc"): "fp_extra",
    ("es_common_mainland", "account_tax_template_p_iva5_bi"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_s_iva0_art22"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_s_iva0_art23"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_s_iva0_nsd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva0_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva10_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva7-5_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva5_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva4_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva2_nd"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_s_iva0_e"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_s_iva0_ic"): "l10n_es_domestic_fiscal_position,fp_intra_private",
    ("es_common_mainland", "account_tax_template_p_iva_isub"): "fp_dua",
    ("es_common_mainland", "account_tax_template_p_irpf24_rdc"): "fp_irpf24",
    ("es_common_mainland", "account_tax_template_s_irpf24_rdc"): "fp_irpf24",
    ("es_common_mainland", "account_tax_template_p_irpf21t"): "fp_irpf15",
    ("es_common_mainland", "account_tax_template_p_irpf21te"): "fp_irpf15",
    ("es_common_mainland", "account_tax_template_p_irpf15e"): "fp_irpf15",
    ("es_common_mainland", "account_tax_template_p_irpf7e"): "fp_irpf7",
    ("es_common_mainland", "account_tax_template_p_irpf21td"): "fp_irpf15",
    ("es_common_mainland", "account_tax_template_p_rp19"): "fp_irpf19",
    ("es_common_mainland", "account_tax_template_p_rrD19"): "fp_irpf19",
    ("es_common_mainland", "account_tax_template_p_irpf19ca"): "fp_irpf19",
    ("es_common_mainland", "account_tax_template_p_irpf19cs"): "fp_irpf19",
    ("es_common_mainland", "account_tax_template_p_irpf35cya"): "fp_irpf19",
    ("cz", "l10n_cz_other_transaction_deduction"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_investment_gold"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_acquisition_transport"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_12_domestic_supplies"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_12_receipt_domestic_supplies"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_tax_reverse_charge_mode"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_21_tax_reverse_charge_scheme"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_12_other_supplies_obligation"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_12_tax_reverse_charge_scheme"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_21_domestic_supplies"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_21_receipt_domestic_supplies"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_special_mode"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("cz", "l10n_cz_not_subject_vat"): "fiscal_position_domestic_cz,fiscal_position_eu_private_cz",
    ("eg", "eg_exempt_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_exempt_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_stamp_tax_20_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_stamp_tax_20_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_8_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_8_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_10_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_10_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_1_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_1_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_15_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_15_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_30_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_30_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_05_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_05_sale"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_5_purchase"): "account_fiscal_position_egypt",
    ("eg", "eg_schedule_tax_5_sale"): "account_fiscal_position_egypt",
}


def upgrade(file_manager):
    log = logging.getLogger(__name__)

    MODS_WITH_DYNAMIC_DOMESTIC_FP = {'l10n_in'}
    DEFINED_DOMESTIC_FP = {
        'l10n_ch': 'fiscal_position_template_1',
        'l10n_fr_account': 'fiscal_position_template_domestic',
    }

    SRC_FIELD = 'tax_ids/tax_src_id'
    DEST_FIELD = 'tax_ids/tax_dest_id'
    fiscal_position_data_files = [
        file for file in file_manager
        if file.path.suffix in ('.csv')
        and 'account.fiscal.position' in file.path.name
    ]
    fiscal_position_file_names = {f.path.parts[-1] for f in fiscal_position_data_files}
    nb_fiscal_position_files = len(fiscal_position_data_files)

    tax_data_files = [
        file for file in file_manager
        if file.path.suffix in ('.csv')
        and 'account.tax-' in file.path.name
    ]
    nb_tax_files = len(tax_data_files)

    eu_b2c_fps = {}
    tax_positions = defaultdict(lambda: defaultdict(lambda: defaultdict(lambda: defaultdict(fp=set(), replaces=set()))))  # {module_name: {coa_name: { tax_x: {fp: {fiscal_position_1,fiscal_position_2}, replaces: {tax1}}}}
    for i, file in enumerate(fiscal_position_data_files, start=1):
        file_manager.print_progress(i, nb_fiscal_position_files, file.path)

        module_name = file.path.parts[-4]
        csv_file = csv.DictReader(file.content.splitlines())
        csv_data = list(csv_file)
        field_names = csv_file.fieldnames
        if SRC_FIELD not in field_names or DEST_FIELD not in field_names:
            log.warning("No src and dest fields in %s...skipping", file.path.parts[-1])
            continue

        has_country = 'country_id' in field_names

        buffer = StringIO()
        writer = csv.DictWriter(
            buffer,
            fieldnames=[
                f
                for f in field_names + ([] if has_country else ['country_id'])
                if f not in (SRC_FIELD, DEST_FIELD)
            ],
            delimiter=',',
            quotechar='"',
            quoting=csv.QUOTE_ALL,
            lineterminator='\n',
        )
        writer.writeheader()

        domestic_fp_id = f'{module_name}_domestic_fiscal_position'
        module_country = module_name[5:7] if module_name.startswith('l10n_') else 'us'
        domestic_fp_name = f'{module_country.upper()} Domestic'
        coa_name = file.path.parts[-1].split("position-")[1].replace(".csv", "")
        fiscal_position = ''
        for row_nb, row in enumerate(csv_data, start=1):
            fiscal_position = row['id'] or fiscal_position
            if row.get('country_group_id') == 'account.europe_vat' and row.get('auto_apply') and not row.get('country_id') and not row.get('vat_required'):
                eu_b2c_fps[module_country] = fiscal_position

            src_tax = row.pop(SRC_FIELD)
            dest_tax = row.pop(DEST_FIELD)
            if row_nb == 1:
                # copy the first fiscal position to create a generic domestic fiscal position
                # if the first fiscal position doesn't have a country matching the module
                # otherwise assume the first one is the domestic fp
                dom_fp_data = {
                    **row,
                    'id': domestic_fp_id,
                    'name': domestic_fp_name,
                }
                if (
                    module_name not in MODS_WITH_DYNAMIC_DOMESTIC_FP
                    and module_name not in DEFINED_DOMESTIC_FP
                    and (not has_country or row.get('country_id') != f'base.{module_country}')
                ):
                    dom_fp_data['country_id'] = f'base.{module_country}'
                    writer.writerow(dom_fp_data)
                else:
                    domestic_fp_id = DEFINED_DOMESTIC_FP.get(module_name) or row['id']

            if src_tax and dest_tax:
                existing_src_tax_fp = tax_positions[module_name][coa_name][src_tax]['fp']
                if existing_src_tax_fp and domestic_fp_id not in existing_src_tax_fp:
                    log.info("In module: %s, Src Tax: %s will be assigned to multiple Fiscal Positions: %s.", module_name, src_tax, f"{','.join(existing_src_tax_fp)},{domestic_fp_id}")
                if module_name not in MODS_WITH_DYNAMIC_DOMESTIC_FP:
                    tax_positions[module_name][coa_name][src_tax]['fp'].add(domestic_fp_id)
                    if eub2c_position := eu_b2c_fps.get(module_country):
                        tax_positions[module_name][coa_name][src_tax]['fp'].add(eub2c_position)

                existing_dest_tax_fp = tax_positions[module_name][coa_name][dest_tax]['fp']
                if existing_dest_tax_fp and fiscal_position not in existing_dest_tax_fp:
                    log.info("In module: %s, Dest Tax: %s will be assigned to multiple Fiscal Positions: %s.", module_name, dest_tax, f"{','.join(existing_dest_tax_fp)},{fiscal_position}")
                tax_positions[module_name][coa_name][dest_tax]['fp'].add(fiscal_position)

                tax_positions[module_name][coa_name][dest_tax]['replaces'].add(src_tax)
                if row['id']:
                    writer.writerow(row)
            else:
                if src_tax:
                    log.warning("%s tax in module %s is mapped to nothing", src_tax, module_name)
                writer.writerow(row)

        file.content = buffer.getvalue()

    for i, file in enumerate(tax_data_files, start=1):
        file_manager.print_progress(i, nb_tax_files, file.path)

        module_name = file.path.parts[-4]
        coa_name = file.path.parts[-1].split("tax-")[1].replace(".csv", "")
        csv_file = csv.DictReader(file.content.splitlines())
        csv_data = list(csv_file)
        if (fpfile := f'account.fiscal.position-{coa_name}.csv') and fpfile not in fiscal_position_file_names:
            log.warning("Missing fiscal position file %s while processing %s", fpfile, module_name)
        is_primary_tax = 'name' in csv_file.fieldnames
        buffer = StringIO()
        writer = csv.DictWriter(
            buffer,
            fieldnames=[fn for fn in csv_file.fieldnames if fn] + (['fiscal_position_ids', 'original_tax_ids'] if is_primary_tax else []),
            delimiter=',',
            quotechar='"',
            quoting=csv.QUOTE_ALL,
            lineterminator='\n',
            extrasaction='ignore',
        )
        writer.writeheader()
        for tax_row in csv_data:
            tax_id = tax_row['id']
            if tax_id and is_primary_tax:
                tax_info = tax_positions[module_name][coa_name][tax_id] if tax_id else {}
                new_fp = ','.join(tax_info.get('fp', []))
                new_alts = ','.join(tax_info.get('replaces', []))
                if not new_fp:
                    new_fp = FP_LOOKUP.get((coa_name, tax_id), "")
                writer.writerow({
                    **tax_row,
                    'fiscal_position_ids': new_fp,
                    'original_tax_ids': new_alts,
                })
            else:
                writer.writerow(tax_row)
        file.content = buffer.getvalue()
