# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.
# pylint: disable=C0302

"""
The EU_TAX_MAP dictionary contains a basic Tax Mapping for EU countries. It answers the question:
for an X% tax rate in the domestic country, what is the corresponding rate in a foreign EU country?

it takes the form tuple: rate, where
    (Fiscal Country Code, Domestic Tax Rate, Foreign Country Code): Foreign Tax Rate
"""

EU_TAX_MAP = {
    ('AT', 10.0, 'BE'): 6.0,
    ('AT', 10.0, 'BG'): 20.0,
    ('AT', 10.0, 'CY'): 5.0,
    ('AT', 10.0, 'CZ'): 12.0,
    ('AT', 10.0, 'DE'): 7.0,
    ('AT', 10.0, 'DK'): 25.0,
    ('AT', 10.0, 'EE'): 9.0,
    ('AT', 10.0, 'ES'): 10.0,
    ('AT', 10.0, 'FI'): 10.0,
    ('AT', 10.0, 'FR'): 5.5,
    ('AT', 10.0, 'GR'): 13.0,
    ('AT', 10.0, 'HR'): 5.0,
    ('AT', 10.0, 'HU'): 5.0,
    ('AT', 10.0, 'IE'): 13.5,
    ('AT', 10.0, 'IT'): 4.0,
    ('AT', 10.0, 'LT'): 5.0,
    ('AT', 10.0, 'LU'): 8.0,
    ('AT', 10.0, 'LV'): 12.0,
    ('AT', 10.0, 'MT'): 5.0,
    ('AT', 10.0, 'NL'): 9.0,
    ('AT', 10.0, 'PL'): 8.0,
    ('AT', 10.0, 'PT'): 6.0,
    ('AT', 10.0, 'RO'): 11.0,
    ('AT', 10.0, 'SE'): 6.0,
    ('AT', 10.0, 'SI'): 9.5,
    ('AT', 10.0, 'SK'): 19.0,
    ('AT', 13.0, 'BE'): 21.0,
    ('AT', 13.0, 'BG'): 20.0,
    ('AT', 13.0, 'CY'): 19.0,
    ('AT', 13.0, 'CZ'): 21.0,
    ('AT', 13.0, 'DE'): 19.0,
    ('AT', 13.0, 'DK'): 25.0,
    ('AT', 13.0, 'EE'): 22.0,
    ('AT', 13.0, 'ES'): 21.0,
    ('AT', 13.0, 'FI'): 25.5,
    ('AT', 13.0, 'FR'): 20.0,
    ('AT', 13.0, 'GR'): 24.0,
    ('AT', 13.0, 'HR'): 25.0,
    ('AT', 13.0, 'HU'): 27.0,
    ('AT', 13.0, 'IE'): 23.0,
    ('AT', 13.0, 'IT'): 22.0,
    ('AT', 13.0, 'LT'): 21.0,
    ('AT', 13.0, 'LU'): 17.0,
    ('AT', 13.0, 'LV'): 21.0,
    ('AT', 13.0, 'MT'): 18.0,
    ('AT', 13.0, 'NL'): 21.0,
    ('AT', 13.0, 'PL'): 23.0,
    ('AT', 13.0, 'PT'): 23.0,
    ('AT', 13.0, 'RO'): 21.0,
    ('AT', 13.0, 'SE'): 25.0,
    ('AT', 13.0, 'SI'): 22.0,
    ('AT', 13.0, 'SK'): 23.0,
    ('AT', 20.0, 'BE'): 21.0,
    ('AT', 20.0, 'BG'): 20.0,
    ('AT', 20.0, 'CY'): 19.0,
    ('AT', 20.0, 'CZ'): 21.0,
    ('AT', 20.0, 'DE'): 19.0,
    ('AT', 20.0, 'DK'): 25.0,
    ('AT', 20.0, 'EE'): 22.0,
    ('AT', 20.0, 'ES'): 21.0,
    ('AT', 20.0, 'FI'): 25.5,
    ('AT', 20.0, 'FR'): 20.0,
    ('AT', 20.0, 'GR'): 24.0,
    ('AT', 20.0, 'HR'): 25.0,
    ('AT', 20.0, 'HU'): 27.0,
    ('AT', 20.0, 'IE'): 23.0,
    ('AT', 20.0, 'IT'): 22.0,
    ('AT', 20.0, 'LT'): 21.0,
    ('AT', 20.0, 'LU'): 17.0,
    ('AT', 20.0, 'LV'): 21.0,
    ('AT', 20.0, 'MT'): 18.0,
    ('AT', 20.0, 'NL'): 21.0,
    ('AT', 20.0, 'PL'): 23.0,
    ('AT', 20.0, 'PT'): 23.0,
    ('AT', 20.0, 'RO'): 21.0,
    ('AT', 20.0, 'SE'): 25.0,
    ('AT', 20.0, 'SI'): 22.0,
    ('AT', 20.0, 'SK'): 23.0,
    ('BE', 12.0, 'AT'): 20.0,
    ('BE', 12.0, 'BG'): 20.0,
    ('BE', 12.0, 'CY'): 19.0,
    ('BE', 12.0, 'CZ'): 21.0,
    ('BE', 12.0, 'DE'): 19.0,
    ('BE', 12.0, 'DK'): 25.0,
    ('BE', 12.0, 'EE'): 22.0,
    ('BE', 12.0, 'ES'): 21.0,
    ('BE', 12.0, 'FI'): 25.5,
    ('BE', 12.0, 'FR'): 20.0,
    ('BE', 12.0, 'GR'): 24.0,
    ('BE', 12.0, 'HR'): 25.0,
    ('BE', 12.0, 'HU'): 27.0,
    ('BE', 12.0, 'IE'): 23.0,
    ('BE', 12.0, 'IT'): 22.0,
    ('BE', 12.0, 'LT'): 21.0,
    ('BE', 12.0, 'LU'): 17.0,
    ('BE', 12.0, 'LV'): 21.0,
    ('BE', 12.0, 'MT'): 18.0,
    ('BE', 12.0, 'NL'): 21.0,
    ('BE', 12.0, 'PL'): 23.0,
    ('BE', 12.0, 'PT'): 23.0,
    ('BE', 12.0, 'RO'): 21.0,
    ('BE', 12.0, 'SE'): 25.0,
    ('BE', 12.0, 'SI'): 22.0,
    ('BE', 12.0, 'SK'): 23.0,
    ('BE', 21.0, 'AT'): 20.0,
    ('BE', 21.0, 'BG'): 20.0,
    ('BE', 21.0, 'CY'): 19.0,
    ('BE', 21.0, 'CZ'): 21.0,
    ('BE', 21.0, 'DE'): 19.0,
    ('BE', 21.0, 'DK'): 25.0,
    ('BE', 21.0, 'EE'): 22.0,
    ('BE', 21.0, 'ES'): 21.0,
    ('BE', 21.0, 'FI'): 25.5,
    ('BE', 21.0, 'FR'): 20.0,
    ('BE', 21.0, 'GR'): 24.0,
    ('BE', 21.0, 'HR'): 25.0,
    ('BE', 21.0, 'HU'): 27.0,
    ('BE', 21.0, 'IE'): 23.0,
    ('BE', 21.0, 'IT'): 22.0,
    ('BE', 21.0, 'LT'): 21.0,
    ('BE', 21.0, 'LU'): 17.0,
    ('BE', 21.0, 'LV'): 21.0,
    ('BE', 21.0, 'MT'): 18.0,
    ('BE', 21.0, 'NL'): 21.0,
    ('BE', 21.0, 'PL'): 23.0,
    ('BE', 21.0, 'PT'): 23.0,
    ('BE', 21.0, 'RO'): 21.0,
    ('BE', 21.0, 'SE'): 25.0,
    ('BE', 21.0, 'SI'): 22.0,
    ('BE', 21.0, 'SK'): 23.0,
    ('BE', 6.0, 'AT'): 10.0,
    ('BE', 6.0, 'BG'): 20.0,
    ('BE', 6.0, 'CY'): 5.0,
    ('BE', 6.0, 'CZ'): 12.0,
    ('BE', 6.0, 'DE'): 7.0,
    ('BE', 6.0, 'DK'): 25.0,
    ('BE', 6.0, 'EE'): 9.0,
    ('BE', 6.0, 'ES'): 10.0,
    ('BE', 6.0, 'FI'): 10.0,
    ('BE', 6.0, 'FR'): 5.5,
    ('BE', 6.0, 'GR'): 13.0,
    ('BE', 6.0, 'HR'): 5.0,
    ('BE', 6.0, 'HU'): 5.0,
    ('BE', 6.0, 'IE'): 13.5,
    ('BE', 6.0, 'IT'): 4.0,
    ('BE', 6.0, 'LT'): 5.0,
    ('BE', 6.0, 'LU'): 8.0,
    ('BE', 6.0, 'LV'): 12.0,
    ('BE', 6.0, 'MT'): 5.0,
    ('BE', 6.0, 'NL'): 9.0,
    ('BE', 6.0, 'PL'): 8.0,
    ('BE', 6.0, 'PT'): 6.0,
    ('BE', 6.0, 'RO'): 11.0,
    ('BE', 6.0, 'SE'): 6.0,
    ('BE', 6.0, 'SI'): 9.5,
    ('BE', 6.0, 'SK'): 19.0,
    ('BG', 20.0, 'AT'): 20.0,
    ('BG', 20.0, 'BE'): 21.0,
    ('BG', 20.0, 'CY'): 19.0,
    ('BG', 20.0, 'CZ'): 21.0,
    ('BG', 20.0, 'DE'): 19.0,
    ('BG', 20.0, 'DK'): 25.0,
    ('BG', 20.0, 'EE'): 22.0,
    ('BG', 20.0, 'ES'): 21.0,
    ('BG', 20.0, 'FI'): 25.5,
    ('BG', 20.0, 'FR'): 20.0,
    ('BG', 20.0, 'GR'): 24.0,
    ('BG', 20.0, 'HR'): 25.0,
    ('BG', 20.0, 'HU'): 27.0,
    ('BG', 20.0, 'IE'): 23.0,
    ('BG', 20.0, 'IT'): 22.0,
    ('BG', 20.0, 'LT'): 21.0,
    ('BG', 20.0, 'LU'): 17.0,
    ('BG', 20.0, 'LV'): 21.0,
    ('BG', 20.0, 'MT'): 18.0,
    ('BG', 20.0, 'NL'): 21.0,
    ('BG', 20.0, 'PL'): 23.0,
    ('BG', 20.0, 'PT'): 23.0,
    ('BG', 20.0, 'RO'): 21.0,
    ('BG', 20.0, 'SE'): 25.0,
    ('BG', 20.0, 'SI'): 22.0,
    ('BG', 20.0, 'SK'): 23.0,
    ('BG', 9.0, 'AT'): 10.0,
    ('BG', 9.0, 'BE'): 6.0,
    ('BG', 9.0, 'CY'): 5.0,
    ('BG', 9.0, 'CZ'): 12.0,
    ('BG', 9.0, 'DE'): 7.0,
    ('BG', 9.0, 'DK'): 25.0,
    ('BG', 9.0, 'EE'): 9.0,
    ('BG', 9.0, 'ES'): 10.0,
    ('BG', 9.0, 'FI'): 10.0,
    ('BG', 9.0, 'FR'): 5.5,
    ('BG', 9.0, 'GR'): 13.0,
    ('BG', 9.0, 'HR'): 5.0,
    ('BG', 9.0, 'HU'): 5.0,
    ('BG', 9.0, 'IE'): 13.5,
    ('BG', 9.0, 'IT'): 4.0,
    ('BG', 9.0, 'LT'): 5.0,
    ('BG', 9.0, 'LU'): 8.0,
    ('BG', 9.0, 'LV'): 12.0,
    ('BG', 9.0, 'MT'): 5.0,
    ('BG', 9.0, 'NL'): 9.0,
    ('BG', 9.0, 'PL'): 8.0,
    ('BG', 9.0, 'PT'): 6.0,
    ('BG', 9.0, 'RO'): 11.0,
    ('BG', 9.0, 'SE'): 6.0,
    ('BG', 9.0, 'SI'): 9.5,
    ('BG', 9.0, 'SK'): 19.0,
    ('CY', 19.0, 'AT'): 20.0,
    ('CY', 19.0, 'BE'): 21.0,
    ('CY', 19.0, 'BG'): 20.0,
    ('CY', 19.0, 'CZ'): 21.0,
    ('CY', 19.0, 'DE'): 19.0,
    ('CY', 19.0, 'DK'): 25.0,
    ('CY', 19.0, 'EE'): 22.0,
    ('CY', 19.0, 'ES'): 21.0,
    ('CY', 19.0, 'FI'): 25.5,
    ('CY', 19.0, 'FR'): 20.0,
    ('CY', 19.0, 'GR'): 24.0,
    ('CY', 19.0, 'HR'): 25.0,
    ('CY', 19.0, 'HU'): 27.0,
    ('CY', 19.0, 'IE'): 23.0,
    ('CY', 19.0, 'IT'): 22.0,
    ('CY', 19.0, 'LT'): 21.0,
    ('CY', 19.0, 'LU'): 17.0,
    ('CY', 19.0, 'LV'): 21.0,
    ('CY', 19.0, 'MT'): 18.0,
    ('CY', 19.0, 'NL'): 21.0,
    ('CY', 19.0, 'PL'): 23.0,
    ('CY', 19.0, 'PT'): 23.0,
    ('CY', 19.0, 'RO'): 21.0,
    ('CY', 19.0, 'SE'): 25.0,
    ('CY', 19.0, 'SI'): 22.0,
    ('CY', 19.0, 'SK'): 23.0,
    ('CY', 5.0, 'AT'): 10.0,
    ('CY', 5.0, 'BE'): 6.0,
    ('CY', 5.0, 'BG'): 20.0,
    ('CY', 5.0, 'CZ'): 12.0,
    ('CY', 5.0, 'DE'): 7.0,
    ('CY', 5.0, 'DK'): 25.0,
    ('CY', 5.0, 'EE'): 9.0,
    ('CY', 5.0, 'ES'): 10.0,
    ('CY', 5.0, 'FI'): 10.0,
    ('CY', 5.0, 'FR'): 5.5,
    ('CY', 5.0, 'GR'): 13.0,
    ('CY', 5.0, 'HR'): 5.0,
    ('CY', 5.0, 'HU'): 5.0,
    ('CY', 5.0, 'IE'): 13.5,
    ('CY', 5.0, 'IT'): 4.0,
    ('CY', 5.0, 'LT'): 5.0,
    ('CY', 5.0, 'LU'): 8.0,
    ('CY', 5.0, 'LV'): 12.0,
    ('CY', 5.0, 'MT'): 5.0,
    ('CY', 5.0, 'NL'): 9.0,
    ('CY', 5.0, 'PL'): 8.0,
    ('CY', 5.0, 'PT'): 6.0,
    ('CY', 5.0, 'RO'): 11.0,
    ('CY', 5.0, 'SE'): 6.0,
    ('CY', 5.0, 'SI'): 9.5,
    ('CY', 5.0, 'SK'): 19.0,
    ('CY', 9.0, 'AT'): 10.0,
    ('CY', 9.0, 'BE'): 6.0,
    ('CY', 9.0, 'BG'): 20.0,
    ('CY', 9.0, 'CZ'): 12.0,
    ('CY', 9.0, 'DE'): 7.0,
    ('CY', 9.0, 'DK'): 25.0,
    ('CY', 9.0, 'EE'): 9.0,
    ('CY', 9.0, 'ES'): 10.0,
    ('CY', 9.0, 'FI'): 10.0,
    ('CY', 9.0, 'FR'): 5.5,
    ('CY', 9.0, 'GR'): 13.0,
    ('CY', 9.0, 'HR'): 13.0,
    ('CY', 9.0, 'HU'): 5.0,
    ('CY', 9.0, 'IE'): 13.5,
    ('CY', 9.0, 'IT'): 10.0,
    ('CY', 9.0, 'LT'): 5.0,
    ('CY', 9.0, 'LU'): 8.0,
    ('CY', 9.0, 'LV'): 12.0,
    ('CY', 9.0, 'MT'): 5.0,
    ('CY', 9.0, 'NL'): 9.0,
    ('CY', 9.0, 'PL'): 8.0,
    ('CY', 9.0, 'PT'): 6.0,
    ('CY', 9.0, 'RO'): 11.0,
    ('CY', 9.0, 'SE'): 6.0,
    ('CY', 9.0, 'SI'): 9.5,
    ('CY', 9.0, 'SK'): 19.0,
    ('CZ', 10.0, 'AT'): 10.0,
    ('CZ', 10.0, 'BE'): 6.0,
    ('CZ', 10.0, 'BG'): 20.0,
    ('CZ', 10.0, 'CY'): 5.0,
    ('CZ', 10.0, 'DE'): 7.0,
    ('CZ', 10.0, 'DK'): 25.0,
    ('CZ', 10.0, 'EE'): 9.0,
    ('CZ', 10.0, 'ES'): 10.0,
    ('CZ', 10.0, 'FI'): 10.0,
    ('CZ', 10.0, 'FR'): 5.5,
    ('CZ', 10.0, 'GR'): 13.0,
    ('CZ', 10.0, 'HR'): 5.0,
    ('CZ', 10.0, 'HU'): 5.0,
    ('CZ', 10.0, 'IE'): 13.5,
    ('CZ', 10.0, 'IT'): 4.0,
    ('CZ', 10.0, 'LT'): 5.0,
    ('CZ', 10.0, 'LU'): 8.0,
    ('CZ', 10.0, 'LV'): 12.0,
    ('CZ', 10.0, 'MT'): 5.0,
    ('CZ', 10.0, 'NL'): 9.0,
    ('CZ', 10.0, 'PL'): 8.0,
    ('CZ', 10.0, 'PT'): 6.0,
    ('CZ', 10.0, 'RO'): 11.0,
    ('CZ', 10.0, 'SE'): 6.0,
    ('CZ', 10.0, 'SI'): 9.5,
    ('CZ', 10.0, 'SK'): 19.0,
    ('CZ', 12.0, 'AT'): 10.0,
    ('CZ', 12.0, 'BE'): 6.0,
    ('CZ', 12.0, 'BG'): 20.0,
    ('CZ', 12.0, 'CY'): 5.0,
    ('CZ', 12.0, 'DE'): 7.0,
    ('CZ', 12.0, 'DK'): 25.0,
    ('CZ', 12.0, 'EE'): 9.0,
    ('CZ', 12.0, 'ES'): 10.0,
    ('CZ', 12.0, 'FI'): 10.0,
    ('CZ', 12.0, 'FR'): 5.5,
    ('CZ', 12.0, 'GR'): 13.0,
    ('CZ', 12.0, 'HR'): 13.0,
    ('CZ', 12.0, 'HU'): 5.0,
    ('CZ', 12.0, 'IE'): 13.5,
    ('CZ', 12.0, 'IT'): 10.0,
    ('CZ', 12.0, 'LT'): 5.0,
    ('CZ', 12.0, 'LU'): 8.0,
    ('CZ', 12.0, 'LV'): 12.0,
    ('CZ', 12.0, 'MT'): 5.0,
    ('CZ', 12.0, 'NL'): 9.0,
    ('CZ', 12.0, 'PL'): 8.0,
    ('CZ', 12.0, 'PT'): 6.0,
    ('CZ', 12.0, 'RO'): 11.0,
    ('CZ', 12.0, 'SE'): 6.0,
    ('CZ', 12.0, 'SI'): 9.5,
    ('CZ', 12.0, 'SK'): 19.0,
    ('CZ', 15.0, 'AT'): 10.0,
    ('CZ', 15.0, 'BE'): 6.0,
    ('CZ', 15.0, 'BG'): 20.0,
    ('CZ', 15.0, 'CY'): 5.0,
    ('CZ', 15.0, 'DE'): 7.0,
    ('CZ', 15.0, 'DK'): 25.0,
    ('CZ', 15.0, 'EE'): 9.0,
    ('CZ', 15.0, 'ES'): 10.0,
    ('CZ', 15.0, 'FI'): 10.0,
    ('CZ', 15.0, 'FR'): 5.5,
    ('CZ', 15.0, 'GR'): 13.0,
    ('CZ', 15.0, 'HR'): 13.0,
    ('CZ', 15.0, 'HU'): 5.0,
    ('CZ', 15.0, 'IE'): 13.5,
    ('CZ', 15.0, 'IT'): 10.0,
    ('CZ', 15.0, 'LT'): 5.0,
    ('CZ', 15.0, 'LU'): 8.0,
    ('CZ', 15.0, 'LV'): 12.0,
    ('CZ', 15.0, 'MT'): 5.0,
    ('CZ', 15.0, 'NL'): 9.0,
    ('CZ', 15.0, 'PL'): 8.0,
    ('CZ', 15.0, 'PT'): 6.0,
    ('CZ', 15.0, 'RO'): 11.0,
    ('CZ', 15.0, 'SE'): 6.0,
    ('CZ', 15.0, 'SI'): 9.5,
    ('CZ', 15.0, 'SK'): 19.0,
    ('CZ', 21.0, 'AT'): 20.0,
    ('CZ', 21.0, 'BE'): 21.0,
    ('CZ', 21.0, 'BG'): 20.0,
    ('CZ', 21.0, 'CY'): 19.0,
    ('CZ', 21.0, 'DE'): 19.0,
    ('CZ', 21.0, 'DK'): 25.0,
    ('CZ', 21.0, 'EE'): 22.0,
    ('CZ', 21.0, 'ES'): 21.0,
    ('CZ', 21.0, 'FI'): 25.5,
    ('CZ', 21.0, 'FR'): 20.0,
    ('CZ', 21.0, 'GR'): 24.0,
    ('CZ', 21.0, 'HR'): 25.0,
    ('CZ', 21.0, 'HU'): 27.0,
    ('CZ', 21.0, 'IE'): 23.0,
    ('CZ', 21.0, 'IT'): 22.0,
    ('CZ', 21.0, 'LT'): 21.0,
    ('CZ', 21.0, 'LU'): 17.0,
    ('CZ', 21.0, 'LV'): 21.0,
    ('CZ', 21.0, 'MT'): 18.0,
    ('CZ', 21.0, 'NL'): 21.0,
    ('CZ', 21.0, 'PL'): 23.0,
    ('CZ', 21.0, 'PT'): 23.0,
    ('CZ', 21.0, 'RO'): 21.0,
    ('CZ', 21.0, 'SE'): 25.0,
    ('CZ', 21.0, 'SI'): 22.0,
    ('CZ', 21.0, 'SK'): 23.0,
    ('DE', 19.0, 'AT'): 20.0,
    ('DE', 19.0, 'BE'): 21.0,
    ('DE', 19.0, 'BG'): 20.0,
    ('DE', 19.0, 'CY'): 19.0,
    ('DE', 19.0, 'CZ'): 21.0,
    ('DE', 19.0, 'DK'): 25.0,
    ('DE', 19.0, 'EE'): 22.0,
    ('DE', 19.0, 'ES'): 21.0,
    ('DE', 19.0, 'FI'): 25.5,
    ('DE', 19.0, 'FR'): 20.0,
    ('DE', 19.0, 'GR'): 24.0,
    ('DE', 19.0, 'HR'): 25.0,
    ('DE', 19.0, 'HU'): 27.0,
    ('DE', 19.0, 'IE'): 23.0,
    ('DE', 19.0, 'IT'): 22.0,
    ('DE', 19.0, 'LT'): 21.0,
    ('DE', 19.0, 'LU'): 17.0,
    ('DE', 19.0, 'LV'): 21.0,
    ('DE', 19.0, 'MT'): 18.0,
    ('DE', 19.0, 'NL'): 21.0,
    ('DE', 19.0, 'PL'): 23.0,
    ('DE', 19.0, 'PT'): 23.0,
    ('DE', 19.0, 'RO'): 21.0,
    ('DE', 19.0, 'SE'): 25.0,
    ('DE', 19.0, 'SI'): 22.0,
    ('DE', 19.0, 'SK'): 23.0,
    ('DE', 7.0, 'AT'): 10.0,
    ('DE', 7.0, 'BE'): 6.0,
    ('DE', 7.0, 'BG'): 20.0,
    ('DE', 7.0, 'CY'): 5.0,
    ('DE', 7.0, 'CZ'): 12.0,
    ('DE', 7.0, 'DK'): 25.0,
    ('DE', 7.0, 'EE'): 9.0,
    ('DE', 7.0, 'ES'): 10.0,
    ('DE', 7.0, 'FI'): 10.0,
    ('DE', 7.0, 'FR'): 5.5,
    ('DE', 7.0, 'GR'): 13.0,
    ('DE', 7.0, 'HR'): 5.0,
    ('DE', 7.0, 'HU'): 5.0,
    ('DE', 7.0, 'IE'): 13.5,
    ('DE', 7.0, 'IT'): 4.0,
    ('DE', 7.0, 'LT'): 5.0,
    ('DE', 7.0, 'LU'): 8.0,
    ('DE', 7.0, 'LV'): 12.0,
    ('DE', 7.0, 'MT'): 5.0,
    ('DE', 7.0, 'NL'): 9.0,
    ('DE', 7.0, 'PL'): 8.0,
    ('DE', 7.0, 'PT'): 6.0,
    ('DE', 7.0, 'RO'): 11.0,
    ('DE', 7.0, 'SE'): 6.0,
    ('DE', 7.0, 'SI'): 9.5,
    ('DE', 7.0, 'SK'): 19.0,
    ('DK', 25.0, 'AT'): 20.0,
    ('DK', 25.0, 'BE'): 21.0,
    ('DK', 25.0, 'BG'): 20.0,
    ('DK', 25.0, 'CY'): 19.0,
    ('DK', 25.0, 'CZ'): 21.0,
    ('DK', 25.0, 'DE'): 19.0,
    ('DK', 25.0, 'EE'): 22.0,
    ('DK', 25.0, 'ES'): 21.0,
    ('DK', 25.0, 'FI'): 25.5,
    ('DK', 25.0, 'FR'): 20.0,
    ('DK', 25.0, 'GR'): 24.0,
    ('DK', 25.0, 'HR'): 25.0,
    ('DK', 25.0, 'HU'): 27.0,
    ('DK', 25.0, 'IE'): 23.0,
    ('DK', 25.0, 'IT'): 22.0,
    ('DK', 25.0, 'LT'): 21.0,
    ('DK', 25.0, 'LU'): 17.0,
    ('DK', 25.0, 'LV'): 21.0,
    ('DK', 25.0, 'MT'): 18.0,
    ('DK', 25.0, 'NL'): 21.0,
    ('DK', 25.0, 'PL'): 23.0,
    ('DK', 25.0, 'PT'): 23.0,
    ('DK', 25.0, 'RO'): 21.0,
    ('DK', 25.0, 'SE'): 25.0,
    ('DK', 25.0, 'SI'): 22.0,
    ('DK', 25.0, 'SK'): 23.0,
    ('EE', 22.0, 'AT'): 20.0,
    ('EE', 22.0, 'BE'): 21.0,
    ('EE', 22.0, 'BG'): 20.0,
    ('EE', 22.0, 'CY'): 19.0,
    ('EE', 22.0, 'CZ'): 21.0,
    ('EE', 22.0, 'DE'): 19.0,
    ('EE', 22.0, 'DK'): 25.0,
    ('EE', 22.0, 'ES'): 21.0,
    ('EE', 22.0, 'FI'): 25.5,
    ('EE', 22.0, 'FR'): 20.0,
    ('EE', 22.0, 'GR'): 24.0,
    ('EE', 22.0, 'HR'): 25.0,
    ('EE', 22.0, 'HU'): 27.0,
    ('EE', 22.0, 'IE'): 23.0,
    ('EE', 22.0, 'IT'): 22.0,
    ('EE', 22.0, 'LT'): 21.0,
    ('EE', 22.0, 'LU'): 17.0,
    ('EE', 22.0, 'LV'): 21.0,
    ('EE', 22.0, 'MT'): 18.0,
    ('EE', 22.0, 'NL'): 21.0,
    ('EE', 22.0, 'PL'): 23.0,
    ('EE', 22.0, 'PT'): 23.0,
    ('EE', 22.0, 'RO'): 21.0,
    ('EE', 22.0, 'SE'): 25.0,
    ('EE', 22.0, 'SI'): 22.0,
    ('EE', 22.0, 'SK'): 23.0,
    ('EE', 20.0, 'AT'): 20.0,
    ('EE', 20.0, 'BE'): 21.0,
    ('EE', 20.0, 'BG'): 20.0,
    ('EE', 20.0, 'CY'): 19.0,
    ('EE', 20.0, 'CZ'): 21.0,
    ('EE', 20.0, 'DE'): 19.0,
    ('EE', 20.0, 'DK'): 25.0,
    ('EE', 20.0, 'ES'): 21.0,
    ('EE', 20.0, 'FI'): 25.5,
    ('EE', 20.0, 'FR'): 20.0,
    ('EE', 20.0, 'GR'): 24.0,
    ('EE', 20.0, 'HR'): 25.0,
    ('EE', 20.0, 'HU'): 27.0,
    ('EE', 20.0, 'IE'): 23.0,
    ('EE', 20.0, 'IT'): 22.0,
    ('EE', 20.0, 'LT'): 21.0,
    ('EE', 20.0, 'LU'): 17.0,
    ('EE', 20.0, 'LV'): 21.0,
    ('EE', 20.0, 'MT'): 18.0,
    ('EE', 20.0, 'NL'): 21.0,
    ('EE', 20.0, 'PL'): 23.0,
    ('EE', 20.0, 'PT'): 23.0,
    ('EE', 20.0, 'RO'): 21.0,
    ('EE', 20.0, 'SE'): 25.0,
    ('EE', 20.0, 'SI'): 22.0,
    ('EE', 20.0, 'SK'): 23.0,
    ('EE', 9.0, 'AT'): 10.0,
    ('EE', 9.0, 'BE'): 6.0,
    ('EE', 9.0, 'BG'): 20.0,
    ('EE', 9.0, 'CY'): 5.0,
    ('EE', 9.0, 'CZ'): 12.0,
    ('EE', 9.0, 'DE'): 7.0,
    ('EE', 9.0, 'DK'): 25.0,
    ('EE', 9.0, 'ES'): 10.0,
    ('EE', 9.0, 'FI'): 10.0,
    ('EE', 9.0, 'FR'): 5.5,
    ('EE', 9.0, 'GR'): 13.0,
    ('EE', 9.0, 'HR'): 5.0,
    ('EE', 9.0, 'HU'): 5.0,
    ('EE', 9.0, 'IE'): 13.5,
    ('EE', 9.0, 'IT'): 4.0,
    ('EE', 9.0, 'LT'): 5.0,
    ('EE', 9.0, 'LU'): 8.0,
    ('EE', 9.0, 'LV'): 12.0,
    ('EE', 9.0, 'MT'): 5.0,
    ('EE', 9.0, 'NL'): 9.0,
    ('EE', 9.0, 'PL'): 8.0,
    ('EE', 9.0, 'PT'): 6.0,
    ('EE', 9.0, 'RO'): 11.0,
    ('EE', 9.0, 'SE'): 6.0,
    ('EE', 9.0, 'SI'): 9.5,
    ('EE', 9.0, 'SK'): 19.0,
    ('ES', 10.0, 'AT'): 10.0,
    ('ES', 10.0, 'BE'): 6.0,
    ('ES', 10.0, 'BG'): 20.0,
    ('ES', 10.0, 'CY'): 5.0,
    ('ES', 10.0, 'CZ'): 12.0,
    ('ES', 10.0, 'DE'): 7.0,
    ('ES', 10.0, 'DK'): 25.0,
    ('ES', 10.0, 'EE'): 9.0,
    ('ES', 10.0, 'FI'): 10.0,
    ('ES', 10.0, 'FR'): 5.5,
    ('ES', 10.0, 'GR'): 13.0,
    ('ES', 10.0, 'HR'): 13.0,
    ('ES', 10.0, 'HU'): 5.0,
    ('ES', 10.0, 'IE'): 13.5,
    ('ES', 10.0, 'IT'): 10.0,
    ('ES', 10.0, 'LT'): 5.0,
    ('ES', 10.0, 'LU'): 8.0,
    ('ES', 10.0, 'LV'): 12.0,
    ('ES', 10.0, 'MT'): 5.0,
    ('ES', 10.0, 'NL'): 9.0,
    ('ES', 10.0, 'PL'): 8.0,
    ('ES', 10.0, 'PT'): 6.0,
    ('ES', 10.0, 'RO'): 11.0,
    ('ES', 10.0, 'SE'): 6.0,
    ('ES', 10.0, 'SI'): 9.5,
    ('ES', 10.0, 'SK'): 19.0,
    ('ES', 21.0, 'AT'): 20.0,
    ('ES', 21.0, 'BE'): 21.0,
    ('ES', 21.0, 'BG'): 20.0,
    ('ES', 21.0, 'CY'): 19.0,
    ('ES', 21.0, 'CZ'): 21.0,
    ('ES', 21.0, 'DE'): 19.0,
    ('ES', 21.0, 'DK'): 25.0,
    ('ES', 21.0, 'EE'): 22.0,
    ('ES', 21.0, 'FI'): 25.5,
    ('ES', 21.0, 'FR'): 20.0,
    ('ES', 21.0, 'GR'): 24.0,
    ('ES', 21.0, 'HR'): 25.0,
    ('ES', 21.0, 'HU'): 27.0,
    ('ES', 21.0, 'IE'): 23.0,
    ('ES', 21.0, 'IT'): 22.0,
    ('ES', 21.0, 'LT'): 21.0,
    ('ES', 21.0, 'LU'): 17.0,
    ('ES', 21.0, 'LV'): 21.0,
    ('ES', 21.0, 'MT'): 18.0,
    ('ES', 21.0, 'NL'): 21.0,
    ('ES', 21.0, 'PL'): 23.0,
    ('ES', 21.0, 'PT'): 23.0,
    ('ES', 21.0, 'RO'): 21.0,
    ('ES', 21.0, 'SE'): 25.0,
    ('ES', 21.0, 'SI'): 22.0,
    ('ES', 21.0, 'SK'): 23.0,
    ('ES', 4.0, 'AT'): 10.0,
    ('ES', 4.0, 'BE'): 6.0,
    ('ES', 4.0, 'BG'): 20.0,
    ('ES', 4.0, 'CY'): 5.0,
    ('ES', 4.0, 'CZ'): 12.0,
    ('ES', 4.0, 'DE'): 7.0,
    ('ES', 4.0, 'DK'): 25.0,
    ('ES', 4.0, 'EE'): 9.0,
    ('ES', 4.0, 'FI'): 10.0,
    ('ES', 4.0, 'FR'): 5.5,
    ('ES', 4.0, 'GR'): 13.0,
    ('ES', 4.0, 'HR'): 5.0,
    ('ES', 4.0, 'HU'): 5.0,
    ('ES', 4.0, 'IE'): 4.8,
    ('ES', 4.0, 'IT'): 4.0,
    ('ES', 4.0, 'LT'): 5.0,
    ('ES', 4.0, 'LU'): 8.0,
    ('ES', 4.0, 'LV'): 12.0,
    ('ES', 4.0, 'MT'): 5.0,
    ('ES', 4.0, 'NL'): 9.0,
    ('ES', 4.0, 'PL'): 8.0,
    ('ES', 4.0, 'PT'): 6.0,
    ('ES', 4.0, 'RO'): 11.0,
    ('ES', 4.0, 'SE'): 6.0,
    ('ES', 4.0, 'SI'): 9.5,
    ('ES', 4.0, 'SK'): 19.0,
    ('FI', 10.0, 'AT'): 10.0,
    ('FI', 10.0, 'BE'): 6.0,
    ('FI', 10.0, 'BG'): 20.0,
    ('FI', 10.0, 'CY'): 5.0,
    ('FI', 10.0, 'CZ'): 12.0,
    ('FI', 10.0, 'DE'): 7.0,
    ('FI', 10.0, 'DK'): 25.0,
    ('FI', 10.0, 'EE'): 9.0,
    ('FI', 10.0, 'ES'): 10.0,
    ('FI', 10.0, 'FR'): 5.5,
    ('FI', 10.0, 'GR'): 13.0,
    ('FI', 10.0, 'HR'): 5.0,
    ('FI', 10.0, 'HU'): 5.0,
    ('FI', 10.0, 'IE'): 13.5,
    ('FI', 10.0, 'IT'): 4.0,
    ('FI', 10.0, 'LT'): 5.0,
    ('FI', 10.0, 'LU'): 8.0,
    ('FI', 10.0, 'LV'): 12.0,
    ('FI', 10.0, 'MT'): 5.0,
    ('FI', 10.0, 'NL'): 9.0,
    ('FI', 10.0, 'PL'): 8.0,
    ('FI', 10.0, 'PT'): 6.0,
    ('FI', 10.0, 'RO'): 11.0,
    ('FI', 10.0, 'SE'): 6.0,
    ('FI', 10.0, 'SI'): 9.5,
    ('FI', 10.0, 'SK'): 19.0,
    ('FI', 14.0, 'AT'): 10.0,
    ('FI', 14.0, 'BE'): 6.0,
    ('FI', 14.0, 'BG'): 20.0,
    ('FI', 14.0, 'CY'): 5.0,
    ('FI', 14.0, 'CZ'): 12.0,
    ('FI', 14.0, 'DE'): 7.0,
    ('FI', 14.0, 'DK'): 25.0,
    ('FI', 14.0, 'EE'): 9.0,
    ('FI', 14.0, 'ES'): 10.0,
    ('FI', 14.0, 'FR'): 5.5,
    ('FI', 14.0, 'GR'): 13.0,
    ('FI', 14.0, 'HR'): 13.0,
    ('FI', 14.0, 'HU'): 5.0,
    ('FI', 14.0, 'IE'): 13.5,
    ('FI', 14.0, 'IT'): 10.0,
    ('FI', 14.0, 'LT'): 5.0,
    ('FI', 14.0, 'LU'): 8.0,
    ('FI', 14.0, 'LV'): 12.0,
    ('FI', 14.0, 'MT'): 5.0,
    ('FI', 14.0, 'NL'): 9.0,
    ('FI', 14.0, 'PL'): 8.0,
    ('FI', 14.0, 'PT'): 6.0,
    ('FI', 14.0, 'RO'): 11.0,
    ('FI', 14.0, 'SE'): 6.0,
    ('FI', 14.0, 'SI'): 9.5,
    ('FI', 14.0, 'SK'): 19.0,
    ('FI', 24.0, 'AT'): 20.0,
    ('FI', 24.0, 'BE'): 21.0,
    ('FI', 24.0, 'BG'): 20.0,
    ('FI', 24.0, 'CY'): 19.0,
    ('FI', 24.0, 'CZ'): 21.0,
    ('FI', 24.0, 'DE'): 19.0,
    ('FI', 24.0, 'DK'): 25.0,
    ('FI', 24.0, 'EE'): 22.0,
    ('FI', 24.0, 'ES'): 21.0,
    ('FI', 24.0, 'FR'): 20.0,
    ('FI', 24.0, 'GR'): 24.0,
    ('FI', 24.0, 'HR'): 25.0,
    ('FI', 24.0, 'HU'): 27.0,
    ('FI', 24.0, 'IE'): 23.0,
    ('FI', 24.0, 'IT'): 22.0,
    ('FI', 24.0, 'LT'): 21.0,
    ('FI', 24.0, 'LU'): 17.0,
    ('FI', 24.0, 'LV'): 21.0,
    ('FI', 24.0, 'MT'): 18.0,
    ('FI', 24.0, 'NL'): 21.0,
    ('FI', 24.0, 'PL'): 23.0,
    ('FI', 24.0, 'PT'): 23.0,
    ('FI', 24.0, 'RO'): 21.0,
    ('FI', 24.0, 'SE'): 25.0,
    ('FI', 24.0, 'SI'): 22.0,
    ('FI', 24.0, 'SK'): 23.0,
    ('FI', 25.5, 'AT'): 20.0,
    ('FI', 25.5, 'BE'): 21.0,
    ('FI', 25.5, 'BG'): 20.0,
    ('FI', 25.5, 'CY'): 19.0,
    ('FI', 25.5, 'CZ'): 21.0,
    ('FI', 25.5, 'DE'): 19.0,
    ('FI', 25.5, 'DK'): 25.0,
    ('FI', 25.5, 'EE'): 22.0,
    ('FI', 25.5, 'ES'): 21.0,
    ('FI', 25.5, 'FR'): 20.0,
    ('FI', 25.5, 'GR'): 24.0,
    ('FI', 25.5, 'HR'): 25.0,
    ('FI', 25.5, 'HU'): 27.0,
    ('FI', 25.5, 'IE'): 23.0,
    ('FI', 25.5, 'IT'): 22.0,
    ('FI', 25.5, 'LT'): 21.0,
    ('FI', 25.5, 'LU'): 17.0,
    ('FI', 25.5, 'LV'): 21.0,
    ('FI', 25.5, 'MT'): 18.0,
    ('FI', 25.5, 'NL'): 21.0,
    ('FI', 25.5, 'PL'): 23.0,
    ('FI', 25.5, 'PT'): 23.0,
    ('FI', 25.5, 'RO'): 21.0,
    ('FI', 25.5, 'SE'): 25.0,
    ('FI', 25.5, 'SI'): 22.0,
    ('FI', 25.5, 'SK'): 23.0,
    ('FR', 10.0, 'AT'): 10.0,
    ('FR', 10.0, 'BE'): 6.0,
    ('FR', 10.0, 'BG'): 20.0,
    ('FR', 10.0, 'CY'): 5.0,
    ('FR', 10.0, 'CZ'): 12.0,
    ('FR', 10.0, 'DE'): 7.0,
    ('FR', 10.0, 'DK'): 25.0,
    ('FR', 10.0, 'EE'): 9.0,
    ('FR', 10.0, 'ES'): 10.0,
    ('FR', 10.0, 'FI'): 10.0,
    ('FR', 10.0, 'GR'): 13.0,
    ('FR', 10.0, 'HR'): 13.0,
    ('FR', 10.0, 'HU'): 5.0,
    ('FR', 10.0, 'IE'): 13.5,
    ('FR', 10.0, 'IT'): 10.0,
    ('FR', 10.0, 'LT'): 5.0,
    ('FR', 10.0, 'LU'): 8.0,
    ('FR', 10.0, 'LV'): 12.0,
    ('FR', 10.0, 'MT'): 5.0,
    ('FR', 10.0, 'NL'): 9.0,
    ('FR', 10.0, 'PL'): 8.0,
    ('FR', 10.0, 'PT'): 6.0,
    ('FR', 10.0, 'RO'): 11.0,
    ('FR', 10.0, 'SE'): 6.0,
    ('FR', 10.0, 'SI'): 9.5,
    ('FR', 10.0, 'SK'): 19.0,
    ('FR', 2.1, 'AT'): 10.0,
    ('FR', 2.1, 'BE'): 6.0,
    ('FR', 2.1, 'BG'): 20.0,
    ('FR', 2.1, 'CY'): 5.0,
    ('FR', 2.1, 'CZ'): 12.0,
    ('FR', 2.1, 'DE'): 7.0,
    ('FR', 2.1, 'DK'): 25.0,
    ('FR', 2.1, 'EE'): 9.0,
    ('FR', 2.1, 'ES'): 4.0,
    ('FR', 2.1, 'FI'): 10.0,
    ('FR', 2.1, 'GR'): 13.0,
    ('FR', 2.1, 'HR'): 5.0,
    ('FR', 2.1, 'HU'): 5.0,
    ('FR', 2.1, 'IE'): 4.8,
    ('FR', 2.1, 'IT'): 4.0,
    ('FR', 2.1, 'LT'): 5.0,
    ('FR', 2.1, 'LU'): 8.0,
    ('FR', 2.1, 'LV'): 12.0,
    ('FR', 2.1, 'MT'): 5.0,
    ('FR', 2.1, 'NL'): 9.0,
    ('FR', 2.1, 'PL'): 8.0,
    ('FR', 2.1, 'PT'): 6.0,
    ('FR', 2.1, 'RO'): 11.0,
    ('FR', 2.1, 'SE'): 6.0,
    ('FR', 2.1, 'SI'): 9.5,
    ('FR', 2.1, 'SK'): 19.0,
    ('FR', 20.0, 'AT'): 20.0,
    ('FR', 20.0, 'BE'): 21.0,
    ('FR', 20.0, 'BG'): 20.0,
    ('FR', 20.0, 'CY'): 19.0,
    ('FR', 20.0, 'CZ'): 21.0,
    ('FR', 20.0, 'DE'): 19.0,
    ('FR', 20.0, 'DK'): 25.0,
    ('FR', 20.0, 'EE'): 22.0,
    ('FR', 20.0, 'ES'): 21.0,
    ('FR', 20.0, 'FI'): 25.5,
    ('FR', 20.0, 'GR'): 24.0,
    ('FR', 20.0, 'HR'): 25.0,
    ('FR', 20.0, 'HU'): 27.0,
    ('FR', 20.0, 'IE'): 23.0,
    ('FR', 20.0, 'IT'): 22.0,
    ('FR', 20.0, 'LT'): 21.0,
    ('FR', 20.0, 'LU'): 17.0,
    ('FR', 20.0, 'LV'): 21.0,
    ('FR', 20.0, 'MT'): 18.0,
    ('FR', 20.0, 'NL'): 21.0,
    ('FR', 20.0, 'PL'): 23.0,
    ('FR', 20.0, 'PT'): 23.0,
    ('FR', 20.0, 'RO'): 21.0,
    ('FR', 20.0, 'SE'): 25.0,
    ('FR', 20.0, 'SI'): 22.0,
    ('FR', 20.0, 'SK'): 23.0,
    ('FR', 5.5, 'AT'): 10.0,
    ('FR', 5.5, 'BE'): 6.0,
    ('FR', 5.5, 'BG'): 20.0,
    ('FR', 5.5, 'CY'): 5.0,
    ('FR', 5.5, 'CZ'): 12.0,
    ('FR', 5.5, 'DE'): 7.0,
    ('FR', 5.5, 'DK'): 25.0,
    ('FR', 5.5, 'EE'): 9.0,
    ('FR', 5.5, 'ES'): 10.0,
    ('FR', 5.5, 'FI'): 10.0,
    ('FR', 5.5, 'GR'): 13.0,
    ('FR', 5.5, 'HR'): 5.0,
    ('FR', 5.5, 'HU'): 5.0,
    ('FR', 5.5, 'IE'): 13.5,
    ('FR', 5.5, 'IT'): 4.0,
    ('FR', 5.5, 'LT'): 5.0,
    ('FR', 5.5, 'LU'): 8.0,
    ('FR', 5.5, 'LV'): 12.0,
    ('FR', 5.5, 'MT'): 5.0,
    ('FR', 5.5, 'NL'): 9.0,
    ('FR', 5.5, 'PL'): 8.0,
    ('FR', 5.5, 'PT'): 6.0,
    ('FR', 5.5, 'RO'): 11.0,
    ('FR', 5.5, 'SE'): 6.0,
    ('FR', 5.5, 'SI'): 9.5,
    ('FR', 5.5, 'SK'): 19.0,
    ('GR', 13.0, 'AT'): 10.0,
    ('GR', 13.0, 'BE'): 6.0,
    ('GR', 13.0, 'BG'): 20.0,
    ('GR', 13.0, 'CY'): 5.0,
    ('GR', 13.0, 'CZ'): 12.0,
    ('GR', 13.0, 'DE'): 7.0,
    ('GR', 13.0, 'DK'): 25.0,
    ('GR', 13.0, 'EE'): 9.0,
    ('GR', 13.0, 'ES'): 10.0,
    ('GR', 13.0, 'FI'): 10.0,
    ('GR', 13.0, 'FR'): 5.5,
    ('GR', 13.0, 'HR'): 13.0,
    ('GR', 13.0, 'HU'): 5.0,
    ('GR', 13.0, 'IE'): 13.5,
    ('GR', 13.0, 'IT'): 10.0,
    ('GR', 13.0, 'LT'): 5.0,
    ('GR', 13.0, 'LU'): 8.0,
    ('GR', 13.0, 'LV'): 12.0,
    ('GR', 13.0, 'MT'): 5.0,
    ('GR', 13.0, 'NL'): 9.0,
    ('GR', 13.0, 'PL'): 8.0,
    ('GR', 13.0, 'PT'): 6.0,
    ('GR', 13.0, 'RO'): 11.0,
    ('GR', 13.0, 'SE'): 6.0,
    ('GR', 13.0, 'SI'): 9.5,
    ('GR', 13.0, 'SK'): 19.0,
    ('GR', 24.0, 'AT'): 20.0,
    ('GR', 24.0, 'BE'): 21.0,
    ('GR', 24.0, 'BG'): 20.0,
    ('GR', 24.0, 'CY'): 19.0,
    ('GR', 24.0, 'CZ'): 21.0,
    ('GR', 24.0, 'DE'): 19.0,
    ('GR', 24.0, 'DK'): 25.0,
    ('GR', 24.0, 'EE'): 22.0,
    ('GR', 24.0, 'ES'): 21.0,
    ('GR', 24.0, 'FI'): 25.5,
    ('GR', 24.0, 'FR'): 20.0,
    ('GR', 24.0, 'HR'): 25.0,
    ('GR', 24.0, 'HU'): 27.0,
    ('GR', 24.0, 'IE'): 23.0,
    ('GR', 24.0, 'IT'): 22.0,
    ('GR', 24.0, 'LT'): 21.0,
    ('GR', 24.0, 'LU'): 17.0,
    ('GR', 24.0, 'LV'): 21.0,
    ('GR', 24.0, 'MT'): 18.0,
    ('GR', 24.0, 'NL'): 21.0,
    ('GR', 24.0, 'PL'): 23.0,
    ('GR', 24.0, 'PT'): 23.0,
    ('GR', 24.0, 'RO'): 21.0,
    ('GR', 24.0, 'SE'): 25.0,
    ('GR', 24.0, 'SI'): 22.0,
    ('GR', 24.0, 'SK'): 23.0,
    ('GR', 6.0, 'AT'): 10.0,
    ('GR', 6.0, 'BE'): 6.0,
    ('GR', 6.0, 'BG'): 20.0,
    ('GR', 6.0, 'CY'): 5.0,
    ('GR', 6.0, 'CZ'): 12.0,
    ('GR', 6.0, 'DE'): 7.0,
    ('GR', 6.0, 'DK'): 25.0,
    ('GR', 6.0, 'EE'): 9.0,
    ('GR', 6.0, 'ES'): 10.0,
    ('GR', 6.0, 'FI'): 10.0,
    ('GR', 6.0, 'FR'): 5.5,
    ('GR', 6.0, 'HR'): 5.0,
    ('GR', 6.0, 'HU'): 5.0,
    ('GR', 6.0, 'IE'): 13.5,
    ('GR', 6.0, 'IT'): 4.0,
    ('GR', 6.0, 'LT'): 5.0,
    ('GR', 6.0, 'LU'): 8.0,
    ('GR', 6.0, 'LV'): 12.0,
    ('GR', 6.0, 'MT'): 5.0,
    ('GR', 6.0, 'NL'): 9.0,
    ('GR', 6.0, 'PL'): 8.0,
    ('GR', 6.0, 'PT'): 6.0,
    ('GR', 6.0, 'RO'): 11.0,
    ('GR', 6.0, 'SE'): 6.0,
    ('GR', 6.0, 'SI'): 9.5,
    ('GR', 6.0, 'SK'): 19.0,
    ('HR', 13.0, 'AT'): 10.0,
    ('HR', 13.0, 'BE'): 6.0,
    ('HR', 13.0, 'BG'): 20.0,
    ('HR', 13.0, 'CY'): 5.0,
    ('HR', 13.0, 'CZ'): 12.0,
    ('HR', 13.0, 'DE'): 7.0,
    ('HR', 13.0, 'DK'): 25.0,
    ('HR', 13.0, 'EE'): 9.0,
    ('HR', 13.0, 'ES'): 10.0,
    ('HR', 13.0, 'FI'): 10.0,
    ('HR', 13.0, 'FR'): 5.5,
    ('HR', 13.0, 'GR'): 13.0,
    ('HR', 13.0, 'HU'): 5.0,
    ('HR', 13.0, 'IE'): 13.5,
    ('HR', 13.0, 'IT'): 10.0,
    ('HR', 13.0, 'LT'): 5.0,
    ('HR', 13.0, 'LU'): 8.0,
    ('HR', 13.0, 'LV'): 12.0,
    ('HR', 13.0, 'MT'): 5.0,
    ('HR', 13.0, 'NL'): 9.0,
    ('HR', 13.0, 'PL'): 8.0,
    ('HR', 13.0, 'PT'): 6.0,
    ('HR', 13.0, 'RO'): 11.0,
    ('HR', 13.0, 'SE'): 6.0,
    ('HR', 13.0, 'SI'): 9.5,
    ('HR', 13.0, 'SK'): 19.0,
    ('HR', 25.0, 'AT'): 20.0,
    ('HR', 25.0, 'BE'): 21.0,
    ('HR', 25.0, 'BG'): 20.0,
    ('HR', 25.0, 'CY'): 19.0,
    ('HR', 25.0, 'CZ'): 21.0,
    ('HR', 25.0, 'DE'): 19.0,
    ('HR', 25.0, 'DK'): 25.0,
    ('HR', 25.0, 'EE'): 22.0,
    ('HR', 25.0, 'ES'): 21.0,
    ('HR', 25.0, 'FI'): 25.5,
    ('HR', 25.0, 'FR'): 20.0,
    ('HR', 25.0, 'GR'): 24.0,
    ('HR', 25.0, 'HU'): 27.0,
    ('HR', 25.0, 'IE'): 23.0,
    ('HR', 25.0, 'IT'): 22.0,
    ('HR', 25.0, 'LT'): 21.0,
    ('HR', 25.0, 'LU'): 17.0,
    ('HR', 25.0, 'LV'): 21.0,
    ('HR', 25.0, 'MT'): 18.0,
    ('HR', 25.0, 'NL'): 21.0,
    ('HR', 25.0, 'PL'): 23.0,
    ('HR', 25.0, 'PT'): 23.0,
    ('HR', 25.0, 'RO'): 21.0,
    ('HR', 25.0, 'SE'): 25.0,
    ('HR', 25.0, 'SI'): 22.0,
    ('HR', 25.0, 'SK'): 23.0,
    ('HR', 5.0, 'AT'): 10.0,
    ('HR', 5.0, 'BE'): 6.0,
    ('HR', 5.0, 'BG'): 20.0,
    ('HR', 5.0, 'CY'): 5.0,
    ('HR', 5.0, 'CZ'): 12.0,
    ('HR', 5.0, 'DE'): 7.0,
    ('HR', 5.0, 'DK'): 25.0,
    ('HR', 5.0, 'EE'): 9.0,
    ('HR', 5.0, 'ES'): 10.0,
    ('HR', 5.0, 'FI'): 10.0,
    ('HR', 5.0, 'FR'): 5.5,
    ('HR', 5.0, 'GR'): 13.0,
    ('HR', 5.0, 'HU'): 5.0,
    ('HR', 5.0, 'IE'): 13.5,
    ('HR', 5.0, 'IT'): 4.0,
    ('HR', 5.0, 'LT'): 5.0,
    ('HR', 5.0, 'LU'): 8.0,
    ('HR', 5.0, 'LV'): 12.0,
    ('HR', 5.0, 'MT'): 5.0,
    ('HR', 5.0, 'NL'): 9.0,
    ('HR', 5.0, 'PL'): 8.0,
    ('HR', 5.0, 'PT'): 6.0,
    ('HR', 5.0, 'RO'): 11.0,
    ('HR', 5.0, 'SE'): 6.0,
    ('HR', 5.0, 'SI'): 9.5,
    ('HR', 5.0, 'SK'): 19.0,
    ('HU', 18.0, 'AT'): 10.0,
    ('HU', 18.0, 'BE'): 6.0,
    ('HU', 18.0, 'BG'): 20.0,
    ('HU', 18.0, 'CY'): 5.0,
    ('HU', 18.0, 'CZ'): 12.0,
    ('HU', 18.0, 'DE'): 7.0,
    ('HU', 18.0, 'DK'): 25.0,
    ('HU', 18.0, 'EE'): 9.0,
    ('HU', 18.0, 'ES'): 10.0,
    ('HU', 18.0, 'FI'): 10.0,
    ('HU', 18.0, 'FR'): 5.5,
    ('HU', 18.0, 'GR'): 13.0,
    ('HU', 18.0, 'HR'): 13.0,
    ('HU', 18.0, 'IE'): 13.5,
    ('HU', 18.0, 'IT'): 10.0,
    ('HU', 18.0, 'LT'): 5.0,
    ('HU', 18.0, 'LU'): 8.0,
    ('HU', 18.0, 'LV'): 12.0,
    ('HU', 18.0, 'MT'): 5.0,
    ('HU', 18.0, 'NL'): 9.0,
    ('HU', 18.0, 'PL'): 8.0,
    ('HU', 18.0, 'PT'): 6.0,
    ('HU', 18.0, 'RO'): 11.0,
    ('HU', 18.0, 'SE'): 6.0,
    ('HU', 18.0, 'SI'): 9.5,
    ('HU', 18.0, 'SK'): 19.0,
    ('HU', 27.0, 'AT'): 20.0,
    ('HU', 27.0, 'BE'): 21.0,
    ('HU', 27.0, 'BG'): 20.0,
    ('HU', 27.0, 'CY'): 19.0,
    ('HU', 27.0, 'CZ'): 21.0,
    ('HU', 27.0, 'DE'): 19.0,
    ('HU', 27.0, 'DK'): 25.0,
    ('HU', 27.0, 'EE'): 22.0,
    ('HU', 27.0, 'ES'): 21.0,
    ('HU', 27.0, 'FI'): 25.5,
    ('HU', 27.0, 'FR'): 20.0,
    ('HU', 27.0, 'GR'): 24.0,
    ('HU', 27.0, 'HR'): 25.0,
    ('HU', 27.0, 'IE'): 23.0,
    ('HU', 27.0, 'IT'): 22.0,
    ('HU', 27.0, 'LT'): 21.0,
    ('HU', 27.0, 'LU'): 17.0,
    ('HU', 27.0, 'LV'): 21.0,
    ('HU', 27.0, 'MT'): 18.0,
    ('HU', 27.0, 'NL'): 21.0,
    ('HU', 27.0, 'PL'): 23.0,
    ('HU', 27.0, 'PT'): 23.0,
    ('HU', 27.0, 'RO'): 21.0,
    ('HU', 27.0, 'SE'): 25.0,
    ('HU', 27.0, 'SI'): 22.0,
    ('HU', 27.0, 'SK'): 23.0,
    ('HU', 5.0, 'AT'): 10.0,
    ('HU', 5.0, 'BE'): 6.0,
    ('HU', 5.0, 'BG'): 20.0,
    ('HU', 5.0, 'CY'): 5.0,
    ('HU', 5.0, 'CZ'): 12.0,
    ('HU', 5.0, 'DE'): 7.0,
    ('HU', 5.0, 'DK'): 25.0,
    ('HU', 5.0, 'EE'): 9.0,
    ('HU', 5.0, 'ES'): 10.0,
    ('HU', 5.0, 'FI'): 10.0,
    ('HU', 5.0, 'FR'): 5.5,
    ('HU', 5.0, 'GR'): 13.0,
    ('HU', 5.0, 'HR'): 5.0,
    ('HU', 5.0, 'IE'): 13.5,
    ('HU', 5.0, 'IT'): 4.0,
    ('HU', 5.0, 'LT'): 5.0,
    ('HU', 5.0, 'LU'): 8.0,
    ('HU', 5.0, 'LV'): 12.0,
    ('HU', 5.0, 'MT'): 5.0,
    ('HU', 5.0, 'NL'): 9.0,
    ('HU', 5.0, 'PL'): 8.0,
    ('HU', 5.0, 'PT'): 6.0,
    ('HU', 5.0, 'RO'): 11.0,
    ('HU', 5.0, 'SE'): 6.0,
    ('HU', 5.0, 'SI'): 9.5,
    ('HU', 5.0, 'SK'): 19.0,
    ('IE', 13.5, 'AT'): 20.0,
    ('IE', 13.5, 'BE'): 21.0,
    ('IE', 13.5, 'BG'): 20.0,
    ('IE', 13.5, 'CY'): 19.0,
    ('IE', 13.5, 'CZ'): 21.0,
    ('IE', 13.5, 'DE'): 19.0,
    ('IE', 13.5, 'DK'): 25.0,
    ('IE', 13.5, 'EE'): 22.0,
    ('IE', 13.5, 'ES'): 21.0,
    ('IE', 13.5, 'FI'): 25.5,
    ('IE', 13.5, 'FR'): 20.0,
    ('IE', 13.5, 'GR'): 24.0,
    ('IE', 13.5, 'HR'): 25.0,
    ('IE', 13.5, 'HU'): 27.0,
    ('IE', 13.5, 'IE'): 23.0,
    ('IE', 13.5, 'IT'): 22.0,
    ('IE', 13.5, 'LT'): 21.0,
    ('IE', 13.5, 'LU'): 17.0,
    ('IE', 13.5, 'LV'): 21.0,
    ('IE', 13.5, 'MT'): 18.0,
    ('IE', 13.5, 'NL'): 21.0,
    ('IE', 13.5, 'PL'): 23.0,
    ('IE', 13.5, 'PT'): 23.0,
    ('IE', 13.5, 'RO'): 21.0,
    ('IE', 13.5, 'SE'): 25.0,
    ('IE', 13.5, 'SI'): 22.0,
    ('IE', 13.5, 'SK'): 23.0,
    ('IE', 23.0, 'AT'): 20.0,
    ('IE', 23.0, 'BE'): 21.0,
    ('IE', 23.0, 'BG'): 20.0,
    ('IE', 23.0, 'CY'): 19.0,
    ('IE', 23.0, 'CZ'): 21.0,
    ('IE', 23.0, 'DE'): 19.0,
    ('IE', 23.0, 'DK'): 25.0,
    ('IE', 23.0, 'EE'): 22.0,
    ('IE', 23.0, 'ES'): 21.0,
    ('IE', 23.0, 'FI'): 25.5,
    ('IE', 23.0, 'FR'): 20.0,
    ('IE', 23.0, 'GR'): 24.0,
    ('IE', 23.0, 'HR'): 25.0,
    ('IE', 23.0, 'HU'): 27.0,
    ('IE', 23.0, 'IT'): 22.0,
    ('IE', 23.0, 'LT'): 21.0,
    ('IE', 23.0, 'LU'): 17.0,
    ('IE', 23.0, 'LV'): 21.0,
    ('IE', 23.0, 'MT'): 18.0,
    ('IE', 23.0, 'NL'): 21.0,
    ('IE', 23.0, 'PL'): 23.0,
    ('IE', 23.0, 'PT'): 23.0,
    ('IE', 23.0, 'RO'): 21.0,
    ('IE', 23.0, 'SE'): 25.0,
    ('IE', 23.0, 'SI'): 22.0,
    ('IE', 23.0, 'SK'): 23.0,
    ('IE', 4.8, 'AT'): 10.0,
    ('IE', 4.8, 'BE'): 6.0,
    ('IE', 4.8, 'BG'): 20.0,
    ('IE', 4.8, 'CY'): 5.0,
    ('IE', 4.8, 'CZ'): 12.0,
    ('IE', 4.8, 'DE'): 7.0,
    ('IE', 4.8, 'DK'): 25.0,
    ('IE', 4.8, 'EE'): 9.0,
    ('IE', 4.8, 'ES'): 4.0,
    ('IE', 4.8, 'FI'): 10.0,
    ('IE', 4.8, 'FR'): 5.5,
    ('IE', 4.8, 'GR'): 13.0,
    ('IE', 4.8, 'HR'): 5.0,
    ('IE', 4.8, 'HU'): 5.0,
    ('IE', 4.8, 'IT'): 4.0,
    ('IE', 4.8, 'LT'): 5.0,
    ('IE', 4.8, 'LU'): 8.0,
    ('IE', 4.8, 'LV'): 12.0,
    ('IE', 4.8, 'MT'): 5.0,
    ('IE', 4.8, 'NL'): 9.0,
    ('IE', 4.8, 'PL'): 8.0,
    ('IE', 4.8, 'PT'): 6.0,
    ('IE', 4.8, 'RO'): 11.0,
    ('IE', 4.8, 'SE'): 6.0,
    ('IE', 4.8, 'SI'): 9.5,
    ('IE', 4.8, 'SK'): 19.0,
    ('IE', 9.0, 'AT'): 10.0,
    ('IE', 9.0, 'BE'): 6.0,
    ('IE', 9.0, 'BG'): 20.0,
    ('IE', 9.0, 'CY'): 5.0,
    ('IE', 9.0, 'CZ'): 12.0,
    ('IE', 9.0, 'DE'): 7.0,
    ('IE', 9.0, 'DK'): 25.0,
    ('IE', 9.0, 'EE'): 9.0,
    ('IE', 9.0, 'ES'): 10.0,
    ('IE', 9.0, 'FI'): 10.0,
    ('IE', 9.0, 'FR'): 5.5,
    ('IE', 9.0, 'GR'): 13.0,
    ('IE', 9.0, 'HR'): 5.0,
    ('IE', 9.0, 'HU'): 5.0,
    ('IE', 9.0, 'IT'): 10.0,
    ('IE', 9.0, 'LT'): 5.0,
    ('IE', 9.0, 'LU'): 8.0,
    ('IE', 9.0, 'LV'): 12.0,
    ('IE', 9.0, 'MT'): 5.0,
    ('IE', 9.0, 'NL'): 9.0,
    ('IE', 9.0, 'PL'): 8.0,
    ('IE', 9.0, 'PT'): 6.0,
    ('IE', 9.0, 'RO'): 11.0,
    ('IE', 9.0, 'SE'): 6.0,
    ('IE', 9.0, 'SI'): 9.5,
    ('IE', 9.0, 'SK'): 19.0,
    ('IT', 10.0, 'AT'): 10.0,
    ('IT', 10.0, 'BE'): 6.0,
    ('IT', 10.0, 'BG'): 20.0,
    ('IT', 10.0, 'CY'): 5.0,
    ('IT', 10.0, 'CZ'): 12.0,
    ('IT', 10.0, 'DE'): 7.0,
    ('IT', 10.0, 'DK'): 25.0,
    ('IT', 10.0, 'EE'): 9.0,
    ('IT', 10.0, 'ES'): 10.0,
    ('IT', 10.0, 'FI'): 10.0,
    ('IT', 10.0, 'FR'): 5.5,
    ('IT', 10.0, 'GR'): 13.0,
    ('IT', 10.0, 'HR'): 13.0,
    ('IT', 10.0, 'HU'): 5.0,
    ('IT', 10.0, 'IE'): 13.5,
    ('IT', 10.0, 'LT'): 5.0,
    ('IT', 10.0, 'LU'): 8.0,
    ('IT', 10.0, 'LV'): 12.0,
    ('IT', 10.0, 'MT'): 5.0,
    ('IT', 10.0, 'NL'): 9.0,
    ('IT', 10.0, 'PL'): 8.0,
    ('IT', 10.0, 'PT'): 6.0,
    ('IT', 10.0, 'RO'): 11.0,
    ('IT', 10.0, 'SE'): 6.0,
    ('IT', 10.0, 'SI'): 9.5,
    ('IT', 10.0, 'SK'): 19.0,
    ('IT', 22.0, 'AT'): 20.0,
    ('IT', 22.0, 'BE'): 21.0,
    ('IT', 22.0, 'BG'): 20.0,
    ('IT', 22.0, 'CY'): 19.0,
    ('IT', 22.0, 'CZ'): 21.0,
    ('IT', 22.0, 'DE'): 19.0,
    ('IT', 22.0, 'DK'): 25.0,
    ('IT', 22.0, 'EE'): 22.0,
    ('IT', 22.0, 'ES'): 21.0,
    ('IT', 22.0, 'FI'): 25.5,
    ('IT', 22.0, 'FR'): 20.0,
    ('IT', 22.0, 'GR'): 24.0,
    ('IT', 22.0, 'HR'): 25.0,
    ('IT', 22.0, 'HU'): 27.0,
    ('IT', 22.0, 'IE'): 23.0,
    ('IT', 22.0, 'LT'): 21.0,
    ('IT', 22.0, 'LU'): 17.0,
    ('IT', 22.0, 'LV'): 21.0,
    ('IT', 22.0, 'MT'): 18.0,
    ('IT', 22.0, 'NL'): 21.0,
    ('IT', 22.0, 'PL'): 23.0,
    ('IT', 22.0, 'PT'): 23.0,
    ('IT', 22.0, 'RO'): 21.0,
    ('IT', 22.0, 'SE'): 25.0,
    ('IT', 22.0, 'SI'): 22.0,
    ('IT', 22.0, 'SK'): 23.0,
    ('IT', 4.0, 'AT'): 10.0,
    ('IT', 4.0, 'BE'): 6.0,
    ('IT', 4.0, 'BG'): 20.0,
    ('IT', 4.0, 'CY'): 5.0,
    ('IT', 4.0, 'CZ'): 12.0,
    ('IT', 4.0, 'DE'): 7.0,
    ('IT', 4.0, 'DK'): 25.0,
    ('IT', 4.0, 'EE'): 9.0,
    ('IT', 4.0, 'ES'): 4.0,
    ('IT', 4.0, 'FI'): 10.0,
    ('IT', 4.0, 'FR'): 5.5,
    ('IT', 4.0, 'GR'): 13.0,
    ('IT', 4.0, 'HR'): 5.0,
    ('IT', 4.0, 'HU'): 5.0,
    ('IT', 4.0, 'IE'): 4.8,
    ('IT', 4.0, 'LT'): 5.0,
    ('IT', 4.0, 'LU'): 8.0,
    ('IT', 4.0, 'LV'): 12.0,
    ('IT', 4.0, 'MT'): 5.0,
    ('IT', 4.0, 'NL'): 9.0,
    ('IT', 4.0, 'PL'): 8.0,
    ('IT', 4.0, 'PT'): 6.0,
    ('IT', 4.0, 'RO'): 11.0,
    ('IT', 4.0, 'SE'): 6.0,
    ('IT', 4.0, 'SI'): 9.5,
    ('IT', 4.0, 'SK'): 19.0,
    ('IT', 5.0, 'AT'): 10.0,
    ('IT', 5.0, 'BE'): 6.0,
    ('IT', 5.0, 'BG'): 20.0,
    ('IT', 5.0, 'CY'): 5.0,
    ('IT', 5.0, 'CZ'): 12.0,
    ('IT', 5.0, 'DE'): 7.0,
    ('IT', 5.0, 'DK'): 25.0,
    ('IT', 5.0, 'EE'): 9.0,
    ('IT', 5.0, 'ES'): 10.0,
    ('IT', 5.0, 'FI'): 10.0,
    ('IT', 5.0, 'FR'): 5.5,
    ('IT', 5.0, 'GR'): 13.0,
    ('IT', 5.0, 'HR'): 5.0,
    ('IT', 5.0, 'HU'): 5.0,
    ('IT', 5.0, 'IE'): 13.5,
    ('IT', 5.0, 'LT'): 5.0,
    ('IT', 5.0, 'LU'): 8.0,
    ('IT', 5.0, 'LV'): 12.0,
    ('IT', 5.0, 'MT'): 5.0,
    ('IT', 5.0, 'NL'): 9.0,
    ('IT', 5.0, 'PL'): 8.0,
    ('IT', 5.0, 'PT'): 6.0,
    ('IT', 5.0, 'RO'): 11.0,
    ('IT', 5.0, 'SE'): 6.0,
    ('IT', 5.0, 'SI'): 9.5,
    ('IT', 5.0, 'SK'): 19.0,
    ('LT', 21.0, 'AT'): 20.0,
    ('LT', 21.0, 'BE'): 21.0,
    ('LT', 21.0, 'BG'): 20.0,
    ('LT', 21.0, 'CY'): 19.0,
    ('LT', 21.0, 'CZ'): 21.0,
    ('LT', 21.0, 'DE'): 19.0,
    ('LT', 21.0, 'DK'): 25.0,
    ('LT', 21.0, 'EE'): 22.0,
    ('LT', 21.0, 'ES'): 21.0,
    ('LT', 21.0, 'FI'): 25.5,
    ('LT', 21.0, 'FR'): 20.0,
    ('LT', 21.0, 'GR'): 24.0,
    ('LT', 21.0, 'HR'): 25.0,
    ('LT', 21.0, 'HU'): 27.0,
    ('LT', 21.0, 'IE'): 23.0,
    ('LT', 21.0, 'IT'): 22.0,
    ('LT', 21.0, 'LU'): 17.0,
    ('LT', 21.0, 'LV'): 21.0,
    ('LT', 21.0, 'MT'): 18.0,
    ('LT', 21.0, 'NL'): 21.0,
    ('LT', 21.0, 'PL'): 23.0,
    ('LT', 21.0, 'PT'): 23.0,
    ('LT', 21.0, 'RO'): 21.0,
    ('LT', 21.0, 'SE'): 25.0,
    ('LT', 21.0, 'SI'): 22.0,
    ('LT', 21.0, 'SK'): 23.0,
    ('LT', 5.0, 'AT'): 10.0,
    ('LT', 5.0, 'BE'): 6.0,
    ('LT', 5.0, 'BG'): 20.0,
    ('LT', 5.0, 'CY'): 5.0,
    ('LT', 5.0, 'CZ'): 12.0,
    ('LT', 5.0, 'DE'): 7.0,
    ('LT', 5.0, 'DK'): 25.0,
    ('LT', 5.0, 'EE'): 9.0,
    ('LT', 5.0, 'ES'): 10.0,
    ('LT', 5.0, 'FI'): 10.0,
    ('LT', 5.0, 'FR'): 5.5,
    ('LT', 5.0, 'GR'): 13.0,
    ('LT', 5.0, 'HR'): 5.0,
    ('LT', 5.0, 'HU'): 5.0,
    ('LT', 5.0, 'IE'): 13.5,
    ('LT', 5.0, 'IT'): 4.0,
    ('LT', 5.0, 'LU'): 8.0,
    ('LT', 5.0, 'LV'): 12.0,
    ('LT', 5.0, 'MT'): 5.0,
    ('LT', 5.0, 'NL'): 9.0,
    ('LT', 5.0, 'PL'): 8.0,
    ('LT', 5.0, 'PT'): 6.0,
    ('LT', 5.0, 'RO'): 11.0,
    ('LT', 5.0, 'SE'): 6.0,
    ('LT', 5.0, 'SI'): 9.5,
    ('LT', 5.0, 'SK'): 19.0,
    ('LT', 9.0, 'AT'): 10.0,
    ('LT', 9.0, 'BE'): 6.0,
    ('LT', 9.0, 'BG'): 20.0,
    ('LT', 9.0, 'CY'): 5.0,
    ('LT', 9.0, 'CZ'): 12.0,
    ('LT', 9.0, 'DE'): 7.0,
    ('LT', 9.0, 'DK'): 25.0,
    ('LT', 9.0, 'EE'): 9.0,
    ('LT', 9.0, 'ES'): 10.0,
    ('LT', 9.0, 'FI'): 10.0,
    ('LT', 9.0, 'FR'): 5.5,
    ('LT', 9.0, 'GR'): 13.0,
    ('LT', 9.0, 'HR'): 13.0,
    ('LT', 9.0, 'HU'): 5.0,
    ('LT', 9.0, 'IE'): 13.5,
    ('LT', 9.0, 'IT'): 10.0,
    ('LT', 9.0, 'LU'): 8.0,
    ('LT', 9.0, 'LV'): 12.0,
    ('LT', 9.0, 'MT'): 5.0,
    ('LT', 9.0, 'NL'): 9.0,
    ('LT', 9.0, 'PL'): 8.0,
    ('LT', 9.0, 'PT'): 6.0,
    ('LT', 9.0, 'RO'): 11.0,
    ('LT', 9.0, 'SE'): 6.0,
    ('LT', 9.0, 'SI'): 9.5,
    ('LT', 9.0, 'SK'): 19.0,
    ('LU', 13.0, 'AT'): 20.0,
    ('LU', 13.0, 'BE'): 21.0,
    ('LU', 13.0, 'BG'): 20.0,
    ('LU', 13.0, 'CY'): 19.0,
    ('LU', 13.0, 'CZ'): 21.0,
    ('LU', 13.0, 'DE'): 19.0,
    ('LU', 13.0, 'DK'): 25.0,
    ('LU', 13.0, 'EE'): 22.0,
    ('LU', 13.0, 'ES'): 21.0,
    ('LU', 13.0, 'FI'): 25.5,
    ('LU', 13.0, 'FR'): 20.0,
    ('LU', 13.0, 'GR'): 24.0,
    ('LU', 13.0, 'HR'): 25.0,
    ('LU', 13.0, 'HU'): 27.0,
    ('LU', 13.0, 'IE'): 23.0,
    ('LU', 13.0, 'IT'): 22.0,
    ('LU', 13.0, 'LT'): 21.0,
    ('LU', 13.0, 'LV'): 21.0,
    ('LU', 13.0, 'MT'): 18.0,
    ('LU', 13.0, 'NL'): 21.0,
    ('LU', 13.0, 'PL'): 23.0,
    ('LU', 13.0, 'PT'): 23.0,
    ('LU', 13.0, 'RO'): 21.0,
    ('LU', 13.0, 'SE'): 18.0,
    ('LU', 13.0, 'SI'): 21.0,
    ('LU', 13.0, 'SK'): 23.0,
    ('LU', 14.0, 'AT'): 20.0,
    ('LU', 14.0, 'BE'): 21.0,
    ('LU', 14.0, 'BG'): 20.0,
    ('LU', 14.0, 'CY'): 19.0,
    ('LU', 14.0, 'CZ'): 21.0,
    ('LU', 14.0, 'DE'): 19.0,
    ('LU', 14.0, 'DK'): 25.0,
    ('LU', 14.0, 'EE'): 22.0,
    ('LU', 14.0, 'ES'): 21.0,
    ('LU', 14.0, 'FI'): 25.5,
    ('LU', 14.0, 'FR'): 20.0,
    ('LU', 14.0, 'GR'): 24.0,
    ('LU', 14.0, 'HR'): 25.0,
    ('LU', 14.0, 'HU'): 27.0,
    ('LU', 14.0, 'IE'): 23.0,
    ('LU', 14.0, 'IT'): 22.0,
    ('LU', 14.0, 'LT'): 21.0,
    ('LU', 14.0, 'LV'): 21.0,
    ('LU', 14.0, 'MT'): 18.0,
    ('LU', 14.0, 'NL'): 21.0,
    ('LU', 14.0, 'PL'): 23.0,
    ('LU', 14.0, 'PT'): 23.0,
    ('LU', 14.0, 'RO'): 21.0,
    ('LU', 14.0, 'SE'): 18.0,
    ('LU', 14.0, 'SI'): 21.0,
    ('LU', 14.0, 'SK'): 23.0,
    ('LU', 16.0, 'AT'): 20.0,
    ('LU', 16.0, 'BE'): 21.0,
    ('LU', 16.0, 'BG'): 20.0,
    ('LU', 16.0, 'CY'): 19.0,
    ('LU', 16.0, 'CZ'): 21.0,
    ('LU', 16.0, 'DE'): 19.0,
    ('LU', 16.0, 'DK'): 25.0,
    ('LU', 16.0, 'EE'): 22.0,
    ('LU', 16.0, 'ES'): 21.0,
    ('LU', 16.0, 'FI'): 25.5,
    ('LU', 16.0, 'FR'): 20.0,
    ('LU', 16.0, 'GR'): 24.0,
    ('LU', 16.0, 'HR'): 25.0,
    ('LU', 16.0, 'HU'): 27.0,
    ('LU', 16.0, 'IE'): 23.0,
    ('LU', 16.0, 'IT'): 22.0,
    ('LU', 16.0, 'LT'): 21.0,
    ('LU', 16.0, 'LV'): 21.0,
    ('LU', 16.0, 'MT'): 18.0,
    ('LU', 16.0, 'NL'): 21.0,
    ('LU', 16.0, 'PL'): 23.0,
    ('LU', 16.0, 'PT'): 23.0,
    ('LU', 16.0, 'RO'): 21.0,
    ('LU', 16.0, 'SE'): 25.0,
    ('LU', 16.0, 'SI'): 22.0,
    ('LU', 16.0, 'SK'): 23.0,
    ('LU', 17.0, 'AT'): 20.0,
    ('LU', 17.0, 'BE'): 21.0,
    ('LU', 17.0, 'BG'): 20.0,
    ('LU', 17.0, 'CY'): 19.0,
    ('LU', 17.0, 'CZ'): 21.0,
    ('LU', 17.0, 'DE'): 19.0,
    ('LU', 17.0, 'DK'): 25.0,
    ('LU', 17.0, 'EE'): 22.0,
    ('LU', 17.0, 'ES'): 21.0,
    ('LU', 17.0, 'FI'): 25.5,
    ('LU', 17.0, 'FR'): 20.0,
    ('LU', 17.0, 'GR'): 24.0,
    ('LU', 17.0, 'HR'): 25.0,
    ('LU', 17.0, 'HU'): 27.0,
    ('LU', 17.0, 'IE'): 23.0,
    ('LU', 17.0, 'IT'): 22.0,
    ('LU', 17.0, 'LT'): 21.0,
    ('LU', 17.0, 'LV'): 21.0,
    ('LU', 17.0, 'MT'): 18.0,
    ('LU', 17.0, 'NL'): 21.0,
    ('LU', 17.0, 'PL'): 23.0,
    ('LU', 17.0, 'PT'): 23.0,
    ('LU', 17.0, 'RO'): 21.0,
    ('LU', 17.0, 'SE'): 25.0,
    ('LU', 17.0, 'SI'): 22.0,
    ('LU', 17.0, 'SK'): 23.0,
    ('LU', 3.0, 'AT'): 10.0,
    ('LU', 3.0, 'BE'): 6.0,
    ('LU', 3.0, 'BG'): 20.0,
    ('LU', 3.0, 'CY'): 5.0,
    ('LU', 3.0, 'CZ'): 12.0,
    ('LU', 3.0, 'DE'): 7.0,
    ('LU', 3.0, 'DK'): 25.0,
    ('LU', 3.0, 'EE'): 9.0,
    ('LU', 3.0, 'ES'): 4.0,
    ('LU', 3.0, 'FI'): 10.0,
    ('LU', 3.0, 'FR'): 5.5,
    ('LU', 3.0, 'GR'): 13.0,
    ('LU', 3.0, 'HR'): 5.0,
    ('LU', 3.0, 'HU'): 5.0,
    ('LU', 3.0, 'IE'): 4.8,
    ('LU', 3.0, 'IT'): 4.0,
    ('LU', 3.0, 'LT'): 5.0,
    ('LU', 3.0, 'LV'): 12.0,
    ('LU', 3.0, 'MT'): 5.0,
    ('LU', 3.0, 'NL'): 9.0,
    ('LU', 3.0, 'PL'): 8.0,
    ('LU', 3.0, 'PT'): 6.0,
    ('LU', 3.0, 'RO'): 11.0,
    ('LU', 3.0, 'SE'): 6.0,
    ('LU', 3.0, 'SI'): 9.5,
    ('LU', 3.0, 'SK'): 19.0,
    ('LU', 7.0, 'AT'): 10.0,
    ('LU', 7.0, 'BE'): 6.0,
    ('LU', 7.0, 'BG'): 20.0,
    ('LU', 7.0, 'CY'): 5.0,
    ('LU', 7.0, 'CZ'): 12.0,
    ('LU', 7.0, 'DE'): 7.0,
    ('LU', 7.0, 'DK'): 25.0,
    ('LU', 7.0, 'EE'): 9.0,
    ('LU', 7.0, 'ES'): 10.0,
    ('LU', 7.0, 'FI'): 10.0,
    ('LU', 7.0, 'FR'): 5.5,
    ('LU', 7.0, 'GR'): 13.0,
    ('LU', 7.0, 'HR'): 5.0,
    ('LU', 7.0, 'HU'): 5.0,
    ('LU', 7.0, 'IE'): 13.5,
    ('LU', 7.0, 'IT'): 10.0,
    ('LU', 7.0, 'LT'): 5.0,
    ('LU', 7.0, 'LV'): 12.0,
    ('LU', 7.0, 'MT'): 5.0,
    ('LU', 7.0, 'NL'): 9.0,
    ('LU', 7.0, 'PL'): 7.0,
    ('LU', 7.0, 'PT'): 6.0,
    ('LU', 7.0, 'RO'): 11.0,
    ('LU', 7.0, 'SE'): 6.0,
    ('LU', 7.0, 'SI'): 9.5,
    ('LU', 7.0, 'SK'): 19.0,
    ('LU', 8.0, 'AT'): 10.0,
    ('LU', 8.0, 'BE'): 6.0,
    ('LU', 8.0, 'BG'): 20.0,
    ('LU', 8.0, 'CY'): 5.0,
    ('LU', 8.0, 'CZ'): 12.0,
    ('LU', 8.0, 'DE'): 7.0,
    ('LU', 8.0, 'DK'): 25.0,
    ('LU', 8.0, 'EE'): 9.0,
    ('LU', 8.0, 'ES'): 10.0,
    ('LU', 8.0, 'FI'): 10.0,
    ('LU', 8.0, 'FR'): 5.5,
    ('LU', 8.0, 'GR'): 13.0,
    ('LU', 8.0, 'HR'): 5.0,
    ('LU', 8.0, 'HU'): 5.0,
    ('LU', 8.0, 'IE'): 13.5,
    ('LU', 8.0, 'IT'): 10.0,
    ('LU', 8.0, 'LT'): 5.0,
    ('LU', 8.0, 'LV'): 12.0,
    ('LU', 8.0, 'MT'): 5.0,
    ('LU', 8.0, 'NL'): 9.0,
    ('LU', 8.0, 'PL'): 8.0,
    ('LU', 8.0, 'PT'): 6.0,
    ('LU', 8.0, 'RO'): 11.0,
    ('LU', 8.0, 'SE'): 6.0,
    ('LU', 8.0, 'SI'): 9.5,
    ('LU', 8.0, 'SK'): 19.0,
    ('LV', 12.0, 'AT'): 10.0,
    ('LV', 12.0, 'BE'): 6.0,
    ('LV', 12.0, 'BG'): 20.0,
    ('LV', 12.0, 'CY'): 5.0,
    ('LV', 12.0, 'CZ'): 12.0,
    ('LV', 12.0, 'DE'): 7.0,
    ('LV', 12.0, 'DK'): 25.0,
    ('LV', 12.0, 'EE'): 9.0,
    ('LV', 12.0, 'ES'): 10.0,
    ('LV', 12.0, 'FI'): 10.0,
    ('LV', 12.0, 'FR'): 5.5,
    ('LV', 12.0, 'GR'): 13.0,
    ('LV', 12.0, 'HR'): 13.0,
    ('LV', 12.0, 'HU'): 5.0,
    ('LV', 12.0, 'IE'): 13.5,
    ('LV', 12.0, 'IT'): 10.0,
    ('LV', 12.0, 'LT'): 5.0,
    ('LV', 12.0, 'LU'): 8.0,
    ('LV', 12.0, 'MT'): 5.0,
    ('LV', 12.0, 'NL'): 9.0,
    ('LV', 12.0, 'PL'): 8.0,
    ('LV', 12.0, 'PT'): 6.0,
    ('LV', 12.0, 'RO'): 11.0,
    ('LV', 12.0, 'SE'): 6.0,
    ('LV', 12.0, 'SI'): 9.5,
    ('LV', 12.0, 'SK'): 19.0,
    ('LV', 21.0, 'AT'): 20.0,
    ('LV', 21.0, 'BE'): 21.0,
    ('LV', 21.0, 'BG'): 20.0,
    ('LV', 21.0, 'CY'): 19.0,
    ('LV', 21.0, 'CZ'): 21.0,
    ('LV', 21.0, 'DE'): 19.0,
    ('LV', 21.0, 'DK'): 25.0,
    ('LV', 21.0, 'EE'): 22.0,
    ('LV', 21.0, 'ES'): 21.0,
    ('LV', 21.0, 'FI'): 25.5,
    ('LV', 21.0, 'FR'): 20.0,
    ('LV', 21.0, 'GR'): 24.0,
    ('LV', 21.0, 'HR'): 25.0,
    ('LV', 21.0, 'HU'): 27.0,
    ('LV', 21.0, 'IE'): 23.0,
    ('LV', 21.0, 'IT'): 22.0,
    ('LV', 21.0, 'LT'): 21.0,
    ('LV', 21.0, 'LU'): 17.0,
    ('LV', 21.0, 'MT'): 18.0,
    ('LV', 21.0, 'NL'): 21.0,
    ('LV', 21.0, 'PL'): 23.0,
    ('LV', 21.0, 'PT'): 23.0,
    ('LV', 21.0, 'RO'): 21.0,
    ('LV', 21.0, 'SE'): 25.0,
    ('LV', 21.0, 'SI'): 22.0,
    ('LV', 21.0, 'SK'): 23.0,
    ('LV', 5.0, 'AT'): 10.0,
    ('LV', 5.0, 'BE'): 6.0,
    ('LV', 5.0, 'BG'): 20.0,
    ('LV', 5.0, 'CY'): 5.0,
    ('LV', 5.0, 'CZ'): 12.0,
    ('LV', 5.0, 'DE'): 7.0,
    ('LV', 5.0, 'DK'): 25.0,
    ('LV', 5.0, 'EE'): 9.0,
    ('LV', 5.0, 'ES'): 10.0,
    ('LV', 5.0, 'FI'): 10.0,
    ('LV', 5.0, 'FR'): 5.5,
    ('LV', 5.0, 'GR'): 13.0,
    ('LV', 5.0, 'HR'): 5.0,
    ('LV', 5.0, 'HU'): 5.0,
    ('LV', 5.0, 'IE'): 13.5,
    ('LV', 5.0, 'IT'): 4.0,
    ('LV', 5.0, 'LT'): 5.0,
    ('LV', 5.0, 'LU'): 8.0,
    ('LV', 5.0, 'MT'): 5.0,
    ('LV', 5.0, 'NL'): 9.0,
    ('LV', 5.0, 'PL'): 8.0,
    ('LV', 5.0, 'PT'): 6.0,
    ('LV', 5.0, 'RO'): 11.0,
    ('LV', 5.0, 'SE'): 6.0,
    ('LV', 5.0, 'SI'): 9.5,
    ('LV', 5.0, 'SK'): 19.0,
    ('MT', 18.0, 'AT'): 20.0,
    ('MT', 18.0, 'BE'): 21.0,
    ('MT', 18.0, 'BG'): 20.0,
    ('MT', 18.0, 'CY'): 19.0,
    ('MT', 18.0, 'CZ'): 21.0,
    ('MT', 18.0, 'DE'): 19.0,
    ('MT', 18.0, 'DK'): 25.0,
    ('MT', 18.0, 'EE'): 22.0,
    ('MT', 18.0, 'ES'): 21.0,
    ('MT', 18.0, 'FI'): 25.5,
    ('MT', 18.0, 'FR'): 20.0,
    ('MT', 18.0, 'GR'): 24.0,
    ('MT', 18.0, 'HR'): 25.0,
    ('MT', 18.0, 'HU'): 27.0,
    ('MT', 18.0, 'IE'): 23.0,
    ('MT', 18.0, 'IT'): 22.0,
    ('MT', 18.0, 'LT'): 21.0,
    ('MT', 18.0, 'LU'): 17.0,
    ('MT', 18.0, 'LV'): 21.0,
    ('MT', 18.0, 'NL'): 21.0,
    ('MT', 18.0, 'PL'): 23.0,
    ('MT', 18.0, 'PT'): 23.0,
    ('MT', 18.0, 'RO'): 21.0,
    ('MT', 18.0, 'SE'): 25.0,
    ('MT', 18.0, 'SI'): 22.0,
    ('MT', 18.0, 'SK'): 23.0,
    ('MT', 5.0, 'AT'): 10.0,
    ('MT', 5.0, 'BE'): 6.0,
    ('MT', 5.0, 'BG'): 20.0,
    ('MT', 5.0, 'CY'): 5.0,
    ('MT', 5.0, 'CZ'): 12.0,
    ('MT', 5.0, 'DE'): 7.0,
    ('MT', 5.0, 'DK'): 25.0,
    ('MT', 5.0, 'EE'): 9.0,
    ('MT', 5.0, 'ES'): 10.0,
    ('MT', 5.0, 'FI'): 10.0,
    ('MT', 5.0, 'FR'): 5.5,
    ('MT', 5.0, 'GR'): 13.0,
    ('MT', 5.0, 'HR'): 5.0,
    ('MT', 5.0, 'HU'): 5.0,
    ('MT', 5.0, 'IE'): 13.5,
    ('MT', 5.0, 'IT'): 4.0,
    ('MT', 5.0, 'LT'): 5.0,
    ('MT', 5.0, 'LU'): 8.0,
    ('MT', 5.0, 'LV'): 12.0,
    ('MT', 5.0, 'NL'): 9.0,
    ('MT', 5.0, 'PL'): 8.0,
    ('MT', 5.0, 'PT'): 6.0,
    ('MT', 5.0, 'RO'): 11.0,
    ('MT', 5.0, 'SE'): 6.0,
    ('MT', 5.0, 'SI'): 9.5,
    ('MT', 5.0, 'SK'): 19.0,
    ('MT', 7.0, 'AT'): 10.0,
    ('MT', 7.0, 'BE'): 6.0,
    ('MT', 7.0, 'BG'): 20.0,
    ('MT', 7.0, 'CY'): 5.0,
    ('MT', 7.0, 'CZ'): 12.0,
    ('MT', 7.0, 'DE'): 7.0,
    ('MT', 7.0, 'DK'): 25.0,
    ('MT', 7.0, 'EE'): 9.0,
    ('MT', 7.0, 'ES'): 10.0,
    ('MT', 7.0, 'FI'): 10.0,
    ('MT', 7.0, 'FR'): 5.5,
    ('MT', 7.0, 'GR'): 13.0,
    ('MT', 7.0, 'HR'): 5.0,
    ('MT', 7.0, 'HU'): 5.0,
    ('MT', 7.0, 'IE'): 13.5,
    ('MT', 7.0, 'IT'): 10.0,
    ('MT', 7.0, 'LT'): 5.0,
    ('MT', 7.0, 'LU'): 8.0,
    ('MT', 7.0, 'LV'): 12.0,
    ('MT', 7.0, 'NL'): 9.0,
    ('MT', 7.0, 'PL'): 8.0,
    ('MT', 7.0, 'PT'): 6.0,
    ('MT', 7.0, 'RO'): 11.0,
    ('MT', 7.0, 'SE'): 6.0,
    ('MT', 7.0, 'SI'): 9.5,
    ('MT', 7.0, 'SK'): 19.0,
    ('NL', 21.0, 'AT'): 20.0,
    ('NL', 21.0, 'BE'): 21.0,
    ('NL', 21.0, 'BG'): 20.0,
    ('NL', 21.0, 'CY'): 19.0,
    ('NL', 21.0, 'CZ'): 21.0,
    ('NL', 21.0, 'DE'): 19.0,
    ('NL', 21.0, 'DK'): 25.0,
    ('NL', 21.0, 'EE'): 22.0,
    ('NL', 21.0, 'ES'): 21.0,
    ('NL', 21.0, 'FI'): 25.5,
    ('NL', 21.0, 'FR'): 20.0,
    ('NL', 21.0, 'GR'): 24.0,
    ('NL', 21.0, 'HR'): 25.0,
    ('NL', 21.0, 'HU'): 27.0,
    ('NL', 21.0, 'IE'): 23.0,
    ('NL', 21.0, 'IT'): 22.0,
    ('NL', 21.0, 'LT'): 21.0,
    ('NL', 21.0, 'LU'): 17.0,
    ('NL', 21.0, 'LV'): 21.0,
    ('NL', 21.0, 'MT'): 18.0,
    ('NL', 21.0, 'PL'): 23.0,
    ('NL', 21.0, 'PT'): 23.0,
    ('NL', 21.0, 'RO'): 21.0,
    ('NL', 21.0, 'SE'): 25.0,
    ('NL', 21.0, 'SI'): 22.0,
    ('NL', 21.0, 'SK'): 23.0,
    ('NL', 9.0, 'AT'): 10.0,
    ('NL', 9.0, 'BE'): 6.0,
    ('NL', 9.0, 'BG'): 20.0,
    ('NL', 9.0, 'CY'): 5.0,
    ('NL', 9.0, 'CZ'): 12.0,
    ('NL', 9.0, 'DE'): 7.0,
    ('NL', 9.0, 'DK'): 25.0,
    ('NL', 9.0, 'EE'): 9.0,
    ('NL', 9.0, 'ES'): 10.0,
    ('NL', 9.0, 'FI'): 10.0,
    ('NL', 9.0, 'FR'): 5.5,
    ('NL', 9.0, 'GR'): 13.0,
    ('NL', 9.0, 'HR'): 5.0,
    ('NL', 9.0, 'HU'): 5.0,
    ('NL', 9.0, 'IE'): 13.5,
    ('NL', 9.0, 'IT'): 4.0,
    ('NL', 9.0, 'LT'): 5.0,
    ('NL', 9.0, 'LU'): 8.0,
    ('NL', 9.0, 'LV'): 12.0,
    ('NL', 9.0, 'MT'): 5.0,
    ('NL', 9.0, 'PL'): 8.0,
    ('NL', 9.0, 'PT'): 6.0,
    ('NL', 9.0, 'RO'): 11.0,
    ('NL', 9.0, 'SE'): 6.0,
    ('NL', 9.0, 'SI'): 9.5,
    ('NL', 9.0, 'SK'): 19.0,
    ('PL', 23.0, 'AT'): 20.0,
    ('PL', 23.0, 'BE'): 21.0,
    ('PL', 23.0, 'BG'): 20.0,
    ('PL', 23.0, 'CY'): 19.0,
    ('PL', 23.0, 'CZ'): 21.0,
    ('PL', 23.0, 'DE'): 19.0,
    ('PL', 23.0, 'DK'): 25.0,
    ('PL', 23.0, 'EE'): 22.0,
    ('PL', 23.0, 'ES'): 21.0,
    ('PL', 23.0, 'FI'): 25.5,
    ('PL', 23.0, 'FR'): 20.0,
    ('PL', 23.0, 'GR'): 24.0,
    ('PL', 23.0, 'HR'): 25.0,
    ('PL', 23.0, 'HU'): 27.0,
    ('PL', 23.0, 'IE'): 23.0,
    ('PL', 23.0, 'IT'): 22.0,
    ('PL', 23.0, 'LT'): 21.0,
    ('PL', 23.0, 'LU'): 17.0,
    ('PL', 23.0, 'LV'): 21.0,
    ('PL', 23.0, 'MT'): 18.0,
    ('PL', 23.0, 'NL'): 21.0,
    ('PL', 23.0, 'PT'): 23.0,
    ('PL', 23.0, 'RO'): 21.0,
    ('PL', 23.0, 'SE'): 25.0,
    ('PL', 23.0, 'SI'): 22.0,
    ('PL', 23.0, 'SK'): 23.0,
    ('PL', 5.0, 'AT'): 10.0,
    ('PL', 5.0, 'BE'): 6.0,
    ('PL', 5.0, 'BG'): 20.0,
    ('PL', 5.0, 'CY'): 5.0,
    ('PL', 5.0, 'CZ'): 12.0,
    ('PL', 5.0, 'DE'): 7.0,
    ('PL', 5.0, 'DK'): 25.0,
    ('PL', 5.0, 'EE'): 9.0,
    ('PL', 5.0, 'ES'): 10.0,
    ('PL', 5.0, 'FI'): 10.0,
    ('PL', 5.0, 'FR'): 5.5,
    ('PL', 5.0, 'GR'): 13.0,
    ('PL', 5.0, 'HR'): 5.0,
    ('PL', 5.0, 'HU'): 5.0,
    ('PL', 5.0, 'IE'): 13.5,
    ('PL', 5.0, 'IT'): 4.0,
    ('PL', 5.0, 'LT'): 5.0,
    ('PL', 5.0, 'LU'): 8.0,
    ('PL', 5.0, 'LV'): 12.0,
    ('PL', 5.0, 'MT'): 5.0,
    ('PL', 5.0, 'NL'): 9.0,
    ('PL', 5.0, 'PT'): 6.0,
    ('PL', 5.0, 'RO'): 11.0,
    ('PL', 5.0, 'SE'): 6.0,
    ('PL', 5.0, 'SI'): 9.5,
    ('PL', 5.0, 'SK'): 19.0,
    ('PL', 8.0, 'AT'): 10.0,
    ('PL', 8.0, 'BE'): 6.0,
    ('PL', 8.0, 'BG'): 20.0,
    ('PL', 8.0, 'CY'): 5.0,
    ('PL', 8.0, 'CZ'): 12.0,
    ('PL', 8.0, 'DE'): 7.0,
    ('PL', 8.0, 'DK'): 25.0,
    ('PL', 8.0, 'EE'): 9.0,
    ('PL', 8.0, 'ES'): 10.0,
    ('PL', 8.0, 'FI'): 10.0,
    ('PL', 8.0, 'FR'): 5.5,
    ('PL', 8.0, 'GR'): 13.0,
    ('PL', 8.0, 'HR'): 5.0,
    ('PL', 8.0, 'HU'): 5.0,
    ('PL', 8.0, 'IE'): 13.5,
    ('PL', 8.0, 'IT'): 10.0,
    ('PL', 8.0, 'LT'): 5.0,
    ('PL', 8.0, 'LU'): 8.0,
    ('PL', 8.0, 'LV'): 12.0,
    ('PL', 8.0, 'MT'): 5.0,
    ('PL', 8.0, 'NL'): 9.0,
    ('PL', 8.0, 'PT'): 6.0,
    ('PL', 8.0, 'RO'): 11.0,
    ('PL', 8.0, 'SE'): 6.0,
    ('PL', 8.0, 'SI'): 9.5,
    ('PL', 8.0, 'SK'): 19.0,
    ('PT', 13.0, 'AT'): 20.0,
    ('PT', 13.0, 'BE'): 21.0,
    ('PT', 13.0, 'BG'): 20.0,
    ('PT', 13.0, 'CY'): 19.0,
    ('PT', 13.0, 'CZ'): 21.0,
    ('PT', 13.0, 'DE'): 19.0,
    ('PT', 13.0, 'DK'): 25.0,
    ('PT', 13.0, 'EE'): 22.0,
    ('PT', 13.0, 'ES'): 21.0,
    ('PT', 13.0, 'FI'): 25.5,
    ('PT', 13.0, 'FR'): 20.0,
    ('PT', 13.0, 'GR'): 24.0,
    ('PT', 13.0, 'HR'): 25.0,
    ('PT', 13.0, 'HU'): 27.0,
    ('PT', 13.0, 'IE'): 23.0,
    ('PT', 13.0, 'IT'): 22.0,
    ('PT', 13.0, 'LT'): 21.0,
    ('PT', 13.0, 'LU'): 17.0,
    ('PT', 13.0, 'LV'): 21.0,
    ('PT', 13.0, 'MT'): 18.0,
    ('PT', 13.0, 'NL'): 21.0,
    ('PT', 13.0, 'PL'): 23.0,
    ('PT', 13.0, 'RO'): 21.0,
    ('PT', 13.0, 'SE'): 18.0,
    ('PT', 13.0, 'SI'): 21.0,
    ('PT', 13.0, 'SK'): 23.0,
    ('PT', 23.0, 'AT'): 20.0,
    ('PT', 23.0, 'BE'): 21.0,
    ('PT', 23.0, 'BG'): 20.0,
    ('PT', 23.0, 'CY'): 19.0,
    ('PT', 23.0, 'CZ'): 21.0,
    ('PT', 23.0, 'DE'): 19.0,
    ('PT', 23.0, 'DK'): 25.0,
    ('PT', 23.0, 'EE'): 22.0,
    ('PT', 23.0, 'ES'): 21.0,
    ('PT', 23.0, 'FI'): 25.5,
    ('PT', 23.0, 'FR'): 20.0,
    ('PT', 23.0, 'GR'): 24.0,
    ('PT', 23.0, 'HR'): 25.0,
    ('PT', 23.0, 'HU'): 27.0,
    ('PT', 23.0, 'IE'): 23.0,
    ('PT', 23.0, 'IT'): 22.0,
    ('PT', 23.0, 'LT'): 21.0,
    ('PT', 23.0, 'LU'): 17.0,
    ('PT', 23.0, 'LV'): 21.0,
    ('PT', 23.0, 'MT'): 18.0,
    ('PT', 23.0, 'NL'): 21.0,
    ('PT', 23.0, 'PL'): 23.0,
    ('PT', 23.0, 'RO'): 21.0,
    ('PT', 23.0, 'SE'): 25.0,
    ('PT', 23.0, 'SI'): 22.0,
    ('PT', 23.0, 'SK'): 23.0,
    ('PT', 6.0, 'AT'): 10.0,
    ('PT', 6.0, 'BE'): 6.0,
    ('PT', 6.0, 'BG'): 20.0,
    ('PT', 6.0, 'CY'): 5.0,
    ('PT', 6.0, 'CZ'): 12.0,
    ('PT', 6.0, 'DE'): 7.0,
    ('PT', 6.0, 'DK'): 25.0,
    ('PT', 6.0, 'EE'): 9.0,
    ('PT', 6.0, 'ES'): 10.0,
    ('PT', 6.0, 'FI'): 10.0,
    ('PT', 6.0, 'FR'): 5.5,
    ('PT', 6.0, 'GR'): 13.0,
    ('PT', 6.0, 'HR'): 5.0,
    ('PT', 6.0, 'HU'): 5.0,
    ('PT', 6.0, 'IE'): 13.5,
    ('PT', 6.0, 'IT'): 4.0,
    ('PT', 6.0, 'LT'): 5.0,
    ('PT', 6.0, 'LU'): 8.0,
    ('PT', 6.0, 'LV'): 12.0,
    ('PT', 6.0, 'MT'): 5.0,
    ('PT', 6.0, 'NL'): 9.0,
    ('PT', 6.0, 'PL'): 8.0,
    ('PT', 6.0, 'RO'): 11.0,
    ('PT', 6.0, 'SE'): 6.0,
    ('PT', 6.0, 'SI'): 9.5,
    ('PT', 6.0, 'SK'): 19.0,
    ('RO', 21.0, 'AT'): 20.0,
    ('RO', 21.0, 'BE'): 21.0,
    ('RO', 21.0, 'BG'): 20.0,
    ('RO', 21.0, 'CY'): 19.0,
    ('RO', 21.0, 'CZ'): 21.0,
    ('RO', 21.0, 'DE'): 19.0,
    ('RO', 21.0, 'DK'): 25.0,
    ('RO', 21.0, 'EE'): 22.0,
    ('RO', 21.0, 'ES'): 21.0,
    ('RO', 21.0, 'FI'): 25.5,
    ('RO', 21.0, 'FR'): 20.0,
    ('RO', 21.0, 'GR'): 24.0,
    ('RO', 21.0, 'HR'): 25.0,
    ('RO', 21.0, 'HU'): 27.0,
    ('RO', 21.0, 'IE'): 23.0,
    ('RO', 21.0, 'IT'): 22.0,
    ('RO', 21.0, 'LT'): 21.0,
    ('RO', 21.0, 'LU'): 17.0,
    ('RO', 21.0, 'LV'): 21.0,
    ('RO', 21.0, 'MT'): 18.0,
    ('RO', 21.0, 'NL'): 21.0,
    ('RO', 21.0, 'PL'): 23.0,
    ('RO', 21.0, 'PT'): 23.0,
    ('RO', 21.0, 'SE'): 25.0,
    ('RO', 21.0, 'SI'): 22.0,
    ('RO', 21.0, 'SK'): 23.0,
    ('RO', 11.0, 'AT'): 10.0,
    ('RO', 11.0, 'BE'): 6.0,
    ('RO', 11.0, 'BG'): 20.0,
    ('RO', 11.0, 'CY'): 5.0,
    ('RO', 11.0, 'CZ'): 12.0,
    ('RO', 11.0, 'DE'): 7.0,
    ('RO', 11.0, 'DK'): 25.0,
    ('RO', 11.0, 'EE'): 9.0,
    ('RO', 11.0, 'ES'): 10.0,
    ('RO', 11.0, 'FI'): 10.0,
    ('RO', 11.0, 'FR'): 5.5,
    ('RO', 11.0, 'GR'): 13.0,
    ('RO', 11.0, 'HR'): 13.0,
    ('RO', 11.0, 'HU'): 5.0,
    ('RO', 11.0, 'IE'): 13.5,
    ('RO', 11.0, 'IT'): 10.0,
    ('RO', 11.0, 'LT'): 5.0,
    ('RO', 11.0, 'LU'): 8.0,
    ('RO', 11.0, 'LV'): 12.0,
    ('RO', 11.0, 'MT'): 5.0,
    ('RO', 11.0, 'NL'): 9.0,
    ('RO', 11.0, 'PL'): 8.0,
    ('RO', 11.0, 'PT'): 6.0,
    ('RO', 11.0, 'SE'): 6.0,
    ('RO', 11.0, 'SI'): 9.5,
    ('RO', 11.0, 'SK'): 19.0,
    ('SE', 12.0, 'AT'): 10.0,
    ('SE', 12.0, 'BE'): 6.0,
    ('SE', 12.0, 'BG'): 20.0,
    ('SE', 12.0, 'CY'): 5.0,
    ('SE', 12.0, 'CZ'): 12.0,
    ('SE', 12.0, 'DE'): 7.0,
    ('SE', 12.0, 'DK'): 25.0,
    ('SE', 12.0, 'EE'): 9.0,
    ('SE', 12.0, 'ES'): 10.0,
    ('SE', 12.0, 'FI'): 10.0,
    ('SE', 12.0, 'FR'): 5.5,
    ('SE', 12.0, 'GR'): 13.0,
    ('SE', 12.0, 'HR'): 13.0,
    ('SE', 12.0, 'HU'): 5.0,
    ('SE', 12.0, 'IE'): 13.5,
    ('SE', 12.0, 'IT'): 10.0,
    ('SE', 12.0, 'LT'): 5.0,
    ('SE', 12.0, 'LU'): 8.0,
    ('SE', 12.0, 'LV'): 12.0,
    ('SE', 12.0, 'MT'): 5.0,
    ('SE', 12.0, 'NL'): 9.0,
    ('SE', 12.0, 'PL'): 8.0,
    ('SE', 12.0, 'PT'): 6.0,
    ('SE', 12.0, 'RO'): 11.0,
    ('SE', 12.0, 'SI'): 9.5,
    ('SE', 12.0, 'SK'): 19.0,
    ('SE', 25.0, 'AT'): 20.0,
    ('SE', 25.0, 'BE'): 21.0,
    ('SE', 25.0, 'BG'): 20.0,
    ('SE', 25.0, 'CY'): 19.0,
    ('SE', 25.0, 'CZ'): 21.0,
    ('SE', 25.0, 'DE'): 19.0,
    ('SE', 25.0, 'DK'): 25.0,
    ('SE', 25.0, 'EE'): 22.0,
    ('SE', 25.0, 'ES'): 21.0,
    ('SE', 25.0, 'FI'): 25.5,
    ('SE', 25.0, 'FR'): 20.0,
    ('SE', 25.0, 'GR'): 24.0,
    ('SE', 25.0, 'HR'): 25.0,
    ('SE', 25.0, 'HU'): 27.0,
    ('SE', 25.0, 'IE'): 23.0,
    ('SE', 25.0, 'IT'): 22.0,
    ('SE', 25.0, 'LT'): 21.0,
    ('SE', 25.0, 'LU'): 17.0,
    ('SE', 25.0, 'LV'): 21.0,
    ('SE', 25.0, 'MT'): 18.0,
    ('SE', 25.0, 'NL'): 21.0,
    ('SE', 25.0, 'PL'): 23.0,
    ('SE', 25.0, 'PT'): 23.0,
    ('SE', 25.0, 'RO'): 21.0,
    ('SE', 25.0, 'SI'): 22.0,
    ('SE', 25.0, 'SK'): 23.0,
    ('SE', 6.0, 'AT'): 10.0,
    ('SE', 6.0, 'BE'): 6.0,
    ('SE', 6.0, 'BG'): 20.0,
    ('SE', 6.0, 'CY'): 5.0,
    ('SE', 6.0, 'CZ'): 12.0,
    ('SE', 6.0, 'DE'): 7.0,
    ('SE', 6.0, 'DK'): 25.0,
    ('SE', 6.0, 'EE'): 9.0,
    ('SE', 6.0, 'ES'): 10.0,
    ('SE', 6.0, 'FI'): 10.0,
    ('SE', 6.0, 'FR'): 5.5,
    ('SE', 6.0, 'GR'): 13.0,
    ('SE', 6.0, 'HR'): 5.0,
    ('SE', 6.0, 'HU'): 5.0,
    ('SE', 6.0, 'IE'): 13.5,
    ('SE', 6.0, 'IT'): 4.0,
    ('SE', 6.0, 'LT'): 5.0,
    ('SE', 6.0, 'LU'): 8.0,
    ('SE', 6.0, 'LV'): 12.0,
    ('SE', 6.0, 'MT'): 5.0,
    ('SE', 6.0, 'NL'): 9.0,
    ('SE', 6.0, 'PL'): 8.0,
    ('SE', 6.0, 'PT'): 6.0,
    ('SE', 6.0, 'RO'): 11.0,
    ('SE', 6.0, 'SI'): 9.5,
    ('SE', 6.0, 'SK'): 19.0,
    ('SI', 22.0, 'AT'): 20.0,
    ('SI', 22.0, 'BE'): 21.0,
    ('SI', 22.0, 'BG'): 20.0,
    ('SI', 22.0, 'CY'): 19.0,
    ('SI', 22.0, 'CZ'): 21.0,
    ('SI', 22.0, 'DE'): 19.0,
    ('SI', 22.0, 'DK'): 25.0,
    ('SI', 22.0, 'EE'): 22.0,
    ('SI', 22.0, 'ES'): 21.0,
    ('SI', 22.0, 'FI'): 25.5,
    ('SI', 22.0, 'FR'): 20.0,
    ('SI', 22.0, 'GR'): 24.0,
    ('SI', 22.0, 'HR'): 25.0,
    ('SI', 22.0, 'HU'): 27.0,
    ('SI', 22.0, 'IE'): 23.0,
    ('SI', 22.0, 'IT'): 22.0,
    ('SI', 22.0, 'LT'): 21.0,
    ('SI', 22.0, 'LU'): 17.0,
    ('SI', 22.0, 'LV'): 21.0,
    ('SI', 22.0, 'MT'): 18.0,
    ('SI', 22.0, 'NL'): 21.0,
    ('SI', 22.0, 'PL'): 23.0,
    ('SI', 22.0, 'PT'): 23.0,
    ('SI', 22.0, 'RO'): 21.0,
    ('SI', 22.0, 'SE'): 25.0,
    ('SI', 22.0, 'SK'): 23.0,
    ('SI', 5.0, 'AT'): 10.0,
    ('SI', 5.0, 'BE'): 6.0,
    ('SI', 5.0, 'BG'): 20.0,
    ('SI', 5.0, 'CY'): 5.0,
    ('SI', 5.0, 'CZ'): 12.0,
    ('SI', 5.0, 'DE'): 7.0,
    ('SI', 5.0, 'DK'): 25.0,
    ('SI', 5.0, 'EE'): 9.0,
    ('SI', 5.0, 'ES'): 10.0,
    ('SI', 5.0, 'FI'): 10.0,
    ('SI', 5.0, 'FR'): 5.5,
    ('SI', 5.0, 'GR'): 13.0,
    ('SI', 5.0, 'HR'): 5.0,
    ('SI', 5.0, 'HU'): 5.0,
    ('SI', 5.0, 'IE'): 13.5,
    ('SI', 5.0, 'IT'): 4.0,
    ('SI', 5.0, 'LT'): 5.0,
    ('SI', 5.0, 'LU'): 8.0,
    ('SI', 5.0, 'LV'): 12.0,
    ('SI', 5.0, 'MT'): 5.0,
    ('SI', 5.0, 'NL'): 9.0,
    ('SI', 5.0, 'PL'): 8.0,
    ('SI', 5.0, 'PT'): 6.0,
    ('SI', 5.0, 'RO'): 11.0,
    ('SI', 5.0, 'SE'): 6.0,
    ('SI', 5.0, 'SK'): 19.0,
    ('SI', 9.5, 'AT'): 10.0,
    ('SI', 9.5, 'BE'): 6.0,
    ('SI', 9.5, 'BG'): 20.0,
    ('SI', 9.5, 'CY'): 5.0,
    ('SI', 9.5, 'CZ'): 12.0,
    ('SI', 9.5, 'DE'): 7.0,
    ('SI', 9.5, 'DK'): 25.0,
    ('SI', 9.5, 'EE'): 9.0,
    ('SI', 9.5, 'ES'): 10.0,
    ('SI', 9.5, 'FI'): 10.0,
    ('SI', 9.5, 'FR'): 5.5,
    ('SI', 9.5, 'GR'): 13.0,
    ('SI', 9.5, 'HR'): 13.0,
    ('SI', 9.5, 'HU'): 5.0,
    ('SI', 9.5, 'IE'): 13.5,
    ('SI', 9.5, 'IT'): 10.0,
    ('SI', 9.5, 'LT'): 5.0,
    ('SI', 9.5, 'LU'): 8.0,
    ('SI', 9.5, 'LV'): 12.0,
    ('SI', 9.5, 'MT'): 5.0,
    ('SI', 9.5, 'NL'): 9.0,
    ('SI', 9.5, 'PL'): 8.0,
    ('SI', 9.5, 'PT'): 6.0,
    ('SI', 9.5, 'RO'): 11.0,
    ('SI', 9.5, 'SE'): 6.0,
    ('SI', 9.5, 'SK'): 19.0,
    ('SK', 10.0, 'AT'): 10.0,
    ('SK', 10.0, 'BE'): 6.0,
    ('SK', 10.0, 'BG'): 20.0,
    ('SK', 10.0, 'CY'): 5.0,
    ('SK', 10.0, 'CZ'): 12.0,
    ('SK', 10.0, 'DE'): 7.0,
    ('SK', 10.0, 'DK'): 25.0,
    ('SK', 10.0, 'EE'): 9.0,
    ('SK', 10.0, 'ES'): 10.0,
    ('SK', 10.0, 'FI'): 10.0,
    ('SK', 10.0, 'FR'): 5.5,
    ('SK', 10.0, 'GR'): 13.0,
    ('SK', 10.0, 'HR'): 5.0,
    ('SK', 10.0, 'HU'): 5.0,
    ('SK', 10.0, 'IE'): 13.5,
    ('SK', 10.0, 'IT'): 4.0,
    ('SK', 10.0, 'LT'): 5.0,
    ('SK', 10.0, 'LU'): 8.0,
    ('SK', 10.0, 'LV'): 12.0,
    ('SK', 10.0, 'MT'): 5.0,
    ('SK', 10.0, 'NL'): 9.0,
    ('SK', 10.0, 'PL'): 8.0,
    ('SK', 10.0, 'PT'): 6.0,
    ('SK', 10.0, 'RO'): 11.0,
    ('SK', 10.0, 'SE'): 6.0,
    ('SK', 10.0, 'SI'): 9.5,
    ('SK', 20.0, 'AT'): 20.0,
    ('SK', 20.0, 'BE'): 21.0,
    ('SK', 20.0, 'BG'): 20.0,
    ('SK', 20.0, 'CY'): 19.0,
    ('SK', 20.0, 'CZ'): 21.0,
    ('SK', 20.0, 'DE'): 19.0,
    ('SK', 20.0, 'DK'): 25.0,
    ('SK', 20.0, 'EE'): 22.0,
    ('SK', 20.0, 'ES'): 21.0,
    ('SK', 20.0, 'FI'): 25.5,
    ('SK', 20.0, 'FR'): 20.0,
    ('SK', 20.0, 'GR'): 24.0,
    ('SK', 20.0, 'HR'): 25.0,
    ('SK', 20.0, 'HU'): 27.0,
    ('SK', 20.0, 'IE'): 23.0,
    ('SK', 20.0, 'IT'): 22.0,
    ('SK', 20.0, 'LT'): 21.0,
    ('SK', 20.0, 'LU'): 17.0,
    ('SK', 20.0, 'LV'): 21.0,
    ('SK', 20.0, 'MT'): 18.0,
    ('SK', 20.0, 'NL'): 21.0,
    ('SK', 20.0, 'PL'): 23.0,
    ('SK', 20.0, 'PT'): 23.0,
    ('SK', 20.0, 'RO'): 21.0,
    ('SK', 20.0, 'SE'): 25.0,
    ('SK', 20.0, 'SI'): 22.0,
    ('SK', 19.0, 'AT'): 10.0,
    ('SK', 19.0, 'BE'): 6.0,
    ('SK', 19.0, 'BG'): 20.0,
    ('SK', 19.0, 'CY'): 5.0,
    ('SK', 19.0, 'CZ'): 12.0,
    ('SK', 19.0, 'DE'): 7.0,
    ('SK', 19.0, 'DK'): 25.0,
    ('SK', 19.0, 'EE'): 9.0,
    ('SK', 19.0, 'ES'): 10.0,
    ('SK', 19.0, 'FI'): 10.0,
    ('SK', 19.0, 'FR'): 5.5,
    ('SK', 19.0, 'GR'): 13.0,
    ('SK', 19.0, 'HR'): 5.0,
    ('SK', 19.0, 'HU'): 5.0,
    ('SK', 19.0, 'IE'): 13.5,
    ('SK', 19.0, 'IT'): 4.0,
    ('SK', 19.0, 'LT'): 5.0,
    ('SK', 19.0, 'LU'): 8.0,
    ('SK', 19.0, 'LV'): 12.0,
    ('SK', 19.0, 'MT'): 5.0,
    ('SK', 19.0, 'NL'): 9.0,
    ('SK', 19.0, 'PL'): 8.0,
    ('SK', 19.0, 'PT'): 6.0,
    ('SK', 19.0, 'RO'): 11.0,
    ('SK', 19.0, 'SE'): 6.0,
    ('SK', 19.0, 'SI'): 9.5,
    ('SK', 23.0, 'AT'): 20.0,
    ('SK', 23.0, 'BE'): 21.0,
    ('SK', 23.0, 'BG'): 20.0,
    ('SK', 23.0, 'CY'): 19.0,
    ('SK', 23.0, 'CZ'): 21.0,
    ('SK', 23.0, 'DE'): 19.0,
    ('SK', 23.0, 'DK'): 25.0,
    ('SK', 23.0, 'EE'): 22.0,
    ('SK', 23.0, 'ES'): 21.0,
    ('SK', 23.0, 'FI'): 25.5,
    ('SK', 23.0, 'FR'): 20.0,
    ('SK', 23.0, 'GR'): 24.0,
    ('SK', 23.0, 'HR'): 25.0,
    ('SK', 23.0, 'HU'): 27.0,
    ('SK', 23.0, 'IE'): 23.0,
    ('SK', 23.0, 'IT'): 22.0,
    ('SK', 23.0, 'LT'): 21.0,
    ('SK', 23.0, 'LU'): 17.0,
    ('SK', 23.0, 'LV'): 21.0,
    ('SK', 23.0, 'MT'): 18.0,
    ('SK', 23.0, 'NL'): 21.0,
    ('SK', 23.0, 'PL'): 23.0,
    ('SK', 23.0, 'PT'): 23.0,
    ('SK', 23.0, 'RO'): 21.0,
    ('SK', 23.0, 'SE'): 25.0,
    ('SK', 23.0, 'SI'): 22.0,
    ('GB', 20.0, 'AT'): 20.0,
    ('GB', 20.0, 'BE'): 21.0,
    ('GB', 20.0, 'BG'): 20.0,
    ('GB', 20.0, 'CY'): 19.0,
    ('GB', 20.0, 'CZ'): 21.0,
    ('GB', 20.0, 'DE'): 19.0,
    ('GB', 20.0, 'DK'): 25.0,
    ('GB', 20.0, 'EE'): 22.0,
    ('GB', 20.0, 'ES'): 21.0,
    ('GB', 20.0, 'FI'): 24.0,
    ('GB', 20.0, 'FR'): 20.0,
    ('GB', 20.0, 'GR'): 24.0,
    ('GB', 20.0, 'HR'): 25.0,
    ('GB', 20.0, 'HU'): 27.0,
    ('GB', 20.0, 'IE'): 23.0,
    ('GB', 20.0, 'IT'): 22.0,
    ('GB', 20.0, 'LT'): 21.0,
    ('GB', 20.0, 'LU'): 16.0,
    ('GB', 20.0, 'LV'): 21.0,
    ('GB', 20.0, 'MT'): 18.0,
    ('GB', 20.0, 'NL'): 21.0,
    ('GB', 20.0, 'PL'): 23.0,
    ('GB', 20.0, 'PT'): 23.0,
    ('GB', 20.0, 'RO'): 21.0,
    ('GB', 20.0, 'SE'): 25.0,
    ('GB', 20.0, 'SI'): 22.0,
    ('GB', 20.0, 'SK'): 23.0,
    ('CH', 8.1, 'AT'): 20.0,
    ('CH', 8.1, 'BE'): 21.0,
    ('CH', 8.1, 'BG'): 20.0,
    ('CH', 8.1, 'CY'): 19.0,
    ('CH', 8.1, 'CZ'): 21.0,
    ('CH', 8.1, 'DE'): 19.0,
    ('CH', 8.1, 'DK'): 25.0,
    ('CH', 8.1, 'EE'): 24.0,
    ('CH', 8.1, 'ES'): 21.0,
    ('CH', 8.1, 'FI'): 25.5,
    ('CH', 8.1, 'FR'): 20.0,
    ('CH', 8.1, 'GR'): 24.0,
    ('CH', 8.1, 'HR'): 25.0,
    ('CH', 8.1, 'HU'): 27.0,
    ('CH', 8.1, 'IE'): 23.0,
    ('CH', 8.1, 'IT'): 22.0,
    ('CH', 8.1, 'LT'): 21.0,
    ('CH', 8.1, 'LU'): 17.0,
    ('CH', 8.1, 'LV'): 21.0,
    ('CH', 8.1, 'MT'): 18.0,
    ('CH', 8.1, 'NL'): 21.0,
    ('CH', 8.1, 'PL'): 23.0,
    ('CH', 8.1, 'PT'): 23.0,
    ('CH', 8.1, 'RO'): 21.0,
    ('CH', 8.1, 'SE'): 25.0,
    ('CH', 8.1, 'SI'): 22.0,
    ('CH', 8.1, 'SK'): 23.0,
}
